package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanfracsipca;

/**
 * SanfracsipcaDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class SanfracsipcaDaoImpl implements SanfracsipcaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Sanfracsipca> rwMap = new RowMapper<Sanfracsipca>() {
		public Sanfracsipca mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Sanfracsipca(
               resultSet.getLong("LFID"), resultSet.getString("LFTIPREG"), resultSet.getString("LFTIPOP"), resultSet.getString("LFENTEM"), resultSet.getString("LFSUFIJO"), resultSet.getString("LFNUMREF"), resultSet.getString("LFDIGCON"), resultSet.getDate("LFFECLIMPA"), resultSet.getString("LFIMPORTE"), resultSet.getDate("LFFECOPER"), resultSet.getDate("LFFECSOLIC"), resultSet.getString("LFTIPTER"), resultSet.getString("LFCIF"), resultSet.getString("LFNOMBRE"), resultSet.getString("LFAPE1"), resultSet.getString("LFAPE2"), resultSet.getString("LFTEL"), resultSet.getString("LFFAX"), resultSet.getString("LFEMAIL"), resultSet.getString("LFSIGL"), resultSet.getString("LFVIAPU"), resultSet.getString("LFPORTAL"), resultSet.getString("LFLETRA"), resultSet.getString("LFESCAL"), resultSet.getString("LFPISO"), resultSet.getString("LFPUERTA"), resultSet.getString("LFCODPROV"), resultSet.getString("LFCODMUN"), resultSet.getString("LFCODLOC"), resultSet.getString("LFCODPOS"), resultSet.getString("LFCODCAU"), resultSet.getString("LFMOTCAU"), resultSet.getString("LFPROPAG"), resultSet.getString("LFMOTPRO"), resultSet.getString("LFCUENTA"), resultSet.getString("LFEXGARA"), resultSet.getString("LFTIPGARA"), resultSet.getDate("LFFECDEP"), resultSet.getDate("LFFECAPORAV"), resultSet.getString("LFINDICSUF"), resultSet.getDate("LFFECNOTIF"), resultSet.getDate("LFFECINFORM"), resultSet.getDate("LFFECRESOL"), resultSet.getString("LFESTIMRESOL"), resultSet.getString("LFMOTRES"), resultSet.getString("LFNUMPL"), resultSet.getString("LFFRECPL"), resultSet.getDate("LFFECLIM1PA"), resultSet.getString("LFPORCDEM"), resultSet.getString("LFTIPPAG"), resultSet.getString("LFTIPNOT"), resultSet.getDate("LFFECNOTRESOL"), resultSet.getDate("LFFECINVAL"), resultSet.getString("LFTIPINVAL"), resultSet.getString("LFMOTINVAL"), resultSet.getDate("LFFECALC"), resultSet.getString("LFIMPPDTE"), resultSet.getString("LFIMPINT"), resultSet.getString("LFORGRESP"), resultSet.getString("LFNUMEXP"), resultSet.getDate("LFFECENV3"), resultSet.getDate("LFFECENVCEN"), resultSet.getDate("LFFECLIMPAGVOL"), resultSet.getString("LFIBAN"), resultSet.getString("LFESTADO"), resultSet.getDate("LFFECALTA"), resultSet.getDate("LFFECMODIF"), resultSet.getString("LFUSUALTA"), resultSet.getString("LFUSUMODIF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Pagination
     * @return Sanfracsipca
     */
	public Sanfracsipca add(Sanfracsipca sanfracsipca) {
    	String query = "INSERT INTO SANFRACSIPCA (LFID, LFTIPREG, LFTIPOP, LFENTEM, LFSUFIJO, LFNUMREF, LFDIGCON, LFFECLIMPA, LFIMPORTE, LFFECOPER, LFFECSOLIC, LFTIPTER, LFCIF, LFNOMBRE, LFAPE1, LFAPE2, LFTEL, LFFAX, LFEMAIL, LFSIGL, LFVIAPU, LFPORTAL, LFLETRA, LFESCAL, LFPISO, LFPUERTA, LFCODPROV, LFCODMUN, LFCODLOC, LFCODPOS, LFCODCAU, LFMOTCAU, LFPROPAG, LFMOTPRO, LFCUENTA, LFEXGARA, LFTIPGARA, LFFECDEP, LFFECAPORAV, LFINDICSUF, LFFECNOTIF, LFFECINFORM, LFFECRESOL, LFESTIMRESOL, LFMOTRES, LFNUMPL, LFFRECPL, LFFECLIM1PA, LFPORCDEM, LFTIPPAG, LFTIPNOT, LFFECNOTRESOL, LFFECINVAL, LFTIPINVAL, LFMOTINVAL, LFFECALC, LFIMPPDTE, LFIMPINT, LFORGRESP, LFNUMEXP, LFFECENV3, LFFECENVCEN, LFFECLIMPAGVOL, LFIBAN, LFESTADO, LFFECALTA, LFFECMODIF, LFUSUALTA, LFUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sanfracsipca.getLfid(), sanfracsipca.getLftipreg(), sanfracsipca.getLftipop(), sanfracsipca.getLfentem(), sanfracsipca.getLfsufijo(), sanfracsipca.getLfnumref(), sanfracsipca.getLfdigcon(), sanfracsipca.getLffeclimpa(), sanfracsipca.getLfimporte(), sanfracsipca.getLffecoper(), sanfracsipca.getLffecsolic(), sanfracsipca.getLftipter(), sanfracsipca.getLfcif(), sanfracsipca.getLfnombre(), sanfracsipca.getLfape1(), sanfracsipca.getLfape2(), sanfracsipca.getLftel(), sanfracsipca.getLffax(), sanfracsipca.getLfemail(), sanfracsipca.getLfsigl(), sanfracsipca.getLfviapu(), sanfracsipca.getLfportal(), sanfracsipca.getLfletra(), sanfracsipca.getLfescal(), sanfracsipca.getLfpiso(), sanfracsipca.getLfpuerta(), sanfracsipca.getLfcodprov(), sanfracsipca.getLfcodmun(), sanfracsipca.getLfcodloc(), sanfracsipca.getLfcodpos(), sanfracsipca.getLfcodcau(), sanfracsipca.getLfmotcau(), sanfracsipca.getLfpropag(), sanfracsipca.getLfmotpro(), sanfracsipca.getLfcuenta(), sanfracsipca.getLfexgara(), sanfracsipca.getLftipgara(), sanfracsipca.getLffecdep(), sanfracsipca.getLffecaporav(), sanfracsipca.getLfindicsuf(), sanfracsipca.getLffecnotif(), sanfracsipca.getLffecinform(), sanfracsipca.getLffecresol(), sanfracsipca.getLfestimresol(), sanfracsipca.getLfmotres(), sanfracsipca.getLfnumpl(), sanfracsipca.getLffrecpl(), sanfracsipca.getLffeclim1pa(), sanfracsipca.getLfporcdem(), sanfracsipca.getLftippag(), sanfracsipca.getLftipnot(), sanfracsipca.getLffecnotresol(), sanfracsipca.getLffecinval(), sanfracsipca.getLftipinval(), sanfracsipca.getLfmotinval(), sanfracsipca.getLffecalc(), sanfracsipca.getLfimppdte(), sanfracsipca.getLfimpint(), sanfracsipca.getLforgresp(), sanfracsipca.getLfnumexp(), sanfracsipca.getLffecenv3(), sanfracsipca.getLffecenvcen(), sanfracsipca.getLffeclimpagvol(), sanfracsipca.getLfiban(), sanfracsipca.getLfestado(), sanfracsipca.getLffecalta(), sanfracsipca.getLffecmodif(), sanfracsipca.getLfusualta(), sanfracsipca.getLfusumodif());
		return sanfracsipca;
	}

    /**
     * Updates a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Pagination
     * @return Sanfracsipca
     */
    public Sanfracsipca update(Sanfracsipca sanfracsipca) {
		String query = "UPDATE SANFRACSIPCA SET  WHERE LFID=? AND LFTIPREG=? AND LFTIPOP=? AND LFENTEM=? AND LFSUFIJO=? AND LFNUMREF=? AND LFDIGCON=? AND LFFECLIMPA=? AND LFIMPORTE=? AND LFFECOPER=? AND LFFECSOLIC=? AND LFTIPTER=? AND LFCIF=? AND LFNOMBRE=? AND LFAPE1=? AND LFAPE2=? AND LFTEL=? AND LFFAX=? AND LFEMAIL=? AND LFSIGL=? AND LFVIAPU=? AND LFPORTAL=? AND LFLETRA=? AND LFESCAL=? AND LFPISO=? AND LFPUERTA=? AND LFCODPROV=? AND LFCODMUN=? AND LFCODLOC=? AND LFCODPOS=? AND LFCODCAU=? AND LFMOTCAU=? AND LFPROPAG=? AND LFMOTPRO=? AND LFCUENTA=? AND LFEXGARA=? AND LFTIPGARA=? AND LFFECDEP=? AND LFFECAPORAV=? AND LFINDICSUF=? AND LFFECNOTIF=? AND LFFECINFORM=? AND LFFECRESOL=? AND LFESTIMRESOL=? AND LFMOTRES=? AND LFNUMPL=? AND LFFRECPL=? AND LFFECLIM1PA=? AND LFPORCDEM=? AND LFTIPPAG=? AND LFTIPNOT=? AND LFFECNOTRESOL=? AND LFFECINVAL=? AND LFTIPINVAL=? AND LFMOTINVAL=? AND LFFECALC=? AND LFIMPPDTE=? AND LFIMPINT=? AND LFORGRESP=? AND LFNUMEXP=? AND LFFECENV3=? AND LFFECENVCEN=? AND LFFECLIMPAGVOL=? AND LFIBAN=? AND LFESTADO=? AND LFFECALTA=? AND LFFECMODIF=? AND LFUSUALTA=? AND LFUSUMODIF=?";
		this.jdbcTemplate.update(query, sanfracsipca.getLfid(), sanfracsipca.getLftipreg(), sanfracsipca.getLftipop(), sanfracsipca.getLfentem(), sanfracsipca.getLfsufijo(), sanfracsipca.getLfnumref(), sanfracsipca.getLfdigcon(), sanfracsipca.getLffeclimpa(), sanfracsipca.getLfimporte(), sanfracsipca.getLffecoper(), sanfracsipca.getLffecsolic(), sanfracsipca.getLftipter(), sanfracsipca.getLfcif(), sanfracsipca.getLfnombre(), sanfracsipca.getLfape1(), sanfracsipca.getLfape2(), sanfracsipca.getLftel(), sanfracsipca.getLffax(), sanfracsipca.getLfemail(), sanfracsipca.getLfsigl(), sanfracsipca.getLfviapu(), sanfracsipca.getLfportal(), sanfracsipca.getLfletra(), sanfracsipca.getLfescal(), sanfracsipca.getLfpiso(), sanfracsipca.getLfpuerta(), sanfracsipca.getLfcodprov(), sanfracsipca.getLfcodmun(), sanfracsipca.getLfcodloc(), sanfracsipca.getLfcodpos(), sanfracsipca.getLfcodcau(), sanfracsipca.getLfmotcau(), sanfracsipca.getLfpropag(), sanfracsipca.getLfmotpro(), sanfracsipca.getLfcuenta(), sanfracsipca.getLfexgara(), sanfracsipca.getLftipgara(), sanfracsipca.getLffecdep(), sanfracsipca.getLffecaporav(), sanfracsipca.getLfindicsuf(), sanfracsipca.getLffecnotif(), sanfracsipca.getLffecinform(), sanfracsipca.getLffecresol(), sanfracsipca.getLfestimresol(), sanfracsipca.getLfmotres(), sanfracsipca.getLfnumpl(), sanfracsipca.getLffrecpl(), sanfracsipca.getLffeclim1pa(), sanfracsipca.getLfporcdem(), sanfracsipca.getLftippag(), sanfracsipca.getLftipnot(), sanfracsipca.getLffecnotresol(), sanfracsipca.getLffecinval(), sanfracsipca.getLftipinval(), sanfracsipca.getLfmotinval(), sanfracsipca.getLffecalc(), sanfracsipca.getLfimppdte(), sanfracsipca.getLfimpint(), sanfracsipca.getLforgresp(), sanfracsipca.getLfnumexp(), sanfracsipca.getLffecenv3(), sanfracsipca.getLffecenvcen(), sanfracsipca.getLffeclimpagvol(), sanfracsipca.getLfiban(), sanfracsipca.getLfestado(), sanfracsipca.getLffecalta(), sanfracsipca.getLffecmodif(), sanfracsipca.getLfusualta(), sanfracsipca.getLfusumodif());
		return sanfracsipca;
	}

    /**
     * Finds a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Pagination
     * @return Sanfracsipca
     */
    @Transactional (readOnly = true)
    public Sanfracsipca find(Sanfracsipca sanfracsipca) {
		String query = "SELECT t1.LFID LFID, t1.LFTIPREG LFTIPREG, t1.LFTIPOP LFTIPOP, t1.LFENTEM LFENTEM, t1.LFSUFIJO LFSUFIJO, t1.LFNUMREF LFNUMREF, t1.LFDIGCON LFDIGCON, t1.LFFECLIMPA LFFECLIMPA, t1.LFIMPORTE LFIMPORTE, t1.LFFECOPER LFFECOPER, t1.LFFECSOLIC LFFECSOLIC, t1.LFTIPTER LFTIPTER, t1.LFCIF LFCIF, t1.LFNOMBRE LFNOMBRE, t1.LFAPE1 LFAPE1, t1.LFAPE2 LFAPE2, t1.LFTEL LFTEL, t1.LFFAX LFFAX, t1.LFEMAIL LFEMAIL, t1.LFSIGL LFSIGL, t1.LFVIAPU LFVIAPU, t1.LFPORTAL LFPORTAL, t1.LFLETRA LFLETRA, t1.LFESCAL LFESCAL, t1.LFPISO LFPISO, t1.LFPUERTA LFPUERTA, t1.LFCODPROV LFCODPROV, t1.LFCODMUN LFCODMUN, t1.LFCODLOC LFCODLOC, t1.LFCODPOS LFCODPOS, t1.LFCODCAU LFCODCAU, t1.LFMOTCAU LFMOTCAU, t1.LFPROPAG LFPROPAG, t1.LFMOTPRO LFMOTPRO, t1.LFCUENTA LFCUENTA, t1.LFEXGARA LFEXGARA, t1.LFTIPGARA LFTIPGARA, t1.LFFECDEP LFFECDEP, t1.LFFECAPORAV LFFECAPORAV, t1.LFINDICSUF LFINDICSUF, t1.LFFECNOTIF LFFECNOTIF, t1.LFFECINFORM LFFECINFORM, t1.LFFECRESOL LFFECRESOL, t1.LFESTIMRESOL LFESTIMRESOL, t1.LFMOTRES LFMOTRES, t1.LFNUMPL LFNUMPL, t1.LFFRECPL LFFRECPL, t1.LFFECLIM1PA LFFECLIM1PA, t1.LFPORCDEM LFPORCDEM, t1.LFTIPPAG LFTIPPAG, t1.LFTIPNOT LFTIPNOT, t1.LFFECNOTRESOL LFFECNOTRESOL, t1.LFFECINVAL LFFECINVAL, t1.LFTIPINVAL LFTIPINVAL, t1.LFMOTINVAL LFMOTINVAL, t1.LFFECALC LFFECALC, t1.LFIMPPDTE LFIMPPDTE, t1.LFIMPINT LFIMPINT, t1.LFORGRESP LFORGRESP, t1.LFNUMEXP LFNUMEXP, t1.LFFECENV3 LFFECENV3, t1.LFFECENVCEN LFFECENVCEN, t1.LFFECLIMPAGVOL LFFECLIMPAGVOL, t1.LFIBAN LFIBAN, t1.LFESTADO LFESTADO, t1.LFFECALTA LFFECALTA, t1.LFFECMODIF LFFECMODIF, t1.LFUSUALTA LFUSUALTA, t1.LFUSUMODIF LFUSUMODIF FROM SANFRACSIPCA t1  WHERE t1.LFID = ?   AND t1.LFTIPREG = ?   AND t1.LFTIPOP = ?   AND t1.LFENTEM = ?   AND t1.LFSUFIJO = ?   AND t1.LFNUMREF = ?   AND t1.LFDIGCON = ?   AND t1.LFFECLIMPA = ?   AND t1.LFIMPORTE = ?   AND t1.LFFECOPER = ?   AND t1.LFFECSOLIC = ?   AND t1.LFTIPTER = ?   AND t1.LFCIF = ?   AND t1.LFNOMBRE = ?   AND t1.LFAPE1 = ?   AND t1.LFAPE2 = ?   AND t1.LFTEL = ?   AND t1.LFFAX = ?   AND t1.LFEMAIL = ?   AND t1.LFSIGL = ?   AND t1.LFVIAPU = ?   AND t1.LFPORTAL = ?   AND t1.LFLETRA = ?   AND t1.LFESCAL = ?   AND t1.LFPISO = ?   AND t1.LFPUERTA = ?   AND t1.LFCODPROV = ?   AND t1.LFCODMUN = ?   AND t1.LFCODLOC = ?   AND t1.LFCODPOS = ?   AND t1.LFCODCAU = ?   AND t1.LFMOTCAU = ?   AND t1.LFPROPAG = ?   AND t1.LFMOTPRO = ?   AND t1.LFCUENTA = ?   AND t1.LFEXGARA = ?   AND t1.LFTIPGARA = ?   AND t1.LFFECDEP = ?   AND t1.LFFECAPORAV = ?   AND t1.LFINDICSUF = ?   AND t1.LFFECNOTIF = ?   AND t1.LFFECINFORM = ?   AND t1.LFFECRESOL = ?   AND t1.LFESTIMRESOL = ?   AND t1.LFMOTRES = ?   AND t1.LFNUMPL = ?   AND t1.LFFRECPL = ?   AND t1.LFFECLIM1PA = ?   AND t1.LFPORCDEM = ?   AND t1.LFTIPPAG = ?   AND t1.LFTIPNOT = ?   AND t1.LFFECNOTRESOL = ?   AND t1.LFFECINVAL = ?   AND t1.LFTIPINVAL = ?   AND t1.LFMOTINVAL = ?   AND t1.LFFECALC = ?   AND t1.LFIMPPDTE = ?   AND t1.LFIMPINT = ?   AND t1.LFORGRESP = ?   AND t1.LFNUMEXP = ?   AND t1.LFFECENV3 = ?   AND t1.LFFECENVCEN = ?   AND t1.LFFECLIMPAGVOL = ?   AND t1.LFIBAN = ?   AND t1.LFESTADO = ?   AND t1.LFFECALTA = ?   AND t1.LFFECMODIF = ?   AND t1.LFUSUALTA = ?   AND t1.LFUSUMODIF = ?  ";
		
		List<Sanfracsipca> sanfracsipcaList = this.jdbcTemplate.query(query, this.rwMap, sanfracsipca.getLfid() , sanfracsipca.getLftipreg() , sanfracsipca.getLftipop() , sanfracsipca.getLfentem() , sanfracsipca.getLfsufijo() , sanfracsipca.getLfnumref() , sanfracsipca.getLfdigcon() , sanfracsipca.getLffeclimpa() , sanfracsipca.getLfimporte() , sanfracsipca.getLffecoper() , sanfracsipca.getLffecsolic() , sanfracsipca.getLftipter() , sanfracsipca.getLfcif() , sanfracsipca.getLfnombre() , sanfracsipca.getLfape1() , sanfracsipca.getLfape2() , sanfracsipca.getLftel() , sanfracsipca.getLffax() , sanfracsipca.getLfemail() , sanfracsipca.getLfsigl() , sanfracsipca.getLfviapu() , sanfracsipca.getLfportal() , sanfracsipca.getLfletra() , sanfracsipca.getLfescal() , sanfracsipca.getLfpiso() , sanfracsipca.getLfpuerta() , sanfracsipca.getLfcodprov() , sanfracsipca.getLfcodmun() , sanfracsipca.getLfcodloc() , sanfracsipca.getLfcodpos() , sanfracsipca.getLfcodcau() , sanfracsipca.getLfmotcau() , sanfracsipca.getLfpropag() , sanfracsipca.getLfmotpro() , sanfracsipca.getLfcuenta() , sanfracsipca.getLfexgara() , sanfracsipca.getLftipgara() , sanfracsipca.getLffecdep() , sanfracsipca.getLffecaporav() , sanfracsipca.getLfindicsuf() , sanfracsipca.getLffecnotif() , sanfracsipca.getLffecinform() , sanfracsipca.getLffecresol() , sanfracsipca.getLfestimresol() , sanfracsipca.getLfmotres() , sanfracsipca.getLfnumpl() , sanfracsipca.getLffrecpl() , sanfracsipca.getLffeclim1pa() , sanfracsipca.getLfporcdem() , sanfracsipca.getLftippag() , sanfracsipca.getLftipnot() , sanfracsipca.getLffecnotresol() , sanfracsipca.getLffecinval() , sanfracsipca.getLftipinval() , sanfracsipca.getLfmotinval() , sanfracsipca.getLffecalc() , sanfracsipca.getLfimppdte() , sanfracsipca.getLfimpint() , sanfracsipca.getLforgresp() , sanfracsipca.getLfnumexp() , sanfracsipca.getLffecenv3() , sanfracsipca.getLffecenvcen() , sanfracsipca.getLffeclimpagvol() , sanfracsipca.getLfiban() , sanfracsipca.getLfestado() , sanfracsipca.getLffecalta() , sanfracsipca.getLffecmodif() , sanfracsipca.getLfusualta() , sanfracsipca.getLfusumodif());
		return (Sanfracsipca) DataAccessUtils.uniqueResult(sanfracsipcaList);
    }

    /**
     * Removes a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Pagination
     * @return
     */
    public void remove(Sanfracsipca sanfracsipca) {
		String query = "DELETE FROM SANFRACSIPCA WHERE LFID=? AND LFTIPREG=? AND LFTIPOP=? AND LFENTEM=? AND LFSUFIJO=? AND LFNUMREF=? AND LFDIGCON=? AND LFFECLIMPA=? AND LFIMPORTE=? AND LFFECOPER=? AND LFFECSOLIC=? AND LFTIPTER=? AND LFCIF=? AND LFNOMBRE=? AND LFAPE1=? AND LFAPE2=? AND LFTEL=? AND LFFAX=? AND LFEMAIL=? AND LFSIGL=? AND LFVIAPU=? AND LFPORTAL=? AND LFLETRA=? AND LFESCAL=? AND LFPISO=? AND LFPUERTA=? AND LFCODPROV=? AND LFCODMUN=? AND LFCODLOC=? AND LFCODPOS=? AND LFCODCAU=? AND LFMOTCAU=? AND LFPROPAG=? AND LFMOTPRO=? AND LFCUENTA=? AND LFEXGARA=? AND LFTIPGARA=? AND LFFECDEP=? AND LFFECAPORAV=? AND LFINDICSUF=? AND LFFECNOTIF=? AND LFFECINFORM=? AND LFFECRESOL=? AND LFESTIMRESOL=? AND LFMOTRES=? AND LFNUMPL=? AND LFFRECPL=? AND LFFECLIM1PA=? AND LFPORCDEM=? AND LFTIPPAG=? AND LFTIPNOT=? AND LFFECNOTRESOL=? AND LFFECINVAL=? AND LFTIPINVAL=? AND LFMOTINVAL=? AND LFFECALC=? AND LFIMPPDTE=? AND LFIMPINT=? AND LFORGRESP=? AND LFNUMEXP=? AND LFFECENV3=? AND LFFECENVCEN=? AND LFFECLIMPAGVOL=? AND LFIBAN=? AND LFESTADO=? AND LFFECALTA=? AND LFFECMODIF=? AND LFUSUALTA=? AND LFUSUMODIF=?";
		this.jdbcTemplate.update(query, sanfracsipca.getLfid() , sanfracsipca.getLftipreg() , sanfracsipca.getLftipop() , sanfracsipca.getLfentem() , sanfracsipca.getLfsufijo() , sanfracsipca.getLfnumref() , sanfracsipca.getLfdigcon() , sanfracsipca.getLffeclimpa() , sanfracsipca.getLfimporte() , sanfracsipca.getLffecoper() , sanfracsipca.getLffecsolic() , sanfracsipca.getLftipter() , sanfracsipca.getLfcif() , sanfracsipca.getLfnombre() , sanfracsipca.getLfape1() , sanfracsipca.getLfape2() , sanfracsipca.getLftel() , sanfracsipca.getLffax() , sanfracsipca.getLfemail() , sanfracsipca.getLfsigl() , sanfracsipca.getLfviapu() , sanfracsipca.getLfportal() , sanfracsipca.getLfletra() , sanfracsipca.getLfescal() , sanfracsipca.getLfpiso() , sanfracsipca.getLfpuerta() , sanfracsipca.getLfcodprov() , sanfracsipca.getLfcodmun() , sanfracsipca.getLfcodloc() , sanfracsipca.getLfcodpos() , sanfracsipca.getLfcodcau() , sanfracsipca.getLfmotcau() , sanfracsipca.getLfpropag() , sanfracsipca.getLfmotpro() , sanfracsipca.getLfcuenta() , sanfracsipca.getLfexgara() , sanfracsipca.getLftipgara() , sanfracsipca.getLffecdep() , sanfracsipca.getLffecaporav() , sanfracsipca.getLfindicsuf() , sanfracsipca.getLffecnotif() , sanfracsipca.getLffecinform() , sanfracsipca.getLffecresol() , sanfracsipca.getLfestimresol() , sanfracsipca.getLfmotres() , sanfracsipca.getLfnumpl() , sanfracsipca.getLffrecpl() , sanfracsipca.getLffeclim1pa() , sanfracsipca.getLfporcdem() , sanfracsipca.getLftippag() , sanfracsipca.getLftipnot() , sanfracsipca.getLffecnotresol() , sanfracsipca.getLffecinval() , sanfracsipca.getLftipinval() , sanfracsipca.getLfmotinval() , sanfracsipca.getLffecalc() , sanfracsipca.getLfimppdte() , sanfracsipca.getLfimpint() , sanfracsipca.getLforgresp() , sanfracsipca.getLfnumexp() , sanfracsipca.getLffecenv3() , sanfracsipca.getLffecenvcen() , sanfracsipca.getLffeclimpagvol() , sanfracsipca.getLfiban() , sanfracsipca.getLfestado() , sanfracsipca.getLffecalta() , sanfracsipca.getLffecmodif() , sanfracsipca.getLfusualta() , sanfracsipca.getLfusumodif());
    }
    
   /**
    * Finds a List of rows in the Sanfracsipca table.
    * 
    * @param sanfracsipca Sanfracsipca
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Sanfracsipca> findAll(Sanfracsipca sanfracsipca, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.LFID LFID,t1.LFTIPREG LFTIPREG,t1.LFTIPOP LFTIPOP,t1.LFENTEM LFENTEM,t1.LFSUFIJO LFSUFIJO,t1.LFNUMREF LFNUMREF,t1.LFDIGCON LFDIGCON,t1.LFFECLIMPA LFFECLIMPA,t1.LFIMPORTE LFIMPORTE,t1.LFFECOPER LFFECOPER,t1.LFFECSOLIC LFFECSOLIC,t1.LFTIPTER LFTIPTER,t1.LFCIF LFCIF,t1.LFNOMBRE LFNOMBRE,t1.LFAPE1 LFAPE1,t1.LFAPE2 LFAPE2,t1.LFTEL LFTEL,t1.LFFAX LFFAX,t1.LFEMAIL LFEMAIL,t1.LFSIGL LFSIGL,t1.LFVIAPU LFVIAPU,t1.LFPORTAL LFPORTAL,t1.LFLETRA LFLETRA,t1.LFESCAL LFESCAL,t1.LFPISO LFPISO,t1.LFPUERTA LFPUERTA,t1.LFCODPROV LFCODPROV,t1.LFCODMUN LFCODMUN,t1.LFCODLOC LFCODLOC,t1.LFCODPOS LFCODPOS,t1.LFCODCAU LFCODCAU,t1.LFMOTCAU LFMOTCAU,t1.LFPROPAG LFPROPAG,t1.LFMOTPRO LFMOTPRO,t1.LFCUENTA LFCUENTA,t1.LFEXGARA LFEXGARA,t1.LFTIPGARA LFTIPGARA,t1.LFFECDEP LFFECDEP,t1.LFFECAPORAV LFFECAPORAV,t1.LFINDICSUF LFINDICSUF,t1.LFFECNOTIF LFFECNOTIF,t1.LFFECINFORM LFFECINFORM,t1.LFFECRESOL LFFECRESOL,t1.LFESTIMRESOL LFESTIMRESOL,t1.LFMOTRES LFMOTRES,t1.LFNUMPL LFNUMPL,t1.LFFRECPL LFFRECPL,t1.LFFECLIM1PA LFFECLIM1PA,t1.LFPORCDEM LFPORCDEM,t1.LFTIPPAG LFTIPPAG,t1.LFTIPNOT LFTIPNOT,t1.LFFECNOTRESOL LFFECNOTRESOL,t1.LFFECINVAL LFFECINVAL,t1.LFTIPINVAL LFTIPINVAL,t1.LFMOTINVAL LFMOTINVAL,t1.LFFECALC LFFECALC,t1.LFIMPPDTE LFIMPPDTE,t1.LFIMPINT LFIMPINT,t1.LFORGRESP LFORGRESP,t1.LFNUMEXP LFNUMEXP,t1.LFFECENV3 LFFECENV3,t1.LFFECENVCEN LFFECENVCEN,t1.LFFECLIMPAGVOL LFFECLIMPAGVOL,t1.LFIBAN LFIBAN,t1.LFESTADO LFESTADO,t1.LFFECALTA LFFECALTA,t1.LFFECMODIF LFFECMODIF,t1.LFUSUALTA LFUSUALTA,t1.LFUSUMODIF LFUSUMODIF "); 
		query.append("FROM SANFRACSIPCA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanfracsipca); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sanfracsipca>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Sanfracsipca table.
     * 
     * @param sanfracsipca Sanfracsipca
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Sanfracsipca sanfracsipca) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANFRACSIPCA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanfracsipca); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Sanfracsipca table using like.
     * 
     * @param sanfracsipca Sanfracsipca
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Sanfracsipca> findAllLike(Sanfracsipca sanfracsipca, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.LFID LFID,t1.LFTIPREG LFTIPREG,t1.LFTIPOP LFTIPOP,t1.LFENTEM LFENTEM,t1.LFSUFIJO LFSUFIJO,t1.LFNUMREF LFNUMREF,t1.LFDIGCON LFDIGCON,t1.LFFECLIMPA LFFECLIMPA,t1.LFIMPORTE LFIMPORTE,t1.LFFECOPER LFFECOPER,t1.LFFECSOLIC LFFECSOLIC,t1.LFTIPTER LFTIPTER,t1.LFCIF LFCIF,t1.LFNOMBRE LFNOMBRE,t1.LFAPE1 LFAPE1,t1.LFAPE2 LFAPE2,t1.LFTEL LFTEL,t1.LFFAX LFFAX,t1.LFEMAIL LFEMAIL,t1.LFSIGL LFSIGL,t1.LFVIAPU LFVIAPU,t1.LFPORTAL LFPORTAL,t1.LFLETRA LFLETRA,t1.LFESCAL LFESCAL,t1.LFPISO LFPISO,t1.LFPUERTA LFPUERTA,t1.LFCODPROV LFCODPROV,t1.LFCODMUN LFCODMUN,t1.LFCODLOC LFCODLOC,t1.LFCODPOS LFCODPOS,t1.LFCODCAU LFCODCAU,t1.LFMOTCAU LFMOTCAU,t1.LFPROPAG LFPROPAG,t1.LFMOTPRO LFMOTPRO,t1.LFCUENTA LFCUENTA,t1.LFEXGARA LFEXGARA,t1.LFTIPGARA LFTIPGARA,t1.LFFECDEP LFFECDEP,t1.LFFECAPORAV LFFECAPORAV,t1.LFINDICSUF LFINDICSUF,t1.LFFECNOTIF LFFECNOTIF,t1.LFFECINFORM LFFECINFORM,t1.LFFECRESOL LFFECRESOL,t1.LFESTIMRESOL LFESTIMRESOL,t1.LFMOTRES LFMOTRES,t1.LFNUMPL LFNUMPL,t1.LFFRECPL LFFRECPL,t1.LFFECLIM1PA LFFECLIM1PA,t1.LFPORCDEM LFPORCDEM,t1.LFTIPPAG LFTIPPAG,t1.LFTIPNOT LFTIPNOT,t1.LFFECNOTRESOL LFFECNOTRESOL,t1.LFFECINVAL LFFECINVAL,t1.LFTIPINVAL LFTIPINVAL,t1.LFMOTINVAL LFMOTINVAL,t1.LFFECALC LFFECALC,t1.LFIMPPDTE LFIMPPDTE,t1.LFIMPINT LFIMPINT,t1.LFORGRESP LFORGRESP,t1.LFNUMEXP LFNUMEXP,t1.LFFECENV3 LFFECENV3,t1.LFFECENVCEN LFFECENVCEN,t1.LFFECLIMPAGVOL LFFECLIMPAGVOL,t1.LFIBAN LFIBAN,t1.LFESTADO LFESTADO,t1.LFFECALTA LFFECALTA,t1.LFFECMODIF LFFECMODIF,t1.LFUSUALTA LFUSUALTA,t1.LFUSUMODIF LFUSUMODIF "); 
        query.append("FROM SANFRACSIPCA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanfracsipca,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sanfracsipca>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Sanfracsipca table using like.
     * 
     * @param sanfracsipca Sanfracsipca
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Sanfracsipca sanfracsipca, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANFRACSIPCA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanfracsipca,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Sanfracsipca entity 
	 * 
	 * @param sanfracsipca Sanfracsipca
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Sanfracsipca sanfracsipca){
		
		StringBuilder where = new StringBuilder(SanfracsipcaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanfracsipca  != null  && sanfracsipca.getLfid() != null ) {
			where.append(" AND t1.LFID = ?");
			params.add(sanfracsipca.getLfid());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftipreg() != null ) {
			where.append(" AND t1.LFTIPREG = ?");
			params.add(sanfracsipca.getLftipreg());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftipop() != null ) {
			where.append(" AND t1.LFTIPOP = ?");
			params.add(sanfracsipca.getLftipop());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfentem() != null ) {
			where.append(" AND t1.LFENTEM = ?");
			params.add(sanfracsipca.getLfentem());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfsufijo() != null ) {
			where.append(" AND t1.LFSUFIJO = ?");
			params.add(sanfracsipca.getLfsufijo());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfnumref() != null ) {
			where.append(" AND t1.LFNUMREF = ?");
			params.add(sanfracsipca.getLfnumref());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfdigcon() != null ) {
			where.append(" AND t1.LFDIGCON = ?");
			params.add(sanfracsipca.getLfdigcon());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffeclimpa() != null ) {
			where.append(" AND t1.LFFECLIMPA = ?");
			params.add(sanfracsipca.getLffeclimpa());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfimporte() != null ) {
			where.append(" AND t1.LFIMPORTE = ?");
			params.add(sanfracsipca.getLfimporte());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecoper() != null ) {
			where.append(" AND t1.LFFECOPER = ?");
			params.add(sanfracsipca.getLffecoper());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecsolic() != null ) {
			where.append(" AND t1.LFFECSOLIC = ?");
			params.add(sanfracsipca.getLffecsolic());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftipter() != null ) {
			where.append(" AND t1.LFTIPTER = ?");
			params.add(sanfracsipca.getLftipter());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcif() != null ) {
			where.append(" AND t1.LFCIF = ?");
			params.add(sanfracsipca.getLfcif());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfnombre() != null ) {
			where.append(" AND t1.LFNOMBRE = ?");
			params.add(sanfracsipca.getLfnombre());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfape1() != null ) {
			where.append(" AND t1.LFAPE1 = ?");
			params.add(sanfracsipca.getLfape1());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfape2() != null ) {
			where.append(" AND t1.LFAPE2 = ?");
			params.add(sanfracsipca.getLfape2());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftel() != null ) {
			where.append(" AND t1.LFTEL = ?");
			params.add(sanfracsipca.getLftel());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffax() != null ) {
			where.append(" AND t1.LFFAX = ?");
			params.add(sanfracsipca.getLffax());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfemail() != null ) {
			where.append(" AND t1.LFEMAIL = ?");
			params.add(sanfracsipca.getLfemail());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfsigl() != null ) {
			where.append(" AND t1.LFSIGL = ?");
			params.add(sanfracsipca.getLfsigl());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfviapu() != null ) {
			where.append(" AND t1.LFVIAPU = ?");
			params.add(sanfracsipca.getLfviapu());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfportal() != null ) {
			where.append(" AND t1.LFPORTAL = ?");
			params.add(sanfracsipca.getLfportal());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfletra() != null ) {
			where.append(" AND t1.LFLETRA = ?");
			params.add(sanfracsipca.getLfletra());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfescal() != null ) {
			where.append(" AND t1.LFESCAL = ?");
			params.add(sanfracsipca.getLfescal());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfpiso() != null ) {
			where.append(" AND t1.LFPISO = ?");
			params.add(sanfracsipca.getLfpiso());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfpuerta() != null ) {
			where.append(" AND t1.LFPUERTA = ?");
			params.add(sanfracsipca.getLfpuerta());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcodprov() != null ) {
			where.append(" AND t1.LFCODPROV = ?");
			params.add(sanfracsipca.getLfcodprov());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcodmun() != null ) {
			where.append(" AND t1.LFCODMUN = ?");
			params.add(sanfracsipca.getLfcodmun());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcodloc() != null ) {
			where.append(" AND t1.LFCODLOC = ?");
			params.add(sanfracsipca.getLfcodloc());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcodpos() != null ) {
			where.append(" AND t1.LFCODPOS = ?");
			params.add(sanfracsipca.getLfcodpos());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcodcau() != null ) {
			where.append(" AND t1.LFCODCAU = ?");
			params.add(sanfracsipca.getLfcodcau());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfmotcau() != null ) {
			where.append(" AND t1.LFMOTCAU = ?");
			params.add(sanfracsipca.getLfmotcau());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfpropag() != null ) {
			where.append(" AND t1.LFPROPAG = ?");
			params.add(sanfracsipca.getLfpropag());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfmotpro() != null ) {
			where.append(" AND t1.LFMOTPRO = ?");
			params.add(sanfracsipca.getLfmotpro());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfcuenta() != null ) {
			where.append(" AND t1.LFCUENTA = ?");
			params.add(sanfracsipca.getLfcuenta());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfexgara() != null ) {
			where.append(" AND t1.LFEXGARA = ?");
			params.add(sanfracsipca.getLfexgara());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftipgara() != null ) {
			where.append(" AND t1.LFTIPGARA = ?");
			params.add(sanfracsipca.getLftipgara());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecdep() != null ) {
			where.append(" AND t1.LFFECDEP = ?");
			params.add(sanfracsipca.getLffecdep());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecaporav() != null ) {
			where.append(" AND t1.LFFECAPORAV = ?");
			params.add(sanfracsipca.getLffecaporav());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfindicsuf() != null ) {
			where.append(" AND t1.LFINDICSUF = ?");
			params.add(sanfracsipca.getLfindicsuf());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecnotif() != null ) {
			where.append(" AND t1.LFFECNOTIF = ?");
			params.add(sanfracsipca.getLffecnotif());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecinform() != null ) {
			where.append(" AND t1.LFFECINFORM = ?");
			params.add(sanfracsipca.getLffecinform());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecresol() != null ) {
			where.append(" AND t1.LFFECRESOL = ?");
			params.add(sanfracsipca.getLffecresol());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfestimresol() != null ) {
			where.append(" AND t1.LFESTIMRESOL = ?");
			params.add(sanfracsipca.getLfestimresol());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfmotres() != null ) {
			where.append(" AND t1.LFMOTRES = ?");
			params.add(sanfracsipca.getLfmotres());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfnumpl() != null ) {
			where.append(" AND t1.LFNUMPL = ?");
			params.add(sanfracsipca.getLfnumpl());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffrecpl() != null ) {
			where.append(" AND t1.LFFRECPL = ?");
			params.add(sanfracsipca.getLffrecpl());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffeclim1pa() != null ) {
			where.append(" AND t1.LFFECLIM1PA = ?");
			params.add(sanfracsipca.getLffeclim1pa());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfporcdem() != null ) {
			where.append(" AND t1.LFPORCDEM = ?");
			params.add(sanfracsipca.getLfporcdem());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftippag() != null ) {
			where.append(" AND t1.LFTIPPAG = ?");
			params.add(sanfracsipca.getLftippag());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftipnot() != null ) {
			where.append(" AND t1.LFTIPNOT = ?");
			params.add(sanfracsipca.getLftipnot());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecnotresol() != null ) {
			where.append(" AND t1.LFFECNOTRESOL = ?");
			params.add(sanfracsipca.getLffecnotresol());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecinval() != null ) {
			where.append(" AND t1.LFFECINVAL = ?");
			params.add(sanfracsipca.getLffecinval());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLftipinval() != null ) {
			where.append(" AND t1.LFTIPINVAL = ?");
			params.add(sanfracsipca.getLftipinval());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfmotinval() != null ) {
			where.append(" AND t1.LFMOTINVAL = ?");
			params.add(sanfracsipca.getLfmotinval());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecalc() != null ) {
			where.append(" AND t1.LFFECALC = ?");
			params.add(sanfracsipca.getLffecalc());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfimppdte() != null ) {
			where.append(" AND t1.LFIMPPDTE = ?");
			params.add(sanfracsipca.getLfimppdte());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfimpint() != null ) {
			where.append(" AND t1.LFIMPINT = ?");
			params.add(sanfracsipca.getLfimpint());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLforgresp() != null ) {
			where.append(" AND t1.LFORGRESP = ?");
			params.add(sanfracsipca.getLforgresp());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfnumexp() != null ) {
			where.append(" AND t1.LFNUMEXP = ?");
			params.add(sanfracsipca.getLfnumexp());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecenv3() != null ) {
			where.append(" AND t1.LFFECENV3 = ?");
			params.add(sanfracsipca.getLffecenv3());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecenvcen() != null ) {
			where.append(" AND t1.LFFECENVCEN = ?");
			params.add(sanfracsipca.getLffecenvcen());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffeclimpagvol() != null ) {
			where.append(" AND t1.LFFECLIMPAGVOL = ?");
			params.add(sanfracsipca.getLffeclimpagvol());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfiban() != null ) {
			where.append(" AND t1.LFIBAN = ?");
			params.add(sanfracsipca.getLfiban());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfestado() != null ) {
			where.append(" AND t1.LFESTADO = ?");
			params.add(sanfracsipca.getLfestado());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecalta() != null ) {
			where.append(" AND t1.LFFECALTA = ?");
			params.add(sanfracsipca.getLffecalta());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLffecmodif() != null ) {
			where.append(" AND t1.LFFECMODIF = ?");
			params.add(sanfracsipca.getLffecmodif());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfusualta() != null ) {
			where.append(" AND t1.LFUSUALTA = ?");
			params.add(sanfracsipca.getLfusualta());
		}
		if (sanfracsipca  != null  && sanfracsipca.getLfusumodif() != null ) {
			where.append(" AND t1.LFUSUMODIF = ?");
			params.add(sanfracsipca.getLfusumodif());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Sanfracsipca entity 
	 * 
	 * @param sanfracsipca Sanfracsipca
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Sanfracsipca sanfracsipca, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(SanfracsipcaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanfracsipca  != null  && sanfracsipca.getLfid() != null ) {
			where.append(" AND t1.LFID = ?");
			params.add(sanfracsipca.getLfid());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftipreg() != null ) {
			where.append(" AND UPPER(t1.LFTIPREG) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftipreg().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftipreg().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPREG IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftipop() != null ) {
			where.append(" AND UPPER(t1.LFTIPOP) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftipop().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftipop().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPOP IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfentem() != null ) {
			where.append(" AND UPPER(t1.LFENTEM) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfentem().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfentem().toUpperCase() +"%");
			}
			where.append(" AND t1.LFENTEM IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfsufijo() != null ) {
			where.append(" AND UPPER(t1.LFSUFIJO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfsufijo().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfsufijo().toUpperCase() +"%");
			}
			where.append(" AND t1.LFSUFIJO IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfnumref() != null ) {
			where.append(" AND UPPER(t1.LFNUMREF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfnumref().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfnumref().toUpperCase() +"%");
			}
			where.append(" AND t1.LFNUMREF IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfdigcon() != null ) {
			where.append(" AND UPPER(t1.LFDIGCON) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfdigcon().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfdigcon().toUpperCase() +"%");
			}
			where.append(" AND t1.LFDIGCON IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffeclimpa() != null ) {
			where.append(" AND t1.LFFECLIMPA = ?");
			params.add(sanfracsipca.getLffeclimpa());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfimporte() != null ) {
			where.append(" AND UPPER(t1.LFIMPORTE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfimporte().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfimporte().toUpperCase() +"%");
			}
			where.append(" AND t1.LFIMPORTE IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecoper() != null ) {
			where.append(" AND t1.LFFECOPER = ?");
			params.add(sanfracsipca.getLffecoper());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecsolic() != null ) {
			where.append(" AND t1.LFFECSOLIC = ?");
			params.add(sanfracsipca.getLffecsolic());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftipter() != null ) {
			where.append(" AND UPPER(t1.LFTIPTER) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftipter().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftipter().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPTER IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcif() != null ) {
			where.append(" AND UPPER(t1.LFCIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcif().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcif().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCIF IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfnombre() != null ) {
			where.append(" AND UPPER(t1.LFNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfnombre().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.LFNOMBRE IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfape1() != null ) {
			where.append(" AND UPPER(t1.LFAPE1) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfape1().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfape1().toUpperCase() +"%");
			}
			where.append(" AND t1.LFAPE1 IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfape2() != null ) {
			where.append(" AND UPPER(t1.LFAPE2) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfape2().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfape2().toUpperCase() +"%");
			}
			where.append(" AND t1.LFAPE2 IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftel() != null ) {
			where.append(" AND UPPER(t1.LFTEL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftel().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftel().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTEL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffax() != null ) {
			where.append(" AND UPPER(t1.LFFAX) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLffax().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLffax().toUpperCase() +"%");
			}
			where.append(" AND t1.LFFAX IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfemail() != null ) {
			where.append(" AND UPPER(t1.LFEMAIL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfemail().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfemail().toUpperCase() +"%");
			}
			where.append(" AND t1.LFEMAIL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfsigl() != null ) {
			where.append(" AND UPPER(t1.LFSIGL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfsigl().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfsigl().toUpperCase() +"%");
			}
			where.append(" AND t1.LFSIGL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfviapu() != null ) {
			where.append(" AND UPPER(t1.LFVIAPU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfviapu().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfviapu().toUpperCase() +"%");
			}
			where.append(" AND t1.LFVIAPU IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfportal() != null ) {
			where.append(" AND UPPER(t1.LFPORTAL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfportal().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfportal().toUpperCase() +"%");
			}
			where.append(" AND t1.LFPORTAL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfletra() != null ) {
			where.append(" AND UPPER(t1.LFLETRA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfletra().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfletra().toUpperCase() +"%");
			}
			where.append(" AND t1.LFLETRA IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfescal() != null ) {
			where.append(" AND UPPER(t1.LFESCAL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfescal().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfescal().toUpperCase() +"%");
			}
			where.append(" AND t1.LFESCAL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfpiso() != null ) {
			where.append(" AND UPPER(t1.LFPISO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfpiso().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfpiso().toUpperCase() +"%");
			}
			where.append(" AND t1.LFPISO IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfpuerta() != null ) {
			where.append(" AND UPPER(t1.LFPUERTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfpuerta().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfpuerta().toUpperCase() +"%");
			}
			where.append(" AND t1.LFPUERTA IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcodprov() != null ) {
			where.append(" AND UPPER(t1.LFCODPROV) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcodprov().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcodprov().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCODPROV IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcodmun() != null ) {
			where.append(" AND UPPER(t1.LFCODMUN) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcodmun().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcodmun().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCODMUN IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcodloc() != null ) {
			where.append(" AND UPPER(t1.LFCODLOC) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcodloc().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcodloc().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCODLOC IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcodpos() != null ) {
			where.append(" AND UPPER(t1.LFCODPOS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcodpos().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcodpos().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCODPOS IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcodcau() != null ) {
			where.append(" AND UPPER(t1.LFCODCAU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcodcau().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcodcau().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCODCAU IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfmotcau() != null ) {
			where.append(" AND UPPER(t1.LFMOTCAU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfmotcau().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfmotcau().toUpperCase() +"%");
			}
			where.append(" AND t1.LFMOTCAU IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfpropag() != null ) {
			where.append(" AND UPPER(t1.LFPROPAG) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfpropag().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfpropag().toUpperCase() +"%");
			}
			where.append(" AND t1.LFPROPAG IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfmotpro() != null ) {
			where.append(" AND UPPER(t1.LFMOTPRO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfmotpro().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfmotpro().toUpperCase() +"%");
			}
			where.append(" AND t1.LFMOTPRO IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfcuenta() != null ) {
			where.append(" AND UPPER(t1.LFCUENTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfcuenta().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfcuenta().toUpperCase() +"%");
			}
			where.append(" AND t1.LFCUENTA IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfexgara() != null ) {
			where.append(" AND UPPER(t1.LFEXGARA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfexgara().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfexgara().toUpperCase() +"%");
			}
			where.append(" AND t1.LFEXGARA IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftipgara() != null ) {
			where.append(" AND UPPER(t1.LFTIPGARA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftipgara().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftipgara().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPGARA IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecdep() != null ) {
			where.append(" AND t1.LFFECDEP = ?");
			params.add(sanfracsipca.getLffecdep());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecaporav() != null ) {
			where.append(" AND t1.LFFECAPORAV = ?");
			params.add(sanfracsipca.getLffecaporav());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfindicsuf() != null ) {
			where.append(" AND UPPER(t1.LFINDICSUF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfindicsuf().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfindicsuf().toUpperCase() +"%");
			}
			where.append(" AND t1.LFINDICSUF IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecnotif() != null ) {
			where.append(" AND t1.LFFECNOTIF = ?");
			params.add(sanfracsipca.getLffecnotif());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecinform() != null ) {
			where.append(" AND t1.LFFECINFORM = ?");
			params.add(sanfracsipca.getLffecinform());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecresol() != null ) {
			where.append(" AND t1.LFFECRESOL = ?");
			params.add(sanfracsipca.getLffecresol());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfestimresol() != null ) {
			where.append(" AND UPPER(t1.LFESTIMRESOL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfestimresol().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfestimresol().toUpperCase() +"%");
			}
			where.append(" AND t1.LFESTIMRESOL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfmotres() != null ) {
			where.append(" AND UPPER(t1.LFMOTRES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfmotres().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfmotres().toUpperCase() +"%");
			}
			where.append(" AND t1.LFMOTRES IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfnumpl() != null ) {
			where.append(" AND UPPER(t1.LFNUMPL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfnumpl().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfnumpl().toUpperCase() +"%");
			}
			where.append(" AND t1.LFNUMPL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffrecpl() != null ) {
			where.append(" AND UPPER(t1.LFFRECPL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLffrecpl().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLffrecpl().toUpperCase() +"%");
			}
			where.append(" AND t1.LFFRECPL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffeclim1pa() != null ) {
			where.append(" AND t1.LFFECLIM1PA = ?");
			params.add(sanfracsipca.getLffeclim1pa());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfporcdem() != null ) {
			where.append(" AND UPPER(t1.LFPORCDEM) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfporcdem().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfporcdem().toUpperCase() +"%");
			}
			where.append(" AND t1.LFPORCDEM IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftippag() != null ) {
			where.append(" AND UPPER(t1.LFTIPPAG) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftippag().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftippag().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPPAG IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftipnot() != null ) {
			where.append(" AND UPPER(t1.LFTIPNOT) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftipnot().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftipnot().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPNOT IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecnotresol() != null ) {
			where.append(" AND t1.LFFECNOTRESOL = ?");
			params.add(sanfracsipca.getLffecnotresol());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecinval() != null ) {
			where.append(" AND t1.LFFECINVAL = ?");
			params.add(sanfracsipca.getLffecinval());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLftipinval() != null ) {
			where.append(" AND UPPER(t1.LFTIPINVAL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLftipinval().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLftipinval().toUpperCase() +"%");
			}
			where.append(" AND t1.LFTIPINVAL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfmotinval() != null ) {
			where.append(" AND UPPER(t1.LFMOTINVAL) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfmotinval().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfmotinval().toUpperCase() +"%");
			}
			where.append(" AND t1.LFMOTINVAL IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecalc() != null ) {
			where.append(" AND t1.LFFECALC = ?");
			params.add(sanfracsipca.getLffecalc());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfimppdte() != null ) {
			where.append(" AND UPPER(t1.LFIMPPDTE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfimppdte().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfimppdte().toUpperCase() +"%");
			}
			where.append(" AND t1.LFIMPPDTE IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfimpint() != null ) {
			where.append(" AND UPPER(t1.LFIMPINT) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfimpint().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfimpint().toUpperCase() +"%");
			}
			where.append(" AND t1.LFIMPINT IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLforgresp() != null ) {
			where.append(" AND UPPER(t1.LFORGRESP) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLforgresp().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLforgresp().toUpperCase() +"%");
			}
			where.append(" AND t1.LFORGRESP IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfnumexp() != null ) {
			where.append(" AND UPPER(t1.LFNUMEXP) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfnumexp().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfnumexp().toUpperCase() +"%");
			}
			where.append(" AND t1.LFNUMEXP IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecenv3() != null ) {
			where.append(" AND t1.LFFECENV3 = ?");
			params.add(sanfracsipca.getLffecenv3());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecenvcen() != null ) {
			where.append(" AND t1.LFFECENVCEN = ?");
			params.add(sanfracsipca.getLffecenvcen());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffeclimpagvol() != null ) {
			where.append(" AND t1.LFFECLIMPAGVOL = ?");
			params.add(sanfracsipca.getLffeclimpagvol());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfiban() != null ) {
			where.append(" AND UPPER(t1.LFIBAN) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfiban().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfiban().toUpperCase() +"%");
			}
			where.append(" AND t1.LFIBAN IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfestado() != null ) {
			where.append(" AND UPPER(t1.LFESTADO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfestado().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfestado().toUpperCase() +"%");
			}
			where.append(" AND t1.LFESTADO IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecalta() != null ) {
			where.append(" AND t1.LFFECALTA = ?");
			params.add(sanfracsipca.getLffecalta());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLffecmodif() != null ) {
			where.append(" AND t1.LFFECMODIF = ?");
			params.add(sanfracsipca.getLffecmodif());
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfusualta() != null ) {
			where.append(" AND UPPER(t1.LFUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfusualta().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfusualta().toUpperCase() +"%");
			}
			where.append(" AND t1.LFUSUALTA IS NOT NULL");
	     }			
		if (sanfracsipca  != null  && sanfracsipca.getLfusumodif() != null ) {
			where.append(" AND UPPER(t1.LFUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanfracsipca.getLfusumodif().toUpperCase() +"%");
			}else{
				params.add("%"+sanfracsipca.getLfusumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.LFUSUMODIF IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

