package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanfracsipca;

/**
 * SanfracsipcaDao  
 *  
 */

public interface SanfracsipcaDao {
    
    /**
     * Inserts a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Sanfracsipca
     * @return Sanfracsipca
     */
    Sanfracsipca add(Sanfracsipca sanfracsipca);

    /**
     * Updates a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Sanfracsipca
     * @return Sanfracsipca
     */
    Sanfracsipca update(Sanfracsipca sanfracsipca);

    /**
     * Finds a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Sanfracsipca
     * @return Sanfracsipca
     */
    Sanfracsipca find(Sanfracsipca sanfracsipca);

    /**
     * Deletes a single row in the Sanfracsipca table.
     *
     * @param sanfracsipca Sanfracsipca
     * @return 
     */
    void remove(Sanfracsipca sanfracsipca);

    /**
     * Finds a List of rows in the Sanfracsipca table.
     *
     * @param sanfracsipca Sanfracsipca
     * @param pagination Pagination
     * @return List
     */
    List<Sanfracsipca> findAll(Sanfracsipca sanfracsipca, Pagination pagination);

    /**
     * Counts rows in the Sanfracsipca table.
     *
     * @param sanfracsipca Sanfracsipca
     * @return Long
     */
    Long findAllCount(Sanfracsipca sanfracsipca);
	
	/**
     * Finds rows in the Sanfracsipca table using like.
     *
     * @param sanfracsipca Sanfracsipca
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Sanfracsipca> findAllLike(Sanfracsipca sanfracsipca, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Sanfracsipca table using like.
     *
     * @param sanfracsipca Sanfracsipca
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Sanfracsipca sanfracsipca, Boolean startsWith);
}

