package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Santramexp;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanfracc;

/**
 * SanfraccDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanfraccDaoImpl implements SanfraccDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Sanfracc> rwMap = new RowMapper<Sanfracc>() {
		public Sanfracc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sanfracc(resultSet.getBigDecimal("FAID"),
					resultSet.getDate("FAFECHA"),
					resultSet.getString("FAIMPORTE"),
					resultSet.getString("FAINTERES"),
					resultSet.getDate("FAFECALTA"),
					resultSet.getDate("FAFECMODIF"),
					resultSet.getString("FAUSUALTA"),
					resultSet.getString("FAUSUMODIF"), new Santramexp(
							resultSet.getString("SantramexpTRID")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Pagination
	 * @return Sanfracc
	 */
	public Sanfracc add(Sanfracc sanfracc) {
		String query = "INSERT INTO SANFRACC (FAID, FATRID, FAFECHA, FAIMPORTE, FAINTERES, FAFECALTA, FAFECMODIF, FAUSUALTA, FAUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?)";
		Object getSantramexpTridAux = null;
		if (sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrid() != null) {
			getSantramexpTridAux = sanfracc.getSantramexp().getTrid();
		}
		this.jdbcTemplate.update(query, sanfracc.getFaid(),
				getSantramexpTridAux, sanfracc.getFafecha(),
				sanfracc.getFaimporte(), sanfracc.getFainteres(),
				sanfracc.getFafecalta(), sanfracc.getFafecmodif(),
				sanfracc.getFausualta(), sanfracc.getFausumodif());
		return sanfracc;
	}

	/**
	 * Updates a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Pagination
	 * @return Sanfracc
	 */
	public Sanfracc update(Sanfracc sanfracc) {
		String query = "UPDATE SANFRACC SET FATRID=?, FAFECHA=?, FAIMPORTE=?, FAINTERES=?, FAFECALTA=?, FAFECMODIF=?, FAUSUALTA=?, FAUSUMODIF=? WHERE FAID=?";
		Object getSantramexpTridAux = null;
		if (sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrid() != null) {
			getSantramexpTridAux = sanfracc.getSantramexp().getTrid();
		}
		this.jdbcTemplate.update(query, getSantramexpTridAux,
				sanfracc.getFafecha(), sanfracc.getFaimporte(),
				sanfracc.getFainteres(), sanfracc.getFafecalta(),
				sanfracc.getFafecmodif(), sanfracc.getFausualta(),
				sanfracc.getFausumodif(), sanfracc.getFaid());
		return sanfracc;
	}

	/**
	 * Finds a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Pagination
	 * @return Sanfracc
	 */
	@Transactional(readOnly = true)
	public Sanfracc find(Sanfracc sanfracc) {
		String query = "SELECT t1.FAID FAID, t1.FAFECHA FAFECHA, t1.FAIMPORTE FAIMPORTE, t1.FAINTERES FAINTERES, t1.FAFECALTA FAFECALTA, t1.FAFECMODIF FAFECMODIF, t1.FAUSUALTA FAUSUALTA, t1.FAUSUMODIF FAUSUMODIF, t2.TRID SANTRAMEXPTRID, t2.TRCODIGO SANTRAMEXPTRCODIGO, t2.TRFECINI SANTRAMEXPTRFECINI, t2.TRFECFIN SANTRAMEXPTRFECFIN, /*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/ t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES, t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO, t2.TRTRIDREL SANTRAMEXPTRTRIDREL, t2.TRFECACINI SANTRAMEXPTRFECACINI, t2.TRRESULTADO SANTRAMEXPTRRESULTADO, t2.TRESTIMACION SANTRAMEXPTRESTIMACION, t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA, t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO, t2.TRRESOSAN SANTRAMEXPTRRESOSAN, t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE, t2.TRFECREGS SANTRAMEXPTRFECREGS, t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE, t2.TRNUMREGS SANTRAMEXPTRNUMREGS, t2.TRNUMREGE SANTRAMEXPTRNUMREGE, t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM, t2.TRFECENVIO SANTRAMEXPTRFECENVIO, t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE, t2.TRFECALTA SANTRAMEXPTRFECALTA, t2.TRFECMODIF SANTRAMEXPTRFECMODIF, t2.TRUSUALTA SANTRAMEXPTRUSUALTA, t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF, t2.TREXCODIGO SANTRAMEXPTREXCODIGO FROM SANFRACC t1 , SANTRAMEXP t2  WHERE t1.FAID = ?   AND t1.FATRID= t2.TRID(+)";

		List<Sanfracc> sanfraccList = this.jdbcTemplate.query(query,
				this.rwMap, sanfracc.getFaid());
		return (Sanfracc) DataAccessUtils.uniqueResult(sanfraccList);
	}

	/**
	 * Removes a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Pagination
	 * @return
	 */
	public void remove(Sanfracc sanfracc) {
		String query = "DELETE FROM SANFRACC WHERE FAID=?";
		this.jdbcTemplate.update(query, sanfracc.getFaid());
	}

	/**
	 * Finds a List of rows in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanfracc> findAll(Sanfracc sanfracc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.FAID FAID,t1.FAFECHA FAFECHA,t1.FAIMPORTE FAIMPORTE,t1.FAINTERES FAINTERES,t1.FAFECALTA FAFECALTA,t1.FAFECMODIF FAFECMODIF,t1.FAUSUALTA FAUSUALTA,t1.FAUSUMODIF FAUSUMODIF,t2.TRID SANTRAMEXPTRID,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF,t2.TREXCODIGO SANTRAMEXPTREXCODIGO ");
		query.append("FROM SANFRACC t1 ,SANTRAMEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanfracc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FATRID= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanfracc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanfracc sanfracc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANFRACC t1 , SANTRAMEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanfracc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FATRID= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sanfracc table using like.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanfracc> findAllLike(Sanfracc sanfracc, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.FAID FAID,t1.FAFECHA FAFECHA,t1.FAIMPORTE FAIMPORTE,t1.FAINTERES FAINTERES,t1.FAFECALTA FAFECALTA,t1.FAFECMODIF FAFECMODIF,t1.FAUSUALTA FAUSUALTA,t1.FAUSUMODIF FAUSUMODIF,t2.TRID SANTRAMEXPTRID,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF,t2.TREXCODIGO SANTRAMEXPTREXCODIGO ");
		query.append("FROM SANFRACC t1 ,SANTRAMEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanfracc, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FATRID= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanfracc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanfracc table using like.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanfracc sanfracc, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANFRACC t1 ,SANTRAMEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanfracc, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FATRID= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanfracc entity
	 * 
	 * @param sanfracc
	 *            Sanfracc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanfracc sanfracc) {

		StringBuilder where = new StringBuilder(
				SanfraccDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanfracc != null && sanfracc.getFaid() != null) {
			where.append(" AND t1.FAID = ?");
			params.add(sanfracc.getFaid());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(sanfracc.getSantramexp().getTrid());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getExpedien() != null
				&& sanfracc.getSantramexp().getExpedien().getExcodigo() != null) {
			where.append(" AND t2.TREXCODIGO = ?");
			params.add(sanfracc.getSantramexp().getExpedien().getExcodigo());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(sanfracc.getSantramexp().getTrcodigo());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(sanfracc.getSantramexp().getTrfecini());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(sanfracc.getSantramexp().getTrfecfin());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrobserves() != null) {
			where.append(" AND t2.TROBSERVES = ?");
			params.add(sanfracc.getSantramexp().getTrobserves());
		}
		if (sanfracc != null
				&& sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getCensoMonitor() != null
				&& sanfracc.getSantramexp().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.TRMOCODIGO = ?");
			params.add(sanfracc.getSantramexp().getCensoMonitor().getMocodigo());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(sanfracc.getSantramexp().getTrtridrel());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecacini() != null) {
			where.append(" AND t2.TRFECACINI = ?");
			params.add(sanfracc.getSantramexp().getTrfecacini());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(sanfracc.getSantramexp().getTrresultado());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrestimacion() != null) {
			where.append(" AND t2.TRESTIMACION = ?");
			params.add(sanfracc.getSantramexp().getTrestimacion());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(sanfracc.getSantramexp().getTrresofecha());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresotipo() != null) {
			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(sanfracc.getSantramexp().getTrresotipo());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresosan() != null) {
			where.append(" AND t2.TRRESOSAN = ?");
			params.add(sanfracc.getSantramexp().getTrresosan());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(sanfracc.getSantramexp().getTrresoimporte());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(sanfracc.getSantramexp().getTrfecregs());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrestadoacuse() != null) {
			where.append(" AND t2.TRESTADOACUSE = ?");
			params.add(sanfracc.getSantramexp().getTrestadoacuse());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrnumregs() != null) {
			where.append(" AND t2.TRNUMREGS = ?");
			params.add(sanfracc.getSantramexp().getTrnumregs());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrnumrege() != null) {
			where.append(" AND t2.TRNUMREGE = ?");
			params.add(sanfracc.getSantramexp().getTrnumrege());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrtipocom() != null) {
			where.append(" AND t2.TRTIPOCOM = ?");
			params.add(sanfracc.getSantramexp().getTrtipocom());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(sanfracc.getSantramexp().getTrfecenvio());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(sanfracc.getSantramexp().getTrfeccierre());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(sanfracc.getSantramexp().getTrfecalta());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(sanfracc.getSantramexp().getTrfecmodif());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrusualta() != null) {
			where.append(" AND t2.TRUSUALTA = ?");
			params.add(sanfracc.getSantramexp().getTrusualta());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrusumodif() != null) {
			where.append(" AND t2.TRUSUMODIF = ?");
			params.add(sanfracc.getSantramexp().getTrusumodif());
		}
		if (sanfracc != null && sanfracc.getFafecha() != null) {
			where.append(" AND t1.FAFECHA = ?");
			params.add(sanfracc.getFafecha());
		}
		if (sanfracc != null && sanfracc.getFaimporte() != null) {
			where.append(" AND t1.FAIMPORTE = ?");
			params.add(sanfracc.getFaimporte());
		}
		if (sanfracc != null && sanfracc.getFainteres() != null) {
			where.append(" AND t1.FAINTERES = ?");
			params.add(sanfracc.getFainteres());
		}
		if (sanfracc != null && sanfracc.getFafecalta() != null) {
			where.append(" AND t1.FAFECALTA = ?");
			params.add(sanfracc.getFafecalta());
		}
		if (sanfracc != null && sanfracc.getFafecmodif() != null) {
			where.append(" AND t1.FAFECMODIF = ?");
			params.add(sanfracc.getFafecmodif());
		}
		if (sanfracc != null && sanfracc.getFausualta() != null) {
			where.append(" AND t1.FAUSUALTA = ?");
			params.add(sanfracc.getFausualta());
		}
		if (sanfracc != null && sanfracc.getFausumodif() != null) {
			where.append(" AND t1.FAUSUMODIF = ?");
			params.add(sanfracc.getFausumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanfracc entity
	 * 
	 * @param sanfracc
	 *            Sanfracc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanfracc sanfracc, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanfraccDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanfracc != null && sanfracc.getFaid() != null) {
			where.append(" AND t1.FAID = ?");
			params.add(sanfracc.getFaid());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(sanfracc.getSantramexp().getTrid());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getExpedien() != null
				&& sanfracc.getSantramexp().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t2.TREXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getExpedien().getExcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getExpedien().getExcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TREXCODIGO IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrcodigo() != null) {
			where.append(" AND UPPER(t2.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TRCODIGO IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(sanfracc.getSantramexp().getTrfecini());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(sanfracc.getSantramexp().getTrfecfin());
		}

		if (sanfracc != null
				&& sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getCensoMonitor() != null
				&& sanfracc.getSantramexp().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t2.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TRMOCODIGO IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(sanfracc.getSantramexp().getTrtridrel());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecacini() != null) {
			where.append(" AND t2.TRFECACINI = ?");
			params.add(sanfracc.getSantramexp().getTrfecacini());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(sanfracc.getSantramexp().getTrresultado());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrestimacion() != null) {
			where.append(" AND UPPER(t2.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrestimacion()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrestimacion()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTIMACION IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(sanfracc.getSantramexp().getTrresofecha());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresotipo() != null) {

			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(sanfracc.getSantramexp().getTrresotipo());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresosan() != null) {

			where.append(" AND t2.TRRESOSAN = ?");
			params.add(sanfracc.getSantramexp().getTrresosan());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(sanfracc.getSantramexp().getTrresoimporte());

		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(sanfracc.getSantramexp().getTrfecregs());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t2.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrestadoacuse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrestadoacuse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTADOACUSE IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrnumregs() != null) {
			where.append(" AND UPPER(t2.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrnumregs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrnumregs().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TRNUMREGS IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrnumrege() != null) {
			where.append(" AND UPPER(t2.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrnumrege()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrnumrege().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TRNUMREGE IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrtipocom() != null) {
			where.append(" AND UPPER(t2.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrtipocom()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrtipocom().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TRTIPOCOM IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(sanfracc.getSantramexp().getTrfecenvio());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(sanfracc.getSantramexp().getTrfeccierre());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(sanfracc.getSantramexp().getTrfecalta());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(sanfracc.getSantramexp().getTrfecmodif());
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrusualta() != null) {
			where.append(" AND UPPER(t2.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TRUSUALTA IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getSantramexp() != null
				&& sanfracc.getSantramexp().getTrusumodif() != null) {
			where.append(" AND UPPER(t2.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getSantramexp().getTrusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanfracc.getSantramexp().getTrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUMODIF IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getFafecha() != null) {
			where.append(" AND t1.FAFECHA = ?");
			params.add(sanfracc.getFafecha());
		}
		if (sanfracc != null && sanfracc.getFaimporte() != null) {
			where.append(" AND UPPER(t1.FAIMPORTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getFaimporte().toUpperCase() + "%");
			} else {
				params.add("%" + sanfracc.getFaimporte().toUpperCase() + "%");
			}
			where.append(" AND t1.FAIMPORTE IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getFainteres() != null) {
			where.append(" AND UPPER(t1.FAINTERES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getFainteres().toUpperCase() + "%");
			} else {
				params.add("%" + sanfracc.getFainteres().toUpperCase() + "%");
			}
			where.append(" AND t1.FAINTERES IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getFafecalta() != null) {
			where.append(" AND t1.FAFECALTA = ?");
			params.add(sanfracc.getFafecalta());
		}
		if (sanfracc != null && sanfracc.getFafecmodif() != null) {
			where.append(" AND t1.FAFECMODIF = ?");
			params.add(sanfracc.getFafecmodif());
		}
		if (sanfracc != null && sanfracc.getFausualta() != null) {
			where.append(" AND UPPER(t1.FAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getFausualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanfracc.getFausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.FAUSUALTA IS NOT NULL");
		}
		if (sanfracc != null && sanfracc.getFausumodif() != null) {
			where.append(" AND UPPER(t1.FAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanfracc.getFausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanfracc.getFausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.FAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes rows in the Sanfracc table.
	 * 
	 * @param fatrid
	 *            BigDecimal
	 * @return
	 */
	public void removeByTrid(BigDecimal fatrid) {
		String query = "DELETE FROM SANFRACC WHERE FATRID=?";
		this.jdbcTemplate.update(query, fatrid);
	}
}
