package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.util.List;

import com.ejie.y41b.model.Sanfracc;

/**
 * SanfraccDao  
 * 
 *  
 */

public interface SanfraccDao {

	/**
	 * Inserts a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	Sanfracc add(Sanfracc sanfracc);

	/**
	 * Updates a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	Sanfracc update(Sanfracc sanfracc);

	/**
	 * Finds a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Sanfracc
	 */
	Sanfracc find(Sanfracc sanfracc);

	/**
	 * Deletes a single row in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return
	 */
	void remove(Sanfracc sanfracc);

	/**
	 * Finds a List of rows in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanfracc> findAll(Sanfracc sanfracc, Pagination pagination);

	/**
	 * Counts rows in the Sanfracc table.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @return Long
	 */
	Long findAllCount(Sanfracc sanfracc);

	/**
	 * Finds rows in the Sanfracc table using like.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanfracc> findAllLike(Sanfracc sanfracc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sanfracc table using like.
	 * 
	 * @param sanfracc
	 *            Sanfracc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanfracc sanfracc, Boolean startsWith);

	/**
	 * Removes rows in the Sanfracc table.
	 * 
	 * @param fatrid
	 *            BigDecimal
	 * @return
	 */
	void removeByTrid(BigDecimal fatrid);
}
