package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * SanexprelDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanexprelDaoImpl implements SanexprelDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(SanexprelDaoImpl.class);

	private RowMapper<Sanexprel> rwMapDefecto = new RowMapper<Sanexprel>() {
		public Sanexprel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Sanexprel sanexprel = new Sanexprel(resultSet.getString("RLID"),
					resultSet.getString("RLHDCODREL"),
					resultSet.getString("RLEXCODREL"),
					resultSet.getString("CODEXPCOMPLETO"),
					resultSet.getString("RLHDCODIGO"),
					resultSet.getString("RLESORIG"),
					resultSet.getString("MONOMBRE"),
					resultSet.getDate("FECHAINI"),
					resultSet.getDate("FECHAFIN"),
					resultSet.getString("RLARBCODIGO"),
					resultSet.getString("RLARBCODREL"),
					resultSet.getString("RLINSCODIGO"),
					resultSet.getString("RLINSCODREL"));

			sanexprel.setExpedienByRlexcodigo(new Expedien(resultSet
					.getString("RLEXCODIGO")));
			return sanexprel;
		}
	};
	private RowMapper<Sanexprel> rwMap = new RowMapper<Sanexprel>() {
		public Sanexprel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Sanexprel sanexprel = new Sanexprel(resultSet.getString("RLID"),
					resultSet.getString("RLHDCODREL"),
					resultSet.getString("RLINSCODREL"),
					resultSet.getString("RLEXCODREL"),
					resultSet.getString("CODEXPCOMPLETO"),
					resultSet.getString("RLHDCODIGO"),
					resultSet.getString("RLINSCODIGO"),
					resultSet.getString("RLESORIG"),
					resultSet.getString("MONOMBRE"),
					resultSet.getDate("FECHAINI"),
					resultSet.getDate("FECHAFIN"), new TipoProcedimiento(
							resultSet.getString("PCODIGO"),
							resultSet.getString("PNOMBRE"),
							resultSet.getString("PNOMBREE"), null),
					resultSet.getString("RLARBCODIGO"),
					resultSet.getString("RLARBCODREL"));
			return sanexprel;
		}
	};

	private RowMapper<Sanexprel> rwMapSinArbConIns = new RowMapper<Sanexprel>() {
		public Sanexprel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Sanexprel sanexprel = new Sanexprel(resultSet.getString("RLID"),
					resultSet.getString("RLHDCODREL"),
					resultSet.getString("RLINSCODREL"),
					resultSet.getString("RLEXCODREL"),
					resultSet.getString("CODEXPCOMPLETO"),
					resultSet.getString("RLHDCODIGO"),
					resultSet.getString("RLINSCODIGO"),
					resultSet.getString("RLESORIG"),
					resultSet.getString("MONOMBRE"),
					resultSet.getDate("FECHAINI"),
					resultSet.getDate("FECHAFIN"), new TipoProcedimiento(
							resultSet.getString("PCODIGO"),
							resultSet.getString("PNOMBRE"),
							resultSet.getString("PNOMBREE"), null));
			return sanexprel;
		}
	};

	private RowMapper<Sanexprel> rwMapConArbSinIns = new RowMapper<Sanexprel>() {
		public Sanexprel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Sanexprel sanexprel = new Sanexprel(resultSet.getString("RLID"),
					resultSet.getString("RLHDCODREL"),
					resultSet.getString("RLEXCODREL"),
					resultSet.getString("CODEXPCOMPLETO"),
					resultSet.getString("RLHDCODIGO"),
					resultSet.getString("RLESORIG"),
					resultSet.getString("MONOMBRE"),
					resultSet.getDate("FECHAINI"),
					resultSet.getDate("FECHAFIN"), new TipoProcedimiento(
							resultSet.getString("PCODIGO"),
							resultSet.getString("PNOMBRE"),
							resultSet.getString("PNOMBREE"), null),
					resultSet.getString("RLARBCODIGO"),
					resultSet.getString("RLARBCODREL"));
			return sanexprel;
		}
	};

	private RowMapper<Sanexprel> rwMapSinArbSinIns = new RowMapper<Sanexprel>() {
		public Sanexprel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Sanexprel sanexprel = new Sanexprel(resultSet.getString("RLID"),
					resultSet.getString("RLHDCODREL"),
					resultSet.getString("RLEXCODREL"),
					resultSet.getString("CODEXPCOMPLETO"),
					resultSet.getString("RLHDCODIGO"),
					resultSet.getString("RLESORIG"),
					resultSet.getString("MONOMBRE"),
					resultSet.getDate("FECHAINI"),
					resultSet.getDate("FECHAFIN"), new TipoProcedimiento(
							resultSet.getString("PCODIGO"),
							resultSet.getString("PNOMBRE"),
							resultSet.getString("PNOMBREE"), null));
			return sanexprel;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return Sanexprel
	 */
	public Sanexprel add(Sanexprel sanexprel) {
		String querycompleta = "";
		try {
			String query = "";
			if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
				if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
					query = "INSERT INTO SANEXPREL (RLID, RLINSCODREL, RLINSCODIGO, RLEXCODREL, RLEXCODIGO, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, RLESORIG, RLFECALTA, RLFECMODIF, RLUSUALTA, RLUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				} else {
					query = "INSERT INTO SANEXPREL (RLID, RLEXCODREL, RLEXCODIGO, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, RLESORIG, RLFECALTA, RLFECMODIF, RLUSUALTA, RLUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				}

			} else {
				if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
					query = "INSERT INTO SANEXPREL (RLID, RLINSCODREL, RLINSCODIGO, RLEXCODREL, RLEXCODIGO, RLHDCODREL, RLHDCODIGO, RLESORIG, RLFECALTA, RLFECMODIF, RLUSUALTA, RLUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				} else {
					query = "INSERT INTO SANEXPREL (RLID, RLEXCODREL, RLEXCODIGO, RLHDCODREL, RLHDCODIGO, RLESORIG, RLFECALTA, RLFECMODIF, RLUSUALTA, RLUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?)";
				}

			}

			/*
			 * Object getExpedienByRlexcodrelExcodigoAux1 = null; if
			 * (sanexprel.getExpedienByRlexcodrel() != null &&
			 * sanexprel.getExpedienByRlexcodrel().getExcodigo() != null) {
			 * getExpedienByRlexcodrelExcodigoAux1 = sanexprel
			 * .getExpedienByRlexcodrel().getExcodigo(); }
			 */
			Object getExpedienByRlexcodigoExcodigoAux2 = null;
			if (sanexprel.getExpedienByRlexcodigo() != null
					&& sanexprel.getExpedienByRlexcodigo().getExcodigo() != null) {
				getExpedienByRlexcodigoExcodigoAux2 = sanexprel
						.getExpedienByRlexcodigo().getExcodigo();
			}

			if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
				if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
					Object[] params = { sanexprel.getRlid(),
							sanexprel.getRlinscodrel(),
							sanexprel.getRlinscodigo(),
							sanexprel.getRlexcodrel(),
							getExpedienByRlexcodigoExcodigoAux2,
							sanexprel.getRlhdcodrel(),
							sanexprel.getRlhdcodigo(),
							sanexprel.getRlarbcodrel(),
							sanexprel.getRlarbcodigo(),
							sanexprel.getRlesorig(), sanexprel.getRlfecalta(),
							sanexprel.getRlfecmodif(),
							sanexprel.getRlusualta(), sanexprel.getRlusumodif() };
					querycompleta = Y41bUtils.dameSQL(query, params);
					this.jdbcTemplate.update(query, params);
				} else {
					Object[] params = { sanexprel.getRlid(),
							sanexprel.getRlexcodrel(),
							getExpedienByRlexcodigoExcodigoAux2,
							sanexprel.getRlhdcodrel(),
							sanexprel.getRlhdcodigo(),
							sanexprel.getRlarbcodrel(),
							sanexprel.getRlarbcodigo(),
							sanexprel.getRlesorig(), sanexprel.getRlfecalta(),
							sanexprel.getRlfecmodif(),
							sanexprel.getRlusualta(), sanexprel.getRlusumodif() };
					querycompleta = Y41bUtils.dameSQL(query, params);
					this.jdbcTemplate.update(query, params);
				}

			} else {
				if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
					Object[] params = { sanexprel.getRlid(),
							sanexprel.getRlinscodrel(),
							sanexprel.getRlinscodigo(),
							sanexprel.getRlexcodrel(),
							getExpedienByRlexcodigoExcodigoAux2,
							sanexprel.getRlhdcodrel(),
							sanexprel.getRlhdcodigo(), sanexprel.getRlesorig(),
							sanexprel.getRlfecalta(),
							sanexprel.getRlfecmodif(),
							sanexprel.getRlusualta(), sanexprel.getRlusumodif() };
					querycompleta = Y41bUtils.dameSQL(query, params);
					this.jdbcTemplate.update(query, params);

				} else {
					Object[] params = { sanexprel.getRlid(),
							sanexprel.getRlexcodrel(),
							getExpedienByRlexcodigoExcodigoAux2,
							sanexprel.getRlhdcodrel(),
							sanexprel.getRlhdcodigo(), sanexprel.getRlesorig(),
							sanexprel.getRlfecalta(),
							sanexprel.getRlfecmodif(),
							sanexprel.getRlusualta(), sanexprel.getRlusumodif() };
					querycompleta = Y41bUtils.dameSQL(query, params);
					this.jdbcTemplate.update(query, params);
				}
			}

			return sanexprel;

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en add. sanexprel: " + e.getMessage()
					+ querycompleta, e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return Sanexprel
	 */
	public Sanexprel update(Sanexprel sanexprel) {
		String query = "UPDATE SANEXPREL SET RLEXCODREL=?, RLEXCODIGO=?, RLHDCODREL=?, RLHDCODIGO=?, RLFECALTA=?, RLFECMODIF=?, RLUSUALTA=?, RLUSUMODIF=? WHERE RLID=?";
		Object getExpedienByRlexcodrelExcodigoAux = null;
		if (sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcodigo() != null) {
			getExpedienByRlexcodrelExcodigoAux = sanexprel
					.getExpedienByRlexcodrel().getExcodigo();
		}
		Object getExpedienByRlexcodigoExcodigoAux = null;
		if (sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcodigo() != null) {
			getExpedienByRlexcodigoExcodigoAux = sanexprel
					.getExpedienByRlexcodigo().getExcodigo();
		}
		this.jdbcTemplate.update(query, getExpedienByRlexcodrelExcodigoAux,
				getExpedienByRlexcodigoExcodigoAux, sanexprel.getRlhdcodrel(),
				sanexprel.getRlhdcodigo(), sanexprel.getRlfecalta(),
				sanexprel.getRlfecmodif(), sanexprel.getRlusualta(),
				sanexprel.getRlusumodif(), sanexprel.getRlid());
		return sanexprel;
	}

	/**
	 * Finds a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return Sanexprel
	 */
	@Transactional(readOnly = true)
	public Sanexprel find(Sanexprel sanexprel) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.RLID RLID, t1.RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODIGO RLARBCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLINSCODIGO RLINSCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLFECALTA RLFECALTA, t1.RLFECMODIF RLFECMODIF, t1.RLUSUALTA RLUSUALTA, t1.RLUSUMODIF RLUSUMODIF, t1.RLESORIG RLESORIG, t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE, t3.EXCODIGO EXPEDIENEXCODIGO2, t3.EXCOOR EXPEDIENEXCOOR2, t3.EXNRAN EXPEDIENEXNRAN2, t3.EXNROR EXPEDIENEXNROR2, t3.EXFERE EXPEDIENEXFERE2, t3.EXCOIT EXPEDIENEXCOIT2, t3.EXCOES EXPEDIENEXCOES2, t3.EXFEACIN EXPEDIENEXFEACIN2, t3.EXFEEMCA EXPEDIENEXFEEMCA2, t3.EXFEPLCA EXPEDIENEXFEPLCA2, t3.EXFPNOPC EXPEDIENEXFPNOPC2, t3.EXFEDE EXPEDIENEXFEDE2, t3.EXFECOAL EXPEDIENEXFECOAL2, t3.EXFENOPR EXPEDIENEXFENOPR2, t3.EXFEPUPR EXPEDIENEXFEPUPR2, t3.EXCOOSPR EXPEDIENEXCOOSPR2, t3.EXFEALPR EXPEDIENEXFEALPR2, t3.EXFEEL EXPEDIENEXFEEL2, t3.EXFERES EXPEDIENEXFERES2, t3.EXFENORE EXPEDIENEXFENORE2, t3.EXFEPURE EXPEDIENEXFEPURE2, t3.EXCOOSRE EXPEDIENEXCOOSRE2, t3.EXCOTTR EXPEDIENEXCOTTR2, t3.EXCAMURE EXPEDIENEXCAMURE2, t3.EXFETA EXPEDIENEXFETA2, t3.EXCOTSA EXPEDIENEXCOTSA2, t3.EXFECROI EXPEDIENEXFECROI2, t3.EXFEAR EXPEDIENEXFEAR2, t3.EXCOORIE EXPEDIENEXCOORIE2, t3.EXINRE EXPEDIENEXINRE2, t3.EXINCOCO EXPEDIENEXINCOCO2, t3.EXINEXVA EXPEDIENEXINEXVA2, t3.EXFECIRC EXPEDIENEXFECIRC2, t3.EXFENOAI EXPEDIENEXFENOAI2, t3.EXFECOLM EXPEDIENEXFECOLM2, t3.EXNUINLM EXPEDIENEXNUINLM2, t3.EXFEINMU EXPEDIENEXFEINMU2, t3.EXFEAVMU EXPEDIENEXFEAVMU2, t3.EXFEIMCD EXPEDIENEXFEIMCD2, t3.EXFECEDE EXPEDIENEXFECEDE2, t3.EXCOPS EXPEDIENEXCOPS2, t3.EXCOSE EXPEDIENEXCOSE2 ");
		query.append(", '' CODEXPCOMPLETO, '' MONOMBRE, '' FECHAINI, '' FECHAFIN, '' PCODIGO, '' PNOMBRE, '' PNOMBREE ");
		query.append("FROM SANEXPREL t1 , EXPEDIEN t2 , EXPEDIEN t3 WHERE t1.RLID = ?   AND t1.RLEXCODREL= t2.EXCODIGO(+) AND t1.RLEXCODIGO= t3.EXCODIGO(+)");

		List<Sanexprel> sanexprelList = this.jdbcTemplate.query(
				query.toString(), this.rwMapDefecto, sanexprel.getRlid());
		return (Sanexprel) DataAccessUtils.uniqueResult(sanexprelList);
	}

	/**
	 * Finds a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return Sanexprel
	 */
	@Transactional(readOnly = true)
	public Sanexprel findRel(Sanexprel sanexprel) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.RLID RLID, t1.RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODIGO RLARBCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLINSCODIGO RLINSCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLFECALTA RLFECALTA, t1.RLFECMODIF RLFECMODIF, t1.RLUSUALTA RLUSUALTA, t1.RLUSUMODIF RLUSUMODIF, t1.RLESORIG RLESORIG, t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE, t3.EXCODIGO EXPEDIENEXCODIGO2, t3.EXCOOR EXPEDIENEXCOOR2, t3.EXNRAN EXPEDIENEXNRAN2, t3.EXNROR EXPEDIENEXNROR2, t3.EXFERE EXPEDIENEXFERE2, t3.EXCOIT EXPEDIENEXCOIT2, t3.EXCOES EXPEDIENEXCOES2, t3.EXFEACIN EXPEDIENEXFEACIN2, t3.EXFEEMCA EXPEDIENEXFEEMCA2, t3.EXFEPLCA EXPEDIENEXFEPLCA2, t3.EXFPNOPC EXPEDIENEXFPNOPC2, t3.EXFEDE EXPEDIENEXFEDE2, t3.EXFECOAL EXPEDIENEXFECOAL2, t3.EXFENOPR EXPEDIENEXFENOPR2, t3.EXFEPUPR EXPEDIENEXFEPUPR2, t3.EXCOOSPR EXPEDIENEXCOOSPR2, t3.EXFEALPR EXPEDIENEXFEALPR2, t3.EXFEEL EXPEDIENEXFEEL2, t3.EXFERES EXPEDIENEXFERES2, t3.EXFENORE EXPEDIENEXFENORE2, t3.EXFEPURE EXPEDIENEXFEPURE2, t3.EXCOOSRE EXPEDIENEXCOOSRE2, t3.EXCOTTR EXPEDIENEXCOTTR2, t3.EXCAMURE EXPEDIENEXCAMURE2, t3.EXFETA EXPEDIENEXFETA2, t3.EXCOTSA EXPEDIENEXCOTSA2, t3.EXFECROI EXPEDIENEXFECROI2, t3.EXFEAR EXPEDIENEXFEAR2, t3.EXCOORIE EXPEDIENEXCOORIE2, t3.EXINRE EXPEDIENEXINRE2, t3.EXINCOCO EXPEDIENEXINCOCO2, t3.EXINEXVA EXPEDIENEXINEXVA2, t3.EXFECIRC EXPEDIENEXFECIRC2, t3.EXFENOAI EXPEDIENEXFENOAI2, t3.EXFECOLM EXPEDIENEXFECOLM2, t3.EXNUINLM EXPEDIENEXNUINLM2, t3.EXFEINMU EXPEDIENEXFEINMU2, t3.EXFEAVMU EXPEDIENEXFEAVMU2, t3.EXFEIMCD EXPEDIENEXFEIMCD2, t3.EXFECEDE EXPEDIENEXFECEDE2, t3.EXCOPS EXPEDIENEXCOPS2, t3.EXCOSE EXPEDIENEXCOSE2 ");
		query.append(", '' CODEXPCOMPLETO, '' MONOMBRE, '' FECHAINI, '' FECHAFIN, '' PCODIGO, '' PNOMBRE, '' PNOMBREE ");
		query.append("FROM SANEXPREL t1 , EXPEDIEN t2 , EXPEDIEN t3 WHERE t1.RLHDCODREL = ? AND t1.RLEXCODREL= t2.EXCODIGO(+) AND t1.RLEXCODIGO= t3.EXCODIGO(+) ");

		String campo = "";
		String valor = "";
		if (sanexprel.getRlarbcodigo() != null) {
			campo = "AND RLARBCODIGO = ?";
			valor = sanexprel.getRlarbcodigo();
		} else if (sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcodigo() != null) {

			campo = "AND RLEXCODIGO = ?";
			valor = sanexprel.getExpedienByRlexcodigo().getExcodigo();
		} else {
			campo = "AND 1 = ?";
			valor = "2";
		}
		query.append(campo);

		List<Sanexprel> sanexprelList = this.jdbcTemplate.query(
				query.toString(), this.rwMapDefecto, sanexprel.getRlhdcodrel(),
				valor);
		return (Sanexprel) DataAccessUtils.uniqueResult(sanexprelList);
	}

	/**
	 * Removes a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return
	 */
	public void remove(Sanexprel sanexprel) {
		String query = "DELETE FROM SANEXPREL WHERE RLID=?";
		this.jdbcTemplate.update(query, sanexprel.getRlid());
	}

	/**
	 * Removes a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return
	 */
	public void removeExpedienteSolicitud(Sanexprel sanexprel) {
		String query = "DELETE FROM SANEXPREL WHERE RLHDCODREL=? OR RLHDCODIGO=? ";
		this.jdbcTemplate.update(query, sanexprel.getRlhdcodigo(),
				sanexprel.getRlhdcodigo());
	}

	/**
	 * Removes a single row in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Pagination
	 * @return
	 */
	public void removeExpedienteInspeccion(Sanexprel sanexprel) {
		String query = "DELETE FROM SANEXPREL WHERE RLINSCODREL=? OR RLINSCODIGO=? ";
		this.jdbcTemplate.update(query, sanexprel.getRlinscodigo(),
				sanexprel.getRlinscodigo());
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexprel> findAll(Sanexprel sanexprel, Pagination pagination) {

		StringBuilder query = new StringBuilder("");

		if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, RLINSCODREL, RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and T2.ATCOAC = t4.ACCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_INSPECCIONES + "'");

				// inspecciones

				query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
				query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				query.append("'");

			} else {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, RLINSCODREL, RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");

				query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
				query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				query.append("'");

			}
		} else {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLINSCODREL, RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and T2.ATCOAC = t4.ACCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_INSPECCIONES + "'");
			} else {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
			}

		}
		query.append(")");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapTratado(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				return (List<Sanexprel>) this.jdbcTemplate.query(
						query.toString(), this.rwMap, params.toArray());
			} else {
				return (List<Sanexprel>) this.jdbcTemplate.query(
						query.toString(), this.rwMapConArbSinIns,
						params.toArray());
			}
		} else {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				return (List<Sanexprel>) this.jdbcTemplate.query(
						query.toString(), this.rwMapSinArbConIns,
						params.toArray());
			} else {
				return (List<Sanexprel>) this.jdbcTemplate.query(
						query.toString(), this.rwMapSinArbSinIns,
						params.toArray());
			}
		}

	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoProcedimiento> findAllTipoProcExpedientesRelacionados(
			Sanexprel sanexprel, Pagination pagination) {

		StringBuilder query = new StringBuilder("");

		if (Y41bModuloUtils.getInstance().mostrarArbitraje()
				&& Y41bModuloUtils.getInstance().mostrarControlMercado()) {
			query.append("select distinct PCODIGO, PNOMBRE, PNOMBREE  "
					+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SANCIONES
					+ "'"
					+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
			query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
			query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			query.append("'");
			query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and t4.ACCODIGO = t2.ATCOAC and t5.PCODIGO ='");
			query.append(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			query.append("'");
		} else if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			query.append("select distinct PCODIGO, PNOMBRE, PNOMBREE  "
					+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SANCIONES
					+ "'"
					+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
			query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
			query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			query.append("'");
		} else if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
			query.append("select distinct PCODIGO, PNOMBRE, PNOMBREE  "
					+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SANCIONES
					+ "'"
					+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
			query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and t4.ACCODIGO = t2.ATCOAC and t5.PCODIGO ='");
			query.append(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			query.append("'");

		} else {
			query.append("select distinct PCODIGO, PNOMBRE, PNOMBREE  "
					+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SANCIONES
					+ "'"
					+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
		}
		query.append(")");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapExpedientesrelacionados(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<TipoProcedimiento>() {
					public TipoProcedimiento mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TipoProcedimiento(resultSet
								.getString("PCODIGO"), resultSet
								.getString("PNOMBRE"), resultSet
								.getString("PNOMBREE"), null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoProcedimiento> findAllTipoProcExpedientesRelacionados2(
			Sanexprel sanexprel, Pagination pagination) {

		StringBuilder query = new StringBuilder("");

		String arbitrajeSelect = "'' RLARBCODREL, '' RLARBCODIGO, ";
		String controlMercadoSelect = "'' RLINSCODREL, '' RLINSCODIGO, ";
		String arbitrajeUnion = "";
		String controlMercadoUnion = "";
		if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			arbitrajeSelect = "RLARBCODREL, RLARBCODIGO, ";
			arbitrajeUnion = " union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
					+ arbitrajeSelect
					+ " "
					+ controlMercadoSelect
					+ " t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_ARBITRAJE + "'";
		}
		if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
			controlMercadoSelect = "RLINSCODREL, RLINSCODIGO, ";
			controlMercadoUnion = " union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
					+ arbitrajeSelect
					+ " "
					+ controlMercadoSelect
					+ " t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and t4.ACCODIGO = t2.ATCOAC and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_INSPECCIONES + "'";
		}

		query.append("select distinct PCODIGO, PNOMBRE, PNOMBREE  "
				+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
				+ arbitrajeSelect
				+ "  "
				+ controlMercadoSelect
				+ " t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
				+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
				+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
				+ Y41bConstantes.TIPO_PROC_SANCIONES
				+ "'"
				+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
				+ arbitrajeSelect
				+ "  "
				+ controlMercadoSelect
				+ " t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
				+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
				+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
				+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
		query.append(arbitrajeUnion);
		query.append(controlMercadoUnion);
		query.append(")");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapExpedientesrelacionados(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipoProcedimiento>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<TipoProcedimiento>() {
					public TipoProcedimiento mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new TipoProcedimiento(resultSet
								.getString("PCODIGO"), resultSet
								.getString("PNOMBRE"), resultSet
								.getString("PNOMBREE"), null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexprel> findAllNumExpedientesExpedientesRelacionados(
			Sanexprel sanexprel, Pagination pagination) {

		StringBuilder query = new StringBuilder("");

		if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
					+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SANCIONES
					+ "'"
					+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
			query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
			query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			query.append("'");
		} else {
			query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, '' RLINSCODREL, '' RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
					+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SANCIONES
					+ "'"
					+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
					+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
					+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
		}
		query.append(")");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapExpedientesrelacionados(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanexprel>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexprel> findAllNumExpedientesExpedientesRelacionados2(
			Sanexprel sanexprel, Pagination pagination) {

		StringBuilder query = new StringBuilder("");

		String arbitrajeSelect = "'' RLARBCODREL, '' RLARBCODIGO, ";
		String controlMercadoSelect = "'' RLINSCODREL, '' RLINSCODIGO, ";
		String arbitrajeUnion = "";
		String controlMercadoUnion = "";
		if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			arbitrajeSelect = "RLARBCODREL, RLARBCODIGO, ";
			arbitrajeUnion = " union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
					+ arbitrajeSelect
					+ " "
					+ controlMercadoSelect
					+ " t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_ARBITRAJE + "'";
		}
		if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
			controlMercadoSelect = "RLINSCODREL, RLINSCODIGO, ";
			controlMercadoUnion = " union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
					+ arbitrajeSelect
					+ " "
					+ controlMercadoSelect
					+ " t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and t4.ACCODIGO = t2.ATCOAC and t5.PCODIGO ='"
					+ Y41bConstantes.TIPO_PROC_INSPECCIONES + "'";
		}

		query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, "
				+ arbitrajeSelect
				+ " "
				+ controlMercadoSelect
				+ " CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
				+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
				+ arbitrajeSelect
				+ " "
				+ controlMercadoSelect
				+ " t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
				+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
				+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
				+ Y41bConstantes.TIPO_PROC_SANCIONES
				+ "'"
				+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, "
				+ arbitrajeSelect
				+ " "
				+ controlMercadoSelect
				+ " t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
				+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
				+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
				+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
		query.append(arbitrajeUnion);
		query.append(controlMercadoUnion);
		query.append(")");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapExpedientesrelacionados(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanexprel>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanexprel table.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanexprel sanexprel) {
		StringBuilder query = new StringBuilder("");
		if (Y41bModuloUtils.getInstance().mostrarArbitraje()) {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, RLINSCODREL, RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and T2.ATCOAC = t4.ACCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_INSPECCIONES + "'");

				// inspecciones

				query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
				query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				query.append("'");

			} else {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, RLINSCODREL, RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");

				query.append(" union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLARBCODIGO RLARBCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.SACOJA || '-' || t2.SANROR || '-' || t2.SANRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.SAFESOLI FECHAINI, t4.EXFECFIN AS FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE from SANEXPREL t1, SOLARB t2, CENSO_MONITOR t3, ARBEXP t4, TIPO_PROCEDIMIENTO t5 where t1.RLARBCODREL= t2.SACODIGO AND t2.SACODIGO = t4.EXCODIGO(+) AND t4.EXMOCODIGO = t3.MOCODIGO(+) AND t5.PCODIGO ='");
				query.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				query.append("'");

			}
		} else {
			if (Y41bModuloUtils.getInstance().mostrarControlMercado()) {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLINSCODREL, RLINSCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, t1.RLINSCODREL RLINSCODREL, t1.RLINSCODIGO RLINSCODIGO, t4.ACCOOR || '-' || t4.ACNROR || '-' || t4.ACNRAN || '-' || t2.ATNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.ACFERE FECHAINI, t2.ATFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, ACTUACION t2, CENSO_MONITOR t3, ACTA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLINSCODREL= t2.ATCODIGO and t4.ACCOMO = t3.MOCODIGO(+) and T2.ATCOAC = t4.ACCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_INSPECCIONES + "'");
			} else {
				query.append("select RLID, RLEXCODIGO, RLEXCODREL, RLHDCODREL, RLHDCODIGO, RLARBCODREL, RLARBCODIGO, CODEXPCOMPLETO, RLESORIG, MONOMBRE, FECHAINI, FECHAFIN, PCODIGO, PNOMBRE, PNOMBREE "
						+ " from (select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t2.EXCOOR || '-' || t2.EXNROR || '-' || t2.EXNRAN CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t2.EXFERE FECHAINI, t4.EXFECFIN as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ " from SANEXPREL t1, EXPEDIEN t2, CENSO_MONITOR t3, SANEXP t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLEXCODREL= t2.EXCODIGO and t2.EXCODIGO = t4.EXCODIGO(+) and t2.EXCOIT = t3.MOCODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SANCIONES
						+ "'"
						+ "union select t1.RLID RLID, t1.RLEXCODIGO RLEXCODIGO, t1.RLEXCODREL RLEXCODREL, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO, '' RLARBCODREL, '' RLARBCODIGO, t4.DECOOR || '-' || t4.DENROR || '-' || t4.DENRAN || '-' || t2.HDNROR CODEXPCOMPLETO, t1.RLESORIG RLESORIG, t3.MONOMBRE MONOMBRE, t4.DEFERE FECHAINI, t2.HDFECHACIERRE as FECHAFIN, t5.PCODIGO PCODIGO, t5.PNOMBRE PNOMBRE, t5.PNOMBREE PNOMBREE "
						+ "from SANEXPREL t1, HECHO_DENUNCIADO t2, CENSO_MONITOR t3, DENUNCIA t4, TIPO_PROCEDIMIENTO t5 "
						+ "where t1.RLHDCODREL= t2.HDCODIGO and t2.HDCOMO = t3.MOCODIGO(+) and T2.HDCODE = t4.DECODIGO and t5.PCODIGO ='"
						+ Y41bConstantes.TIPO_PROC_SOLICITUDES + "'");
			}

		}
		query.append(")");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapTratado(sanexprel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		String querycount = "SELECT COUNT(distinct RLID) FROM ( ";
		querycount = querycount.concat(query.toString()).concat(" )");
		return this.jdbcTemplate.queryForLong(querycount, params.toArray());
	}

	/**
	 * Finds rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexprel> findAllLike(Sanexprel sanexprel,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RLID RLID,t1.RLEXCODIGO RLEXCODIGO, t1.RLHDCODREL RLHDCODREL, t1.RLHDCODIGO RLHDCODIGO,t1.RLARBCODIGO RLARBCODIGO, t1.RLARBCODREL RLARBCODREL, t1.RLINSCODIGO RLINSCODIGO, t1.RLINSCODREL RLINSCODREL,t1.RLFECALTA RLFECALTA,t1.RLFECMODIF RLFECMODIF,t1.RLUSUALTA RLUSUALTA,t1.RLUSUMODIF RLUSUMODIF,t1.RLESORIG RLESORIG, t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.EXCODIGO EXPEDIENEXCODIGO2,t3.EXCOOR EXPEDIENEXCOOR2,t3.EXNRAN EXPEDIENEXNRAN2,t3.EXNROR EXPEDIENEXNROR2,t3.EXFERE EXPEDIENEXFERE2,t3.EXCOIT EXPEDIENEXCOIT2,t3.EXCOES EXPEDIENEXCOES2,t3.EXFEACIN EXPEDIENEXFEACIN2,t3.EXFEEMCA EXPEDIENEXFEEMCA2,t3.EXFEPLCA EXPEDIENEXFEPLCA2,t3.EXFPNOPC EXPEDIENEXFPNOPC2,t3.EXFEDE EXPEDIENEXFEDE2,t3.EXFECOAL EXPEDIENEXFECOAL2,t3.EXFENOPR EXPEDIENEXFENOPR2,t3.EXFEPUPR EXPEDIENEXFEPUPR2,t3.EXCOOSPR EXPEDIENEXCOOSPR2,t3.EXFEALPR EXPEDIENEXFEALPR2,t3.EXFEEL EXPEDIENEXFEEL2,t3.EXFERES EXPEDIENEXFERES2,t3.EXFENORE EXPEDIENEXFENORE2,t3.EXFEPURE EXPEDIENEXFEPURE2,t3.EXCOOSRE EXPEDIENEXCOOSRE2,t3.EXCOTTR EXPEDIENEXCOTTR2,t3.EXCAMURE EXPEDIENEXCAMURE2,t3.EXFETA EXPEDIENEXFETA2,t3.EXCOTSA EXPEDIENEXCOTSA2,t3.EXFECROI EXPEDIENEXFECROI2,t3.EXFEAR EXPEDIENEXFEAR2,t3.EXCOORIE EXPEDIENEXCOORIE2,t3.EXINRE EXPEDIENEXINRE2,t3.EXINCOCO EXPEDIENEXINCOCO2,t3.EXINEXVA EXPEDIENEXINEXVA2,t3.EXFECIRC EXPEDIENEXFECIRC2,t3.EXFENOAI EXPEDIENEXFENOAI2,t3.EXFECOLM EXPEDIENEXFECOLM2,t3.EXNUINLM EXPEDIENEXNUINLM2,t3.EXFEINMU EXPEDIENEXFEINMU2,t3.EXFEAVMU EXPEDIENEXFEAVMU2,t3.EXFEIMCD EXPEDIENEXFEIMCD2,t3.EXFECEDE EXPEDIENEXFECEDE2,t3.EXCOPS EXPEDIENEXCOPS2,t3.EXCOSE EXPEDIENEXCOSE2 ");
		query.append("FROM SANEXPREL t1 ,EXPEDIEN t2 ,EXPEDIEN t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanexprel, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RLEXCODREL= t2.EXCODIGO(+) AND t1.RLEXCODIGO= t3.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanexprel>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDefecto, params.toArray());
	}

	/**
	 * Counts rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanexprel sanexprel, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANEXPREL t1 ,EXPEDIEN t2 ,EXPEDIEN t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanexprel, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RLEXCODREL= t2.EXCODIGO(+) AND t1.RLEXCODIGO= t3.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanexprel entity
	 * 
	 * @param sanexprel
	 *            Sanexprel Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapExpedientesrelacionados(
			Sanexprel sanexprel) {

		StringBuilder where = new StringBuilder(
				SanexprelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcodigo() != null) {
			where.append(" AND RLEXCODIGO = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExcodigo());
		}

		if (sanexprel != null && sanexprel.getRlhdcodigo() != null) {
			where.append(" AND RLHDCODIGO = ?");
			params.add(sanexprel.getRlhdcodigo());
		}

		if (sanexprel != null && sanexprel.getRlarbcodigo() != null) {
			where.append(" AND RLARBCODIGO = ?");
			params.add(sanexprel.getRlarbcodigo());
		}

		if (sanexprel != null && sanexprel.getRlinscodigo() != null) {
			where.append(" AND RLINSCODIGO = ?");
			params.add(sanexprel.getRlinscodigo());
		}

		if (sanexprel != null && sanexprel.getTipoProcedimiento() != null
				&& sanexprel.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND PCODIGO = ?");
			params.add(sanexprel.getTipoProcedimiento().getPcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanexprel entity
	 * 
	 * @param sanexprel
	 *            Sanexprel Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapTratado(Sanexprel sanexprel) {

		StringBuilder where = new StringBuilder(
				SanexprelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcodigo() != null) {
			where.append(" AND RLEXCODIGO = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExcodigo());
		}

		if (sanexprel != null && sanexprel.getRlhdcodigo() != null) {
			where.append(" AND RLHDCODIGO = ?");
			params.add(sanexprel.getRlhdcodigo());
		}

		if (sanexprel != null && sanexprel.getRlinscodigo() != null) {
			where.append(" AND RLINSCODIGO = ?");
			params.add(sanexprel.getRlinscodigo());
		}

		if (sanexprel != null && sanexprel.getRlarbcodigo() != null) {
			where.append(" AND RLARBCODIGO = ?");
			params.add(sanexprel.getRlarbcodigo());
		}

		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcodigo() != null) {
			where.append(" AND RLEXCODREL = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExcodigo());
		}

		if (sanexprel != null && sanexprel.getRlhdcodrel() != null) {
			where.append(" AND RLHDCODREL = ?");
			params.add(sanexprel.getRlhdcodrel());
		}

		if (sanexprel != null && sanexprel.getRlinscodrel() != null) {
			where.append(" AND RLINSCODREL = ?");
			params.add(sanexprel.getRlinscodrel());
		}

		if (sanexprel != null && sanexprel.getRlarbcodrel() != null) {
			where.append(" AND RLARBCODREL = ?");
			params.add(sanexprel.getRlarbcodrel());
		}

		if (sanexprel != null && sanexprel.getRlesorig() != null) {
			where.append(" AND RLESORIG = ?");
			params.add(sanexprel.getRlesorig());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanexprel entity
	 * 
	 * @param sanexprel
	 *            Sanexprel Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanexprel sanexprel,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanexprelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanexprel != null && sanexprel.getRlid() != null) {
			where.append(" AND UPPER(t1.RLID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getRlid().toUpperCase() + "%");
			} else {
				params.add("%" + sanexprel.getRlid().toUpperCase() + "%");
			}
			where.append(" AND t1.RLID IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExcodigo());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExnran());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExnror());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfere());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcoit()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcoit()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcoes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcoes()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeacin());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeemca());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeplca());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfpnopc());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfede());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfecoal());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfenopr());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfepupr());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcoospr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcoospr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfealpr());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeel());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExferes());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfenore());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfepure());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcoosre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcoosre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcottr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcottr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExcamure());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeta());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcotsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcotsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfecroi());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfear());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcoorie()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcoorie()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExinre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExinre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExincoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExincoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExinexva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExinexva()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfecirc());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfenoai());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfecolm());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExnuinlm()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExnuinlm()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeinmu());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeavmu());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfeimcd());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(sanexprel.getExpedienByRlexcodrel().getExfecede());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getExcose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getExcose()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (sanexprel != null
				&& sanexprel.getExpedienByRlexcodrel() != null
				&& sanexprel.getExpedienByRlexcodrel().getSanexp() != null
				&& sanexprel.getExpedienByRlexcodrel().getSanexp()
						.getExcodigo() != null) {
			where.append(" AND UPPER(t2.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodrel().getSanexp()
						.getExcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodrel().getSanexp()
								.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCODIGO IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcodigo() != null) {
			where.append(" AND t3.EXCODIGO = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExcodigo());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcoor() != null) {
			where.append(" AND UPPER(t3.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOOR IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExnran() != null) {
			where.append(" AND t3.EXNRAN = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExnran());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExnror() != null) {
			where.append(" AND t3.EXNROR = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExnror());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfere() != null) {
			where.append(" AND t3.EXFERE = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfere());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcoit() != null) {
			where.append(" AND UPPER(t3.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcoit()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcoit()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOIT IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcoes() != null) {
			where.append(" AND UPPER(t3.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcoes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcoes()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOES IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeacin() != null) {
			where.append(" AND t3.EXFEACIN = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeacin());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeemca() != null) {
			where.append(" AND t3.EXFEEMCA = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeemca());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeplca() != null) {
			where.append(" AND t3.EXFEPLCA = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeplca());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfpnopc() != null) {
			where.append(" AND t3.EXFPNOPC = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfpnopc());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfede() != null) {
			where.append(" AND t3.EXFEDE = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfede());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfecoal() != null) {
			where.append(" AND t3.EXFECOAL = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfecoal());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfenopr() != null) {
			where.append(" AND t3.EXFENOPR = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfenopr());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfepupr() != null) {
			where.append(" AND t3.EXFEPUPR = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfepupr());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcoospr() != null) {
			where.append(" AND UPPER(t3.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcoospr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcoospr()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOOSPR IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfealpr() != null) {
			where.append(" AND t3.EXFEALPR = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfealpr());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeel() != null) {
			where.append(" AND t3.EXFEEL = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeel());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExferes() != null) {
			where.append(" AND t3.EXFERES = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExferes());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfenore() != null) {
			where.append(" AND t3.EXFENORE = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfenore());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfepure() != null) {
			where.append(" AND t3.EXFEPURE = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfepure());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcoosre() != null) {
			where.append(" AND UPPER(t3.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcoosre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcoosre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOOSRE IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcottr() != null) {
			where.append(" AND UPPER(t3.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcottr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcottr()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOTTR IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcamure() != null) {
			where.append(" AND t3.EXCAMURE = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExcamure());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeta() != null) {
			where.append(" AND t3.EXFETA = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeta());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcotsa() != null) {
			where.append(" AND UPPER(t3.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcotsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcotsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOTSA IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfecroi() != null) {
			where.append(" AND t3.EXFECROI = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfecroi());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfear() != null) {
			where.append(" AND t3.EXFEAR = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfear());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcoorie() != null) {
			where.append(" AND UPPER(t3.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcoorie()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcoorie()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOORIE IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExinre() != null) {
			where.append(" AND UPPER(t3.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExinre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExinre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXINRE IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExincoco() != null) {
			where.append(" AND UPPER(t3.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExincoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExincoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXINCOCO IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExinexva() != null) {
			where.append(" AND UPPER(t3.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExinexva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExinexva()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXINEXVA IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfecirc() != null) {
			where.append(" AND t3.EXFECIRC = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfecirc());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfenoai() != null) {
			where.append(" AND t3.EXFENOAI = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfenoai());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfecolm() != null) {
			where.append(" AND t3.EXFECOLM = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfecolm());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExnuinlm() != null) {
			where.append(" AND UPPER(t3.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExnuinlm()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExnuinlm()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXNUINLM IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeinmu() != null) {
			where.append(" AND t3.EXFEINMU = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeinmu());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeavmu() != null) {
			where.append(" AND t3.EXFEAVMU = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeavmu());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfeimcd() != null) {
			where.append(" AND t3.EXFEIMCD = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfeimcd());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExfecede() != null) {
			where.append(" AND t3.EXFECEDE = ?");
			params.add(sanexprel.getExpedienByRlexcodigo().getExfecede());
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcops() != null) {
			where.append(" AND UPPER(t3.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcops()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOPS IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getExcose() != null) {
			where.append(" AND UPPER(t3.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getExcose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getExcose()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOSE IS NOT NULL");
		}
		if (sanexprel != null
				&& sanexprel.getExpedienByRlexcodigo() != null
				&& sanexprel.getExpedienByRlexcodigo().getSanexp() != null
				&& sanexprel.getExpedienByRlexcodigo().getSanexp()
						.getExcodigo() != null) {
			where.append(" AND UPPER(t3.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getExpedienByRlexcodigo().getSanexp()
						.getExcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanexprel.getExpedienByRlexcodigo().getSanexp()
								.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.EXCODIGO IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getRlhdcodrel() != null) {
			where.append(" AND UPPER(t1.RLHDCODREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getRlhdcodrel().toUpperCase() + "%");
			} else {
				params.add("%" + sanexprel.getRlhdcodrel().toUpperCase() + "%");
			}
			where.append(" AND t1.RLHDCODREL IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getRlhdcodigo() != null) {
			where.append(" AND UPPER(t1.RLHDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getRlhdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexprel.getRlhdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.RLHDCODIGO IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getRlfecalta() != null) {
			where.append(" AND t1.RLFECALTA = ?");
			params.add(sanexprel.getRlfecalta());
		}
		if (sanexprel != null && sanexprel.getRlfecmodif() != null) {
			where.append(" AND t1.RLFECMODIF = ?");
			params.add(sanexprel.getRlfecmodif());
		}
		if (sanexprel != null && sanexprel.getRlusualta() != null) {
			where.append(" AND UPPER(t1.RLUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getRlusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanexprel.getRlusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.RLUSUALTA IS NOT NULL");
		}
		if (sanexprel != null && sanexprel.getRlusumodif() != null) {
			where.append(" AND UPPER(t1.RLUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getRlusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanexprel.getRlusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.RLUSUMODIF IS NOT NULL");
		}

		if (sanexprel != null && sanexprel.getRlesorig() != null) {
			where.append(" AND UPPER(t1.RLESORIG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexprel.getRlesorig().toUpperCase() + "%");
			} else {
				params.add("%" + sanexprel.getRlesorig().toUpperCase() + "%");
			}
			where.append(" AND t1.RLESORIG IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findArbitrajeRelacionadoCount(Sanexprel sanexprel) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANEXPREL t1  ");
		List<Object> params = new ArrayList<Object>();
		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE t1.RLARBCODIGO IS NOT NULL ");
		where.append(" AND t1.RLHDCODREL=? ");

		where.append(" AND ( t1.RLESORIG=? OR t1.RLESORIG=?) ");

		query.append(where.toString());
		params.add(sanexprel.getRlhdcodrel());
		params.add(Y41bConstantes.TIPO_ARB_EXPREL_ORIGEN);
		params.add(Y41bConstantes.TIPO_ARB_EXPREL_ACUMULADO);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSancionadorRelacionadoSolicitudesCount(Sanexprel sanexprel) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANEXPREL t1  ");
		List<Object> params = new ArrayList<Object>();
		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE t1.RLEXCODIGO IS NOT NULL ");
		where.append(" AND t1.RLHDCODREL=? ");

		where.append(" AND ( t1.RLESORIG=? OR t1.RLESORIG=?) ");

		query.append(where.toString());
		params.add(sanexprel.getRlhdcodrel());
		params.add(Y41bConstantes.TIPO_ARB_EXPREL_ORIGEN);
		params.add(Y41bConstantes.TIPO_ARB_EXPREL_ACUMULADO);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Sanexprel table using like.
	 * 
	 * @param sanexprel
	 *            Sanexprel
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSancionadorRelacionadoInspeccionesCount(
			Sanexprel sanexprel, Establecimiento establecimiento) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANEXPREL t1, SANINTERV t2  ");
		List<Object> params = new ArrayList<Object>();
		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE t1.RLEXCODIGO IS NOT NULL ");
		where.append(" AND t1.RLEXCODIGO = t2.UAEXCODIGO ");
		where.append(" AND t2.UAESCODIGO = ? ");
		where.append(" AND t2.UATIPOINTERV = ? ");
		where.append(" AND t1.RLINSCODREL=? ");

		where.append(" AND ( t1.RLESORIG=? OR t1.RLESORIG=?) ");

		query.append(where.toString());
		params.add(establecimiento.getEscodigo());
		params.add(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
		params.add(sanexprel.getRlinscodrel());
		params.add(Y41bConstantes.TIPO_ARB_EXPREL_ORIGEN);
		params.add(Y41bConstantes.TIPO_ARB_EXPREL_ACUMULADO);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
