package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanexpDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class SanexpDaoImpl implements SanexpDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(SanexpDaoImpl.class);

	private RowMapper<Sanexp> rwMap = new RowMapper<Sanexp>() {

		public Sanexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Fase fase = new Fase(resultSet.getString("FASEFCODIGO"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);
			Santramexp santramexp = new Santramexp(resultSet.getString("SantramexpTRID"),
					resultSet.getString("SantramexpTRCODIGO"), resultSet.getDate("SantramexpTRFECINI"),
					resultSet.getDate("SantramexpTRFECFIN"),
					/* resultSet.getString("SantramexpTROBSERVES") */null, resultSet.getString("SantramexpTRNOMTRAMES"),
					resultSet.getString("SantramexpTRTRIDREL"), resultSet.getDate("SantramexpTRFECACINI"),
					resultSet.getBigDecimal("SantramexpTRRESULTADO"), resultSet.getString("SantramexpTRESTIMACION"),
					resultSet.getDate("SantramexpTRRESOFECHA"), resultSet.getString("SantramexpTRRESOTIPO"),
					resultSet.getBigDecimal("SantramexpTRRESOSAN"), resultSet.getBigDecimal("SantramexpTRRESOIMPORTE"),
					resultSet.getDate("SantramexpTRFECREGS"), resultSet.getString("SantramexpTRESTADOACUSE"),
					resultSet.getString("SantramexpTRNUMREGS"), resultSet.getString("SantramexpTRNUMREGE"),
					resultSet.getString("SantramexpTRTIPOCOM"), resultSet.getDate("SantramexpTRFECENVIO"),
					resultSet.getDate("SantramexpTRFECCIERRE"), null, resultSet.getBigDecimal("TRNUMDIAS"),
					resultSet.getDate("SantramexpTRFECALTA"), resultSet.getDate("SantramexpTRFECMODIF"), null, null,
					null, resultSet.getString("SantramexpTRUSUALTA"), resultSet.getString("SantramexpTRUSUMODIF"),
					new Expedien(resultSet.getString("SantramexpTREXCODIGO"), null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null),
					fase, null, null, null);

			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(resultSet.getString("HDCODIGO"));
			Sanexp sanexp = new Sanexp(resultSet.getString("EXCODIGO"), null, resultSet.getString("EXFOLDERID"),
					resultSet.getString("EXDESCES"), resultSet.getString("EXDESCEU"), resultSet.getDate("EXFECPREVFIN"),
					resultSet.getDate("EXFECFIN"), resultSet.getString("EXCALIF"), resultSet.getString("EXIMPORTE"),
					resultSet.getString("EXRECURSO"), resultSet.getString("EXORDEN"), resultSet.getString("EXTIPRES"),
					resultSet.getString("EXCAJA1"), resultSet.getString("EXCAJA2"), resultSet.getString("EXMOCODIGO"),
					null, fase, resultSet.getString("EXMOCODIGOULT"), resultSet.getDate("EXFECPROPRESO"),
					resultSet.getDate("EXFECALTA"), resultSet.getDate("EXFECMODIF"), resultSet.getString("EXUSUALTA"),
					resultSet.getString("EXUSUMODIF"), resultSet.getString("EXLIQESTADO"),
					resultSet.getString("EXLIQAPREMIO"), santramexp, null, hechoDenunciado,
					resultSet.getDate("HDFECHD"), null, new Motivo(resultSet.getString("HDCOTIR"), null, null),
					new Producto(resultSet.getString("HDCOPS")), resultSet.getString("TIPOPROC"),
					resultSet.getDate("EXFECENVIO"), resultSet.getDate("EXFECREOR"),
					resultSet.getString("EXESTIMACION"), resultSet.getDate("EXFECPRESCR"));

			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			sanexp.setPlatea(resultSet.getString("PLATEA"));
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));
			return sanexp;
		}
	};

	private RowMapper<Sanexp> rwMapDetalleExpediente = new RowMapper<Sanexp>() {

		public Sanexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Fase fase = new Fase(resultSet.getString("FASEFCODIGO"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);

			Tramite tramite = new Tramite(resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);
			Tramite tramiteEnt = new Tramite(resultSet.getString("TRCODIGOENT"), resultSet.getString("TRNOMBREENT"),
					resultSet.getString("TRNOMBREEENT"), null, null, null, null, null, null);

			Santramexp santramexp = new Santramexp(resultSet.getString("SantramexpTRID"),
					resultSet.getString("SantramexpTRCODIGO"), resultSet.getDate("SantramexpTRFECINI"),
					resultSet.getDate("SantramexpTRFECFIN"),
					/* resultSet.getString("SantramexpTROBSERVES") */null, resultSet.getString("SantramexpTRNOMTRAMES"),
					resultSet.getString("SantramexpTRTRIDREL"), resultSet.getDate("SantramexpTRFECACINI"),
					resultSet.getBigDecimal("SantramexpTRRESULTADO"), resultSet.getString("SantramexpTRESTIMACION"),
					resultSet.getDate("SantramexpTRRESOFECHA"), resultSet.getString("SantramexpTRRESOTIPO"),
					resultSet.getBigDecimal("SantramexpTRRESOSAN"), resultSet.getBigDecimal("SantramexpTRRESOIMPORTE"),
					resultSet.getDate("SantramexpTRFECREGS"), resultSet.getString("SantramexpTRESTADOACUSE"),
					resultSet.getString("SantramexpTRNUMREGS"), resultSet.getString("SantramexpTRNUMREGE"),
					resultSet.getString("SantramexpTRTIPOCOM"), resultSet.getDate("SantramexpTRFECENVIO"),
					resultSet.getDate("SantramexpTRFECCIERRE"), null, resultSet.getBigDecimal("TRNUMDIAS"),
					resultSet.getDate("SantramexpTRFECALTA"), resultSet.getDate("SantramexpTRFECMODIF"), null, null,
					null, resultSet.getString("SantramexpTRUSUALTA"), resultSet.getString("SantramexpTRUSUMODIF"),
					new Expedien(resultSet.getString("SantramexpTREXCODIGO"), null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null),
					fase, null, null, tramite);

			Santramexp santramexpEntidad = new Santramexp(resultSet.getString("SantramexpTRIDENT"),
					resultSet.getString("SantramexpTRCODIGOENT"), resultSet.getDate("SantramexpTRFECINIENT"),
					resultSet.getDate("SantramexpTRFECFINENT"),
					/* resultSet.getString("SantramexpTROBSERVESENT") */null,
					resultSet.getString("SantramexpTRNOMTRAMESENT"), resultSet.getString("SantramexpTRTRIDRELENT"),
					resultSet.getDate("SantramexpTRFECACINIENT"), resultSet.getBigDecimal("SantramexpTRRESULTADOENT"),
					resultSet.getString("SantramexpTRESTIMACIONENT"), resultSet.getDate("SantramexpTRRESOFECHAENT"),
					resultSet.getString("SantramexpTRRESOTIPOENT"), resultSet.getBigDecimal("SantramexpTRRESOSANENT"),
					resultSet.getBigDecimal("SantramexpTRRESOIMPORTEENT"), resultSet.getDate("SantramexpTRFECREGSENT"),
					resultSet.getString("SantramexpTRESTADOACUSEENT"), resultSet.getString("SantramexpTRNUMREGSENT"),
					resultSet.getString("SantramexpTRNUMREGEENT"), resultSet.getString("SantramexpTRTIPOCOMENT"),
					resultSet.getDate("SantramexpTRFECENVIOENT"), resultSet.getDate("SantramexpTRFECCIERREENT"), null,
					resultSet.getBigDecimal("TRNUMDIASENT"), resultSet.getDate("SantramexpTRFECALTAENT"),
					resultSet.getDate("SantramexpTRFECMODIFENT"), null, null, null,
					resultSet.getString("SantramexpTRUSUALTAENT"), resultSet.getString("SantramexpTRUSUMODIFENT"),
					new Expedien(resultSet.getString("SantramexpTREXCODIGOENT"), null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null),
					fase, null, null, tramiteEnt);
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(resultSet.getString("HDCODIGO"));

			Sanexp sanexp = new Sanexp(resultSet.getString("EXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getString("EXFOLDERID"), resultSet.getString("EXDESCES"), resultSet.getString("EXDESCEU"),
					resultSet.getDate("EXFECPREVFIN"), resultSet.getDate("EXFECFIN"), resultSet.getString("EXCALIF"),
					resultSet.getString("EXIMPORTE"), resultSet.getString("EXRECURSO"), resultSet.getString("EXORDEN"),
					resultSet.getString("EXTIPRES"), resultSet.getString("EXCAJA1"), resultSet.getString("EXCAJA2"),
					resultSet.getString("EXMOCODIGO"), resultSet.getString("MONOMBRE"), fase,
					resultSet.getString("EXMOCODIGOULT"), resultSet.getDate("EXFECPROPRESO"),
					resultSet.getDate("EXFECALTA"), resultSet.getDate("EXFECMODIF"), resultSet.getString("EXUSUALTA"),
					resultSet.getString("EXUSUMODIF"), resultSet.getString("EXLIQESTADO"),
					resultSet.getString("EXLIQAPREMIO"), santramexp, santramexpEntidad, hechoDenunciado,
					resultSet.getDate("HDFECHD"), null, new Motivo(resultSet.getString("HDCOTIR"), null, null),
					new Producto(resultSet.getString("HDCOPS")), resultSet.getString("TIPOPROC"),
					resultSet.getDate("EXFECENVIO"), resultSet.getDate("EXFECREOR"),
					resultSet.getString("EXESTIMACION"), resultSet.getDate("EXFECPRESCR"));
			sanexp.setExcooractual(resultSet.getString("EXCOORACTUAL"));
			sanexp.setPlatea(resultSet.getString("PLATEA"));
			sanexp.setExdestnotifsancionado(resultSet.getString("EXDESTNOTIFSANCIONADO"));
			sanexp.setExverifsanc(resultSet.getString("EXVERIFSANC"));
			sanexp.setExverifinco(resultSet.getString("EXVERIFINCO"));
			sanexp.setExidparticipacionsancionado(resultSet.getString("EXIDPARTICIPACIONSANCIONADO"));
			sanexp.setExhdformanotiforigen(resultSet.getString("EXHDFORMANOTIFORIGEN"));
			return sanexp;
		}
	};

	private RowMapper<Sanexp> rwMapPKExpediente = new RowMapper<Sanexp>() {

		public Sanexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Sanexp sanexp = new Sanexp(resultSet.getString("EXCODIGO"));

			return sanexp;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	public Sanexp add(Sanexp sanexp) {
		try {
			String query = "INSERT INTO SANEXP (EXCODIGO, EXTRPOSCOD, EXTRENTIDAD, EXFOLDERID, EXDESCES, EXDESCEU, EXFECPREVFIN, EXFECFIN, EXCALIF, EXIMPORTE, EXRECURSO, EXORDEN, EXTIPRES, EXCAJA1, EXCAJA2, EXMOCODIGO, EXFCODIGO, EXMOCODIGOULT, EXFECALTA, EXFECMODIF, EXUSUALTA, EXUSUMODIF, EXFECPRESCR,EXCOORACTUAL,EXDESTNOTIFSANCIONADO,EXVERIFSANC,EXVERIFINCO, EXHDFORMANOTIFORIGEN) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			Object getSantramexpTridAux = null;
			Object getSantramexpEntidadTridAux = null;
			if (sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrid() != null) {
				getSantramexpTridAux = sanexp.getSantramexp().getTrid();
			}
			if (sanexp.getSantramexpEntidad() != null && sanexp.getSantramexpEntidad().getTrid() != null) {
				getSantramexpEntidadTridAux = sanexp.getSantramexpEntidad().getTrid();
			}

			Object getFaseTridAux = null;
			if (sanexp.getFase() != null && sanexp.getFase().getFcodigo() != null) {
				getFaseTridAux = sanexp.getFase().getFcodigo();
			}

			this.jdbcTemplate.update(query, sanexp.getExcodigo(), getSantramexpTridAux, getSantramexpEntidadTridAux,
					sanexp.getExfolderid(), sanexp.getExdesces(), sanexp.getExdesceu(), sanexp.getExfecprevfin(),
					sanexp.getExfecfin(), sanexp.getExcalif(), sanexp.getEximporte(), sanexp.getExrecurso(),
					sanexp.getExorden(), sanexp.getExtipres(), sanexp.getExcaja1(), sanexp.getExcaja2(),
					sanexp.getExmocodigo(), getFaseTridAux, sanexp.getExmocodigoult(), sanexp.getExfecalta(),
					sanexp.getExfecmodif(), sanexp.getExusualta(), sanexp.getExusumodif(), sanexp.getExfecprescr(),
					sanexp.getExcooractual(), sanexp.getExdestnotifsancionado(), sanexp.getExverifsanc(),
					sanexp.getExverifinco(), sanexp.getExhdformanotiforigen());
			return sanexp;
		} catch (Exception e) {
			e.printStackTrace();
			SanexpDaoImpl.logger.error("Error producido en sanexp add: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	public Sanexp update(Sanexp sanexp) {
		String sqlCompleta = "";
		try {
			String query = "UPDATE SANEXP SET EXFOLDERID=?,EXDESCES=?,EXDESCEU=?,EXFECFIN=?,EXCALIF=?,EXIMPORTE=?,EXRECURSO=?,EXORDEN=?,EXTIPRES=?,EXCAJA1=?,EXCAJA2=?,EXTRPOSCOD=?,EXMOCODIGO=?,EXFCODIGO=?,EXMOCODIGOULT=?,EXLIQESTADO=?,EXLIQAPREMIO=?, EXFECPREVFIN=?,EXTRENTIDAD=?,HDCODIGO=?,HDFECHD=?,HDTE=?,HDCOTIR=?,HDCOPS=?,TIPOPROC=?,EXFECPROPRESO=?, EXFECENVIO=?,EXFECREOR=?,EXESTIMACION=?,EXFECPRESCR=?,EXCOORACTUAL=?,PLATEA=?,EXDESTNOTIFSANCIONADO=?,EXVERIFSANC=?,EXVERIFINCO=?, EXHDFORMANOTIFORIGEN=? WHERE EXCODIGO=?";
			Object getSantramexpTridAux = null;
			Object getSantramexpEntidadTridAux = null;
			if (sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrid() != null) {
				getSantramexpTridAux = sanexp.getSantramexp().getTrid();
			}
			if (sanexp.getSantramexpEntidad() != null && sanexp.getSantramexpEntidad().getTrid() != null) {
				getSantramexpEntidadTridAux = sanexp.getSantramexpEntidad().getTrid();
			}
			Object getFaseTridAux = null;
			if (sanexp.getFase() != null && sanexp.getFase().getFcodigo() != null) {
				getFaseTridAux = sanexp.getFase().getFcodigo();
			}
			Object getHechoDenunciaAux = null;
			if (sanexp.getHechoDenunciado() != null && sanexp.getHechoDenunciado().getHdcodigo() != null) {
				getHechoDenunciaAux = sanexp.getHechoDenunciado().getHdcodigo();
			}
			Object getMotivoAux = null;
			if (sanexp.getMotivo() != null && sanexp.getMotivo().getTircodigo() != null) {
				getMotivoAux = sanexp.getMotivo().getTircodigo();
			}
			Object getProductoAux = null;
			if (sanexp.getProducto() != null && sanexp.getProducto().getPscodigo() != null) {
				getProductoAux = sanexp.getProducto().getPscodigo();
			}

			Object[] params = { sanexp.getExfolderid(), sanexp.getExdesces(), sanexp.getExdesceu(),
					sanexp.getExfecfin(), sanexp.getExcalif(), sanexp.getEximporte(), sanexp.getExrecurso(),
					sanexp.getExorden(), sanexp.getExtipres(), sanexp.getExcaja1(), sanexp.getExcaja2(),
					getSantramexpTridAux, sanexp.getExmocodigo(), getFaseTridAux, sanexp.getExmocodigoult(),
					sanexp.getExliqestado(), sanexp.getExliqapremio(), sanexp.getExfecprevfin(),
					getSantramexpEntidadTridAux, getHechoDenunciaAux, sanexp.getHdfechd(), sanexp.getHdte(),
					getMotivoAux, getProductoAux, sanexp.getTipoProc(), sanexp.getExfecpropreso(),
					sanexp.getExfecenvio(), sanexp.getExfecreor(), sanexp.getExestimacion(), sanexp.getExfecprescr(),
					sanexp.getExcooractual(), sanexp.getPlatea(), sanexp.getExdestnotifsancionado(),
					sanexp.getExverifsanc(), sanexp.getExverifinco(), sanexp.getExhdformanotiforigen(),
					sanexp.getExcodigo() };

			sqlCompleta = Y41bUtils.dameSQL(query, params);

			this.jdbcTemplate.update(query, sanexp.getExfolderid(), sanexp.getExdesces(), sanexp.getExdesceu(),
					sanexp.getExfecfin(), sanexp.getExcalif(), sanexp.getEximporte(), sanexp.getExrecurso(),
					sanexp.getExorden(), sanexp.getExtipres(), sanexp.getExcaja1(), sanexp.getExcaja2(),
					getSantramexpTridAux, sanexp.getExmocodigo(), getFaseTridAux, sanexp.getExmocodigoult(),
					sanexp.getExliqestado(), sanexp.getExliqapremio(), sanexp.getExfecprevfin(),
					getSantramexpEntidadTridAux, getHechoDenunciaAux, sanexp.getHdfechd(), sanexp.getHdte(),
					getMotivoAux, getProductoAux, sanexp.getTipoProc(), sanexp.getExfecpropreso(),
					sanexp.getExfecenvio(), sanexp.getExfecreor(), sanexp.getExestimacion(), sanexp.getExfecprescr(),
					sanexp.getExcooractual(), sanexp.getPlatea(), sanexp.getExdestnotifsancionado(),
					sanexp.getExverifsanc(), sanexp.getExverifinco(), sanexp.getExhdformanotiforigen(),
					sanexp.getExcodigo());
			return sanexp;
		} catch (Exception e) {
			e.printStackTrace();
			SanexpDaoImpl.logger.error("Error producido en update san exp: " + e.getMessage() + sqlCompleta, e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	@Transactional(readOnly = true)
	public Sanexp find(Sanexp sanexp) {
		String query = "SELECT t1.EXCODIGO EXCODIGO, t1.EXFOLDERID EXFOLDERID, t1.EXDESCES EXDESCES, t1.EXDESCEU EXDESCEU, t1.EXFECPREVFIN EXFECPREVFIN, t1.EXFECFIN EXFECFIN, "
				+ " t1.EXCALIF EXCALIF, t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO, t1.EXORDEN EXORDEN, t1.EXTIPRES EXTIPRES, "
				+ " t1.EXCAJA1 EXCAJA1, t1.EXCAJA2 EXCAJA2, t1.EXMOCODIGO EXMOCODIGO, t1.EXFCODIGO EXFCODIGO, t1.EXMOCODIGOULT EXMOCODIGOULT, t1.EXFECPROPRESO, t1.EXFECALTA EXFECALTA, t1.EXFECMODIF "
				+ " EXFECMODIF, t1.EXUSUALTA EXUSUALTA, t1.EXUSUMODIF EXUSUMODIF, t1.EXLIQESTADO, t1.EXLIQAPREMIO EXLIQAPREMIO, t1.EXFECPREVFIN EXFECPREVFIN,t1.EXTRENTIDAD EXTRENTIDAD, "
				+ " t1.HDCODIGO HDCODIGO,t1.HDFECHD HDFECHD,'' HDTE,t1.HDCOTIR HDCOTIR,t1.HDCOPS HDCOPS,t1.TIPOPROC TIPOPROC,t1.EXFECPROPRESO EXFECPROPRESO,t1.EXFECENVIO EXFECENVIO,t1.EXFECREOR EXFECREOR,t1.EXESTIMACION EXESTIMACION, t1.EXFECPRESCR EXFECPRESCR,t1.EXCOORACTUAL EXCOORACTUAL, t1.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t1.EXVERIFSANC EXVERIFSANC, t1.EXVERIFINCO EXVERIFINCO, t1.EXIDPARTICIPACIONSANCIONADO EXIDPARTICIPACIONSANCIONADO, t1.EXHDFORMANOTIFORIGEN, "
				+ " t2.TRNUMDIAS TRNUMDIAS, t2.TRUAIDINTERV TRUAIDINTERV, t2.TRID SANTRAMEXPTRID, t2.TRCODIGO SANTRAMEXPTRCODIGO, "
				+ " t2.TRFECINI SANTRAMEXPTRFECINI, t2.TRFECFIN SANTRAMEXPTRFECFIN, /*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/ t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES, t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO, "
				+ " t2.TRTRIDREL SANTRAMEXPTRTRIDREL, t2.TRFECACINI SANTRAMEXPTRFECACINI, t2.TRRESULTADO SANTRAMEXPTRRESULTADO, t2.TRESTIMACION SANTRAMEXPTRESTIMACION, t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA, "
				+ " t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO, t2.TRRESOSAN SANTRAMEXPTRRESOSAN, t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE, t2.TRFECREGS SANTRAMEXPTRFECREGS, "
				+ " t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE, t2.TRNUMREGS SANTRAMEXPTRNUMREGS, t2.TRNUMREGE SANTRAMEXPTRNUMREGE, t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM, t2.TRFECENVIO SANTRAMEXPTRFECENVIO,"
				+ " t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE, t2.TRFECALTA SANTRAMEXPTRFECALTA, t2.TRFECMODIF SANTRAMEXPTRFECMODIF, t2.TRUSUALTA SANTRAMEXPTRUSUALTA, t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF, t2.TREXCODIGO SANTRAMEXPTREXCODIGO, "
				+ " t3.FCODIGO as FASEFCODIGO, t3.FNOMBRE as FASEFNOMBRE, t3.FNOMBREE as FASEFNOMBREE, "
				+ " t5.TRNUMDIAS TRNUMDIASENT,t5.TRID SANTRAMEXPTRIDENT, t5.TRCODIGO SANTRAMEXPTRCODIGOENT, "
				+ " t5.TRFECINI SANTRAMEXPTRFECINIENT, t5.TRFECFIN SANTRAMEXPTRFECFINENT, /*t5.TROBSERVES SANTRAMEXPTROBSERVESENT,*/ t5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMESENT, t5.TRMOCODIGO SANTRAMEXPTRMOCODIGOENT, "
				+ " t5.TRTRIDREL SANTRAMEXPTRTRIDRELENT, t5.TRFECACINI SANTRAMEXPTRFECACINIENT, t5.TRRESULTADO SANTRAMEXPTRRESULTADOENT, t5.TRESTIMACION SANTRAMEXPTRESTIMACIONENT, t5.TRRESOFECHA SANTRAMEXPTRRESOFECHAENT, "
				+ " t5.TRRESOTIPO SANTRAMEXPTRRESOTIPOENT, t5.TRRESOSAN SANTRAMEXPTRRESOSANENT, t5.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTEENT, t5.TRFECREGS SANTRAMEXPTRFECREGSENT, "
				+ " t5.TRESTADOACUSE SANTRAMEXPTRESTADOACUSEENT, t5.TRNUMREGS SANTRAMEXPTRNUMREGSENT, t5.TRNUMREGE SANTRAMEXPTRNUMREGEENT, t5.TRTIPOCOM SANTRAMEXPTRTIPOCOMENT, t5.TRFECENVIO SANTRAMEXPTRFECENVIOENT, "
				+ " t5.TRFECCIERRE SANTRAMEXPTRFECCIERREENT, t5.TRFECALTA SANTRAMEXPTRFECALTAENT, t5.TRFECMODIF SANTRAMEXPTRFECMODIFENT, t5.TRUSUALTA SANTRAMEXPTRUSUALTAENT, t5.TRUSUMODIF SANTRAMEXPTRUSUMODIFENT, t5.TREXCODIGO SANTRAMEXPTREXCODIGOENT, "
				+ " T4.TRCODIGO, T4.TRNOMBRE, T4.TRNOMBREE,T6.TRCODIGO TRCODIGOENT, T6.TRNOMBRE TRNOMBREENT, T6.TRNOMBREE TRNOMBREEENT, "
				+ " '' EXCOOR,  (select MONOMBRE FROM CENSO_MONITOR WHERE MOCODIGO=t1.EXMOCODIGO) MONOMBRE, t1.PLATEA PLATEA "
				+ " FROM SANEXP t1 , SANTRAMEXP t2, FASE t3,TRAMITE t4,SANTRAMEXP t5, TRAMITE t6 WHERE t1.EXCODIGO = ? AND t1.EXTRPOSCOD= t2.TRID(+) and t1.EXFCODIGO = t3.FCODIGO(+) AND t4.TRCODIGO(+) = t2.TRCODIGO  AND t1.EXTRENTIDAD= t5.TRID(+) AND t6.TRCODIGO(+) = t5.TRCODIGO";

		List<Sanexp> sanexpList = this.jdbcTemplate.query(query, this.rwMapDetalleExpediente, sanexp.getExcodigo());
		return (Sanexp) DataAccessUtils.uniqueResult(sanexpList);
	}

	/**
	 * Removes a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return
	 */
	public void remove(Sanexp sanexp) {
		String query = "DELETE FROM SANEXP WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, sanexp.getExcodigo());
	}

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexp> findAll(Sanexp sanexp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EXCODIGO EXCODIGO,t1.EXFOLDERID EXFOLDERID,t1.EXDESCES EXDESCES,t1.EXDESCEU EXDESCEU,t1.EXFECPREVFIN EXFECPREVFIN,t1.EXFECFIN EXFECFIN,t1.EXCALIF EXCALIF,t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO,t1.EXORDEN EXORDEN,t1.EXTIPRES EXTIPRES,t1.EXCAJA1 EXCAJA1,t1.EXCAJA2 EXCAJA2,t1.EXMOCODIGO EXMOCODIGO,t1.EXFCODIGO EXFCODIGO,t1.EXMOCODIGOULT EXMOCODIGOULT,t1.EXFECPROPRESO EXFECPROPRESO, t1.EXFECALTA EXFECALTA,t1.EXFECMODIF EXFECMODIF,t1.EXUSUALTA EXUSUALTA,t1.EXUSUMODIF EXUSUMODIF,"
						+ " t1.EXCODIGO EXCODIGO, t1.EXFOLDERID EXFOLDERID, t1.EXDESCES EXDESCES, t1.EXDESCEU EXDESCEU, t1.EXFECPREVFIN EXFECPREVFIN, t1.EXFECFIN EXFECFIN, "
						+ " t1.EXCALIF EXCALIF, t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO, t1.EXORDEN EXORDEN, t1.EXTIPRES EXTIPRES, "
						+ " t1.EXCAJA1 EXCAJA1, t1.EXCAJA2 EXCAJA2, t1.EXMOCODIGO EXMOCODIGO, t1.EXFCODIGO EXFCODIGO, t1.EXMOCODIGOULT EXMOCODIGOULT, t1.EXFECPROPRESO, t1.EXFECALTA EXFECALTA, t1.EXFECMODIF "
						+ " EXFECMODIF, t1.EXUSUALTA EXUSUALTA, t1.EXUSUMODIF EXUSUMODIF, t1.EXLIQESTADO, t1.EXLIQAPREMIO EXLIQAPREMIO, t1.EXFECPREVFIN EXFECPREVFIN,t1.EXTRENTIDAD EXTRENTIDAD, "
						+ " t1.HDCODIGO HDCODIGO,t1.HDFECHD HDFECHD,'' HDTE,t1.HDCOTIR HDCOTIR,t1.HDCOPS HDCOPS,t1.TIPOPROC TIPOPROC,t1.EXFECPROPRESO EXFECPROPRESO,t1.EXFECENVIO EXFECENVIO,t1.EXFECREOR EXFECREOR,t1.EXESTIMACION EXESTIMACION, t1.EXFECPRESCR EXFECPRESCR, t1.EXCOORACTUAL EXCOORACTUAL, t1.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t1.EXVERIFSANC EXVERIFSANC, t1.EXVERIFINCO EXVERIFINCO, t1.EXHDFORMANOTIFORIGEN EXHDFORMANOTIFORIGEN, "
						+ " t2.TRID SANTRAMEXPTRID,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF,t2.TREXCODIGO SANTRAMEXPTREXCODIGO, t3.EXFCODIGO as FASEFCODIGO, t3.FNOMBRE as FASEFNOMBRE, t3.FNOMBREE as FASEFNOMBREE, t1.PLATEA PLATEA ");
		query.append("FROM SANEXP t1 ,SANTRAMEXP t2, FASE t3, SANTRAMEXP t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanexp);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXTRPOSCOD= t2.TRID(+) and t1.EXFCODIGO = t3.FCODIGO(+) AND t1.EXTRENTIDAD= t4.TRID(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanexp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanexp sanexp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANEXP t1 , SANTRAMEXP t2, FASE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanexp);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXTRPOSCOD= t2.TRID(+) and t1.EXFCODIGO = t3.FCODIGO(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexp> findAllLike(Sanexp sanexp, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.EXCODIGO EXCODIGO,t1.EXFOLDERID EXFOLDERID,t1.EXDESCES EXDESCES,t1.EXDESCEU EXDESCEU,t1.EXFECPREVFIN EXFECPREVFIN,t1.EXFECFIN EXFECFIN,t1.EXCALIF EXCALIF,t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO,t1.EXORDEN EXORDEN,t1.EXTIPRES EXTIPRES,t1.EXCAJA1 EXCAJA1,t1.EXCAJA2 EXCAJA2,t1.EXMOCODIGO EXMOCODIGO,t1.EXFCODIGO EXFCODIGO,t1.EXMOCODIGOULT EXMOCODIGOULT,t1.EXFECPROPRESO EXFECPROPRESO, t1.EXFECALTA EXFECALTA,t1.EXFECMODIF EXFECMODIF,t1.EXUSUALTA EXUSUALTA,t1.EXUSUMODIF EXUSUMODIF,"
						+ " t1.EXCODIGO EXCODIGO, t1.EXFOLDERID EXFOLDERID, t1.EXDESCES EXDESCES, t1.EXDESCEU EXDESCEU, t1.EXFECPREVFIN EXFECPREVFIN, t1.EXFECFIN EXFECFIN, "
						+ " t1.EXCALIF EXCALIF, t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO, t1.EXORDEN EXORDEN, t1.EXTIPRES EXTIPRES, "
						+ " t1.EXCAJA1 EXCAJA1, t1.EXCAJA2 EXCAJA2, t1.EXMOCODIGO EXMOCODIGO, t1.EXFCODIGO EXFCODIGO, t1.EXMOCODIGOULT EXMOCODIGOULT, t1.EXFECPROPRESO, t1.EXFECALTA EXFECALTA, t1.EXFECMODIF "
						+ " EXFECMODIF, t1.EXUSUALTA EXUSUALTA, t1.EXUSUMODIF EXUSUMODIF, t1.EXLIQESTADO, t1.EXLIQAPREMIO EXLIQAPREMIO, t1.EXFECPREVFIN EXFECPREVFIN,t1.EXTRENTIDAD EXTRENTIDAD, "
						+ " t1.HDCODIGO HDCODIGO,t1.HDFECHD HDFECHD,'' HDTE,t1.HDCOTIR HDCOTIR,t1.HDCOPS HDCOPS,t1.TIPOPROC TIPOPROC,t1.EXFECPROPRESO EXFECPROPRESO,t1.EXFECENVIO EXFECENVIO,t1.EXFECREOR EXFECREOR,t1.EXESTIMACION EXESTIMACION, t1.EXFECPRESCR EXFECPRESCR, t1.EXCOORACTUAL EXCOORACTUAL, t1.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t1.EXVERIFSANC EXVERIFSANC, t1.EXVERIFINCO EXVERIFINCO, t1.EXHDFORMANOTIFORIGEN EXHDFORMANOTIFORIGEN, "
						+ " t2.TRID SANTRAMEXPTRID,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF,t2.TREXCODIGO SANTRAMEXPTREXCODIGO, t3.FNOMBRE as FASEFNOMBRE, t3.FNOMBREE as FASEFNOMBREE, t1.PLATEA PLATEA ");
		query.append("FROM SANEXP t1 ,SANTRAMEXP t2, FASE t3, SANTRAMEXP t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanexp, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXTRPOSCOD= t2.TRID(+) AND t1.EXFCODIGO = t3.FCODIGO(+) AND t1.EXTRENTIDAD= t4.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanexp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanexp sanexp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANEXP t1 ,SANTRAMEXP t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanexp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.EXTRPOSCOD= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanexp entity
	 * 
	 * @param sanexp
	 *            Sanexp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanexp sanexp) {

		StringBuilder where = new StringBuilder(SanexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanexp != null && sanexp.getExcodigo() != null) {
			where.append(" AND t1.EXCODIGO = ?");
			params.add(sanexp.getExcodigo());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(sanexp.getSantramexp().getTrid());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getExpedien() != null
				&& sanexp.getSantramexp().getExpedien().getExcodigo() != null) {
			where.append(" AND t2.TREXCODIGO = ?");
			params.add(sanexp.getSantramexp().getExpedien().getExcodigo());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(sanexp.getSantramexp().getTrcodigo());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(sanexp.getSantramexp().getTrfecini());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(sanexp.getSantramexp().getTrfecfin());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrobserves() != null) {
			where.append(" AND t2.TROBSERVES = ?");
			params.add(sanexp.getSantramexp().getTrobserves());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getCensoMonitor() != null
				&& sanexp.getSantramexp().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.TRMOCODIGO = ?");
			params.add(sanexp.getSantramexp().getCensoMonitor().getMocodigo());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(sanexp.getSantramexp().getTrtridrel());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecacini() != null) {
			where.append(" AND t2.TRFECACINI = ?");
			params.add(sanexp.getSantramexp().getTrfecacini());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(sanexp.getSantramexp().getTrresultado());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrestimacion() != null) {
			where.append(" AND t2.TRESTIMACION = ?");
			params.add(sanexp.getSantramexp().getTrestimacion());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(sanexp.getSantramexp().getTrresofecha());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresotipo() != null) {
			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(sanexp.getSantramexp().getTrresotipo());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresosan() != null) {
			where.append(" AND t2.TRRESOSAN = ?");
			params.add(sanexp.getSantramexp().getTrresosan());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(sanexp.getSantramexp().getTrresoimporte());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(sanexp.getSantramexp().getTrfecregs());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrestadoacuse() != null) {
			where.append(" AND t2.TRESTADOACUSE = ?");
			params.add(sanexp.getSantramexp().getTrestadoacuse());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrnumregs() != null) {
			where.append(" AND t2.TRNUMREGS = ?");
			params.add(sanexp.getSantramexp().getTrnumregs());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrnumrege() != null) {
			where.append(" AND t2.TRNUMREGE = ?");
			params.add(sanexp.getSantramexp().getTrnumrege());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrtipocom() != null) {
			where.append(" AND t2.TRTIPOCOM = ?");
			params.add(sanexp.getSantramexp().getTrtipocom());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(sanexp.getSantramexp().getTrfecenvio());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(sanexp.getSantramexp().getTrfeccierre());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(sanexp.getSantramexp().getTrfecalta());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(sanexp.getSantramexp().getTrfecmodif());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrusualta() != null) {
			where.append(" AND t2.TRUSUALTA = ?");
			params.add(sanexp.getSantramexp().getTrusualta());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrusumodif() != null) {
			where.append(" AND t2.TRUSUMODIF = ?");
			params.add(sanexp.getSantramexp().getTrusumodif());
		}
		if (sanexp != null && sanexp.getExfolderid() != null) {
			where.append(" AND t1.EXFOLDERID = ?");
			params.add(sanexp.getExfolderid());
		}
		if (sanexp != null && sanexp.getExdesces() != null) {
			where.append(" AND t1.EXDESCES = ?");
			params.add(sanexp.getExdesces());
		}
		if (sanexp != null && sanexp.getExdesceu() != null) {
			where.append(" AND t1.EXDESCEU = ?");
			params.add(sanexp.getExdesceu());
		}
		if (sanexp != null && sanexp.getExfecprevfin() != null) {
			where.append(" AND t1.EXFECPREVFIN = ?");
			params.add(sanexp.getExfecprevfin());
		}
		if (sanexp != null && sanexp.getExfecfin() != null) {
			where.append(" AND t1.EXFECFIN = ?");
			params.add(sanexp.getExfecfin());
		}
		if (sanexp != null && sanexp.getExcalif() != null) {
			where.append(" AND t1.EXCALIF = ?");
			params.add(sanexp.getExcalif());
		}
		if (sanexp != null && sanexp.getEximporte() != null) {
			where.append(" AND t1.EXIMPORTE = ?");
			params.add(sanexp.getEximporte());
		}
		if (sanexp != null && sanexp.getExrecurso() != null) {
			where.append(" AND t1.EXRECURSO = ?");
			params.add(sanexp.getExrecurso());
		}
		if (sanexp != null && sanexp.getExorden() != null) {
			where.append(" AND t1.EXORDEN = ?");
			params.add(sanexp.getExorden());
		}
		if (sanexp != null && sanexp.getExtipres() != null) {
			where.append(" AND t1.EXTIPRES = ?");
			params.add(sanexp.getExtipres());
		}
		if (sanexp != null && sanexp.getExcaja1() != null) {
			where.append(" AND t1.EXCAJA1 = ?");
			params.add(sanexp.getExcaja1());
		}
		if (sanexp != null && sanexp.getExcaja2() != null) {
			where.append(" AND t1.EXCAJA2 = ?");
			params.add(sanexp.getExcaja2());
		}
		if (sanexp != null && sanexp.getExmocodigo() != null) {
			where.append(" AND t1.EXMOCODIGO = ?");
			params.add(sanexp.getExmocodigo());
		}
		/*
		 * if (sanexp != null && sanexp.getExfcodigo() != null) {
		 * where.append(" AND t1.EXFCODIGO = ?");
		 * params.add(sanexp.getExfcodigo()); }
		 */
		if (sanexp != null && sanexp.getExmocodigoult() != null) {
			where.append(" AND t1.EXMOCODIGOULT = ?");
			params.add(sanexp.getExmocodigoult());
		}
		if (sanexp != null && sanexp.getExfecalta() != null) {
			where.append(" AND t1.EXFECALTA = ?");
			params.add(sanexp.getExfecalta());
		}
		if (sanexp != null && sanexp.getExfecmodif() != null) {
			where.append(" AND t1.EXFECMODIF = ?");
			params.add(sanexp.getExfecmodif());
		}
		if (sanexp != null && sanexp.getExusualta() != null) {
			where.append(" AND t1.EXUSUALTA = ?");
			params.add(sanexp.getExusualta());
		}
		if (sanexp != null && sanexp.getExusumodif() != null) {
			where.append(" AND t1.EXUSUMODIF = ?");
			params.add(sanexp.getExusumodif());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrid() != null) {
			where.append(" AND t4.TRID = ?");
			params.add(sanexp.getSantramexpEntidad().getTrid());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getExpedien() != null
				&& sanexp.getSantramexpEntidad().getExpedien().getExcodigo() != null) {
			where.append(" AND t4.TREXCODIGO = ?");
			params.add(sanexp.getSantramexpEntidad().getExpedien().getExcodigo());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrcodigo() != null) {
			where.append(" AND t4.TRCODIGO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrcodigo());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecini() != null) {
			where.append(" AND t4.TRFECINI = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecini());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecfin() != null) {
			where.append(" AND t4.TRFECFIN = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecfin());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrobserves() != null) {
			where.append(" AND t4.TROBSERVES = ?");
			params.add(sanexp.getSantramexpEntidad().getTrobserves());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getCensoMonitor() != null
				&& sanexp.getSantramexpEntidad().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t4.TRMOCODIGO = ?");
			params.add(sanexp.getSantramexpEntidad().getCensoMonitor().getMocodigo());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrtridrel() != null) {
			where.append(" AND t4.TRTRIDREL = ?");
			params.add(sanexp.getSantramexpEntidad().getTrtridrel());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecacini() != null) {
			where.append(" AND t4.TRFECACINI = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecacini());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresultado() != null) {
			where.append(" AND t4.TRRESULTADO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresultado());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrestimacion() != null) {
			where.append(" AND t4.TRESTIMACION = ?");
			params.add(sanexp.getSantramexpEntidad().getTrestimacion());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresofecha() != null) {
			where.append(" AND t4.TRRESOFECHA = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresofecha());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresotipo() != null) {
			where.append(" AND t4.TRRESOTIPO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresotipo());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresosan() != null) {
			where.append(" AND t4.TRRESOSAN = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresosan());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresoimporte() != null) {
			where.append(" AND t4.TRRESOIMPORTE = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresoimporte());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecregs() != null) {
			where.append(" AND t4.TRFECREGS = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecregs());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrestadoacuse() != null) {
			where.append(" AND t4.TRESTADOACUSE = ?");
			params.add(sanexp.getSantramexpEntidad().getTrestadoacuse());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrnumregs() != null) {
			where.append(" AND t4.TRNUMREGS = ?");
			params.add(sanexp.getSantramexpEntidad().getTrnumregs());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrnumrege() != null) {
			where.append(" AND t4.TRNUMREGE = ?");
			params.add(sanexp.getSantramexpEntidad().getTrnumrege());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrtipocom() != null) {
			where.append(" AND t4.TRTIPOCOM = ?");
			params.add(sanexp.getSantramexpEntidad().getTrtipocom());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecenvio() != null) {
			where.append(" AND t4.TRFECENVIO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecenvio());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfeccierre() != null) {
			where.append(" AND t4.TRFECCIERRE = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfeccierre());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecalta() != null) {
			where.append(" AND t4.TRFECALTA = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecalta());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecmodif() != null) {
			where.append(" AND t4.TRFECMODIF = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecmodif());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrusualta() != null) {
			where.append(" AND t4.TRUSUALTA = ?");
			params.add(sanexp.getSantramexpEntidad().getTrusualta());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrusumodif() != null) {
			where.append(" AND t4.TRUSUMODIF = ?");
			params.add(sanexp.getSantramexpEntidad().getTrusumodif());
		}
		if (sanexp != null && sanexp.getExcooractual() != null) {
			where.append(" AND t1.EXCOORACTUAL = ?");
			params.add(sanexp.getExcooractual());
		}
		if (sanexp != null && sanexp.getExdestnotifsancionado() != null) {
			where.append(" AND t1.EXDESTNOTIFSANCIONADO = ?");
			params.add(sanexp.getExdestnotifsancionado());
		}
		if (sanexp != null && sanexp.getExverifsanc() != null) {
			where.append(" AND t1.EXVERIFSANC = ?");
			params.add(sanexp.getExverifsanc());
		}
		if (sanexp != null && sanexp.getExverifinco() != null) {
			where.append(" AND t1.EXVERIFINCO = ?");
			params.add(sanexp.getExverifinco());
		}

		if (sanexp != null && sanexp.getExhdformanotiforigen() != null) {
			where.append(" AND t1.EXHDFORMANOTIFORIGEN = ?");
			params.add(sanexp.getExhdformanotiforigen());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanexp entity
	 * 
	 * @param sanexp
	 *            Sanexp Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanexp sanexp, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SanexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanexp != null && sanexp.getExcodigo() != null) {
			where.append(" AND UPPER(t1.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(sanexp.getSantramexp().getTrid());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getExpedien() != null
				&& sanexp.getSantramexp().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t2.TREXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getExpedien().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getExpedien().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TREXCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrcodigo() != null) {
			where.append(" AND UPPER(t2.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TRCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(sanexp.getSantramexp().getTrfecini());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(sanexp.getSantramexp().getTrfecfin());
		}

		if (sanexp != null && sanexp.getSantramexp() != null
				&& sanexp.getSantramexp().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t2.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TRMOCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(sanexp.getSantramexp().getTrtridrel());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecacini() != null) {
			where.append(" AND t2.TRFECACINI = ?");
			params.add(sanexp.getSantramexp().getTrfecacini());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(sanexp.getSantramexp().getTrresultado());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrestimacion() != null) {
			where.append(" AND UPPER(t2.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrestimacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTIMACION IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(sanexp.getSantramexp().getTrresofecha());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresotipo() != null) {

			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(sanexp.getSantramexp().getTrresotipo());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresosan() != null) {

			where.append(" AND t2.TRRESOSAN = ?");
			params.add(sanexp.getSantramexp().getTrresosan());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrresoimporte() != null) {

			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(sanexp.getSantramexp().getTrresoimporte());

		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(sanexp.getSantramexp().getTrfecregs());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t2.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrestadoacuse().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrestadoacuse().toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTADOACUSE IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrnumregs() != null) {
			where.append(" AND UPPER(t2.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrnumregs().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrnumregs().toUpperCase() + "%");
			}
			where.append(" AND t2.TRNUMREGS IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrnumrege() != null) {
			where.append(" AND UPPER(t2.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrnumrege().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrnumrege().toUpperCase() + "%");
			}
			where.append(" AND t2.TRNUMREGE IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrtipocom() != null) {
			where.append(" AND UPPER(t2.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrtipocom().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrtipocom().toUpperCase() + "%");
			}
			where.append(" AND t2.TRTIPOCOM IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(sanexp.getSantramexp().getTrfecenvio());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(sanexp.getSantramexp().getTrfeccierre());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(sanexp.getSantramexp().getTrfecalta());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(sanexp.getSantramexp().getTrfecmodif());
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrusualta() != null) {
			where.append(" AND UPPER(t2.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrusualta().toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUALTA IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexp() != null && sanexp.getSantramexp().getTrusumodif() != null) {
			where.append(" AND UPPER(t2.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexp().getTrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexp().getTrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUMODIF IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExfolderid() != null) {
			where.append(" AND UPPER(t1.EXFOLDERID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExfolderid().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExfolderid().toUpperCase() + "%");
			}
			where.append(" AND t1.EXFOLDERID IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExdesces() != null) {
			where.append(" AND UPPER(t1.EXDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExdesces().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExdesces().toUpperCase() + "%");
			}
			where.append(" AND t1.EXDESCES IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExdesceu() != null) {
			where.append(" AND UPPER(t1.EXDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExdesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.EXDESCEU IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExfecprevfin() != null) {
			where.append(" AND t1.EXFECPREVFIN = ?");
			params.add(sanexp.getExfecprevfin());
		}
		if (sanexp != null && sanexp.getExfecfin() != null) {
			where.append(" AND t1.EXFECFIN = ?");
			params.add(sanexp.getExfecfin());
		}
		if (sanexp != null && sanexp.getExcalif() != null) {
			where.append(" AND UPPER(t1.EXCALIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExcalif().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExcalif().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCALIF IS NOT NULL");
		}
		if (sanexp != null && sanexp.getEximporte() != null) {
			where.append(" AND UPPER(t1.EXIMPORTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getEximporte().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getEximporte().toUpperCase() + "%");
			}
			where.append(" AND t1.EXIMPORTE IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExrecurso() != null) {
			where.append(" AND UPPER(t1.EXRECURSO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExrecurso().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExrecurso().toUpperCase() + "%");
			}
			where.append(" AND t1.EXRECURSO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExorden() != null) {
			where.append(" AND UPPER(t1.EXORDEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExorden().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExorden().toUpperCase() + "%");
			}
			where.append(" AND t1.EXORDEN IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExtipres() != null) {
			where.append(" AND UPPER(t1.EXTIPRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExtipres().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExtipres().toUpperCase() + "%");
			}
			where.append(" AND t1.EXTIPRES IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExcaja1() != null) {
			where.append(" AND UPPER(t1.EXCAJA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExcaja1().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExcaja1().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCAJA1 IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExcaja2() != null) {
			where.append(" AND UPPER(t1.EXCAJA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExcaja2().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExcaja2().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCAJA2 IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExmocodigo() != null) {
			where.append(" AND UPPER(t1.EXMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExmocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExmocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EXMOCODIGO IS NOT NULL");
		}
		/*
		 * if (sanexp != null && sanexp.getExfcodigo() != null) {
		 * where.append(" AND UPPER(t1.EXFCODIGO) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(sanexp.getExfcodigo().toUpperCase() + "%");
		 * } else { params.add("%" + sanexp.getExfcodigo().toUpperCase() + "%");
		 * } where.append(" AND t1.EXFCODIGO IS NOT NULL"); }
		 */
		if (sanexp != null && sanexp.getExmocodigoult() != null) {
			where.append(" AND UPPER(t1.EXMOCODIGOULT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExmocodigoult().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExmocodigoult().toUpperCase() + "%");
			}
			where.append(" AND t1.EXMOCODIGOULT IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExfecalta() != null) {
			where.append(" AND t1.EXFECALTA = ?");
			params.add(sanexp.getExfecalta());
		}
		if (sanexp != null && sanexp.getExfecmodif() != null) {
			where.append(" AND t1.EXFECMODIF = ?");
			params.add(sanexp.getExfecmodif());
		}
		if (sanexp != null && sanexp.getExusualta() != null) {
			where.append(" AND UPPER(t1.EXUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.EXUSUALTA IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExusumodif() != null) {
			where.append(" AND UPPER(t1.EXUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getExusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getExusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.EXUSUMODIF IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrid() != null) {
			where.append(" AND t4.TRID = ?");
			params.add(sanexp.getSantramexpEntidad().getTrid());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getExpedien() != null
				&& sanexp.getSantramexpEntidad().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t4.TREXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getExpedien().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getExpedien().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.TREXCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrcodigo() != null) {
			where.append(" AND UPPER(t4.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.TRCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecini() != null) {
			where.append(" AND t4.TRFECINI = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecini());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecfin() != null) {
			where.append(" AND t4.TRFECFIN = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecfin());
		}

		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t4.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.TRMOCODIGO IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrtridrel() != null) {
			where.append(" AND t4.TRTRIDREL = ?");
			params.add(sanexp.getSantramexpEntidad().getTrtridrel());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecacini() != null) {
			where.append(" AND t4.TRFECACINI = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecacini());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresultado() != null) {
			where.append(" AND t4.TRRESULTADO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresultado());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrestimacion() != null) {
			where.append(" AND UPPER(t4.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrestimacion().toUpperCase() + "%");
			}
			where.append(" AND t4.TRESTIMACION IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresofecha() != null) {
			where.append(" AND t4.TRRESOFECHA = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresofecha());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresotipo() != null) {

			where.append(" AND t4.TRRESOTIPO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresotipo());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresosan() != null) {

			where.append(" AND t4.TRRESOSAN = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresosan());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrresoimporte() != null) {

			where.append(" AND t4.TRRESOIMPORTE = ?");
			params.add(sanexp.getSantramexpEntidad().getTrresoimporte());

		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecregs() != null) {
			where.append(" AND t4.TRFECREGS = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecregs());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t4.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrestadoacuse().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrestadoacuse().toUpperCase() + "%");
			}
			where.append(" AND t4.TRESTADOACUSE IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrnumregs() != null) {
			where.append(" AND UPPER(t4.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrnumregs().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrnumregs().toUpperCase() + "%");
			}
			where.append(" AND t4.TRNUMREGS IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrnumrege() != null) {
			where.append(" AND UPPER(t4.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrnumrege().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrnumrege().toUpperCase() + "%");
			}
			where.append(" AND t4.TRNUMREGE IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrtipocom() != null) {
			where.append(" AND UPPER(t4.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrtipocom().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrtipocom().toUpperCase() + "%");
			}
			where.append(" AND t4.TRTIPOCOM IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecenvio() != null) {
			where.append(" AND t4.TRFECENVIO = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecenvio());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfeccierre() != null) {
			where.append(" AND t4.TRFECCIERRE = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfeccierre());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecalta() != null) {
			where.append(" AND t4.TRFECALTA = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecalta());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrfecmodif() != null) {
			where.append(" AND t4.TRFECMODIF = ?");
			params.add(sanexp.getSantramexpEntidad().getTrfecmodif());
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrusualta() != null) {
			where.append(" AND UPPER(t4.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrusualta().toUpperCase() + "%");
			}
			where.append(" AND t4.TRUSUALTA IS NOT NULL");
		}
		if (sanexp != null && sanexp.getSantramexpEntidad() != null
				&& sanexp.getSantramexpEntidad().getTrusumodif() != null) {
			where.append(" AND UPPER(t4.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanexp.getSantramexpEntidad().getTrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanexp.getSantramexpEntidad().getTrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t4.TRUSUMODIF IS NOT NULL");
		}
		if (sanexp != null && sanexp.getExcooractual() != null) {
			where.append(" AND t1.EXCOORACTUAL = ?");
			params.add(sanexp.getExcooractual());
		}
		if (sanexp != null && sanexp.getExdestnotifsancionado() != null) {
			where.append(" AND t1.EXDESTNOTIFSANCIONADO = ?");
			params.add(sanexp.getExdestnotifsancionado());
		}
		if (sanexp != null && sanexp.getExverifsanc() != null) {
			where.append(" AND t1.EXVERIFSANC = ?");
			params.add(sanexp.getExverifsanc());
		}
		if (sanexp != null && sanexp.getExverifinco() != null) {
			where.append(" AND t1.EXVERIFINCO = ?");
			params.add(sanexp.getExverifinco());
		}

		if (sanexp != null && sanexp.getExhdformanotiforigen() != null) {
			where.append(" AND t1.EXHDFORMANOTIFORIGEN = ?");
			params.add(sanexp.getExhdformanotiforigen());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	@Transactional(readOnly = true)
	public Sanexp dameDetallesExpediente(Sanexp sanexp) {
		try {
			String query = "SELECT t1.EXCODIGO EXCODIGO,t1.EXFOLDERID EXFOLDERID,t1.EXDESCES EXDESCES,t1.EXDESCEU EXDESCEU,t1.EXFECPREVFIN EXFECPREVFIN,t1.EXFECFIN EXFECFIN,t1.EXCALIF EXCALIF,t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO,t1.EXORDEN EXORDEN,t1.EXTIPRES EXTIPRES,t1.EXCAJA1 EXCAJA1,t1.EXCAJA2 EXCAJA2,t1.EXMOCODIGO EXMOCODIGO,t1.EXFCODIGO EXFCODIGO,t1.EXMOCODIGOULT EXMOCODIGOULT,t1.EXFECPROPRESO EXFECPROPRESO, t1.EXFECALTA EXFECALTA,t1.EXFECMODIF EXFECMODIF,t1.EXUSUALTA EXUSUALTA,t1.EXUSUMODIF EXUSUMODIF,"
					+ " t1.EXCODIGO EXCODIGO, t1.EXFOLDERID EXFOLDERID, t1.EXDESCES EXDESCES, t1.EXDESCEU EXDESCEU, t1.EXFECPREVFIN EXFECPREVFIN, t1.EXFECFIN EXFECFIN, "
					+ " t1.EXCALIF EXCALIF, t1.EXIMPORTE EXIMPORTE,t1.EXRECURSO EXRECURSO, t1.EXORDEN EXORDEN, t1.EXTIPRES EXTIPRES, "
					+ " t1.EXCAJA1 EXCAJA1, t1.EXCAJA2 EXCAJA2, t1.EXMOCODIGO EXMOCODIGO, t1.EXFCODIGO EXFCODIGO, t1.EXMOCODIGOULT EXMOCODIGOULT, t1.EXFECPROPRESO, t1.EXFECALTA EXFECALTA, t1.EXFECMODIF "
					+ " EXFECMODIF, t1.EXUSUALTA EXUSUALTA, t1.EXUSUMODIF EXUSUMODIF, t1.EXLIQESTADO, t1.EXLIQAPREMIO EXLIQAPREMIO, t1.EXFECPREVFIN EXFECPREVFIN,t1.EXTRENTIDAD EXTRENTIDAD, "
					+ " t1.HDCODIGO HDCODIGO,t1.HDFECHD HDFECHD,'' HDTE,t1.HDCOTIR HDCOTIR,t1.HDCOPS HDCOPS,t1.TIPOPROC TIPOPROC,t1.EXFECPROPRESO EXFECPROPRESO,t1.EXFECENVIO EXFECENVIO,t1.EXFECREOR EXFECREOR,t1.EXESTIMACION EXESTIMACION,t1.EXFECPRESCR EXFECPRESCR,t1.EXCOORACTUAL EXCOORACTUAL, t1.PLATEA PLATEA, t1.EXDESTNOTIFSANCIONADO EXDESTNOTIFSANCIONADO, t1.EXVERIFSANC EXVERIFSANC, t1.EXVERIFINCO EXVERIFINCO, t1.EXIDPARTICIPACIONSANCIONADO EXIDPARTICIPACIONSANCIONADO, t1.EXHDFORMANOTIFORIGEN EXHDFORMANOTIFORIGEN ,"
					+ " t7.EXCOOR EXCOOR,  t2.TRNUMDIAS TRNUMDIAS, t5.TRNUMDIAS TRNUMDIASENT, t2.TRUAIDINTERV TRUAIDINTERV, t5.TRUAIDINTERV TRUAIDINTERVENT, "
					+ " (select MONOMBRE FROM CENSO_MONITOR WHERE MOCODIGO=t1.EXMOCODIGO) MONOMBRE, "
					+ " t2.TRID SANTRAMEXPTRID, t2.TRCODIGO SANTRAMEXPTRCODIGO, "
					+ " t2.TRFECINI SANTRAMEXPTRFECINI, t2.TRFECFIN SANTRAMEXPTRFECFIN, /*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/ t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES, t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO, "
					+ " t2.TRTRIDREL SANTRAMEXPTRTRIDREL, t2.TRFECACINI SANTRAMEXPTRFECACINI, t2.TRRESULTADO SANTRAMEXPTRRESULTADO, t2.TRESTIMACION SANTRAMEXPTRESTIMACION, t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA, "
					+ " t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO, t2.TRRESOSAN SANTRAMEXPTRRESOSAN, t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE, t2.TRFECREGS SANTRAMEXPTRFECREGS, "
					+ " t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE, t2.TRNUMREGS SANTRAMEXPTRNUMREGS, t2.TRNUMREGE SANTRAMEXPTRNUMREGE, t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM, t2.TRFECENVIO SANTRAMEXPTRFECENVIO,"
					+ " t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE, t2.TRFECALTA SANTRAMEXPTRFECALTA, t2.TRFECMODIF SANTRAMEXPTRFECMODIF, t2.TRUSUALTA SANTRAMEXPTRUSUALTA, t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF, t2.TREXCODIGO SANTRAMEXPTREXCODIGO, "
					+ " t5.TRID SANTRAMEXPTRIDENT, t5.TRCODIGO SANTRAMEXPTRCODIGOENT, "
					+ " t5.TRFECINI SANTRAMEXPTRFECINIENT, t5.TRFECFIN SANTRAMEXPTRFECFINENT, /*t5.TROBSERVES SANTRAMEXPTROBSERVESENT,*/ t5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMESENT, t5.TRMOCODIGO SANTRAMEXPTRMOCODIGOENT, "
					+ " t5.TRTRIDREL SANTRAMEXPTRTRIDRELENT, t5.TRFECACINI SANTRAMEXPTRFECACINIENT, t5.TRRESULTADO SANTRAMEXPTRRESULTADOENT, t5.TRESTIMACION SANTRAMEXPTRESTIMACIONENT, t5.TRRESOFECHA SANTRAMEXPTRRESOFECHAENT, "
					+ " t5.TRRESOTIPO SANTRAMEXPTRRESOTIPOENT, t5.TRRESOSAN SANTRAMEXPTRRESOSANENT, t5.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTEENT, t5.TRFECREGS SANTRAMEXPTRFECREGSENT, "
					+ " t5.TRESTADOACUSE SANTRAMEXPTRESTADOACUSEENT, t5.TRNUMREGS SANTRAMEXPTRNUMREGSENT, t5.TRNUMREGE SANTRAMEXPTRNUMREGEENT, t5.TRTIPOCOM SANTRAMEXPTRTIPOCOMENT, t5.TRFECENVIO SANTRAMEXPTRFECENVIOENT, "
					+ " t5.TRFECCIERRE SANTRAMEXPTRFECCIERREENT, t5.TRFECALTA SANTRAMEXPTRFECALTAENT, t5.TRFECMODIF SANTRAMEXPTRFECMODIFENT, t5.TRUSUALTA SANTRAMEXPTRUSUALTAENT, t5.TRUSUMODIF SANTRAMEXPTRUSUMODIFENT, t5.TREXCODIGO SANTRAMEXPTREXCODIGOENT, "
					+ " t3.FCODIGO as FASEFCODIGO, t3.FNOMBRE as FASEFNOMBRE, t3.FNOMBREE as FASEFNOMBREE, T4.TRCODIGO, T4.TRNOMBRE, T4.TRNOMBREE, T6.TRCODIGO TRCODIGOENT, T6.TRNOMBRE TRNOMBREENT, T6.TRNOMBREE TRNOMBREEENT "
					+ " FROM SANEXP t1 , SANTRAMEXP t2, FASE t3, TRAMITE t4, SANTRAMEXP t5, TRAMITE t6, EXPEDIEN t7 "
					+ " WHERE t1.EXCODIGO = ? AND t1.EXCODIGO = t7.EXCODIGO AND t1.EXTRPOSCOD= t2.TRID(+) and t1.EXFCODIGO = t3.FCODIGO(+) AND t4.TRCODIGO(+) = t2.TRCODIGO AND t1.EXTRENTIDAD= t5.TRID(+) AND t6.TRCODIGO(+) = t5.TRCODIGO";

			List<Sanexp> sanexpList = this.jdbcTemplate.query(query, this.rwMapDetalleExpediente, sanexp.getExcodigo());
			return (Sanexp) DataAccessUtils.uniqueResult(sanexpList);
		} catch (Exception e) {
			throw new Y41bUDAException(e.getMessage(), null, e);
		}
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	public Sanexp updateHechoDenunciadoOrigen(Sanexp sanexp) {
		String sqlCompleta = "";
		try {
			String query = "UPDATE SANEXP SET HDCODIGO=?, HDFECHD=?, HDTE=?, HDCOPS=?, HDCOTIR=?, TIPOPROC=? WHERE EXCODIGO=?";

			Object getHechoDenunciadoAux = null;
			if (sanexp.getHechoDenunciado() != null && sanexp.getHechoDenunciado().getHdcodigo() != null) {
				getHechoDenunciadoAux = sanexp.getHechoDenunciado().getHdcodigo();
			}
			Object getProductoAux = null;
			if (sanexp.getProducto() != null && sanexp.getProducto().getPscodigo() != null) {
				getProductoAux = sanexp.getProducto().getPscodigo();
			}
			Object getMotivoAux = null;
			if (sanexp.getMotivo() != null && sanexp.getMotivo().getTircodigo() != null) {
				getMotivoAux = sanexp.getMotivo().getTircodigo();
			}
			Object[] params = { getHechoDenunciadoAux, sanexp.getHdfechd(), sanexp.getHdte(), getProductoAux,
					getMotivoAux, sanexp.getTipoProc(), sanexp.getExcodigo() };

			sqlCompleta = Y41bUtils.dameSQL(query, params);

			this.jdbcTemplate.update(query, getHechoDenunciadoAux, sanexp.getHdfechd(), sanexp.getHdte(),
					getProductoAux, getMotivoAux, sanexp.getTipoProc(), sanexp.getExcodigo());
			return sanexp;
		} catch (Exception e) {
			e.printStackTrace();
			SanexpDaoImpl.logger.error("Error producido en update san exp: " + e.getMessage() + sqlCompleta, e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	@Transactional(readOnly = true)
	public Sanexp findLobTablaTemporal(Sanexp sanexp) {
		String query = "SELECT EXCODIGO, HDTE " + "FROM SANEXP  " + "WHERE EXCODIGO = ? ";
		return (Sanexp) this.jdbcTemplate.queryForObject(query, new RowMapper<Sanexp>() {
			public Sanexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Sanexp(resultSet.getString("EXCODIGO"), resultSet.getString("HDTE"));
			}
		}, sanexp.getExcodigo());
	}

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanexp> findAllExcodigo(Sanexp sanexp, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.EXCODIGO EXCODIGO FROM SANEXP t1 ");

		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		if (sanexp != null && sanexp.getExcoor() != null) {
			where.append(" AND t1.EXCOORACTUAL = ?");
			params.add(sanexp.getExcoor());
		}

		if (sanexp != null && sanexp.getExmocodigo() != null) {
			where.append(" AND t1.EXMOCODIGO = ?");
			params.add(sanexp.getExmocodigo());
		}

		// para identificar las sanciones abiertas en los trasvases de
		// instructor
		if (sanexp != null && sanexp.getExfecfin() != null && sanexp.getExfecfin() instanceof Date) {
			where.append(" AND t1.EXFECFIN IS NULL ");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanexp>) this.jdbcTemplate.query(query.toString(), this.rwMapPKExpediente, params.toArray());
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	public Sanexp updateInstructorOficina(Sanexp sanexp) {
		String sqlCompleta = "";
		try {
			String query = "UPDATE SANEXP SET EXMOCODIGO=?,EXCOORACTUAL=? WHERE EXCODIGO=?";

			Object[] params = { sanexp.getExmocodigo(), sanexp.getExcooractual(), sanexp.getExcodigo() };

			sqlCompleta = Y41bUtils.dameSQL(query, params);

			this.jdbcTemplate.update(query, sanexp.getExmocodigo(), sanexp.getExcooractual(), sanexp.getExcodigo());
			return sanexp;
		} catch (Exception e) {
			e.printStackTrace();
			SanexpDaoImpl.logger.error("Error producido en update san exp: " + e.getMessage() + sqlCompleta, e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 */
	public void updateSanexpFechaModificacion(Sanexp sanexp) {
		try {
			// Siempre que se actualiza expedien, forzamos la actualizacin de
			// sanexp para cuando hacemos las explotaciones con carga
			// incremental
			// recojamos los datos de ambas tablas
			String query = "update SANEXP set exfecmodif=exfecmodif where excodigo=?";
			this.jdbcTemplate.update(query, sanexp.getExcodigo());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 */
	public void updateIndicadorPlatea(Sanexp sanexp) {
		try {
			String query = "update SANEXP set platea='S' where excodigo=?";
			this.jdbcTemplate.update(query, sanexp.getExcodigo());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param excodigo
	 *            String
	 */
	public void updateEXIDPARTICIPACIONSANCIONADO(Saninterv saninterv, String excodigo) {
		String query = "UPDATE SANEXP SET EXIDPARTICIPACIONSANCIONADO=? WHERE EXCODIGO=?";

		this.jdbcTemplate.update(query, saninterv.getUanif(), excodigo);
	}

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 */

	public void udpateExcluirViaApremio(String excodigo, String valor) {
		try {
			String query = "";
			if (Y41bConstantes.VALOR_SI.equals(valor)) {
				query = "UPDATE SANEXP set EXEXCLUIDOAPREMIO='S' where excodigo=?";
			} else {
				query = "UPDATE SANEXP set EXEXCLUIDOAPREMIO=NULL where excodigo=?";
			}

			this.jdbcTemplate.update(query, excodigo);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}
}
