package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;

/**
 * SanexpDao  
 * 
 *  
 */

public interface SanexpDao {

	/**
	 * Inserts a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp add(Sanexp sanexp);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp update(Sanexp sanexp);

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp find(Sanexp sanexp);

	/**
	 * Deletes a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return
	 */
	void remove(Sanexp sanexp);

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanexp> findAll(Sanexp sanexp, Pagination pagination);

	/**
	 * Counts rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Long
	 */
	Long findAllCount(Sanexp sanexp);

	/**
	 * Finds rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanexp> findAllLike(Sanexp sanexp, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sanexp table using like.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanexp sanexp, Boolean startsWith);

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp dameDetallesExpediente(Sanexp sanexp);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	Sanexp updateHechoDenunciadoOrigen(Sanexp sanexp);

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @return Sanexp
	 */
	Sanexp findLobTablaTemporal(Sanexp sanexp);

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanexp> findAllExcodigo(Sanexp sanexp, Pagination pagination);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Pagination
	 * @return Sanexp
	 */
	public Sanexp updateInstructorOficina(Sanexp sanexp);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 */
	public void updateSanexpFechaModificacion(Sanexp sanexp);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 */
	public void updateIndicadorPlatea(Sanexp sanexp);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param excodigo
	 *            String
	 */
	public void updateEXIDPARTICIPACIONSANCIONADO(Saninterv saninterv, String excodigo);

	/**
	 * Updates a single row in the Sanexp table.
	 * 
	 * @param sanexp
	 *            Sanexp
	 */
	public void udpateExcluirViaApremio(String excodigo, String valorSi);
}
