package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanenvio;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanenvioDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanenvioDaoImpl implements SanenvioDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(SanenvioDaoImpl.class);

	private RowMapper<Sanenvio> rwMap = new RowMapper<Sanenvio>() {
		public Sanenvio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils
					.cargarDatosBDVO(resultSet);

			Saninterv saninterv = new Saninterv(
					resultSet.getBigDecimal("SanintervUAIDINTERV"),
					resultSet.getString("SanintervUANOMBRE"),
					resultSet.getString("SanintervUAMUNID"));
			saninterv
					.setNombreCompleto((resultSet
							.getString("SanintervUANOMBRE") == null ? ""
							: resultSet
									.getString("SanintervUANOMBRE")
									.concat(" ")
									.concat(resultSet
											.getString("SanintervUAAPELLIDO1") == null ? ""
											: resultSet
													.getString("SanintervUAAPELLIDO1"))
									.concat(" ")
									.concat(resultSet
											.getString("SanintervUAAPELLIDO2") == null ? ""
											: resultSet
													.getString("SanintervUAAPELLIDO2")))
							.trim());

			Sanenvio sanenvio = new Sanenvio(
					resultSet.getBigDecimal("ENID"),
					resultSet.getDate("ENFECENVIO"),
					resultSet.getDate("ENFECACUSE"),
					resultSet.getString("ENESTADO"),
					resultSet.getDate("ENFECALTA"),
					resultSet.getDate("ENFECMODIF"),
					resultSet.getString("ENUSUALTA"),
					resultSet.getString("ENUSUMODIF"),
					new Santramexp(
							resultSet.getString("SantramexpTRID"),
							resultSet.getString("SantramexpTRCODIGO"),
							null,
							resultSet.getDate("SantramexpTRFECINI"),
							resultSet.getDate("SantramexpTRFECFIN"),
							/* resultSet.getString("SantramexpTROBSERVES") */null,
							resultSet.getString("SantramexpTRNOMTRAMES"),
							resultSet.getString("SantramexpTRTRIDREL"),
							resultSet.getDate("SantramexpTRFECACINI"),
							resultSet.getBigDecimal("SantramexpTRRESULTADO"),
							resultSet.getString("SantramexpTRESTIMACION"),
							resultSet.getDate("SantramexpTRRESOFECHA"),
							resultSet.getString("SantramexpTRRESOTIPO"),
							resultSet.getBigDecimal("SantramexpTRRESOSAN"),
							resultSet.getBigDecimal("SantramexpTRRESOIMPORTE"),
							resultSet.getDate("SantramexpTRFECREGS"), null,
							resultSet.getString("SantramexpTRESTADOACUSE"),
							resultSet.getString("SantramexpTRNUMREGS"),
							resultSet.getString("SantramexpTRNUMREGE"),
							resultSet.getString("SantramexpTRTIPOCOM"),
							resultSet.getDate("SantramexpTRFECENVIO"),
							resultSet.getDate("SantramexpTRFECCIERRE"), null,
							null, null, null, resultSet
									.getDate("SantramexpTRFECALTA"), resultSet
									.getDate("SantramexpTRFECMODIF"), null,
							null, null, resultSet
									.getString("SantramexpTRUSUALTA"),
							resultSet.getString("SantramexpTRUSUMODIF"),
							new Expedien(resultSet
									.getString("SantramexpTREXCODIGO")), null,
							null, null, null, null, resultSet
									.getString("SantramexpTRTIPONOTPLATEA"),
							resultSet.getString("SantramexpTRSEDE")),
					saninterv, new Expedien(
							resultSet.getString("ExpedienEXCODIGO")),
					new Santramexp(), resultSet.getString("ENTIPOENVIO"));
			sanenvio.setFecharegistro(resultSet.getDate("FECHAREGISTRO"));
			sanenvio.setTrenvrem(resultSet.getString("TRENVREM"));
			sanenvio.setTrcodrem(resultSet.getString("TRCODREM"));
			sanenvio.setRmestado(resultSet.getString("RMESTADO"));

			sanenvio.setTracusereintentado((columnasSeleccionadas
					.contains("TRACUSEREINTENTADO")) ? resultSet
					.getString("TRACUSEREINTENTADO") : null);

			return sanenvio;
		}
	};

	private RowMapper<Sanenvio> rwMapAux = new RowMapper<Sanenvio>() {
		public Sanenvio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Sanenvio sanenvio = new Sanenvio(resultSet.getBigDecimal("ENID"),
					resultSet.getDate("ENFECENVIO"),
					resultSet.getDate("ENFECACUSE"),
					resultSet.getString("ENESTADO"),
					resultSet.getDate("ENFECALTA"),
					resultSet.getDate("ENFECMODIF"),
					resultSet.getString("ENUSUALTA"),
					resultSet.getString("ENUSUMODIF"), null, null, null, null,
					resultSet.getString("ENTIPOENVIO"));

			return sanenvio;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Pagination
	 * @return Sanenvio
	 */
	public Sanenvio add(Sanenvio sanenvio) {

		String consulta = "";
		try {

			String query = "INSERT INTO SANENVIO (ENTRID, ENINID, ENEXID, ENTRIDACUSE, ENFECENVIO, ENFECACUSE, ENESTADO, ENTIPOENVIO) VALUES (?,?,?,?,?,?,?,?)";
			Object getSantramexpByEntridTridAux = null;
			if (sanenvio.getSantramexpByEntrid() != null
					&& sanenvio.getSantramexpByEntrid().getTrid() != null) {
				getSantramexpByEntridTridAux = sanenvio.getSantramexpByEntrid()
						.getTrid();
			}
			Object getSanintervUaidintervAux = null;
			if (sanenvio.getSaninterv() != null
					&& sanenvio.getSaninterv().getUaidinterv() != null) {
				getSanintervUaidintervAux = sanenvio.getSaninterv()
						.getUaidinterv();
			}
			Object getExpedienExcodigoAux = null;
			if (sanenvio.getExpedien() != null
					&& sanenvio.getExpedien().getExcodigo() != null) {
				getExpedienExcodigoAux = sanenvio.getExpedien().getExcodigo();
			}
			Object getSantramexpByEntridacuseTridAux = null;
			if (sanenvio.getSantramexpByEntridacuse() != null
					&& sanenvio.getSantramexpByEntridacuse().getTrid() != null) {
				getSantramexpByEntridacuseTridAux = sanenvio
						.getSantramexpByEntridacuse().getTrid();
			}
			Object[] params = { getSantramexpByEntridTridAux,
					getSanintervUaidintervAux, getExpedienExcodigoAux,
					getSantramexpByEntridacuseTridAux,
					sanenvio.getEnfecenvio(), sanenvio.getEnfecacuse(),
					sanenvio.getEnestado() };
			consulta = Y41bUtils.dameSQL(query, params);
			this.jdbcTemplate.update(query, getSantramexpByEntridTridAux,
					getSanintervUaidintervAux, getExpedienExcodigoAux,
					getSantramexpByEntridacuseTridAux,
					sanenvio.getEnfecenvio(), sanenvio.getEnfecacuse(),
					sanenvio.getEnestado(), sanenvio.getEntipoenvio());
			return sanenvio;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(
					"Error producido en findAllDocumentosHechoComunicacion: "
							+ e.getMessage() + consulta, e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Pagination
	 * @return Sanenvio
	 */
	public Sanenvio update(Sanenvio sanenvio) {

		String query = "UPDATE SANENVIO SET ENTRID=?, ENINID=?, ENEXID=?, ENTRIDACUSE=?, ENFECENVIO=?, ENFECACUSE=?, ENESTADO=?, ENFECALTA=?, ENFECMODIF=?, ENUSUALTA=?, ENUSUMODIF=?, ENTIPOENVIO=? WHERE ENID=?";
		Object getSantramexpByEntridTridAux = null;
		if (sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrid() != null) {
			getSantramexpByEntridTridAux = sanenvio.getSantramexpByEntrid()
					.getTrid();
		}
		Object getSanintervUaidintervAux = null;
		if (sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaidinterv() != null) {
			getSanintervUaidintervAux = sanenvio.getSaninterv().getUaidinterv();
		}
		Object getExpedienExcodigoAux = null;
		if (sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = sanenvio.getExpedien().getExcodigo();
		}
		Object getSantramexpByEntridacuseTridAux = null;
		if (sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrid() != null) {
			getSantramexpByEntridacuseTridAux = sanenvio
					.getSantramexpByEntridacuse().getTrid();
		}
		this.jdbcTemplate.update(query, getSantramexpByEntridTridAux,
				getSanintervUaidintervAux, getExpedienExcodigoAux,
				getSantramexpByEntridacuseTridAux, sanenvio.getEnfecenvio(),
				sanenvio.getEnfecacuse(), sanenvio.getEnestado(),
				sanenvio.getEnfecalta(), sanenvio.getEnfecmodif(),
				sanenvio.getEnusualta(), sanenvio.getEnusumodif(),
				sanenvio.getEntipoenvio(), sanenvio.getEnid());
		return sanenvio;
	}

	/**
	 * Finds a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Pagination
	 * @return Sanenvio
	 */
	@Transactional(readOnly = true)
	public Sanenvio find(Sanenvio sanenvio) {
		String query = "SELECT t1.ENID ENID, t1.ENFECENVIO ENFECENVIO,t1.ENFECACUSE ENFECACUSE, t1.ENTIPOENVIO ENTIPOENVIO,t1.ENESTADO ENESTADO,t1.ENFECALTA ENFECALTA,t1.ENFECMODIF ENFECMODIF,t1.ENUSUALTA ENUSUALTA,t1.ENUSUMODIF ENUSUMODIF "
				+ " ,t2.TRID SANTRAMEXPTRID,t2.TRSEDE SANTRAMEXPTRSEDE,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF, t2.TRTIPONOTPLATEA SANTRAMEXPTRTIPONOTPLATEA "
				+ " ,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2,t3.UANIF SANINTERVUANIF,t3.UANRTEL SANINTERVUANRTEL,t3.UANRTEL2 SANINTERVUANRTEL2,t3.UAPROV_ID SANINTERVUAPROVID,t3.UAMUN_ID SANINTERVUAMUNID,t3.UALOC_ID SANINTERVUALOCID,t3.UACALLE_ID SANINTERVUACALLEID,t3.UACP_ID SANINTERVUACPID,t3.UAPORTAL_ID SANINTERVUAPORTALID,t3.UANOMBRE_PISO SANINTERVUANOMBREPISO,t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t3.UADIRE_ANT SANINTERVUADIREANT,t3.UATIPOINTERV SANINTERVUATIPOINTERV,t3.UADTCODIGO SANINTERVUADTCODIGO,t3.UAESCODIGO SANINTERVUAESCODIGO,t3.UATRFECALTA SANINTERVUATRFECALTA,t3.UATRFECMODIF SANINTERVUATRFECMODIF,t3.UATRUSUALTA SANINTERVUATRUSUALTA,t3.UATRUSUMODIF SANINTERVUATRUSUMODIF,t3.UAFECALTA SANINTERVUAFECALTA,t3.UAFECMODIF SANINTERVUAFECMODIF,t3.UAUSUALTA SANINTERVUAUSUALTA,t3.UAUSUMODIF SANINTERVUAUSUMODIF "
				+ " ,t4.EXCODIGO EXPEDIENEXCODIGO,t4.EXCOOR EXPEDIENEXCOOR,t4.EXNRAN EXPEDIENEXNRAN,t4.EXNROR EXPEDIENEXNROR,t4.EXFERE EXPEDIENEXFERE,t4.EXCOIT EXPEDIENEXCOIT,t4.EXCOES EXPEDIENEXCOES,t4.EXFEACIN EXPEDIENEXFEACIN,t4.EXFEEMCA EXPEDIENEXFEEMCA,t4.EXFEPLCA EXPEDIENEXFEPLCA,t4.EXFPNOPC EXPEDIENEXFPNOPC,t4.EXFEDE EXPEDIENEXFEDE,t4.EXFECOAL EXPEDIENEXFECOAL,t4.EXFENOPR EXPEDIENEXFENOPR,t4.EXFEPUPR EXPEDIENEXFEPUPR,t4.EXCOOSPR EXPEDIENEXCOOSPR,t4.EXFEALPR EXPEDIENEXFEALPR,t4.EXFEEL EXPEDIENEXFEEL,t4.EXFERES EXPEDIENEXFERES,t4.EXFENORE EXPEDIENEXFENORE,t4.EXFEPURE EXPEDIENEXFEPURE,t4.EXCOOSRE EXPEDIENEXCOOSRE,t4.EXCOTTR EXPEDIENEXCOTTR,t4.EXCAMURE EXPEDIENEXCAMURE,t4.EXFETA EXPEDIENEXFETA,t4.EXCOTSA EXPEDIENEXCOTSA,t4.EXFECROI EXPEDIENEXFECROI,t4.EXFEAR EXPEDIENEXFEAR,t4.EXCOORIE EXPEDIENEXCOORIE,t4.EXINRE EXPEDIENEXINRE,t4.EXINCOCO EXPEDIENEXINCOCO,t4.EXINEXVA EXPEDIENEXINEXVA,t4.EXFECIRC EXPEDIENEXFECIRC,t4.EXFENOAI EXPEDIENEXFENOAI,t4.EXFECOLM EXPEDIENEXFECOLM,t4.EXNUINLM EXPEDIENEXNUINLM,t4.EXFEINMU EXPEDIENEXFEINMU,t4.EXFEAVMU EXPEDIENEXFEAVMU,t4.EXFEIMCD EXPEDIENEXFEIMCD,t4.EXFECEDE EXPEDIENEXFECEDE,t4.EXCOPS EXPEDIENEXCOPS,t4.EXCOSE EXPEDIENEXCOSE "
				+ " ,t5.TRID SANTRAMEXPTRID2,t5.TRCODIGO SANTRAMEXPTRCODIGO2,t5.TRFECINI SANTRAMEXPTRFECINI2,t5.TRFECFIN SANTRAMEXPTRFECFIN2,/*t5.TROBSERVES SANTRAMEXPTROBSERVES2,*/t5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES2,t5.TRMOCODIGO SANTRAMEXPTRMOCODIGO2,t5.TRTRIDREL SANTRAMEXPTRTRIDREL2,t5.TRFECACINI SANTRAMEXPTRFECACINI2,t5.TRRESULTADO SANTRAMEXPTRRESULTADO2,t5.TRESTIMACION SANTRAMEXPTRESTIMACION2,t5.TRRESOFECHA SANTRAMEXPTRRESOFECHA2,t5.TRRESOTIPO SANTRAMEXPTRRESOTIPO2,t5.TRRESOSAN SANTRAMEXPTRRESOSAN2,t5.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE2,t5.TRFECREGS SANTRAMEXPTRFECREGS2,t5.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE2,t5.TRNUMREGS SANTRAMEXPTRNUMREGS2,t5.TRNUMREGE SANTRAMEXPTRNUMREGE2,t5.TRTIPOCOM SANTRAMEXPTRTIPOCOM2,t5.TRFECENVIO SANTRAMEXPTRFECENVIO2,t5.TRFECCIERRE SANTRAMEXPTRFECCIERRE2,t5.TRFECALTA SANTRAMEXPTRFECALTA2,t5.TRFECMODIF SANTRAMEXPTRFECMODIF2,t5.TRUSUALTA SANTRAMEXPTRUSUALTA2,t5.TRUSUMODIF SANTRAMEXPTRUSUMODIF2,t2.TREXCODIGO SANTRAMEXPTREXCODIGO,t3.UAEXCODIGO SANINTERVUAEXCODIGO,t5.TREXCODIGO SANTRAMEXPTREXCODIGO2 "
				+ " ,t2.TRFECREGS FECHAREGISTRO, t2.TRENVREM TRENVREM, t2.TRCODREM TRCODREM, t6.RMESTADO RMESTADO "
				+ " FROM SANENVIO t1 , SANTRAMEXP t2 , SANINTERV t3 , EXPEDIEN t4 , SANTRAMEXP t5, REMESA t6   "
				+ " WHERE t1.ENID = ? AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENEXID= t4.EXCODIGO(+) AND t1.ENTRIDACUSE= t5.TRID(+) AND t2.TRCODREM=t6.RMCODIGO(+) ";

		List<Sanenvio> sanenvioList = this.jdbcTemplate.query(query,
				this.rwMap, sanenvio.getEnid());
		return (Sanenvio) DataAccessUtils.uniqueResult(sanenvioList);
	}

	/**
	 * Removes a single row in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Pagination
	 * @return
	 */
	public void remove(Sanenvio sanenvio) {
		String query = "DELETE FROM SANENVIO WHERE ENID=?";
		this.jdbcTemplate.update(query, sanenvio.getEnid());
	}

	/**
	 * Finds a List of rows in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanenvio> findAll(Sanenvio sanenvio, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENID ENID,t2.TRFECFIN ENFECENVIO,t1.ENFECACUSE ENFECACUSE, t1.ENTIPOENVIO ENTIPOENVIO,t1.ENESTADO ENESTADO,t1.ENFECALTA ENFECALTA,t1.ENFECMODIF ENFECMODIF,t1.ENUSUALTA ENUSUALTA,t1.ENUSUMODIF ENUSUMODIF"
						+ " ,t2.TRID SANTRAMEXPTRID,t2.TRSEDE SANTRAMEXPTRSEDE,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF, t2.TRTIPONOTPLATEA SANTRAMEXPTRTIPONOTPLATEA "
						+ " ,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2,t3.UANIF SANINTERVUANIF,t3.UANRTEL SANINTERVUANRTEL,t3.UANRTEL2 SANINTERVUANRTEL2,t3.UAPROV_ID SANINTERVUAPROVID,t3.UAMUN_ID SANINTERVUAMUNID,t3.UALOC_ID SANINTERVUALOCID,t3.UACALLE_ID SANINTERVUACALLEID,t3.UACP_ID SANINTERVUACPID,t3.UAPORTAL_ID SANINTERVUAPORTALID,t3.UANOMBRE_PISO SANINTERVUANOMBREPISO,t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t3.UADIRE_ANT SANINTERVUADIREANT,t3.UATIPOINTERV SANINTERVUATIPOINTERV,t3.UADTCODIGO SANINTERVUADTCODIGO,t3.UAESCODIGO SANINTERVUAESCODIGO,t3.UATRFECALTA SANINTERVUATRFECALTA,t3.UATRFECMODIF SANINTERVUATRFECMODIF,t3.UATRUSUALTA SANINTERVUATRUSUALTA,t3.UATRUSUMODIF SANINTERVUATRUSUMODIF,t3.UAFECALTA SANINTERVUAFECALTA,t3.UAFECMODIF SANINTERVUAFECMODIF,t3.UAUSUALTA SANINTERVUAUSUALTA,t3.UAUSUMODIF SANINTERVUAUSUMODIF"
						+ " ,t4.EXCODIGO EXPEDIENEXCODIGO,t4.EXCOOR EXPEDIENEXCOOR,t4.EXNRAN EXPEDIENEXNRAN,t4.EXNROR EXPEDIENEXNROR,t4.EXFERE EXPEDIENEXFERE,t4.EXCOIT EXPEDIENEXCOIT,t4.EXCOES EXPEDIENEXCOES,t4.EXFEACIN EXPEDIENEXFEACIN,t4.EXFEEMCA EXPEDIENEXFEEMCA,t4.EXFEPLCA EXPEDIENEXFEPLCA,t4.EXFPNOPC EXPEDIENEXFPNOPC,t4.EXFEDE EXPEDIENEXFEDE,t4.EXFECOAL EXPEDIENEXFECOAL,t4.EXFENOPR EXPEDIENEXFENOPR,t4.EXFEPUPR EXPEDIENEXFEPUPR,t4.EXCOOSPR EXPEDIENEXCOOSPR,t4.EXFEALPR EXPEDIENEXFEALPR,t4.EXFEEL EXPEDIENEXFEEL,t4.EXFERES EXPEDIENEXFERES,t4.EXFENORE EXPEDIENEXFENORE,t4.EXFEPURE EXPEDIENEXFEPURE,t4.EXCOOSRE EXPEDIENEXCOOSRE,t4.EXCOTTR EXPEDIENEXCOTTR,t4.EXCAMURE EXPEDIENEXCAMURE,t4.EXFETA EXPEDIENEXFETA,t4.EXCOTSA EXPEDIENEXCOTSA,t4.EXFECROI EXPEDIENEXFECROI,t4.EXFEAR EXPEDIENEXFEAR,t4.EXCOORIE EXPEDIENEXCOORIE,t4.EXINRE EXPEDIENEXINRE,t4.EXINCOCO EXPEDIENEXINCOCO,t4.EXINEXVA EXPEDIENEXINEXVA,t4.EXFECIRC EXPEDIENEXFECIRC,t4.EXFENOAI EXPEDIENEXFENOAI,t4.EXFECOLM EXPEDIENEXFECOLM,t4.EXNUINLM EXPEDIENEXNUINLM,t4.EXFEINMU EXPEDIENEXFEINMU,t4.EXFEAVMU EXPEDIENEXFEAVMU,t4.EXFEIMCD EXPEDIENEXFEIMCD,t4.EXFECEDE EXPEDIENEXFECEDE,t4.EXCOPS EXPEDIENEXCOPS,t4.EXCOSE EXPEDIENEXCOSE "
						+ " ,t5.TRID SANTRAMEXPTRID2,t5.TRCODIGO SANTRAMEXPTRCODIGO2,t5.TRFECINI SANTRAMEXPTRFECINI2,t5.TRFECFIN SANTRAMEXPTRFECFIN2,/*t5.TROBSERVES SANTRAMEXPTROBSERVES2,*/t5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES2,t5.TRMOCODIGO SANTRAMEXPTRMOCODIGO2,t5.TRTRIDREL SANTRAMEXPTRTRIDREL2,t5.TRFECACINI SANTRAMEXPTRFECACINI2,t5.TRRESULTADO SANTRAMEXPTRRESULTADO2,t5.TRESTIMACION SANTRAMEXPTRESTIMACION2,t5.TRRESOFECHA SANTRAMEXPTRRESOFECHA2,t5.TRRESOTIPO SANTRAMEXPTRRESOTIPO2,t5.TRRESOSAN SANTRAMEXPTRRESOSAN2,t5.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE2,t5.TRFECREGS SANTRAMEXPTRFECREGS2,t5.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE2,t5.TRNUMREGS SANTRAMEXPTRNUMREGS2,t5.TRNUMREGE SANTRAMEXPTRNUMREGE2,t5.TRTIPOCOM SANTRAMEXPTRTIPOCOM2,t5.TRFECENVIO SANTRAMEXPTRFECENVIO2,t5.TRFECCIERRE SANTRAMEXPTRFECCIERRE2,t5.TRFECALTA SANTRAMEXPTRFECALTA2,t5.TRFECMODIF SANTRAMEXPTRFECMODIF2,t5.TRUSUALTA SANTRAMEXPTRUSUALTA2,t5.TRUSUMODIF SANTRAMEXPTRUSUMODIF2,t2.TREXCODIGO SANTRAMEXPTREXCODIGO,t3.UAEXCODIGO SANINTERVUAEXCODIGO,t5.TREXCODIGO SANTRAMEXPTREXCODIGO2 "
						+ " ,(SELECT TRACUSEREINTENTADO FROM SANTRAMEXP ACUSREIN WHERE ACUSREIN.TRTRIDREL=t2.TRID AND ACUSREIN.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
						+ "') AS TRACUSEREINTENTADO, t2.TRFECREGS FECHAREGISTRO, t2.TRENVREM TRENVREM, t2.TRCODREM TRCODREM, t6.RMESTADO RMESTADO ");
		query.append("FROM SANENVIO t1 ,SANTRAMEXP t2 ,SANINTERV t3 ,EXPEDIEN t4 ,SANTRAMEXP t5, REMESA t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanenvio);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENEXID= t4.EXCODIGO(+) AND t1.ENTRIDACUSE= t5.TRID(+) AND t2.TRCODREM=t6.RMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanenvio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanenvio sanenvio) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANENVIO t1 , SANTRAMEXP t2 , SANINTERV t3 , EXPEDIEN t4 , SANTRAMEXP t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanenvio);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENEXID= t4.EXCODIGO(+) AND t1.ENTRIDACUSE= t5.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sanenvio table using like.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanenvio> findAllLike(Sanenvio sanenvio, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENID ENID,DECODE(t2.TRFECREGS,null,t2.TRFECFIN,t2.TRFECREGS) ENFECENVIO, ,t1.ENFECACUSE ENFECACUSE, t1.ENTIPOENVIO ENTIPOENVIO,t1.ENESTADO ENESTADO,t1.ENFECALTA ENFECALTA,t1.ENFECMODIF ENFECMODIF,t1.ENUSUALTA ENUSUALTA,t1.ENUSUMODIF ENUSUMODIF  "
						+ " ,t2.TRID SANTRAMEXPTRID,t2.TRSEDE SANTRAMEXPTRSEDE,t2.TRCODIGO SANTRAMEXPTRCODIGO,t2.TRFECINI SANTRAMEXPTRFECINI,t2.TRFECFIN SANTRAMEXPTRFECFIN,/*t2.TROBSERVES SANTRAMEXPTROBSERVES,*/t2.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES,t2.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t2.TRTRIDREL SANTRAMEXPTRTRIDREL,t2.TRFECACINI SANTRAMEXPTRFECACINI,t2.TRRESULTADO SANTRAMEXPTRRESULTADO,t2.TRESTIMACION SANTRAMEXPTRESTIMACION,t2.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t2.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t2.TRRESOSAN SANTRAMEXPTRRESOSAN,t2.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t2.TRFECREGS SANTRAMEXPTRFECREGS,t2.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t2.TRNUMREGS SANTRAMEXPTRNUMREGS,t2.TRNUMREGE SANTRAMEXPTRNUMREGE,t2.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t2.TRFECENVIO SANTRAMEXPTRFECENVIO,t2.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t2.TRFECALTA SANTRAMEXPTRFECALTA,t2.TRFECMODIF SANTRAMEXPTRFECMODIF,t2.TRUSUALTA SANTRAMEXPTRUSUALTA,t2.TRUSUMODIF SANTRAMEXPTRUSUMODIF, t2.TRTIPONOTPLATEA SANTRAMEXPTRTIPONOTPLATEA "
						+ " ,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2,t3.UANIF SANINTERVUANIF,t3.UANRTEL SANINTERVUANRTEL,t3.UANRTEL2 SANINTERVUANRTEL2,t3.UAPROV_ID SANINTERVUAPROVID,t3.UAMUN_ID SANINTERVUAMUNID,t3.UALOC_ID SANINTERVUALOCID,t3.UACALLE_ID SANINTERVUACALLEID,t3.UACP_ID SANINTERVUACPID,t3.UAPORTAL_ID SANINTERVUAPORTALID,t3.UANOMBRE_PISO SANINTERVUANOMBREPISO,t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t3.UADIRE_ANT SANINTERVUADIREANT,t3.UATIPOINTERV SANINTERVUATIPOINTERV,t3.UADTCODIGO SANINTERVUADTCODIGO,t3.UAESCODIGO SANINTERVUAESCODIGO,t3.UATRFECALTA SANINTERVUATRFECALTA,t3.UATRFECMODIF SANINTERVUATRFECMODIF,t3.UATRUSUALTA SANINTERVUATRUSUALTA,t3.UATRUSUMODIF SANINTERVUATRUSUMODIF,t3.UAFECALTA SANINTERVUAFECALTA,t3.UAFECMODIF SANINTERVUAFECMODIF,t3.UAUSUALTA SANINTERVUAUSUALTA,t3.UAUSUMODIF SANINTERVUAUSUMODIF   + "
						+ " ,t4.EXCODIGO EXPEDIENEXCODIGO,t4.EXCOOR EXPEDIENEXCOOR,t4.EXNRAN EXPEDIENEXNRAN,t4.EXNROR EXPEDIENEXNROR,t4.EXFERE EXPEDIENEXFERE,t4.EXCOIT EXPEDIENEXCOIT,t4.EXCOES EXPEDIENEXCOES,t4.EXFEACIN EXPEDIENEXFEACIN,t4.EXFEEMCA EXPEDIENEXFEEMCA,t4.EXFEPLCA EXPEDIENEXFEPLCA,t4.EXFPNOPC EXPEDIENEXFPNOPC,t4.EXFEDE EXPEDIENEXFEDE,t4.EXFECOAL EXPEDIENEXFECOAL,t4.EXFENOPR EXPEDIENEXFENOPR,t4.EXFEPUPR EXPEDIENEXFEPUPR,t4.EXCOOSPR EXPEDIENEXCOOSPR,t4.EXFEALPR EXPEDIENEXFEALPR,t4.EXFEEL EXPEDIENEXFEEL,t4.EXFERES EXPEDIENEXFERES,t4.EXFENORE EXPEDIENEXFENORE,t4.EXFEPURE EXPEDIENEXFEPURE,t4.EXCOOSRE EXPEDIENEXCOOSRE,t4.EXCOTTR EXPEDIENEXCOTTR,t4.EXCAMURE EXPEDIENEXCAMURE,t4.EXFETA EXPEDIENEXFETA,t4.EXCOTSA EXPEDIENEXCOTSA,t4.EXFECROI EXPEDIENEXFECROI,t4.EXFEAR EXPEDIENEXFEAR,t4.EXCOORIE EXPEDIENEXCOORIE,t4.EXINRE EXPEDIENEXINRE,t4.EXINCOCO EXPEDIENEXINCOCO,t4.EXINEXVA EXPEDIENEXINEXVA,t4.EXFECIRC EXPEDIENEXFECIRC,t4.EXFENOAI EXPEDIENEXFENOAI,t4.EXFECOLM EXPEDIENEXFECOLM,t4.EXNUINLM EXPEDIENEXNUINLM,t4.EXFEINMU EXPEDIENEXFEINMU,t4.EXFEAVMU EXPEDIENEXFEAVMU,t4.EXFEIMCD EXPEDIENEXFEIMCD,t4.EXFECEDE EXPEDIENEXFECEDE,t4.EXCOPS EXPEDIENEXCOPS,t4.EXCOSE EXPEDIENEXCOSE "
						+ " ,t5.TRID SANTRAMEXPTRID2,t5.TRCODIGO SANTRAMEXPTRCODIGO2,t5.TRFECINI SANTRAMEXPTRFECINI2,t5.TRFECFIN SANTRAMEXPTRFECFIN2,/*t5.TROBSERVES SANTRAMEXPTROBSERVES2,*/t5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES2,t5.TRMOCODIGO SANTRAMEXPTRMOCODIGO2,t5.TRTRIDREL SANTRAMEXPTRTRIDREL2,t5.TRFECACINI SANTRAMEXPTRFECACINI2,t5.TRRESULTADO SANTRAMEXPTRRESULTADO2,t5.TRESTIMACION SANTRAMEXPTRESTIMACION2,t5.TRRESOFECHA SANTRAMEXPTRRESOFECHA2,t5.TRRESOTIPO SANTRAMEXPTRRESOTIPO2,t5.TRRESOSAN SANTRAMEXPTRRESOSAN2,t5.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE2,t5.TRFECREGS SANTRAMEXPTRFECREGS2,t5.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE2,t5.TRNUMREGS SANTRAMEXPTRNUMREGS2,t5.TRNUMREGE SANTRAMEXPTRNUMREGE2,t5.TRTIPOCOM SANTRAMEXPTRTIPOCOM2,t5.TRFECENVIO SANTRAMEXPTRFECENVIO2,t5.TRFECCIERRE SANTRAMEXPTRFECCIERRE2,t5.TRFECALTA SANTRAMEXPTRFECALTA2,t5.TRFECMODIF SANTRAMEXPTRFECMODIF2,t5.TRUSUALTA SANTRAMEXPTRUSUALTA2,t5.TRUSUMODIF SANTRAMEXPTRUSUMODIF2,t2.TREXCODIGO SANTRAMEXPTREXCODIGO,t3.UAEXCODIGO SANINTERVUAEXCODIGO,t5.TREXCODIGO SANTRAMEXPTREXCODIGO2 "
						+ " ,t2.TRFECREGS FECHAREGISTRO, t2.TRENVREM TRENVREM, t2.TRCODREM TRCODREM, t6.RMESTADO RMESTADO ");
		query.append("FROM SANENVIO t1 ,SANTRAMEXP t2 ,SANINTERV t3 ,EXPEDIEN t4 ,SANTRAMEXP t5, REMESA t6  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanenvio, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENEXID= t4.EXCODIGO(+) AND t1.ENTRIDACUSE= t5.TRID(+) AND t2.TRCODREM=t6.RMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanenvio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanenvio table using like.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanenvio sanenvio, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANENVIO t1 ,SANTRAMEXP t2 ,SANINTERV t3 ,EXPEDIEN t4 ,SANTRAMEXP t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanenvio, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENEXID= t4.EXCODIGO(+) AND t1.ENTRIDACUSE= t5.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanenvio entity
	 * 
	 * @param sanenvio
	 *            Sanenvio Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanenvio sanenvio) {

		StringBuilder where = new StringBuilder(
				SanenvioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanenvio != null && sanenvio.getEnid() != null) {
			where.append(" AND t1.ENID = ?");
			params.add(sanenvio.getEnid());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrid());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getExpedien() != null
				&& sanenvio.getSantramexpByEntrid().getExpedien().getExcodigo() != null) {
			where.append(" AND t2.TREXCODIGO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getExpedien()
					.getExcodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrcodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecini());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecfin());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrobserves() != null) {
			where.append(" AND t2.TROBSERVES = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrobserves());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getCensoMonitor() != null
				&& sanenvio.getSantramexpByEntrid().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.TRMOCODIGO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getCensoMonitor()
					.getMocodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrtridrel());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecacini() != null) {
			where.append(" AND t2.TRFECACINI = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecacini());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresultado());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrestimacion() != null) {
			where.append(" AND t2.TRESTIMACION = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrestimacion());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresofecha());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresotipo() != null) {
			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresotipo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresosan() != null) {
			where.append(" AND t2.TRRESOSAN = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresosan());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresoimporte());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecregs());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrestadoacuse() != null) {
			where.append(" AND t2.TRESTADOACUSE = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrestadoacuse());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrnumregs() != null) {
			where.append(" AND t2.TRNUMREGS = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrnumregs());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrnumrege() != null) {
			where.append(" AND t2.TRNUMREGE = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrnumrege());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrtipocom() != null) {
			where.append(" AND t2.TRTIPOCOM = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrtipocom());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecenvio());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfeccierre());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecalta());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecmodif());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrusualta() != null) {
			where.append(" AND t2.TRUSUALTA = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrusualta());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrusumodif() != null) {
			where.append(" AND t2.TRUSUMODIF = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrusumodif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(sanenvio.getSaninterv().getUaidinterv());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getExpedien() != null
				&& sanenvio.getSaninterv().getExpedien().getExcodigo() != null) {
			where.append(" AND t3.UAEXCODIGO = ?");
			params.add(sanenvio.getSaninterv().getExpedien().getExcodigo());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanombre() != null) {
			where.append(" AND t3.UANOMBRE = ?");
			params.add(sanenvio.getSaninterv().getUanombre());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanif() != null) {
			where.append(" AND t3.UANIF = ?");
			params.add(sanenvio.getSaninterv().getUanif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanrtel() != null) {
			where.append(" AND t3.UANRTEL = ?");
			params.add(sanenvio.getSaninterv().getUanrtel());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanrtel2() != null) {
			where.append(" AND t3.UANRTEL2 = ?");
			params.add(sanenvio.getSaninterv().getUanrtel2());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaprovId() != null) {
			where.append(" AND t3.UAPROV_ID = ?");
			params.add(sanenvio.getSaninterv().getUaprovId());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUamunId() != null) {
			where.append(" AND t3.UAMUN_ID = ?");
			params.add(sanenvio.getSaninterv().getUamunId());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUalocId() != null) {
			where.append(" AND t3.UALOC_ID = ?");
			params.add(sanenvio.getSaninterv().getUalocId());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUacalleId() != null) {
			where.append(" AND t3.UACALLE_ID = ?");
			params.add(sanenvio.getSaninterv().getUacalleId());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUacpId() != null) {
			where.append(" AND t3.UACP_ID = ?");
			params.add(sanenvio.getSaninterv().getUacpId());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaportalId() != null) {
			where.append(" AND t3.UAPORTAL_ID = ?");
			params.add(sanenvio.getSaninterv().getUaportalId());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanombrePiso() != null) {
			where.append(" AND t3.UANOMBRE_PISO = ?");
			params.add(sanenvio.getSaninterv().getUanombrePiso());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUadireNocapv() != null) {
			where.append(" AND t3.UADIRE_NOCAPV = ?");
			params.add(sanenvio.getSaninterv().getUadireNocapv());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUadireAnt() != null) {
			where.append(" AND t3.UADIRE_ANT = ?");
			params.add(sanenvio.getSaninterv().getUadireAnt());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatipointerv() != null) {
			where.append(" AND t3.UATIPOINTERV = ?");
			params.add(sanenvio.getSaninterv().getUatipointerv());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUadtcodigo() != null) {
			where.append(" AND t3.UADTCODIGO = ?");
			params.add(sanenvio.getSaninterv().getUadtcodigo());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaescodigo() != null) {
			where.append(" AND t3.UAESCODIGO = ?");
			params.add(sanenvio.getSaninterv().getUaescodigo());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(sanenvio.getSaninterv().getUatrfecalta());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(sanenvio.getSaninterv().getUatrfecmodif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrusualta() != null) {
			where.append(" AND t3.UATRUSUALTA = ?");
			params.add(sanenvio.getSaninterv().getUatrusualta());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrusumodif() != null) {
			where.append(" AND t3.UATRUSUMODIF = ?");
			params.add(sanenvio.getSaninterv().getUatrusumodif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(sanenvio.getSaninterv().getUafecalta());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(sanenvio.getSaninterv().getUafecmodif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUausualta() != null) {
			where.append(" AND t3.UAUSUALTA = ?");
			params.add(sanenvio.getSaninterv().getUausualta());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUausumodif() != null) {
			where.append(" AND t3.UAUSUMODIF = ?");
			params.add(sanenvio.getSaninterv().getUausumodif());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcodigo() != null) {
			where.append(" AND t4.EXCODIGO = ?");
			params.add(sanenvio.getExpedien().getExcodigo());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoor() != null) {
			where.append(" AND t4.EXCOOR = ?");
			params.add(sanenvio.getExpedien().getExcoor());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExnran() != null) {
			where.append(" AND t4.EXNRAN = ?");
			params.add(sanenvio.getExpedien().getExnran());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExnror() != null) {
			where.append(" AND t4.EXNROR = ?");
			params.add(sanenvio.getExpedien().getExnror());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfere() != null) {
			where.append(" AND t4.EXFERE = ?");
			params.add(sanenvio.getExpedien().getExfere());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoit() != null) {
			where.append(" AND t4.EXCOIT = ?");
			params.add(sanenvio.getExpedien().getExcoit());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoes() != null) {
			where.append(" AND t4.EXCOES = ?");
			params.add(sanenvio.getExpedien().getExcoes());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeacin() != null) {
			where.append(" AND t4.EXFEACIN = ?");
			params.add(sanenvio.getExpedien().getExfeacin());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeemca() != null) {
			where.append(" AND t4.EXFEEMCA = ?");
			params.add(sanenvio.getExpedien().getExfeemca());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeplca() != null) {
			where.append(" AND t4.EXFEPLCA = ?");
			params.add(sanenvio.getExpedien().getExfeplca());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfpnopc() != null) {
			where.append(" AND t4.EXFPNOPC = ?");
			params.add(sanenvio.getExpedien().getExfpnopc());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfede() != null) {
			where.append(" AND t4.EXFEDE = ?");
			params.add(sanenvio.getExpedien().getExfede());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecoal() != null) {
			where.append(" AND t4.EXFECOAL = ?");
			params.add(sanenvio.getExpedien().getExfecoal());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfenopr() != null) {
			where.append(" AND t4.EXFENOPR = ?");
			params.add(sanenvio.getExpedien().getExfenopr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfepupr() != null) {
			where.append(" AND t4.EXFEPUPR = ?");
			params.add(sanenvio.getExpedien().getExfepupr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoospr() != null) {
			where.append(" AND t4.EXCOOSPR = ?");
			params.add(sanenvio.getExpedien().getExcoospr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfealpr() != null) {
			where.append(" AND t4.EXFEALPR = ?");
			params.add(sanenvio.getExpedien().getExfealpr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeel() != null) {
			where.append(" AND t4.EXFEEL = ?");
			params.add(sanenvio.getExpedien().getExfeel());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExferes() != null) {
			where.append(" AND t4.EXFERES = ?");
			params.add(sanenvio.getExpedien().getExferes());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfenore() != null) {
			where.append(" AND t4.EXFENORE = ?");
			params.add(sanenvio.getExpedien().getExfenore());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfepure() != null) {
			where.append(" AND t4.EXFEPURE = ?");
			params.add(sanenvio.getExpedien().getExfepure());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoosre() != null) {
			where.append(" AND t4.EXCOOSRE = ?");
			params.add(sanenvio.getExpedien().getExcoosre());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcottr() != null) {
			where.append(" AND t4.EXCOTTR = ?");
			params.add(sanenvio.getExpedien().getExcottr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcamure() != null) {
			where.append(" AND t4.EXCAMURE = ?");
			params.add(sanenvio.getExpedien().getExcamure());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeta() != null) {
			where.append(" AND t4.EXFETA = ?");
			params.add(sanenvio.getExpedien().getExfeta());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcotsa() != null) {
			where.append(" AND t4.EXCOTSA = ?");
			params.add(sanenvio.getExpedien().getExcotsa());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecroi() != null) {
			where.append(" AND t4.EXFECROI = ?");
			params.add(sanenvio.getExpedien().getExfecroi());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfear() != null) {
			where.append(" AND t4.EXFEAR = ?");
			params.add(sanenvio.getExpedien().getExfear());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoorie() != null) {
			where.append(" AND t4.EXCOORIE = ?");
			params.add(sanenvio.getExpedien().getExcoorie());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExinre() != null) {
			where.append(" AND t4.EXINRE = ?");
			params.add(sanenvio.getExpedien().getExinre());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExincoco() != null) {
			where.append(" AND t4.EXINCOCO = ?");
			params.add(sanenvio.getExpedien().getExincoco());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExinexva() != null) {
			where.append(" AND t4.EXINEXVA = ?");
			params.add(sanenvio.getExpedien().getExinexva());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecirc() != null) {
			where.append(" AND t4.EXFECIRC = ?");
			params.add(sanenvio.getExpedien().getExfecirc());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfenoai() != null) {
			where.append(" AND t4.EXFENOAI = ?");
			params.add(sanenvio.getExpedien().getExfenoai());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecolm() != null) {
			where.append(" AND t4.EXFECOLM = ?");
			params.add(sanenvio.getExpedien().getExfecolm());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExnuinlm() != null) {
			where.append(" AND t4.EXNUINLM = ?");
			params.add(sanenvio.getExpedien().getExnuinlm());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeinmu() != null) {
			where.append(" AND t4.EXFEINMU = ?");
			params.add(sanenvio.getExpedien().getExfeinmu());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeavmu() != null) {
			where.append(" AND t4.EXFEAVMU = ?");
			params.add(sanenvio.getExpedien().getExfeavmu());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeimcd() != null) {
			where.append(" AND t4.EXFEIMCD = ?");
			params.add(sanenvio.getExpedien().getExfeimcd());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecede() != null) {
			where.append(" AND t4.EXFECEDE = ?");
			params.add(sanenvio.getExpedien().getExfecede());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcops() != null) {
			where.append(" AND t4.EXCOPS = ?");
			params.add(sanenvio.getExpedien().getExcops());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcose() != null) {
			where.append(" AND t4.EXCOSE = ?");
			params.add(sanenvio.getExpedien().getExcose());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getSanexp() != null
				&& sanenvio.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t4.EXCODIGO = ?");
			params.add(sanenvio.getExpedien().getSanexp().getExcodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrid() != null) {
			where.append(" AND t5.TRID = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrid());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getExpedien() != null
				&& sanenvio.getSantramexpByEntridacuse().getExpedien()
						.getExcodigo() != null) {
			where.append(" AND t5.TREXCODIGO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getExpedien()
					.getExcodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrcodigo() != null) {
			where.append(" AND t5.TRCODIGO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrcodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecini() != null) {
			where.append(" AND t5.TRFECINI = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecini());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecfin() != null) {
			where.append(" AND t5.TRFECFIN = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecfin());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrobserves() != null) {
			where.append(" AND t5.TROBSERVES = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrobserves());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t5.TRMOCODIGO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getCensoMonitor()
					.getMocodigo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrtridrel() != null) {
			where.append(" AND t5.TRTRIDREL = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrtridrel());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecacini() != null) {
			where.append(" AND t5.TRFECACINI = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecacini());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresultado() != null) {
			where.append(" AND t5.TRRESULTADO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresultado());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrestimacion() != null) {
			where.append(" AND t5.TRESTIMACION = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrestimacion());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresofecha() != null) {
			where.append(" AND t5.TRRESOFECHA = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresofecha());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresotipo() != null) {
			where.append(" AND t5.TRRESOTIPO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresotipo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresosan() != null) {
			where.append(" AND t5.TRRESOSAN = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresosan());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresoimporte() != null) {
			where.append(" AND t5.TRRESOIMPORTE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresoimporte());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecregs() != null) {
			where.append(" AND t5.TRFECREGS = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecregs());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrestadoacuse() != null) {
			where.append(" AND t5.TRESTADOACUSE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrestadoacuse());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrnumregs() != null) {
			where.append(" AND t5.TRNUMREGS = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrnumregs());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrnumrege() != null) {
			where.append(" AND t5.TRNUMREGE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrnumrege());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrtipocom() != null) {
			where.append(" AND t5.TRTIPOCOM = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrtipocom());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecenvio() != null) {
			where.append(" AND t5.TRFECENVIO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecenvio());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfeccierre() != null) {
			where.append(" AND t5.TRFECCIERRE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfeccierre());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecalta() != null) {
			where.append(" AND t5.TRFECALTA = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecalta());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecmodif() != null) {
			where.append(" AND t5.TRFECMODIF = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecmodif());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrusualta() != null) {
			where.append(" AND t5.TRUSUALTA = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrusualta());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrusumodif() != null) {
			where.append(" AND t5.TRUSUMODIF = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrusumodif());
		}
		if (sanenvio != null && sanenvio.getEnfecenvio() != null) {
			where.append(" AND t1.ENFECENVIO = ?");
			params.add(sanenvio.getEnfecenvio());
		}
		if (sanenvio != null && sanenvio.getEnfecacuse() != null) {
			where.append(" AND t1.ENFECACUSE = ?");
			params.add(sanenvio.getEnfecacuse());
		}
		if (sanenvio != null && sanenvio.getEnestado() != null) {
			where.append(" AND t1.ENESTADO = ?");
			params.add(sanenvio.getEnestado());
		}
		if (sanenvio != null && sanenvio.getEnfecalta() != null) {
			where.append(" AND t1.ENFECALTA = ?");
			params.add(sanenvio.getEnfecalta());
		}
		if (sanenvio != null && sanenvio.getEnfecmodif() != null) {
			where.append(" AND t1.ENFECMODIF = ?");
			params.add(sanenvio.getEnfecmodif());
		}
		if (sanenvio != null && sanenvio.getEnusualta() != null) {
			where.append(" AND t1.ENUSUALTA = ?");
			params.add(sanenvio.getEnusualta());
		}
		if (sanenvio != null && sanenvio.getEnusumodif() != null) {
			where.append(" AND t1.ENUSUMODIF = ?");
			params.add(sanenvio.getEnusumodif());
		}
		if (sanenvio != null && sanenvio.getEntipoenvio() != null) {
			where.append(" AND t1.ENTIPOENVIO = ?");
			params.add(sanenvio.getEntipoenvio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanenvio entity
	 * 
	 * @param sanenvio
	 *            Sanenvio Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanenvio sanenvio, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanenvioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanenvio != null && sanenvio.getEnid() != null) {
			where.append(" AND t1.ENID = ?");
			params.add(sanenvio.getEnid());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrid());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getExpedien() != null
				&& sanenvio.getSantramexpByEntrid().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t2.TREXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getExpedien()
						.getExcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getExpedien()
								.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TREXCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrcodigo() != null) {
			where.append(" AND UPPER(t2.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecini());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecfin());
		}

		if (sanenvio != null
				&& sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getCensoMonitor() != null
				&& sanenvio.getSantramexpByEntrid().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t2.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TRMOCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrtridrel());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecacini() != null) {
			where.append(" AND t2.TRFECACINI = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecacini());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresultado());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrestimacion() != null) {
			where.append(" AND UPPER(t2.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrestimacion()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrestimacion()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTIMACION IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresofecha());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresotipo() != null) {
			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresotipo());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresosan() != null) {

			where.append(" AND t2.TRRESOSAN = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresultado());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresoimporte());

		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecregs());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t2.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrestadoacuse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrestadoacuse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTADOACUSE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrnumregs() != null) {
			where.append(" AND UPPER(t2.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrnumregs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrnumregs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNUMREGS IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrnumrege() != null) {
			where.append(" AND UPPER(t2.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrnumrege()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrnumrege()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNUMREGE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrtipocom() != null) {
			where.append(" AND UPPER(t2.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrtipocom()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrtipocom()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRTIPOCOM IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecenvio());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfeccierre());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecalta());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrfecmodif());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrusualta() != null) {
			where.append(" AND UPPER(t2.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUALTA IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntrid() != null
				&& sanenvio.getSantramexpByEntrid().getTrusumodif() != null) {
			where.append(" AND UPPER(t2.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntrid().getTrusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntrid().getTrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUMODIF IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(sanenvio.getSaninterv().getUaidinterv());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getExpedien() != null
				&& sanenvio.getSaninterv().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t3.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getExpedien().getExcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getExpedien().getExcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAEXCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanombre() != null) {
			where.append(" AND UPPER(t3.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUanombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUanombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANOMBRE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanif() != null) {
			where.append(" AND UPPER(t3.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUanif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUanif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANIF IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanrtel() != null) {
			where.append(" AND UPPER(t3.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUanrtel().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUanrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANRTEL IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanrtel2() != null) {
			where.append(" AND UPPER(t3.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUanrtel2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUanrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANRTEL2 IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaprovId() != null) {
			where.append(" AND UPPER(t3.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUaprovId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUaprovId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAPROV_ID IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUamunId() != null) {
			where.append(" AND UPPER(t3.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUamunId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUamunId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAMUN_ID IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUalocId() != null) {
			where.append(" AND UPPER(t3.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUalocId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUalocId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UALOC_ID IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUacalleId() != null) {
			where.append(" AND UPPER(t3.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUacalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUacalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UACALLE_ID IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUacpId() != null) {
			where.append(" AND UPPER(t3.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUacpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUacpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UACP_ID IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaportalId() != null) {
			where.append(" AND UPPER(t3.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUaportalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUaportalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAPORTAL_ID IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUanombrePiso() != null) {
			where.append(" AND UPPER(t3.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUanombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUanombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UANOMBRE_PISO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUadireNocapv() != null) {
			where.append(" AND UPPER(t3.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUadireNocapv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUadireNocapv()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UADIRE_NOCAPV IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUadireAnt() != null) {
			where.append(" AND UPPER(t3.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUadireAnt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUadireAnt().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UADIRE_ANT IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatipointerv() != null) {
			where.append(" AND UPPER(t3.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUatipointerv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUatipointerv()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATIPOINTERV IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUadtcodigo() != null) {
			where.append(" AND UPPER(t3.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUadtcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUadtcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UADTCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUaescodigo() != null) {
			where.append(" AND UPPER(t3.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUaescodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUaescodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAESCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(sanenvio.getSaninterv().getUatrfecalta());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(sanenvio.getSaninterv().getUatrfecmodif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrusualta() != null) {
			where.append(" AND UPPER(t3.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUatrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUatrusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUALTA IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUatrusumodif() != null) {
			where.append(" AND UPPER(t3.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUatrusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUatrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUMODIF IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(sanenvio.getSaninterv().getUafecalta());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(sanenvio.getSaninterv().getUafecmodif());
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUausualta() != null) {
			where.append(" AND UPPER(t3.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUausualta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUausualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAUSUALTA IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSaninterv() != null
				&& sanenvio.getSaninterv().getUausumodif() != null) {
			where.append(" AND UPPER(t3.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSaninterv().getUausumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSaninterv().getUausumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAUSUMODIF IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcodigo() != null) {
			where.append(" AND t4.EXCODIGO = ?");
			params.add(sanenvio.getExpedien().getExcodigo());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t4.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOOR IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExnran() != null) {
			where.append(" AND t4.EXNRAN = ?");
			params.add(sanenvio.getExpedien().getExnran());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExnror() != null) {
			where.append(" AND t4.EXNROR = ?");
			params.add(sanenvio.getExpedien().getExnror());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfere() != null) {
			where.append(" AND t4.EXFERE = ?");
			params.add(sanenvio.getExpedien().getExfere());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t4.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcoit().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcoit().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOIT IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t4.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcoes().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcoes().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOES IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeacin() != null) {
			where.append(" AND t4.EXFEACIN = ?");
			params.add(sanenvio.getExpedien().getExfeacin());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeemca() != null) {
			where.append(" AND t4.EXFEEMCA = ?");
			params.add(sanenvio.getExpedien().getExfeemca());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeplca() != null) {
			where.append(" AND t4.EXFEPLCA = ?");
			params.add(sanenvio.getExpedien().getExfeplca());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfpnopc() != null) {
			where.append(" AND t4.EXFPNOPC = ?");
			params.add(sanenvio.getExpedien().getExfpnopc());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfede() != null) {
			where.append(" AND t4.EXFEDE = ?");
			params.add(sanenvio.getExpedien().getExfede());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecoal() != null) {
			where.append(" AND t4.EXFECOAL = ?");
			params.add(sanenvio.getExpedien().getExfecoal());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfenopr() != null) {
			where.append(" AND t4.EXFENOPR = ?");
			params.add(sanenvio.getExpedien().getExfenopr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfepupr() != null) {
			where.append(" AND t4.EXFEPUPR = ?");
			params.add(sanenvio.getExpedien().getExfepupr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t4.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOOSPR IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfealpr() != null) {
			where.append(" AND t4.EXFEALPR = ?");
			params.add(sanenvio.getExpedien().getExfealpr());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeel() != null) {
			where.append(" AND t4.EXFEEL = ?");
			params.add(sanenvio.getExpedien().getExfeel());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExferes() != null) {
			where.append(" AND t4.EXFERES = ?");
			params.add(sanenvio.getExpedien().getExferes());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfenore() != null) {
			where.append(" AND t4.EXFENORE = ?");
			params.add(sanenvio.getExpedien().getExfenore());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfepure() != null) {
			where.append(" AND t4.EXFEPURE = ?");
			params.add(sanenvio.getExpedien().getExfepure());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t4.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOOSRE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t4.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcottr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcottr().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOTTR IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcamure() != null) {
			where.append(" AND t4.EXCAMURE = ?");
			params.add(sanenvio.getExpedien().getExcamure());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeta() != null) {
			where.append(" AND t4.EXFETA = ?");
			params.add(sanenvio.getExpedien().getExfeta());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t4.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOTSA IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecroi() != null) {
			where.append(" AND t4.EXFECROI = ?");
			params.add(sanenvio.getExpedien().getExfecroi());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfear() != null) {
			where.append(" AND t4.EXFEAR = ?");
			params.add(sanenvio.getExpedien().getExfear());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t4.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOORIE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t4.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXINRE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t4.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExincoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExincoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXINCOCO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t4.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExinexva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExinexva().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXINEXVA IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecirc() != null) {
			where.append(" AND t4.EXFECIRC = ?");
			params.add(sanenvio.getExpedien().getExfecirc());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfenoai() != null) {
			where.append(" AND t4.EXFENOAI = ?");
			params.add(sanenvio.getExpedien().getExfenoai());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecolm() != null) {
			where.append(" AND t4.EXFECOLM = ?");
			params.add(sanenvio.getExpedien().getExfecolm());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t4.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXNUINLM IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeinmu() != null) {
			where.append(" AND t4.EXFEINMU = ?");
			params.add(sanenvio.getExpedien().getExfeinmu());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeavmu() != null) {
			where.append(" AND t4.EXFEAVMU = ?");
			params.add(sanenvio.getExpedien().getExfeavmu());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfeimcd() != null) {
			where.append(" AND t4.EXFEIMCD = ?");
			params.add(sanenvio.getExpedien().getExfeimcd());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExfecede() != null) {
			where.append(" AND t4.EXFECEDE = ?");
			params.add(sanenvio.getExpedien().getExfecede());
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t4.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcops().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOPS IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t4.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getExcose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getExcose().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EXCOSE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getExpedien() != null
				&& sanenvio.getExpedien().getSanexp() != null
				&& sanenvio.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t4.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getExpedien().getSanexp().getExcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getExpedien().getSanexp().getExcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.EXCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrid() != null) {
			where.append(" AND t5.TRID = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrid());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getExpedien() != null
				&& sanenvio.getSantramexpByEntridacuse().getExpedien()
						.getExcodigo() != null) {
			where.append(" AND UPPER(t5.TREXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse().getExpedien()
						.getExcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getExpedien()
								.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t5.TREXCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrcodigo() != null) {
			where.append(" AND UPPER(t5.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse().getTrcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getTrcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TRCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecini() != null) {
			where.append(" AND t5.TRFECINI = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecini());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecfin() != null) {
			where.append(" AND t5.TRFECFIN = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecfin());
		}

		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getCensoMonitor() != null
				&& sanenvio.getSantramexpByEntridacuse().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t5.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse()
						.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse()
								.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.TRMOCODIGO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrtridrel() != null) {
			where.append(" AND t5.TRTRIDREL = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrtridrel());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecacini() != null) {
			where.append(" AND t5.TRFECACINI = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecacini());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresultado() != null) {
			where.append(" AND t5.TRRESULTADO = ?");
			params.add(sanenvio.getSantramexpByEntrid().getTrresultado());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrestimacion() != null) {
			where.append(" AND UPPER(t5.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse()
						.getTrestimacion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse()
								.getTrestimacion().toUpperCase() + "%");
			}
			where.append(" AND t5.TRESTIMACION IS NOT NULL");
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresofecha() != null) {
			where.append(" AND t5.TRRESOFECHA = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresofecha());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresotipo() != null) {

			where.append(" AND t5.TRRESOTIPO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresotipo());

		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresosan() != null) {

			where.append(" AND t5.TRRESOSAN = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresosan());

		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrresoimporte() != null) {

			where.append(" AND t5.TRRESOIMPORTE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrresoimporte());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecregs() != null) {
			where.append(" AND t5.TRFECREGS = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecregs());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t5.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse()
						.getTrestadoacuse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse()
								.getTrestadoacuse().toUpperCase() + "%");
			}
			where.append(" AND t5.TRESTADOACUSE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrnumregs() != null) {
			where.append(" AND UPPER(t5.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse().getTrnumregs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getTrnumregs()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TRNUMREGS IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrnumrege() != null) {
			where.append(" AND UPPER(t5.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse().getTrnumrege()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getTrnumrege()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TRNUMREGE IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrtipocom() != null) {
			where.append(" AND UPPER(t5.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse().getTrtipocom()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getTrtipocom()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TRTIPOCOM IS NOT NULL");
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecenvio() != null) {
			where.append(" AND t5.TRFECENVIO = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecenvio());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfeccierre() != null) {
			where.append(" AND t5.TRFECCIERRE = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfeccierre());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecalta() != null) {
			where.append(" AND t5.TRFECALTA = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecalta());
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrfecmodif() != null) {
			where.append(" AND t5.TRFECMODIF = ?");
			params.add(sanenvio.getSantramexpByEntridacuse().getTrfecmodif());
		}
		if (sanenvio != null && sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrusualta() != null) {
			where.append(" AND UPPER(t5.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse().getTrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getTrusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TRUSUALTA IS NOT NULL");
		}
		if (sanenvio != null
				&& sanenvio.getSantramexpByEntridacuse() != null
				&& sanenvio.getSantramexpByEntridacuse().getTrusumodif() != null) {
			where.append(" AND UPPER(t5.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getSantramexpByEntridacuse()
						.getTrusumodif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanenvio.getSantramexpByEntridacuse().getTrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TRUSUMODIF IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getEnfecenvio() != null) {
			where.append(" AND t1.ENFECENVIO = ?");
			params.add(sanenvio.getEnfecenvio());
		}
		if (sanenvio != null && sanenvio.getEnfecacuse() != null) {
			where.append(" AND t1.ENFECACUSE = ?");
			params.add(sanenvio.getEnfecacuse());
		}
		if (sanenvio != null && sanenvio.getEnestado() != null) {
			where.append(" AND UPPER(t1.ENESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getEnestado().toUpperCase() + "%");
			} else {
				params.add("%" + sanenvio.getEnestado().toUpperCase() + "%");
			}
			where.append(" AND t1.ENESTADO IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getEnfecalta() != null) {
			where.append(" AND t1.ENFECALTA = ?");
			params.add(sanenvio.getEnfecalta());
		}
		if (sanenvio != null && sanenvio.getEnfecmodif() != null) {
			where.append(" AND t1.ENFECMODIF = ?");
			params.add(sanenvio.getEnfecmodif());
		}
		if (sanenvio != null && sanenvio.getEnusualta() != null) {
			where.append(" AND UPPER(t1.ENUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getEnusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanenvio.getEnusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.ENUSUALTA IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getEnusumodif() != null) {
			where.append(" AND UPPER(t1.ENUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanenvio.getEnusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanenvio.getEnusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.ENUSUMODIF IS NOT NULL");
		}
		if (sanenvio != null && sanenvio.getEntipoenvio() != null) {
			where.append(" AND t1.ENTIPOENVIO = ?");
			params.add(sanenvio.getEntipoenvio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a List of rows in the Sanenvio table.
	 * 
	 * @param sanenvio
	 *            Sanenvio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanenvio> findSanEnvioResolucion(String excodigo) {
		StringBuilder query = new StringBuilder(
				"SELECT ENID, ENFECENVIO, ENFECACUSE, ENESTADO, ENFECALTA, ENFECMODIF, ENUSUALTA, ENUSUMODIF, ENTIPOENVIO ");
		query.append("FROM SANENVIO ");

		// Where clause & Params
		List<Object> params = new ArrayList<Object>();
		params.add(excodigo);
		params.add(excodigo);
		params.add(excodigo);
		StringBuilder where = new StringBuilder(
				" WHERE ENTRID IN (SELECT MAX(TRID) FROM ("
						+ "SELECT T0.TRID FROM SANTRAMEXP T0 WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION
						+ "' AND TREXCODIGO=? AND TRCODIGOREL='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION
						+ "' "
						+ "UNION "
						+ "SELECT T1.TRID FROM SANTRAMEXP T1 WHERE T1.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION
						+ "' AND T1.TREXCODIGO=? AND T1.TRCODIGOREL='"
						+ Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
						+ "' AND EXISTS ( "
						+ "SELECT 1 FROM SANTRAMEXP T2 WHERE T1.TRTRIDREL=T2.TRID AND T2.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
						+ "' AND T2.TREXCODIGO=? AND T2.TRCODIGOREL='"
						+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION + "')))");
		// Where clause & Params
		query.append(where);

		return (List<Sanenvio>) this.jdbcTemplate.query(query.toString(),
				this.rwMapAux, params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
