package com.ejie.y41b.dao;

import ch.qos.logback.classic.Logger;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * SandoctempDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class SandoctempDaoImpl implements SandoctempDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = (Logger) LoggerFactory.getLogger(SandoctempDaoImpl.class);

	private RowMapper<Sandoctemp> rwMap = new RowMapper<Sandoctemp>() {
		public Sandoctemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sandoctemp sandoctemp = new Sandoctemp(resultSet.getString("U5CODOCUMENTO"),
					resultSet.getString("U5EXCODIGO"), resultSet.getString("U5NOFILE"), resultSet.getBlob("U5DATAFILE"),
					resultSet.getInt("U5SIZEFILE"), resultSet.getString("U5TEDESFILE"), resultSet.getString("U5ORIGEN"),
					resultSet.getString("U5TRAMITE"), resultSet.getDate("U5FECHA"), resultSet.getString("U5INDMAIL"),
					resultSet.getString("U5TRMAIL"), resultSet.getString("U5CONTTYPE"),
					resultSet.getString("U5IDDOCUMENTUM"), resultSet.getDate("U5FECHAAPORTACION"),
					resultSet.getDate("U5FECHAENTRADA"), resultSet.getString("U5NUMREGISTROENTRADA"),
					resultSet.getString("U5IDPERFILFIRMA"), resultSet.getString("U5ESTADODOCUMENTO"),
					resultSet.getDate("U5FECHASOLFIRMA"), resultSet.getDate("U5FECHALIMFIRMA"),
					resultSet.getDate("U5FECHAFIRMA"), resultSet.getString("U5COMOFIRMA"),
					resultSet.getString("U5TIPODOCUMENTO"), resultSet.getString("U5DESTINO"),
					resultSet.getString("U5PTCODIGO"), resultSet.getTimestamp("U5FECHASOLLOCALIZADOR"),
					resultSet.getString("PCODIGO"), resultSet.getString("U5IDINTERVINIENTE"));
			sandoctemp.setU5fecharegistroorigen(resultSet.getTimestamp("U5FECHAREGISTROORIGEN"));
			return sandoctemp;
		}
	};

	private RowMapper<DocumentoExpediente> rwMapDocExp = new RowMapper<DocumentoExpediente>() {
		public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return new DocumentoExpediente(resultSet.getString("U5CODOCUMENTO"), resultSet.getString("U5EXCODIGO"),
					resultSet.getString("U5NOFILE"), null, resultSet.getInt("U5SIZEFILE"),
					resultSet.getString("U5CONTTYPE"), resultSet.getString("U5TEDESFILE"),
					resultSet.getString("U5ORIGEN"), resultSet.getDate("U5FECHA"),
					resultSet.getString("U5IDDOCUMENTUM"), null, null, null, resultSet.getString("IDTIPODOC"),
					resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE"), null, null, null, null, null,
					null, null, null);

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Pagination
	 * @return Sandoctemp
	 */
	public Sandoctemp add(Sandoctemp sandoctemp) {
		String query = "INSERT INTO SANDOCTEMP (U5CODOCUMENTO, U5EXCODIGO, U5TRAMITE, U5NOFILE, U5DATAFILE, U5SIZEFILE, U5TEDESFILE, U5ORIGEN, U5FECHA, U5CONTTYPE, U5INDMAIL, U5TRMAIL, U5IDDOCUMENTUM, U5TIPODOCUMENTO, U5FECHAAPORTACION, U5FECHAENTRADA, U5NUMREGISTROENTRADA, U5ID_PERFILFIRMA, U5ESTADODOCUMENTO, U5FECHASOLFIRMA, U5FECHAFIRMA, U5COMOFIRMA, U5FECALTA, U5FECMODIF, U5USUALTA, U5USUMODIF, U5PTCODIGO, U5IDINTERVINIENTE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, sandoctemp.getU5codocumento(),
				sandoctemp.getExpedien() == null ? null : sandoctemp.getExpedien().getExcodigo(),
				sandoctemp.getSantramexp() == null ? null : sandoctemp.getSantramexp().getTrid(),
				sandoctemp.getU5nofile(),
				sandoctemp.getU5datafile() == null ? null : Y41bJdbcUtils.ConvertBlobToByte(sandoctemp.getU5datafile()),
				sandoctemp.getU5sizefile(), sandoctemp.getU5tedesfile(), sandoctemp.getU5origen(),
				sandoctemp.getU5fecha(), sandoctemp.getU5conttype(), sandoctemp.getU5indmail(),
				sandoctemp.getU5trmail(), sandoctemp.getU5iddocumentum(), sandoctemp.getU5tipodocumento(),
				sandoctemp.getU5fechaaportacion(), sandoctemp.getU5fechaentrada(), sandoctemp.getU5numregistroentrada(),
				sandoctemp.getU5idPerfilfirma(), sandoctemp.getU5estadodocumento(), sandoctemp.getU5fechasolfirma(),
				sandoctemp.getU5fechafirma(), sandoctemp.getU5comofirma(), sandoctemp.getU5fecalta(),
				sandoctemp.getU5fecmodif(), sandoctemp.getU5usualta(), sandoctemp.getU5usumodif(),
				sandoctemp.getU5ptcodigo(), sandoctemp.getU5idinterviniente());
		return sandoctemp;
	}

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Pagination
	 * @return Sandoctemp
	 */
	public Sandoctemp update(Sandoctemp sandoctemp) {
		String query = "UPDATE SANDOCTEMP SET U5EXCODIGO=?, U5TRAMITE=?, U5NOFILE=?, U5DATAFILE=?, U5SIZEFILE=?, U5TEDESFILE=?, U5ORIGEN=?, U5FECHA=?, U5CONTTYPE=?, U5INDMAIL=?, U5TRMAIL=?, U5IDDOCUMENTUM=?, U5TIPODOCUMENTO=?, U5FECHAAPORTACION=?, U5FECHAENTRADA=?, U5NUMREGISTROENTRADA=?, U5ID_PERFILFIRMA=?, U5ESTADODOCUMENTO=?, U5FECHASOLFIRMA=?, U5FECHAFIRMA=?, U5COMOFIRMA=?, U5FECALTA=?, U5FECMODIF=?, U5USUALTA=?, U5USUMODIF=?, U5PTCODIGO =?, U5IDINTERVINIENTE =? WHERE U5CODOCUMENTO=?";

		this.jdbcTemplate.update(query,
				sandoctemp.getExpedien() == null ? null : sandoctemp.getExpedien().getExcodigo(),
				sandoctemp.getSantramexp() == null ? null : sandoctemp.getSantramexp().getTrid(),
				sandoctemp.getU5nofile(),
				sandoctemp.getU5datafile() == null ? null : Y41bJdbcUtils.ConvertBlobToByte(sandoctemp.getU5datafile()),
				sandoctemp.getU5sizefile(), sandoctemp.getU5tedesfile(), sandoctemp.getU5origen(),
				sandoctemp.getU5fecha(), sandoctemp.getU5conttype(), sandoctemp.getU5indmail(),
				sandoctemp.getU5trmail(), sandoctemp.getU5iddocumentum(), sandoctemp.getU5tipodocumento(),
				sandoctemp.getU5fechaaportacion(), sandoctemp.getU5fechaentrada(), sandoctemp.getU5numregistroentrada(),
				sandoctemp.getU5idPerfilfirma(), sandoctemp.getU5estadodocumento(), sandoctemp.getU5fechasolfirma(),
				sandoctemp.getU5fechafirma(), sandoctemp.getU5comofirma(), sandoctemp.getU5fecalta(),
				sandoctemp.getU5fecmodif(), sandoctemp.getU5usualta(), sandoctemp.getU5usumodif(),
				sandoctemp.getU5ptcodigo(), sandoctemp.getU5idinterviniente(), sandoctemp.getU5codocumento());
		return sandoctemp;
	}

	/**
	 * Finds a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Pagination
	 * @return Sandoctemp
	 */
	@Transactional(readOnly = true)
	public Sandoctemp find(Sandoctemp sandoctemp) {
		try {
			String query = "SELECT t1.U5CODOCUMENTO U5CODOCUMENTO, t1.U5EXCODIGO U5EXCODIGO, t1.U5DATAFILE, t1.U5FECHALIMFIRMA U5FECHALIMFIRMA, t1.U5TRAMITE U5TRAMITE, t1.U5NOFILE U5NOFILE, t1.U5SIZEFILE U5SIZEFILE, "
					+ " t1.U5TEDESFILE U5TEDESFILE, t1.U5ORIGEN U5ORIGEN, t1.U5FECHA U5FECHA, t1.U5CONTTYPE U5CONTTYPE, t1.U5INDMAIL U5INDMAIL, t1.U5TRMAIL U5TRMAIL, t1.U5IDDOCUMENTUM U5IDDOCUMENTUM, "
					+ " t1.U5TIPODOCUMENTO U5TIPODOCUMENTO, t1.U5FECHAAPORTACION U5FECHAAPORTACION, t1.U5FECHAENTRADA U5FECHAENTRADA, t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA, t1.U5ID_PERFILFIRMA "
					+ " U5IDPERFILFIRMA, t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO, t1.U5FECHASOLFIRMA U5FECHASOLFIRMA, t1.U5FECHAFIRMA U5FECHAFIRMA, t1.U5COMOFIRMA U5COMOFIRMA, t1.U5DESTINO U5DESTINO, "
					+ "  t1.U5PTCODIGO U5PTCODIGO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR, t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN, null PCODIGO, t1.U5IDINTERVINIENTE U5IDINTERVINIENTE "
					+ " FROM SANDOCTEMP t1 WHERE  t1.U5CODOCUMENTO = ? ";

			List<Sandoctemp> sandoctempList = this.jdbcTemplate.query(query, this.rwMap, sandoctemp.getU5codocumento());
			return (Sandoctemp) DataAccessUtils.uniqueResult(sandoctempList);
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en find: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Removes a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Pagination
	 * @return
	 */
	public void remove(Sandoctemp sandoctemp) {
		String query = "DELETE FROM SANDOCTEMP WHERE U5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, sandoctemp.getU5codocumento());
	}

	/**
	 * Finds a List of rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sandoctemp> findAll(Sandoctemp sandoctemp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.U5CODOCUMENTO U5CODOCUMENTO,t1.U5EXCODIGO U5EXCODIGO,t1.U5TRAMITE U5TRAMITE,t1.U5DESTINO U5DESTINO,t1.U5FECHALIMFIRMA U5FECHALIMFIRMA,t1.U5NOFILE U5NOFILE,null U5DATAFILE, t1.U5SIZEFILE U5SIZEFILE,t1.U5TEDESFILE U5TEDESFILE,t1.U5ORIGEN U5ORIGEN,t1.U5FECHA U5FECHA,t1.U5CONTTYPE U5CONTTYPE,t1.U5INDMAIL U5INDMAIL,t1.U5TRMAIL U5TRMAIL,t1.U5IDDOCUMENTUM U5IDDOCUMENTUM,t1.U5TIPODOCUMENTO U5TIPODOCUMENTO,t1.U5FECHAAPORTACION U5FECHAAPORTACION,t1.U5FECHAENTRADA U5FECHAENTRADA,t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA,t1.U5ID_PERFILFIRMA U5IDPERFILFIRMA,t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO,t1.U5FECHASOLFIRMA U5FECHASOLFIRMA,t1.U5FECHAFIRMA U5FECHAFIRMA,t1.U5COMOFIRMA U5COMOFIRMA,t1.U5FECALTA U5FECALTA,t1.U5FECMODIF U5FECMODIF,t1.U5USUALTA U5USUALTA,t1.U5USUMODIF U5USUMODIF, t1.U5PTCODIGO U5PTCODIGO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR , t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN, t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.TRID SANTRAMEXPTRID,t3.TRCODIGO SANTRAMEXPTRCODIGO,t3.TRFECINI SANTRAMEXPTRFECINI,t3.TRFECFIN SANTRAMEXPTRFECFIN,/*t3.TROBSERVES SANTRAMEXPTROBSERVES,*/t3.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t3.TRTRIDREL SANTRAMEXPTRTRIDREL,t3.TRFECACINI SANTRAMEXPTRFECACINI,t3.TRRESULTADO SANTRAMEXPTRRESULTADO,t3.TRESTIMACION SANTRAMEXPTRESTIMACION,t3.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t3.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t3.TRRESOSAN SANTRAMEXPTRRESOSAN,t3.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t3.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t3.TRNUMREGS SANTRAMEXPTRNUMREGS,t3.TRNUMREGE SANTRAMEXPTRNUMREGE,t3.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t3.TRFECENVIO SANTRAMEXPTRFECENVIO,t3.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t3.TRFECALTA SANTRAMEXPTRFECALTA,t3.TRFECMODIF SANTRAMEXPTRFECMODIF,t3.TRUSUALTA SANTRAMEXPTRUSUALTA,t3.TRUSUMODIF SANTRAMEXPTRUSUMODIF,t3.TREXCODIGO SANTRAMEXPTREXCODIGO,null PCODIGO,t1.U5IDINTERVINIENTE U5IDINTERVINIENTE ");
		query.append("FROM SANDOCTEMP t1 ,EXPEDIEN t2 ,SANTRAMEXP t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sandoctemp);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.U5EXCODIGO= t2.EXCODIGO(+) AND t1.U5TRAMITE= t3.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sandoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sandoctemp sandoctemp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANDOCTEMP t1 , EXPEDIEN t2 , SANTRAMEXP t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sandoctemp);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.U5EXCODIGO= t2.EXCODIGO(+) AND t1.U5TRAMITE= t3.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sandoctemp> findAllLike(Sandoctemp sandoctemp, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.U5CODOCUMENTO U5CODOCUMENTO,t1.U5NOFILE U5NOFILE,null U5DATAFILE,t1.U5SIZEFILE U5SIZEFILE,t1.U5TEDESFILE U5TEDESFILE,t1.U5ORIGEN U5ORIGEN,t1.U5FECHA U5FECHA,t1.U5CONTTYPE U5CONTTYPE,t1.U5INDMAIL U5INDMAIL,t1.U5TRMAIL U5TRMAIL,t1.U5IDDOCUMENTUM U5IDDOCUMENTUM,t1.U5TIPODOCUMENTO U5TIPODOCUMENTO,t1.U5FECHAAPORTACION U5FECHAAPORTACION,t1.U5FECHAENTRADA U5FECHAENTRADA,t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA,t1.U5ID_PERFILFIRMA U5IDPERFILFIRMA,t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO,t1.U5FECHASOLFIRMA U5FECHASOLFIRMA,t1.U5FECHAFIRMA U5FECHAFIRMA,t1.U5COMOFIRMA U5COMOFIRMA,t1.U5FECALTA U5FECALTA,t1.U5FECMODIF U5FECMODIF,t1.U5USUALTA U5USUALTA,t1.U5USUMODIF U5USUMODIF, t1.U5PTCODIGO U5PTCODIGO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR ,t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN,t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.TRID SANTRAMEXPTRID,t3.TRCODIGO SANTRAMEXPTRCODIGO,t3.TRFECINI SANTRAMEXPTRFECINI,t3.TRFECFIN SANTRAMEXPTRFECFIN,/*t3.TROBSERVES SANTRAMEXPTROBSERVES,*/t3.TRMOCODIGO SANTRAMEXPTRMOCODIGO,t3.TRTRIDREL SANTRAMEXPTRTRIDREL,t3.TRFECACINI SANTRAMEXPTRFECACINI,t3.TRRESULTADO SANTRAMEXPTRRESULTADO,t3.TRESTIMACION SANTRAMEXPTRESTIMACION,t3.TRRESOFECHA SANTRAMEXPTRRESOFECHA,t3.TRRESOTIPO SANTRAMEXPTRRESOTIPO,t3.TRRESOSAN SANTRAMEXPTRRESOSAN,t3.TRRESOIMPORTE SANTRAMEXPTRRESOIMPORTE,t3.TRRCAFECRECURSO SANTRAMEXPTRRCAFECRECURSO,t3.TRESTADOACUSE SANTRAMEXPTRESTADOACUSE,t3.TRNUMREGS SANTRAMEXPTRNUMREGS,t3.TRNUMREGE SANTRAMEXPTRNUMREGE,t3.TRTIPOCOM SANTRAMEXPTRTIPOCOM,t3.TRFECENVIO SANTRAMEXPTRFECENVIO,t3.TRFECCIERRE SANTRAMEXPTRFECCIERRE,t3.TRFECALTA SANTRAMEXPTRFECALTA,t3.TRFECMODIF SANTRAMEXPTRFECMODIF,t3.TRUSUALTA SANTRAMEXPTRUSUALTA,t3.TRUSUMODIF SANTRAMEXPTRUSUMODIF,t3.TREXCODIGO SANTRAMEXPTREXCODIGO,null PCODIGO,t1.U5IDINTERVINIENTE U5IDINTERVINIENTE ");
		query.append("FROM SANDOCTEMP t1 ,EXPEDIEN t2 ,SANTRAMEXP t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sandoctemp, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.U5EXCODIGO= t2.EXCODIGO(+) AND t1.U5TRAMITE= t3.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sandoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sandoctemp sandoctemp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANDOCTEMP t1 ,EXPEDIEN t2 ,SANTRAMEXP t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sandoctemp, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.U5EXCODIGO= t2.EXCODIGO(+) AND t1.U5TRAMITE= t3.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sandoctemp entity
	 * 
	 * @param sandoctemp
	 *            Sandoctemp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sandoctemp sandoctemp) {

		StringBuilder where = new StringBuilder(SandoctempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sandoctemp != null && sandoctemp.getU5codocumento() != null) {
			where.append(" AND t1.U5CODOCUMENTO = ?");
			params.add(sandoctemp.getU5codocumento());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sandoctemp.getExpedien().getExcodigo());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoor() != null) {
			where.append(" AND t2.EXCOOR = ?");
			params.add(sandoctemp.getExpedien().getExcoor());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(sandoctemp.getExpedien().getExnran());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(sandoctemp.getExpedien().getExnror());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(sandoctemp.getExpedien().getExfere());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoit() != null) {
			where.append(" AND t2.EXCOIT = ?");
			params.add(sandoctemp.getExpedien().getExcoit());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoes() != null) {
			where.append(" AND t2.EXCOES = ?");
			params.add(sandoctemp.getExpedien().getExcoes());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(sandoctemp.getExpedien().getExfeacin());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(sandoctemp.getExpedien().getExfeemca());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(sandoctemp.getExpedien().getExfeplca());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(sandoctemp.getExpedien().getExfpnopc());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(sandoctemp.getExpedien().getExfede());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(sandoctemp.getExpedien().getExfecoal());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(sandoctemp.getExpedien().getExfenopr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(sandoctemp.getExpedien().getExfepupr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoospr() != null) {
			where.append(" AND t2.EXCOOSPR = ?");
			params.add(sandoctemp.getExpedien().getExcoospr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(sandoctemp.getExpedien().getExfealpr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(sandoctemp.getExpedien().getExfeel());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(sandoctemp.getExpedien().getExferes());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(sandoctemp.getExpedien().getExfenore());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(sandoctemp.getExpedien().getExfepure());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoosre() != null) {
			where.append(" AND t2.EXCOOSRE = ?");
			params.add(sandoctemp.getExpedien().getExcoosre());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcottr() != null) {
			where.append(" AND t2.EXCOTTR = ?");
			params.add(sandoctemp.getExpedien().getExcottr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(sandoctemp.getExpedien().getExcamure());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(sandoctemp.getExpedien().getExfeta());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcotsa() != null) {
			where.append(" AND t2.EXCOTSA = ?");
			params.add(sandoctemp.getExpedien().getExcotsa());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(sandoctemp.getExpedien().getExfecroi());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(sandoctemp.getExpedien().getExfear());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoorie() != null) {
			where.append(" AND t2.EXCOORIE = ?");
			params.add(sandoctemp.getExpedien().getExcoorie());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExinre() != null) {
			where.append(" AND t2.EXINRE = ?");
			params.add(sandoctemp.getExpedien().getExinre());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExincoco() != null) {
			where.append(" AND t2.EXINCOCO = ?");
			params.add(sandoctemp.getExpedien().getExincoco());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExinexva() != null) {
			where.append(" AND t2.EXINEXVA = ?");
			params.add(sandoctemp.getExpedien().getExinexva());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(sandoctemp.getExpedien().getExfecirc());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(sandoctemp.getExpedien().getExfenoai());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(sandoctemp.getExpedien().getExfecolm());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExnuinlm() != null) {
			where.append(" AND t2.EXNUINLM = ?");
			params.add(sandoctemp.getExpedien().getExnuinlm());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(sandoctemp.getExpedien().getExfeinmu());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(sandoctemp.getExpedien().getExfeavmu());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(sandoctemp.getExpedien().getExfeimcd());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(sandoctemp.getExpedien().getExfecede());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcops() != null) {
			where.append(" AND t2.EXCOPS = ?");
			params.add(sandoctemp.getExpedien().getExcops());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcose() != null) {
			where.append(" AND t2.EXCOSE = ?");
			params.add(sandoctemp.getExpedien().getExcose());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getSanexp() != null
				&& sandoctemp.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sandoctemp.getExpedien().getSanexp().getExcodigo());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null && sandoctemp.getSantramexp().getTrid() != null) {
			where.append(" AND t3.TRID = ?");
			params.add(sandoctemp.getSantramexp().getTrid());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null && sandoctemp.getSantramexp().getExpedien() != null
				&& sandoctemp.getSantramexp().getExpedien().getExcodigo() != null) {
			where.append(" AND t3.TREXCODIGO = ?");
			params.add(sandoctemp.getSantramexp().getExpedien().getExcodigo());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrcodigo() != null) {
			where.append(" AND t3.TRCODIGO = ?");
			params.add(sandoctemp.getSantramexp().getTrcodigo());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrestado() != null) {
			where.append(" AND t3.TRESTADO = ?");
			params.add(sandoctemp.getSantramexp().getTrestado());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null && sandoctemp.getSantramexp().getFase() != null
				&& sandoctemp.getSantramexp().getFase().getFcodigo() != null) {
			where.append(" AND t3.TRFCODIGO = ?");
			params.add(sandoctemp.getSantramexp().getFase().getFcodigo());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecini() != null) {
			where.append(" AND t3.TRFECINI = ?");
			params.add(sandoctemp.getSantramexp().getTrfecini());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecfin() != null) {
			where.append(" AND t3.TRFECFIN = ?");
			params.add(sandoctemp.getSantramexp().getTrfecfin());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrobserves() != null) {
			where.append(" AND t3.TROBSERVES = ?");
			params.add(sandoctemp.getSantramexp().getTrobserves());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getCensoMonitor() != null
				&& sandoctemp.getSantramexp().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.TRMOCODIGO = ?");
			params.add(sandoctemp.getSantramexp().getCensoMonitor().getMocodigo());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrtridrel() != null) {
			where.append(" AND t3.TRTRIDREL = ?");
			params.add(sandoctemp.getSantramexp().getTrtridrel());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecacini() != null) {
			where.append(" AND t3.TRFECACINI = ?");
			params.add(sandoctemp.getSantramexp().getTrfecacini());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresultado() != null) {
			where.append(" AND t3.TRRESULTADO = ?");
			params.add(sandoctemp.getSantramexp().getTrresultado());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrestimacion() != null) {
			where.append(" AND t3.TRESTIMACION = ?");
			params.add(sandoctemp.getSantramexp().getTrestimacion());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresofecha() != null) {
			where.append(" AND t3.TRRESOFECHA = ?");
			params.add(sandoctemp.getSantramexp().getTrresofecha());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresotipo() != null) {
			where.append(" AND t3.TRRESOTIPO = ?");
			params.add(sandoctemp.getSantramexp().getTrresotipo());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresosan() != null) {
			where.append(" AND t3.TRRESOSAN = ?");
			params.add(sandoctemp.getSantramexp().getTrresosan());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresoimporte() != null) {
			where.append(" AND t3.TRRESOIMPORTE = ?");
			params.add(sandoctemp.getSantramexp().getTrresoimporte());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecregs() != null) {
			where.append(" AND t3.TRRCAFECRECURSO = ?");
			params.add(sandoctemp.getSantramexp().getTrfecregs());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrestadoacuse() != null) {
			where.append(" AND t3.TRESTADOACUSE = ?");
			params.add(sandoctemp.getSantramexp().getTrestadoacuse());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrnumregs() != null) {
			where.append(" AND t3.TRNUMREGS = ?");
			params.add(sandoctemp.getSantramexp().getTrnumregs());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrnumrege() != null) {
			where.append(" AND t3.TRNUMREGE = ?");
			params.add(sandoctemp.getSantramexp().getTrnumrege());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrtipocom() != null) {
			where.append(" AND t3.TRTIPOCOM = ?");
			params.add(sandoctemp.getSantramexp().getTrtipocom());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecenvio() != null) {
			where.append(" AND t3.TRFECENVIO = ?");
			params.add(sandoctemp.getSantramexp().getTrfecenvio());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfeccierre() != null) {
			where.append(" AND t3.TRFECCIERRE = ?");
			params.add(sandoctemp.getSantramexp().getTrfeccierre());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecalta() != null) {
			where.append(" AND t3.TRFECALTA = ?");
			params.add(sandoctemp.getSantramexp().getTrfecalta());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecmodif() != null) {
			where.append(" AND t3.TRFECMODIF = ?");
			params.add(sandoctemp.getSantramexp().getTrfecmodif());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrusualta() != null) {
			where.append(" AND t3.TRUSUALTA = ?");
			params.add(sandoctemp.getSantramexp().getTrusualta());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrusumodif() != null) {
			where.append(" AND t3.TRUSUMODIF = ?");
			params.add(sandoctemp.getSantramexp().getTrusumodif());
		}
		if (sandoctemp != null && sandoctemp.getU5nofile() != null) {
			where.append(" AND t1.U5NOFILE = ?");
			params.add(sandoctemp.getU5nofile());
		}
		if (sandoctemp != null && sandoctemp.getU5sizefile() != null) {
			where.append(" AND t1.U5SIZEFILE = ?");
			params.add(sandoctemp.getU5sizefile());
		}
		if (sandoctemp != null && sandoctemp.getU5tedesfile() != null) {
			where.append(" AND t1.U5TEDESFILE = ?");
			params.add(sandoctemp.getU5tedesfile());
		}
		if (sandoctemp != null && sandoctemp.getU5origen() != null) {
			where.append(" AND t1.U5ORIGEN = ?");
			params.add(sandoctemp.getU5origen());
		}
		if (sandoctemp != null && sandoctemp.getU5fecha() != null) {
			where.append(" AND t1.U5FECHA = ?");
			params.add(sandoctemp.getU5fecha());
		}
		if (sandoctemp != null && sandoctemp.getU5conttype() != null) {
			where.append(" AND t1.U5CONTTYPE = ?");
			params.add(sandoctemp.getU5conttype());
		}
		if (sandoctemp != null && sandoctemp.getU5indmail() != null) {
			where.append(" AND t1.U5INDMAIL = ?");
			params.add(sandoctemp.getU5indmail());
		}
		if (sandoctemp != null && sandoctemp.getU5trmail() != null) {
			where.append(" AND t1.U5TRMAIL = ?");
			params.add(sandoctemp.getU5trmail());
		}
		if (sandoctemp != null && sandoctemp.getU5iddocumentum() != null) {
			where.append(" AND t1.U5IDDOCUMENTUM = ?");
			params.add(sandoctemp.getU5iddocumentum());
		}
		if (sandoctemp != null && sandoctemp.getU5tipodocumento() != null) {
			where.append(" AND t1.U5TIPODOCUMENTO = ?");
			params.add(sandoctemp.getU5tipodocumento());
		}
		if (sandoctemp != null && sandoctemp.getU5fechaaportacion() != null) {
			where.append(" AND t1.U5FECHAAPORTACION = ?");
			params.add(sandoctemp.getU5fechaaportacion());
		}
		if (sandoctemp != null && sandoctemp.getU5fechaentrada() != null) {
			where.append(" AND t1.U5FECHAENTRADA = ?");
			params.add(sandoctemp.getU5fechaentrada());
		}
		if (sandoctemp != null && sandoctemp.getU5numregistroentrada() != null) {
			where.append(" AND t1.U5NUMREGISTROENTRADA = ?");
			params.add(sandoctemp.getU5numregistroentrada());
		}
		if (sandoctemp != null && sandoctemp.getU5idPerfilfirma() != null) {
			where.append(" AND t1.U5ID_PERFILFIRMA = ?");
			params.add(sandoctemp.getU5idPerfilfirma());
		}
		if (sandoctemp != null && sandoctemp.getU5estadodocumento() != null) {
			where.append(" AND t1.U5ESTADODOCUMENTO = ?");
			params.add(sandoctemp.getU5estadodocumento());
		}
		if (sandoctemp != null && sandoctemp.getU5fechasolfirma() != null) {
			where.append(" AND t1.U5FECHASOLFIRMA = ?");
			params.add(sandoctemp.getU5fechasolfirma());
		}
		if (sandoctemp != null && sandoctemp.getU5fechafirma() != null) {
			where.append(" AND t1.U5FECHAFIRMA = ?");
			params.add(sandoctemp.getU5fechafirma());
		}
		if (sandoctemp != null && sandoctemp.getU5comofirma() != null) {
			where.append(" AND t1.U5COMOFIRMA = ?");
			params.add(sandoctemp.getU5comofirma());
		}
		if (sandoctemp != null && sandoctemp.getU5fecalta() != null) {
			where.append(" AND t1.U5FECALTA = ?");
			params.add(sandoctemp.getU5fecalta());
		}
		if (sandoctemp != null && sandoctemp.getU5fecmodif() != null) {
			where.append(" AND t1.U5FECMODIF = ?");
			params.add(sandoctemp.getU5fecmodif());
		}
		if (sandoctemp != null && sandoctemp.getU5usualta() != null) {
			where.append(" AND t1.U5USUALTA = ?");
			params.add(sandoctemp.getU5usualta());
		}
		if (sandoctemp != null && sandoctemp.getU5usumodif() != null) {
			where.append(" AND t1.U5USUMODIF = ?");
			params.add(sandoctemp.getU5usumodif());
		}
		if (sandoctemp != null && sandoctemp.getU5ptcodigo() != null) {
			where.append(" AND t1.U5PTCODIGO = ?");
			params.add(sandoctemp.getU5ptcodigo());
		}
		if (sandoctemp != null && sandoctemp.getU5fechasollocalizador() != null) {
			where.append(" AND t1.U5FECHASOLLOCALIZADOR = ?");
			params.add(sandoctemp.getU5fechasollocalizador());
		}
		if (sandoctemp != null && sandoctemp.getU5idinterviniente() != null) {
			where.append(" AND t1.U5IDINTERVINIENTE = ?");
			params.add(sandoctemp.getU5idinterviniente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sandoctemp entity
	 * 
	 * @param sandoctemp
	 *            Sandoctemp Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sandoctemp sandoctemp, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SandoctempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sandoctemp != null && sandoctemp.getU5codocumento() != null) {
			where.append(" AND t1.U5CODOCUMENTO = ?");
			params.add(sandoctemp.getU5codocumento());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sandoctemp.getExpedien().getExcodigo());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcoor().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(sandoctemp.getExpedien().getExnran());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(sandoctemp.getExpedien().getExnror());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(sandoctemp.getExpedien().getExfere());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcoit().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcoit().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcoes().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcoes().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(sandoctemp.getExpedien().getExfeacin());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(sandoctemp.getExpedien().getExfeemca());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(sandoctemp.getExpedien().getExfeplca());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(sandoctemp.getExpedien().getExfpnopc());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(sandoctemp.getExpedien().getExfede());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(sandoctemp.getExpedien().getExfecoal());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(sandoctemp.getExpedien().getExfenopr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(sandoctemp.getExpedien().getExfepupr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcoospr().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcoospr().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(sandoctemp.getExpedien().getExfealpr());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(sandoctemp.getExpedien().getExfeel());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(sandoctemp.getExpedien().getExferes());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(sandoctemp.getExpedien().getExfenore());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(sandoctemp.getExpedien().getExfepure());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcoosre().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcoosre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcottr().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcottr().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(sandoctemp.getExpedien().getExcamure());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(sandoctemp.getExpedien().getExfeta());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcotsa().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcotsa().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(sandoctemp.getExpedien().getExfecroi());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(sandoctemp.getExpedien().getExfear());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcoorie().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcoorie().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExinre().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExinre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExincoco().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExincoco().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExinexva().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExinexva().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(sandoctemp.getExpedien().getExfecirc());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(sandoctemp.getExpedien().getExfenoai());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(sandoctemp.getExpedien().getExfecolm());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExnuinlm().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExnuinlm().toUpperCase() + "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(sandoctemp.getExpedien().getExfeinmu());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(sandoctemp.getExpedien().getExfeavmu());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(sandoctemp.getExpedien().getExfeimcd());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(sandoctemp.getExpedien().getExfecede());
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcops().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcops().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getExcose().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getExcose().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getExpedien() != null && sandoctemp.getExpedien().getSanexp() != null
				&& sandoctemp.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t2.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getExpedien().getSanexp().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getExpedien().getSanexp().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCODIGO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null && sandoctemp.getSantramexp().getTrid() != null) {
			where.append(" AND t3.TRID = ?");
			params.add(sandoctemp.getSantramexp().getTrid());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null && sandoctemp.getSantramexp().getExpedien() != null
				&& sandoctemp.getSantramexp().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t3.TREXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getExpedien().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getExpedien().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.TREXCODIGO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrcodigo() != null) {
			where.append(" AND UPPER(t3.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.TRCODIGO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecini() != null) {
			where.append(" AND t3.TRFECINI = ?");
			params.add(sandoctemp.getSantramexp().getTrfecini());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecfin() != null) {
			where.append(" AND t3.TRFECFIN = ?");
			params.add(sandoctemp.getSantramexp().getTrfecfin());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getCensoMonitor() != null
				&& sandoctemp.getSantramexp().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t3.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.TRMOCODIGO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrtridrel() != null) {
			where.append(" AND t3.TRTRIDREL = ?");
			params.add(sandoctemp.getSantramexp().getTrtridrel());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecacini() != null) {
			where.append(" AND t3.TRFECACINI = ?");
			params.add(sandoctemp.getSantramexp().getTrfecacini());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresultado() != null) {
			where.append(" AND t3.TRRESULTADO = ?");
			params.add(sandoctemp.getSantramexp().getTrresultado());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrestimacion() != null) {
			where.append(" AND UPPER(t3.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrestimacion().toUpperCase() + "%");
			}
			where.append(" AND t3.TRESTIMACION IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresofecha() != null) {
			where.append(" AND t3.TRRESOFECHA = ?");
			params.add(sandoctemp.getSantramexp().getTrresofecha());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresotipo() != null) {
			where.append(" AND t3.TRRESOTIPO = ?");
			params.add(sandoctemp.getSantramexp().getTrresultado());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresosan() != null) {
			where.append(" AND t3.TRRESOSAN = ?");
			params.add(sandoctemp.getSantramexp().getTrresultado());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrresoimporte() != null) {

			where.append(" AND t3.TRRESOIMPORTE = ?");
			params.add(sandoctemp.getSantramexp().getTrresoimporte());

		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecregs() != null) {
			where.append(" AND t3.TRRCAFECRECURSO = ?");
			params.add(sandoctemp.getSantramexp().getTrfecregs());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t3.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrestadoacuse().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrestadoacuse().toUpperCase() + "%");
			}
			where.append(" AND t3.TRESTADOACUSE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrnumregs() != null) {
			where.append(" AND UPPER(t3.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrnumregs().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrnumregs().toUpperCase() + "%");
			}
			where.append(" AND t3.TRNUMREGS IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrnumrege() != null) {
			where.append(" AND UPPER(t3.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrnumrege().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrnumrege().toUpperCase() + "%");
			}
			where.append(" AND t3.TRNUMREGE IS NOT NULL");
		}

		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecenvio() != null) {
			where.append(" AND t3.TRFECENVIO = ?");
			params.add(sandoctemp.getSantramexp().getTrfecenvio());
		}

		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfeccierre() != null) {
			where.append(" AND t3.TRFECCIERRE = ?");
			params.add(sandoctemp.getSantramexp().getTrfeccierre());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecalta() != null) {
			where.append(" AND t3.TRFECALTA = ?");
			params.add(sandoctemp.getSantramexp().getTrfecalta());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrfecmodif() != null) {
			where.append(" AND t3.TRFECMODIF = ?");
			params.add(sandoctemp.getSantramexp().getTrfecmodif());
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrusualta() != null) {
			where.append(" AND UPPER(t3.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrusualta().toUpperCase() + "%");
			}
			where.append(" AND t3.TRUSUALTA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getSantramexp() != null
				&& sandoctemp.getSantramexp().getTrusumodif() != null) {
			where.append(" AND UPPER(t3.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getSantramexp().getTrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getSantramexp().getTrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t3.TRUSUMODIF IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5nofile() != null) {
			where.append(" AND UPPER(t1.U5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.U5NOFILE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5sizefile() != null) {
			where.append(" AND t1.U5SIZEFILE = ?");
			params.add(sandoctemp.getU5sizefile());
		}
		if (sandoctemp != null && sandoctemp.getU5tedesfile() != null) {
			where.append(" AND UPPER(t1.U5TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5tedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.U5TEDESFILE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5origen() != null) {
			where.append(" AND UPPER(t1.U5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5origen().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5origen().toUpperCase() + "%");
			}
			where.append(" AND t1.U5ORIGEN IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5fecha() != null) {
			where.append(" AND t1.U5FECHA = ?");
			params.add(sandoctemp.getU5fecha());
		}
		if (sandoctemp != null && sandoctemp.getU5conttype() != null) {
			where.append(" AND UPPER(t1.U5CONTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5conttype().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5conttype().toUpperCase() + "%");
			}
			where.append(" AND t1.U5CONTTYPE IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5indmail() != null) {
			where.append(" AND UPPER(t1.U5INDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5indmail().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5indmail().toUpperCase() + "%");
			}
			where.append(" AND t1.U5INDMAIL IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5trmail() != null) {
			where.append(" AND UPPER(t1.U5TRMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5trmail().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5trmail().toUpperCase() + "%");
			}
			where.append(" AND t1.U5TRMAIL IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5iddocumentum() != null) {
			where.append(" AND UPPER(t1.U5IDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5iddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5iddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.U5IDDOCUMENTUM IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5tipodocumento() != null) {
			where.append(" AND UPPER(t1.U5TIPODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5tipodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5tipodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.U5TIPODOCUMENTO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5fechaaportacion() != null) {
			where.append(" AND t1.U5FECHAAPORTACION = ?");
			params.add(sandoctemp.getU5fechaaportacion());
		}
		if (sandoctemp != null && sandoctemp.getU5fechaentrada() != null) {
			where.append(" AND t1.U5FECHAENTRADA = ?");
			params.add(sandoctemp.getU5fechaentrada());
		}
		if (sandoctemp != null && sandoctemp.getU5numregistroentrada() != null) {
			where.append(" AND UPPER(t1.U5NUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5numregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5numregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t1.U5NUMREGISTROENTRADA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5idPerfilfirma() != null) {
			where.append(" AND UPPER(t1.U5ID_PERFILFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5idPerfilfirma().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5idPerfilfirma().toUpperCase() + "%");
			}
			where.append(" AND t1.U5ID_PERFILFIRMA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5estadodocumento() != null) {
			where.append(" AND UPPER(t1.U5ESTADODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5estadodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5estadodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.U5ESTADODOCUMENTO IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5fechasolfirma() != null) {
			where.append(" AND t1.U5FECHASOLFIRMA = ?");
			params.add(sandoctemp.getU5fechasolfirma());
		}
		if (sandoctemp != null && sandoctemp.getU5fechafirma() != null) {
			where.append(" AND t1.U5FECHAFIRMA = ?");
			params.add(sandoctemp.getU5fechafirma());
		}
		if (sandoctemp != null && sandoctemp.getU5comofirma() != null) {
			where.append(" AND UPPER(t1.U5COMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5comofirma().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5comofirma().toUpperCase() + "%");
			}
			where.append(" AND t1.U5COMOFIRMA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5fecalta() != null) {
			where.append(" AND t1.U5FECALTA = ?");
			params.add(sandoctemp.getU5fecalta());
		}
		if (sandoctemp != null && sandoctemp.getU5fecmodif() != null) {
			where.append(" AND t1.U5FECMODIF = ?");
			params.add(sandoctemp.getU5fecmodif());
		}
		if (sandoctemp != null && sandoctemp.getU5usualta() != null) {
			where.append(" AND UPPER(t1.U5USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5usualta().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.U5USUALTA IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5usumodif() != null) {
			where.append(" AND UPPER(t1.U5USUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sandoctemp.getU5usumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sandoctemp.getU5usumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.U5USUMODIF IS NOT NULL");
		}
		if (sandoctemp != null && sandoctemp.getU5ptcodigo() != null) {
			where.append(" AND t1.U5PTCODIGO = ?");
			params.add(sandoctemp.getU5ptcodigo());
		}
		if (sandoctemp != null && sandoctemp.getU5fechasollocalizador() != null) {
			where.append(" AND t1.U5FECHASOLLOCALIZADOR = ?");
			params.add(sandoctemp.getU5fechasollocalizador());
		}
		if (sandoctemp != null && sandoctemp.getU5idinterviniente() != null) {
			where.append(" AND t1.U5IDINTERVINIENTE = ?");
			params.add(sandoctemp.getU5idinterviniente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "DELETE FROM SANDOCTEMP WHERE U5TRAMITE = ? AND U5EXCODIGO=?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(), tramiteComun.getIdExpediente());

	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocsSanDocTramite(TramiteComun tramiteComun) {
		String query = "INSERT INTO SANDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) SELECT THID_TRAMITE,THCODOCUMENTO,THPCODIGO,TRPCODIGO FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_TRAMITE=? ";
		this.jdbcTemplate.update(query, Y41bConstantes.TIPO_PROC_SANCIONES, tramiteComun.getIdTramite());
	}

	/**
	 * insertSanDocTramite
	 * 
	 * @param idNuevoTramite
	 *            String
	 * @param codocumento
	 *            String
	 * @param tipoProcedimiento
	 *            String
	 */
	public void insertSanDocTramite(String idNuevoTramite, String codocumento, String tipoProcedimiento) {
		String query = "INSERT INTO SANDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) VALUES(?,?,?,?)";
		this.jdbcTemplate.update(query, idNuevoTramite, codocumento, tipoProcedimiento, tipoProcedimiento);
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeSanDocTramite(TramiteComun tramiteComun) {
		String query = "DELETE FROM SANDOCTRAMITE WHERE EHCODIGO = ? AND TRPCODIGO ='"
				+ Y41bConstantes.TIPO_PROC_SANCIONES + "'";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param codocumento
	 *            String
	 */
	public void removeSanDocTramiteDocId(TramiteComun tramiteComun, String codocumento) {
		String query = "DELETE FROM SANDOCTRAMITE WHERE EHCODIGO = ? AND CODOCUMENTO=? AND TRPCODIGO =?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(), codocumento, Y41bConstantes.TIPO_PROC_SANCIONES);
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addSanAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO,TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ "SELECT t1.U5CODOCUMENTO U5CODOCUMENTO, t2.THPCODIGO THPCODIGO,t2.TRPCODIGO TRPCODIGO,  t1.U5ID_PERFILFIRMA U5IDPERFILFIRMA, t1.U5TIPODOCUMENTO U5TIPODOCUMENTO, t1.U5EXCODIGO U5EXCODIGO, t2.EHCODIGO, t1.U5NOFILE U5NOFILE, t1.U5DATAFILE U5DATAFILE, t1.U5SIZEFILE U5SIZEFILE, t1.U5TEDESFILE U5TEDESFILE, t1.U5ORIGEN U5ORIGEN, t1.U5TRAMITE U5TRAMITE, t1.U5FECHA U5FECHA, t1.U5INDMAIL U5INDMAIL, t1.U5TRMAIL U5TRMAIL, t1.U5CONTTYPE U5CONTTYPE, t1.U5IDDOCUMENTUM U5IDDOCUMENTUM, t1.U5FECHAAPORTACION U5FECHAAPORTACION, t1.U5FECHAENTRADA U5FECHAENTRADA, t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA, t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO, t1.U5FECHASOLFIRMA U5FECHASOLFIRMA, t1.U5FECHALIMFIRMA U5FECHALIMFIRMA, t1.U5FECHAFIRMA U5FECHAFIRMA, t1.U5COMOFIRMA U5COMOFIRMA, t1.U5DESTINO U5DESTINO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR, T1.U5PTCODIGO U5PTCODIGO, t1.U5NUMREGISTROORIGEN U5NUMREGISTROORIGEN, t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN, t1.U5IDINTERVINIENTE U5IDINTERVINIENTE "
				+ " FROM SANDOCTEMP t1, SANDOCTRAMITE t2 "
				+ " WHERE t1.U5CODOCUMENTO=t2.CODOCUMENTO AND t2.EHCODIGO = ? AND t2.TRPCODIGO=? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(), Y41bConstantes.TIPO_PROC_SANCIONES);
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sandoctemp> findAllSanDocumentosTramite(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.U5CODOCUMENTO U5CODOCUMENTO,t1.U5EXCODIGO U5EXCODIGO,t1.U5NOFILE U5NOFILE,null U5DATAFILE,t1.U5SIZEFILE U5SIZEFILE,t1.U5TEDESFILE U5TEDESFILE,t1.U5ORIGEN U5ORIGEN,t1.U5TRAMITE U5TRAMITE,t1.U5FECHA U5FECHA,t1.U5INDMAIL U5INDMAIL,t1.U5TRMAIL U5TRMAIL,t1.U5CONTTYPE U5CONTTYPE,t1.U5IDDOCUMENTUM U5IDDOCUMENTUM,t1.U5FECHAAPORTACION U5FECHAAPORTACION,t1.U5FECHAENTRADA U5FECHAENTRADA,t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA,t1.U5ID_PERFILFIRMA U5IDPERFILFIRMA,t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO,t1.U5FECHASOLFIRMA U5FECHASOLFIRMA,t1.U5FECHALIMFIRMA U5FECHALIMFIRMA,t1.U5FECHAFIRMA U5FECHAFIRMA,t1.U5COMOFIRMA U5COMOFIRMA,t1.U5TIPODOCUMENTO U5TIPODOCUMENTO,t1.U5DESTINO U5DESTINO, t1.U5PTCODIGO U5PTCODIGO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR, t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN, t2.THPCODIGO PCODIGO,t1.U5IDINTERVINIENTE U5IDINTERVINIENTE ");
		query.append("FROM SANDOCTEMP t1, SANDOCTRAMITE t2  WHERE t1.U5CODOCUMENTO=t2.CODOCUMENTO ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.EHCODIGO = ? ");
		params.add(tramiteComun.getIdTramite());
		where.append(" AND t2.TRPCODIGO = ? ");
		params.add(Y41bConstantes.TIPO_PROC_SANCIONES);

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sandoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		try {
			String query = "INSERT INTO SANDOCTEMP (U5CODOCUMENTO, U5EXCODIGO, U5NOFILE, U5DATAFILE, U5SIZEFILE, U5TEDESFILE, U5ORIGEN, U5TRAMITE, U5FECHA, U5INDMAIL, U5TRMAIL, U5CONTTYPE, U5IDDOCUMENTUM, U5FECHAAPORTACION, U5FECHAENTRADA, U5NUMREGISTROENTRADA, U5ID_PERFILFIRMA, U5ESTADODOCUMENTO, U5FECHASOLFIRMA, U5FECHALIMFIRMA, U5FECHAFIRMA, U5COMOFIRMA, U5TIPODOCUMENTO, U5DESTINO, U5FECHASOLLOCALIZADOR, U5PTCODIGO,U5NUMREGISTROORIGEN,U5FECHAREGISTROORIGEN, U5IDINTERVINIENTE)"
					+ " SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO ,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN, THIDINTERVINIENTE "
					+ " FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THCODOCUMENTO NOT IN (SELECT U5CODOCUMENTO FROM SANDOCTEMP) AND THID_TRAMITE=?";

			this.jdbcTemplate.update(query, Y41bConstantes.TIPO_PROC_SANCIONES, tramiteComun.getIdTramite());
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en addDocumentosHechoAdjuntarDocs: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentos
	 *            List<Map<String, Object>>
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun, List<Map<String, Object>> documentos) {
		try {
			StringBuffer query = new StringBuffer(Y41bConstantes.MIL);
			query.append(
					" INSERT INTO SANDOCTEMP (U5CODOCUMENTO, U5EXCODIGO, U5NOFILE, U5DATAFILE, U5SIZEFILE, U5TEDESFILE, U5ORIGEN, U5TRAMITE, U5FECHA, U5INDMAIL, U5TRMAIL, U5CONTTYPE, U5IDDOCUMENTUM, U5FECHAAPORTACION, U5FECHAENTRADA, U5NUMREGISTROENTRADA, U5ID_PERFILFIRMA, U5ESTADODOCUMENTO, U5FECHASOLFIRMA, U5FECHALIMFIRMA, U5FECHAFIRMA, U5COMOFIRMA, U5TIPODOCUMENTO, U5DESTINO, U5FECHASOLLOCALIZADOR, U5PTCODIGO,U5NUMREGISTROORIGEN,U5FECHAREGISTROORIGEN,U5IDINTERVINIENTE)");
			query.append(
					" SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN,THIDINTERVINIENTE ");
			query.append(" FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_EXPEDIENTE=? AND THID_TRAMITE=? ");

			// Estos documentos ya existen en sandoctemp porque estan aportados
			// o generados desde otros tramites
			for (int i = 0; i < documentos.size(); i++) {
				query.append("AND THCODOCUMENTO<>")
						.append(((BigDecimal) documentos.get(i).get("CODOCUMENTO")).toString());
			}

			this.jdbcTemplate.update(query.toString(), tramiteComun.getTipoProcedimiento().getPcodigo(),
					tramiteComun.getIdExpediente(), tramiteComun.getIdTramite());
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en addDocumentosHechoAdjuntarDocs: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return Sandoctemp
	 */
	public Sandoctemp updateOIDDokusi(Sandoctemp documentoHecho) {
		SandoctempDaoImpl.logger.debug("updateOIDDokusi(). U5CODOCUMENTO: " + documentoHecho.getU5codocumento()
				+ ".U5IDDOCUMENTUM:" + documentoHecho.getU5iddocumentum() + ".");
		String query = "UPDATE SANDOCTEMP SET U5IDDOCUMENTUM=? WHERE U5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getU5iddocumentum(), documentoHecho.getU5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param documentoHecho
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	public Sandoctemp removeBlobFromOIDDokusi(Sandoctemp documentoHecho) {
		String query = "UPDATE SANDOCTEMP SET U5DATAFILE=null WHERE U5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getU5codocumento());
		return documentoHecho;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT SEQ_L21Q5T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param documentoHecho
	 *            Sandoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDoc(Sandoctemp documentoHecho, TramiteComun tramiteComun) {

		String query = " INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO,TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ " SELECT t1.U5CODOCUMENTO U5CODOCUMENTO, '" + documentoHecho.getU5pcodigo() + "', '"
				+ Y41bConstantes.TIPO_PROC_SANCIONES
				+ "',  t1.U5ID_PERFILFIRMA U5ID_PERFILFIRMA, t1.U5TIPODOCUMENTO U5TIPODOCUMENTO, t1.U5EXCODIGO U5EXCODIGO, '"
				+ tramiteComun.getIdTramite()
				+ "', t1.U5NOFILE U5NOFILE, t1.U5DATAFILE U5DATAFILE, t1.U5SIZEFILE U5SIZEFILE, t1.U5TEDESFILE U5TEDESFILE, t1.U5ORIGEN U5ORIGEN, t1.U5TRAMITE U5TRAMITE, t1.U5FECHA U5FECHA, t1.U5INDMAIL U5INDMAIL, t1.U5TRMAIL U5TRMAIL, t1.U5CONTTYPE U5CONTTYPE, t1.U5IDDOCUMENTUM U5IDDOCUMENTUM, t1.U5FECHAAPORTACION U5FECHAAPORTACION, t1.U5FECHAENTRADA U5FECHAENTRADA, t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA, t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO, t1.U5FECHASOLFIRMA U5FECHASOLFIRMA, t1.U5FECHALIMFIRMA U5FECHALIMFIRMA, t1.U5FECHAFIRMA U5FECHAFIRMA, t1.U5COMOFIRMA U5COMOFIRMA, t1.U5DESTINO U5DESTINO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR, T1.U5PTCODIGO U5PTCODIGO, t1.U5NUMREGISTROORIGEN U5NUMREGISTROORIGEN, t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN, t1.U5IDINTERVINIENTE U5IDINTERVINIENTE "
				+ " FROM SANDOCTEMP t1 WHERE t1.U5CODOCUMENTO = ?";
		this.jdbcTemplate.update(query, documentoHecho.getU5codocumento());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.U5CODOCUMENTO U5CODOCUMENTO,t1.U5EXCODIGO U5EXCODIGO,t1.U5NOFILE U5NOFILE,t1.U5SIZEFILE U5SIZEFILE,t1.U5TEDESFILE U5TEDESFILE,t1.U5ORIGEN U5ORIGEN, DECODE(t1.U5FECHAREGISTROORIGEN, null, DECODE(t1.U5FECHAENTRADA,null,t1.U5FECHA,t1.U5FECHAENTRADA),t1.U5FECHAREGISTROORIGEN) U5FECHA,t1.U5CONTTYPE U5CONTTYPE,t1.U5IDDOCUMENTUM U5IDDOCUMENTUM,t1.U5FECHAAPORTACION U5FECHAAPORTACION,t1.U5FECHAENTRADA U5FECHAENTRADA,t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM SANDOCTEMP t1,SANTIPDOC t2 WHERE t1.U5TIPODOCUMENTO = t2.TDID(+) ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.U5EXCODIGO = ? ");
			params.add(tramiteComun.getIdExpediente());

			if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.U5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.U5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ORDEN_CONSEJERO);
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.U5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_REDUCCION);
				// EVOLUTIVO 0135083 2.5
			} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOINFORMACION
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.U5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_SAN_REQ_ENTRADA);
			} // EVOLUTIVO 0135083 2.5
			else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.U5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSOEXTRAORDINARIO);
			}

			where.append(
					" AND t1.U5TRAMITE IN (SELECT tt1.TRID FROM SANTRAMEXP tt1 WHERE tt1.TREXCODIGO=? AND (tt1.TRESTADO=? OR tt1.TRESTADO IS NULL))");
			params.add(tramiteComun.getIdExpediente());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
					new RowMapper<DocumentoExpediente>() {
						public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new DocumentoExpediente(resultSet.getString("U5CODOCUMENTO"),
									resultSet.getString("U5EXCODIGO"), resultSet.getString("U5NOFILE"), null,
									resultSet.getInt("U5SIZEFILE"), resultSet.getString("U5CONTTYPE"),
									resultSet.getString("U5TEDESFILE"), resultSet.getString("U5ORIGEN"),
									resultSet.getDate("U5FECHA"), resultSet.getString("U5IDDOCUMENTUM"),
									resultSet.getDate("U5FECHAAPORTACION"), resultSet.getDate("U5FECHAENTRADA"),
									resultSet.getString("U5NUMREGISTROENTRADA"), resultSet.getString("IDTIPODOC"),
									resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE"), null, null, null,
									null, null, null, null, null);
						}
					}, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en findAllDocumentosHechoComunicacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosExpediente(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder("");
		try {
			query = new StringBuilder(
					"SELECT DISTINCT U5CODOCUMENTO, U5EXCODIGO, U5NOFILE, U5SIZEFILE, U5TEDESFILE, U5ORIGEN, U5TRAMITE, DECODE(U5FECHAREGISTROORIGEN, null, DECODE(U5FECHAENTRADA,null,U5FECHA,U5FECHAENTRADA),U5FECHAREGISTROORIGEN) U5FECHA, U5CONTTYPE, U5INDMAIL, U5TRMAIL, U5IDDOCUMENTUM, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");

			query.append("FROM SANDOCTEMP,SANTIPDOC t2  WHERE U5TIPODOCUMENTO = t2.TDID(+) AND U5EXCODIGO=?");
			// Where clause & Params
			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();

			params.add(tramiteComun.getIdExpediente());

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(), params.toArray(),
					this.rwMapDocExp);
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en findAllDocumentosHechoComunicacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts rows in the Sandoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */

	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder("SELECT COUNT(DISTINCT U5CODOCUMENTO) ");
		query.append("FROM SANDOCTEMP,SANTIPDOC t2  WHERE U5TIPODOCUMENTO = t2.TDID(+) AND U5EXCODIGO=?");
		// Where clause & Params
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sandoctemp> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.U5CODOCUMENTO U5CODOCUMENTO,t1.U5EXCODIGO U5EXCODIGO,null U5DATAFILE,t1.U5NOFILE U5NOFILE,t1.U5SIZEFILE U5SIZEFILE,t1.U5TEDESFILE U5TEDESFILE,t1.U5ORIGEN U5ORIGEN,t1.U5TRAMITE U5TRAMITE,t1.U5FECHA U5FECHA,t1.U5INDMAIL U5INDMAIL,t1.U5TRMAIL U5TRMAIL,t1.U5CONTTYPE U5CONTTYPE,t1.U5IDDOCUMENTUM U5IDDOCUMENTUM,t1.U5FECHAAPORTACION U5FECHAAPORTACION,t1.U5FECHAENTRADA U5FECHAENTRADA,t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA,t1.U5ID_PERFILFIRMA U5IDPERFILFIRMA,t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO,t1.U5FECHASOLFIRMA U5FECHASOLFIRMA,t1.U5FECHALIMFIRMA U5FECHALIMFIRMA,t1.U5FECHAFIRMA U5FECHAFIRMA,t1.U5COMOFIRMA U5COMOFIRMA,t1.U5TIPODOCUMENTO U5TIPODOCUMENTO,t1.U5DESTINO U5DESTINO, t1.U5PTCODIGO U5PTCODIGO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR, t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN,t2.THPCODIGO PCODIGO,t1.U5IDINTERVINIENTE U5IDINTERVINIENTE ");
			query.append("FROM SANDOCTEMP t1, SANDOCTRAMITE t2 WHERE t1.U5CODOCUMENTO=t2.CODOCUMENTO ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t2.EHCODIGO = ? ");
			params.add(tramiteComun.getIdTramite().toString());
			where.append(" AND t2.TRPCODIGO = ? ");
			params.add(Y41bConstantes.TIPO_PROC_SANCIONES);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Sandoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en findAllDocumentosTramite: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDesdeAdjuntarDocsASanDocTemp(TramiteComun tramiteComun) {

		try {
			String query = "INSERT INTO SANDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO, TRPCODIGO) "
					+ " SELECT THID_TRAMITE,THCODOCUMENTO, THPCODIGO,TRPCODIGO FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_EXPEDIENTE=? AND THID_TRAMITE=? ";
			this.jdbcTemplate.update(query, Y41bConstantes.TIPO_PROC_SANCIONES, tramiteComun.getIdExpediente(),
					tramiteComun.getIdTramite());
		} catch (Exception e) {
			e.printStackTrace();
			SandoctempDaoImpl.logger.error("Error producido en addDesdeAdjuntarDocsASanDocTemp: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public Sandoctemp updateOrigen(Sandoctemp documentoHecho) {
		String query = "UPDATE SANDOCTEMP SET U5ORIGEN=? WHERE U5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getU5origen(), documentoHecho.getU5codocumento());
		return documentoHecho;
	}

	/**
	 * findAllDocumentosTramiteCount
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append("FROM SANDOCTEMP t1, SANDOCTRAMITE t2 WHERE t1.U5CODOCUMENTO=t2.CODOCUMENTO ");

		// Where clause & Params
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.EHCODIGO = ? ");
		params.add(tramiteComun.getIdTramite().toString());
		where.append(" AND t2.TRPCODIGO = ? ");
		params.add(Y41bConstantes.TIPO_PROC_SANCIONES);

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	public Sandoctemp updateDatosFirma(Sandoctemp sandoctemp) {
		String query = "UPDATE SANDOCTEMP SET U5ESTADODOCUMENTO=?, U5FECHAFIRMA=?, U5COMOFIRMA=? WHERE U5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, sandoctemp.getU5estadodocumento(), sandoctemp.getU5fechafirma(),
				sandoctemp.getU5comofirma(), sandoctemp.getU5codocumento());
		return sandoctemp;
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tipoDocumento
	 *            the tipo documento
	 * @param excodigo
	 *            the excodigo
	 * @return the date
	 */
	public Date dameFechaAportacionDocumentacion(String tipoDocumento, String excodigo) {
		StringBuilder where = new StringBuilder();
		StringBuilder orden = new StringBuilder();

		StringBuilder query = new StringBuilder(
				"SELECT  t1.U5CODOCUMENTO U5CODOCUMENTO,t1.U5EXCODIGO U5EXCODIGO,t1.U5NOFILE U5NOFILE,t1.U5DATAFILE U5DATAFILE,t1.U5SIZEFILE U5SIZEFILE,t1.U5TEDESFILE U5TEDESFILE,t1.U5ORIGEN U5ORIGEN,t1.U5TRAMITE U5TRAMITE,t1.U5FECHA U5FECHA,t1.U5INDMAIL U5INDMAIL,t1.U5TRMAIL U5TRMAIL,t1.U5CONTTYPE U5CONTTYPE,t1.U5IDDOCUMENTUM U5IDDOCUMENTUM,t1.U5FECHAAPORTACION U5FECHAAPORTACION,t1.U5FECHAENTRADA U5FECHAENTRADA,t1.U5NUMREGISTROENTRADA U5NUMREGISTROENTRADA,t1.U5ID_PERFILFIRMA U5IDPERFILFIRMA,t1.U5ESTADODOCUMENTO U5ESTADODOCUMENTO,t1.U5FECHASOLFIRMA U5FECHASOLFIRMA,t1.U5FECHALIMFIRMA U5FECHALIMFIRMA,t1.U5FECHAFIRMA U5FECHAFIRMA,t1.U5COMOFIRMA U5COMOFIRMA,t1.U5TIPODOCUMENTO U5TIPODOCUMENTO,t1.U5DESTINO U5DESTINO, t1.U5PTCODIGO U5PTCODIGO, t1.U5FECHASOLLOCALIZADOR U5FECHASOLLOCALIZADOR, t1.U5FECHAREGISTROORIGEN U5FECHAREGISTROORIGEN,t2.THPCODIGO PCODIGO,t1.U5IDINTERVINIENTE U5IDINTERVINIENTE ");
		query.append(" FROM SANDOCTEMP t1, SANDOCTRAMITE t2 WHERE t1.U5CODOCUMENTO=t2.CODOCUMENTO ");

		List<Object> params = new ArrayList<Object>();
		where.append(" AND T1.U5TIPODOCUMENTO = ? ");
		params.add(tipoDocumento);
		where.append(" AND T1.U5EXCODIGO = ? ");
		params.add(excodigo);
		where.append(" AND t2.TRPCODIGO = ? ");
		params.add(Y41bConstantes.TIPO_PROC_SANCIONES);

		query.append(where);
		orden.append(" ORDER BY U5FECHAENTRADA DESC, U5FECALTA DESC");
		query.append(orden);

		List<Sandoctemp> listaSanDocTemp = (List<Sandoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap,
				params.toArray());
		if (listaSanDocTemp != null && listaSanDocTemp.size() > 0) {
			Sandoctemp sandoc = (Sandoctemp) listaSanDocTemp.get(0);
			return sandoc.getU5fechaentrada();
		}
		return null;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return int
	 */
	public int updateSanDocTemp(Sandoctemp sandoctemp) {
		String query = "UPDATE SANDOCTEMP SET U5NOFILE=?,U5DATAFILE=?, U5SIZEFILE=?, U5CONTTYPE=? WHERE U5IDDOCUMENTUM=?";
		return this.jdbcTemplate.update(query, sandoctemp.getU5nofile(),
				Y41bJdbcUtils.ConvertBlobToByte(sandoctemp.getU5datafile()), sandoctemp.getU5sizefile(),
				sandoctemp.getU5conttype(), sandoctemp.getU5iddocumentum());
	}

	/**
	 * copiaSanDocTramite
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	public void copiaSanDocTramite(String tridOrigen, String tridDestino) {

		String query = "INSERT INTO SANDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO, TRPCODIGO) "
				+ " SELECT ?, CODOCUMENTO, THPCODIGO, TRPCODIGO "
				+ " FROM SANDOCTRAMITE WHERE 1=1 AND TRPCODIGO = ? AND EHCODIGO = ? AND CODOCUMENTO NOT IN (SELECT CODOCUMENTO FROM SANDOCTRAMITE WHERE EHCODIGO=? AND TRPCODIGO = ?)";
		// EVOLUTIVO 135083 2.1 SE ANIADE UNA CONDICION EN BASE A ESTA
		// INCIDENCIA, PARA QUE NO SE INSERTEN DOCUMENTOS REPETIDOS
		this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_SANCIONES, tridOrigen, tridDestino,
				Y41bConstantes.TIPO_PROC_SANCIONES);

	}

	/**
	 * copiaSanDocTramiteDeUnTipo
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	public void copiaSanDocTramiteDeUnTipo(String tridOrigen, String tridDestino, String tipo) {

		String query = "INSERT INTO SANDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO, TRPCODIGO) "
				+ " SELECT ?, CODOCUMENTO, THPCODIGO, TRPCODIGO "
				+ " FROM SANDOCTRAMITE,SANDOCTEMP WHERE 1=1 AND U5CODOCUMENTO=CODOCUMENTO AND TRPCODIGO = ? AND EHCODIGO = ? AND U5TIPODOCUMENTO=?";

		this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_SANCIONES, tridOrigen, tipo);

	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	public Sandoctemp updateFechaLocalizacion(Sandoctemp sandoctemp) {
		String query = "UPDATE SANDOCTEMP SET U5FECHASOLLOCALIZADOR=SYSDATE WHERE U5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, sandoctemp.getU5codocumento());
		return sandoctemp;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.SandoctempDao#findAllDocumentosHechoComunicacionCount
	 * (com.ejie.y41b.model.TramiteComun)
	 */
	@Override()
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT  count(1) FROM SANDOCTEMP t1,SANTIPDOC t2 WHERE t1.U5TIPODOCUMENTO = t2.TDID(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.U5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOALZADA.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.U5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSO);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.U5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_ORDEN_CONSEJERO);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.U5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_SOLICITUD_REDUCCION);
		} else if (Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONRECURSOEXTRAORDINARIO
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.U5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA_RECURSOEXTRAORDINARIO);
		}

		where.append(
				" AND t1.U5TRAMITE IN (SELECT tt1.TRID FROM SANTRAMEXP tt1 WHERE tt1.TREXCODIGO=? AND (tt1.TRESTADO=? OR tt1.TRESTADO IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Sandoctramite table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocTramiteHechoCount(Sandoctemp sandoctemp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANDOCTRAMITE WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND CODOCUMENTO = ? ");
		params.add(sandoctemp.getU5codocumento());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sandoctemp> findAllDocumentosEliminados(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.U5CODOCUMENTO U5CODOCUMENTO, t1.U5IDDOCUMENTUM U5IDDOCUMENTUM ");
		query.append("FROM SANDOCTEMP t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.U5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());
		where.append(" AND t1.U5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		where.append(
				" AND t1.U5CODOCUMENTO NOT IN (SELECT tt1.THCODOCUMENTO FROM ADJUNTARDOCS tt1 WHERE tt1.THID_TRAMITE = ? AND tt1.TRPCODIGO=? )");
		params.add(tramiteComun.getIdTramite());
		params.add(tramiteComun.getTipoProcedimiento().getPcodigo());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sandoctemp>) this.jdbcTemplate.query(query.toString(), new RowMapper<Sandoctemp>() {
			public Sandoctemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Sandoctemp(resultSet.getString("U5CODOCUMENTO"), resultSet.getString("U5IDDOCUMENTUM"));
			}
		}, params.toArray());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return int
	 */
	public int updateSanDocTempRegistroOrigen(String numregistroOrigen, Date fecharegistroOrigen, String codocumento) {
		String query = "UPDATE SANDOCTEMP SET U5NUMREGISTROORIGEN=?,U5FECHAREGISTROORIGEN=? WHERE U5CODOCUMENTO=?";
		return this.jdbcTemplate.update(query, numregistroOrigen, fecharegistroOrigen, codocumento);
	}
}
