package com.ejie.y41b.dao;

//import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TramiteComun;

/**
 * SandoctempDao  
 * 
 *  
 */

public interface SandoctempDao {

	/**
	 * Inserts a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp add(Sandoctemp sandoctemp);

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp update(Sandoctemp sandoctemp);

	/**
	 * Finds a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp find(Sandoctemp sandoctemp);

	/**
	 * Deletes a single row in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return
	 */
	void remove(Sandoctemp sandoctemp);

	/**
	 * Finds a List of rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sandoctemp> findAll(Sandoctemp sandoctemp, Pagination pagination);

	/**
	 * Counts rows in the Sandoctemp table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Long
	 */
	Long findAllCount(Sandoctemp sandoctemp);

	/**
	 * Finds rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sandoctemp> findAllLike(Sandoctemp sandoctemp, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sandoctemp table using like.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sandoctemp sandoctemp, Boolean startsWith);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addAdjuntarDocsSanDocTramite(TramiteComun tramiteComun);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void removeSanDocTramite(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addSanAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sandoctemp> findAllSanDocumentosTramite(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param documentos
	 *            List<Map<String, Object>>
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun, List<Map<String, Object>> documentos);

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param documentoHecho
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	public Sandoctemp updateOIDDokusi(Sandoctemp documentoHecho);

	/**
	 * Updates a single row in the Sandoctemp table.
	 * 
	 * @param documentoHecho
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	public Sandoctemp removeBlobFromOIDDokusi(Sandoctemp documentoHecho);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	public Long getNewPK();

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param documentoHecho
	 *            Sandoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDoc(Sandoctemp documentoHecho, TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Sandoctemp> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDesdeAdjuntarDocsASanDocTemp(TramiteComun tramiteComun);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public Sandoctemp updateOrigen(Sandoctemp documentoHecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<DocumentoExpediente> findAllDocumentosExpediente(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the Sandoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	Sandoctemp updateDatosFirma(Sandoctemp sandoctemp);

	/**
	 * 
	 * @param idNuevoTramite
	 *            String
	 * @param codocumento
	 *            String
	 * @param tipoProcedimiento
	 *            String
	 */
	void insertSanDocTramite(String idNuevoTramite, String codocumento, String tipoProcedimiento);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tipoDocumento
	 *            the tipo documento
	 * @param excodigo
	 *            the excodigo
	 * @return the date
	 */
	public Date dameFechaAportacionDocumentacion(String tipoDocumento, String excodigo);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return int
	 */
	public int updateSanDocTemp(Sandoctemp sandoctemp);

	/**
	 * copiaSanDocTramite
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	public void copiaSanDocTramite(String tridOrigen, String tridDestino);

	/**
	 * copiaSanDocTramiteDeUnTipo
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	public void copiaSanDocTramiteDeUnTipo(String tridOrigen, String tridDestino, String tipo);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Sandoctemp
	 */
	public Sandoctemp updateFechaLocalizacion(Sandoctemp sandoctemp);

	/**
	 * findAllDocumentosExpedienteCount
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun);

	/**
	 * findAllDocumentosHechoComunicacionCount
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Counts rows in the Sandoctramite table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return Long
	 */
	public Long findAllDocTramiteHechoCount(Sandoctemp sandoctemp);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List<Sandoctemp>
	 */
	List<Sandoctemp> findAllDocumentosEliminados(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param codocumento
	 *            String
	 */
	void removeSanDocTramiteDocId(TramiteComun tramiteComun, String codocumento);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return int
	 */
	public int updateSanDocTempRegistroOrigen(String numregistroOrigen, Date fecharegistroOrigen, String codocumento);
}
