package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sancuesproced;

/**
 * SancuesprocedDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SancuesprocedDaoImpl implements SancuesprocedDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Sancuesproced> rwMap = new RowMapper<Sancuesproced>() {
		public Sancuesproced mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sancuesproced(resultSet.getString("CPCODIGO"),
					resultSet.getString("CPDESCES"),
					resultSet.getString("CPDESCEU"),
					resultSet.getDate("CPFECALTA"),
					resultSet.getDate("CPFECMODIF"),
					resultSet.getString("CPUSUALTA"),
					resultSet.getString("CPUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Pagination
	 * @return Sancuesproced
	 */
	public Sancuesproced add(Sancuesproced sancuesproced) {
		String query = "INSERT INTO SANCUESPROCED (CPCODIGO, CPDESCES, CPDESCEU, CPFECALTA, CPFECMODIF, CPUSUALTA, CPUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sancuesproced.getCpcodigo(),
				sancuesproced.getCpdesces(), sancuesproced.getCpdesceu(),
				sancuesproced.getCpfecalta(), sancuesproced.getCpfecmodif(),
				sancuesproced.getCpusualta(), sancuesproced.getCpusumodif());
		return sancuesproced;
	}

	/**
	 * Updates a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Pagination
	 * @return Sancuesproced
	 */
	public Sancuesproced update(Sancuesproced sancuesproced) {
		String query = "UPDATE SANCUESPROCED SET CPDESCES=?, CPDESCEU=?, CPFECALTA=?, CPFECMODIF=?, CPUSUALTA=?, CPUSUMODIF=? WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, sancuesproced.getCpdesces(),
				sancuesproced.getCpdesceu(), sancuesproced.getCpfecalta(),
				sancuesproced.getCpfecmodif(), sancuesproced.getCpusualta(),
				sancuesproced.getCpusumodif(), sancuesproced.getCpcodigo());
		return sancuesproced;
	}

	/**
	 * Updates a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Pagination
	 * @return Sancuesproced
	 */
	public Sancuesproced updateFechaBaja(Sancuesproced sancuesproced) {
		String query = "UPDATE SANCUESPROCED SET CPFECBAJA=SYSDATE WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, sancuesproced.getCpcodigo());
		return sancuesproced;
	}

	/**
	 * Finds a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Pagination
	 * @return Sancuesproced
	 */
	@Transactional(readOnly = true)
	public Sancuesproced find(Sancuesproced sancuesproced) {
		String query = "SELECT t1.CPCODIGO CPCODIGO, t1.CPDESCES CPDESCES, t1.CPDESCEU CPDESCEU, t1.CPFECALTA CPFECALTA, t1.CPFECMODIF CPFECMODIF, t1.CPUSUALTA CPUSUALTA, t1.CPUSUMODIF CPUSUMODIF FROM SANCUESPROCED t1  WHERE t1.CPCODIGO = ?  ";

		List<Sancuesproced> sancuesprocedList = this.jdbcTemplate.query(query,
				this.rwMap, sancuesproced.getCpcodigo());
		return (Sancuesproced) DataAccessUtils.uniqueResult(sancuesprocedList);
	}

	/**
	 * Removes a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Pagination
	 * @return
	 */
	public void remove(Sancuesproced sancuesproced) {
		String query = "DELETE FROM SANCUESPROCED WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, sancuesproced.getCpcodigo());
	}

	/**
	 * Finds a List of rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sancuesproced> findAll(Sancuesproced sancuesproced,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPDESCES CPDESCES,NVL(t1.CPDESCEU,t1.CPDESCES) CPDESCEU,t1.CPFECALTA CPFECALTA,t1.CPFECMODIF CPFECMODIF,t1.CPUSUALTA CPUSUALTA,t1.CPUSUMODIF CPUSUMODIF ");
		query.append("FROM SANCUESPROCED t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sancuesproced);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sancuesproced>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sancuesproced> findAllAlta(Sancuesproced sancuesproced,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPDESCES CPDESCES,NVL(t1.CPDESCEU,t1.CPDESCES) CPDESCEU,t1.CPFECALTA CPFECALTA,t1.CPFECMODIF CPFECMODIF,t1.CPUSUALTA CPUSUALTA,t1.CPUSUMODIF CPUSUMODIF ");
		query.append("FROM SANCUESPROCED t1 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.CPFECBAJA IS NULL ");
		query.append(where);

		List<Object> params = new ArrayList<Object>();

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sancuesproced>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sancuesproced sancuesproced) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANCUESPROCED t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sancuesproced);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sancuesproced table using like.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sancuesproced> findAllLike(Sancuesproced sancuesproced,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPDESCES CPDESCES,NVL(t1.CPDESCEU,t1.CPDESCES) CPDESCEU,t1.CPFECALTA CPFECALTA,t1.CPFECMODIF CPFECMODIF,t1.CPUSUALTA CPUSUALTA,t1.CPUSUMODIF CPUSUMODIF ");
		query.append("FROM SANCUESPROCED t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sancuesproced,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sancuesproced>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sancuesproced table using like.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sancuesproced sancuesproced, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANCUESPROCED t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sancuesproced,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sancuesproced entity
	 * 
	 * @param sancuesproced
	 *            Sancuesproced Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sancuesproced sancuesproced) {

		StringBuilder where = new StringBuilder(
				SancuesprocedDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sancuesproced != null && sancuesproced.getCpcodigo() != null) {
			where.append(" AND t1.CPCODIGO = ?");
			params.add(sancuesproced.getCpcodigo());
		}
		if (sancuesproced != null && sancuesproced.getCpdesces() != null) {
			where.append(" AND t1.CPDESCES = ?");
			params.add(sancuesproced.getCpdesces());
		}
		if (sancuesproced != null && sancuesproced.getCpdesceu() != null) {
			where.append(" AND t1.CPDESCEU = ?");
			params.add(sancuesproced.getCpdesceu());
		}
		if (sancuesproced != null && sancuesproced.getCpfecalta() != null) {
			where.append(" AND t1.CPFECALTA = ?");
			params.add(sancuesproced.getCpfecalta());
		}
		if (sancuesproced != null && sancuesproced.getCpfecmodif() != null) {
			where.append(" AND t1.CPFECMODIF = ?");
			params.add(sancuesproced.getCpfecmodif());
		}
		if (sancuesproced != null && sancuesproced.getCpusualta() != null) {
			where.append(" AND t1.CPUSUALTA = ?");
			params.add(sancuesproced.getCpusualta());
		}
		if (sancuesproced != null && sancuesproced.getCpusumodif() != null) {
			where.append(" AND t1.CPUSUMODIF = ?");
			params.add(sancuesproced.getCpusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sancuesproced entity
	 * 
	 * @param sancuesproced
	 *            Sancuesproced Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sancuesproced sancuesproced,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SancuesprocedDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sancuesproced != null && sancuesproced.getCpcodigo() != null) {
			where.append(" AND UPPER(t1.CPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sancuesproced.getCpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sancuesproced.getCpcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPCODIGO IS NOT NULL");
		}
		if (sancuesproced != null && sancuesproced.getCpdesces() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.CPDESCES),'','AEIOU')  like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sancuesproced.getCpdesces().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ sancuesproced.getCpdesces().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CPDESCES IS NOT NULL");
		}
		if (sancuesproced != null && sancuesproced.getCpdesceu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.CPDESCEU),'','AEIOU')  like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sancuesproced.getCpdesceu().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ sancuesproced.getCpdesceu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CPDESCEU IS NOT NULL");
		}
		if (sancuesproced != null && sancuesproced.getCpfecalta() != null) {
			where.append(" AND t1.CPFECALTA = ?");
			params.add(sancuesproced.getCpfecalta());
		}
		if (sancuesproced != null && sancuesproced.getCpfecmodif() != null) {
			where.append(" AND t1.CPFECMODIF = ?");
			params.add(sancuesproced.getCpfecmodif());
		}
		if (sancuesproced != null && sancuesproced.getCpusualta() != null) {
			where.append(" AND UPPER(t1.CPUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sancuesproced.getCpusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sancuesproced.getCpusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPUSUALTA IS NOT NULL");
		}
		if (sancuesproced != null && sancuesproced.getCpusumodif() != null) {
			where.append(" AND UPPER(t1.CPUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sancuesproced.getCpusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sancuesproced.getCpusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CPUSUMODIF IS NOT NULL");
		}

		where.append(" AND t1.CPFECBAJA IS NULL");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
