package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Sancuesproced;

/**
 * SancuesprocedDao  
 * 
 *  
 */

public interface SancuesprocedDao {

	/**
	 * Inserts a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	Sancuesproced add(Sancuesproced sancuesproced);

	/**
	 * Updates a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	Sancuesproced update(Sancuesproced sancuesproced);

	/**
	 * Updates a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Pagination
	 * @return Sancuesproced
	 */
	public Sancuesproced updateFechaBaja(Sancuesproced sancuesproced);

	/**
	 * Finds a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Sancuesproced
	 */
	Sancuesproced find(Sancuesproced sancuesproced);

	/**
	 * Deletes a single row in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return
	 */
	void remove(Sancuesproced sancuesproced);

	/**
	 * Finds a List of rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sancuesproced> findAll(Sancuesproced sancuesproced,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sancuesproced> findAllAlta(Sancuesproced sancuesproced,
			Pagination pagination);

	/**
	 * Counts rows in the Sancuesproced table.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @return Long
	 */
	Long findAllCount(Sancuesproced sancuesproced);

	/**
	 * Finds rows in the Sancuesproced table using like.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sancuesproced> findAllLike(Sancuesproced sancuesproced,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sancuesproced table using like.
	 * 
	 * @param sancuesproced
	 *            Sancuesproced
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sancuesproced sancuesproced, Boolean startsWith);
}
