package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sancuesfondo;

/**
 * SancuesfondoDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class SancuesfondoDaoImpl implements SancuesfondoDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Sancuesfondo> rwMap = new RowMapper<Sancuesfondo>() {
		public Sancuesfondo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Sancuesfondo(
               resultSet.getString("CFCODIGO"), resultSet.getString("CFDESCES"), resultSet.getString("CFDESCEU"), resultSet.getDate("CFFECALTA"), resultSet.getDate("CFFECMODIF"), resultSet.getString("CFUSUALTA"), resultSet.getString("CFUSUMODIF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Sancuesfondo table.
     *
     * @param sancuesfondo Pagination
     * @return Sancuesfondo
     */
	public Sancuesfondo add(Sancuesfondo sancuesfondo) {
    	String query = "INSERT INTO SANCUESFONDO (CFCODIGO, CFDESCES, CFDESCEU, CFFECALTA, CFFECMODIF, CFUSUALTA, CFUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sancuesfondo.getCfcodigo(), sancuesfondo.getCfdesces(), sancuesfondo.getCfdesceu(), sancuesfondo.getCffecalta(), sancuesfondo.getCffecmodif(), sancuesfondo.getCfusualta(), sancuesfondo.getCfusumodif());
		return sancuesfondo;
	}

    /**
     * Updates a single row in the Sancuesfondo table.
     *
     * @param sancuesfondo Pagination
     * @return Sancuesfondo
     */
    public Sancuesfondo update(Sancuesfondo sancuesfondo) {
		String query = "UPDATE SANCUESFONDO SET CFDESCES=?, CFDESCEU=?, CFFECALTA=?, CFFECMODIF=?, CFUSUALTA=?, CFUSUMODIF=? WHERE CFCODIGO=?";
		this.jdbcTemplate.update(query, sancuesfondo.getCfdesces(), sancuesfondo.getCfdesceu(), sancuesfondo.getCffecalta(), sancuesfondo.getCffecmodif(), sancuesfondo.getCfusualta(), sancuesfondo.getCfusumodif(), sancuesfondo.getCfcodigo());
		return sancuesfondo;
	}

    /**
     * Finds a single row in the Sancuesfondo table.
     *
     * @param sancuesfondo Pagination
     * @return Sancuesfondo
     */
    @Transactional (readOnly = true)
    public Sancuesfondo find(Sancuesfondo sancuesfondo) {
		String query = "SELECT t1.CFCODIGO CFCODIGO, t1.CFDESCES CFDESCES, t1.CFDESCEU CFDESCEU, t1.CFFECALTA CFFECALTA, t1.CFFECMODIF CFFECMODIF, t1.CFUSUALTA CFUSUALTA, t1.CFUSUMODIF CFUSUMODIF FROM SANCUESFONDO t1  WHERE t1.CFCODIGO = ?  ";
		
		List<Sancuesfondo> sancuesfondoList = this.jdbcTemplate.query(query, this.rwMap, sancuesfondo.getCfcodigo());
		return (Sancuesfondo) DataAccessUtils.uniqueResult(sancuesfondoList);
    }

    /**
     * Removes a single row in the Sancuesfondo table.
     *
     * @param sancuesfondo Pagination
     * @return
     */
    public void remove(Sancuesfondo sancuesfondo) {
		String query = "DELETE FROM SANCUESFONDO WHERE CFCODIGO=?";
		this.jdbcTemplate.update(query, sancuesfondo.getCfcodigo());
    }
    
   /**
    * Finds a List of rows in the Sancuesfondo table.
    * 
    * @param sancuesfondo Sancuesfondo
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Sancuesfondo> findAll(Sancuesfondo sancuesfondo, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.CFCODIGO CFCODIGO,t1.CFDESCES CFDESCES,t1.CFDESCEU CFDESCEU,t1.CFFECALTA CFFECALTA,t1.CFFECMODIF CFFECMODIF,t1.CFUSUALTA CFUSUALTA,t1.CFUSUMODIF CFUSUMODIF "); 
		query.append("FROM SANCUESFONDO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sancuesfondo); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sancuesfondo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Sancuesfondo table.
     * 
     * @param sancuesfondo Sancuesfondo
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Sancuesfondo sancuesfondo) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANCUESFONDO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sancuesfondo); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Sancuesfondo table using like.
     * 
     * @param sancuesfondo Sancuesfondo
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Sancuesfondo> findAllLike(Sancuesfondo sancuesfondo, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.CFCODIGO CFCODIGO,t1.CFDESCES CFDESCES,t1.CFDESCEU CFDESCEU,t1.CFFECALTA CFFECALTA,t1.CFFECMODIF CFFECMODIF,t1.CFUSUALTA CFUSUALTA,t1.CFUSUMODIF CFUSUMODIF "); 
        query.append("FROM SANCUESFONDO t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sancuesfondo,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sancuesfondo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Sancuesfondo table using like.
     * 
     * @param sancuesfondo Sancuesfondo
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Sancuesfondo sancuesfondo, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANCUESFONDO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sancuesfondo,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Sancuesfondo entity 
	 * 
	 * @param sancuesfondo Sancuesfondo
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Sancuesfondo sancuesfondo){
		
		StringBuilder where = new StringBuilder(SancuesfondoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sancuesfondo  != null  && sancuesfondo.getCfcodigo() != null ) {
			where.append(" AND t1.CFCODIGO = ?");
			params.add(sancuesfondo.getCfcodigo());
		}
		if (sancuesfondo  != null  && sancuesfondo.getCfdesces() != null ) {
			where.append(" AND t1.CFDESCES = ?");
			params.add(sancuesfondo.getCfdesces());
		}
		if (sancuesfondo  != null  && sancuesfondo.getCfdesceu() != null ) {
			where.append(" AND t1.CFDESCEU = ?");
			params.add(sancuesfondo.getCfdesceu());
		}
		if (sancuesfondo  != null  && sancuesfondo.getCffecalta() != null ) {
			where.append(" AND t1.CFFECALTA = ?");
			params.add(sancuesfondo.getCffecalta());
		}
		if (sancuesfondo  != null  && sancuesfondo.getCffecmodif() != null ) {
			where.append(" AND t1.CFFECMODIF = ?");
			params.add(sancuesfondo.getCffecmodif());
		}
		if (sancuesfondo  != null  && sancuesfondo.getCfusualta() != null ) {
			where.append(" AND t1.CFUSUALTA = ?");
			params.add(sancuesfondo.getCfusualta());
		}
		if (sancuesfondo  != null  && sancuesfondo.getCfusumodif() != null ) {
			where.append(" AND t1.CFUSUMODIF = ?");
			params.add(sancuesfondo.getCfusumodif());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Sancuesfondo entity 
	 * 
	 * @param sancuesfondo Sancuesfondo
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Sancuesfondo sancuesfondo, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(SancuesfondoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sancuesfondo  != null  && sancuesfondo.getCfcodigo() != null ) {
			where.append(" AND UPPER(t1.CFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancuesfondo.getCfcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+sancuesfondo.getCfcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.CFCODIGO IS NOT NULL");
	     }			
		if (sancuesfondo  != null  && sancuesfondo.getCfdesces() != null ) {
			where.append(" AND UPPER(t1.CFDESCES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancuesfondo.getCfdesces().toUpperCase() +"%");
			}else{
				params.add("%"+sancuesfondo.getCfdesces().toUpperCase() +"%");
			}
			where.append(" AND t1.CFDESCES IS NOT NULL");
	     }			
		if (sancuesfondo  != null  && sancuesfondo.getCfdesceu() != null ) {
			where.append(" AND UPPER(t1.CFDESCEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancuesfondo.getCfdesceu().toUpperCase() +"%");
			}else{
				params.add("%"+sancuesfondo.getCfdesceu().toUpperCase() +"%");
			}
			where.append(" AND t1.CFDESCEU IS NOT NULL");
	     }			
		if (sancuesfondo  != null  && sancuesfondo.getCffecalta() != null ) {
			where.append(" AND t1.CFFECALTA = ?");
			params.add(sancuesfondo.getCffecalta());
	     }			
		if (sancuesfondo  != null  && sancuesfondo.getCffecmodif() != null ) {
			where.append(" AND t1.CFFECMODIF = ?");
			params.add(sancuesfondo.getCffecmodif());
	     }			
		if (sancuesfondo  != null  && sancuesfondo.getCfusualta() != null ) {
			where.append(" AND UPPER(t1.CFUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancuesfondo.getCfusualta().toUpperCase() +"%");
			}else{
				params.add("%"+sancuesfondo.getCfusualta().toUpperCase() +"%");
			}
			where.append(" AND t1.CFUSUALTA IS NOT NULL");
	     }			
		if (sancuesfondo  != null  && sancuesfondo.getCfusumodif() != null ) {
			where.append(" AND UPPER(t1.CFUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancuesfondo.getCfusumodif().toUpperCase() +"%");
			}else{
				params.add("%"+sancuesfondo.getCfusumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.CFUSUMODIF IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

