package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sancontrolplazos;

/**
 * SancontrolplazosDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class SancontrolplazosDaoImpl implements SancontrolplazosDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Sancontrolplazos> rwMap = new RowMapper<Sancontrolplazos>() {
		public Sancontrolplazos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Sancontrolplazos(
               resultSet.getBigDecimal("COID"), resultSet.getString("CONOMBREES"), resultSet.getString("CONOMBREEU"), resultSet.getBigDecimal("COPLAZO"), resultSet.getString("COTIPOPLAZO"), resultSet.getString("COPRID")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Sancontrolplazos table.
     *
     * @param sancontrolplazos Pagination
     * @return Sancontrolplazos
     */
	public Sancontrolplazos add(Sancontrolplazos sancontrolplazos) {
    	String query = "INSERT INTO SANCONTROLPLAZOS (COID, CONOMBRE_ES, CONOMBRE_EU, COPLAZO, COTIPOPLAZO, COPRID) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sancontrolplazos.getCoid(), sancontrolplazos.getConombreEs(), sancontrolplazos.getConombreEu(), sancontrolplazos.getCoplazo(), sancontrolplazos.getCotipoplazo(), sancontrolplazos.getCoprid());
		return sancontrolplazos;
	}

    /**
     * Updates a single row in the Sancontrolplazos table.
     *
     * @param sancontrolplazos Pagination
     * @return Sancontrolplazos
     */
    public Sancontrolplazos update(Sancontrolplazos sancontrolplazos) {
		String query = "UPDATE SANCONTROLPLAZOS SET CONOMBRE_ES=?, CONOMBRE_EU=?, COPLAZO=?, COTIPOPLAZO=?, COPRID=? WHERE COID=?";
		this.jdbcTemplate.update(query, sancontrolplazos.getConombreEs(), sancontrolplazos.getConombreEu(), sancontrolplazos.getCoplazo(), sancontrolplazos.getCotipoplazo(), sancontrolplazos.getCoprid(), sancontrolplazos.getCoid());
		return sancontrolplazos;
	}

    /**
     * Finds a single row in the Sancontrolplazos table.
     *
     * @param sancontrolplazos Pagination
     * @return Sancontrolplazos
     */
    @Transactional (readOnly = true)
    public Sancontrolplazos find(Sancontrolplazos sancontrolplazos) {
		String query = "SELECT t1.COID COID, t1.CONOMBRE_ES CONOMBREES, t1.CONOMBRE_EU CONOMBREEU, t1.COPLAZO COPLAZO, t1.COTIPOPLAZO COTIPOPLAZO, t1.COPRID COPRID FROM SANCONTROLPLAZOS t1  WHERE t1.COID = ?  ";
		
		List<Sancontrolplazos> sancontrolplazosList = this.jdbcTemplate.query(query, this.rwMap, sancontrolplazos.getCoid());
		return (Sancontrolplazos) DataAccessUtils.uniqueResult(sancontrolplazosList);
    }

    /**
     * Removes a single row in the Sancontrolplazos table.
     *
     * @param sancontrolplazos Pagination
     * @return
     */
    public void remove(Sancontrolplazos sancontrolplazos) {
		String query = "DELETE FROM SANCONTROLPLAZOS WHERE COID=?";
		this.jdbcTemplate.update(query, sancontrolplazos.getCoid());
    }
    
   /**
    * Finds a List of rows in the Sancontrolplazos table.
    * 
    * @param sancontrolplazos Sancontrolplazos
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Sancontrolplazos> findAll(Sancontrolplazos sancontrolplazos, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.COID COID,t1.CONOMBRE_ES CONOMBREES,t1.CONOMBRE_EU CONOMBREEU,t1.COPLAZO COPLAZO,t1.COTIPOPLAZO COTIPOPLAZO,t1.COPRID COPRID "); 
		query.append("FROM SANCONTROLPLAZOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sancontrolplazos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sancontrolplazos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Sancontrolplazos table.
     * 
     * @param sancontrolplazos Sancontrolplazos
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Sancontrolplazos sancontrolplazos) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANCONTROLPLAZOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sancontrolplazos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Sancontrolplazos table using like.
     * 
     * @param sancontrolplazos Sancontrolplazos
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Sancontrolplazos> findAllLike(Sancontrolplazos sancontrolplazos, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.COID COID,t1.CONOMBRE_ES CONOMBREES,t1.CONOMBRE_EU CONOMBREEU,t1.COPLAZO COPLAZO,t1.COTIPOPLAZO COTIPOPLAZO,t1.COPRID COPRID "); 
        query.append("FROM SANCONTROLPLAZOS t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sancontrolplazos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sancontrolplazos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Sancontrolplazos table using like.
     * 
     * @param sancontrolplazos Sancontrolplazos
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Sancontrolplazos sancontrolplazos, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANCONTROLPLAZOS t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sancontrolplazos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Sancontrolplazos entity 
	 * 
	 * @param sancontrolplazos Sancontrolplazos
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Sancontrolplazos sancontrolplazos){
		
		StringBuilder where = new StringBuilder(SancontrolplazosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sancontrolplazos  != null  && sancontrolplazos.getCoid() != null ) {
			where.append(" AND t1.COID = ?");
			params.add(sancontrolplazos.getCoid());
		}
		if (sancontrolplazos  != null  && sancontrolplazos.getConombreEs() != null ) {
			where.append(" AND t1.CONOMBRE_ES = ?");
			params.add(sancontrolplazos.getConombreEs());
		}
		if (sancontrolplazos  != null  && sancontrolplazos.getConombreEu() != null ) {
			where.append(" AND t1.CONOMBRE_EU = ?");
			params.add(sancontrolplazos.getConombreEu());
		}
		if (sancontrolplazos  != null  && sancontrolplazos.getCoplazo() != null ) {
			where.append(" AND t1.COPLAZO = ?");
			params.add(sancontrolplazos.getCoplazo());
		}
		if (sancontrolplazos  != null  && sancontrolplazos.getCotipoplazo() != null ) {
			where.append(" AND t1.COTIPOPLAZO = ?");
			params.add(sancontrolplazos.getCotipoplazo());
		}
		if (sancontrolplazos  != null  && sancontrolplazos.getCoprid() != null ) {
			where.append(" AND t1.COPRID = ?");
			params.add(sancontrolplazos.getCoprid());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Sancontrolplazos entity 
	 * 
	 * @param sancontrolplazos Sancontrolplazos
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Sancontrolplazos sancontrolplazos, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(SancontrolplazosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sancontrolplazos  != null  && sancontrolplazos.getCoid() != null ) {
			where.append(" AND t1.COID = ?");
			params.add(sancontrolplazos.getCoid());
	     }			
		if (sancontrolplazos  != null  && sancontrolplazos.getConombreEs() != null ) {
			where.append(" AND UPPER(t1.CONOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancontrolplazos.getConombreEs().toUpperCase() +"%");
			}else{
				params.add("%"+sancontrolplazos.getConombreEs().toUpperCase() +"%");
			}
			where.append(" AND t1.CONOMBRE_ES IS NOT NULL");
	     }			
		if (sancontrolplazos  != null  && sancontrolplazos.getConombreEu() != null ) {
			where.append(" AND UPPER(t1.CONOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancontrolplazos.getConombreEu().toUpperCase() +"%");
			}else{
				params.add("%"+sancontrolplazos.getConombreEu().toUpperCase() +"%");
			}
			where.append(" AND t1.CONOMBRE_EU IS NOT NULL");
	     }			
		if (sancontrolplazos  != null  && sancontrolplazos.getCoplazo() != null ) {
			where.append(" AND t1.COPLAZO = ?");
			params.add(sancontrolplazos.getCoplazo());
	     }			
		if (sancontrolplazos  != null  && sancontrolplazos.getCotipoplazo() != null ) {
			where.append(" AND UPPER(t1.COTIPOPLAZO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancontrolplazos.getCotipoplazo().toUpperCase() +"%");
			}else{
				params.add("%"+sancontrolplazos.getCotipoplazo().toUpperCase() +"%");
			}
			where.append(" AND t1.COTIPOPLAZO IS NOT NULL");
	     }			
		if (sancontrolplazos  != null  && sancontrolplazos.getCoprid() != null ) {
			where.append(" AND UPPER(t1.COPRID) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sancontrolplazos.getCoprid().toUpperCase() +"%");
			}else{
				params.add("%"+sancontrolplazos.getCoprid().toUpperCase() +"%");
			}
			where.append(" AND t1.COPRID IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

