/*
 * 
 */
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanbandejaDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class SanbandejaDaoImpl implements SanbandejaDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger LOGGER = LoggerFactory.getLogger(SanbandejaDaoImpl.class);

	@Autowired()
	private ParametrosDao parametrosDao;

	private RowMapper<Sanbandeja> rwMap = new RowMapper<Sanbandeja>() {
		public Sanbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Sanexp sanexp = new Sanexp(resultSet.getString("EXPEDIENEXCODIGO"), null, null,
					resultSet.getString("EXDESCES"), resultSet.getString("EXDESCEU"), null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null);
			Expedien expedien = new Expedien(resultSet.getString("EXPEDIENEXCODIGO"),
					resultSet.getString("CODCOMPLETO"), resultSet.getDate("EXPEDIENEXFERE"), sanexp, null,
					resultSet.getString("EXPEDIENEXCOOR"), resultSet.getBigDecimal("EXPEDIENEXNRAN"),
					resultSet.getBigDecimal("EXPEDIENEXNROR"), resultSet.getString("EXPEDIENEXCOIT"));
			Saninterv saninterv = new Saninterv(resultSet.getBigDecimal("SanintervUAIDINTERV"),
					resultSet.getString("SanintervUANOMBRE"), resultSet.getString("SanintervUAAPELLIDO1"),
					resultSet.getString("SanintervUAAPELLIDO2"), resultSet.getString("SanintervUANIF"),
					resultSet.getString("SanintervUANRTEL"), resultSet.getString("SanintervUANRTEL2"),
					resultSet.getString("SanintervUAPROVID"), resultSet.getString("SanintervUAMUNID"),
					resultSet.getString("SanintervUALOCID"), resultSet.getString("SanintervUACALLEID"),
					resultSet.getString("SanintervUACPID"), resultSet.getString("SanintervUAPORTALID"),
					resultSet.getString("SanintervUANOMBREPISO"), resultSet.getString("SanintervUADIRENOCAPV"),
					resultSet.getString("SanintervUADIREANT"), resultSet.getString("SanintervUATIPOINTERV"),
					resultSet.getString("SanintervUADTCODIGO"), resultSet.getString("SanintervUAESCODIGO"),
					resultSet.getDate("SanintervUATRFECALTA"), resultSet.getDate("SanintervUATRFECMODIF"),
					resultSet.getString("SanintervUATRUSUALTA"), resultSet.getString("SanintervUATRUSUMODIF"),
					resultSet.getDate("SanintervUAFECALTA"), resultSet.getDate("SanintervUAFECMODIF"),
					resultSet.getString("SanintervUAUSUALTA"), resultSet.getString("SanintervUAUSUMODIF"),
					new Expedien(resultSet.getString("SanintervUAEXCODIGO"), null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null),
					null, null, null, null, null);
			CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MonitorMOCODIGO"),
					resultSet.getString("MONITORMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);
			Tramite tramite = new Tramite(resultSet.getString("SANTRAMEXPTRCODIGO"), resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);
			Santramexp santramexp = new Santramexp(resultSet.getString("BATRID"),
					resultSet.getString("SANTRAMEXPTRCODIGO"), null, resultSet.getString("SANTRAMEXPTRNOMTRAMES"),
					censoMonitor, tramite);
			santramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

			Fase fase = new Fase(resultSet.getString("BAFASE"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);

			return new Sanbandeja(resultSet.getString("BAID"), resultSet.getString("BATRID"),
					resultSet.getDate("BAFEC"), resultSet.getString("BAESTADO"), resultSet.getDate("BAFECLIMITE"),
					resultSet.getString("BAFASE"), resultSet.getString("BANOMDOC"), resultSet.getDate("BAFECALTA"),
					resultSet.getDate("BAFECMODIF"), resultSet.getString("BAUSUALTA"),
					resultSet.getString("BAUSUMODIF"), expedien, saninterv, censoMonitor, santramexp, fase,
					resultSet.getString("BATIPO"), resultSet.getDate("BAFECINI"), resultSet.getString("BATEXTO"),
					resultSet.getString("BATEXTOE"));
		}
	};

	private RowMapper<Sanbandeja> rwMapBandejaSanciones = new RowMapper<Sanbandeja>() {
		public Sanbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			try {
				Sanexp sanexp = new Sanexp(resultSet.getString("EXPEDIENEXCODIGO"));

				Expedien expedien = new Expedien(resultSet.getString("EXPEDIENEXCODIGO"),
						resultSet.getString("CODCOMPLETO"), resultSet.getDate("EXPEDIENEXFERE"), sanexp, null,
						resultSet.getString("EXPEDIENEXCOOR"), resultSet.getBigDecimal("EXPEDIENEXNRAN"),
						resultSet.getBigDecimal("EXPEDIENEXNROR"), resultSet.getString("EXPEDIENEXCOIT"));
				Saninterv saninterv = new Saninterv(resultSet.getBigDecimal("SanintervUAIDINTERV"),
						resultSet.getString("SanintervUANOMBRE"), resultSet.getString("SanintervUAAPELLIDO1"),
						resultSet.getString("SanintervUAAPELLIDO2"));
				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MonitorMOCODIGO"),
						resultSet.getString("MonitorMONOMBRE"), null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null);
				Tramite tramite = new Tramite(resultSet.getString("SANTRAMEXPTRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"), null, null, null, null, null,
						null);
				Santramexp santramexp = new Santramexp(resultSet.getString("BATRID"),
						resultSet.getString("SANTRAMEXPTRCODIGO"), null, resultSet.getString("SANTRAMEXPTRNOMTRAMES"),
						censoMonitor, tramite);
				santramexp.setTrfecini(resultSet.getDate("TRFECINI"));
				santramexp.setTrfecfin(resultSet.getDate("TRFECFIN"));
				santramexp.setTrfechaEnvioBOPVBOE(resultSet.getDate("SANTRAMEXPTRFECHAENVIOBOPVBOE"));

				santramexp.setTrestadoacuse(resultSet.getString("TRESTADOACUSE"));
				santramexp.setTrresotipo(resultSet.getString("TRRESOTIPO"));

				santramexp.setEnvcdessitcorreoses(resultSet.getString("ENVCDESSITCORREOSES"));
				santramexp.setEnvcdessitcorreoseu(resultSet.getString("ENVCDESSITCORREOSEU"));
				santramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

				Fase fase = new Fase(resultSet.getString("BAFASE"), resultSet.getString("FASEFNOMBRE"),
						resultSet.getString("FASEFNOMBREE"), null, null);

				Sanbandeja sanbandeja = new Sanbandeja(resultSet.getString("BAID"), resultSet.getString("BATRID"),
						resultSet.getDate("BAFEC"), resultSet.getString("BAESTADO"), resultSet.getDate("BAFECLIMITE"),
						resultSet.getString("BAFASE"), resultSet.getString("BANOMDOC"), resultSet.getDate("BAFECALTA"),
						resultSet.getDate("BAFECMODIF"), resultSet.getString("BAUSUALTA"),
						resultSet.getString("BAUSUMODIF"), expedien, saninterv, censoMonitor, santramexp, fase,
						resultSet.getString("BATIPO"), resultSet.getDate("BAFECINI"), resultSet.getString("BATEXTO"),
						resultSet.getString("BATEXTOE"));
				sanbandeja.setAvisos(resultSet.getString("AVISOS"));
				sanbandeja.setTramitesPendientes(resultSet.getString("TRAMITESPENDIENTES"));
				return sanbandeja;

			} catch (Exception e) {
				e.printStackTrace();
				SanbandejaDaoImpl.LOGGER.error("Error producido en rwMapBandejaSanciones: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	};

	private RowMapper<Sanbandeja> rwMapBandejaSancionesExtras = new RowMapper<Sanbandeja>() {
		public Sanbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			try {
				Sanexp sanexp = new Sanexp(resultSet.getString("EXPEDIENEXCODIGO"));

				Expedien expedien = new Expedien(resultSet.getString("EXPEDIENEXCODIGO"),
						resultSet.getString("CODCOMPLETO"), resultSet.getDate("EXPEDIENEXFERE"), sanexp, null,
						resultSet.getString("EXPEDIENEXCOOR"), resultSet.getBigDecimal("EXPEDIENEXNRAN"),
						resultSet.getBigDecimal("EXPEDIENEXNROR"), resultSet.getString("EXPEDIENEXCOIT"));
				Saninterv saninterv = new Saninterv(resultSet.getBigDecimal("SanintervUAIDINTERV"),
						resultSet.getString("SanintervUANOMBRE"), resultSet.getString("SanintervUAAPELLIDO1"),
						resultSet.getString("SanintervUAAPELLIDO2"));
				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MonitorMOCODIGO"),
						resultSet.getString("MonitorMONOMBRE"), null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null);
				Tramite tramite = new Tramite(resultSet.getString("SANTRAMEXPTRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"), null, null, null, null, null,
						null);
				Santramexp santramexp = new Santramexp(resultSet.getString("BATRID"),
						resultSet.getString("SANTRAMEXPTRCODIGO"), null, resultSet.getString("SANTRAMEXPTRNOMTRAMES"),
						censoMonitor, tramite);
				santramexp.setTrfecini(resultSet.getDate("TRFECINI"));
				santramexp.setTrfecfin(resultSet.getDate("TRFECFIN"));
				santramexp.setTrfechaEnvioBOPVBOE(resultSet.getDate("SANTRAMEXPTRFECHAENVIOBOPVBOE"));

				santramexp.setTrestadoacuse(resultSet.getString("TRESTADOACUSE"));
				santramexp.setTrresotipo(resultSet.getString("TRRESOTIPO"));

				santramexp.setEnvcdessitcorreoses(resultSet.getString("ENVCDESSITCORREOSES"));
				santramexp.setEnvcdessitcorreoseu(resultSet.getString("ENVCDESSITCORREOSEU"));
				santramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

				Fase fase = new Fase(resultSet.getString("BAFASE"), resultSet.getString("FASEFNOMBRE"),
						resultSet.getString("FASEFNOMBREE"), null, null);

				Sanbandeja sanbandeja = new Sanbandeja(resultSet.getString("BAID"), resultSet.getString("BATRID"),
						resultSet.getDate("BAFEC"), resultSet.getString("BAESTADO"), resultSet.getDate("BAFECLIMITE"),
						resultSet.getString("BAFASE"), resultSet.getString("BANOMDOC"), resultSet.getDate("BAFECALTA"),
						resultSet.getDate("BAFECMODIF"), resultSet.getString("BAUSUALTA"),
						resultSet.getString("BAUSUMODIF"), expedien, saninterv, censoMonitor, santramexp, fase,
						resultSet.getString("BATIPO"), resultSet.getDate("BAFECINI"), resultSet.getString("BATEXTO"),
						resultSet.getString("BATEXTOE"));
				sanbandeja.setBafeclimiteliquidacion(resultSet.getDate("BAFECLIMITELIQUIDACION"));
				sanbandeja.setAvisos(resultSet.getString("AVISOS"));
				sanbandeja.setTramitesPendientes(resultSet.getString("TRAMITESPENDIENTES"));
				return sanbandeja;

			} catch (Exception e) {
				e.printStackTrace();
				SanbandejaDaoImpl.LOGGER.error("Error producido en rwMapBandejaSanciones: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	};

	private RowMapper<Sanbandeja> rwMapAvisoAlegaciones = new RowMapper<Sanbandeja>() {
		public Sanbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			try {

				Expedien expedien = new Expedien(resultSet.getString("EXPEDIENEXCODIGO"));
				Saninterv saninterv = new Saninterv(resultSet.getBigDecimal("SanintervUAIDINTERV"));
				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MonitorMOCODIGO"), null);
				Santramexp santramexp = new Santramexp(resultSet.getString("BATRID"), null, null, null, censoMonitor,
						null);
				Fase fase = new Fase(resultSet.getString("BAFASE"), null, null, null, null);

				return new Sanbandeja(resultSet.getString("BAID"), resultSet.getString("BATRID"),
						resultSet.getDate("BAFEC"), resultSet.getString("BAESTADO"), resultSet.getDate("BAFECLIMITE"),
						resultSet.getString("BAFASE"), resultSet.getString("BANOMDOC"), resultSet.getDate("BAFECALTA"),
						resultSet.getDate("BAFECMODIF"), resultSet.getString("BAUSUALTA"),
						resultSet.getString("BAUSUMODIF"), expedien, saninterv, censoMonitor, santramexp, fase,
						resultSet.getString("BATIPO"), resultSet.getDate("BAFECINI"), resultSet.getString("BATEXTO"),
						resultSet.getString("BATEXTOE"));
			} catch (Exception e) {
				e.printStackTrace();
				SanbandejaDaoImpl.LOGGER.error("Error producido en rwMapBandejaSanciones: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Pagination
	 * @return Sanbandeja
	 */
	public Sanbandeja add(Sanbandeja sanbandeja) {
		try {
			String query = "INSERT INTO SANBANDEJA (BAEXCODIGO, BAUAIDINTERV, BAULTINSTR, BATRID, BAFEC, BAESTADO, BAFECLIMITE, BAFASE, BANOMDOC, BATIPO, BAFECINI, BATEXTO, BATEXTOE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			Object getExpedienExcodigoAux = null;
			if (sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcodigo() != null) {
				getExpedienExcodigoAux = sanbandeja.getExpedien().getExcodigo();
			}
			Object getSanintervUaidintervAux = null;
			if (sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUaidinterv() != null) {
				getSanintervUaidintervAux = sanbandeja.getSaninterv().getUaidinterv();
			}
			Object getMonitorMocodigoAux = null;
			if (sanbandeja.getMonitor() != null && sanbandeja.getMonitor().getMocodigo() != null) {
				getMonitorMocodigoAux = sanbandeja.getMonitor().getMocodigo();
			}
			this.jdbcTemplate.update(query, getExpedienExcodigoAux, getSanintervUaidintervAux, getMonitorMocodigoAux,
					sanbandeja.getBatrid(), sanbandeja.getBafec(), sanbandeja.getBaestado(),
					sanbandeja.getBafeclimite(), sanbandeja.getBafase(), sanbandeja.getBanomdoc(),
					sanbandeja.getBatipo(), sanbandeja.getBafecini(), sanbandeja.getBatexto(),
					sanbandeja.getBatextoe());
			return sanbandeja;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Updates a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Pagination
	 * @return Sanbandeja
	 */
	public Sanbandeja update(Sanbandeja sanbandeja) {
		String query = "UPDATE SANBANDEJA SET BAEXCODIGO=?, BAUAIDINTERV=?, BAULTINSTR=?, BATRID=?, BAFEC=?, BAESTADO=?, BAFECLIMITE=?, BAFASE=?, BANOMDOC=?, BAFECALTA=?, BAFECMODIF=?, BAUSUALTA=?, BAUSUMODIF=?, BATIPO=?, BAFECINI=?, BATEXTO=?, BATEXTOE=? WHERE BAID=?";
		Object getExpedienExcodigoAux = null;
		if (sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = sanbandeja.getExpedien().getExcodigo();
		}
		Object getSanintervUaidintervAux = null;
		if (sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUaidinterv() != null) {
			getSanintervUaidintervAux = sanbandeja.getSaninterv().getUaidinterv();
		}
		Object getMonitorMocodigoAux = null;
		if (sanbandeja.getMonitor() != null && sanbandeja.getMonitor().getMocodigo() != null) {
			getMonitorMocodigoAux = sanbandeja.getMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, getExpedienExcodigoAux, getSanintervUaidintervAux, getMonitorMocodigoAux,
				sanbandeja.getBatrid(), sanbandeja.getBafec(), sanbandeja.getBaestado(), sanbandeja.getBafeclimite(),
				sanbandeja.getBafase(), sanbandeja.getBanomdoc(), sanbandeja.getBafecalta(), sanbandeja.getBafecmodif(),
				sanbandeja.getBausualta(), sanbandeja.getBausumodif(), sanbandeja.getBatipo(), sanbandeja.getBafecini(),
				sanbandeja.getBatexto(), sanbandeja.getBatextoe(), sanbandeja.getBaid());
		return sanbandeja;
	}

	/**
	 * Finds a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Pagination
	 * @return Sanbandeja
	 */
	@Transactional(readOnly = true)
	public Sanbandeja find(Sanbandeja sanbandeja) {
		String query = "SELECT t1.BAID BAID, t1.BATRID BATRID, t1.BAFEC BAFEC, t1.BAESTADO BAESTADO, t1.BAFECLIMITE BAFECLIMITE, t1.BAFASE BAFASE, t1.BANOMDOC BANOMDOC, t1.BAFECALTA BAFECALTA, t1.BAFECMODIF BAFECMODIF, t1.BAUSUALTA BAUSUALTA, t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE,"
				+ " t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE, t3.UAIDINTERV SANINTERVUAIDINTERV, t3.UANOMBRE SANINTERVUANOMBRE, t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2, t3.UANIF SANINTERVUANIF, t3.UANRTEL SANINTERVUANRTEL, t3.UANRTEL2 SANINTERVUANRTEL2, t3.UAPROV_ID SANINTERVUAPROVID, t3.UAMUN_ID SANINTERVUAMUNID, t3.UALOC_ID SANINTERVUALOCID, t3.UACALLE_ID SANINTERVUACALLEID, t3.UACP_ID SANINTERVUACPID, t3.UAPORTAL_ID SANINTERVUAPORTALID, t3.UANOMBRE_PISO SANINTERVUANOMBREPISO, t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV, t3.UADIRE_ANT SANINTERVUADIREANT, t3.UATIPOINTERV SANINTERVUATIPOINTERV, t3.UADTCODIGO SANINTERVUADTCODIGO, t3.UAESCODIGO SANINTERVUAESCODIGO, t3.UATRFECALTA SANINTERVUATRFECALTA, t3.UATRFECMODIF SANINTERVUATRFECMODIF, t3.UATRUSUALTA SANINTERVUATRUSUALTA, t3.UATRUSUMODIF SANINTERVUATRUSUMODIF, t3.UAFECALTA SANINTERVUAFECALTA, t3.UAFECMODIF SANINTERVUAFECMODIF, t3.UAUSUALTA SANINTERVUAUSUALTA, t3.UAUSUMODIF SANINTERVUAUSUMODIF, t4.MOCODIGO MONITORMOCODIGO, t4.MONOMBRE MONITORMONOMBRE, t4.MOCOOR MONITORMOCOOR, t4.MOCOEM MONITORMOCOEM, t4.MOUSU MONITORMOUSU, t4.MOCLAVE MONITORMOCLAVE, t4.MOFECBAJA MONITORMOFECBAJA, t4.MOADMIN MONITORMOADMIN, t4.MOPRIMERA MONITORMOPRIMERA, t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES, t4.ID_PERFILSANCIONES MONITORIDPERFILSANCIONES, t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES, t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE, t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION, t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS, t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO, t4.USUARIOXLNET MONITORUSUARIOXLNET, t3.UAEXCODIGO SANINTERVUAEXCODIGO "
				+ " FROM SANBANDEJA t1 , EXPEDIEN t2 , SANINTERV t3 , CENSO_MONITOR t4  WHERE t1.BAID = ?   AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t1.BAUAIDINTERV= t3.UAIDINTERV(+) AND t1.BAULTINSTR= t4.MOCODIGO(+)";

		List<Sanbandeja> sanbandejaList = this.jdbcTemplate.query(query, this.rwMap, sanbandeja.getBaid());
		return (Sanbandeja) DataAccessUtils.uniqueResult(sanbandejaList);
	}

	/**
	 * Borra la bandeja para un expediente.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 */
	@Transactional(readOnly = true)
	public void deleteBandejaPorExpediente(Sanbandeja sanbandeja) {
		StringBuffer query = new StringBuffer("DELETE FROM SANBANDEJA WHERE BAEXCODIGO=? AND BATIPO IS NULL");
		SanbandejaDaoImpl.LOGGER.info(
				"SanbandejaDaoImpl - deleteBandejaPorExpediente - Inicio " + sanbandeja.getExpedien().getExcodigo());
		this.jdbcTemplate.update(query.toString(), sanbandeja.getExpedien().getExcodigo());

	}

	/**
	 * Borra los avisos caducados de la bandeja.
	 * 
	 */

	public void deleteBandejaAvisosCaducados() {

		/* borramos los caducados */
		StringBuffer query = new StringBuffer("DELETE FROM SANBANDEJA WHERE (BATIPO = '"
				+ Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC + "' OR BATIPO = '"
				+ Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL + "' OR BATIPO = '"
				+ Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION + "' OR BATIPO = '"
				+ Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA
				+ "') AND (BAFECLIMITE < sysdate) ");

		this.jdbcTemplate.update(query.toString());

	}

	/**
	 * Removes a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Pagination
	 * @return
	 */
	public void remove(Sanbandeja sanbandeja) {
		String query = "DELETE FROM SANBANDEJA WHERE BAID=?";
		SanbandejaDaoImpl.LOGGER
				.info("SanbandejaDaoImpl - *** Remove - Elimino Registro de la bandeja " + sanbandeja.getBaid());
		this.jdbcTemplate.update(query, sanbandeja.getBaid());
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanbandeja> findAll(Sanbandeja sanbandeja, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.BAID BAID,t1.BATRID BATRID,t1.BAFEC BAFEC,t1.BAESTADO BAESTADO,t1.BAFECLIMITE BAFECLIMITE,t1.BAFASE BAFASE,t1.BANOMDOC BANOMDOC,t1.BAFECALTA BAFECALTA,t1.BAFECMODIF BAFECMODIF,t1.BAUSUALTA BAUSUALTA,t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE "
						+ " ,t2.EXCODIGO EXPEDIENEXCODIGO,(SELECT EXDESCES FROM SANEXP WHERE T2.EXCODIGO = EXCODIGO) AS EXDESCES, (SELECT EXDESCEU FROM SANEXP WHERE T2.EXCODIGO = EXCODIGO) AS EXDESCEU, t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXCOOR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t2.EXNRAN CODCOMPLETO, t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2, t3.UANIF SANINTERVUANIF,t3.UANRTEL SANINTERVUANRTEL,t3.UANRTEL2 SANINTERVUANRTEL2,t3.UAPROV_ID SANINTERVUAPROVID,t3.UAMUN_ID SANINTERVUAMUNID,t3.UALOC_ID SANINTERVUALOCID,t3.UACALLE_ID SANINTERVUACALLEID,t3.UACP_ID SANINTERVUACPID,t3.UAPORTAL_ID SANINTERVUAPORTALID,t3.UANOMBRE_PISO SANINTERVUANOMBREPISO,t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t3.UADIRE_ANT SANINTERVUADIREANT,t3.UATIPOINTERV SANINTERVUATIPOINTERV,t3.UADTCODIGO SANINTERVUADTCODIGO,t3.UAESCODIGO SANINTERVUAESCODIGO,t3.UATRFECALTA SANINTERVUATRFECALTA,t3.UATRFECMODIF SANINTERVUATRFECMODIF,t3.UATRUSUALTA SANINTERVUATRUSUALTA,t3.UATRUSUMODIF SANINTERVUATRUSUMODIF,t3.UAFECALTA SANINTERVUAFECALTA,t3.UAFECMODIF SANINTERVUAFECMODIF,t3.UAUSUALTA SANINTERVUAUSUALTA,t3.UAUSUMODIF SANINTERVUAUSUMODIF,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE,t4.MOCOOR MONITORMOCOOR,t4.MOCOEM MONITORMOCOEM,t4.MOUSU MONITORMOUSU,t4.MOCLAVE MONITORMOCLAVE,t4.MOFECBAJA MONITORMOFECBAJA,t4.MOADMIN MONITORMOADMIN,t4.MOPRIMERA MONITORMOPRIMERA,t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES,t4.ID_PERFILSANCIONES MONITORIDPERFILSANCIONES,t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES,t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE,t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION,t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS,t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO,t4.USUARIOXLNET MONITORUSUARIOXLNET,t3.UAEXCODIGO SANINTERVUAEXCODIGO, T5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES, t5.TRCODIGO SANTRAMEXPTRCODIGO, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE " + " ,t5.TRISTELEMATICA TRISTELEMATICA ");
		query.append(
				"FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,CENSO_MONITOR t4, SANTRAMEXP t5, FASE t6, TRAMITE t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanbandeja);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t5.TRUAIDINTERV = t3.UAIDINTERV(+) AND t1.BAULTINSTR= t4.MOCODIGO(+) AND t1.BATRID = t5.TRID(+) AND t1.BAFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null && pagination.getSort() != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanbandeja>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanbandeja sanbandeja) {
		/*
		 * StringBuilder query = new StringBuilder(
		 * "SELECT COUNT(1) FROM SANBANDEJA t1 , EXPEDIEN t2 , SANINTERV t3 , CENSO_MONITOR t4 "
		 * );
		 */
		try {
			StringBuilder query = new StringBuilder("SELECT COUNT(1) "
					+ " FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,CENSO_MONITOR t4, SANTRAMEXP t5, FASE t6, TRAMITE t7 ");
			// Where clause & Params
			Map<String, ?> mapaWhere = this.getWhereMap(sanbandeja);

			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t5.TRUAIDINTERV = t3.UAIDINTERV(+) AND t1.BAULTINSTR= t4.MOCODIGO(+) AND t1.BATRID = t5.TRID(+) AND t1.BAFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO(+) ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			List<?> params = (List<?>) mapaWhere.get("params");

			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			SanbandejaDaoImpl.LOGGER.error("Error producido en findAllDocumentosHechoComunicacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanbandeja> findAllLike(Sanbandeja sanbandeja, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.BAID BAID,t1.BATRID BATRID,t1.BAFEC BAFEC,t1.BAESTADO BAESTADO,t1.BAFECLIMITE BAFECLIMITE,t1.BAFASE BAFASE,t1.BANOMDOC BANOMDOC,t1.BAFECALTA BAFECALTA,t1.BAFECMODIF BAFECMODIF,t1.BAUSUALTA BAUSUALTA,t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE, "
						+ " t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2, t3.UANIF SANINTERVUANIF,t3.UANRTEL SANINTERVUANRTEL,t3.UANRTEL2 SANINTERVUANRTEL2,t3.UAPROV_ID SANINTERVUAPROVID,t3.UAMUN_ID SANINTERVUAMUNID,t3.UALOC_ID SANINTERVUALOCID,t3.UACALLE_ID SANINTERVUACALLEID,t3.UACP_ID SANINTERVUACPID,t3.UAPORTAL_ID SANINTERVUAPORTALID,t3.UANOMBRE_PISO SANINTERVUANOMBREPISO,t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t3.UADIRE_ANT SANINTERVUADIREANT,t3.UATIPOINTERV SANINTERVUATIPOINTERV,t3.UADTCODIGO SANINTERVUADTCODIGO,t3.UAESCODIGO SANINTERVUAESCODIGO,t3.UATRFECALTA SANINTERVUATRFECALTA,t3.UATRFECMODIF SANINTERVUATRFECMODIF,t3.UATRUSUALTA SANINTERVUATRUSUALTA,t3.UATRUSUMODIF SANINTERVUATRUSUMODIF,t3.UAFECALTA SANINTERVUAFECALTA,t3.UAFECMODIF SANINTERVUAFECMODIF,t3.UAUSUALTA SANINTERVUAUSUALTA,t3.UAUSUMODIF SANINTERVUAUSUMODIF,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE,t4.MOCOOR MONITORMOCOOR,t4.MOCOEM MONITORMOCOEM,t4.MOUSU MONITORMOUSU,t4.MOCLAVE MONITORMOCLAVE,t4.MOFECBAJA MONITORMOFECBAJA,t4.MOADMIN MONITORMOADMIN,t4.MOPRIMERA MONITORMOPRIMERA,t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES,t4.ID_PERFILSANCIONES MONITORIDPERFILSANCIONES,t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES,t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE,t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION,t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS,t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO,t4.USUARIOXLNET MONITORUSUARIOXLNET,t3.UAEXCODIGO SANINTERVUAEXCODIGO ");
		query.append("FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,CENSO_MONITOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanbandeja, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t1.BAUAIDINTERV= t3.UAIDINTERV(+) AND t1.BAULTINSTR= t4.MOCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanbandeja>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanbandeja sanbandeja, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,MONITOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanbandeja, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t1.BAUAIDINTERV= t3.UAIDINTERV(+) AND t1.BAULTINSTR= t4.MOCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanbandeja entity
	 * 
	 * @param sanbandeja
	 *            Sanbandeja Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanbandeja sanbandeja) {

		StringBuilder where = new StringBuilder(SanbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanbandeja != null && sanbandeja.getBaid() != null) {
			where.append(" AND t1.BAID = ?");
			params.add(sanbandeja.getBaid());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sanbandeja.getExpedien().getExcodigo());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoor() != null) {
			where.append(" AND t2.EXCOOR = ?");
			params.add(sanbandeja.getExpedien().getExcoor());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(sanbandeja.getExpedien().getExnran());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(sanbandeja.getExpedien().getExnror());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(sanbandeja.getExpedien().getExfere());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoit() != null) {
			where.append(" AND t2.EXCOIT = ?");
			params.add(sanbandeja.getExpedien().getExcoit());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoes() != null) {
			where.append(" AND t2.EXCOES = ?");
			params.add(sanbandeja.getExpedien().getExcoes());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(sanbandeja.getExpedien().getExfeacin());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(sanbandeja.getExpedien().getExfeemca());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(sanbandeja.getExpedien().getExfeplca());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(sanbandeja.getExpedien().getExfpnopc());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(sanbandeja.getExpedien().getExfede());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(sanbandeja.getExpedien().getExfecoal());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(sanbandeja.getExpedien().getExfenopr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(sanbandeja.getExpedien().getExfepupr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoospr() != null) {
			where.append(" AND t2.EXCOOSPR = ?");
			params.add(sanbandeja.getExpedien().getExcoospr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(sanbandeja.getExpedien().getExfealpr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(sanbandeja.getExpedien().getExfeel());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(sanbandeja.getExpedien().getExferes());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(sanbandeja.getExpedien().getExfenore());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(sanbandeja.getExpedien().getExfepure());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoosre() != null) {
			where.append(" AND t2.EXCOOSRE = ?");
			params.add(sanbandeja.getExpedien().getExcoosre());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcottr() != null) {
			where.append(" AND t2.EXCOTTR = ?");
			params.add(sanbandeja.getExpedien().getExcottr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(sanbandeja.getExpedien().getExcamure());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(sanbandeja.getExpedien().getExfeta());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcotsa() != null) {
			where.append(" AND t2.EXCOTSA = ?");
			params.add(sanbandeja.getExpedien().getExcotsa());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(sanbandeja.getExpedien().getExfecroi());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(sanbandeja.getExpedien().getExfear());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoorie() != null) {
			where.append(" AND t2.EXCOORIE = ?");
			params.add(sanbandeja.getExpedien().getExcoorie());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExinre() != null) {
			where.append(" AND t2.EXINRE = ?");
			params.add(sanbandeja.getExpedien().getExinre());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExincoco() != null) {
			where.append(" AND t2.EXINCOCO = ?");
			params.add(sanbandeja.getExpedien().getExincoco());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExinexva() != null) {
			where.append(" AND t2.EXINEXVA = ?");
			params.add(sanbandeja.getExpedien().getExinexva());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(sanbandeja.getExpedien().getExfecirc());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(sanbandeja.getExpedien().getExfenoai());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(sanbandeja.getExpedien().getExfecolm());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExnuinlm() != null) {
			where.append(" AND t2.EXNUINLM = ?");
			params.add(sanbandeja.getExpedien().getExnuinlm());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(sanbandeja.getExpedien().getExfeinmu());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(sanbandeja.getExpedien().getExfeavmu());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(sanbandeja.getExpedien().getExfeimcd());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(sanbandeja.getExpedien().getExfecede());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcops() != null) {
			where.append(" AND t2.EXCOPS = ?");
			params.add(sanbandeja.getExpedien().getExcops());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcose() != null) {
			where.append(" AND t2.EXCOSE = ?");
			params.add(sanbandeja.getExpedien().getExcose());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getSanexp() != null
				&& sanbandeja.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sanbandeja.getExpedien().getSanexp().getExcodigo());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(sanbandeja.getSaninterv().getUaidinterv());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getExpedien() != null
				&& sanbandeja.getSaninterv().getExpedien().getExcodigo() != null) {
			where.append(" AND t3.UAEXCODIGO = ?");
			params.add(sanbandeja.getSaninterv().getExpedien().getExcodigo());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUanombre() != null) {
			where.append(" AND t3.UANOMBRE = ?");
			params.add(sanbandeja.getSaninterv().getUanombre());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaapellido1() != null) {
			where.append(" AND t3.UAAPELLIDO1 = ?");
			params.add(sanbandeja.getSaninterv().getUaapellido1());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaapellido2() != null) {
			where.append(" AND t3.UAAPELLIDO2 = ?");
			params.add(sanbandeja.getSaninterv().getUaapellido2());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUanif() != null) {
			where.append(" AND t3.UANIF = ?");
			params.add(sanbandeja.getSaninterv().getUanif());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUanrtel() != null) {
			where.append(" AND t3.UANRTEL = ?");
			params.add(sanbandeja.getSaninterv().getUanrtel());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUanrtel2() != null) {
			where.append(" AND t3.UANRTEL2 = ?");
			params.add(sanbandeja.getSaninterv().getUanrtel2());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaprovId() != null) {
			where.append(" AND t3.UAPROV_ID = ?");
			params.add(sanbandeja.getSaninterv().getUaprovId());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUamunId() != null) {
			where.append(" AND t3.UAMUN_ID = ?");
			params.add(sanbandeja.getSaninterv().getUamunId());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUalocId() != null) {
			where.append(" AND t3.UALOC_ID = ?");
			params.add(sanbandeja.getSaninterv().getUalocId());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUacalleId() != null) {
			where.append(" AND t3.UACALLE_ID = ?");
			params.add(sanbandeja.getSaninterv().getUacalleId());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUacpId() != null) {
			where.append(" AND t3.UACP_ID = ?");
			params.add(sanbandeja.getSaninterv().getUacpId());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaportalId() != null) {
			where.append(" AND t3.UAPORTAL_ID = ?");
			params.add(sanbandeja.getSaninterv().getUaportalId());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUanombrePiso() != null) {
			where.append(" AND t3.UANOMBRE_PISO = ?");
			params.add(sanbandeja.getSaninterv().getUanombrePiso());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUadireNocapv() != null) {
			where.append(" AND t3.UADIRE_NOCAPV = ?");
			params.add(sanbandeja.getSaninterv().getUadireNocapv());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUadireAnt() != null) {
			where.append(" AND t3.UADIRE_ANT = ?");
			params.add(sanbandeja.getSaninterv().getUadireAnt());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatipointerv() != null) {
			where.append(" AND t3.UATIPOINTERV = ?");
			params.add(sanbandeja.getSaninterv().getUatipointerv());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUadtcodigo() != null) {
			where.append(" AND t3.UADTCODIGO = ?");
			params.add(sanbandeja.getSaninterv().getUadtcodigo());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaescodigo() != null) {
			where.append(" AND t3.UAESCODIGO = ?");
			params.add(sanbandeja.getSaninterv().getUaescodigo());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(sanbandeja.getSaninterv().getUatrfecalta());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(sanbandeja.getSaninterv().getUatrfecmodif());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrusualta() != null) {
			where.append(" AND t3.UATRUSUALTA = ?");
			params.add(sanbandeja.getSaninterv().getUatrusualta());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrusumodif() != null) {
			where.append(" AND t3.UATRUSUMODIF = ?");
			params.add(sanbandeja.getSaninterv().getUatrusumodif());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(sanbandeja.getSaninterv().getUafecalta());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(sanbandeja.getSaninterv().getUafecmodif());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUausualta() != null) {
			where.append(" AND t3.UAUSUALTA = ?");
			params.add(sanbandeja.getSaninterv().getUausualta());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUausumodif() != null) {
			where.append(" AND t3.UAUSUMODIF = ?");
			params.add(sanbandeja.getSaninterv().getUausumodif());
		}
		if (sanbandeja != null && sanbandeja.getMonitor() != null && sanbandeja.getMonitor().getMocodigo() != null) {
			where.append(" AND t4.MOCODIGO = ?");
			params.add(sanbandeja.getMonitor().getMocodigo());
		}
		if (sanbandeja != null && sanbandeja.getBatrid() != null) {
			where.append(" AND t1.BATRID = ?");
			params.add(sanbandeja.getBatrid());
		}
		if (sanbandeja != null && sanbandeja.getBafec() != null) {
			where.append(" AND t1.BAFEC = ?");
			params.add(sanbandeja.getBafec());
		}
		if (sanbandeja != null && sanbandeja.getBaestado() != null) {
			where.append(" AND t1.BAESTADO = ?");
			params.add(sanbandeja.getBaestado());
		}
		if (sanbandeja != null && sanbandeja.getBafeclimite() != null) {
			where.append(" AND t1.BAFECLIMITE = ?");
			params.add(sanbandeja.getBafeclimite());
		}
		if (sanbandeja != null && sanbandeja.getBafase() != null) {
			where.append(" AND t1.BAFASE = ?");
			params.add(sanbandeja.getBafase());
		}
		if (sanbandeja != null && sanbandeja.getBanomdoc() != null) {
			where.append(" AND t1.BANOMDOC = ?");
			params.add(sanbandeja.getBanomdoc());
		}
		if (sanbandeja != null && sanbandeja.getBafecalta() != null) {
			where.append(" AND t1.BAFECALTA = ?");
			params.add(sanbandeja.getBafecalta());
		}
		if (sanbandeja != null && sanbandeja.getBafecmodif() != null) {
			where.append(" AND t1.BAFECMODIF = ?");
			params.add(sanbandeja.getBafecmodif());
		}
		if (sanbandeja != null && sanbandeja.getBausualta() != null) {
			where.append(" AND t1.BAUSUALTA = ?");
			params.add(sanbandeja.getBausualta());
		}
		if (sanbandeja != null && sanbandeja.getBausumodif() != null) {
			where.append(" AND t1.BAUSUMODIF = ?");
			params.add(sanbandeja.getBausumodif());
		}
		if (sanbandeja != null && sanbandeja.getBatipo() != null) {
			where.append(" AND t1.BATIPO = ?");
			params.add(sanbandeja.getBatipo());
		}
		if (sanbandeja != null && sanbandeja.getBafecini() != null) {
			where.append(" AND t1.BAFECINI = ?");
			params.add(sanbandeja.getBafecini());
		}
		if (sanbandeja != null && sanbandeja.getBatexto() != null) {
			where.append(" AND t1.BATEXTO = ?");
			params.add(sanbandeja.getBatexto());
		}
		if (sanbandeja != null && sanbandeja.getBatextoe() != null) {
			where.append(" AND t1.BATEXTOE = ?");
			params.add(sanbandeja.getBatextoe());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanbandeja entity
	 * 
	 * @param sanbandeja
	 *            Sanbandeja Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanbandeja sanbandeja, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SanbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanbandeja != null && sanbandeja.getBaid() != null) {
			where.append(" AND UPPER(t1.BAID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBaid().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBaid().toUpperCase() + "%");
			}
			where.append(" AND t1.BAID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(sanbandeja.getExpedien().getExcodigo());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcoor().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(sanbandeja.getExpedien().getExnran());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(sanbandeja.getExpedien().getExnror());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(sanbandeja.getExpedien().getExfere());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcoit().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcoit().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcoes().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcoes().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(sanbandeja.getExpedien().getExfeacin());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(sanbandeja.getExpedien().getExfeemca());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(sanbandeja.getExpedien().getExfeplca());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(sanbandeja.getExpedien().getExfpnopc());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(sanbandeja.getExpedien().getExfede());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(sanbandeja.getExpedien().getExfecoal());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(sanbandeja.getExpedien().getExfenopr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(sanbandeja.getExpedien().getExfepupr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcoospr().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcoospr().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(sanbandeja.getExpedien().getExfealpr());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(sanbandeja.getExpedien().getExfeel());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(sanbandeja.getExpedien().getExferes());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(sanbandeja.getExpedien().getExfenore());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(sanbandeja.getExpedien().getExfepure());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcoosre().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcoosre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcottr().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcottr().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(sanbandeja.getExpedien().getExcamure());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(sanbandeja.getExpedien().getExfeta());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcotsa().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcotsa().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(sanbandeja.getExpedien().getExfecroi());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(sanbandeja.getExpedien().getExfear());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcoorie().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcoorie().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExinre().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExinre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExincoco().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExincoco().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExinexva().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExinexva().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(sanbandeja.getExpedien().getExfecirc());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(sanbandeja.getExpedien().getExfenoai());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(sanbandeja.getExpedien().getExfecolm());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExnuinlm().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExnuinlm().toUpperCase() + "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(sanbandeja.getExpedien().getExfeinmu());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(sanbandeja.getExpedien().getExfeavmu());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(sanbandeja.getExpedien().getExfeimcd());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(sanbandeja.getExpedien().getExfecede());
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcops().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcops().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getExcose().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getExcose().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getExpedien() != null && sanbandeja.getExpedien().getSanexp() != null
				&& sanbandeja.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t2.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getExpedien().getSanexp().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getExpedien().getSanexp().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCODIGO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(sanbandeja.getSaninterv().getUaidinterv());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getExpedien() != null
				&& sanbandeja.getSaninterv().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t3.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getExpedien().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getExpedien().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.UAEXCODIGO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUanombre() != null) {
			where.append(" AND UPPER(t3.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUanombre().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUanombre().toUpperCase() + "%");
			}
			where.append(" AND t3.UANOMBRE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaapellido1() != null) {
			where.append(" AND UPPER(t3.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUaapellido1().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUaapellido1().toUpperCase() + "%");
			}
			where.append(" AND t3.UAAPELLIDO1 IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaapellido2() != null) {
			where.append(" AND UPPER(t3.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUaapellido2().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUaapellido2().toUpperCase() + "%");
			}
			where.append(" AND t3.UAAPELLIDO2 IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUanif() != null) {
			where.append(" AND UPPER(t3.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t3.UANIF IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUanrtel() != null) {
			where.append(" AND UPPER(t3.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUanrtel().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUanrtel().toUpperCase() + "%");
			}
			where.append(" AND t3.UANRTEL IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUanrtel2() != null) {
			where.append(" AND UPPER(t3.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUanrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUanrtel2().toUpperCase() + "%");
			}
			where.append(" AND t3.UANRTEL2 IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaprovId() != null) {
			where.append(" AND UPPER(t3.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUaprovId().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUaprovId().toUpperCase() + "%");
			}
			where.append(" AND t3.UAPROV_ID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUamunId() != null) {
			where.append(" AND UPPER(t3.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUamunId().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUamunId().toUpperCase() + "%");
			}
			where.append(" AND t3.UAMUN_ID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUalocId() != null) {
			where.append(" AND UPPER(t3.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUalocId().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUalocId().toUpperCase() + "%");
			}
			where.append(" AND t3.UALOC_ID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUacalleId() != null) {
			where.append(" AND UPPER(t3.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUacalleId().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUacalleId().toUpperCase() + "%");
			}
			where.append(" AND t3.UACALLE_ID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null && sanbandeja.getSaninterv().getUacpId() != null) {
			where.append(" AND UPPER(t3.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUacpId().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUacpId().toUpperCase() + "%");
			}
			where.append(" AND t3.UACP_ID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaportalId() != null) {
			where.append(" AND UPPER(t3.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUaportalId().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUaportalId().toUpperCase() + "%");
			}
			where.append(" AND t3.UAPORTAL_ID IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUanombrePiso() != null) {
			where.append(" AND UPPER(t3.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUanombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUanombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t3.UANOMBRE_PISO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUadireNocapv() != null) {
			where.append(" AND UPPER(t3.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUadireNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUadireNocapv().toUpperCase() + "%");
			}
			where.append(" AND t3.UADIRE_NOCAPV IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUadireAnt() != null) {
			where.append(" AND UPPER(t3.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUadireAnt().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUadireAnt().toUpperCase() + "%");
			}
			where.append(" AND t3.UADIRE_ANT IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatipointerv() != null) {
			where.append(" AND UPPER(t3.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUatipointerv().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUatipointerv().toUpperCase() + "%");
			}
			where.append(" AND t3.UATIPOINTERV IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUadtcodigo() != null) {
			where.append(" AND UPPER(t3.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUadtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUadtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.UADTCODIGO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUaescodigo() != null) {
			where.append(" AND UPPER(t3.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUaescodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUaescodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.UAESCODIGO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(sanbandeja.getSaninterv().getUatrfecalta());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(sanbandeja.getSaninterv().getUatrfecmodif());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrusualta() != null) {
			where.append(" AND UPPER(t3.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUatrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUatrusualta().toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUALTA IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUatrusumodif() != null) {
			where.append(" AND UPPER(t3.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUatrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUatrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUMODIF IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(sanbandeja.getSaninterv().getUafecalta());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(sanbandeja.getSaninterv().getUafecmodif());
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUausualta() != null) {
			where.append(" AND UPPER(t3.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUausualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUausualta().toUpperCase() + "%");
			}
			where.append(" AND t3.UAUSUALTA IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getSaninterv() != null
				&& sanbandeja.getSaninterv().getUausumodif() != null) {
			where.append(" AND UPPER(t3.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getSaninterv().getUausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getSaninterv().getUausumodif().toUpperCase() + "%");
			}
			where.append(" AND t3.UAUSUMODIF IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getMonitor() != null && sanbandeja.getMonitor().getMocodigo() != null) {
			where.append(" AND t4.MOCODIGO = ?");
			params.add(sanbandeja.getMonitor().getMocodigo());
		}
		if (sanbandeja != null && sanbandeja.getMonitor() != null && sanbandeja.getMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t4.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getMonitor().getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getMonitor().getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t4.MONOMBRE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBatrid() != null) {
			where.append(" AND t1.BATRID = ?");
			params.add(sanbandeja.getBatrid());
		}
		if (sanbandeja != null && sanbandeja.getBafec() != null) {
			where.append(" AND t1.BAFEC = ?");
			params.add(sanbandeja.getBafec());
		}
		if (sanbandeja != null && sanbandeja.getBaestado() != null) {
			where.append(" AND UPPER(t1.BAESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBaestado().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBaestado().toUpperCase() + "%");
			}
			where.append(" AND t1.BAESTADO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBafeclimite() != null) {
			where.append(" AND t1.BAFECLIMITE = ?");
			params.add(sanbandeja.getBafeclimite());
		}
		if (sanbandeja != null && sanbandeja.getBafase() != null) {
			where.append(" AND UPPER(t1.BAFASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBafase().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBafase().toUpperCase() + "%");
			}
			where.append(" AND t1.BAFASE IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBanomdoc() != null) {
			where.append(" AND UPPER(t1.BANOMDOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBanomdoc().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBanomdoc().toUpperCase() + "%");
			}
			where.append(" AND t1.BANOMDOC IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBafecalta() != null) {
			where.append(" AND t1.BAFECALTA = ?");
			params.add(sanbandeja.getBafecalta());
		}
		if (sanbandeja != null && sanbandeja.getBafecmodif() != null) {
			where.append(" AND t1.BAFECMODIF = ?");
			params.add(sanbandeja.getBafecmodif());
		}
		if (sanbandeja != null && sanbandeja.getBausualta() != null) {
			where.append(" AND UPPER(t1.BAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBausualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.BAUSUALTA IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBausumodif() != null) {
			where.append(" AND UPPER(t1.BAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.BAUSUMODIF IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBatipo() != null) {
			where.append(" AND t1.BATIPO = ?");
			params.add(sanbandeja.getBatipo());
		}
		if (sanbandeja != null && sanbandeja.getBafecini() != null) {
			where.append(" AND t1.BAFECINI = ?");
			params.add(sanbandeja.getBafecini());
		}
		if (sanbandeja != null && sanbandeja.getBatexto() != null) {
			where.append(" AND UPPER(t1.BATEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBatexto().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBatexto().toUpperCase() + "%");
			}
			where.append(" AND t1.BATEXTO IS NOT NULL");
		}
		if (sanbandeja != null && sanbandeja.getBatextoe() != null) {
			where.append(" AND UPPER(t1.BATEXTOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanbandeja.getBatextoe().toUpperCase() + "%");
			} else {
				params.add("%" + sanbandeja.getBatextoe().toUpperCase() + "%");
			}
			where.append(" AND t1.BATEXTOE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue() {
		String query = "SELECT L21U3Q00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		return this.jdbcTemplate.queryForInt(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public List<Sanbandeja> dameBandeja(Sanbandeja sanbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		StringBuilder queryNueva = new StringBuilder("");
		StringBuilder query1 = new StringBuilder(
				"SELECT  t1.BAID BAID,t1.BATRID BATRID,t1.BAFEC BAFEC,t1.BAESTADO BAESTADO,(SELECT MIN(X.BAFECLIMITE) FROM SANBANDEJA X WHERE X.BAEXCODIGO=T1.BAEXCODIGO) BAFECLIMITE,t1.BAFASE BAFASE,t1.BANOMDOC BANOMDOC,t1.BAFECALTA BAFECALTA,t1.BAFECMODIF BAFECMODIF,t1.BAUSUALTA BAUSUALTA,t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE "
						+ " ,t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR, LPAD(T2.EXNROR,12,'0') CORRELATIVOPAD, t2.EXCOOR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t2.EXNRAN CODCOMPLETO, t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT "
						+ " ,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2"
						+ " ,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE "
						+ ",T5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES, t5.TRCODIGO SANTRAMEXPTRCODIGO, t5.TRFECHAENVIOBOPVBOE SANTRAMEXPTRFECHAENVIOBOPVBOE, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE, t5.TRFECINI TRFECINI,"
						+ " (SELECT MAX(SGFECHALIMITEPAGO) FROM PAGOS WHERE SGIDESTADOPAGO = 'PP' AND ROWNUM <= 1 AND SGIDEXPEDIENTE = t2.EXCODIGO ) BAFECLIMITELIQUIDACION, "
						+ " t5.TRFECFIN TRFECFIN, (SELECT count(t12.TRID) FROM SANTRAMEXP t12 WHERE t12.TREXCODIGO=T1.BAEXCODIGO AND t12.TRESTADO!='T') TRAMITESPENDIENTES, "
						+ " (SELECT count(t13.BAID) FROM SANBANDEJA t13 WHERE t13.BAEXCODIGO=T1.BAEXCODIGO AND BATIPO IS NOT NULL AND ((SYSDATE > BAFECINI AND BAFECLIMITE IS NOT NULL AND BAFECINI <= BAFECLIMITE))) AVISOS "
						+ ",t5.TRRESOTIPO, t5.TRESTADOACUSE, t9.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t9.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU "
						+ ",t5.TRISTELEMATICA TRISTELEMATICA ");
		query1.append(
				"FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,CENSO_MONITOR t4, SANTRAMEXP t5, FASE t6, TRAMITE t7, SANEXP t8, ENVIOS_POR_REMESA t9 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND T2.EXCODIGO = T3.UAEXCODIGO AND t2.EXCOES = t3.UAESCODIGO AND t3.UATIPOINTERV='E' AND t1.BAULTINSTR= t4.MOCODIGO(+) AND t1.BATRID = t5.TRID(+) AND t1.BAFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO(+) AND BATIPO IS NULL AND T2.EXCODIGO = T8.EXCODIGO(+)  AND to_char(t5.TRTRIDREL) = t9.EHCODIGO(+)  ");
		// ultimo tramite pendiente o tramitado
		where.append(
				" AND T1.BATRID=(SELECT MIN(T14.BATRID) FROM SANBANDEJA T14 WHERE T14.BAEXCODIGO = T1.BAEXCODIGO AND T14.BAFEC = ( SELECT MIN(T11.BAFEC) FROM SANBANDEJA T11 WHERE T11.BAEXCODIGO=T14.BAEXCODIGO AND T11.BATIPO IS NULL ) ) ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder wherePerfil = new StringBuilder("");

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(
					" AND (EXISTS (SELECT 1 FROM SANTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.BAEXCODIGO AND AUX.TRESTADO NOT IN ('"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND AUX.TRCODIGO=?");
			params.add(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA);
			where.append(") OR ( 1=1 ");
		}
		if (censoMonitor.getMoadmiliquidacion() != null
				&& censoMonitor.getMoadmiliquidacion().equals(Y41bConstantes.SI)) {
			where.append(
					" AND (EXISTS(SELECT 1 FROM SANTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.BAEXCODIGO AND AUX.TRESTADO NOT IN ('"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND AUX.TRCODIGO IN ('"
							+ Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION + "', '"
							+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA + "')");
			where.append(") OR ( 1=1 ");
		}

		if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) {
			/* ve todo */
			wherePerfil.append(" AND 1 = 1 ");
		} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
			wherePerfil.append(" AND (T1.BAULTINSTR =? OR t8.EXMOCODIGO = ?) AND T8.EXCOORACTUAL = ? ");
			params.add(sanbandeja.getMonitor().getMocodigo());
			params.add(sanbandeja.getMonitor().getMocodigo());
			params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
			wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
			params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
			// EL ADMINISTRATIVO EN SU BANDEJA VE LAS NOTIFICACIONES
			// COMUNICACIONES Y ACUSES QUE ESTEN PENDIENTES DE TRAMITAR DE SU
			// OFICINA
			wherePerfil
					.append(" AND EXISTS(SELECT 1 FROM SANTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.BAEXCODIGO AND AUX.TRESTADO <> '"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "' AND (AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO + "' )) ");
			wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
			params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else if (Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else {
			wherePerfil.append(" AND T1.BAULTINSTR = ? ");
			params.add(sanbandeja.getMonitor().getMocodigo());
		}

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			wherePerfil.append(" )) ");
		}
		if (censoMonitor.getMoadmiliquidacion() != null
				&& censoMonitor.getMoadmiliquidacion().equals(Y41bConstantes.SI)) {
			wherePerfil.append(" )) ");
		}

		// EVOLUTIVO 0135083 2.10
		if (sanbandeja.getTrFechaDesde() != null) {
			wherePerfil.append(" AND t1.BAFEC >= ?");
			params.add(sanbandeja.getTrFechaDesde());
		}
		if (sanbandeja.getTrFechaHasta() != null) {

			wherePerfil.append(" AND t1.BAFEC <= ?");
			params.add(sanbandeja.getTrFechaHasta());
		}
		if (sanbandeja.getTrcodigo() != null) {

			wherePerfil.append(
					"AND EXISTS ( SELECT 1 FROM SANBANDEJA t15, SANTRAMEXP t16 WHERE t15.BAEXCODIGO = t1.BAEXCODIGO AND t15.BATRID = t16.TRID(+) AND t15.BATIPO IS NULL AND t16.TRCODIGO = ? AND t15.BAESTADO <> ?)");
			params.add(sanbandeja.getTrcodigo());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		}
		if (sanbandeja.getMocodigo() != null) {
			wherePerfil.append(" AND t4.MOCODIGO = ? ");
			params.add(sanbandeja.getMocodigo());
		}
		if (sanbandeja.getCodOrg() != null) {
			wherePerfil.append(" AND t8.EXCOORACTUAL = ? ");
			params.add(sanbandeja.getCodOrg());
		}
		// EVOLUTIVO 0135083 2.10
		// EVOLUTIVO 0150942
		if (sanbandeja.getPcodigo() != null) {
			if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(sanbandeja.getPcodigo())) {
				wherePerfil.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1 WHERE AUX1.RLARBCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
			} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(sanbandeja.getPcodigo())) {
				wherePerfil.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, HECHO_DENUNCIADO AUX2 WHERE AUX1.RLHDCODREL IS NOT NULL AND AUX1.RLHDCODREL=AUX2.HDCODIGO AND AUX1.RLESORIG='S' AND AUX2.HDTIPODENUNCIANTE IS NULL AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
			} else if (sanbandeja.getPcodigo().equals("DEN")) {
				wherePerfil.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, HECHO_DENUNCIADO AUX2 WHERE AUX1.RLHDCODREL IS NOT NULL AND AUX1.RLHDCODREL=AUX2.HDCODIGO AND AUX1.RLESORIG='S' AND AUX2.HDTIPODENUNCIANTE IS NOT NULL AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(sanbandeja.getPcodigo())) {
				if (sanbandeja.getAccoororigen() != null) {
					wherePerfil.append(
							" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, ACTA AUX6, ACTUACION AUX7 WHERE AUX1.RLINSCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t2.EXCODIGO AND AUX7.ATCODIGO=AUX1.RLINSCODREL AND AUX6.ACCODIGO=AUX7.ATCOAC ");

					if ("1".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOCM IS NOT NULL ");
						if (sanbandeja.getAtcocm() != null) {
							wherePerfil
									.append(" AND TRANSLATE(UPPER(AUX7.ATCOCM),'','AEIOU') like ? ESCAPE  '\\' ");
							params.add(
									"%" + sanbandeja.getAtcocm().toUpperCase().replaceAll("", "A").replaceAll("", "E")
											.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
						}
						wherePerfil.append(") ");
					} else if ("2".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOAL IS NOT NULL) ");
					} else if ("3".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATIDCOMUNICACIONSOIVRE IS NOT NULL) ");
					} else if ("4".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOHD IS NOT NULL AND AUX7.ATCOHDDENUNCIA IS NULL) ");
					} else if ("5".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOHD IS NOT NULL AND AUX7.ATCOHDDENUNCIA IS NOT NULL) ");
					} else if ("6".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(
								" AND AUX7.ATCOCM IS NULL AND AUX7.ATCOAL IS NULL AND AUX7.ATIDCOMUNICACIONSOIVRE IS NULL AND AUX7.ATCOHD IS NULL AND AUX6.ACTIORORIGEN IS NULL) ");
					} else if ("7".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX6.ACTIORORIGEN = ?) ");
						params.add(Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA);
					} else if ("8".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX6.ACTIORORIGEN = ?) ");
						params.add(Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES);
					}
				} else {
					wherePerfil.append(
							" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1 WHERE AUX1.RLINSCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
				}
			}
		}
		// EVOLUTIVO 0150942
		where.append(wherePerfil);
		query1.append(where);

		/*
		 * Comentado por 86469: [Evolutivo Bandejas ] - Bandeja Sancionador
		 * //sacamos los avisos que estan apunto de terminar tambien
		 * StringBuilder queryAvisos = new StringBuilder(
		 * "SELECT  t1.BAID BAID,t1.BATRID BATRID,t1.BAFEC BAFEC,t1.BAESTADO BAESTADO,t1.BAFECLIMITE BAFECLIMITE,t1.BAFASE BAFASE,t1.BANOMDOC BANOMDOC,t1.BAFECALTA BAFECALTA,t1.BAFECMODIF BAFECMODIF,t1.BAUSUALTA BAUSUALTA,t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE "
		 * +
		 * " ,t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,LPAD(T2.EXNROR,12,'0') CORRELATIVOPAD, t2.EXCOOR || '"
		 * + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.EXNROR || '" +
		 * Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP +
		 * "' || t2.EXNRAN CODCOMPLETO, t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE "
		 * +
		 * " ,0 SANINTERVUAIDINTERV,'' SANINTERVUANOMBRE,'' SANINTERVUAAPELLIDO1,'' SANINTERVUAAPELLIDO2"
		 * + " ,'' MONITORMOCODIGO,'' MONITORMONOMBRE " +
		 * ", '' SANTRAMEXPTRNOMTRAMES, '' SANTRAMEXPTRCODIGO, null SANTRAMEXPTRFECHAENVIOBOPVBOE, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
		 * + " '' TRNOMBRE, '' TRNOMBREE " +
		 * " FROM SANBANDEJA T1 , EXPEDIEN T2, SANEXP T3, FASE t6 " +
		 * " WHERE 1=1 AND T1.BAEXCODIGO= T2.EXCODIGO(+) AND T3.EXCODIGO = T2.EXCODIGO AND ((SYSDATE > BAFECINI AND BAFECLIMITE IS NOT NULL AND BAFECINI <= BAFECLIMITE)) AND BATIPO IS NOT NULL "
		 * + " AND T3.EXFCODIGO = t6.FCODIGO ");
		 * 
		 * StringBuilder wherePerfilAvisos = new StringBuilder(""); if
		 * (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) { //Ve todo
		 * wherePerfilAvisos.append(" AND 1 = 1 "); } else if
		 * (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) { wherePerfilAvisos
		 * .append(
		 * " AND (T1.BAULTINSTR =? OR T3.EXMOCODIGO = ?) AND T3.EXCOORACTUAL = ? "
		 * ); params.add(sanbandeja.getMonitor().getMocodigo());
		 * params.add(sanbandeja.getMonitor().getMocodigo());
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
		 * wherePerfilAvisos.append(" AND T3.EXCOORACTUAL = ? ");
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else { //el resto no ven avisos
		 * wherePerfilAvisos.append(" AND 1 = 0 "); }
		 * 
		 * queryAvisos.append(wherePerfilAvisos);
		 * 
		 * queryNueva.append(query1); queryNueva.append(" UNION ");
		 * queryNueva.append(queryAvisos);
		 */
		queryNueva.append(query1);

		if (pagination != null && pagination.getSort() != null) {
			queryNueva = pagination.getPaginationQuery(queryNueva);
		}

		return (List<Sanbandeja>) this.jdbcTemplate.query(queryNueva.toString(), this.rwMapBandejaSancionesExtras,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaCount(Sanbandeja sanbandeja, CensoMonitor censoMonitor, String perfil) {

		StringBuilder query1 = new StringBuilder("SELECT COUNT (BAID) ");
		query1.append("FROM SANBANDEJA t1 , EXPEDIEN t2, SANINTERV t3 , SANTRAMEXP t5,  SANEXP t8, CENSO_MONITOR t4  ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BATRID = t5.TRID(+) AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t2.EXCODIGO = t3.UAEXCODIGO AND t2.EXCOES = t3.UAESCODIGO AND t3.UATIPOINTERV='E'  AND BATIPO IS NULL AND T1.BAEXCODIGO = T8.EXCODIGO(+) AND  t8.EXMOCODIGO= t4.MOCODIGO(+)  ");
		// ultimo tramite pendiente o tramitado
		where.append(
				" AND T1.BATRID=(SELECT MIN(T14.BATRID) FROM SANBANDEJA T14 WHERE T14.BAEXCODIGO = T1.BAEXCODIGO AND T14.BAFEC = ( SELECT MIN(T11.BAFEC) FROM SANBANDEJA T11 WHERE T11.BAEXCODIGO=T14.BAEXCODIGO AND T11.BATIPO IS NULL ) ) ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder wherePerfil = new StringBuilder("");

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(
					" AND (EXISTS (SELECT 1 FROM SANTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.BAEXCODIGO AND AUX.TRESTADO NOT IN ('"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND AUX.TRCODIGO=?");
			params.add(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA);
			where.append(") OR ( 1=1 ");
		}
		if (censoMonitor.getMoadmiliquidacion() != null
				&& censoMonitor.getMoadmiliquidacion().equals(Y41bConstantes.SI)) {
			where.append(
					" AND (EXISTS(SELECT 1 FROM SANTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.BAEXCODIGO AND AUX.TRESTADO NOT IN ('"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND AUX.TRCODIGO IN ('"
							+ Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION + "', '"
							+ Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA + "')");
			where.append(") OR ( 1=1 ");
		}
		if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) {
			/* ve todo */
			wherePerfil.append(" AND 1 = 1");
		} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
			wherePerfil.append(" AND (T1.BAULTINSTR = ? OR T8.EXMOCODIGO = ?)  AND T8.EXCOORACTUAL = ?");
			params.add(sanbandeja.getMonitor().getMocodigo());
			params.add(sanbandeja.getMonitor().getMocodigo());
			params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
			wherePerfil.append(" AND T8.EXCOORACTUAL = ?");
			params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
			// EL ADMINISTRATIVO EN SU BANDEJA VE LAS NOTIFICACIONES
			// COMUNICACIONES Y ACUSES QUE ESTEN PENDIENTES DE TRAMITAR DE SU
			// OFICINA
			wherePerfil
					.append(" AND EXISTS(SELECT 1 FROM SANTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.BAEXCODIGO AND AUX.TRESTADO <> '"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "' AND (AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO + "' )) ");
			wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
			params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else if (Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else {
			wherePerfil.append(" AND T1.BAULTINSTR = ?");
			params.add(sanbandeja.getMonitor().getMocodigo());
		}

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			wherePerfil.append(" )) ");
		}
		if (censoMonitor.getMoadmiliquidacion() != null
				&& censoMonitor.getMoadmiliquidacion().equals(Y41bConstantes.SI)) {
			wherePerfil.append(" )) ");
		}

		// EVOLUTIVO 0135083 2.10
		if (sanbandeja.getTrFechaDesde() != null) {
			// wherePerfil
			// .append(" AND ")
			// .append("T1.BAFEC>= to_date ('")
			// .append(Y41bUtils.parseDateToString(
			// sanbandeja.getTrFechaDesde(),
			// Y41bConstantes.EUSKERA)).append("', 'YYYY/MM/DD')");
			wherePerfil.append(" AND t1.BAFEC >= ?");
			params.add(sanbandeja.getTrFechaDesde());
		}
		if (sanbandeja.getTrFechaHasta() != null) {
			// wherePerfil
			// .append(" AND ")
			// .append("T1.BAFEC<= to_date ('")
			// .append(Y41bUtils.parseDateToString(
			// sanbandeja.getTrFechaHasta(),
			// Y41bConstantes.EUSKERA)).append("', 'YYYY/MM/DD')");
			wherePerfil.append(" AND t1.BAFEC <= ?");
			params.add(sanbandeja.getTrFechaHasta());
		}
		if (sanbandeja.getTrcodigo() != null) {
			// wherePerfil
			// .append(" AND (")
			// .append("T5.TRCODIGO='")
			// .append(sanbandeja.getTrcodigo())
			// .append("' AND")
			// .append(" T1.BAESTADO = '"
			// + Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION
			// + "' )");
			wherePerfil.append(
					"AND EXISTS ( SELECT 1 FROM SANBANDEJA t15, SANTRAMEXP t16 WHERE t15.BAEXCODIGO = t1.BAEXCODIGO AND t15.BATRID = t16.TRID(+) AND t15.BATIPO IS NULL AND t16.TRCODIGO = ? AND t15.BAESTADO <> ?)");
			params.add(sanbandeja.getTrcodigo());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		}
		if (sanbandeja.getMocodigo() != null) {
			wherePerfil.append(" AND t4.MOCODIGO = ? ");
			params.add(sanbandeja.getMocodigo());
		}
		if (sanbandeja.getCodOrg() != null) {
			wherePerfil.append(" AND t8.EXCOORACTUAL = ? ");
			params.add(sanbandeja.getCodOrg());
		}
		// EVOLUTIVO 0135083 2.10
		// EVOLUTIVO 0150942
		if (sanbandeja.getPcodigo() != null) {
			if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(sanbandeja.getPcodigo())) {
				wherePerfil.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1 WHERE AUX1.RLARBCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
			} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(sanbandeja.getPcodigo())) {
				wherePerfil.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, HECHO_DENUNCIADO AUX2 WHERE AUX1.RLHDCODREL IS NOT NULL AND AUX1.RLHDCODREL=AUX2.HDCODIGO AND AUX1.RLESORIG='S' AND AUX2.HDTIPODENUNCIANTE IS NULL AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
			} else if (sanbandeja.getPcodigo().equals("DEN")) {
				wherePerfil.append(
						" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, HECHO_DENUNCIADO AUX2 WHERE AUX1.RLHDCODREL IS NOT NULL AND AUX1.RLHDCODREL=AUX2.HDCODIGO AND AUX1.RLESORIG='S' AND AUX2.HDTIPODENUNCIANTE IS NOT NULL AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(sanbandeja.getPcodigo())) {
				if (sanbandeja.getAccoororigen() != null) {
					wherePerfil.append(
							" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1, ACTA AUX6, ACTUACION AUX7 WHERE AUX1.RLINSCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t2.EXCODIGO AND AUX7.ATCODIGO=AUX1.RLINSCODREL AND AUX6.ACCODIGO=AUX7.ATCOAC ");

					if ("1".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOCM IS NOT NULL ");
						if (sanbandeja.getAtcocm() != null) {
							wherePerfil
									.append(" AND TRANSLATE(UPPER(AUX7.ATCOCM),'','AEIOU') like ? ESCAPE  '\\' ");
							params.add(
									"%" + sanbandeja.getAtcocm().toUpperCase().replaceAll("", "A").replaceAll("", "E")
											.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
						}
						wherePerfil.append(") ");
					} else if ("2".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOAL IS NOT NULL) ");
					} else if ("3".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATIDCOMUNICACIONSOIVRE IS NOT NULL) ");
					} else if ("4".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOHD IS NOT NULL AND AUX7.ATCOHDDENUNCIA IS NULL) ");
					} else if ("5".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX7.ATCOHD IS NOT NULL AND AUX7.ATCOHDDENUNCIA IS NOT NULL) ");
					} else if ("6".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(
								" AND AUX7.ATCOCM IS NULL AND AUX7.ATCOAL IS NULL AND AUX7.ATIDCOMUNICACIONSOIVRE IS NULL AND AUX7.ATCOHD IS NULL AND AUX6.ACTIORORIGEN IS NULL) ");
					} else if ("7".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX6.ACTIORORIGEN = ?) ");
						params.add(Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA);
					} else if ("8".equals(sanbandeja.getAccoororigen())) {
						wherePerfil.append(" AND AUX6.ACTIORORIGEN = ?) ");
						params.add(Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES);
					}
				} else {
					wherePerfil.append(
							" AND EXISTS (SELECT 1 FROM SANEXPREL AUX1 WHERE AUX1.RLINSCODREL IS NOT NULL AND AUX1.RLESORIG='S' AND AUX1.RLEXCODIGO=t2.EXCODIGO) ");
				}
			}
		}
		// EVOLUTIVO 0150942

		where.append(wherePerfil);
		query1.append(where);

		Long numeroRegistros1 = this.jdbcTemplate.queryForLong(query1.toString(), params.toArray());

		/*
		 * Comentado por 86469: [Evolutivo Bandejas ] - Bandeja Sancionador
		 * //sacamos los avisos que estan apunto de terminar tambien
		 * StringBuilder queryAvisos = new StringBuilder( "SELECT COUNT (BAID)"
		 * + " FROM SANBANDEJA T1 , EXPEDIEN T2, SANEXP T3, FASE t6 " +
		 * " WHERE 1=1 AND T1.BAEXCODIGO= T2.EXCODIGO(+) AND T3.EXCODIGO = T2.EXCODIGO AND ((SYSDATE > BAFECINI AND BAFECLIMITE IS NOT NULL AND BAFECINI <= BAFECLIMITE)) AND BATIPO IS NOT NULL "
		 * + " AND T3.EXFCODIGO = t6.FCODIGO ");
		 * 
		 * StringBuilder wherePerfilAvisos = new StringBuilder(""); List<Object>
		 * params2 = new ArrayList<Object>();
		 * 
		 * if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) { //ve todo
		 * wherePerfilAvisos.append(" AND 1 = 1 "); } else if
		 * (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) { wherePerfilAvisos
		 * .append(
		 * " AND (T1.BAULTINSTR =? OR T3.EXMOCODIGO = ?) AND T3.EXCOORACTUAL = ? "
		 * ); params2.add(sanbandeja.getMonitor().getMocodigo());
		 * params2.add(sanbandeja.getMonitor().getMocodigo());
		 * params2.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
		 * wherePerfilAvisos.append(" AND T3.EXCOORACTUAL = ? ");
		 * params2.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else { wherePerfilAvisos.append(" AND 1 = 0 "); }
		 * 
		 * queryAvisos.append(wherePerfilAvisos);
		 * 
		 * Long numeroRegistros2 = this.jdbcTemplate.queryForLong(
		 * queryAvisos.toString(), params2.toArray());
		 * 
		 * return numeroRegistros1 + numeroRegistros2;
		 */
		return numeroRegistros1;
	}

	/**
	 * Aniade aviso bandeja apertura expediente.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	// public void aniadeAvisoBandejaMeses(Expedien expedien,
	// CensoMonitor censoMonitor, Long numeroMeses, String textoc,
	// String textoe, BigDecimal idTramite, Date fechaDesde, String batipo) {
	//
	// logger.info("SanbandejaDaoImpl - aniadeAvisoBandejaMeses - Inicio "
	// + batipo);
	//
	// Sanbandeja sanbandeja = new Sanbandeja();
	// sanbandeja.setExpedien(expedien);
	// /* conseguimos el letrado del expediente */
	// sanbandeja.setMonitor(censoMonitor);
	// sanbandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
	// /* Fecha de hoy */
	//
	// sanbandeja.setBafecini(fechaDesde);
	// sanbandeja.setBatexto(textoc);
	// sanbandeja.setBatextoe(textoe);
	// sanbandeja.setBatrid(idTramite);
	// Date fechaLimite = Y41bUtils.addMonth(fechaDesde,
	// Integer.parseInt(numeroMeses.toString()));
	// Date fechaEmpezarPitar = Y41bUtils.addDays(fechaLimite, (-1)
	// * Y41bConstantes.TIPO_AVISO_SANCIONES_NUMERODIASANTES);
	// sanbandeja.setBatipo(batipo);
	// sanbandeja.setBafecini(fechaEmpezarPitar);
	// sanbandeja.setBafeclimite(fechaLimite);
	// logger.info("SanbandejaDaoImpl - aniadeAvisoBandejaMeses - Fin ");
	// this.add(sanbandeja);
	// }

	/**
	 * Aniade aviso bandeja apertura expediente.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	public void aniadeAvisoBandejaDias(Expedien expedien, CensoMonitor censoMonitor, Long numeroMeses, String textoc,
			String textoe, String idTramite, Date fechaDesde, String batipo) {

		// Antes de insertar, borramos
		Sanbandeja aviso = new Sanbandeja();
		aviso.setExpedien(new Expedien(expedien.getExcodigo()));
		aviso.setBatipo(batipo);
		List<Sanbandeja> lavisos = this.findAll(aviso, null);
		for (int i = 0; i < lavisos.size(); i++) {
			this.remove(lavisos.get(i));
		}

		SanbandejaDaoImpl.LOGGER.info("SanbandejaDaoImpl - aniadeAvisoBandejaDias - Inicio " + batipo);

		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setExpedien(expedien);
		/* conseguimos el letrado del expediente */
		sanbandeja.setMonitor(censoMonitor);
		sanbandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		sanbandeja.setBatexto(textoc);
		sanbandeja.setBatextoe(textoe);
		sanbandeja.setBatrid(idTramite);
		Date fechaLimite = Y41bUtils.addDays(fechaDesde, Integer.parseInt(numeroMeses.toString()));
		Date fechaEmpezarPitar = Y41bUtils.addDays(fechaLimite,
				(-1) * Y41bConstantes.TIPO_AVISO_SANCIONES_NUMERODIASANTES);
		SanbandejaDaoImpl.LOGGER.info("SanbandejaDaoImpl - aniadeAvisoBandejaDias - Insertado aviso. Desde: "
				+ fechaEmpezarPitar.toString() + " . Hasta: " + fechaLimite);

		sanbandeja.setBatipo(batipo);

		// La fecha de inicio es diferente segun el aviso tenga un periodo de
		// validez hasta la fecha limite
		// o a partir de la fecha limite
		if (Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_PROP_RESOL.equals(batipo)
				|| Y41bConstantes.TIPO_AVISO_SANCIONES_APERTURA_RESOL.equals(batipo)
				|| Y41bConstantes.TIPO_AVISO_SANCIONES_REMISION_ASESORI.equals(batipo)
				|| Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION.equals(batipo)) {
			sanbandeja.setBafecini(fechaEmpezarPitar);
		} else {
			sanbandeja.setBafecini(fechaDesde);
		}
		// --------------------------------------------
		sanbandeja.setBafeclimite(fechaLimite);
		SanbandejaDaoImpl.LOGGER.info("SanbandejaDaoImpl - aniadeAvisoBandejaDias - Fin ");
		this.add(sanbandeja);
	}

	/**
	 * Aniade aviso bandeja apertura expediente.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroAnios
	 *            the numero anios
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	// public void aniadeAvisoBandejaAnios(Expedien expedien,
	// CensoMonitor censoMonitor, Long numeroAnios, String textoc,
	// String textoe, BigDecimal idTramite, Date fechaDesde, String batipo) {
	//
	// logger.info("SanbandejaDaoImpl - aniadeAvisoBandejaMeses - Inicio "
	// + batipo);
	//
	// Sanbandeja sanbandeja = new Sanbandeja();
	// sanbandeja.setExpedien(expedien);
	// /* conseguimos el letrado del expediente */
	// sanbandeja.setMonitor(censoMonitor);
	// sanbandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
	// /* Fecha de hoy */
	//
	// sanbandeja.setBafecini(fechaDesde);
	// sanbandeja.setBatexto(textoc);
	// sanbandeja.setBatextoe(textoe);
	// Date fechaLimite = Y41bUtils.addYear(fechaDesde,
	// Integer.parseInt(numeroAnios.toString()));
	// Date fechaEmpezarPitar = Y41bUtils.addDays(fechaLimite, (-1)
	// * Y41bConstantes.TIPO_AVISO_SANCIONES_NUMERODIASANTES);
	// sanbandeja.setBatipo(batipo);
	// sanbandeja.setBafecini(fechaEmpezarPitar);
	// sanbandeja.setBafeclimite(fechaLimite);
	// logger.info("SanbandejaDaoImpl - aniadeAvisoBandejaMeses - Fin ");
	// this.add(sanbandeja);
	// }

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */

	public List<Sanbandeja> getAvisosPlazoAlegaciones(Expedien expedien) {

		String query = "SELECT t1.BAID BAID, t1.BATRID BATRID, t1.BAFEC BAFEC, t1.BAESTADO BAESTADO, t1.BAFECLIMITE BAFECLIMITE, t1.BAFASE BAFASE, t1.BANOMDOC BANOMDOC, t1.BAFECALTA BAFECALTA, t1.BAFECMODIF BAFECMODIF, t1.BAUSUALTA BAUSUALTA, t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE, "
				+ " t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE, t3.UAIDINTERV SANINTERVUAIDINTERV, t3.UANOMBRE SANINTERVUANOMBRE, t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2, t3.UANIF SANINTERVUANIF, t3.UANRTEL SANINTERVUANRTEL, t3.UANRTEL2 SANINTERVUANRTEL2, t3.UAPROV_ID SANINTERVUAPROVID, t3.UAMUN_ID SANINTERVUAMUNID, t3.UALOC_ID SANINTERVUALOCID, t3.UACALLE_ID SANINTERVUACALLEID, t3.UACP_ID SANINTERVUACPID, t3.UAPORTAL_ID SANINTERVUAPORTALID, t3.UANOMBRE_PISO SANINTERVUANOMBREPISO, t3.UADIRE_NOCAPV SANINTERVUADIRENOCAPV, t3.UADIRE_ANT SANINTERVUADIREANT, t3.UATIPOINTERV SANINTERVUATIPOINTERV, t3.UADTCODIGO SANINTERVUADTCODIGO, t3.UAESCODIGO SANINTERVUAESCODIGO, t3.UATRFECALTA SANINTERVUATRFECALTA, t3.UATRFECMODIF SANINTERVUATRFECMODIF, t3.UATRUSUALTA SANINTERVUATRUSUALTA, t3.UATRUSUMODIF SANINTERVUATRUSUMODIF, t3.UAFECALTA SANINTERVUAFECALTA, t3.UAFECMODIF SANINTERVUAFECMODIF, t3.UAUSUALTA SANINTERVUAUSUALTA, t3.UAUSUMODIF SANINTERVUAUSUMODIF, t4.MOCODIGO MONITORMOCODIGO, t4.MONOMBRE MONITORMONOMBRE, t4.MOCOOR MONITORMOCOOR, t4.MOCOEM MONITORMOCOEM, t4.MOUSU MONITORMOUSU, t4.MOCLAVE MONITORMOCLAVE, t4.MOFECBAJA MONITORMOFECBAJA, t4.MOADMIN MONITORMOADMIN, t4.MOPRIMERA MONITORMOPRIMERA, t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES, t4.ID_PERFILSANCIONES MONITORIDPERFILSANCIONES, t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES, t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE, t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION, t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS, t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO, t4.USUARIOXLNET MONITORUSUARIOXLNET, t3.UAEXCODIGO SANINTERVUAEXCODIGO "
				+ " FROM SANBANDEJA t1 , EXPEDIEN t2 , SANINTERV t3 , CENSO_MONITOR t4  WHERE t1.BAEXCODIGO = ? AND (t1.BATIPO = ? OR t1.BATIPO = ? OR t1.BATIPO = ? OR t1.BATIPO = ?) AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND t1.BAUAIDINTERV= t3.UAIDINTERV(+) AND t1.BAULTINSTR= t4.MOCODIGO(+)";

		List<Sanbandeja> sanbandejaList = this.jdbcTemplate.query(query, this.rwMapAvisoAlegaciones,
				expedien.getExcodigo(), Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_ACUERDO_INC,
				Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_PROPUESTA_RESOL,
				Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCION,
				Y41bConstantes.TIPO_AVISO_SANCIONES_NOTIFICACION_RESOLUCIONPRUEBA);
		return sanbandejaList;

	}

	/**
	 * Removes a single row in the Sanbandeja table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 */
	public void removeAllEntradas(String excodigo) {
		String query = "DELETE FROM SANBANDEJA WHERE BAEXCODIGO=?";
		SanbandejaDaoImpl.LOGGER.info("SanbandejaDaoImpl - *** Remove - Elimino removeAllEntradas " + excodigo);
		this.jdbcTemplate.update(query, excodigo);
	}

	/**
	 * Crea aviso segun parametro.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param santramexp
	 *            the santramexp
	 * @param tipo
	 *            String
	 */
	public void creaAvisoSegunParametro(Expedien expedien, CensoMonitor censoMonitor, Santramexp santramexp,
			String tipo) {
		Parametros parametros = new Parametros();
		parametros.setParametro(tipo);
		parametros = this.parametrosDao.find(parametros);
		if (parametros != null) {
			Long numeroDias = new Long(parametros.getValor());
			this.aniadeAvisoBandejaDias(expedien, censoMonitor, numeroDias, "", "", santramexp.getTrid(),
					santramexp.getTrfecini(), tipo);
		}
	}

	/**
	 * Crea aviso segun parametro.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param tipo
	 *            the tipo
	 */
	public void creaAvisoFechaPrescripcion(Expedien expedien, CensoMonitor censoMonitor, String tipo) {

		// Antes de insertar, borramos
		Sanbandeja aviso = new Sanbandeja();
		aviso.setExpedien(new Expedien(expedien.getExcodigo()));
		aviso.setBatipo(Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
		List<Sanbandeja> lavisos = this.findAll(aviso, null);
		for (int i = 0; i < lavisos.size(); i++) {
			this.remove(lavisos.get(i));
		}

		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
		// if
		// (Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_LEVE.equals(tipo))
		// {
		// parametros
		// .setParametro(Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_LEVE);
		// } else if (Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_GRAVE
		// .equals(tipo)) {
		// parametros
		// .setParametro(Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_GRAVE);
		// } else if (Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_MUYGRAVE
		// .equals(tipo)) {
		// parametros
		// .setParametro(Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION_MUYGRAVE);
		// }
		parametros = this.parametrosDao.find(parametros);
		if (parametros != null) {
			Long numeroDias = new Long(parametros.getValor());
			this.aniadeAvisoBandejaDias(expedien, censoMonitor, numeroDias, "", "", null,
					expedien.getSanexp().getHdfechd(), Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
		}
	}

	/**
	 * Crea aviso segun parametro.
	 * 
	 * @param expedien
	 *            the expedien
	 */
	public void eliminaAvisoFechaPrescripcion(Expedien expedien) {
		String query = "DELETE FROM SANBANDEJA WHERE BAEXCODIGO=? AND BATIPO = ?";
		SanbandejaDaoImpl.LOGGER.info("SanbandejaDaoImpl - *** eliminaAvisoFechaPrescripcion " + query);
		this.jdbcTemplate.update(query, expedien.getExcodigo(), Y41bConstantes.TIPO_AVISO_SANCIONES_PRESCRIPCION);
	}

	/**
	 * Crea tramite apertura bandeja.
	 * 
	 * @param santramexp
	 *            the santramexp
	 */
	public void creaTramiteAperturaBandeja(Santramexp santramexp) {
		Sanbandeja sanbandeja = new Sanbandeja();
		sanbandeja.setExpedien(santramexp.getExpedien());
		sanbandeja.setMonitor(santramexp.getCensoMonitorEj());
		sanbandeja.setBatrid(santramexp.getTrid());
		sanbandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		sanbandeja.setBafec(santramexp.getTrfecini());
		sanbandeja.setBafase(santramexp.getFase().getFcodigo());
		this.add(sanbandeja);
	}

	/**
	 * Updates a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Pagination
	 * @return Sanbandeja
	 */
	public Sanbandeja updateCensoMonitorNoTramitados(Sanbandeja sanbandeja) {
		String query = "UPDATE SANBANDEJA SET BAULTINSTR=? WHERE BAEXCODIGO=? AND BAESTADO!='T'";
		Object getMonitorMocodigoAux = null;
		if (sanbandeja.getMonitor() != null && sanbandeja.getMonitor().getMocodigo() != null) {
			getMonitorMocodigoAux = sanbandeja.getMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, getMonitorMocodigoAux, sanbandeja.getExpedien().getExcodigo());
		return sanbandeja;
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public List<Sanbandeja> dameBandejaTP(Sanbandeja sanbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		StringBuilder queryNueva = new StringBuilder("");
		StringBuilder query1 = new StringBuilder(
				"SELECT  t1.BAID BAID,t1.BATRID BATRID,t1.BAFEC BAFEC,t1.BAESTADO BAESTADO,t1.BAFECLIMITE BAFECLIMITE,t1.BAFASE BAFASE,t1.BANOMDOC BANOMDOC,t1.BAFECALTA BAFECALTA,t1.BAFECMODIF BAFECMODIF,t1.BAUSUALTA BAUSUALTA,t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI,t1.BATEXTO BATEXTO,t1.BATEXTOE BATEXTOE "
						+ " ,t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR, LPAD(T2.EXNROR,12,'0') CORRELATIVOPAD, t2.EXCOOR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t2.EXNRAN CODCOMPLETO, t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT "
						+ " ,t3.UAIDINTERV SANINTERVUAIDINTERV,t3.UANOMBRE SANINTERVUANOMBRE,t3.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t3.UAAPELLIDO2 SANINTERVUAAPELLIDO2"
						+ " ,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE "
						+ ",T5.TRNOMTRAMES SANTRAMEXPTRNOMTRAMES, t5.TRCODIGO SANTRAMEXPTRCODIGO, t5.TRFECHAENVIOBOPVBOE SANTRAMEXPTRFECHAENVIOBOPVBOE, t5.TRISTELEMATICA TRISTELEMATICA, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE, t5.TRFECINI TRFECINI, t5.TRFECFIN TRFECFIN , t5.TRRESOTIPO, t5.TRESTADOACUSE TRESTADOACUSE, t9.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t9.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU "
						+ ", 0 TRAMITESPENDIENTES, 0 AVISOS ");
		query1.append(
				"FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,CENSO_MONITOR t4, SANTRAMEXP t5, FASE t6, TRAMITE t7, SANEXP t8, ENVIOS_POR_REMESA t9 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND T2.EXCODIGO = T3.UAEXCODIGO AND t2.EXCOES = t3.UAESCODIGO AND t3.UATIPOINTERV='E' AND t1.BAULTINSTR= t4.MOCODIGO(+) AND t1.BATRID = t5.TRID(+) AND t1.BAFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO AND BATIPO IS NULL AND T2.EXCODIGO = T8.EXCODIGO AND T5.TRESTADO!='T'  AND to_char(t5.TRTRIDREL)  = t9.EHCODIGO(+)  ");

		List<Object> params = new ArrayList<Object>();

		where.append("AND t1.BAEXCODIGO=? ");
		params.add(sanbandeja.getExpedien().getExcodigo());

		query1.append(where);

		queryNueva.append(query1);

		if (pagination != null && pagination.getSort() != null) {
			queryNueva = pagination.getPaginationQuery(queryNueva);
		}

		return (List<Sanbandeja>) this.jdbcTemplate.query(queryNueva.toString(), this.rwMapBandejaSanciones,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaTPCount(Sanbandeja sanbandeja, CensoMonitor censoMonitor, String perfil) {

		StringBuilder query1 = new StringBuilder("SELECT COUNT (BAID) ");
		query1.append(
				"FROM SANBANDEJA t1 ,EXPEDIEN t2 ,SANINTERV t3 ,CENSO_MONITOR t4, SANTRAMEXP t5, FASE t6, TRAMITE t7, SANEXP t8, ENVIOS_POR_REMESA t9  ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.BAEXCODIGO= t2.EXCODIGO(+) AND T2.EXCODIGO = T3.UAEXCODIGO AND t2.EXCOES = t3.UAESCODIGO AND t3.UATIPOINTERV='E' AND t1.BAULTINSTR= t4.MOCODIGO(+) AND t1.BATRID = t5.TRID(+) AND t1.BAFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO AND BATIPO IS NULL AND T2.EXCODIGO = T8.EXCODIGO  AND to_char(t5.TRTRIDREL)  = t9.EHCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.BAEXCODIGO=? ");
		params.add(sanbandeja.getExpedien().getExcodigo());

		/*
		 * StringBuilder wherePerfil = new StringBuilder("");
		 * 
		 * if (censoMonitor.getMobopvboe() != null &&
		 * censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
		 * where.append(" AND (T5.TRCODIGO=? ");
		 * params.add(Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA);
		 * where.append(" OR ( 1=1 "); } if
		 * (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) { //ve todo
		 * wherePerfil.append(" AND 1 = 1"); } else if
		 * (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) { wherePerfil
		 * .append
		 * (" AND (T1.BAULTINSTR = ? OR T8.EXMOCODIGO = ?)  AND T8.EXCOORACTUAL = ?"
		 * ); params.add(sanbandeja.getMonitor().getMocodigo());
		 * params.add(sanbandeja.getMonitor().getMocodigo());
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
		 * wherePerfil.append(" AND T8.EXCOORACTUAL = ?");
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) { // EL
		 * ADMINISTRATIVO EN SU BANDEJA VE LAS NOTIFICACIONES // COMUNICACIONES
		 * Y ACUSES QUE ESTEN PENDIENTES DE TRAMITAR
		 * wherePerfil.append(" AND T5.TRESTADO <> '" +
		 * Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "' AND (T5.TRCODIGO = '" +
		 * Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION +
		 * "' OR T5.TRCODIGO = '" +
		 * Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION +
		 * "' OR T5.TRCODIGO = '" +
		 * Y41bConstantes.TRAMITE_SANCIONES_PUBLICACION_BOPV_AYUNTA +
		 * "' OR T5.TRCODIGO = '" + Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
		 * + "' )"); wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_ADMINLIQUIDACIONES.equals(perfil)) {
		 * // EL ADMINISTRATIVO DE LIQUIDACIONES VE LAS LIQUIDACIONES //
		 * PENDIENTES DE TRAMITAR
		 * wherePerfil.append(" AND T5.TRESTADO NOT IN ('" +
		 * Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND T5.TRCODIGO IN ('"
		 * + Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION + "', '" +
		 * Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA + "')"); }
		 * else if
		 * (Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
		 * wherePerfil.append(" AND 1 = 0 "); } else if
		 * (Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
		 * wherePerfil.append(" AND 1 = 0 "); } else {
		 * wherePerfil.append(" AND T1.BAULTINSTR = ?");
		 * params.add(sanbandeja.getMonitor().getMocodigo()); } if
		 * (censoMonitor.getMobopvboe() != null &&
		 * censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
		 * wherePerfil.append(" )) "); } where.append(wherePerfil);
		 */

		query1.append(where);

		return this.jdbcTemplate.queryForLong(query1.toString(), params.toArray());

	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public List<Sanbandeja> dameBandejaAvisos(Sanbandeja sanbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		StringBuilder queryNueva = new StringBuilder("");

		// sacamos los avisos que estan apunto de terminar tambien
		StringBuilder queryAvisos = new StringBuilder(
				"SELECT  t1.BAID BAID,t1.BATRID BATRID,t1.BAFEC BAFEC,t1.BAESTADO BAESTADO,t1.BAFECLIMITE BAFECLIMITE,t1.BAFASE BAFASE,t1.BANOMDOC BANOMDOC,t1.BAFECALTA BAFECALTA,t1.BAFECMODIF BAFECMODIF,t1.BAUSUALTA BAUSUALTA,t1.BAUSUMODIF BAUSUMODIF, t1.BATIPO BATIPO, t1.BAFECINI BAFECINI, t1.BATEXTO BATEXTO, t1.BATEXTOE BATEXTOE "
						+ " ,t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,LPAD(T2.EXNROR,12,'0') CORRELATIVOPAD, t2.EXCOOR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.EXNROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t2.EXNRAN CODCOMPLETO, t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT "
						+ " ,0 SANINTERVUAIDINTERV,'' SANINTERVUANOMBRE,'' SANINTERVUAAPELLIDO1,'' SANINTERVUAAPELLIDO2"
						+ " ,'' MONITORMOCODIGO,'' MONITORMONOMBRE "
						+ ", '' SANTRAMEXPTRNOMTRAMES, '' SANTRAMEXPTRCODIGO, null SANTRAMEXPTRFECHAENVIOBOPVBOE, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE, null TRFECINI, null TRFECFIN, 0 TRAMITESPENDIENTES, 0 AVISOS "
						+ ", '' TRESTADOACUSE,'' TRRESOTIPO, '' ENVCDESSITCORREOSES, '' ENVCDESSITCORREOSEU"
						+ ", t8.TRISTELEMATICA TRISTELEMATICA "
						+ " FROM SANBANDEJA T1 , EXPEDIEN T2, SANEXP T3, FASE t6, TRAMITE t7, SANTRAMEXP t8 "
						+ " WHERE 1=1 AND T1.BAEXCODIGO=T2.EXCODIGO(+) AND T2.EXCODIGO=T3.EXCODIGO(+) AND ((SYSDATE > BAFECINI AND BAFECLIMITE IS NOT NULL AND BAFECINI <= BAFECLIMITE)) AND BATIPO IS NOT NULL "
						+ " AND T3.EXFCODIGO = t6.FCODIGO(+) AND T1.BATRID=t8.TRID(+) AND T1.BAEXCODIGO=T8.TREXCODIGO(+) AND T8.TRCODIGO=t7.TRCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();
		queryAvisos.append("AND t1.BAEXCODIGO=? ");
		params.add(sanbandeja.getExpedien().getExcodigo());

		/*
		 * StringBuilder wherePerfilAvisos = new StringBuilder(""); if
		 * (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) { // Ve todo
		 * wherePerfilAvisos.append(" AND 1 = 1 "); } else if
		 * (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) { wherePerfilAvisos
		 * .append(
		 * " AND (T1.BAULTINSTR =? OR T3.EXMOCODIGO = ?) AND T3.EXCOORACTUAL = ? "
		 * ); params.add(sanbandeja.getMonitor().getMocodigo());
		 * params.add(sanbandeja.getMonitor().getMocodigo());
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
		 * wherePerfilAvisos.append(" AND T3.EXCOORACTUAL = ? ");
		 * params.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else { // el resto no ven avisos
		 * wherePerfilAvisos.append(" AND 1 = 0 "); }
		 * 
		 * queryAvisos.append(wherePerfilAvisos);
		 */

		queryNueva.append(queryAvisos);

		if (pagination != null && pagination.getSort() != null) {
			queryNueva = pagination.getPaginationQuery(queryNueva);
		}

		return (List<Sanbandeja>) this.jdbcTemplate.query(queryNueva.toString(), this.rwMapBandejaSanciones,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaAvisosCount(Sanbandeja sanbandeja, CensoMonitor censoMonitor, String perfil) {

		// sacamos los avisos que estan apunto de terminar tambien
		StringBuilder queryAvisos = new StringBuilder("SELECT COUNT (BAID)"
				+ " FROM SANBANDEJA T1 , EXPEDIEN T2, SANEXP T3, FASE t6, TRAMITE t7, SANTRAMEXP t8 "
				+ " WHERE 1=1 AND T1.BAEXCODIGO= T2.EXCODIGO(+) AND T2.EXCODIGO=T3.EXCODIGO(+) AND ((SYSDATE > BAFECINI AND BAFECLIMITE IS NOT NULL AND BAFECINI <= BAFECLIMITE)) AND BATIPO IS NOT NULL "
				+ " AND T3.EXFCODIGO = t6.FCODIGO(+) AND T1.BATRID=t8.TRID(+) AND T1.BAEXCODIGO=T8.TREXCODIGO(+) AND T8.TRCODIGO=t7.TRCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();
		queryAvisos.append(" AND t1.BAEXCODIGO=? ");
		params.add(sanbandeja.getExpedien().getExcodigo());

		/*
		 * StringBuilder wherePerfilAvisos = new StringBuilder(""); List<Object>
		 * params2 = new ArrayList<Object>();
		 * 
		 * if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) { // ve todo
		 * wherePerfilAvisos.append(" AND 1 = 1 "); } else if
		 * (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) { wherePerfilAvisos
		 * .append(
		 * " AND (T1.BAULTINSTR =? OR T3.EXMOCODIGO = ?) AND T3.EXCOORACTUAL = ? "
		 * ); params2.add(sanbandeja.getMonitor().getMocodigo());
		 * params2.add(sanbandeja.getMonitor().getMocodigo());
		 * params2.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
		 * wherePerfilAvisos.append(" AND T3.EXCOORACTUAL = ? ");
		 * params2.add(sanbandeja.getMonitor().getOrganismo().getCodOrg()); }
		 * else { wherePerfilAvisos.append(" AND 1 = 0 "); }
		 * 
		 * queryAvisos.append(wherePerfilAvisos);
		 */

		return this.jdbcTemplate.queryForLong(queryAvisos.toString(), params.toArray());

	}
}
