package com.ejie.y41b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Santramexp;

/**
 * SanbandejaDao  
 * 
 *  
 */

public interface SanbandejaDao {

	/**
	 * Inserts a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja add(Sanbandeja sanbandeja);

	/**
	 * Updates a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja update(Sanbandeja sanbandeja);

	/**
	 * Finds a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja find(Sanbandeja sanbandeja);

	/**
	 * Deletes a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return
	 */
	void remove(Sanbandeja sanbandeja);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanbandeja> findAll(Sanbandeja sanbandeja, Pagination pagination);

	/**
	 * Counts rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Long
	 */
	Long findAllCount(Sanbandeja sanbandeja);

	/**
	 * Finds rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanbandeja> findAllLike(Sanbandeja sanbandeja, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanbandeja sanbandeja, Boolean startsWith);

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue();

	/**
	 * Finds a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Pagination
	 * 
	 */

	public void deleteBandejaPorExpediente(Sanbandeja sanbandeja);

	/**
	 * Borra los avisos caducados de la bandeja de sancionadores
	 */
	public void deleteBandejaAvisosCaducados();

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	List<Sanbandeja> dameBandeja(Sanbandeja sanbandeja, Pagination pagination,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaCount(Sanbandeja sanbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Aniade aviso bandeja apertura expediente.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	// public void aniadeAvisoBandejaMeses(Expedien expedien,
	// CensoMonitor censoMonitor, Long numeroMeses, String textoc,
	// String textoe, BigDecimal idTramite, Date fechaDesde, String batipo);

	/**
	 * Aniade aviso bandeja apertura expediente.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	public void aniadeAvisoBandejaDias(Expedien expedien,
			CensoMonitor censoMonitor, Long numeroMeses, String textoc,
			String textoe, String idTramite, Date fechaDesde, String batipo);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param expedien
	 *            the expedien
	 * @return List
	 */

	public List<Sanbandeja> getAvisosPlazoAlegaciones(Expedien expedien);

	/**
	 * Removes a single row in the Sanbandeja table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 */
	public void removeAllEntradas(String excodigo);

	/**
	 * Crea aviso segun parametro.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param santramexp
	 *            the santramexp
	 * @param tipo
	 *            the tipo
	 */
	public void creaAvisoSegunParametro(Expedien expedien,
			CensoMonitor censoMonitor, Santramexp santramexp, String tipo);

	/**
	 * Crea tramite apertura bandeja.
	 * 
	 * @param santramexp
	 *            the santramexp
	 */
	public void creaTramiteAperturaBandeja(Santramexp santramexp);

	/**
	 * Crea aviso segun parametro.
	 * 
	 * @param expedien
	 *            the expedien
	 * @param censoMonitor
	 *            the censo monitor
	 * @param tipo
	 *            the tipo
	 */
	public void creaAvisoFechaPrescripcion(Expedien expedien,
			CensoMonitor censoMonitor, String tipo);

	/**
	 * Crea aviso segun parametro.
	 * 
	 * @param expedien
	 *            the expedien
	 */
	public void eliminaAvisoFechaPrescripcion(Expedien expedien);

	/**
	 * updateCensoMonitorNoTramitados
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja updateCensoMonitorNoTramitados(Sanbandeja sanbandeja);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	List<Sanbandeja> dameBandejaTP(Sanbandeja sanbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaTPCount(Sanbandeja sanbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	List<Sanbandeja> dameBandejaAvisos(Sanbandeja sanbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaAvisosCount(Sanbandeja sanbandeja,
			CensoMonitor censoMonitor, String perfil);
}
