package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.RespuestaFile;

/**
 * * RespuestaFileDao  
 * 
 *  
 */

public interface RespuestaFileDao {

	/**
	 * Inserts a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile add(RespuestaFile respuestafile);

	/**
	 * Updates a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile update(RespuestaFile respuestafile);

	/**
	 * Finds a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile find(RespuestaFile respuestafile);

	/**
	 * Deletes a single row in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @return
	 */
	void remove(RespuestaFile respuestafile);

	/**
	 * Removes a single row in the RespuestaFile table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	void removeRespuestaFileConsulta(Consulta consulta);

	/**
	 * Finds a List of rows in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<RespuestaFile> findAll(RespuestaFile respuestafile,
			Pagination pagination);

	/**
	 * Counts rows in the RespuestaFile table.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @return List
	 */
	Long findAllCount(RespuestaFile respuestafile);

	/**
	 * Finds rows in the RespuestaFile table using like.
	 * 
	 * @param respuestafile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RespuestaFile> findAllLike(RespuestaFile respuestafile,
			Pagination pagination, Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

}
