package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.SituacionCorreos;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * RemesaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RemesaDaoImpl implements RemesaDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<SituacionCorreos> rwMapSituacionCorreos = new RowMapper<SituacionCorreos>() {
		public SituacionCorreos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new SituacionCorreos(resultSet.getString("CODSITCORREOS"),
					resultSet.getString("EHACUSERECIBORECIBIDO"),
					resultSet.getString("SITCONPEE"),
					resultSet.getString("DESC_SIT_CORREOS_ES"),
					resultSet.getString("DESC_SIT_CORREOS_EU"));
		}
	};

	private RowMapper<Remesa> rwMapAA66 = new RowMapper<Remesa>() {
		public Remesa mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Remesa(resultSet.getString("RMCODIGO"),
					resultSet.getString("RMTIPO"),
					resultSet.getString("RMESTADO"),
					resultSet.getString("RMCODPLANTCARATULA"),
					resultSet.getString("RMCODPLANTACUSE"),
					resultSet.getString("RMCODPLANTLISTADO"), null, null, null,
					resultSet.getTimestamp("RMFECHAGENERACION"),
					resultSet.getDate("RMFECHAEMISION"),
					resultSet.getString("RMCOMO"),
					resultSet.getString("RMTIPOPROC"), null,
					resultSet.getInt("RMIDCOLECCIONAA66"),
					resultSet.getString("RMCODCOLECCIONAA66"),
					resultSet.getInt("RMIDREMESAAA66"),
					resultSet.getString("RMCODREMESAAA66"),
					resultSet.getString("RMDESDESREMESA"),
					resultSet.getString("RMDESMOTREMES"),
					resultSet.getString("RMDESMOTREMEU"),
					resultSet.getString("RMDESERRORES"),
					resultSet.getString("RMDESERROREU"),
					resultSet.getDate("RMFECHAACTUALIZACION"), null);
		}
	};

	private RowMapper<Remesa> rwMapVista = new RowMapper<Remesa>() {
		public Remesa mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Remesa(resultSet.getString("RMCODIGO"),
					resultSet.getString("RMTIPO"),
					resultSet.getString("RMESTADO"),
					resultSet.getTimestamp("RMFECHAGENERACION"),
					resultSet.getDate("RMFECHAEMISION"),
					resultSet.getDate("RMFECHA_ENVIOMASRECIENTE"));
		}
	};

	private RowMapper<Remesa> rwMapExcel = new RowMapper<Remesa>() {
		public Remesa mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Remesa(resultSet.getString("RMCODIGO"),
					resultSet.getString("RMTIPO"),
					resultSet.getString("RMESTADO"),
					resultSet.getString("RMCODPLANTCARATULA"),
					resultSet.getString("RMCODPLANTACUSE"),
					resultSet.getString("RMCODPLANTLISTADO"), null, null, null,
					resultSet.getTimestamp("RMFECHAGENERACION"),
					resultSet.getDate("RMFECHAEMISION"),
					resultSet.getString("RMCOMO"),
					resultSet.getString("RMTIPOPROC"),
					resultSet.getString("PNOMBRE"),
					resultSet.getString("PNOMBREE"),
					resultSet.getString("MONOMBRE"),
					resultSet.getString("IDTRAMITE"),
					resultSet.getString("ENVCCOMOEJECUCION"),
					resultSet.getString("MONOMBRE"),
					resultSet.getString("EHTIPONOTIFICACIONPLATEA"),
					resultSet.getString("NOMBREDESTINATARIO"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getDate("EHFECHAINICIO"),
					resultSet.getString("ENVCESTADO"),
					resultSet.getString("ENVCCODSITCORREOS"),
					resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"),
					resultSet.getString("EHACUSERECIBORECIBIDO"),
					resultSet.getString("EHESTADOTRAMITE"),
					resultSet.getString("CODSITCORREOS"),
					resultSet.getString("DESCSITCORREOSES"),
					resultSet.getString("DESCSITCORREOSEU"),
					resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("ENVCCODENVIO"),
					resultSet.getString("ENVCCODBARRAS"),
					resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"),
					resultSet.getDate("ENVFECHAACTUALIZACION"), null,
					resultSet.getInt("RMIDCOLECCIONAA66"),
					resultSet.getString("RMCODCOLECCIONAA66"),
					resultSet.getInt("RMIDREMESAAA66"),
					resultSet.getString("RMCODREMESAAA66"),
					resultSet.getString("RMDESDESREMESA"),
					resultSet.getString("RMDESMOTREMES"),
					resultSet.getString("RMDESMOTREMEU"),
					resultSet.getString("RMDESERRORES"),
					resultSet.getString("RMDESERROREU"),
					resultSet.getDate("RMFECHAACTUALIZACION"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa add(Remesa remesa) {
		String query = "INSERT INTO REMESA (RMCODIGO, RMTIPO, RMESTADO, RMCODPLANTCARATULA, RMCODPLANTACUSE, RMCODPLANTLISTADO, RMDATAFILE, RMLISTADOFILE, RMACUSESFILE, RMFECHAGENERACION, RMFECHAEMISION, RMCOMO, RMTIPOPROC) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, remesa.getRmcodigo(),
				remesa.getRmtipo(), remesa.getRmestado(),
				remesa.getRmcodplantcaratula(), remesa.getRmcodplantacuse(),
				remesa.getRmcodplantlistado(), remesa.getRmdatafile(),
				remesa.getRmlistadofile(), remesa.getRmacusesfile(),
				remesa.getRmfechageneracion(), remesa.getRmfechaemision(),
				remesa.getRmcomo(), remesa.getRmtipoproc());
		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa update(Remesa remesa) {
		String query = "UPDATE REMESA SET RMESTADO= ?, RMID_COLECCION_AA66=?, RMCOD_COLECCION_AA66=?, RMID_REMESA_AA66=?, RMCOD_REMESA_AA66=?, RMDES_DESREMESA=?, RMDES_MOTREMES=?, RMDES_MOTREMEU=?, RMDES_ERRORES=?, RMDES_ERROREU=? "
				+ "WHERE RMCODIGO=?";
		this.jdbcTemplate.update(query, remesa.getRmestado(),
				remesa.getRmidColeccionAA66(), remesa.getRmcodColeccionAA66(),
				remesa.getRmidRemesaAA66(), remesa.getRmcodRemesaAA66(),
				remesa.getRmdesDesremesa(), remesa.getRmdesMotremes(),
				remesa.getRmdesMotremeu(),
				getDescripcionMaxima1000(remesa.getRmdesErrores()),
				getDescripcionMaxima1000(remesa.getRmdesErroreu()),
				remesa.getRmcodigo());
		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa updateDatosGeneracion(Remesa remesa) {
		String query = "UPDATE REMESA SET RMESTADO=?, "
				+ "RMID_COLECCION_AA66=?, RMCOD_COLECCION_AA66=?, RMID_REMESA_AA66=?, RMCOD_REMESA_AA66=?, RMDES_DESREMESA=?, RMDES_MOTREMES=?, RMDES_MOTREMEU=?, RMDES_ERRORES=?, RMDES_ERROREU=?, "
				+ "RMDATAFILE=?,  RMACUSESFILE=?, RMLISTADOFILE=?, RMFECHAGENERACION=? WHERE RMCODIGO=?";
		this.jdbcTemplate.update(
				query,
				remesa.getRmestado(),
				// Datos de AA66
				remesa.getRmidColeccionAA66(),
				remesa.getRmcodColeccionAA66(),
				remesa.getRmidRemesaAA66(),
				remesa.getRmcodRemesaAA66(),
				remesa.getRmdesDesremesa(),
				remesa.getRmdesMotremes(),
				remesa.getRmdesMotremeu(),
				getDescripcionMaxima1000(remesa.getRmdesErrores()),
				getDescripcionMaxima1000(remesa.getRmdesErroreu()),
				//
				Y41bJdbcUtils.ConvertBlobToByte(remesa.getRmdatafile()),
				(remesa.getRmacusesfile() == null) ? null : Y41bJdbcUtils
						.ConvertBlobToByte(remesa.getRmacusesfile()),
				(remesa.getRmlistadofile() == null) ? null : Y41bJdbcUtils
						.ConvertBlobToByte(remesa.getRmlistadofile()), remesa
						.getRmfechageneracion(), remesa.getRmcodigo());
		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa updateFechaActualizacionRemesa(Remesa remesa) {
		String query = "UPDATE REMESA SET RMFECHAACTUALIZACION=SYSDATE WHERE RMCODIGO=?";
		this.jdbcTemplate.update(query, remesa.getRmcodigo());
		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa updateEstadoRemesa(Remesa remesa) {
		String query = "UPDATE REMESA SET RMESTADO=?, RMFECHAEMISION=?, RMFECHAACTUALIZACION=SYSDATE WHERE RMCODIGO=?";
		this.jdbcTemplate.update(query, remesa.getRmestado(),
				remesa.getRmfechaemision(), remesa.getRmcodigo());
		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa updateEstadoRemesaErronea(Remesa remesa, String tipoError) {
		String query = "UPDATE REMESA SET RMESTADO='"
				+ tipoError
				+ "', RMDES_ERRORES=?, RMDES_ERROREU=?, RMFECHAACTUALIZACION=SYSDATE WHERE RMCODIGO=?";
		this.jdbcTemplate.update(query,
				getDescripcionMaxima1000(remesa.getRmdesErrores()),
				getDescripcionMaxima1000(remesa.getRmdesErroreu()),
				remesa.getRmcodigo());
		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public void cerrarRemesa(Remesa remesa) {
		String query = "UPDATE REMESA SET RMESTADO=?, RMFECHAACTUALIZACION=SYSDATE WHERE RMCODIGO=?";
		this.jdbcTemplate.update(query, Y41bConstantes.ESTADO_REMESA_CERRADA,
				remesa.getRmcodigo());
	}

	private String getSelectQuery() {
		return "SELECT t1.RMCODIGO RMCODIGO, t1.RMTIPO RMTIPO, t1.RMESTADO RMESTADO, t1.RMCODPLANTCARATULA RMCODPLANTCARATULA, t1.RMCODPLANTACUSE RMCODPLANTACUSE, t1.RMCODPLANTLISTADO RMCODPLANTLISTADO, t1.RMFECHAGENERACION RMFECHAGENERACION, t1.RMFECHAEMISION RMFECHAEMISION, t1.RMCOMO RMCOMO, t1.RMTIPOPROC RMTIPOPROC, t1.RMFECHAACTUALIZACION RMFECHAACTUALIZACION ";
	}

	private String getFromWhereQuery() {
		return "FROM REMESA t1 WHERE t1.RMCODIGO = ?  ";
	}

	private String getAA66SelectQuery() {
		return ", t1.RMID_COLECCION_AA66 RMIDCOLECCIONAA66, t1.RMCOD_COLECCION_AA66 RMCODCOLECCIONAA66, t1.RMID_REMESA_AA66 RMIDREMESAAA66, "
				+ "t1.RMCOD_REMESA_AA66 RMCODREMESAAA66, t1.RMDES_DESREMESA RMDESDESREMESA, t1.RMDES_MOTREMES RMDESMOTREMES, "
				+ "t1.RMDES_MOTREMEU RMDESMOTREMEU, t1.RMDES_ERRORES RMDESERRORES, t1.RMDES_ERROREU RMDESERROREU ";
	}

	// FROM REMESA t1, CENSO_MONITOR t2 ,ENVIOS_POR_REMESA t3, TRAMITE_HECHO t4
	// , SITUACION_Y41B_CON_CORREOS t5, DENUNCIA t6, HECHO_DENUNCIADO
	// t7,INTERVINIENTES t8, CENSO_MONITOR t9
	// private String getEnvioSelectQuery() {
	// return
	// ", t6.DECOOR||' '||t6.DENRAN||' '||t6.DENROR||' '||t7.HDNROR IDTRAMITE,t3.ENVCCOMOEJECUCION ENVCCOMOEJECUCION, (SELECT MONOMBRE from CENSO_MONITOR where MOCODIGO = t3.ENVCCOMOEJECUCION) MONOMBRE, t4.EHTIPONOTIFICACIONPLATEA EHTIPONOTIFICACIONPLATEA, "
	// +
	// "t4.EHIDDESTINATARIO EHIDDESTINATARIO, t8.NIF NIF, t8.NOMBRE ||' '||t8.APELLIDO1||' '||t8.APELLIDO2 AS NOMBREDESTINATARIO, t8.NOMBRE_CP NOMBRE_CP, t8.NOMBRE_PROVINCIA NOMBRE_PROVINCIA, "
	// +
	// "t8.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIO, t4.EHFECHAINICIO EHFECHAINICIO, "
	// +
	// "t3.ENVCESTADO ENVCESTADO, t3.ENVCCOD_SIT_CORREOS ENVCCOD_SIT_CORREOS, t3.ENVCDES_SIT_CORREOS_ES ENVCDES_SIT_CORREOS_ES,t3.ENVCDES_SIT_CORREOS_EU ENVCDES_SIT_CORREOS_EU, "
	// +
	// "t5.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO, t4.EHESTADOTRAMITE EHESTADOTRAMITE, t5.COD_SIT_CORREOS COD_SIT_CORREOS, t5.DESC_SIT_CORREOS_ES DESC_SIT_CORREOS_ES, t5.DESC_SIT_CORREOS_EU DESC_SIT_CORREOS_EU, "
	// +
	// "t3.ENVC_ID_ENVIO ENVC_ID_ENVIO,t3.ENVC_COD_ENVIO ENVC_COD_ENVIO, t3.ENVCCODBARRAS ENVCCODBARRAS, t3.ENVCDESERRORES ENVCDESERRORES, t3.ENVCDESERROREU ENVCDESERROREU, t3.ENVFECHAACTUALIZACION ENVFECHAACTUALIZACION, "
	// +
	// "t12.PCODIGO PCODIGO,t12.PNOMBRE PNOMBRE,NVL(t12.PNOMBREE,t12.PNOMBRE) PNOMBREE ";
	// }

	/**
	 * Finds a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	@Transactional(readOnly = true)
	public Remesa find(Remesa remesa) {
		String query = getSelectQuery() + getAA66SelectQuery()
				+ getFromWhereQuery();

		List<Remesa> remesaList = this.jdbcTemplate.query(query,
				this.rwMapAA66, remesa.getRmcodigo());
		return (Remesa) DataAccessUtils.uniqueResult(remesaList);
	}

	// /**
	// * Finds a single row in the Remesa table.
	// *
	// * @param remesa
	// * Pagination
	// * @return Remesa
	// */
	// @Transactional(readOnly = true)
	// public Remesa findRemesaEnvio(Remesa remesa) {
	// String query = getSelectQuery() + getAA66SelectQuery()
	// + getEnvioSelectQuery() + getFromWhereQuery();
	//
	// List<Remesa> remesaList = this.jdbcTemplate.query(query,
	// this.rwMapExcel, remesa.getRmcodigo());
	// return (Remesa) DataAccessUtils.uniqueResult(remesaList);
	// }

	/**
	 * Removes a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return
	 */
	public void remove(Remesa remesa) {
		String query = "DELETE FROM REMESA WHERE RMCODIGO=?";
		this.jdbcTemplate.update(query, remesa.getRmcodigo());
	}

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAll(Remesa remesa, Pagination pagination) {
		StringBuilder query = new StringBuilder(getSelectQuery()
				+ getAA66SelectQuery());
		query.append("FROM REMESA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapAA66(remesa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapAA66, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Remesa remesa) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM REMESA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapAA66(remesa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllLike(Remesa remesa, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(getSelectQuery()
				+ getAA66SelectQuery());
		query.append("FROM REMESA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapAA66(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapAA66, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Remesa remesa, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM REMESA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapAA66(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeRemesasCount(RemesaBusqueda remesa,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM REMESA t1, CENSO_MONITOR t2 ");

		if (remesa.getRmtipo() != null
				&& remesa.getRmtipo().equalsIgnoreCase(
						Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			query.append(" ,ENVIOS_POR_REMESA t3, TRAMITE_HECHO t4 ");

			if (remesa.getRmsituacionacuse() != null) {
				query.append(" , SITUACION_Y41B_CON_CORREOS t5 ");
			}

		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		where.append(" AND t1.RMCOMO = t2.MOCODIGO ");
		if (remesa.getRmtipo() != null
				&& remesa.getRmtipo().equalsIgnoreCase(
						Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			where.append(" AND t1.RMCODIGO = t4.EHCODREM AND t4.EHCODIGO = t3.EHCODIGO");

			if (remesa.getRmsituacionacuse() != null) {
				where.append(" AND t3.ENVCCOD_SIT_CORREOS = t5.COD_SIT_CORREOS ");
			}

		}

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeVistaSol(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT ");
		query.append("RMCODIGO, RMESTADO, RMTIPO, RMFECHAGENERACION, RMFECHAEMISION, RMFECHA_ENVIOMASRECIENTE ");
		query.append(" FROM REMESASENVIOSVISTASOL ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapVista, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllRemesasLikeVistaSolCount(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT ");
		query.append("(DISTINCT RMCODIGO) ");
		query.append("FROM REMESASENVIOSVISTASOL ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeVistaIns(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT ");
		query.append("RMCODIGO, RMESTADO, RMTIPO, RMFECHAGENERACION, RMFECHAEMISION, RMFECHA_ENVIOMASRECIENTE ");
		query.append(" FROM REMESASENVIOSVISTAINS ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapVista, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllRemesasLikeVistaInsCount(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT ");
		query.append("(DISTINCT RMCODIGO) ");
		query.append("FROM REMESASENVIOSVISTAINS ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeVistaSan(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT ");
		query.append("RMCODIGO, RMESTADO, RMTIPO, RMFECHAGENERACION, RMFECHAEMISION, RMFECHA_ENVIOMASRECIENTE ");
		query.append(" FROM REMESASENVIOSVISTASAN ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapVista, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllRemesasLikeVistaSanCount(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT ");
		query.append("(DISTINCT RMCODIGO) ");
		query.append("FROM REMESASENVIOSVISTASAN ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeVistaArb(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT ");
		query.append("RMCODIGO, RMESTADO, RMTIPO, RMFECHAGENERACION, RMFECHAEMISION, RMFECHA_ENVIOMASRECIENTE ");
		query.append(" FROM REMESASENVIOSVISTAARB ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapVista, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllRemesasLikeVistaArbCount(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT ");
		query.append("(DISTINCT RMCODIGO) ");
		query.append("FROM REMESASENVIOSVISTAARB ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeVistaArbAdh(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT ");
		query.append("RMCODIGO, RMESTADO, RMTIPO, RMFECHAGENERACION, RMFECHAEMISION, RMFECHA_ENVIOMASRECIENTE ");
		query.append(" FROM REMESASENVIOSVISTAARBADH ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapVista, params.toArray());
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllRemesasLikeVistaArbAdhCount(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT ");
		query.append("(DISTINCT RMCODIGO) ");
		query.append("FROM REMESASENVIOSVISTAARBADH ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLike(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(getSelectQuery()
				+ getAA66SelectQuery());
		query.append("FROM REMESA t1, CENSO_MONITOR t2 ");

		if (remesa.getRmtipo() != null
				&& remesa.getRmtipo().equalsIgnoreCase(
						Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			query.append(" ,ENVIOS_POR_REMESA t3, TRAMITE_HECHO t4 ");

			if (remesa.getRmsituacionacuse() != null) {
				query.append(" , SITUACION_Y41B_CON_CORREOS t5 ");
			}
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.RMCOMO = t2.MOCODIGO ");

		if (remesa.getRmtipo() != null
				&& remesa.getRmtipo().equalsIgnoreCase(
						Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			where.append(" AND t1.RMCODIGO = t4.EHCODREM AND t4.EHCODIGO = t3.EHCODIGO");

			if (remesa.getRmsituacionacuse() != null) {
				where.append(" AND t3.ENVCCOD_SIT_CORREOS = t5.COD_SIT_CORREOS ");
			}
		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapAA66, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Remesa entity
	 * 
	 * @param remesa
	 *            Remesa Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMapAA66(Remesa remesa) {

		StringBuilder where = new StringBuilder(
				RemesaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (remesa != null) {
			if (remesa.getRmcodigo() != null) {
				where.append(" AND t1.RMCODIGO = ?");
				params.add(remesa.getRmcodigo());
			}
			if (remesa.getRmtipo() != null) {
				where.append(" AND t1.RMTIPO = ?");
				params.add(remesa.getRmtipo());
			}
			if (remesa.getRmestado() != null) {
				where.append(" AND t1.RMESTADO = ?");
				params.add(remesa.getRmestado());
			}
			if (remesa.getRmcodplantcaratula() != null) {
				where.append(" AND t1.RMCODPLANTCARATULA = ?");
				params.add(remesa.getRmcodplantcaratula());
			}
			if (remesa.getRmcodplantacuse() != null) {
				where.append(" AND t1.RMCODPLANTACUSE = ?");
				params.add(remesa.getRmcodplantacuse());
			}
			if (remesa.getRmcodplantlistado() != null) {
				where.append(" AND t1.RMCODPLANTLISTADO = ?");
				params.add(remesa.getRmcodplantlistado());
			}
			if (remesa.getRmfechageneracion() != null) {
				where.append(" AND t1.RMFECHAGENERACION = ?");
				params.add(remesa.getRmfechageneracion());
			}
			if (remesa.getRmfechaemision() != null) {
				where.append(" AND t1.RMFECHAEMISION = ?");
				params.add(remesa.getRmfechaemision());
			}
			if (remesa.getRmcomo() != null) {
				where.append(" AND t1.RMCOMO = ?");
				params.add(remesa.getRmcomo());
			}
			if (remesa.getRmtipoproc() != null) {
				where.append(" AND t1.RMCOMO = ?");
				params.add(remesa.getRmtipoproc());
			}
			if (remesa.getRmcodigo() != null) {
				where.append(" AND t1.RMCODIGO = ?");
				params.add(remesa.getRmcodigo());
			}
			if (remesa.getRmidColeccionAA66() != null) {
				where.append(" AND t1.RMID_COLECCION_AA66 = ?");
				params.add(remesa.getRmidColeccionAA66());
			}
			if (remesa.getRmcodColeccionAA66() != null) {
				where.append(" AND t1.RMCOD_COLECCION_AA66 = ?");
				params.add(remesa.getRmcodColeccionAA66());
			}
			if (remesa.getRmidRemesaAA66() != null) {
				where.append(" AND t1.RMID_REMESA_AA66 = ?");
				params.add(remesa.getRmidRemesaAA66());
			}
			if (remesa.getRmcodRemesaAA66() != null) {
				where.append(" AND t1.RMCOD_REMESA_AA66 = ?");
				params.add(remesa.getRmcodRemesaAA66());
			}
			if (remesa.getRmdesDesremesa() != null) {
				where.append(" AND t1.RMDES_DESREMESA = ?");
				params.add(remesa.getRmdesDesremesa());
			}
			if (remesa.getRmdesMotremes() != null) {
				where.append(" AND t1.RMDES_MOTREMES = ?");
				params.add(remesa.getRmdesMotremes());
			}
			if (remesa.getRmdesMotremeu() != null) {
				where.append(" AND t1.RMDES_MOTREMEU = ?");
				params.add(remesa.getRmdesMotremeu());
			}
			if (remesa.getRmdesErrores() != null) {
				where.append(" AND t1.RMDES_ERRORES = ?");
				params.add(remesa.getRmdesErrores());
			}
			if (remesa.getRmdesErroreu() != null) {
				where.append(" AND t1.RMDES_ERROREU = ?");
				params.add(remesa.getRmdesErroreu());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Remesa entity
	 * 
	 * @param remesa
	 *            Remesa Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereLikeMapAA66(Remesa remesa, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RemesaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (remesa != null) {
			if (remesa.getRmcodigo() != null) {
				where.append(" AND UPPER(t1.RMCODIGO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodigo().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcodigo().toUpperCase() + "%");
				}
				where.append(" AND t1.RMCODIGO IS NOT NULL");
			}
			if (remesa.getRmtipo() != null) {
				where.append(" AND UPPER(t1.RMTIPO) like ? ESCAPE  '\\'");
				params.add(remesa.getRmtipo().toUpperCase());
				where.append(" AND t1.RMTIPO IS NOT NULL");
			}
			if (remesa.getRmestado() != null) {
				where.append(" AND UPPER(t1.RMESTADO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmestado().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmestado().toUpperCase() + "%");
				}
				where.append(" AND t1.RMESTADO IS NOT NULL");
			}
			if (remesa.getRmcodplantcaratula() != null) {
				where.append(" AND UPPER(t1.RMCODPLANTCARATULA) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodplantcaratula().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ remesa.getRmcodplantcaratula().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.RMCODPLANTCARATULA IS NOT NULL");
			}
			if (remesa.getRmcodplantacuse() != null) {
				where.append(" AND UPPER(t1.RMCODPLANTACUSE) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodplantacuse().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcodplantacuse().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.RMCODPLANTACUSE IS NOT NULL");
			}
			if (remesa.getRmcodplantlistado() != null) {
				where.append(" AND UPPER(t1.RMCODPLANTLISTADO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodplantlistado().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ remesa.getRmcodplantlistado().toUpperCase() + "%");
				}
				where.append(" AND t1.RMCODPLANTLISTADO IS NOT NULL");
			}
			if (remesa.getRmfechageneracion() != null) {
				where.append(" AND t1.RMFECHAGENERACION = ?");
				params.add(remesa.getRmfechageneracion());
			}
			if (remesa.getRmfechaemision() != null) {
				where.append(" AND t1.RMFECHAEMISION = ?");
				params.add(remesa.getRmfechaemision());
			}
			if (remesa.getRmcomo() != null) {
				where.append(" AND UPPER(t1.RMCOMO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcomo().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcomo().toUpperCase() + "%");
				}
				where.append(" AND t1.RMCOMO IS NOT NULL");
			}
			if (remesa.getRmtipoproc() != null) {
				where.append(" AND UPPER(t1.RMTIPOPROC) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcomo().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmtipoproc().toUpperCase() + "%");
				}
			}

			if (remesa.getRmidColeccionAA66() != null) {
				where.append(" AND t1.RMID_COLECCION_AA66 = ? ");
				params.add(remesa.getRmidColeccionAA66());
			}
			if (remesa.getRmcodColeccionAA66() != null) {
				where.append(" AND UPPER(t1.RMCOD_COLECCION_AA66) like ? ESCAPE  '\\' ");
				if (startsWith) {
					params.add(remesa.getRmcodColeccionAA66().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ remesa.getRmcodColeccionAA66().toUpperCase()
							+ "%");
				}
			}
			if (remesa.getRmidRemesaAA66() != null) {
				where.append(" AND t1.RMID_REMESA_AA66 = ?  ");
				params.add(remesa.getRmidRemesaAA66());
			}
			if (remesa.getRmcodRemesaAA66() != null) {
				where.append(" AND UPPER(t1.RMCOD_REMESA_AA66 like ? ESCAPE  '\\' ");
				if (startsWith) {
					params.add(remesa.getRmcodRemesaAA66().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcodRemesaAA66().toUpperCase()
							+ "%");
				}
			}
			if (remesa.getRmdesDesremesa() != null) {
				where.append(" AND UPPER(t1.RMDES_DESREMESA like ? ESCAPE  '\\' ");
				if (startsWith) {
					params.add(remesa.getRmdesDesremesa().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmdesDesremesa().toUpperCase()
							+ "%");
				}
			}
			if (remesa.getRmdesMotremes() != null) {
				where.append(" AND UPPER(t1.RMDES_MOTREMES like ? ESCAPE  '\\' ");
				if (startsWith) {
					params.add(remesa.getRmdesMotremes().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmdesMotremes().toUpperCase()
							+ "%");
				}
			}
			if (remesa.getRmdesMotremeu() != null) {
				where.append(" AND UPPER(t1.RMDES_MOTREMEU like ? ESCAPE  '\\' ");
				if (startsWith) {
					params.add(remesa.getRmdesMotremeu().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmdesMotremeu().toUpperCase()
							+ "%");
				}
			}
			if (remesa.getRmdesErrores() != null) {
				where.append(" AND UPPER(t1.RMDES_ERRORES like ? ESCAPE  '\\' ");

				if (startsWith) {
					params.add(remesa.getRmdesErrores().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmdesErrores().toUpperCase()
							+ "%");
				}
			}
			if (remesa.getRmdesErroreu() != null) {
				where.append(" AND UPPER(t1.RMDES_ERROREU like ? ESCAPE  '\\' ");

				if (startsWith) {
					params.add(remesa.getRmdesErroreu().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmdesErroreu().toUpperCase()
							+ "%");
				}
			}
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Remesa entity
	 * 
	 * @param remesa
	 *            Remesa Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereLikeMap(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RemesaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		if (remesa != null) {
			if (remesa.getRmcodigo() != null) {
				where.append(" AND UPPER(t1.RMCODIGO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodigo().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcodigo().toUpperCase() + "%");
				}
				where.append(" AND t1.RMCODIGO IS NOT NULL");
			}
			if (remesa.getRmtipo() != null) {
				where.append(" AND UPPER(t1.RMTIPO) like ? ESCAPE  '\\'");
				params.add(remesa.getRmtipo().toUpperCase());
				where.append(" AND t1.RMTIPO IS NOT NULL");
			}
			// fecha registro desde
			if (remesa.getRmfechageneracionDesde() != null) {
				where.append(" AND TO_CHAR(t1.RMFECHAGENERACION, 'YYYYMMDD') >= TO_CHAR(?, 'YYYYMMDD')");
				params.add(remesa.getRmfechageneracionDesde());
			}
			// fecha registro hasta
			if (remesa.getRmfechageneracionHasta() != null) {
				where.append(" AND TO_CHAR(t1.RMFECHAGENERACION, 'YYYYMMDD') <= TO_CHAR(?, 'YYYYMMDD')");
				params.add(remesa.getRmfechageneracionHasta());
			}

			if (remesa.getRmcomo() != null) {
				where.append(" AND UPPER(t1.RMCOMO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcomo().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcomo().toUpperCase() + "%");
				}
				where.append(" AND t1.RMCOMO IS NOT NULL");
			}

			if (remesa.getRmcodorg() != null) {
				where.append(" AND UPPER(t2.MOCOOR) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodorg().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcodorg().toUpperCase() + "%");
				}
			}

			if (remesa.getRmtipoexpediente() != null) {
				where.append(" AND UPPER(t1.RMTIPOPROC) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmtipoexpediente().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmtipoexpediente().toUpperCase()
							+ "%");
				}
			}

			if (remesa.getRmestado() != null) {
				where.append(" AND UPPER(t1.RMESTADO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmestado().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmestado().toUpperCase() + "%");
				}
			}

			if (remesa.getRmestado() == null) {
				if (remesa.getRmcheckcerradas() != null
						&& remesa.getRmcheckcerradas().equalsIgnoreCase(
								Y41bConstantes.VALOR_NO)) {
					where.append(" AND t1.RMESTADO <> '")
							.append(Y41bConstantes.ESTADO_REMESA_CERRADA)
							.append("'");
				}
			}

			if (remesa.getRmtipo() != null
					&& remesa.getRmtipo().equalsIgnoreCase(
							Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

				// fecha act envio desde
				if (remesa.getRmFechaActEnvDesde() != null) {
					where.append(" AND TO_CHAR(t3.ENVFECHAACTUALIZACION, 'YYYYMMDD') >= TO_CHAR(?, 'YYYYMMDD')");
					params.add(remesa.getRmFechaActEnvDesde());
				}
				// fecha act envio hasta
				if (remesa.getRmFechaActEnvHasta() != null) {
					where.append(" AND TO_CHAR(t3.ENVFECHAACTUALIZACION, 'YYYYMMDD') <= TO_CHAR(?, 'YYYYMMDD')");
					params.add(remesa.getRmFechaActEnvHasta());
				}

				// estado envio

				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_SINACTUALIZAR)) {
					where.append(" AND t3.ENVFECHAACTUALIZACION IS NULL");
				}

				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_SINESTADO)) {
					where.append(" AND t3.ENVCESTADO IS NULL AND t3.ENVFECHAACTUALIZACION IS NOT NULL");
				}

				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_ERRONEO)) {
					where.append(" AND t3.ENVCESTADO = ?");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_ERRONEO);
				}

				// con pee
				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOS)) {
					where.append(" AND t3.ENVCESTADO = ? ");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOS);
				}

				// tendra PEE a la espera de el
				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE)) {
					where.append(" AND t3.ENVCESTADO = ? ");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE);
				}

				// no tendra PEE
				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE)) {
					where.append(" AND t3.ENVCESTADO = ? ");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE);
				}

				// SITUACION CORREOS
				if (remesa.getRmsituacioncorreos() != null
						&& !(remesa.getRmsituacioncorreos()
								.equalsIgnoreCase(Y41bConstantes.REMESAS_SITUACIONCORREOS_OTROS))) {
					where.append(" AND UPPER(t3.ENVCCOD_SIT_CORREOS) like ? ESCAPE  '\\'");
					if (startsWith) {
						params.add(remesa.getRmsituacioncorreos().toUpperCase()
								+ "%");
					} else {
						params.add("%"
								+ remesa.getRmsituacioncorreos().toUpperCase()
								+ "%");
					}
				}

				if (remesa.getRmsituacioncorreos() != null
						&& remesa.getRmsituacioncorreos().equalsIgnoreCase(
								Y41bConstantes.REMESAS_SITUACIONCORREOS_OTROS)) {
					where.append(" AND t3.ENVCCOD_SIT_CORREOS NOT IN (SELECT COD_SIT_CORREOS FROM SITUACION_Y41B_CON_CORREOS) ");
				}

				// SITUACION ACUSE
				if (remesa.getRmsituacionacuse() != null
						&& !(remesa.getRmsituacionacuse()
								.equalsIgnoreCase(Y41bConstantes.REMESAS_SITUACIONACUSE_SINSITUACION))) {
					where.append(" AND UPPER(t5.EHACUSERECIBORECIBIDO) like ? ESCAPE  '\\'");
					if (startsWith) {
						params.add(remesa.getRmsituacionacuse().toUpperCase()
								+ "%");
					} else {
						params.add("%"
								+ remesa.getRmsituacionacuse().toUpperCase()
								+ "%");
					}
				}

				if (remesa.getRmsituacionacuse() != null
						&& remesa
								.getRmsituacionacuse()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_SITUACIONACUSE_SINSITUACION)) {
					where.append(" AND t5.EHACUSERECIBORECIBIDO IS NULL ");
				}

				// ESTADO ACUSE
				if (remesa.getRmestadoacuse() != null
						&& remesa.getRmestadoacuse().equals(
								Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					where.append(" AND t4.EHESTADOTRAMITE = ? ");
					params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				}

				if (remesa.getRmestadoacuse() != null
						&& !(remesa.getRmestadoacuse()
								.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO))) {
					where.append(" AND (t4.EHESTADOTRAMITE <> ? OR t4.EHESTADOTRAMITE IS NULL)");
					params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				}

			}

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Remesa entity
	 * 
	 * @param remesa
	 *            Remesa Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereLikeMapExcel(RemesaBusqueda remesa,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RemesaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		if (remesa != null) {
			if (remesa.getRmcodigo() != null) {
				where.append(" AND UPPER(RMCODIGO) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(remesa.getRmcodigo().toUpperCase() + "%");
				} else {
					params.add("%" + remesa.getRmcodigo().toUpperCase() + "%");
				}
				where.append(" AND RMCODIGO IS NOT NULL");
			}
			if (remesa.getRmtipo() != null) {
				where.append(" AND RMTIPO = ? ");
				params.add(remesa.getRmtipo());
			}
			// fecha registro desde
			if (remesa.getRmfechageneracionDesde() != null) {
				where.append(" AND TO_CHAR(RMFECHAGENERACION, 'YYYYMMDD') >= TO_CHAR(?, 'YYYYMMDD')");
				params.add(remesa.getRmfechageneracionDesde());
			}
			// fecha registro hasta
			if (remesa.getRmfechageneracionHasta() != null) {
				where.append(" AND TO_CHAR(RMFECHAGENERACION, 'YYYYMMDD') <= TO_CHAR(?, 'YYYYMMDD')");
				params.add(remesa.getRmfechageneracionHasta());
			}

			if (remesa.getRmcomo() != null) {
				where.append(" AND RMCOMO = ? ");
				params.add(remesa.getRmcomo());
			}

			if (remesa.getRmcodorg() != null) {
				where.append(" AND JOKERCOOR = ? ");
				params.add(remesa.getRmcodorg());
			}

			if (remesa.getRmtipoexpediente() != null) {
				where.append(" AND RMTIPOPROC = ? ");
				params.add(remesa.getRmtipoexpediente());
			}

			if (remesa.getRmestado() != null) {
				where.append(" AND RMESTADO = ? ");
				params.add(remesa.getRmestado());
			}

			if (remesa.getRmestado() == null) {
				if (remesa.getRmcheckcerradas() != null
						&& remesa.getRmcheckcerradas().equalsIgnoreCase(
								Y41bConstantes.VALOR_NO)) {
					where.append(" AND RMESTADO <> '")
							.append(Y41bConstantes.ESTADO_REMESA_CERRADA)
							.append("'");
				}
			}

			if (remesa.getRmtipo() != null
					&& remesa.getRmtipo().equalsIgnoreCase(
							Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

				// fecha act envio desde
				if (remesa.getRmFechaActEnvDesde() != null) {
					where.append(" AND TO_CHAR(ENVFECHAACTUALIZACION, 'YYYYMMDD') >= TO_CHAR(?, 'YYYYMMDD')");
					params.add(remesa.getRmFechaActEnvDesde());
				}
				// fecha act envio hasta
				if (remesa.getRmFechaActEnvHasta() != null) {
					where.append(" AND TO_CHAR(ENVFECHAACTUALIZACION, 'YYYYMMDD') <= TO_CHAR(?, 'YYYYMMDD')");
					params.add(remesa.getRmFechaActEnvHasta());
				}

				// estado envio

				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_SINACTUALIZAR)) {
					where.append(" AND ENVFECHAACTUALIZACION IS NULL");
				}

				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_SINESTADO)) {
					where.append(" AND ENVCESTADO IS NULL AND ENVFECHAACTUALIZACION IS NOT NULL");
				}

				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_ERRONEO)) {
					where.append(" AND ENVCESTADO = ?");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_ERRONEO);
				}

				// con pee
				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOS)) {
					where.append(" AND ENVCESTADO = ? ");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOS);
				}

				// tendra PEE a la espera de el
				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE)) {
					where.append(" AND ENVCESTADO = ? ");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE);
				}

				// no tendra PEE
				if (remesa.getRmestadoenvio() != null
						&& remesa
								.getRmestadoenvio()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE)) {
					where.append(" AND ENVCESTADO = ? ");
					params.add(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE);
				}

				// SITUACION CORREOS
				if (remesa.getRmsituacioncorreos() != null
						&& !(remesa.getRmsituacioncorreos()
								.equalsIgnoreCase(Y41bConstantes.REMESAS_SITUACIONCORREOS_OTROS))) {
					where.append(" AND ENVCCODSITCORREOS = ? ");
					params.add(remesa.getRmsituacioncorreos());
				}

				if (remesa.getRmsituacioncorreos() != null
						&& remesa.getRmsituacioncorreos().equalsIgnoreCase(
								Y41bConstantes.REMESAS_SITUACIONCORREOS_OTROS)) {
					where.append(" AND ENVCCODSITCORREOS NOT IN (SELECT COD_SIT_CORREOS FROM SITUACION_Y41B_CON_CORREOS) ");
				}

				// SITUACION ACUSE
				if (remesa.getRmsituacionacuse() != null
						&& !(remesa.getRmsituacionacuse()
								.equalsIgnoreCase(Y41bConstantes.REMESAS_SITUACIONACUSE_SINSITUACION))) {
					where.append(" AND EHACUSERECIBORECIBIDO = ? ");
					params.add(remesa.getRmsituacionacuse());
				}

				if (remesa.getRmsituacionacuse() != null
						&& remesa
								.getRmsituacionacuse()
								.equalsIgnoreCase(
										Y41bConstantes.REMESAS_SITUACIONACUSE_SINSITUACION)) {
					where.append(" AND EHACUSERECIBORECIBIDO IS NULL ");
				}

				// ESTADO ACUSE
				if (remesa.getRmestadoacuse() != null
						&& remesa.getRmestadoacuse().equals(
								Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					where.append(" AND EHESTADOTRAMITE = ? ");
					params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				}

				if (remesa.getRmestadoacuse() != null
						&& !(remesa.getRmestadoacuse()
								.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO))) {
					where.append(" AND (EHESTADOTRAMITE <> ? OR EHESTADOTRAMITE IS NULL)");
					params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				}

			}

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/*
	 * String
	 * 
	 * Devuelve un cdigo nuevo de Remesa utilizando la tabla Remesa_Secuencias.
	 * 
	 * @return String
	 */
	public String getIdRemesa() {
		StringBuilder query = new StringBuilder(
				"SELECT MAX(RMSNUMSEC) NUMSEC FROM REMESA_SECUENCIAS");

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		// where.append(mapaWhere.get("query"));
		where.append(" AND RMSANO = ?");
		List<Object> params = new ArrayList<Object>();
		params.add(Calendar.getInstance().get(Calendar.YEAR));
		query.append(where);

		// List<?> params = (List<?>) mapaWhere.get("params");
		Long numSecuencia = this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
		if (numSecuencia != null) {
			numSecuencia = numSecuencia + Y41bConstantes.NUM_1;
		} else {
			numSecuencia = Long.parseLong(Y41bConstantes.NUM_1 + "");
		}

		// insertar con un numero de secuencia siguiente
		String queryInsert = "INSERT INTO REMESA_SECUENCIAS (RMSANO, RMSNUMSEC) VALUES (?,?)";
		this.jdbcTemplate.update(queryInsert,
				Calendar.getInstance().get(Calendar.YEAR), numSecuencia);
		return ""
				+ Calendar.getInstance().get(Calendar.YEAR)
				+ "-"
				+ StringUtils.leftPad("" + numSecuencia, Y41bConstantes.NUM_4,
						"0");

	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public Remesa findBlobTablaRemesas(String codRemesa) {
		try {
			String query = "SELECT RMCODIGO, RMDATAFILE , RMLISTADOFILE, RMACUSESFILE, NULL RMFECHA"
					+ " FROM REMESA T1 WHERE RMCODIGO= ?";

			List<Remesa> listRemesas = this.jdbcTemplate.query(
					query.toString(), new RowMapper<Remesa>() {
						public Remesa mapRow(ResultSet resultSet, int rowNum)
								throws SQLException {
							return new Remesa(resultSet.getString("RMCODIGO"),
									resultSet.getBlob("RMDATAFILE"), resultSet
											.getBlob("RMLISTADOFILE"),
									resultSet.getBlob("RMACUSESFILE"));
						}
					}, codRemesa);
			return (Remesa) DataAccessUtils.uniqueResult(listRemesas);
		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasPendientes(RemesaBusqueda remesa,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(getSelectQuery()
				+ getAA66SelectQuery());
		query.append("FROM REMESA t1, CENSO_MONITOR t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereAllRemesasPendientesMap(remesa);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.RMCOMO = t2.MOCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapAA66, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Remesa entity
	 * 
	 * @param remesa
	 *            Remesa Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereAllRemesasPendientesMap(RemesaBusqueda remesa) {

		StringBuilder where = new StringBuilder(
				RemesaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND (t1.RMESTADO = ?");
		params.add(Y41bConstantes.ESTADO_REMESA_EMITIDA);
		where.append(" OR t1.RMESTADO = ?)");
		params.add(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS);

		where.append(" AND t1.RMTIPO = ?");
		params.add(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA);

		// J-17/01
		where.append(" AND ((SYSDATE - RMFECHAEMISION)>= (select VALOR from PARAMETROS where PARAMETRO LIKE ?) OR RMFECHAEMISION IS NULL) ");
		params.add(Y41bConstantes.AA66_DIAS_DE_ESPERA_CONSULTA);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private String getDescripcionMaxima1000(String descripcion) {
		return descripcion == null ? ""
				: descripcion.length() <= 1000 ? descripcion : descripcion
						.substring(0, 999);
	}

	/**
	 * Finds a List of rows in the SituacionCorreos table.
	 * 
	 * @param situacionCorreos
	 *            SituacionCorreos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<SituacionCorreos> findAllSituacionCorreos(
			SituacionCorreos situacionCorreos, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_SIT_CORREOS CODSITCORREOS,t1.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO,t1.SITCONPEE SITCONPEE ,t1.DESC_SIT_CORREOS_ES DESC_SIT_CORREOS_ES, t1.DESC_SIT_CORREOS_EU DESC_SIT_CORREOS_EU "
						+ "FROM SITUACION_Y41B_CON_CORREOS t1 ");
		if (situacionCorreos != null
				&& situacionCorreos.getCodSitCorreos() != null) {
			where.append(" AND t1.CODSITCORREOS = ?");
			params.add(situacionCorreos.getCodSitCorreos());
		}
		if (situacionCorreos != null
				&& situacionCorreos.getEhAcuseReciboRecibido() != null) {
			where.append(" AND t1.EHACUSERECIBORECIBIDO = ?");
			params.add(situacionCorreos.getEhAcuseReciboRecibido());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<SituacionCorreos>) this.jdbcTemplate.query(
				query.toString(), rwMapSituacionCorreos, params.toArray());
	}

	// /**
	// * Finds rows in the Remesa table using like.
	// *
	// * @param remesa
	// * Remesa
	// * @param pagination
	// * Pagination
	// * @param startsWith
	// * Boolean
	// * @return List
	// */
	// @Transactional(readOnly = true)
	// public List<Remesa> findAllRemesasLikeExcel(RemesaBusqueda remesa,
	// Pagination pagination, Boolean startsWith) {
	// StringBuilder query = new StringBuilder(getSelectQuery()
	// + getAA66SelectQuery() + getEnvioSelectQuery());
	// query.append("FROM REMESA t1, CENSO_MONITOR t2, ENVIOS_POR_REMESA t3, TRAMITE_HECHO t4 , SITUACION_Y41B_CON_CORREOS t5, DENUNCIA t6, HECHO_DENUNCIADO t7, INTERVINIENTES t8, TRAMITE_HECHO t9 , DECISION_HECHO t10, ORGANISMO t11, TIPO_PROCEDIMIENTO t12 ");
	// // Where clause & Params
	// Map<String, ?> mapaWhere = this.getWhereLikeMap(remesa, startsWith);
	// StringBuilder where = new StringBuilder(" WHERE 1=1 ");
	// where.append(" AND t1.RMCOMO = t2.MOCODIGO ");
	// where.append(" AND t1.RMCODIGO = t4.EHCODREM(+)  ");
	// where.append(" AND t4.EHCODIGO = t3.EHCODIGO(+)");
	// where.append(" AND t4.EHIDDESTINATARIO= t8.IDINTERVINIENTE(+)");
	// where.append(" AND t4.EHCOHD= t7.HDCODIGO(+)");
	// where.append(" AND t7.HDCODE= t6.DECODIGO(+)");
	// where.append(" AND t7.HDCODIGO = t10.HCCOHD(+)");
	// where.append(" AND t10.HCCOOR = t11.COD_ORG(+)");
	// where.append(" AND t4.EHCODIGO = t9.EHCODIGORELACIONADO(+)");
	// where.append(" AND t9.EHCOTEE(+) = '"
	// + Y41bConstantes.TRAMITE_ACUSE_RECIBO + "'");
	// where.append(" AND t3.ENVCCOD_SIT_CORREOS = t5.COD_SIT_CORREOS(+) ");
	// where.append(" AND t1.RMTIPOPROC = t12.PCODIGO ");
	//
	// where.append(mapaWhere.get("query"));
	// query.append(where);
	//
	// List<?> params = (List<?>) mapaWhere.get("params");
	//
	// if (pagination != null) {
	// query = pagination.getPaginationQuery(query);
	// }
	//
	// return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
	// this.rwMapExcel, params.toArray());
	// }
	// }

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeExcelSol(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT ");
		query.append("RMCODIGO, RMTIPO, RMESTADO, RMCODPLANTCARATULA, RMCODPLANTACUSE,RMCODPLANTLISTADO, RMFECHAGENERACION, RMFECHAEMISION, RMCOMO, RMTIPOPROC, RMFECHAACTUALIZACION, RMFECHA_ENVIOMASRECIENTE, RMIDCOLECCIONAA66, RMCODCOLECCIONAA66"
				+ ", RMIDREMESAAA66, RMCODREMESAAA66, RMDESDESREMESA, RMDESMOTREMES, RMDESMOTREMEU, RMDESERRORES, RMDESERROREU, IDTRAMITE, JOKERCOOR, JOKERRAN, JOKERROR, JOKERCODIGO, ENVCCOMOEJECUCION, MONOMBRE"
				+ ", EHTIPONOTIFICACIONPLATEA, EHIDDESTINATARIO, NIF, NOMBREDESTINATARIO, NOMBRECP, NOMBREPROVINCIA, NOMBREMUNICIPIO, EHFECHAINICIO, ENVCESTADO, ENVCCODSITCORREOS, ENVCDESSITCORREOSES, ENVCDESSITCORREOSEU"
				+ ", EHACUSERECIBORECIBIDO, EHESTADOTRAMITE, CODSITCORREOS, DESCSITCORREOSES, DESCSITCORREOSEU	, ENVCIDENVIO, ENVCCODENVIO, ENVCCODBARRAS, ENVCDESERRORES, ENVCDESERROREU, ENVFECHAACTUALIZACION, PCODIGO"
				+ ", PNOMBRE, PNOMBREE");

		query.append(" FROM REMESASENVIOSVISTASOL ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapExcel, params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeExcelIns(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT ");
		query.append("RMCODIGO, RMTIPO, RMESTADO, RMCODPLANTCARATULA, RMCODPLANTACUSE,RMCODPLANTLISTADO, RMFECHAGENERACION, RMFECHAEMISION, RMCOMO, RMTIPOPROC, RMFECHAACTUALIZACION, RMFECHA_ENVIOMASRECIENTE, RMIDCOLECCIONAA66, RMCODCOLECCIONAA66"
				+ ", RMIDREMESAAA66, RMCODREMESAAA66, RMDESDESREMESA, RMDESMOTREMES, RMDESMOTREMEU, RMDESERRORES, RMDESERROREU, IDTRAMITE, JOKERCOOR, JOKERRAN, JOKERROR, JOKERCODIGO, ENVCCOMOEJECUCION, MONOMBRE"
				+ ", EHTIPONOTIFICACIONPLATEA, EHIDDESTINATARIO, NIF, NOMBREDESTINATARIO, NOMBRECP, NOMBREPROVINCIA, NOMBREMUNICIPIO, EHFECHAINICIO, ENVCESTADO, ENVCCODSITCORREOS, ENVCDESSITCORREOSES, ENVCDESSITCORREOSEU"
				+ ", EHACUSERECIBORECIBIDO, EHESTADOTRAMITE, CODSITCORREOS, DESCSITCORREOSES, DESCSITCORREOSEU	, ENVCIDENVIO, ENVCCODENVIO, ENVCCODBARRAS, ENVCDESERRORES, ENVCDESERROREU, ENVFECHAACTUALIZACION, PCODIGO"
				+ ", PNOMBRE, PNOMBREE");

		query.append(" FROM REMESASENVIOSVISTAINS ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapExcel, params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeExcelSan(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT ");
		query.append("RMCODIGO, RMTIPO, RMESTADO, RMCODPLANTCARATULA, RMCODPLANTACUSE,RMCODPLANTLISTADO, RMFECHAGENERACION, RMFECHAEMISION, RMCOMO, RMTIPOPROC, RMFECHAACTUALIZACION, RMFECHA_ENVIOMASRECIENTE, RMIDCOLECCIONAA66, RMCODCOLECCIONAA66"
				+ ", RMIDREMESAAA66, RMCODREMESAAA66, RMDESDESREMESA, RMDESMOTREMES, RMDESMOTREMEU, RMDESERRORES, RMDESERROREU, IDTRAMITE, JOKERCOOR, JOKERRAN, JOKERROR, JOKERCODIGO, ENVCCOMOEJECUCION, MONOMBRE"
				+ ", EHTIPONOTIFICACIONPLATEA, EHIDDESTINATARIO, NIF, NOMBREDESTINATARIO, NOMBRECP, NOMBREPROVINCIA, NOMBREMUNICIPIO, EHFECHAINICIO, ENVCESTADO, ENVCCODSITCORREOS, ENVCDESSITCORREOSES, ENVCDESSITCORREOSEU"
				+ ", EHACUSERECIBORECIBIDO, EHESTADOTRAMITE, CODSITCORREOS, DESCSITCORREOSES, DESCSITCORREOSEU	, ENVCIDENVIO, ENVCCODENVIO, ENVCCODBARRAS, ENVCDESERRORES, ENVCDESERROREU, ENVFECHAACTUALIZACION, PCODIGO"
				+ ", PNOMBRE, PNOMBREE");

		query.append(" FROM REMESASENVIOSVISTASAN ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapExcel, params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeExcelArb(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT ");
		query.append("RMCODIGO, RMTIPO, RMESTADO, RMCODPLANTCARATULA, RMCODPLANTACUSE,RMCODPLANTLISTADO, RMFECHAGENERACION, RMFECHAEMISION, RMCOMO, RMTIPOPROC, RMFECHAACTUALIZACION, RMFECHA_ENVIOMASRECIENTE, RMIDCOLECCIONAA66, RMCODCOLECCIONAA66"
				+ ", RMIDREMESAAA66, RMCODREMESAAA66, RMDESDESREMESA, RMDESMOTREMES, RMDESMOTREMEU, RMDESERRORES, RMDESERROREU, IDTRAMITE, JOKERCOOR, JOKERRAN, JOKERROR, JOKERCODIGO, ENVCCOMOEJECUCION, MONOMBRE"
				+ ", EHTIPONOTIFICACIONPLATEA, EHIDDESTINATARIO, NIF, NOMBREDESTINATARIO, NOMBRECP, NOMBREPROVINCIA, NOMBREMUNICIPIO, EHFECHAINICIO, ENVCESTADO, ENVCCODSITCORREOS, ENVCDESSITCORREOSES, ENVCDESSITCORREOSEU"
				+ ", EHACUSERECIBORECIBIDO, EHESTADOTRAMITE, CODSITCORREOS, DESCSITCORREOSES, DESCSITCORREOSEU	, ENVCIDENVIO, ENVCCODENVIO, ENVCCODBARRAS, ENVCDESERRORES, ENVCDESERROREU, ENVFECHAACTUALIZACION, PCODIGO"
				+ ", PNOMBRE, PNOMBREE");

		query.append(" FROM REMESASENVIOSVISTAARB ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapExcel, params.toArray());
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Remesa> findAllRemesasLikeExcelArbAdh(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT ");
		query.append("RMCODIGO, RMTIPO, RMESTADO, RMCODPLANTCARATULA, RMCODPLANTACUSE,RMCODPLANTLISTADO, RMFECHAGENERACION, RMFECHAEMISION, RMCOMO, RMTIPOPROC, RMFECHAACTUALIZACION, RMFECHA_ENVIOMASRECIENTE, RMIDCOLECCIONAA66, RMCODCOLECCIONAA66"
				+ ", RMIDREMESAAA66, RMCODREMESAAA66, RMDESDESREMESA, RMDESMOTREMES, RMDESMOTREMEU, RMDESERRORES, RMDESERROREU, IDTRAMITE, JOKERCOOR, JOKERRAN, JOKERROR, JOKERCODIGO, ENVCCOMOEJECUCION, MONOMBRE"
				+ ", EHTIPONOTIFICACIONPLATEA, EHIDDESTINATARIO, NIF, NOMBREDESTINATARIO, NOMBRECP, NOMBREPROVINCIA, NOMBREMUNICIPIO, EHFECHAINICIO, ENVCESTADO, ENVCCODSITCORREOS, ENVCDESSITCORREOSES, ENVCDESSITCORREOSEU"
				+ ", EHACUSERECIBORECIBIDO, EHESTADOTRAMITE, CODSITCORREOS, DESCSITCORREOSES, DESCSITCORREOSEU	, ENVCIDENVIO, ENVCCODENVIO, ENVCCODBARRAS, ENVCDESERRORES, ENVCDESERROREU, ENVFECHAACTUALIZACION, PCODIGO"
				+ ", PNOMBRE, PNOMBREE");

		query.append(" FROM REMESASENVIOSVISTAARBADH ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMapExcel(remesa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Remesa>) this.jdbcTemplate.query(query.toString(),
				this.rwMapExcel, params.toArray());
	}
}
