package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.SituacionCorreos;

/**
 * RemesaDao  
 * 
 *  
 */

public interface RemesaDao {

	/**
	 * Inserts a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa add(Remesa remesa);

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa updateDatosGeneracion(Remesa remesa);

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa updateEstadoRemesa(Remesa remesa);

	/**
	 * Finds a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa find(Remesa remesa);

	/**
	 * Deletes a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return
	 */
	void remove(Remesa remesa);

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Remesa> findAll(Remesa remesa, Pagination pagination);

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Long
	 */
	Long findAllCount(Remesa remesa);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Remesa> findAllLike(Remesa remesa, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Remesa remesa, Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeVistaSol(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllRemesasLikeVistaSolCount(RemesaBusqueda remesa,
			Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeVistaIns(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllRemesasLikeVistaInsCount(RemesaBusqueda remesa,
			Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeVistaSan(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllRemesasLikeVistaSanCount(RemesaBusqueda remesa,
			Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeVistaArb(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllRemesasLikeVistaArbCount(RemesaBusqueda remesa,
			Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeVistaArbAdh(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllRemesasLikeVistaArbAdhCount(RemesaBusqueda remesa,
			Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Remesa> findAllRemesasLike(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeRemesasCount(RemesaBusqueda remesa, Boolean startsWith);

	/**
	 * Devuelve un cdigo nuevo de Remesa utilizando la tabla Remesa_Secuencias.
	 * 
	 * 
	 * @return String
	 */
	public String getIdRemesa();

	Remesa update(Remesa remesa);

	void cerrarRemesa(Remesa remesa);

	Remesa updateEstadoRemesaErronea(Remesa remesa, String tipoError);

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Pagination
	 * @return Remesa
	 */
	public Remesa updateFechaActualizacionRemesa(Remesa remesa);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Remesa> findAllRemesasPendientes(RemesaBusqueda remesa,
			Pagination pagination);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public Remesa findBlobTablaRemesas(String codRemesa);

	/**
	 * Finds a List of rows in the SituacionCorreos table.
	 * 
	 * @param situacionCorreos
	 *            SituacionCorreos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<SituacionCorreos> findAllSituacionCorreos(
			SituacionCorreos situacionCorreos, Pagination pagination);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcelSol(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcelIns(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcelSan(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcelArb(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcelArbAdh(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);
}
