package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sancuesfondo;
import com.ejie.y41b.model.Sancuesproced;
import com.ejie.y41b.model.Sanrecrca;
import com.ejie.y41b.model.Sanresulsen;
import com.ejie.y41b.model.Tribunal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Recurso;

/**
 * RecursoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RecursoDaoImpl implements RecursoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Recurso> rwMap = new RowMapper<Recurso>() {
		public Recurso mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Recurso(
					resultSet.getString("RECODIGO"),
					resultSet.getDate("REFEREOR"),
					resultSet.getDate("REFERENP"),
					resultSet.getDate("REFEPRRO"),
					resultSet.getDate("REFENRO1"),
					resultSet.getDate("REFERERO"),
					resultSet.getString("RECOOS"),
					resultSet.getDate("REFENRRO"),
					resultSet.getString("RECOTTRO"),
					resultSet.getBigDecimal("RECAMRRO"),
					resultSet.getDate("REFERERE"),
					resultSet.getString("RECOMORR"),
					resultSet.getDate("REFEPRRR"),
					resultSet.getDate("REFENRR1"),
					resultSet.getDate("REFERERR"),
					resultSet.getString("RECOOSRR"),
					resultSet.getDate("REFENRRR"),
					resultSet.getString("RECOTTRR"),
					resultSet.getBigDecimal("RECAMRRR"),
					resultSet.getDate("REFECOLM"),
					resultSet.getString("RENUINLM"),
					resultSet.getDate("REFEINMU"),
					resultSet.getDate("REFEAVMU"),
					resultSet.getDate("REFEIMCD"),
					resultSet.getDate("REFECEDE"),
					resultSet.getString("RENRORRC"),
					resultSet.getBigDecimal("RENRANRC"),
					resultSet.getString("RECOTRRC"),
					resultSet.getDate("REFEINRC"),
					resultSet.getDate("REFENORC"),
					resultSet.getDate("REFERSET"),
					resultSet.getDate("REFESERC"),
					resultSet.getBigDecimal("RECAMURC"),
					resultSet.getString("RECOTIFA"),
					resultSet.getDate("REFEPOCS"),
					resultSet.getString("REINRETS"),
					resultSet.getString("RECOOR"),
					new Expedien(resultSet.getString("ExpedienEXCODIGO"),
							resultSet.getString("ExpedienEXCOOR"), resultSet
									.getBigDecimal("ExpedienEXNRAN"), resultSet
									.getBigDecimal("ExpedienEXNROR"), resultSet
									.getDate("ExpedienEXFERE"), resultSet
									.getString("ExpedienEXCOIT"), resultSet
									.getString("ExpedienEXCOES"), resultSet
									.getDate("ExpedienEXFEACIN"), resultSet
									.getDate("ExpedienEXFEEMCA"), resultSet
									.getDate("ExpedienEXFEPLCA"), resultSet
									.getDate("ExpedienEXFPNOPC"), resultSet
									.getDate("ExpedienEXFEDE"), resultSet
									.getDate("ExpedienEXFECOAL"), resultSet
									.getDate("ExpedienEXFENOPR"), resultSet
									.getDate("ExpedienEXFEPUPR"), resultSet
									.getString("ExpedienEXCOOSPR"), resultSet
									.getDate("ExpedienEXFEALPR"), resultSet
									.getDate("ExpedienEXFEEL"), resultSet
									.getDate("ExpedienEXFERES"), resultSet
									.getDate("ExpedienEXFENORE"), resultSet
									.getDate("ExpedienEXFEPURE"), resultSet
									.getString("ExpedienEXCOOSRE"), resultSet
									.getString("ExpedienEXCOTTR"), resultSet
									.getBigDecimal("ExpedienEXCAMURE"),
							resultSet.getDate("ExpedienEXFETA"), resultSet
									.getString("ExpedienEXCOTSA"), resultSet
									.getDate("ExpedienEXFECROI"), resultSet
									.getDate("ExpedienEXFEAR"), resultSet
									.getString("ExpedienEXCOORIE"), resultSet
									.getString("ExpedienEXINRE"), resultSet
									.getString("ExpedienEXINCOCO"), resultSet
									.getString("ExpedienEXINEXVA"), resultSet
									.getDate("ExpedienEXFECIRC"), resultSet
									.getDate("ExpedienEXFENOAI"), resultSet
									.getDate("ExpedienEXFECOLM"), resultSet
									.getString("ExpedienEXNUINLM"), resultSet
									.getDate("ExpedienEXFEINMU"), resultSet
									.getDate("ExpedienEXFEAVMU"), resultSet
									.getDate("ExpedienEXFEIMCD"), resultSet
									.getDate("ExpedienEXFECEDE"), resultSet
									.getString("ExpedienEXCOPS"), resultSet
									.getString("ExpedienEXCOSE"), null, null,
							null, null),
					new Sanrecrca(
							resultSet.getString("SanrecrcaRECODIGO"),
							resultSet.getDate("SanrecrcaRERCAFECENV"),
							resultSet.getString("SanrecrcaRERCANUMSEN"),
							new Sanresulsen(resultSet
									.getString("SanrecrcaRERCASEN"), null,
									null, null, null, null, null),
							new Tribunal(resultSet
									.getString("SanrecrcaRERCATRIB"), null,
									null),
							resultSet.getString("SanrecrcaRERCASALA"),
							resultSet.getString("SanrecrcaRERCAACUE"),
							resultSet.getDate("SanrecrcaRERCAFECDEV"),
							resultSet.getBigDecimal("SanrecrcaRERCAIMPDEV") == null ? null
									: resultSet.getBigDecimal(
											"SanrecrcaRERCAIMPDEV").toString(),
							resultSet.getString("SanrecrcaRERCAABO"), resultSet
									.getString("SanrecrcaRERCANOTA"), resultSet
									.getDate("SanrecrcaREFECALTA"), resultSet
									.getDate("SanrecrcaREFECMODIF"), resultSet
									.getString("SanrecrcaREUSUALTA"), resultSet
									.getString("SanrecrcaREUSUMODIF"),
							new Sancuesfondo(resultSet
									.getString("SanrecrcaRERCACFON"), null,
									null, null, null, null, null, null),
							new Sancuesproced(resultSet
									.getString("SanrecrcaRERCACPROC"), null,
									null, null, null, null, null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Pagination
	 * @return Recurso
	 */
	public Recurso add(Recurso recurso) {
		String query = "INSERT INTO RECURSO (RECODIGO, RECOEX, REFEREOR, REFERENP, REFEPRRO, REFENRO1, REFERERO, RECOOS, REFENRRO, RECOTTRO, RECAMRRO, REFERERE, RECOMORR, REFEPRRR, REFENRR1, REFERERR, RECOOSRR, REFENRRR, RECOTTRR, RECAMRRR, REFECOLM, RENUINLM, REFEINMU, REFEAVMU, REFEIMCD, REFECEDE, RENRORRC, RENRANRC, RECOTRRC, REFEINRC, REFENORC, REFERSET, REFESERC, RECAMURC, RECOTIFA, REFEPOCS, REINRETS, RECOOR) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getExpedienExcodigoAux = null;
		if (recurso.getExpedien() != null
				&& recurso.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = recurso.getExpedien().getExcodigo();
		}
		this.jdbcTemplate.update(query, recurso.getRecodigo(),
				getExpedienExcodigoAux, recurso.getRefereor(),
				recurso.getReferenp(), recurso.getRefeprro(),
				recurso.getRefenro1(), recurso.getReferero(),
				recurso.getRecoos(), recurso.getRefenrro(),
				recurso.getRecottro(), recurso.getRecamrro(),
				recurso.getReferere(), recurso.getRecomorr(),
				recurso.getRefeprrr(), recurso.getRefenrr1(),
				recurso.getRefererr(), recurso.getRecoosrr(),
				recurso.getRefenrrr(), recurso.getRecottrr(),
				recurso.getRecamrrr(), recurso.getRefecolm(),
				recurso.getRenuinlm(), recurso.getRefeinmu(),
				recurso.getRefeavmu(), recurso.getRefeimcd(),
				recurso.getRefecede(), recurso.getRenrorrc(),
				recurso.getRenranrc(), recurso.getRecotrrc(),
				recurso.getRefeinrc(), recurso.getRefenorc(),
				recurso.getReferset(), recurso.getRefeserc(),
				recurso.getRecamurc(), recurso.getRecotifa(),
				recurso.getRefepocs(), recurso.getReinrets(),
				recurso.getRecoor());
		return recurso;
	}

	/**
	 * Updates a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Pagination
	 * @return Recurso
	 */
	public Recurso update(Recurso recurso) {
		String query = "UPDATE RECURSO SET RECOEX=?, REFEREOR=?, REFERENP=?, REFEPRRO=?, REFENRO1=?, REFERERO=?, RECOOS=?, REFENRRO=?, RECOTTRO=?, RECAMRRO=?, REFERERE=?, RECOMORR=?, REFEPRRR=?, REFENRR1=?, REFERERR=?, RECOOSRR=?, REFENRRR=?, RECOTTRR=?, RECAMRRR=?, REFECOLM=?, RENUINLM=?, REFEINMU=?, REFEAVMU=?, REFEIMCD=?, REFECEDE=?, RENRORRC=?, RENRANRC=?, RECOTRRC=?, REFEINRC=?, REFENORC=?, REFERSET=?, REFESERC=?, RECAMURC=?, RECOTIFA=?, REFEPOCS=?, REINRETS=?, RECOOR=? WHERE RECODIGO=?";
		Object getExpedienExcodigoAux = null;
		if (recurso.getExpedien() != null
				&& recurso.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = recurso.getExpedien().getExcodigo();
		}
		this.jdbcTemplate.update(query, getExpedienExcodigoAux,
				recurso.getRefereor(), recurso.getReferenp(),
				recurso.getRefeprro(), recurso.getRefenro1(),
				recurso.getReferero(), recurso.getRecoos(),
				recurso.getRefenrro(), recurso.getRecottro(),
				recurso.getRecamrro(), recurso.getReferere(),
				recurso.getRecomorr(), recurso.getRefeprrr(),
				recurso.getRefenrr1(), recurso.getRefererr(),
				recurso.getRecoosrr(), recurso.getRefenrrr(),
				recurso.getRecottrr(), recurso.getRecamrrr(),
				recurso.getRefecolm(), recurso.getRenuinlm(),
				recurso.getRefeinmu(), recurso.getRefeavmu(),
				recurso.getRefeimcd(), recurso.getRefecede(),
				recurso.getRenrorrc(), recurso.getRenranrc(),
				recurso.getRecotrrc(), recurso.getRefeinrc(),
				recurso.getRefenorc(), recurso.getReferset(),
				recurso.getRefeserc(), recurso.getRecamurc(),
				recurso.getRecotifa(), recurso.getRefepocs(),
				recurso.getReinrets(), recurso.getRecoor(),
				recurso.getRecodigo());
		return recurso;
	}

	/**
	 * Finds a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Pagination
	 * @return Recurso
	 */
	@Transactional(readOnly = true)
	public Recurso find(Recurso recurso) {
		String query = "SELECT t1.RECODIGO RECODIGO, t1.REFEREOR REFEREOR, t1.REFERENP REFERENP, t1.REFEPRRO REFEPRRO, t1.REFENRO1 REFENRO1, t1.REFERERO REFERERO, t1.RECOOS RECOOS, t1.REFENRRO REFENRRO, t1.RECOTTRO RECOTTRO, t1.RECAMRRO RECAMRRO, t1.REFERERE REFERERE, t1.RECOMORR RECOMORR, t1.REFEPRRR REFEPRRR, t1.REFENRR1 REFENRR1, t1.REFERERR REFERERR, t1.RECOOSRR RECOOSRR, t1.REFENRRR REFENRRR, t1.RECOTTRR RECOTTRR, t1.RECAMRRR RECAMRRR, t1.REFECOLM REFECOLM, t1.RENUINLM RENUINLM, t1.REFEINMU REFEINMU, t1.REFEAVMU REFEAVMU, t1.REFEIMCD REFEIMCD, t1.REFECEDE REFECEDE, t1.RENRORRC RENRORRC, t1.RENRANRC RENRANRC, t1.RECOTRRC RECOTRRC, t1.REFEINRC REFEINRC, t1.REFENORC REFENORC, t1.REFERSET REFERSET, t1.REFESERC REFESERC, t1.RECAMURC RECAMURC, t1.RECOTIFA RECOTIFA, t1.REFEPOCS REFEPOCS, t1.REINRETS REINRETS, t1.RECOOR RECOOR, t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE, t3.RECODIGO SANRECRCARECODIGO, t3.RERCAFECENV SANRECRCARERCAFECENV, t3.RERCANUMSEN SANRECRCARERCANUMSEN,t3.RERCASEN SANRECRCARERCASEN, t3.RERCATRIB SANRECRCARERCATRIB, t3.RERCASALA SANRECRCARERCASALA, t3.RERCAACUE SANRECRCARERCAACUE, t3.RERCAFECDEV SANRECRCARERCAFECDEV, t3.RERCAIMPDEV SANRECRCARERCAIMPDEV, t3.RERCAABO SANRECRCARERCAABO, t3.RERCANOTA SANRECRCARERCANOTA, t3.REFECALTA SANRECRCAREFECALTA, t3.REFECMODIF SANRECRCAREFECMODIF, t3.REUSUALTA SANRECRCAREUSUALTA, t3.REUSUMODIF SANRECRCAREUSUMODIF, t3.RERCACFON SANRECRCARERCACFON, t3.RERCACPROC SANRECRCARERCACPROC FROM RECURSO t1 , EXPEDIEN t2 , SANRECRCA t3  WHERE t1.RECODIGO = ?   AND t1.RECOEX= t2.EXCODIGO(+) AND t1.RECODIGO= t3.RECODIGO(+)";

		List<Recurso> recursoList = this.jdbcTemplate.query(query, this.rwMap,
				recurso.getRecodigo());
		return (Recurso) DataAccessUtils.uniqueResult(recursoList);
	}

	/**
	 * Removes a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Pagination
	 * @return
	 */
	public void remove(Recurso recurso) {
		String query = "DELETE FROM RECURSO WHERE RECODIGO=?";
		this.jdbcTemplate.update(query, recurso.getRecodigo());
	}

	/**
	 * Finds a List of rows in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Recurso> findAll(Recurso recurso, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RECODIGO RECODIGO,t1.REFEREOR REFEREOR,t1.REFERENP REFERENP,t1.REFEPRRO REFEPRRO,t1.REFENRO1 REFENRO1,t1.REFERERO REFERERO,t1.RECOOS RECOOS,t1.REFENRRO REFENRRO,t1.RECOTTRO RECOTTRO,t1.RECAMRRO RECAMRRO,t1.REFERERE REFERERE,t1.RECOMORR RECOMORR,t1.REFEPRRR REFEPRRR,t1.REFENRR1 REFENRR1,t1.REFERERR REFERERR,t1.RECOOSRR RECOOSRR,t1.REFENRRR REFENRRR,t1.RECOTTRR RECOTTRR,t1.RECAMRRR RECAMRRR,t1.REFECOLM REFECOLM,t1.RENUINLM RENUINLM,t1.REFEINMU REFEINMU,t1.REFEAVMU REFEAVMU,t1.REFEIMCD REFEIMCD,t1.REFECEDE REFECEDE,t1.RENRORRC RENRORRC,t1.RENRANRC RENRANRC,t1.RECOTRRC RECOTRRC,t1.REFEINRC REFEINRC,t1.REFENORC REFENORC,t1.REFERSET REFERSET,t1.REFESERC REFESERC,t1.RECAMURC RECAMURC,t1.RECOTIFA RECOTIFA,t1.REFEPOCS REFEPOCS,t1.REINRETS REINRETS,t1.RECOOR RECOOR,t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.RECODIGO SANRECRCARECODIGO,t3.RERCAFECENV SANRECRCARERCAFECENV,t3.RERCANUMSEN SANRECRCARERCANUMSEN,t3.RERCASEN SANRECRCARERCASEN,t3.RERCATRIB SANRECRCARERCATRIB,t3.RERCASALA SANRECRCARERCASALA,t3.RERCAACUE SANRECRCARERCAACUE,t3.RERCAFECDEV SANRECRCARERCAFECDEV,t3.RERCAIMPDEV SANRECRCARERCAIMPDEV,t3.RERCAABO SANRECRCARERCAABO,t3.RERCANOTA SANRECRCARERCANOTA,t3.REFECALTA SANRECRCAREFECALTA,t3.REFECMODIF SANRECRCAREFECMODIF,t3.REUSUALTA SANRECRCAREUSUALTA,t3.REUSUMODIF SANRECRCAREUSUMODIF,t3.RERCACFON SANRECRCARERCACFON,t3.RERCACPROC SANRECRCARERCACPROC ");
		query.append("FROM RECURSO t1 ,EXPEDIEN t2 ,SANRECRCA t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(recurso);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RECOEX= t2.EXCODIGO(+) AND t1.RECODIGO= t3.RECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Recurso>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Recurso recurso) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM RECURSO t1 , EXPEDIEN t2 , SANRECRCA t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(recurso);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RECOEX= t2.EXCODIGO(+) AND t1.RECODIGO= t3.RECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Recurso table using like.
	 * 
	 * @param recurso
	 *            Recurso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Recurso> findAllLike(Recurso recurso, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RECODIGO RECODIGO,t1.REFEREOR REFEREOR,t1.REFERENP REFERENP,t1.REFEPRRO REFEPRRO,t1.REFENRO1 REFENRO1,t1.REFERERO REFERERO,t1.RECOOS RECOOS,t1.REFENRRO REFENRRO,t1.RECOTTRO RECOTTRO,t1.RECAMRRO RECAMRRO,t1.REFERERE REFERERE,t1.RECOMORR RECOMORR,t1.REFEPRRR REFEPRRR,t1.REFENRR1 REFENRR1,t1.REFERERR REFERERR,t1.RECOOSRR RECOOSRR,t1.REFENRRR REFENRRR,t1.RECOTTRR RECOTTRR,t1.RECAMRRR RECAMRRR,t1.REFECOLM REFECOLM,t1.RENUINLM RENUINLM,t1.REFEINMU REFEINMU,t1.REFEAVMU REFEAVMU,t1.REFEIMCD REFEIMCD,t1.REFECEDE REFECEDE,t1.RENRORRC RENRORRC,t1.RENRANRC RENRANRC,t1.RECOTRRC RECOTRRC,t1.REFEINRC REFEINRC,t1.REFENORC REFENORC,t1.REFERSET REFERSET,t1.REFESERC REFESERC,t1.RECAMURC RECAMURC,t1.RECOTIFA RECOTIFA,t1.REFEPOCS REFEPOCS,t1.REINRETS REINRETS,t1.RECOOR RECOOR,t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t3.RECODIGO SANRECRCARECODIGO,t3.RERCAFECENV SANRECRCARERCAFECENV,t3.RERCANUMSEN SANRECRCARERCANUMSEN,t3.RERCASEN SANRECRCARERCASEN,t3.RERCATRIB SANRECRCARERCATRIB,t3.RERCASALA SANRECRCARERCASALA,t3.RERCAACUE SANRECRCARERCAACUE,t3.RERCAFECDEV SANRECRCARERCAFECDEV,t3.RERCAIMPDEV SANRECRCARERCAIMPDEV,t3.RERCAABO SANRECRCARERCAABO,t3.RERCANOTA SANRECRCARERCANOTA,t3.REFECALTA SANRECRCAREFECALTA,t3.REFECMODIF SANRECRCAREFECMODIF,t3.REUSUALTA SANRECRCAREUSUALTA,t3.REUSUMODIF SANRECRCAREUSUMODIF,t3.RERCACFON SANRECRCARERCACFON,t3.RERCACPROC SANRECRCARERCACPROC ");
		query.append("FROM RECURSO t1 ,EXPEDIEN t2 ,SANRECRCA t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(recurso, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RECOEX= t2.EXCODIGO(+) AND t1.RECODIGO= t3.RECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Recurso>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Recurso table using like.
	 * 
	 * @param recurso
	 *            Recurso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Recurso recurso, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM RECURSO t1 ,EXPEDIEN t2 ,SANRECRCA t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(recurso, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RECOEX= t2.EXCODIGO(+) AND t1.RECODIGO= t3.RECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Recurso entity
	 * 
	 * @param recurso
	 *            Recurso Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Recurso recurso) {

		StringBuilder where = new StringBuilder(
				RecursoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (recurso != null && recurso.getRecodigo() != null) {
			where.append(" AND t1.RECODIGO = ?");
			params.add(recurso.getRecodigo());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(recurso.getExpedien().getExcodigo());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoor() != null) {
			where.append(" AND t2.EXCOOR = ?");
			params.add(recurso.getExpedien().getExcoor());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(recurso.getExpedien().getExnran());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(recurso.getExpedien().getExnror());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(recurso.getExpedien().getExfere());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoit() != null) {
			where.append(" AND t2.EXCOIT = ?");
			params.add(recurso.getExpedien().getExcoit());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoes() != null) {
			where.append(" AND t2.EXCOES = ?");
			params.add(recurso.getExpedien().getExcoes());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(recurso.getExpedien().getExfeacin());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(recurso.getExpedien().getExfeemca());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(recurso.getExpedien().getExfeplca());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(recurso.getExpedien().getExfpnopc());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(recurso.getExpedien().getExfede());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(recurso.getExpedien().getExfecoal());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(recurso.getExpedien().getExfenopr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(recurso.getExpedien().getExfepupr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoospr() != null) {
			where.append(" AND t2.EXCOOSPR = ?");
			params.add(recurso.getExpedien().getExcoospr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(recurso.getExpedien().getExfealpr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(recurso.getExpedien().getExfeel());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(recurso.getExpedien().getExferes());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(recurso.getExpedien().getExfenore());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(recurso.getExpedien().getExfepure());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoosre() != null) {
			where.append(" AND t2.EXCOOSRE = ?");
			params.add(recurso.getExpedien().getExcoosre());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcottr() != null) {
			where.append(" AND t2.EXCOTTR = ?");
			params.add(recurso.getExpedien().getExcottr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(recurso.getExpedien().getExcamure());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(recurso.getExpedien().getExfeta());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcotsa() != null) {
			where.append(" AND t2.EXCOTSA = ?");
			params.add(recurso.getExpedien().getExcotsa());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(recurso.getExpedien().getExfecroi());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(recurso.getExpedien().getExfear());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoorie() != null) {
			where.append(" AND t2.EXCOORIE = ?");
			params.add(recurso.getExpedien().getExcoorie());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExinre() != null) {
			where.append(" AND t2.EXINRE = ?");
			params.add(recurso.getExpedien().getExinre());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExincoco() != null) {
			where.append(" AND t2.EXINCOCO = ?");
			params.add(recurso.getExpedien().getExincoco());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExinexva() != null) {
			where.append(" AND t2.EXINEXVA = ?");
			params.add(recurso.getExpedien().getExinexva());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(recurso.getExpedien().getExfecirc());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(recurso.getExpedien().getExfenoai());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(recurso.getExpedien().getExfecolm());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExnuinlm() != null) {
			where.append(" AND t2.EXNUINLM = ?");
			params.add(recurso.getExpedien().getExnuinlm());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(recurso.getExpedien().getExfeinmu());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(recurso.getExpedien().getExfeavmu());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(recurso.getExpedien().getExfeimcd());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(recurso.getExpedien().getExfecede());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcops() != null) {
			where.append(" AND t2.EXCOPS = ?");
			params.add(recurso.getExpedien().getExcops());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcose() != null) {
			where.append(" AND t2.EXCOSE = ?");
			params.add(recurso.getExpedien().getExcose());
		}
		if (recurso != null && recurso.getRefereor() != null) {
			where.append(" AND t1.REFEREOR = ?");
			params.add(recurso.getRefereor());
		}
		if (recurso != null && recurso.getReferenp() != null) {
			where.append(" AND t1.REFERENP = ?");
			params.add(recurso.getReferenp());
		}
		if (recurso != null && recurso.getRefeprro() != null) {
			where.append(" AND t1.REFEPRRO = ?");
			params.add(recurso.getRefeprro());
		}
		if (recurso != null && recurso.getRefenro1() != null) {
			where.append(" AND t1.REFENRO1 = ?");
			params.add(recurso.getRefenro1());
		}
		if (recurso != null && recurso.getReferero() != null) {
			where.append(" AND t1.REFERERO = ?");
			params.add(recurso.getReferero());
		}
		if (recurso != null && recurso.getRecoos() != null) {
			where.append(" AND t1.RECOOS = ?");
			params.add(recurso.getRecoos());
		}
		if (recurso != null && recurso.getRefenrro() != null) {
			where.append(" AND t1.REFENRRO = ?");
			params.add(recurso.getRefenrro());
		}
		if (recurso != null && recurso.getRecottro() != null) {
			where.append(" AND t1.RECOTTRO = ?");
			params.add(recurso.getRecottro());
		}
		if (recurso != null && recurso.getRecamrro() != null) {
			where.append(" AND t1.RECAMRRO = ?");
			params.add(recurso.getRecamrro());
		}
		if (recurso != null && recurso.getReferere() != null) {
			where.append(" AND t1.REFERERE = ?");
			params.add(recurso.getReferere());
		}
		if (recurso != null && recurso.getRecomorr() != null) {
			where.append(" AND t1.RECOMORR = ?");
			params.add(recurso.getRecomorr());
		}
		if (recurso != null && recurso.getRefeprrr() != null) {
			where.append(" AND t1.REFEPRRR = ?");
			params.add(recurso.getRefeprrr());
		}
		if (recurso != null && recurso.getRefenrr1() != null) {
			where.append(" AND t1.REFENRR1 = ?");
			params.add(recurso.getRefenrr1());
		}
		if (recurso != null && recurso.getRefererr() != null) {
			where.append(" AND t1.REFERERR = ?");
			params.add(recurso.getRefererr());
		}
		if (recurso != null && recurso.getRecoosrr() != null) {
			where.append(" AND t1.RECOOSRR = ?");
			params.add(recurso.getRecoosrr());
		}
		if (recurso != null && recurso.getRefenrrr() != null) {
			where.append(" AND t1.REFENRRR = ?");
			params.add(recurso.getRefenrrr());
		}
		if (recurso != null && recurso.getRecottrr() != null) {
			where.append(" AND t1.RECOTTRR = ?");
			params.add(recurso.getRecottrr());
		}
		if (recurso != null && recurso.getRecamrrr() != null) {
			where.append(" AND t1.RECAMRRR = ?");
			params.add(recurso.getRecamrrr());
		}
		if (recurso != null && recurso.getRefecolm() != null) {
			where.append(" AND t1.REFECOLM = ?");
			params.add(recurso.getRefecolm());
		}
		if (recurso != null && recurso.getRenuinlm() != null) {
			where.append(" AND t1.RENUINLM = ?");
			params.add(recurso.getRenuinlm());
		}
		if (recurso != null && recurso.getRefeinmu() != null) {
			where.append(" AND t1.REFEINMU = ?");
			params.add(recurso.getRefeinmu());
		}
		if (recurso != null && recurso.getRefeavmu() != null) {
			where.append(" AND t1.REFEAVMU = ?");
			params.add(recurso.getRefeavmu());
		}
		if (recurso != null && recurso.getRefeimcd() != null) {
			where.append(" AND t1.REFEIMCD = ?");
			params.add(recurso.getRefeimcd());
		}
		if (recurso != null && recurso.getRefecede() != null) {
			where.append(" AND t1.REFECEDE = ?");
			params.add(recurso.getRefecede());
		}
		if (recurso != null && recurso.getRenrorrc() != null) {
			where.append(" AND t1.RENRORRC = ?");
			params.add(recurso.getRenrorrc());
		}
		if (recurso != null && recurso.getRenranrc() != null) {
			where.append(" AND t1.RENRANRC = ?");
			params.add(recurso.getRenranrc());
		}
		if (recurso != null && recurso.getRecotrrc() != null) {
			where.append(" AND t1.RECOTRRC = ?");
			params.add(recurso.getRecotrrc());
		}
		if (recurso != null && recurso.getRefeinrc() != null) {
			where.append(" AND t1.REFEINRC = ?");
			params.add(recurso.getRefeinrc());
		}
		if (recurso != null && recurso.getRefenorc() != null) {
			where.append(" AND t1.REFENORC = ?");
			params.add(recurso.getRefenorc());
		}
		if (recurso != null && recurso.getReferset() != null) {
			where.append(" AND t1.REFERSET = ?");
			params.add(recurso.getReferset());
		}
		if (recurso != null && recurso.getRefeserc() != null) {
			where.append(" AND t1.REFESERC = ?");
			params.add(recurso.getRefeserc());
		}
		if (recurso != null && recurso.getRecamurc() != null) {
			where.append(" AND t1.RECAMURC = ?");
			params.add(recurso.getRecamurc());
		}
		if (recurso != null && recurso.getRecotifa() != null) {
			where.append(" AND t1.RECOTIFA = ?");
			params.add(recurso.getRecotifa());
		}
		if (recurso != null && recurso.getRefepocs() != null) {
			where.append(" AND t1.REFEPOCS = ?");
			params.add(recurso.getRefepocs());
		}
		if (recurso != null && recurso.getReinrets() != null) {
			where.append(" AND t1.REINRETS = ?");
			params.add(recurso.getReinrets());
		}
		if (recurso != null && recurso.getRecoor() != null) {
			where.append(" AND t1.RECOOR = ?");
			params.add(recurso.getRecoor());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRecodigo() != null) {
			where.append(" AND t3.RECODIGO = ?");
			params.add(recurso.getSanrecrca().getRecodigo());
		}
		if (recurso != null
				&& recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getSancuesfondo() != null
				&& recurso.getSanrecrca().getSancuesfondo().getCfcodigo() != null) {
			where.append(" AND t3.RERCACFON = ?");
			params.add(recurso.getSanrecrca().getSancuesfondo().getCfcodigo());
		}
		if (recurso != null
				&& recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getSancuesproced() != null
				&& recurso.getSanrecrca().getSancuesproced().getCpcodigo() != null) {
			where.append(" AND t3.RERCACPROC = ?");
			params.add(recurso.getSanrecrca().getSancuesproced().getCpcodigo());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercafecenv() != null) {
			where.append(" AND t3.RERCAFECENV = ?");
			params.add(recurso.getSanrecrca().getRercafecenv());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getSanresulsen() != null
				&& recurso.getSanrecrca().getSanresulsen().getRsid() != null) {
			where.append(" AND t3.RERCASEN = ?");
			params.add(recurso.getSanrecrca().getSanresulsen().getRsid());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getTribunal() != null
				&& recurso.getSanrecrca().getTribunal().getTbcodigo() != null) {
			where.append(" AND t3.RERCATRIB = ?");
			params.add(recurso.getSanrecrca().getTribunal().getTbcodigo());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercasala() != null) {
			where.append(" AND t3.RERCASALA = ?");
			params.add(recurso.getSanrecrca().getRercasala());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercaacue() != null) {
			where.append(" AND t3.RERCAACUE = ?");
			params.add(recurso.getSanrecrca().getRercaacue());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercafecdev() != null) {
			where.append(" AND t3.RERCAFECDEV = ?");
			params.add(recurso.getSanrecrca().getRercafecdev());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercaimpdev() != null) {
			where.append(" AND t3.RERCAIMPDEV = ?");
			params.add(recurso.getSanrecrca().getRercaimpdev());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercaabo() != null) {
			where.append(" AND t3.RERCAABO = ?");
			params.add(recurso.getSanrecrca().getRercaabo());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercanota() != null) {
			where.append(" AND t3.RERCANOTA = ?");
			params.add(recurso.getSanrecrca().getRercanota());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRefecalta() != null) {
			where.append(" AND t3.REFECALTA = ?");
			params.add(recurso.getSanrecrca().getRefecalta());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRefecmodif() != null) {
			where.append(" AND t3.REFECMODIF = ?");
			params.add(recurso.getSanrecrca().getRefecmodif());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getReusualta() != null) {
			where.append(" AND t3.REUSUALTA = ?");
			params.add(recurso.getSanrecrca().getReusualta());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getReusumodif() != null) {
			where.append(" AND t3.REUSUMODIF = ?");
			params.add(recurso.getSanrecrca().getReusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Recurso entity
	 * 
	 * @param recurso
	 *            Recurso Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Recurso recurso, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RecursoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (recurso != null && recurso.getRecodigo() != null) {
			where.append(" AND UPPER(t1.RECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.RECODIGO IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(recurso.getExpedien().getExcodigo());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(recurso.getExpedien().getExnran());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(recurso.getExpedien().getExnror());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(recurso.getExpedien().getExfere());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcoit().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcoit().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcoes().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcoes().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(recurso.getExpedien().getExfeacin());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(recurso.getExpedien().getExfeemca());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(recurso.getExpedien().getExfeplca());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(recurso.getExpedien().getExfpnopc());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(recurso.getExpedien().getExfede());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(recurso.getExpedien().getExfecoal());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(recurso.getExpedien().getExfenopr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(recurso.getExpedien().getExfepupr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(recurso.getExpedien().getExfealpr());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(recurso.getExpedien().getExfeel());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(recurso.getExpedien().getExferes());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(recurso.getExpedien().getExfenore());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(recurso.getExpedien().getExfepure());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcottr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcottr().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(recurso.getExpedien().getExcamure());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(recurso.getExpedien().getExfeta());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(recurso.getExpedien().getExfecroi());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(recurso.getExpedien().getExfear());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExinre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExincoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExincoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExinexva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExinexva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(recurso.getExpedien().getExfecirc());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(recurso.getExpedien().getExfenoai());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(recurso.getExpedien().getExfecolm());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(recurso.getExpedien().getExfeinmu());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(recurso.getExpedien().getExfeavmu());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(recurso.getExpedien().getExfeimcd());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(recurso.getExpedien().getExfecede());
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcops().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (recurso != null && recurso.getExpedien() != null
				&& recurso.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getExpedien().getExcose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getExpedien().getExcose().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (recurso != null && recurso.getRefereor() != null) {
			where.append(" AND t1.REFEREOR = ?");
			params.add(recurso.getRefereor());
		}
		if (recurso != null && recurso.getReferenp() != null) {
			where.append(" AND t1.REFERENP = ?");
			params.add(recurso.getReferenp());
		}
		if (recurso != null && recurso.getRefeprro() != null) {
			where.append(" AND t1.REFEPRRO = ?");
			params.add(recurso.getRefeprro());
		}
		if (recurso != null && recurso.getRefenro1() != null) {
			where.append(" AND t1.REFENRO1 = ?");
			params.add(recurso.getRefenro1());
		}
		if (recurso != null && recurso.getReferero() != null) {
			where.append(" AND t1.REFERERO = ?");
			params.add(recurso.getReferero());
		}
		if (recurso != null && recurso.getRecoos() != null) {
			where.append(" AND UPPER(t1.RECOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecoos().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecoos().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOOS IS NOT NULL");
		}
		if (recurso != null && recurso.getRefenrro() != null) {
			where.append(" AND t1.REFENRRO = ?");
			params.add(recurso.getRefenrro());
		}
		if (recurso != null && recurso.getRecottro() != null) {
			where.append(" AND UPPER(t1.RECOTTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecottro().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecottro().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOTTRO IS NOT NULL");
		}
		if (recurso != null && recurso.getRecamrro() != null) {
			where.append(" AND t1.RECAMRRO = ?");
			params.add(recurso.getRecamrro());
		}
		if (recurso != null && recurso.getReferere() != null) {
			where.append(" AND t1.REFERERE = ?");
			params.add(recurso.getReferere());
		}
		if (recurso != null && recurso.getRecomorr() != null) {
			where.append(" AND UPPER(t1.RECOMORR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecomorr().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecomorr().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOMORR IS NOT NULL");
		}
		if (recurso != null && recurso.getRefeprrr() != null) {
			where.append(" AND t1.REFEPRRR = ?");
			params.add(recurso.getRefeprrr());
		}
		if (recurso != null && recurso.getRefenrr1() != null) {
			where.append(" AND t1.REFENRR1 = ?");
			params.add(recurso.getRefenrr1());
		}
		if (recurso != null && recurso.getRefererr() != null) {
			where.append(" AND t1.REFERERR = ?");
			params.add(recurso.getRefererr());
		}
		if (recurso != null && recurso.getRecoosrr() != null) {
			where.append(" AND UPPER(t1.RECOOSRR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecoosrr().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecoosrr().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOOSRR IS NOT NULL");
		}
		if (recurso != null && recurso.getRefenrrr() != null) {
			where.append(" AND t1.REFENRRR = ?");
			params.add(recurso.getRefenrrr());
		}
		if (recurso != null && recurso.getRecottrr() != null) {
			where.append(" AND UPPER(t1.RECOTTRR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecottrr().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecottrr().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOTTRR IS NOT NULL");
		}
		if (recurso != null && recurso.getRecamrrr() != null) {
			where.append(" AND t1.RECAMRRR = ?");
			params.add(recurso.getRecamrrr());
		}
		if (recurso != null && recurso.getRefecolm() != null) {
			where.append(" AND t1.REFECOLM = ?");
			params.add(recurso.getRefecolm());
		}
		if (recurso != null && recurso.getRenuinlm() != null) {
			where.append(" AND UPPER(t1.RENUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRenuinlm().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRenuinlm().toUpperCase() + "%");
			}
			where.append(" AND t1.RENUINLM IS NOT NULL");
		}
		if (recurso != null && recurso.getRefeinmu() != null) {
			where.append(" AND t1.REFEINMU = ?");
			params.add(recurso.getRefeinmu());
		}
		if (recurso != null && recurso.getRefeavmu() != null) {
			where.append(" AND t1.REFEAVMU = ?");
			params.add(recurso.getRefeavmu());
		}
		if (recurso != null && recurso.getRefeimcd() != null) {
			where.append(" AND t1.REFEIMCD = ?");
			params.add(recurso.getRefeimcd());
		}
		if (recurso != null && recurso.getRefecede() != null) {
			where.append(" AND t1.REFECEDE = ?");
			params.add(recurso.getRefecede());
		}
		if (recurso != null && recurso.getRenrorrc() != null) {
			where.append(" AND UPPER(t1.RENRORRC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRenrorrc().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRenrorrc().toUpperCase() + "%");
			}
			where.append(" AND t1.RENRORRC IS NOT NULL");
		}
		if (recurso != null && recurso.getRenranrc() != null) {
			where.append(" AND t1.RENRANRC = ?");
			params.add(recurso.getRenranrc());
		}
		if (recurso != null && recurso.getRecotrrc() != null) {
			where.append(" AND UPPER(t1.RECOTRRC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecotrrc().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecotrrc().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOTRRC IS NOT NULL");
		}
		if (recurso != null && recurso.getRefeinrc() != null) {
			where.append(" AND t1.REFEINRC = ?");
			params.add(recurso.getRefeinrc());
		}
		if (recurso != null && recurso.getRefenorc() != null) {
			where.append(" AND t1.REFENORC = ?");
			params.add(recurso.getRefenorc());
		}
		if (recurso != null && recurso.getReferset() != null) {
			where.append(" AND t1.REFERSET = ?");
			params.add(recurso.getReferset());
		}
		if (recurso != null && recurso.getRefeserc() != null) {
			where.append(" AND t1.REFESERC = ?");
			params.add(recurso.getRefeserc());
		}
		if (recurso != null && recurso.getRecamurc() != null) {
			where.append(" AND t1.RECAMURC = ?");
			params.add(recurso.getRecamurc());
		}
		if (recurso != null && recurso.getRecotifa() != null) {
			where.append(" AND UPPER(t1.RECOTIFA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecotifa().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecotifa().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOTIFA IS NOT NULL");
		}
		if (recurso != null && recurso.getRefepocs() != null) {
			where.append(" AND t1.REFEPOCS = ?");
			params.add(recurso.getRefepocs());
		}
		if (recurso != null && recurso.getReinrets() != null) {
			where.append(" AND UPPER(t1.REINRETS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getReinrets().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getReinrets().toUpperCase() + "%");
			}
			where.append(" AND t1.REINRETS IS NOT NULL");
		}
		if (recurso != null && recurso.getRecoor() != null) {
			where.append(" AND UPPER(t1.RECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getRecoor().toUpperCase() + "%");
			} else {
				params.add("%" + recurso.getRecoor().toUpperCase() + "%");
			}
			where.append(" AND t1.RECOOR IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRecodigo() != null) {
			where.append(" AND t3.RECODIGO = ?");
			params.add(recurso.getSanrecrca().getRecodigo());
		}
		if (recurso != null
				&& recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getSancuesfondo() != null
				&& recurso.getSanrecrca().getSancuesfondo().getCfcodigo() != null) {
			where.append(" AND UPPER(t3.RERCACFON) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getSancuesfondo()
						.getCfcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getSancuesfondo()
								.getCfcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.RERCACFON IS NOT NULL");
		}
		if (recurso != null
				&& recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getSancuesproced() != null
				&& recurso.getSanrecrca().getSancuesproced().getCpcodigo() != null) {
			where.append(" AND UPPER(t3.RERCACPROC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getSancuesproced()
						.getCpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getSancuesproced()
								.getCpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.RERCACPROC IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercafecenv() != null) {
			where.append(" AND t3.RERCAFECENV = ?");
			params.add(recurso.getSanrecrca().getRercafecenv());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getSanresulsen() != null
				&& recurso.getSanrecrca().getSanresulsen().getRsid() != null) {
			where.append(" AND UPPER(t3.RERCASEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getSanresulsen().getRsid()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getSanresulsen().getRsid()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.RERCASEN IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getTribunal() != null
				&& recurso.getSanrecrca().getTribunal().getTbcodigo() != null) {
			where.append(" AND UPPER(t3.RERCATRIB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getTribunal().getTbcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getTribunal().getTbcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.RERCATRIB IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercasala() != null) {
			where.append(" AND UPPER(t3.RERCASALA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getRercasala().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getRercasala().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.RERCASALA IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercaacue() != null) {
			where.append(" AND UPPER(t3.RERCAACUE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getRercaacue().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getRercaacue().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.RERCAACUE IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercafecdev() != null) {
			where.append(" AND t3.RERCAFECDEV = ?");
			params.add(recurso.getSanrecrca().getRercafecdev());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercaimpdev() != null) {
			where.append(" AND t3.RERCAIMPDEV = ?");
			params.add(recurso.getSanrecrca().getRercaimpdev());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercaabo() != null) {
			where.append(" AND UPPER(t3.RERCAABO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getRercaabo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getRercaabo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.RERCAABO IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRercanota() != null) {
			where.append(" AND UPPER(t3.RERCANOTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getRercanota().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getRercanota().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.RERCANOTA IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRefecalta() != null) {
			where.append(" AND t3.REFECALTA = ?");
			params.add(recurso.getSanrecrca().getRefecalta());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getRefecmodif() != null) {
			where.append(" AND t3.REFECMODIF = ?");
			params.add(recurso.getSanrecrca().getRefecmodif());
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getReusualta() != null) {
			where.append(" AND UPPER(t3.REUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getReusualta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getReusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.REUSUALTA IS NOT NULL");
		}
		if (recurso != null && recurso.getSanrecrca() != null
				&& recurso.getSanrecrca().getReusumodif() != null) {
			where.append(" AND UPPER(t3.REUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(recurso.getSanrecrca().getReusumodif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ recurso.getSanrecrca().getReusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.REUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
