// CHECKSTYLE:OFF
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.ReclamacionArb;

/**
 * * ReclamacionArbImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class ReclamacionArbDaoImpl implements ReclamacionArbDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            ReclamacionArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ReclamacionArb> findAllLikeSolicitudes(ReclamacionArb solicitudesBusqueda, Pagination pagination,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(Y41bConstantes.BUFFER_3000);

		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D'  AND t8.HCCOHD=t4.HDCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t4.HDNROR HDNROR, t4.HDCODIGO HDCODIGO, t1.DECODT DECODT, CASE WHEN tt3CONSUMIDOR.DTCODIGO IS NOT NULL THEN tt3CONSUMIDOR.DTNOMBRE ELSE t3CONSUMIDOR.NOMBRE END DTNOMBRE, CASE WHEN tt3CONSUMIDOR.DTCODIGO IS NOT NULL THEN tt3CONSUMIDOR.DTAPELLIDO1 ELSE t3CONSUMIDOR.APELLIDO1 END DTAPELLIDO1, CASE WHEN tt3CONSUMIDOR.DTCODIGO IS NOT NULL THEN tt3CONSUMIDOR.DTAPELLIDO2 ELSE t3CONSUMIDOR.APELLIDO2 END DTAPELLIDO2, CASE WHEN tt3CONSUMIDOR.DTCODIGO IS NOT NULL THEN tt3CONSUMIDOR.DTNIF ELSE t3CONSUMIDOR.NIF END DTNIF, CASE WHEN tt3CONSUMIDOR.DTCODIGO IS NOT NULL THEN tt3CONSUMIDOR.DTTECOEM ELSE t3CONSUMIDOR.COEM END DTTECOEM, t5.FCODIGO FCODIGO, T4.HDFEHD HDFEHD, T4.HDTE HDTE, t4.HDCOTSR HDCOTSR, t4.HDCAPTSO HDCAPTSO, t4.HDTESO HDTESO, t4.HDCOES HDCOES, CASE WHEN t7ESTABLECIMIENTO.HDCODIGO IS NOT NULL THEN t7ESTABLECIMIENTO.NOMBRE ELSE tt7ESTABLECIMIENTO.ESNOMBRE END ESNOMBRE, CASE WHEN t7ESTABLECIMIENTO.HDCODIGO IS NOT NULL THEN t7ESTABLECIMIENTO.NIF ELSE tt7ESTABLECIMIENTO.ESNIF END ESNIF ");

		query.append(
				" FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, FASE t5,INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, DECISION_HECHO t8 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereBusquedaMap(solicitudesBusqueda, startsWith);

		where.append(mapaWhere.get("query"));
		query.append(where);
		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<ReclamacionArb>) this.jdbcTemplate.query(query.toString(), new RowMapper<ReclamacionArb>() {
			public ReclamacionArb mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				ReclamacionArb retorno = new ReclamacionArb();
				retorno.setDecoor(resultSet.getString("DECOOR"));
				retorno.setDenran(resultSet.getBigDecimal("DENRAN"));
				retorno.setDenror(resultSet.getBigDecimal("DENROR"));
				retorno.setHdnror(resultSet.getBigDecimal("HDNROR"));
				retorno.setHdcodigo(resultSet.getString("HDCODIGO"));
				retorno.setDtcodigo(resultSet.getString("DECODT"));
				retorno.setDtnombre(resultSet.getString("DTNOMBRE"));
				retorno.setDtapellido1(resultSet.getString("DTAPELLIDO1"));
				retorno.setDtapellido2(resultSet.getString("DTAPELLIDO2"));
				retorno.setDtnif(resultSet.getString("DTNIF"));
				retorno.setFcodigo(resultSet.getString("FCODIGO"));
				retorno.setHdfehd(resultSet.getDate("HDFEHD"));
				retorno.setHdte(resultSet.getString("HDTE"));
				retorno.setHdcotsr(resultSet.getString("HDCOTSR"));
				retorno.setHdcaptso(resultSet.getBigDecimal("HDCAPTSO"));
				retorno.setHdteso(resultSet.getString("HDTESO"));
				retorno.setHdcoes(resultSet.getString("HDCOES"));
				retorno.setEscodigo(resultSet.getString("HDCOES"));
				retorno.setEsnombre(resultSet.getString("ESNOMBRE"));
				retorno.setDtcoem(resultSet.getString("DTTECOEM"));
				retorno.setEsnif(resultSet.getString("ESNIF"));
				return retorno;
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the ReclamacionArb table.
	 * 
	 * @param solicitudesBusqueda
	 *            ReclamacionArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeSolicitudesCount(ReclamacionArb solicitudesBusqueda, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);

		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D'  AND t8.HCCOHD=t4.HDCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.HDCODIGO) FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, FASE t5, INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, DECISION_HECHO t8 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereBusquedaMap(solicitudesBusqueda, startsWith);

		where.append(mapaWhere.get("query"));
		query.append(where);
		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param startsWith
	 *            Boolean
	 * @return Map<String, ?>
	 */
	private Map<String, ?> getWhereBusquedaMap(ReclamacionArb solicitudesBusqueda, Boolean startsWith) {
		StringBuilder where = new StringBuilder("");
		List<Object> params = new ArrayList<Object>();

		// EXPEDIENTE
		if (solicitudesBusqueda.getNumExpediente() != null) {
			where.append(" AND '").append(Y41bConstantes.TIPO_PROC_SOLICITUDES)
					.append("' || '-' || t1.DECOOR || '-' || t1.DENROR || '-' || t1.DENRAN || '-' || t4.HDNROR=?");
			params.add(solicitudesBusqueda.getNumExpediente().toUpperCase());
		}

		// ID DEL HECHO
		if (solicitudesBusqueda.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO=?");
			params.add(solicitudesBusqueda.getHdcodigo());
		}

		// Dni persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnif() != null) {
			where.append(" AND ((UPPER(t3CONSUMIDOR.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			}
			where.append(
					" AND t3CONSUMIDOR.NIF IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL AND t4.TRCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt3CONSUMIDOR.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			}
			where.append(
					" AND tt3CONSUMIDOR.DTNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL AND t4.TRCODIGOACTUAL IS NULL)) ");
		}

		// est cerrada
		// Incluir expedientes cerrados
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndIncluirCerrados() != null
				&& solicitudesBusqueda.getIndIncluirCerrados().equals(Y41bConstantes.VALOR_SI)) {

			where.append(" AND t4.HDFECHACIERRE IS NOT NULL ");
		}

		// no este relacionada con solicitud previa de arbitraje
		if (solicitudesBusqueda != null && solicitudesBusqueda.getindNoRelacionada() != null
				&& solicitudesBusqueda.getindNoRelacionada().equals(Y41bConstantes.VALOR_SI)) {

			where.append(
					" AND NOT EXISTS (SELECT 1 FROM SANEXPREL t10SANEXPREL WHERE  t10SANEXPREL.RLARBCODIGO IS NOT NULL  AND t10SANEXPREL.RLHDCODREL=t4.HDCODIGO AND (t10SANEXPREL.RLESORIG=?)  ) ");
			params.add(Y41bConstantes.TIPO_RELACION_ORIGEN);

		}

		// tipo de solicitud reclamacin
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdcosc() != null) {

			where.append(" AND t4.HDCOSC=?");
			params.add(solicitudesBusqueda.getHdcosc());
		}

		// la solicitud tiene que tener decisin y de un tipo concreto
		if (Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS != null
				&& Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length > 0) {
			where.append(" AND t8.HCCOTTD IS NOT NULL AND t8.HCCOTTD NOT IN (");

			for (int i = 0; i < Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length; i++) {
				where.append("? ");
				if (i != Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length - 1) {
					where.append(", ");
				}
				params.add(Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS[i]);
			}

			where.append(" ) ");

		}

		// y que exista fecha de decisin
		where.append(" AND t8.HCFEDE IS NOT NULL ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
