package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.RangoEdad;

/**
 * * RangoEdadDao  
 * 
 *  
 */

public interface RangoEdadDao {

	/**
	 * Inserts a single row in the RangoEdad table.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	RangoEdad add(RangoEdad rangoedad);

	/**
	 * Updates a single row in the RangoEdad table.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	RangoEdad update(RangoEdad rangoedad);

	/**
	 * Finds a single row in the RangoEdad table.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	RangoEdad find(RangoEdad rangoedad);

	/**
	 * Deletes a single row in the RangoEdad table.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @return
	 */
	void remove(RangoEdad rangoedad);

	/**
	 * Finds a List of rows in the RangoEdad table.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<RangoEdad> findAll(RangoEdad rangoedad, Pagination pagination);

	/**
	 * Counts rows in the RangoEdad table.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @return List
	 */
	Long findAllCount(RangoEdad rangoedad);

	/**
	 * Finds rows in the RangoEdad table using like.
	 * 
	 * @param rangoedad
	 *            RangoEdad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RangoEdad> findAllLike(RangoEdad rangoedad, Pagination pagination,
			Boolean startsWith);
}
