package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Provinc;

/**
 * ProvincDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class ProvincDaoImpl implements ProvincDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Provinc> rwMap = new RowMapper<Provinc>() {
		public Provinc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Provinc(
               resultSet.getString("PVCODIGO"), resultSet.getString("PVNOMBRE"), resultSet.getString("PVCOCA"), resultSet.getString("PVCOMA"), resultSet.getString("PVNRPRTE"), resultSet.getString("PVNOCA")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Provinc table.
     *
     * @param provinc Pagination
     * @return Provinc
     */
	public Provinc add(Provinc provinc) {
    	String query = "INSERT INTO PROVINC (PVCODIGO, PVNOMBRE, PVCOCA, PVCOMA, PVNRPRTE, PVNOCA) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, provinc.getPvcodigo(), provinc.getPvnombre(), provinc.getPvcoca(), provinc.getPvcoma(), provinc.getPvnrprte(), provinc.getPvnoca());
		return provinc;
	}

    /**
     * Updates a single row in the Provinc table.
     *
     * @param provinc Pagination
     * @return Provinc
     */
    public Provinc update(Provinc provinc) {
		String query = "UPDATE PROVINC SET PVNOMBRE=?, PVCOCA=?, PVCOMA=?, PVNRPRTE=?, PVNOCA=? WHERE PVCODIGO=?";
		this.jdbcTemplate.update(query, provinc.getPvnombre(), provinc.getPvcoca(), provinc.getPvcoma(), provinc.getPvnrprte(), provinc.getPvnoca(), provinc.getPvcodigo());
		return provinc;
	}

    /**
     * Finds a single row in the Provinc table.
     *
     * @param provinc Pagination
     * @return Provinc
     */
    @Transactional (readOnly = true)
    public Provinc find(Provinc provinc) {
		String query = "SELECT t1.PVCODIGO PVCODIGO, t1.PVNOMBRE PVNOMBRE, t1.PVCOCA PVCOCA, t1.PVCOMA PVCOMA, t1.PVNRPRTE PVNRPRTE, t1.PVNOCA PVNOCA FROM PROVINC t1  WHERE t1.PVCODIGO = ?  ";
		
		List<Provinc> provincList = this.jdbcTemplate.query(query, this.rwMap, provinc.getPvcodigo());
		return (Provinc) DataAccessUtils.uniqueResult(provincList);
    }

    /**
     * Removes a single row in the Provinc table.
     *
     * @param provinc Pagination
     * @return
     */
    public void remove(Provinc provinc) {
		String query = "DELETE FROM PROVINC WHERE PVCODIGO=?";
		this.jdbcTemplate.update(query, provinc.getPvcodigo());
    }
    
   /**
    * Finds a List of rows in the Provinc table.
    * 
    * @param provinc Provinc
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Provinc> findAll(Provinc provinc, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.PVCODIGO PVCODIGO,t1.PVNOMBRE PVNOMBRE,t1.PVCOCA PVCOCA,t1.PVCOMA PVCOMA,t1.PVNRPRTE PVNRPRTE,t1.PVNOCA PVNOCA "); 
		query.append("FROM PROVINC t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(provinc); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Provinc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Provinc table.
     * 
     * @param provinc Provinc
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Provinc provinc) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PROVINC t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(provinc); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Provinc table using like.
     * 
     * @param provinc Provinc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Provinc> findAllLike(Provinc provinc, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.PVCODIGO PVCODIGO,t1.PVNOMBRE PVNOMBRE,t1.PVCOCA PVCOCA,t1.PVCOMA PVCOMA,t1.PVNRPRTE PVNRPRTE,t1.PVNOCA PVNOCA "); 
        query.append("FROM PROVINC t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(provinc,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Provinc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Provinc table using like.
     * 
     * @param provinc Provinc
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Provinc provinc, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PROVINC t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(provinc,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Provinc entity 
	 * 
	 * @param provinc Provinc
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Provinc provinc){
		
		StringBuilder where = new StringBuilder(ProvincDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (provinc  != null  && provinc.getPvcodigo() != null ) {
			where.append(" AND t1.PVCODIGO = ?");
			params.add(provinc.getPvcodigo());
		}
		if (provinc  != null  && provinc.getPvnombre() != null ) {
			where.append(" AND t1.PVNOMBRE = ?");
			params.add(provinc.getPvnombre());
		}
		if (provinc  != null  && provinc.getPvcoca() != null ) {
			where.append(" AND t1.PVCOCA = ?");
			params.add(provinc.getPvcoca());
		}
		if (provinc  != null  && provinc.getPvcoma() != null ) {
			where.append(" AND t1.PVCOMA = ?");
			params.add(provinc.getPvcoma());
		}
		if (provinc  != null  && provinc.getPvnrprte() != null ) {
			where.append(" AND t1.PVNRPRTE = ?");
			params.add(provinc.getPvnrprte());
		}
		if (provinc  != null  && provinc.getPvnoca() != null ) {
			where.append(" AND t1.PVNOCA = ?");
			params.add(provinc.getPvnoca());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Provinc entity 
	 * 
	 * @param provinc Provinc
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Provinc provinc, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(ProvincDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (provinc  != null  && provinc.getPvcodigo() != null ) {
			where.append(" AND UPPER(t1.PVCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(provinc.getPvcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+provinc.getPvcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.PVCODIGO IS NOT NULL");
	     }			
		if (provinc  != null  && provinc.getPvnombre() != null ) {
			where.append(" AND UPPER(t1.PVNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(provinc.getPvnombre().toUpperCase() +"%");
			}else{
				params.add("%"+provinc.getPvnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.PVNOMBRE IS NOT NULL");
	     }			
		if (provinc  != null  && provinc.getPvcoca() != null ) {
			where.append(" AND UPPER(t1.PVCOCA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(provinc.getPvcoca().toUpperCase() +"%");
			}else{
				params.add("%"+provinc.getPvcoca().toUpperCase() +"%");
			}
			where.append(" AND t1.PVCOCA IS NOT NULL");
	     }			
		if (provinc  != null  && provinc.getPvcoma() != null ) {
			where.append(" AND UPPER(t1.PVCOMA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(provinc.getPvcoma().toUpperCase() +"%");
			}else{
				params.add("%"+provinc.getPvcoma().toUpperCase() +"%");
			}
			where.append(" AND t1.PVCOMA IS NOT NULL");
	     }			
		if (provinc  != null  && provinc.getPvnrprte() != null ) {
			where.append(" AND UPPER(t1.PVNRPRTE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(provinc.getPvnrprte().toUpperCase() +"%");
			}else{
				params.add("%"+provinc.getPvnrprte().toUpperCase() +"%");
			}
			where.append(" AND t1.PVNRPRTE IS NOT NULL");
	     }			
		if (provinc  != null  && provinc.getPvnoca() != null ) {
			where.append(" AND UPPER(t1.PVNOCA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(provinc.getPvnoca().toUpperCase() +"%");
			}else{
				params.add("%"+provinc.getPvnoca().toUpperCase() +"%");
			}
			where.append(" AND t1.PVNOCA IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

