package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Provinc;

/**
 * ProvincDao  
 *  
 */

public interface ProvincDao {
    
    /**
     * Inserts a single row in the Provinc table.
     *
     * @param provinc Provinc
     * @return Provinc
     */
    Provinc add(Provinc provinc);

    /**
     * Updates a single row in the Provinc table.
     *
     * @param provinc Provinc
     * @return Provinc
     */
    Provinc update(Provinc provinc);

    /**
     * Finds a single row in the Provinc table.
     *
     * @param provinc Provinc
     * @return Provinc
     */
    Provinc find(Provinc provinc);

    /**
     * Deletes a single row in the Provinc table.
     *
     * @param provinc Provinc
     * @return 
     */
    void remove(Provinc provinc);

    /**
     * Finds a List of rows in the Provinc table.
     *
     * @param provinc Provinc
     * @param pagination Pagination
     * @return List
     */
    List<Provinc> findAll(Provinc provinc, Pagination pagination);

    /**
     * Counts rows in the Provinc table.
     *
     * @param provinc Provinc
     * @return Long
     */
    Long findAllCount(Provinc provinc);
	
	/**
     * Finds rows in the Provinc table using like.
     *
     * @param provinc Provinc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Provinc> findAllLike(Provinc provinc, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Provinc table using like.
     *
     * @param provinc Provinc
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Provinc provinc, Boolean startsWith);
}

