package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Protocol;

/**
 * ProtocolDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ProtocolDaoImpl implements ProtocolDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Protocol> rwMap = new RowMapper<Protocol>() {
		public Protocol mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Protocol(resultSet.getString("PTCODIGO"),
					resultSet.getString("PTCOAT"),
					resultSet.getString("PTCOTR"),
					resultSet.getInt("PTNRPRTP"),
					resultSet.getString("PTCORETP"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Pagination
	 * @return Protocol
	 */
	public Protocol add(Protocol protocol) {
		String query = "INSERT INTO PROTOCOLO (PTCODIGO, PTCOAT, PTCOTR, PTNRPRTP, PTCORETP) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, protocol.getPtcodigo(),
				protocol.getPtcoat(), protocol.getPtcotr(),
				protocol.getPtnrprtp(), protocol.getPtcoretp());
		return protocol;
	}

	/**
	 * Updates a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Pagination
	 * @return Protocol
	 */
	public Protocol update(Protocol protocol) {
		String query = "UPDATE PROTOCOLO SET PTCOAT=?, PTCOTR=?, PTNRPRTP=?, PTCORETP=? WHERE PTCODIGO=?";
		this.jdbcTemplate.update(query, protocol.getPtcoat(),
				protocol.getPtcotr(), protocol.getPtnrprtp(),
				protocol.getPtcoretp(), protocol.getPtcodigo());
		return protocol;
	}

	/**
	 * Finds a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Pagination
	 * @return Protocol
	 */
	@Transactional(readOnly = true)
	public Protocol find(Protocol protocol) {
		String query = "SELECT t1.PTCODIGO PTCODIGO, t1.PTCOAT PTCOAT, t1.PTCOTR PTCOTR, t1.PTNRPRTP PTNRPRTP, t1.PTCORETP PTCORETP FROM PROTOCOLO t1  WHERE t1.PTCODIGO = ?  ";

		List<Protocol> protocolList = this.jdbcTemplate.query(query,
				this.rwMap, protocol.getPtcodigo());
		return (Protocol) DataAccessUtils.uniqueResult(protocolList);
	}

	/**
	 * Removes a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Pagination
	 * @return
	 */
	public void remove(Protocol protocol) {
		String query = "DELETE FROM PROTOCOLO WHERE PTCODIGO=?";
		this.jdbcTemplate.update(query, protocol.getPtcodigo());
	}

	/**
	 * Removes a single row in the Protocol table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	public void removeByActuacion(Actuacion actuacion, String tipProtocolo) {
		String query = "DELETE FROM PROTOCOLO WHERE PTCOAT=? and PTCOTR IN (SELECT TRCODIGO FROM TIP_PREG_PROTOC WHERE TRCOTP = ?)";
		this.jdbcTemplate.update(query, actuacion.getAtcoat(), tipProtocolo);
	}

	/**
	 * Removes all protocol of an Actuacion.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	public void removeAllProtocoloInspeccion(Actuacion actuacion) {
		String query = "DELETE FROM PROTOCOLO WHERE PTCOAT=? ";
		this.jdbcTemplate.update(query, actuacion.getAtcodigo());
	}

	/**
	 * Finds a List of rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Protocol> findAll(Protocol protocol, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTCOAT PTCOAT,t1.PTCOTR PTCOTR,t1.PTNRPRTP PTNRPRTP,t1.PTCORETP PTCORETP ");
		query.append("FROM PROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(protocol);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Protocol>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Protocol protocol) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(protocol);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Protocol> findAllLike(Protocol protocol, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTCOAT PTCOAT,t1.PTCOTR PTCOTR,t1.PTNRPRTP PTNRPRTP,t1.PTCORETP PTCORETP ");
		query.append("FROM PROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(protocol, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Protocol>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Protocol protocol, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(protocol, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Protocol entity
	 * 
	 * @param protocol
	 *            Protocol Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Protocol protocol) {

		StringBuilder where = new StringBuilder(
				ProtocolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (protocol != null && protocol.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(protocol.getPtcodigo());
		}
		if (protocol != null && protocol.getPtcoat() != null) {
			where.append(" AND t1.PTCOAT = ?");
			params.add(protocol.getPtcoat());
		}
		if (protocol != null && protocol.getPtcotr() != null) {
			where.append(" AND t1.PTCOTR = ?");
			params.add(protocol.getPtcotr());
		}
		if (protocol != null && protocol.getPtnrprtp() != null) {
			where.append(" AND t1.PTNRPRTP = ?");
			params.add(protocol.getPtnrprtp());
		}
		if (protocol != null && protocol.getPtcoretp() != null) {
			where.append(" AND t1.PTCORETP = ?");
			params.add(protocol.getPtcoretp());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Protocol entity
	 * 
	 * @param protocol
	 *            Protocol Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Protocol protocol, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ProtocolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (protocol != null && protocol.getPtcodigo() != null) {
			where.append(" AND UPPER(t1.PTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocol.getPtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + protocol.getPtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PTCODIGO IS NOT NULL");
		}
		if (protocol != null && protocol.getPtcoat() != null) {
			where.append(" AND UPPER(t1.PTCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocol.getPtcoat().toUpperCase() + "%");
			} else {
				params.add("%" + protocol.getPtcoat().toUpperCase() + "%");
			}
			where.append(" AND t1.PTCOAT IS NOT NULL");
		}
		if (protocol != null && protocol.getPtcotr() != null) {
			where.append(" AND UPPER(t1.PTCOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocol.getPtcotr().toUpperCase() + "%");
			} else {
				params.add("%" + protocol.getPtcotr().toUpperCase() + "%");
			}
			where.append(" AND t1.PTCOTR IS NOT NULL");
		}
		if (protocol != null && protocol.getPtnrprtp() != null) {
			where.append(" AND t1.PTNRPRTP = ?");
			params.add(protocol.getPtnrprtp());
		}
		if (protocol != null && protocol.getPtcoretp() != null) {
			where.append(" AND UPPER(t1.PTCORETP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(protocol.getPtcoretp().toUpperCase() + "%");
			} else {
				params.add("%" + protocol.getPtcoretp().toUpperCase() + "%");
			}
			where.append(" AND t1.PTCORETP IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllPreguntasContestadasCount(Protocol protocol) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PROTOCOLO t1, TIP_PREG_PROTOC t2 "
						+ " WHERE 1=1 AND t1.PTCOTR = t2.TRCODIGO AND t1.PTCOAT=?  AND t2.TRCOTP=? ");

		List<Object> params = new ArrayList<Object>();
		params.add(protocol.getPtcoat());
		params.add(protocol.getPtcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
