package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Protocol;

/**
 * ProtocolDao  
 * 
 *  
 */

public interface ProtocolDao {

	/**
	 * Inserts a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	Protocol add(Protocol protocol);

	/**
	 * Updates a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	Protocol update(Protocol protocol);

	/**
	 * Finds a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	Protocol find(Protocol protocol);

	/**
	 * Deletes a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return
	 */
	void remove(Protocol protocol);

	/**
	 * Removes a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Pagination
	 * @return
	 */
	public void removeByActuacion(Actuacion actuacion, String tipProtocolo);

	/**
	 * Removes all protocol of an Actuacion.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	public void removeAllProtocoloInspeccion(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Protocol> findAll(Protocol protocol, Pagination pagination);

	/**
	 * Counts rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	Long findAllCount(Protocol protocol);

	/**
	 * Finds rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Protocol> findAllLike(Protocol protocol, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Protocol protocol, Boolean startsWith);

	/**
	 * Counts rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	public Long findAllPreguntasContestadasCount(Protocol protocol);
}
