package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProd;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Y41bProductoTree;

/**
 * * ProductoDao  
 * 
 *  
 */

public interface ProductoDao {

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto add(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto update(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto find(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Pagination
	 * @return Producto
	 */
	Producto findProductoSeleccionable(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return Producto
	 */
	public Producto findProductoSeleccionableCampanha(CampanhaProd campanhaProd);

	/**
	 * Deletes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	void remove(Producto producto);

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Producto> findAll(Producto producto, Pagination pagination);

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param y41bProductoTree
	 *            Y41bProductoTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Y41bProductoTree> findAllProductosPadre(
			Y41bProductoTree y41bProductoTree, Pagination pagination);

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param y41bProductoTree
	 *            Y41bProductoTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Y41bProductoTree> findAllChildren(
			Y41bProductoTree y41bProductoTree, Pagination pagination);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param y41bProductoTree
	 *            Y41bProductoTree
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long countProductosHijos(Y41bProductoTree y41bProductoTree,
			Producto producto, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return List
	 */
	Long findAllCount(Producto producto);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLike(Producto producto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeCount(Producto producto, Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLikeProducto(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeProductoCount(Producto producto, Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllLikeProductoSeleccion(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeProductoSeleccionCount(Producto producto,
			Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllLikeProductoSeleccionCampanha(
			Producto producto, Campanha campanha, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeProductoSeleccionCampanhaCount(Producto producto,
			Campanha campanha, Boolean startsWith);

	/**
	 * Inserts a single row in the ProductoDescriptor table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto addProductoDescriptor(Producto producto);

	/**
	 * Finds a List of rows in the ProductoDescriptor table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllProductosDescriptores(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Updates a single row in the ProductoDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateProductoDescriptor(Descriptor descriptorAEliminar,
			Descriptor descriptorBueno);

	/**
	 * Deletes a single row in the ProductoDescriptor table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	public void removeProductoDescriptor(Producto producto);

	/**
	 * Deletes a single row in the ProductoDescriptor table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	public void removeAllProductoDescriptor(Producto producto);

	/**
	 * Find a single row in the findAllProductoDescriptor Many To Many
	 * relationship.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllProductoDescriptor(Producto producto,
			Pagination pagination);

}
