package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ProdAgrupado;

/**
 * ProdAgrupadoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ProdAgrupadoDaoImpl implements ProdAgrupadoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ProdAgrupado> rwMap = new RowMapper<ProdAgrupado>() {
		public ProdAgrupado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ProdAgrupado(resultSet.getString("E8CODIGO"),
					resultSet.getString("E8NOMBRE"),
					resultSet.getString("E8NOMBREE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ProdAgrupado table.
	 * 
	 * @param prodagrupado
	 *            Pagination
	 * @return ProdAgrupado
	 */
	public ProdAgrupado add(ProdAgrupado prodagrupado) {
		String query = "INSERT INTO PROD_AGRUPADO (E8CODIGO, E8NOMBRE, E8NOMBREE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, prodagrupado.getE8codigo(),
				prodagrupado.getE8nombre(), prodagrupado.getE8nombree());
		return prodagrupado;
	}

	/**
	 * Updates a single row in the ProdAgrupado table.
	 * 
	 * @param prodagrupado
	 *            Pagination
	 * @return ProdAgrupado
	 */
	public ProdAgrupado update(ProdAgrupado prodagrupado) {
		String query = "UPDATE PROD_AGRUPADO SET E8NOMBRE=?, E8NOMBREE=? WHERE E8CODIGO=?";
		this.jdbcTemplate.update(query, prodagrupado.getE8nombre(),
				prodagrupado.getE8nombree(), prodagrupado.getE8codigo());
		return prodagrupado;
	}

	/**
	 * Finds a single row in the ProdAgrupado table.
	 * 
	 * @param prodagrupado
	 *            Pagination
	 * @return ProdAgrupado
	 */
	@Transactional(readOnly = true)
	public ProdAgrupado find(ProdAgrupado prodagrupado) {
		String query = "SELECT t1.E8CODIGO E8CODIGO, t1.E8NOMBRE E8NOMBRE,t1.E8NOMBREE E8NOMBREE FROM PROD_AGRUPADO t1  WHERE t1.E8CODIGO = ?  ";

		List<ProdAgrupado> prodagrupadoList = this.jdbcTemplate.query(query,
				this.rwMap, prodagrupado.getE8codigo());
		return (ProdAgrupado) DataAccessUtils.uniqueResult(prodagrupadoList);
	}

	/**
	 * Removes a single row in the ProdAgrupado table.
	 * 
	 * @param prodagrupado
	 *            Pagination
	 * @return
	 */
	public void remove(ProdAgrupado prodagrupado) {
		String query = "DELETE FROM PROD_AGRUPADO WHERE E8CODIGO=?";
		this.jdbcTemplate.update(query, prodagrupado.getE8codigo());
	}

	/**
	 * Finds a List of rows in the ProdAgrupado table.
	 * 
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ProdAgrupado> findAll(ProdAgrupado prodagrupado,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.E8CODIGO E8CODIGO,t1.E8NOMBRE E8NOMBRE,NVL(t1.E8NOMBREE,t1.E8NOMBRE) E8NOMBREE ");
		query.append("FROM PROD_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(prodagrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ProdAgrupado>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ProdAgrupado table.
	 * 
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ProdAgrupado prodagrupado) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PROD_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(prodagrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ProdAgrupado table using like.
	 * 
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ProdAgrupado> findAllLike(ProdAgrupado prodagrupado,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.E8CODIGO E8CODIGO,t1.E8NOMBRE E8NOMBRE,NVL(t1.E8NOMBREE,t1.E8NOMBRE) E8NOMBREE ");
		query.append("FROM PROD_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(prodagrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ProdAgrupado>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ProdAgrupado table using like.
	 * 
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ProdAgrupado prodagrupado, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PROD_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(prodagrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ProdAgrupado entity
	 * 
	 * @param prodagrupado
	 *            ProdAgrupado Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ProdAgrupado prodagrupado) {

		StringBuilder where = new StringBuilder(
				ProdAgrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (prodagrupado != null && prodagrupado.getE8codigo() != null) {
			where.append(" AND t1.E8CODIGO = ?");
			params.add(prodagrupado.getE8codigo());
		}
		if (prodagrupado != null && prodagrupado.getE8nombre() != null) {
			where.append(" AND t1.E8NOMBRE = ?");
			params.add(prodagrupado.getE8nombre());
		}
		if (prodagrupado != null && prodagrupado.getE8nombree() != null) {
			where.append(" AND t1.E8NOMBREE = ?");
			params.add(prodagrupado.getE8nombree());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ProdAgrupado entity
	 * 
	 * @param prodagrupado
	 *            ProdAgrupado Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(ProdAgrupado prodagrupado,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ProdAgrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (prodagrupado != null && prodagrupado.getE8codigo() != null) {
			where.append(" AND UPPER(t1.E8CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(prodagrupado.getE8codigo().toUpperCase() + "%");
			} else {
				params.add("%" + prodagrupado.getE8codigo().toUpperCase() + "%");
			}
			where.append(" AND t1.E8CODIGO IS NOT NULL");
		}
		if (prodagrupado != null && prodagrupado.getE8nombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.E8NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(prodagrupado.getE8nombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ prodagrupado.getE8nombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.E8NOMBRE IS NOT NULL");
		}
		if (prodagrupado != null && prodagrupado.getE8nombree() != null) {
			where.append(" AND (TRANSLATE(UPPER(t1.E8NOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(prodagrupado.getE8nombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ prodagrupado.getE8nombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.E8NOMBREE IS NOT NULL)");

			where.append(" OR (TRANSLATE(UPPER(t1.E8NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(prodagrupado.getE8nombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ prodagrupado.getE8nombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.E8NOMBRE IS NOT NULL AND t1.E8NOMBREE IS NULL)");

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
