package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.ProdAgrupado;

/**
 * ProdAgrupadoDao  
 *  
 */

public interface ProdAgrupadoDao {
    
    /**
     * Inserts a single row in the ProdAgrupado table.
     *
     * @param prodagrupado ProdAgrupado
     * @return ProdAgrupado
     */
    ProdAgrupado add(ProdAgrupado prodagrupado);

    /**
     * Updates a single row in the ProdAgrupado table.
     *
     * @param prodagrupado ProdAgrupado
     * @return ProdAgrupado
     */
    ProdAgrupado update(ProdAgrupado prodagrupado);

    /**
     * Finds a single row in the ProdAgrupado table.
     *
     * @param prodagrupado ProdAgrupado
     * @return ProdAgrupado
     */
    ProdAgrupado find(ProdAgrupado prodagrupado);

    /**
     * Deletes a single row in the ProdAgrupado table.
     *
     * @param prodagrupado ProdAgrupado
     * @return 
     */
    void remove(ProdAgrupado prodagrupado);

    /**
     * Finds a List of rows in the ProdAgrupado table.
     *
     * @param prodagrupado ProdAgrupado
     * @param pagination Pagination
     * @return List
     */
    List<ProdAgrupado> findAll(ProdAgrupado prodagrupado, Pagination pagination);

    /**
     * Counts rows in the ProdAgrupado table.
     *
     * @param prodagrupado ProdAgrupado
     * @return Long
     */
    Long findAllCount(ProdAgrupado prodagrupado);
	
	/**
     * Finds rows in the ProdAgrupado table using like.
     *
     * @param prodagrupado ProdAgrupado
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<ProdAgrupado> findAllLike(ProdAgrupado prodagrupado, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the ProdAgrupado table using like.
     *
     * @param prodagrupado ProdAgrupado
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(ProdAgrupado prodagrupado, Boolean startsWith);
}

