package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * PosibleTramiteDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PosibleTramiteDaoImpl implements PosibleTramiteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<PosibleTramite> rwMap = new RowMapper<PosibleTramite>() {
		public PosibleTramite mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new PosibleTramite(resultSet.getString("TRPOSIBLECODIGO"),
					resultSet.getString("TRPOSIBLECODIGOORIGEN"),
					resultSet.getString("TRPOSIBLECODIGOSIGUIENTE"),
					new TipoProcedimiento(resultSet
							.getString("TipoProcedimientoPCODIGO"), resultSet
							.getString("TipoProcedimientoPNOMBRE"), resultSet
							.getString("TipoProcedimientoPNOMBREE"), resultSet
							.getDate("TipoProcedimientoPBAJA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return PosibleTramite
	 */
	public PosibleTramite add(PosibleTramite posibletramite) {
		String query = "INSERT INTO POSIBLE_TRAMITE (TRPOSIBLECODIGO, PCODIGO, TRPOSIBLECODIGOORIGEN, TRPOSIBLECODIGOSIGUIENTE) VALUES (?,?,?,?)";
		Object getTipoProcedimientoPcodigoAux = null;
		if (posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = posibletramite
					.getTipoProcedimiento().getPcodigo();
		}
		this.jdbcTemplate.update(query, posibletramite.getTrposiblecodigo(),
				getTipoProcedimientoPcodigoAux,
				posibletramite.getTrposiblecodigoorigen(),
				posibletramite.getTrposiblecodigosiguiente());
		return posibletramite;
	}

	/**
	 * Updates a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return PosibleTramite
	 */
	public PosibleTramite update(PosibleTramite posibletramite) {
		String query = "UPDATE POSIBLE_TRAMITE SET PCODIGO=?, TRPOSIBLECODIGOORIGEN=?, TRPOSIBLECODIGOSIGUIENTE=? WHERE TRPOSIBLECODIGO=?";
		Object getTipoProcedimientoPcodigoAux = null;
		if (posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = posibletramite
					.getTipoProcedimiento().getPcodigo();
		}
		this.jdbcTemplate.update(query, getTipoProcedimientoPcodigoAux,
				posibletramite.getTrposiblecodigoorigen(),
				posibletramite.getTrposiblecodigosiguiente(),
				posibletramite.getTrposiblecodigo());
		return posibletramite;
	}

	/**
	 * Finds a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return PosibleTramite
	 */
	@Transactional(readOnly = true)
	public PosibleTramite find(PosibleTramite posibletramite) {
		String query = "SELECT t1.TRPOSIBLECODIGO TRPOSIBLECODIGO, t1.TRPOSIBLECODIGOORIGEN TRPOSIBLECODIGOORIGEN, t1.TRPOSIBLECODIGOSIGUIENTE TRPOSIBLECODIGOSIGUIENTE, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA FROM POSIBLE_TRAMITE t1 , TIPO_PROCEDIMIENTO t2  WHERE t1.TRPOSIBLECODIGO = ?   AND t1.PCODIGO= t2.PCODIGO(+)";

		List<PosibleTramite> posibletramiteList = this.jdbcTemplate.query(
				query, this.rwMap, posibletramite.getTrposiblecodigo());
		return (PosibleTramite) DataAccessUtils
				.uniqueResult(posibletramiteList);
	}

	/**
	 * Removes a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return
	 */
	public void remove(PosibleTramite posibletramite) {
		String query = "DELETE FROM POSIBLE_TRAMITE WHERE TRPOSIBLECODIGO=?";
		this.jdbcTemplate.update(query, posibletramite.getTrposiblecodigo());
	}

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PosibleTramite> findAll(PosibleTramite posibletramite,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRPOSIBLECODIGO TRPOSIBLECODIGO,t1.TRPOSIBLECODIGOORIGEN TRPOSIBLECODIGOORIGEN,t1.TRPOSIBLECODIGOSIGUIENTE TRPOSIBLECODIGOSIGUIENTE,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA ");
		query.append("FROM POSIBLE_TRAMITE t1 ,TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(posibletramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<PosibleTramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(PosibleTramite posibletramite) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM POSIBLE_TRAMITE t1 , TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(posibletramite);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the PosibleTramite table using like.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PosibleTramite> findAllLike(PosibleTramite posibletramite,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRPOSIBLECODIGO TRPOSIBLECODIGO,t1.TRPOSIBLECODIGOORIGEN TRPOSIBLECODIGOORIGEN,t1.TRPOSIBLECODIGOSIGUIENTE TRPOSIBLECODIGOSIGUIENTE,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA ");
		query.append("FROM POSIBLE_TRAMITE t1 ,TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(posibletramite,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<PosibleTramite>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PosibleTramite table using like.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(PosibleTramite posibletramite,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM POSIBLE_TRAMITE t1 ,TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(posibletramite,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PosibleTramite entity
	 * 
	 * @param posibletramite
	 *            PosibleTramite Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(PosibleTramite posibletramite) {

		StringBuilder where = new StringBuilder(
				PosibleTramiteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (posibletramite != null
				&& posibletramite.getTrposiblecodigo() != null) {
			where.append(" AND t1.TRPOSIBLECODIGO = ?");
			params.add(posibletramite.getTrposiblecodigo());
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(posibletramite.getTipoProcedimiento().getPcodigo());
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPnombre() != null) {
			where.append(" AND t2.PNOMBRE = ?");
			params.add(posibletramite.getTipoProcedimiento().getPnombre());
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPnombree() != null) {
			where.append(" AND t2.PNOMBREE = ?");
			params.add(posibletramite.getTipoProcedimiento().getPnombree());
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPbaja() != null) {
			where.append(" AND t2.PBAJA = ?");
			params.add(posibletramite.getTipoProcedimiento().getPbaja());
		}
		if (posibletramite != null
				&& posibletramite.getTrposiblecodigoorigen() != null) {
			where.append(" AND t1.TRPOSIBLECODIGOORIGEN = ?");
			params.add(posibletramite.getTrposiblecodigoorigen());
		}
		if (posibletramite != null
				&& posibletramite.getTrposiblecodigosiguiente() != null) {
			where.append(" AND t1.TRPOSIBLECODIGOSIGUIENTE = ?");
			params.add(posibletramite.getTrposiblecodigosiguiente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PosibleTramite entity
	 * 
	 * @param posibletramite
	 *            PosibleTramite Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(PosibleTramite posibletramite,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PosibleTramiteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (posibletramite != null
				&& posibletramite.getTrposiblecodigo() != null) {
			where.append(" AND UPPER(t1.TRPOSIBLECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(posibletramite.getTrposiblecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ posibletramite.getTrposiblecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRPOSIBLECODIGO IS NOT NULL");
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(posibletramite.getTipoProcedimiento().getPcodigo());
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPnombre() != null) {
			where.append(" AND UPPER(t2.PNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(posibletramite.getTipoProcedimiento().getPnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ posibletramite.getTipoProcedimiento().getPnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBRE IS NOT NULL");
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPnombree() != null) {
			where.append(" AND UPPER(t2.PNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(posibletramite.getTipoProcedimiento().getPnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ posibletramite.getTipoProcedimiento().getPnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBREE IS NOT NULL");
		}
		if (posibletramite != null
				&& posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPbaja() != null) {
			where.append(" AND t2.PBAJA = ?");
			params.add(posibletramite.getTipoProcedimiento().getPbaja());
		}
		if (posibletramite != null
				&& posibletramite.getTrposiblecodigoorigen() != null) {
			where.append(" AND UPPER(t1.TRPOSIBLECODIGOORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(posibletramite.getTrposiblecodigoorigen()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ posibletramite.getTrposiblecodigoorigen()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TRPOSIBLECODIGOORIGEN IS NOT NULL");
		}
		if (posibletramite != null
				&& posibletramite.getTrposiblecodigosiguiente() != null) {
			where.append(" AND UPPER(t1.TRPOSIBLECODIGOSIGUIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(posibletramite.getTrposiblecodigosiguiente()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ posibletramite.getTrposiblecodigosiguiente()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TRPOSIBLECODIGOSIGUIENTE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllPosibleTramite(PosibleTramite posibletramite,
			CensoMonitor censoMonitor, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCODIGO=t2.TRPOSIBLECODIGOSIGUIENTE(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT t1.TRCODIGO TRCODIGO, t1.TRNOMBRE TRNOMBRE,NVL(t1.TRNOMBREE,t1.TRNOMBRE) TRNOMBREE, t1.TRBAJA TRBAJA, t1.ISKONTSUMONET ISKONTSUMONET, t1.PCODIGO PCODIGO, t1.ID_PERFIL IDPERFIL "
						+ "FROM TRAMITE t1,POSIBLE_TRAMITE t2 ");

		where.append(" AND t2.TRPOSIBLECODIGOORIGEN = ?");
		params.add(posibletramite.getTrposiblecodigoorigen());

		where.append(" AND t2.PCODIGO = ?");
		params.add(posibletramite.getTipoProcedimiento().getPcodigo());

		if (posibletramite.getTipoProcedimiento().getPcodigo() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo()
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND t2.TIPOSOLICITUD = ?");
			params.add(posibletramite.getTiposolicitud());
		}

		if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilSolicitudes().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		} else if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilSanciones().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		} else if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		} else if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilInspecciones().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<Tramite>() {
					public Tramite mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Tramite(resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet
										.getString("TRNOMBREE"), resultSet
										.getDate("TRBAJA"), resultSet
										.getString("ISKONTSUMONET"), resultSet
										.getString("PCODIGO"), resultSet
										.getString("IDPERFIL"), null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllPosibleTramiteCount(PosibleTramite posibletramite,
			CensoMonitor censoMonitor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCODIGO=t2.TRPOSIBLECODIGOSIGUIENTE(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE t1,POSIBLE_TRAMITE t2 ");

		where.append(" AND t2.TRPOSIBLECODIGOORIGEN = ?");
		params.add(posibletramite.getTrposiblecodigoorigen());

		where.append(" AND t2.PCODIGO = ?");
		params.add(posibletramite.getTipoProcedimiento().getPcodigo());

		if (posibletramite.getTipoProcedimiento().getPcodigo() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo()
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND t2.TIPOSOLICITUD = ?");
			params.add(posibletramite.getTiposolicitud());
		}

		if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilSolicitudes().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		} else if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilSanciones().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		} else if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		} else if (posibletramite.getTipoProcedimiento().getPcodigo()
				.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			where.append(" AND (t1.ID_PERFIL <= ? ");
			params.add(censoMonitor.getPerfilInspecciones().getIdPerfil());
			where.append(" OR t1.ID_PERFIL IS NULL) ");
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Removes a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	public void removeAllPosiblesTramitesTemporal(Tramite tramite) {
		try {
			String query = "DELETE FROM TEMPORAL_POSIBLE_TRAMITE WHERE TRPOSIBLECODIGOORIGEN = ? AND PCODIGO=? ";
			this.jdbcTemplate.update(query, tramite.getTrcodigo(),
					tramite.getPcodigo());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 */
	public void addPosiblesTramitesTemporal(Tramite tramite) {

		String query = "INSERT INTO TEMPORAL_POSIBLE_TRAMITE (TRPOSIBLECODIGO, PCODIGO, TRPOSIBLECODIGOORIGEN, TRPOSIBLECODIGOSIGUIENTE,TIPOSOLICITUD) SELECT TRPOSIBLECODIGO, PCODIGO, TRPOSIBLECODIGOORIGEN, TRPOSIBLECODIGOSIGUIENTE,TIPOSOLICITUD FROM POSIBLE_TRAMITE  WHERE TRPOSIBLECODIGOORIGEN = ? AND PCODIGO=? ";
		this.jdbcTemplate.update(query, tramite.getTrcodigo(),
				tramite.getPcodigo());
	}

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tramite> findAllPosibleTramiteTemporal(
			PosibleTramite posibletramite, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCODIGO=t2.TRPOSIBLECODIGOSIGUIENTE(+)	AND t1.FCODIGO= t3.FCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.TRCODIGO TRCODIGO, t1.TRNOMBRE TRNOMBRE,t1.TRNOMBREE TRNOMBREE, t1.TRBAJA TRBAJA, t1.ISKONTSUMONET ISKONTSUMONET, t1.PCODIGO PCODIGO, t1.ID_PERFIL IDPERFIL,t3.FCODIGO FASEFCODIGO,t3.FNOMBRE FASEFNOMBRE,t3.FNOMBREE FASEFNOMBREE,t3.FBAJA FASEFBAJA,t3.PCODIGO FASEPCODIGO "
						+ "FROM TRAMITE t1,TEMPORAL_POSIBLE_TRAMITE t2, FASE t3 ");

		where.append(" AND t2.TRPOSIBLECODIGOORIGEN = ?");
		params.add(posibletramite.getTrposiblecodigoorigen());

		where.append(" AND t2.PCODIGO = ?");
		params.add(posibletramite.getTipoProcedimiento().getPcodigo());

		if (posibletramite.getTipoProcedimiento().getPcodigo() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo()
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND t2.TIPOSOLICITUD = ?");
			params.add(posibletramite.getTiposolicitud());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Tramite>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<Tramite>() {
					public Tramite mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Tramite(resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet
										.getString("TRNOMBREE"), resultSet
										.getDate("TRBAJA"), resultSet
										.getString("ISKONTSUMONET"), resultSet
										.getString("PCODIGO"), resultSet
										.getString("IDPERFIL"), null, new Fase(
										resultSet.getString("FaseFCODIGO"),
										resultSet.getString("FaseFNOMBRE"),
										resultSet.getString("FaseFNOMBREE"),
										resultSet.getDate("FaseFBAJA"),
										new TipoProcedimiento(resultSet
												.getString("FasePCODIGO"),
												null, null, null)));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllPosibleTramiteTemporalCount(PosibleTramite posibletramite) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCODIGO=t2.TRPOSIBLECODIGOSIGUIENTE(+) AND t1.FCODIGO= t3.FCODIGO(+)  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE t1,TEMPORAL_POSIBLE_TRAMITE t2, FASE t3 ");

		where.append(" AND t2.TRPOSIBLECODIGOORIGEN = ?");
		params.add(posibletramite.getTrposiblecodigoorigen());

		where.append(" AND t2.PCODIGO = ?");
		params.add(posibletramite.getTipoProcedimiento().getPcodigo());

		if (posibletramite.getTipoProcedimiento().getPcodigo() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo()
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND t2.TIPOSOLICITUD = ?");
			params.add(posibletramite.getTiposolicitud());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllExistePosibleTramiteTemporalCount(
			PosibleTramite posibletramite) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCODIGO=t2.TRPOSIBLECODIGOSIGUIENTE(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM TRAMITE t1,TEMPORAL_POSIBLE_TRAMITE t2 ");

		where.append(" AND t2.TRPOSIBLECODIGOORIGEN = ?");
		params.add(posibletramite.getTrposiblecodigoorigen());

		where.append(" AND t2.TRPOSIBLECODIGOSIGUIENTE = ?");
		params.add(posibletramite.getTrposiblecodigosiguiente());

		where.append(" AND t2.PCODIGO = ?");
		params.add(posibletramite.getTipoProcedimiento().getPcodigo());

		if (posibletramite.getTipoProcedimiento().getPcodigo() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo()
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			where.append(" AND t2.TIPOSOLICITUD = ?");
			params.add(posibletramite.getTiposolicitud());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return PosibleTramite
	 */
	public PosibleTramite addPosibleTramiteTemporal(
			PosibleTramite posibletramite) {
		String query = "INSERT INTO TEMPORAL_POSIBLE_TRAMITE (TRPOSIBLECODIGO, PCODIGO, TRPOSIBLECODIGOORIGEN, TRPOSIBLECODIGOSIGUIENTE,TIPOSOLICITUD) VALUES (?,?,?,?,?)";
		Object getTipoProcedimientoPcodigoAux = null;
		if (posibletramite.getTipoProcedimiento() != null
				&& posibletramite.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = posibletramite
					.getTipoProcedimiento().getPcodigo();
		}
		this.jdbcTemplate.update(query, posibletramite.getTrposiblecodigo(),
				getTipoProcedimientoPcodigoAux,
				posibletramite.getTrposiblecodigoorigen(),
				posibletramite.getTrposiblecodigosiguiente(),
				posibletramite.getTiposolicitud());
		return posibletramite;
	}

	/**
	 * Removes a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return
	 */
	public void removePosibleTramiteTemporal(PosibleTramite posibletramite) {
		if (posibletramite.getTiposolicitud() != null) {
			String query = "DELETE FROM TEMPORAL_POSIBLE_TRAMITE WHERE TRPOSIBLECODIGOORIGEN=? AND TRPOSIBLECODIGOSIGUIENTE=? AND TIPOSOLICITUD=?";
			this.jdbcTemplate.update(query,
					posibletramite.getTrposiblecodigoorigen(),
					posibletramite.getTrposiblecodigosiguiente(),
					posibletramite.getTiposolicitud());
		} else {
			String query = "DELETE FROM TEMPORAL_POSIBLE_TRAMITE WHERE TRPOSIBLECODIGOORIGEN=? AND TRPOSIBLECODIGOSIGUIENTE=? ";
			this.jdbcTemplate.update(query,
					posibletramite.getTrposiblecodigoorigen(),
					posibletramite.getTrposiblecodigosiguiente());
		}
	}

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 */
	public void addAllPosibleTramites(Tramite tramite) {

		String query = "INSERT INTO POSIBLE_TRAMITE(TRPOSIBLECODIGO, PCODIGO, TRPOSIBLECODIGOORIGEN, TRPOSIBLECODIGOSIGUIENTE,TIPOSOLICITUD) SELECT TRPOSIBLECODIGO, PCODIGO, TRPOSIBLECODIGOORIGEN, TRPOSIBLECODIGOSIGUIENTE, TIPOSOLICITUD FROM TEMPORAL_POSIBLE_TRAMITE WHERE TRPOSIBLECODIGOORIGEN = ? AND PCODIGO=? ";
		this.jdbcTemplate.update(query, tramite.getTrcodigo(),
				tramite.getPcodigo());
	}

	/**
	 * Deletes a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	public void removeAllPosibleTramites(Tramite tramite) {
		String query = "DELETE  FROM POSIBLE_TRAMITE "
				+ " WHERE TRPOSIBLECODIGOORIGEN = ? AND PCODIGO=?";

		this.jdbcTemplate.update(query, tramite.getTrcodigo(),
				tramite.getPcodigo());
	}
}