package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.Tramite;

/**
 * PosibleTramiteDao  
 * 
 *  
 */

public interface PosibleTramiteDao {

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	PosibleTramite add(PosibleTramite posibletramite);

	/**
	 * Updates a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	PosibleTramite update(PosibleTramite posibletramite);

	/**
	 * Finds a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	PosibleTramite find(PosibleTramite posibletramite);

	/**
	 * Deletes a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return
	 */
	void remove(PosibleTramite posibletramite);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PosibleTramite> findAll(PosibleTramite posibletramite,
			Pagination pagination);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return Long
	 */
	Long findAllCount(PosibleTramite posibletramite);

	/**
	 * Finds rows in the PosibleTramite table using like.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PosibleTramite> findAllLike(PosibleTramite posibletramite,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the PosibleTramite table using like.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(PosibleTramite posibletramite, Boolean startsWith);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllPosibleTramite(PosibleTramite posibletramite,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllPosibleTramiteCount(PosibleTramite posibletramite,
			CensoMonitor censoMonitor);

	/**
	 * Removes a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	public void removeAllPosiblesTramitesTemporal(Tramite tramite);

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 */
	public void addPosiblesTramitesTemporal(Tramite tramite);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllPosibleTramiteTemporal(
			PosibleTramite posibletramite, Pagination pagination);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return Long
	 */
	public Long findAllPosibleTramiteTemporalCount(PosibleTramite posibletramite);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            PosibleTramite
	 * @return Long
	 */
	public Long findAllExistePosibleTramiteTemporalCount(
			PosibleTramite posibletramite);

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return PosibleTramite
	 */
	public PosibleTramite addPosibleTramiteTemporal(
			PosibleTramite posibletramite);

	/**
	 * Removes a single row in the PosibleTramite table.
	 * 
	 * @param posibletramite
	 *            Pagination
	 * @return
	 */
	public void removePosibleTramiteTemporal(PosibleTramite posibletramite);

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 */
	public void addAllPosibleTramites(Tramite tramite);

	/**
	 * Deletes a single row in the PosibleTramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	public void removeAllPosibleTramites(Tramite tramite);
}
