package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * * PlantillaTramiteDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PlantillaTramiteDaoImpl implements PlantillaTramiteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<PlantillaTramite> rwMap = new RowMapper<PlantillaTramite>() {
		public PlantillaTramite mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new PlantillaTramite(resultSet.getString("PTCODIGO"),
					resultSet.getString("PTCOOR"),
					resultSet.getString("PTNOMBRE"),
					resultSet.getString("PTNOMBREE"),
					resultSet.getBlob("PTPLANTILLA"), null,
					resultSet.getDate("PTULTMODIFICACION"),
					resultSet.getString("PTCONTENTTYPEFILE"),
					resultSet.getString("PTNOFILE"),
					resultSet.getInt("PTSIZEFILE"),
					resultSet.getString("PTCONTENTTYPEFILEE"),
					resultSet.getString("PTNOFILEE"),
					resultSet.getInt("PTSIZEFILEE"), new Tramite(
							resultSet.getString("TramiteTRCODIGO"),
							resultSet.getString("TramiteTRNOMBRE"),
							resultSet.getString("TramiteTRNOMBREE"),
							resultSet.getDate("TramiteTRBAJA"), null, null,
							null, null, null), resultSet.getString("PCODIGO"),
					resultSet.getString("TIPOSOLICITUD"),
					resultSet.getString("NOLOCALIZABLE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	public PlantillaTramite add(PlantillaTramite plantillatramite) {

		String query = "INSERT INTO PLANTILLA_TRAMITE( PTCODIGO,PTCODTRA,PTCOOR,PTNOMBRE,PTNOMBREE,PTPLANTILLA,PTPLANTILLAE,PTULTMODIFICACION,PTCONTENTTYPEFILE,PTNOFILE,PTSIZEFILE,PTCONTENTTYPEFILEE,PTNOFILEE,PTSIZEFILEE,TIPOSOLICITUD,NOLOCALIZABLE)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getTramiteTrcodigoAux = null;
		if (plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			getTramiteTrcodigoAux = plantillatramite.getTramite().getTrcodigo();
		}
		byte[] plantilla = null;
		if (plantillatramite.getPtplantilla() != null) {
			plantilla = Y41bJdbcUtils.ConvertBlobToByte(plantillatramite
					.getPtplantilla());
		}
		this.jdbcTemplate.update(query, plantillatramite.getPtcodigo(),
				getTramiteTrcodigoAux, plantillatramite.getPtcoor(),
				plantillatramite.getPtnombre(),
				plantillatramite.getPtnombree(), plantilla,
				plantillatramite.getPtplantillae(),
				plantillatramite.getPtultmodificacion(),
				plantillatramite.getPtcontenttypefile(),
				plantillatramite.getPtnofile(),
				plantillatramite.getPtsizefile(),
				plantillatramite.getPtcontenttypefilee(),
				plantillatramite.getPtnofilee(),
				plantillatramite.getPtsizefilee(),
				plantillatramite.getTiposolicitud(),
				plantillatramite.getNolocalizable());
		return plantillatramite;
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	public PlantillaTramite update(PlantillaTramite plantillatramite) {
		String query = "UPDATE PLANTILLA_TRAMITE SET PTCODTRA=?,PTCOOR=?,PTNOMBRE=?,PTNOMBREE=?,PTPLANTILLA=?,PTPLANTILLAE=?,PTULTMODIFICACION=?,PTCONTENTTYPEFILE=?,PTNOFILE=?,PTSIZEFILE=?,PTCONTENTTYPEFILEE=?,PTNOFILEE=?,PTSIZEFILEE=?,TIPOSOLICITUD=?,NOLOCALIZABLE=? WHERE PTCODIGO=?";
		Object getTramiteTrcodigoAux = null;
		if (plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			getTramiteTrcodigoAux = plantillatramite.getTramite().getTrcodigo();
		}
		byte[] plantilla = null;
		if (plantillatramite.getPtplantilla() != null) {
			plantilla = Y41bJdbcUtils.ConvertBlobToByte(plantillatramite
					.getPtplantilla());
		}
		this.jdbcTemplate.update(query, getTramiteTrcodigoAux,
				plantillatramite.getPtcoor(), plantillatramite.getPtnombre(),
				plantillatramite.getPtnombree(), plantilla,
				plantillatramite.getPtplantillae(),
				plantillatramite.getPtultmodificacion(),
				plantillatramite.getPtcontenttypefile(),
				plantillatramite.getPtnofile(),
				plantillatramite.getPtsizefile(),
				plantillatramite.getPtcontenttypefilee(),
				plantillatramite.getPtnofilee(),
				plantillatramite.getPtsizefilee(),
				plantillatramite.getTiposolicitud(),
				plantillatramite.getNolocalizable(),
				plantillatramite.getPtcodigo());
		return plantillatramite;
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	public PlantillaTramite updatePlantilla(PlantillaTramite plantillatramite) {
		String query = "UPDATE PLANTILLA_TRAMITE SET PTNOMBRE=?,PTPLANTILLA=?,PTULTMODIFICACION=?,PTCONTENTTYPEFILE=?,PTNOFILE=?,PTSIZEFILE=?,TIPOSOLICITUD=?,NOLOCALIZABLE=? WHERE PTCODTRA=? AND PTCOOR = ?";
		Object getTramiteTrcodigoAux = null;
		if (plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			getTramiteTrcodigoAux = plantillatramite.getTramite().getTrcodigo();
		}
		byte[] plantilla = null;
		if (plantillatramite.getPtplantilla() != null) {
			plantilla = Y41bJdbcUtils.ConvertBlobToByte(plantillatramite
					.getPtplantilla());
		}
		this.jdbcTemplate.update(query, plantillatramite.getPtnombre(),
				plantilla, plantillatramite.getPtultmodificacion(),
				plantillatramite.getPtcontenttypefile(),
				plantillatramite.getPtnofile(),
				plantillatramite.getPtsizefile(),
				plantillatramite.getTiposolicitud(),
				plantillatramite.getNolocalizable(), getTramiteTrcodigoAux,
				plantillatramite.getPtcoor());
		return plantillatramite;
	}

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	@Transactional(readOnly = true)
	public PlantillaTramite find(PlantillaTramite plantillatramite) {
		try {
			String query = "SELECT t1.PTCODIGO PTCODIGO, t1.PTCOOR PTCOOR, t1.PTNOMBRE PTNOMBRE, t1.PTNOMBREE PTNOMBREE, t1.PTPLANTILLA PTPLANTILLA, t1.PTULTMODIFICACION PTULTMODIFICACION, t1.PTCONTENTTYPEFILE PTCONTENTTYPEFILE, t1.PTNOFILE PTNOFILE, t1.PTSIZEFILE PTSIZEFILE, t1.PTCONTENTTYPEFILEE PTCONTENTTYPEFILEE, t1.PTNOFILEE PTNOFILEE, t1.PTSIZEFILEE PTSIZEFILEE, t1.TIPOSOLICITUD TIPOSOLICITUD,t1.NOLOCALIZABLE NOLOCALIZABLE, t2.TRCODIGO TRAMITETRCODIGO, t2.TRNOMBRE TRAMITETRNOMBRE, t2.TRNOMBREE TRAMITETRNOMBREE, t2.TRBAJA TRAMITETRBAJA,t2.PCODIGO PCODIGO  "
					+ "FROM PLANTILLA_TRAMITE t1 , TRAMITE t2  "
					+ "WHERE t1.PTCODIGO = ?   AND t1.PTCODTRA= t2.TRCODIGO(+)  ";
			return (PlantillaTramite) this.jdbcTemplate.queryForObject(query,
					rwMap, plantillatramite.getPtcodigo());
		} catch (EmptyResultDataAccessException e) {
			return new PlantillaTramite();
		}
	}

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	@Transactional(readOnly = true)
	public PlantillaTramite findPlantillaTramite(
			PlantillaTramite plantillatramite) {
		String query = "SELECT t1.PTCODIGO PTCODIGO, t1.PTCOOR PTCOOR, t1.PTNOMBRE PTNOMBRE, t1.PTNOMBREE PTNOMBREE, t1.PTPLANTILLA PTPLANTILLA, t1.PTULTMODIFICACION PTULTMODIFICACION, t1.PTCONTENTTYPEFILE PTCONTENTTYPEFILE, t1.PTNOFILE PTNOFILE, t1.PTSIZEFILE PTSIZEFILE, t1.PTCONTENTTYPEFILEE PTCONTENTTYPEFILEE, t1.PTNOFILEE PTNOFILEE, t1.PTSIZEFILEE PTSIZEFILEE, t1.TIPOSOLICITUD TIPOSOLICITUD,t1.NOLOCALIZABLE NOLOCALIZABLE, t2.TRCODIGO TRAMITETRCODIGO, t2.TRNOMBRE TRAMITETRNOMBRE, t2.TRNOMBREE TRAMITETRNOMBREE, t2.TRBAJA TRAMITETRBAJA,t2.PCODIGO PCODIGO "
				+ "FROM PLANTILLA_TRAMITE t1 , TRAMITE t2  "
				+ "WHERE t2.TRCODIGO = ?  AND t1.PTCOOR = ? AND t1.PTCODTRA= t2.TRCODIGO(+)  ";
		return (PlantillaTramite) this.jdbcTemplate.queryForObject(query,
				rwMap, plantillatramite.getTramite().getTrcodigo(),
				plantillatramite.getPtcoor());
	}

	/**
	 * Removes a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return
	 */
	public void remove(PlantillaTramite plantillatramite) {
		String query = "DELETE  FROM PLANTILLA_TRAMITE WHERE PTCODIGO=?";
		this.jdbcTemplate.update(query, plantillatramite.getPtcodigo());
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaTramite> findAll(PlantillaTramite plantillatramite,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PTCODTRA= t2.TRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTCOOR PTCOOR,t1.PTNOMBRE PTNOMBRE,t1.PTNOMBREE PTNOMBREE, t1.PTPLANTILLA PTPLANTILLA,t1.PTULTMODIFICACION PTULTMODIFICACION,t1.PTCONTENTTYPEFILE PTCONTENTTYPEFILE,t1.PTNOFILE PTNOFILE,t1.PTSIZEFILE PTSIZEFILE,t1.PTCONTENTTYPEFILEE PTCONTENTTYPEFILEE,t1.PTNOFILEE PTNOFILEE,t1.PTSIZEFILEE PTSIZEFILEE, t1.TIPOSOLICITUD TIPOSOLICITUD,t1.NOLOCALIZABLE NOLOCALIZABLE,t2.TRCODIGO TRAMITETRCODIGO,t2.TRNOMBRE TRAMITETRNOMBRE,t2.TRNOMBREE TRAMITETRNOMBREE,t2.TRBAJA TRAMITETRBAJA,t2.PCODIGO PCODIGO "
						+ "FROM PLANTILLA_TRAMITE t1 ,TRAMITE t2 ");

		if (plantillatramite != null && plantillatramite.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(plantillatramite.getPtcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(plantillatramite.getTramite().getTrcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(plantillatramite.getTramite().getTrnombre());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(plantillatramite.getTramite().getTrnombree());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(plantillatramite.getTramite().getTrbaja());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(plantillatramite.getTramite().getPcodigo());
		}
		if (plantillatramite != null && plantillatramite.getPtcoor() != null) {
			where.append(" AND t1.PTCOOR = ?");
			params.add(plantillatramite.getPtcoor());
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND t1.PTNOMBRE = ?");
			params.add(plantillatramite.getPtnombre());
		}
		if (plantillatramite != null && plantillatramite.getPtnombree() != null) {
			where.append(" AND t1.PTNOMBREE = ?");
			params.add(plantillatramite.getPtnombree());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtultmodificacion() != null) {
			where.append(" AND t1.PTULTMODIFICACION = ?");
			params.add(plantillatramite.getPtultmodificacion());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefile() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILE = ?");
			params.add(plantillatramite.getPtcontenttypefile());
		}
		if (plantillatramite != null && plantillatramite.getPtnofile() != null) {
			where.append(" AND t1.PTNOFILE = ?");
			params.add(plantillatramite.getPtnofile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefile() != null) {
			where.append(" AND t1.PTSIZEFILE = ?");
			params.add(plantillatramite.getPtsizefile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefilee() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILEE = ?");
			params.add(plantillatramite.getPtcontenttypefilee());
		}
		if (plantillatramite != null && plantillatramite.getPtnofilee() != null) {
			where.append(" AND t1.PTNOFILEE = ?");
			params.add(plantillatramite.getPtnofilee());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefilee() != null) {
			where.append(" AND t1.PTSIZEFILEE = ?");
			params.add(plantillatramite.getPtsizefilee());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaTramite>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaTramite> findAllOrganismos() {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT distinct t1.PTCOOR PTCOOR "
						+ "FROM PLANTILLA_TRAMITE t1 ");

		return (List<PlantillaTramite>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<PlantillaTramite>() {
					public PlantillaTramite mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new PlantillaTramite(null, resultSet
								.getString("PTCOOR"), null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(PlantillaTramite plantillatramite) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PTCODTRA= t2.TRCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLA_TRAMITE t1   ,  TRAMITE t2  ");
		if (plantillatramite != null && plantillatramite.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(plantillatramite.getPtcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(plantillatramite.getTramite().getTrcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(plantillatramite.getTramite().getTrnombre());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(plantillatramite.getTramite().getTrnombree());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(plantillatramite.getTramite().getTrbaja());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(plantillatramite.getTramite().getPcodigo());
		}
		if (plantillatramite != null && plantillatramite.getPtcoor() != null) {
			where.append(" AND t1.PTCOOR = ?");
			params.add(plantillatramite.getPtcoor());
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND t1.PTNOMBRE = ?");
			params.add(plantillatramite.getPtnombre());
		}
		if (plantillatramite != null && plantillatramite.getPtnombree() != null) {
			where.append(" AND t1.PTNOMBREE = ?");
			params.add(plantillatramite.getPtnombree());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtultmodificacion() != null) {
			where.append(" AND t1.PTULTMODIFICACION = ?");
			params.add(plantillatramite.getPtultmodificacion());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefile() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILE = ?");
			params.add(plantillatramite.getPtcontenttypefile());
		}
		if (plantillatramite != null && plantillatramite.getPtnofile() != null) {
			where.append(" AND t1.PTNOFILE = ?");
			params.add(plantillatramite.getPtnofile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefile() != null) {
			where.append(" AND t1.PTSIZEFILE = ?");
			params.add(plantillatramite.getPtsizefile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefilee() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILEE = ?");
			params.add(plantillatramite.getPtcontenttypefilee());
		}
		if (plantillatramite != null && plantillatramite.getPtnofilee() != null) {
			where.append(" AND t1.PTNOFILEE = ?");
			params.add(plantillatramite.getPtnofilee());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefilee() != null) {
			where.append(" AND t1.PTSIZEFILEE = ?");
			params.add(plantillatramite.getPtsizefilee());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	@Transactional(readOnly = true)
	public Long findAllCountPlantillaTramiteByNombre(
			PlantillaTramite plantillatramite) {
		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM PLANTILLA_TRAMITE t1 , TRAMITE t2 ");
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  AND t1.PTCODTRA= t2.TRCODIGO(+) ");

		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(plantillatramite.getTramite().getTrcodigo());
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND UPPER(t1.PTNOMBRE) like ?");
			params.add(plantillatramite.getPtnombre().toUpperCase());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table. Nota: Este metodo no
	 * filtra nada si no tiene valor el campo TRCODIGO (codigo del tramite)
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaTramite> findAllTramiteByTramite(
			PlantillaTramite plantillatramite, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PTCODTRA= t2.TRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTCOOR PTCOOR,t1.PTNOMBRE PTNOMBRE,t1.PTNOMBREE PTNOMBREE, t1.PTPLANTILLA PTPLANTILLA,t1.PTULTMODIFICACION PTULTMODIFICACION,t1.PTCONTENTTYPEFILE PTCONTENTTYPEFILE,t1.PTNOFILE PTNOFILE,t1.PTSIZEFILE PTSIZEFILE,t1.PTCONTENTTYPEFILEE PTCONTENTTYPEFILEE,t1.PTNOFILEE PTNOFILEE,t1.PTSIZEFILEE PTSIZEFILEE, t1.TIPOSOLICITUD TIPOSOLICITUD,t1.NOLOCALIZABLE NOLOCALIZABLE,t2.TRCODIGO TRAMITETRCODIGO,t2.TRNOMBRE TRAMITETRNOMBRE,t2.TRNOMBREE TRAMITETRNOMBREE,t2.TRBAJA TRAMITETRBAJA, t2.PCODIGO PCODIGO "
						+ "FROM PLANTILLA_TRAMITE t1 ,TRAMITE t2 ");

		if (plantillatramite != null && plantillatramite.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(plantillatramite.getPtcodigo());
		}
		// Importante para que no filtre nada si no viene el código del tipo
		// de decisión
		where.append(" AND t2.TRCODIGO = ?");
		params.add(plantillatramite.getTramite().getTrcodigo());

		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(plantillatramite.getTramite().getTrnombre());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(plantillatramite.getTramite().getTrnombree());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(plantillatramite.getTramite().getTrbaja());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() == null) {
			where.append(" AND t2.TRBAJA IS NULL ");
		}
		if (plantillatramite != null && plantillatramite.getPtcoor() != null) {
			where.append(" AND t1.PTCOOR = ?");
			params.add(plantillatramite.getPtcoor());
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND t1.PTNOMBRE = ?");
			params.add(plantillatramite.getPtnombre());
		}
		if (plantillatramite != null && plantillatramite.getPtnombree() != null) {
			where.append(" AND t1.PTNOMBREE = ?");
			params.add(plantillatramite.getPtnombree());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtultmodificacion() != null) {
			where.append(" AND t1.PTULTMODIFICACION = ?");
			params.add(plantillatramite.getPtultmodificacion());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefile() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILE = ?");
			params.add(plantillatramite.getPtcontenttypefile());
		}
		if (plantillatramite != null && plantillatramite.getPtnofile() != null) {
			where.append(" AND t1.PTNOFILE = ?");
			params.add(plantillatramite.getPtnofile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefile() != null) {
			where.append(" AND t1.PTSIZEFILE = ?");
			params.add(plantillatramite.getPtsizefile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefilee() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILEE = ?");
			params.add(plantillatramite.getPtcontenttypefilee());
		}
		if (plantillatramite != null && plantillatramite.getPtnofilee() != null) {
			where.append(" AND t1.PTNOFILEE = ?");
			params.add(plantillatramite.getPtnofilee());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefilee() != null) {
			where.append(" AND t1.PTSIZEFILEE = ?");
			params.add(plantillatramite.getPtsizefilee());
		}
		if (plantillatramite != null && plantillatramite.getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(plantillatramite.getPcodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaTramite>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaTramite> findAllTramite(
			PlantillaTramite plantillatramite, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PTCODTRA= t2.TRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTCOOR PTCOOR,t1.PTNOMBRE PTNOMBRE,t1.PTNOMBREE PTNOMBREE, t1.PTPLANTILLA PTPLANTILLA,t1.PTULTMODIFICACION PTULTMODIFICACION,t1.PTCONTENTTYPEFILE PTCONTENTTYPEFILE,t1.PTNOFILE PTNOFILE,t1.PTSIZEFILE PTSIZEFILE,t1.PTCONTENTTYPEFILEE PTCONTENTTYPEFILEE,t1.PTNOFILEE PTNOFILEE,t1.PTSIZEFILEE PTSIZEFILEE, t1.TIPOSOLICITUD TIPOSOLICITUD,t1.NOLOCALIZABLE NOLOCALIZABLE,t2.TRCODIGO TRAMITETRCODIGO,t2.TRNOMBRE TRAMITETRNOMBRE,t2.TRNOMBREE TRAMITETRNOMBREE,t2.TRBAJA TRAMITETRBAJA, t2.PCODIGO PCODIGO "
						+ "FROM PLANTILLA_TRAMITE t1 ,TRAMITE t2 ");

		if (plantillatramite != null && plantillatramite.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(plantillatramite.getPtcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(plantillatramite.getTramite().getTrcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(plantillatramite.getTramite().getTrnombre());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(plantillatramite.getTramite().getTrnombree());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(plantillatramite.getTramite().getTrbaja());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() == null) {
			where.append(" AND t2.TRBAJA IS NULL ");
		}
		if (plantillatramite != null && plantillatramite.getPtcoor() != null) {
			where.append(" AND t1.PTCOOR = ?");
			params.add(plantillatramite.getPtcoor());
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND t1.PTNOMBRE = ?");
			params.add(plantillatramite.getPtnombre());
		}
		if (plantillatramite != null && plantillatramite.getPtnombree() != null) {
			where.append(" AND t1.PTNOMBREE = ?");
			params.add(plantillatramite.getPtnombree());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtultmodificacion() != null) {
			where.append(" AND t1.PTULTMODIFICACION = ?");
			params.add(plantillatramite.getPtultmodificacion());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefile() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILE = ?");
			params.add(plantillatramite.getPtcontenttypefile());
		}
		if (plantillatramite != null && plantillatramite.getPtnofile() != null) {
			where.append(" AND t1.PTNOFILE = ?");
			params.add(plantillatramite.getPtnofile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefile() != null) {
			where.append(" AND t1.PTSIZEFILE = ?");
			params.add(plantillatramite.getPtsizefile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefilee() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILEE = ?");
			params.add(plantillatramite.getPtcontenttypefilee());
		}
		if (plantillatramite != null && plantillatramite.getPtnofilee() != null) {
			where.append(" AND t1.PTNOFILEE = ?");
			params.add(plantillatramite.getPtnofilee());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefilee() != null) {
			where.append(" AND t1.PTSIZEFILEE = ?");
			params.add(plantillatramite.getPtsizefilee());
		}
		if (plantillatramite != null && plantillatramite.getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(plantillatramite.getPcodigo());
		}
		if (plantillatramite != null
				&& plantillatramite.getTiposolicitud() != null) {
			where.append(" AND t1.TIPOSOLICITUD = ?");
			params.add(plantillatramite.getTiposolicitud());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaTramite>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramiteCount(PlantillaTramite plantillatramite) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.PTCODTRA= t2.TRCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PLANTILLA_TRAMITE t1   ,  TRAMITE t2  ");
		if (plantillatramite != null && plantillatramite.getPtcodigo() != null) {
			where.append(" AND t1.PTCODIGO = ?");
			params.add(plantillatramite.getPtcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(plantillatramite.getTramite().getTrcodigo());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombre() != null) {
			where.append(" AND t2.TRNOMBRE = ?");
			params.add(plantillatramite.getTramite().getTrnombre());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombree() != null) {
			where.append(" AND t2.TRNOMBREE = ?");
			params.add(plantillatramite.getTramite().getTrnombree());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA = ?");
			params.add(plantillatramite.getTramite().getTrbaja());
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() == null) {
			where.append(" AND t2.TRBAJA IS NULL ");
		}
		if (plantillatramite != null && plantillatramite.getPtcoor() != null) {
			where.append(" AND t1.PTCOOR = ?");
			params.add(plantillatramite.getPtcoor());
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND t1.PTNOMBRE = ?");
			params.add(plantillatramite.getPtnombre());
		}
		if (plantillatramite != null && plantillatramite.getPtnombree() != null) {
			where.append(" AND t1.PTNOMBREE = ?");
			params.add(plantillatramite.getPtnombree());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtultmodificacion() != null) {
			where.append(" AND t1.PTULTMODIFICACION = ?");
			params.add(plantillatramite.getPtultmodificacion());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefile() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILE = ?");
			params.add(plantillatramite.getPtcontenttypefile());
		}
		if (plantillatramite != null && plantillatramite.getPtnofile() != null) {
			where.append(" AND t1.PTNOFILE = ?");
			params.add(plantillatramite.getPtnofile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefile() != null) {
			where.append(" AND t1.PTSIZEFILE = ?");
			params.add(plantillatramite.getPtsizefile());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefilee() != null) {
			where.append(" AND t1.PTCONTENTTYPEFILEE = ?");
			params.add(plantillatramite.getPtcontenttypefilee());
		}
		if (plantillatramite != null && plantillatramite.getPtnofilee() != null) {
			where.append(" AND t1.PTNOFILEE = ?");
			params.add(plantillatramite.getPtnofilee());
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefilee() != null) {
			where.append(" AND t1.PTSIZEFILEE = ?");
			params.add(plantillatramite.getPtsizefilee());
		}
		if (plantillatramite != null && plantillatramite.getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(plantillatramite.getPcodigo());
		}
		if (plantillatramite != null
				&& plantillatramite.getTiposolicitud() != null) {
			where.append(" AND t1.TIPOSOLICITUD = ?");
			params.add(plantillatramite.getTiposolicitud());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the PlantillaTramite table using like.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlantillaTramite> findAllLike(
			PlantillaTramite plantillatramite, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.PTCODTRA= t2.TRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.PTCODIGO PTCODIGO,t1.PTCOOR PTCOOR,t1.PTNOMBRE PTNOMBRE,t1.PTNOMBREE PTNOMBREE, t1.PTPLANTILLA PTPLANTILLA,t1.PTULTMODIFICACION PTULTMODIFICACION,t1.PTCONTENTTYPEFILE PTCONTENTTYPEFILE,t1.PTNOFILE PTNOFILE,t1.PTSIZEFILE PTSIZEFILE,t1.PTCONTENTTYPEFILEE PTCONTENTTYPEFILEE,t1.PTNOFILEE PTNOFILEE,t1.PTSIZEFILEE PTSIZEFILEE, t1.TIPOSOLICITUD TIPOSOLICITUD,t1.NOLOCALIZABLE NOLOCALIZABLE,t2.TRCODIGO TRAMITETRCODIGO,t2.TRNOMBRE TRAMITETRNOMBRE,t2.TRNOMBREE TRAMITETRNOMBREE,t2.TRBAJA TRAMITETRBAJA,t2.PCODIGO PCODIGO "
						+ "FROM PLANTILLA_TRAMITE t1 ,TRAMITE t2 ");

		if (plantillatramite != null && plantillatramite.getPtcodigo() != null) {
			where.append(" AND UPPER(t1.PTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + plantillatramite.getPtcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTCODIGO IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getTramite().getTrcodigo() + "%");
			} else {
				params.add("%" + plantillatramite.getTramite().getTrcodigo()
						+ "%");
			}
			where.append(" AND t2.TRCODIGO IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombre() != null) {
			where.append(" AND UPPER(t2.TRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getTramite().getTrnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantillatramite.getTramite().getTrnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNOMBRE IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrnombree() != null) {
			where.append(" AND UPPER(t2.TRNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getTramite().getTrnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ plantillatramite.getTramite().getTrnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNOMBREE IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getTramite() != null
				&& plantillatramite.getTramite().getTrbaja() != null) {
			where.append(" AND t2.TRBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getTramite().getTrbaja() + "%");
			} else {
				params.add("%" + plantillatramite.getTramite().getTrbaja()
						+ "%");
			}
			where.append(" AND t2.TRBAJA IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getPtcoor() != null) {
			where.append(" AND UPPER(t1.PTCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtcoor().toUpperCase() + "%");
			} else {
				params.add("%" + plantillatramite.getPtcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTCOOR IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getPtnombre() != null) {
			where.append(" AND UPPER(t1.PTNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtnombre().toUpperCase() + "%");
			} else {
				params.add("%" + plantillatramite.getPtnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTNOMBRE IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getPtnombree() != null) {
			where.append(" AND UPPER(t1.PTNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtnombree().toUpperCase() + "%");
			} else {
				params.add("%" + plantillatramite.getPtnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTNOMBREE IS NOT NULL");
		}
		if (plantillatramite != null
				&& plantillatramite.getPtultmodificacion() != null) {
			where.append(" AND t1.PTULTMODIFICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtultmodificacion() + "%");
			} else {
				params.add("%" + plantillatramite.getPtultmodificacion() + "%");
			}
			where.append(" AND t1.PTULTMODIFICACION IS NOT NULL");
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefile() != null) {
			where.append(" AND UPPER(t1.PTCONTENTTYPEFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtcontenttypefile()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ plantillatramite.getPtcontenttypefile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTCONTENTTYPEFILE IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getPtnofile() != null) {
			where.append(" AND UPPER(t1.PTNOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtnofile().toUpperCase() + "%");
			} else {
				params.add("%" + plantillatramite.getPtnofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTNOFILE IS NOT NULL");
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefile() != null) {
			where.append(" AND t1.PTSIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtsizefile() + "%");
			} else {
				params.add("%" + plantillatramite.getPtsizefile() + "%");
			}
			where.append(" AND t1.PTSIZEFILE IS NOT NULL");
		}
		if (plantillatramite != null
				&& plantillatramite.getPtcontenttypefilee() != null) {
			where.append(" AND UPPER(t1.PTCONTENTTYPEFILEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtcontenttypefilee()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ plantillatramite.getPtcontenttypefilee()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.PTCONTENTTYPEFILEE IS NOT NULL");
		}
		if (plantillatramite != null && plantillatramite.getPtnofilee() != null) {
			where.append(" AND UPPER(t1.PTNOFILEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtnofilee().toUpperCase() + "%");
			} else {
				params.add("%" + plantillatramite.getPtnofilee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PTNOFILEE IS NOT NULL");
		}
		if (plantillatramite != null
				&& plantillatramite.getPtsizefilee() != null) {
			where.append(" AND t1.PTSIZEFILEE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillatramite.getPtsizefilee() + "%");
			} else {
				params.add("%" + plantillatramite.getPtsizefilee() + "%");
			}
			where.append(" AND t1.PTSIZEFILEE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlantillaTramite>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
