package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.PlantillaTramite;

/**
 * * PlantillaTramiteDao  
 * 
 *  
 */

public interface PlantillaTramiteDao {

	/**
	 * Inserts a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite add(PlantillaTramite plantillatramite);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite update(PlantillaTramite plantillatramite);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	PlantillaTramite updatePlantilla(PlantillaTramite plantillatramite);

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite find(PlantillaTramite plantillatramite);

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return PlantillaTramite
	 */
	PlantillaTramite findPlantillaTramite(PlantillaTramite plantillatramite);

	/**
	 * Deletes a single row in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return
	 */
	void remove(PlantillaTramite plantillatramite);

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaTramite> findAll(PlantillaTramite plantillatramite,
			Pagination pagination);

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return List
	 */
	Long findAllCount(PlantillaTramite plantillatramite);

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            Pagination
	 * @return Long
	 */
	Long findAllCountPlantillaTramiteByNombre(PlantillaTramite plantillatramite);

	/**
	 * Finds a List of rows in the PlantillaTramite table. Nota: Este metodo no
	 * filtra nada si no tiene valor el campo TRCODIGO (codigo del tramite)
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaTramite> findAllTramiteByTramite(
			PlantillaTramite plantillatramite, Pagination pagination);

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaTramite> findAllTramite(PlantillaTramite plantillatramite,
			Pagination pagination);

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @return Long
	 */
	Long findAllTramiteCount(PlantillaTramite plantillatramite);

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @return List
	 */
	List<PlantillaTramite> findAllOrganismos();

	/**
	 * Finds rows in the PlantillaTramite table using like.
	 * 
	 * @param plantillatramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PlantillaTramite> findAllLike(PlantillaTramite plantillatramite,
			Pagination pagination, Boolean startsWith);
}
