package com.ejie.y41b.dao;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.PlantillaInformeCierreCampanha;

/**
 * Extraccion de datos para la plantilla Informe de Cierre de Campanha.
 * 
 *  
 */
public interface PlantillaInformeCierreCampanhaDao {

	/**
	 * 01. Cabecera de la plantilla de Informe de cierre de informe.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findCabecera(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 02. Actuaciones por protocolo y toma de muestras.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findActuacionesProtocoloMuestras(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 03. Productos de la campanha.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findProductosCampanha(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 04. Origen de las tomas de muestras.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findOrigenTomas(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 05. Suma de muestras indicativas y reglamentarias realizadas.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findSumaMuestrasIndicativasReglamentarias(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 06. Suma de protocolos estandar.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findSumaProtocolosEstandar(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 07. Suma de protocolos estandar con infraccion.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findSumaProtocolosEstandarInfraccion(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 08. Total de protocolos estandar.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findTotalProtocolosEstandar(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 08.5. Total de infracciones.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	@Transactional(readOnly = true)
	PlantillaInformeCierreCampanha findTotalInfracciones(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 09. Preguntas mas frecuentemente infringidas.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findPreguntasFrecuentementeInfringidas(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 09.4. Titulo pregunta1.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	public PlantillaInformeCierreCampanha findTituloPregunta1(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 09.5. Titulo pregunta2.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	public PlantillaInformeCierreCampanha findTituloPregunta2(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 09.6. Titulo pregunta3.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	public PlantillaInformeCierreCampanha findTituloPregunta3(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 10. Actas con incumplimiento.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findActasIncumplimiento(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 11. Suma de actuaciones con toma de muestras.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findSumaMuestras(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 12. Suma de tomas de muestra con infraccion.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findSumaMuestrasInfraccion(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 13. Suma de incumplimientos detectados.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findSumaIncumplimientosDetectados(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 14. Texto de incumplimientos detectados.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findTextoIncumplimientosDetectados(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 15. Actas de toma de muestras relacionadas con incumplimientos.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findActasMuestrasIncumplimientos(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 16. Actuaciones propuestas por SSCC.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findActuacionesPropuestasSSCC(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);

	/**
	 * 17. Establecimientos visitados durante las actuaciones.
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha findEstablecimientosVisitados(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha);
}
