package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.PlantillaDecision;

/**
 * * PlantillaDecisionDao  
 * 
 *  
 */

public interface PlantillaDecisionDao {

	/**
	 * Inserts a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision add(PlantillaDecision plantilladecision);

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision update(PlantillaDecision plantilladecision);

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision updateDecision(PlantillaDecision plantilladecision);

	/**
	 * Finds a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision find(PlantillaDecision plantilladecision);

	/**
	 * Finds a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            Pagination
	 * @return PlantillaDecision
	 */
	PlantillaDecision findPlantillaDecision(PlantillaDecision plantilladecision);

	/**
	 * Deletes a single row in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return
	 */
	void remove(PlantillaDecision plantilladecision);

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaDecision> findAll(PlantillaDecision plantilladecision,
			Pagination pagination);

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return List
	 */
	Long findAllCount(PlantillaDecision plantilladecision);

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	Long findAllCountPlantillaDecisionByNombre(
			PlantillaDecision plantillaDecision);

	/**
	 * Finds a List of rows in the PlantillaDecision table. Nota: Este metodo no
	 * filtra nada si no tiene valor el campo DECODIGO (código del tipo de
	 * decision)
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaDecision> findAllDecisionByDecision(
			PlantillaDecision plantilladecision, Pagination pagination);

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaDecision> findAllDecision(
			PlantillaDecision plantilladecision, Pagination pagination);

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @return Long
	 */
	Long findAllDecisionCount(PlantillaDecision plantilladecision);

	/**
	 * Finds rows in the PlantillaDecision table using like.
	 * 
	 * @param plantilladecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PlantillaDecision> findAllLike(PlantillaDecision plantilladecision,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @return List
	 */
	List<PlantillaDecision> findAllOrganismos();
}
