package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Empper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Peta1;

/**
 * Peta1DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Peta1DaoImpl implements Peta1Dao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Peta1> rwMap = new RowMapper<Peta1>() {
		public Peta1 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Peta1(new Empper(resultSet.getString("M7COPE"), null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null),
					resultSet.getString("M7COTA1"),
					resultSet.getDate("M7FECALTA"),
					resultSet.getString("M7USUALTA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Pagination
	 * @return Peta1
	 */
	public Peta1 add(Peta1 peta1) {
		String query = "INSERT INTO PETA1 (M7COPE, M7COTA1) VALUES (?,?)";
		Object EmpperPecodigoAux = null;
		if (peta1.getEmpper() != null
				&& peta1.getEmpper().getPecodigo() != null) {
			EmpperPecodigoAux = peta1.getEmpper().getPecodigo();
		}
		this.jdbcTemplate.update(query, EmpperPecodigoAux, peta1.getM7cota1());
		return peta1;
	}

	/**
	 * Updates a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Pagination
	 * @return Peta1
	 */
	public Peta1 update(Peta1 peta1) {
		String query = "UPDATE PETA1 SET  WHERE M7COPE=? AND M7COTA1=?";
		Object EmpperPecodigoAux = null;
		if (peta1.getEmpper() != null
				&& peta1.getEmpper().getPecodigo() != null) {
			EmpperPecodigoAux = peta1.getEmpper().getPecodigo();
		}
		this.jdbcTemplate.update(query, EmpperPecodigoAux, peta1.getM7cota1());
		return peta1;
	}

	/**
	 * Finds a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Pagination
	 * @return Peta1
	 */
	@Transactional(readOnly = true)
	public Peta1 find(Peta1 peta1) {
		String query = "SELECT t1.M7COPE M7COPE, t1.M7COTA1 M7COTA1, t1.M7FECALTA M7FECALTA, t1.M7USUALTA M7USUALTA FROM PETA1 t1  WHERE t1.M7COPE = ?   AND t1.M7COTA1 = ?   AND t1.M7FECALTA = ?   AND t1.M7USUALTA = ?  ";

		List<Peta1> peta1List = this.jdbcTemplate.query(query, this.rwMap,
				peta1.getEmpper().getPecodigo(), peta1.getM7cota1(),
				peta1.getM7fecalta(), peta1.getM7usualta());
		return (Peta1) DataAccessUtils.uniqueResult(peta1List);
	}

	/**
	 * Removes a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Pagination
	 * @return
	 */
	public void remove(Peta1 peta1) {
		String query = "DELETE FROM PETA1 WHERE M7COPE=? AND M7COTA1 IN ('01','20','48') ";
		this.jdbcTemplate.update(query, peta1.getEmpper().getPecodigo());
	}

	/**
	 * Finds a List of rows in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Peta1> findAll(Peta1 peta1, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M7COPE M7COPE,t1.M7COTA1 M7COTA1,t1.M7FECALTA M7FECALTA,t1.M7USUALTA M7USUALTA ");
		query.append("FROM PETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(peta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Peta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Peta1 peta1) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(peta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Peta1 table using like.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Peta1> findAllLike(Peta1 peta1, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M7COPE M7COPE,t1.M7COTA1 M7COTA1,t1.M7FECALTA M7FECALTA,t1.M7USUALTA M7USUALTA ");
		query.append("FROM PETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(peta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Peta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Peta1 table using like.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Peta1 peta1, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(peta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Peta1 entity
	 * 
	 * @param peta1
	 *            Peta1 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Peta1 peta1) {

		StringBuilder where = new StringBuilder(
				Peta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (peta1 != null && peta1.getEmpper().getPecodigo() != null) {
			where.append(" AND t1.M7COPE = ?");
			params.add(peta1.getEmpper().getPecodigo());
		}
		if (peta1 != null && peta1.getM7cota1() != null) {
			where.append(" AND t1.M7COTA1 = ?");
			params.add(peta1.getM7cota1());
		}
		if (peta1 != null && peta1.getM7fecalta() != null) {
			where.append(" AND t1.M7FECALTA = ?");
			params.add(peta1.getM7fecalta());
		}
		if (peta1 != null && peta1.getM7usualta() != null) {
			where.append(" AND t1.M7USUALTA = ?");
			params.add(peta1.getM7usualta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Peta1 entity
	 * 
	 * @param peta1
	 *            Peta1 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Peta1 peta1, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Peta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (peta1 != null && peta1.getEmpper().getPecodigo() != null) {
			where.append(" AND UPPER(t1.M7COPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(peta1.getEmpper().getPecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + peta1.getEmpper().getPecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M7COPE IS NOT NULL");
		}
		if (peta1 != null && peta1.getM7cota1() != null) {
			where.append(" AND UPPER(t1.M7COTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(peta1.getM7cota1().toUpperCase() + "%");
			} else {
				params.add("%" + peta1.getM7cota1().toUpperCase() + "%");
			}
			where.append(" AND t1.M7COTA1 IS NOT NULL");
		}
		if (peta1 != null && peta1.getM7fecalta() != null) {
			where.append(" AND t1.M7FECALTA = ?");
			params.add(peta1.getM7fecalta());
		}
		if (peta1 != null && peta1.getM7usualta() != null) {
			where.append(" AND UPPER(t1.M7USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(peta1.getM7usualta().toUpperCase() + "%");
			} else {
				params.add("%" + peta1.getM7usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.M7USUALTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
