package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Sector;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Pese;

/**
 * PeseDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PeseDaoImpl implements PeseDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Pese> rwMap = new RowMapper<Pese>() {
		public Pese mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Pese pese = new Pese();
			Empper empper = new Empper();
			empper.setPecodigo(resultSet.getString("M8COPE"));
			pese.setEmpper(empper);
			pese.setM8cose(resultSet.getString("M8COSE"));
			Sector sector = new Sector();
			sector.setSecodigo(resultSet.getString("M8COSE"));
			sector.setSenombre(resultSet.getString("SectorSENOMBRE"));
			sector.setSenombree(resultSet.getString("SectorSENOMBREE"));
			pese.setSector(sector);
			return pese;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pagination
	 * @return Pese
	 */
	public Pese add(Pese pese) {
		if (this.findAllCount(pese).intValue() == 0) {
			String query = "INSERT INTO Y41BD5T00 (M8COPE, M8COSE) VALUES (?,?)";
			Object EmpperPecodigoAux = null;
			if (pese.getEmpper() != null
					&& pese.getEmpper().getPecodigo() != null) {
				EmpperPecodigoAux = pese.getEmpper().getPecodigo();
			}
			this.jdbcTemplate
					.update(query, EmpperPecodigoAux, pese.getM8cose());
		}
		return pese;
	}

	/**
	 * Updates a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pagination
	 * @return Pese
	 */
	public Pese update(Pese pese) {
		String query = "UPDATE PESE SET  WHERE M8COPE=? AND M8COSE=?";
		Object EmpperPecodigoAux = null;
		if (pese.getEmpper() != null && pese.getEmpper().getPecodigo() != null) {
			EmpperPecodigoAux = pese.getEmpper().getPecodigo();
		}
		this.jdbcTemplate.update(query, EmpperPecodigoAux, pese.getM8cose());
		return pese;
	}

	/**
	 * Finds a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pagination
	 * @return Pese
	 */
	@Transactional(readOnly = true)
	public Pese find(Pese pese) {
		String query = "SELECT t1.M8COPE M8COPE, t1.M8COSE M8COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE FROM Y41BD5T00 t1, SECTOR t2 WHERE t1.M8COSE=t2.SECODIGO(+) AND t1.M8COPE = ? AND t1.M8COSE = ?   ";

		List<Pese> peseList = this.jdbcTemplate.query(query, this.rwMap, pese
				.getEmpper().getPecodigo(), pese.getM8cose());
		return (Pese) DataAccessUtils.uniqueResult(peseList);
	}

	/**
	 * Removes a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pagination
	 * @return
	 */
	public void remove(Pese pese) {
		String query = "DELETE FROM Y41BD5T00 WHERE M8COPE=? AND M8COSE=? ";
		this.jdbcTemplate.update(query, pese.getEmpper().getPecodigo(),
				pese.getM8cose());
	}

	/**
	 * Finds a List of rows in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pese> findAll(Pese pese, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M8COPE M8COPE,t1.M8COSE M8COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE ");
		query.append("FROM Y41BD5T00 t1, SECTOR t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pese);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.M8COSE=t2.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pese>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Pese pese) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BD5T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pese);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Pese table using like.
	 * 
	 * @param pese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pese> findAllLike(Pese pese, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M8COPE M8COPE,t1.M8COSE M8COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE ");
		query.append("FROM Y41BD5T00 t1, SECTOR t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pese);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.M8COSE=t2.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pese>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Pese table using like.
	 * 
	 * @param pese
	 *            Pese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Pese pese, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BD5T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(pese, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pese entity
	 * 
	 * @param pese
	 *            Pese Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Pese pese) {

		StringBuilder where = new StringBuilder(PeseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pese != null && pese.getEmpper() != null
				&& pese.getEmpper().getPecodigo() != null) {
			where.append(" AND t1.M8COPE = ?");
			params.add(pese.getEmpper().getPecodigo());
		}
		if (pese != null && pese.getM8cose() != null) {
			where.append(" AND t1.M8COSE = ?");
			params.add(pese.getM8cose());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pese entity
	 * 
	 * @param pese
	 *            Pese Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Pese pese, Boolean startsWith) {

		StringBuilder where = new StringBuilder(PeseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pese != null && pese.getEmpper().getPecodigo() != null) {
			where.append(" AND UPPER(t1.M8COPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pese.getEmpper().getPecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + pese.getEmpper().getPecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M8COPE IS NOT NULL");
		}
		if (pese != null && pese.getM8cose() != null) {
			where.append(" AND UPPER(t1.M8COSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pese.getM8cose().toUpperCase() + "%");
			} else {
				params.add("%" + pese.getM8cose().toUpperCase() + "%");
			}
			where.append(" AND t1.M8COSE IS NOT NULL");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public void volcarEmpperSectores(Empper empper) {
		String query = "DELETE FROM Y41BD5T00 WHERE M8COPE = ? ";
		this.jdbcTemplate.update(query, empper.getPecodigo());
		query = "INSERT INTO Y41BD5T00 SELECT M8COPE,M8COSE FROM PESE WHERE M8COPE = ? ";
		this.jdbcTemplate.update(query, empper.getPecodigo());
	}

	@Override
	public void removePese(Pese pese) {
		String query = "DELETE FROM PESE WHERE M8COPE = ? ";
		this.jdbcTemplate.update(query, pese.getEmpper().getPecodigo());
	}

	@Override
	public void addPese(Pese pese) {
		String query = "INSERT INTO PESE (M8COPE, M8COSE) VALUES (?,?)";
		Object EmpperOecodigoAux = null;
		if (pese.getEmpper() != null && pese.getEmpper().getPecodigo() != null) {
			EmpperOecodigoAux = pese.getEmpper().getPecodigo();
		}
		this.jdbcTemplate.update(query, EmpperOecodigoAux, pese.getM8cose());

	}
}
