package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Perfil;

/**
 * PerfilDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PerfilDaoImpl implements PerfilDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Perfil> rwMap = new RowMapper<Perfil>() {
		public Perfil mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Perfil(resultSet.getString("IDPERFIL"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("ISMANTENIMIENTO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return Perfil
	 */
	public Perfil add(Perfil perfil) {
		String query = "INSERT INTO PERFIL (ID_PERFIL, NOMBRE_ES, NOMBRE_EU, ISMANTENIMIENTO) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, perfil.getIdPerfil(),
				perfil.getNombreEs(), perfil.getNombreEu(),
				perfil.getIsmantenimiento());
		return perfil;
	}

	/**
	 * Updates a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return Perfil
	 */
	public Perfil update(Perfil perfil) {
		String query = "UPDATE PERFIL SET NOMBRE_ES=?, NOMBRE_EU=?, ISMANTENIMIENTO=? WHERE ID_PERFIL=?";
		this.jdbcTemplate.update(query, perfil.getNombreEs(),
				perfil.getNombreEu(), perfil.getIsmantenimiento(),
				perfil.getIdPerfil());
		return perfil;
	}

	/**
	 * Finds a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return Perfil
	 */
	@Transactional(readOnly = true)
	public Perfil find(Perfil perfil) {
		String query = "SELECT t1.ID_PERFIL IDPERFIL, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ISMANTENIMIENTO ISMANTENIMIENTO FROM PERFIL t1  WHERE t1.ID_PERFIL = ?  ";

		List<Perfil> perfilList = this.jdbcTemplate.query(query, this.rwMap,
				perfil.getIdPerfil());
		return (Perfil) DataAccessUtils.uniqueResult(perfilList);
	}

	/**
	 * Removes a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return
	 */
	public void remove(Perfil perfil) {
		String query = "DELETE FROM PERFIL WHERE ID_PERFIL=?";
		this.jdbcTemplate.update(query, perfil.getIdPerfil());
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAll(Perfil perfil, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ISMANTENIMIENTO ISMANTENIMIENTO ");
		query.append("FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(perfil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND ID_PERFIL <> '"
				+ Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO + "'");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Perfil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllControlMercado(Perfil perfil,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ISMANTENIMIENTO ISMANTENIMIENTO ");
		query.append("FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(perfil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Perfil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllSinSanciones(Perfil perfil, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ISMANTENIMIENTO ISMANTENIMIENTO ");
		query.append("FROM PERFIL t1 ");
		Map<String, ?> mapaWhere = this.getWhereMap(perfil);
		// Where clause & Params
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND ID_PERFIL <> '"
				+ Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO + "'");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Perfil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllPerfilFirma(Perfil perfil, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ISMANTENIMIENTO ISMANTENIMIENTO ");
		query.append("FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapPerfilFirma(perfil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Perfil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Perfil entity
	 * 
	 * @param perfil
	 *            Perfil Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapPerfilFirma(Perfil perfil) {

		StringBuilder where = new StringBuilder(
				PerfilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}
		if (perfil != null && perfil.getIsmantenimiento() != null) {
			where.append(" AND t1.ISMANTENIMIENTO = ?");
			params.add(perfil.getIsmantenimiento());
		}

		where.append(" AND (t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_INSTRUCTOR);
		where.append(" OR t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_COORDINADOR);
		where.append(" OR t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_DIRECTOR);
		where.append(" OR t1.ID_PERFIL = ?) ");
		params.add(Y41bConstantes.PERFIL_SUPERVISOR);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllPerfilTramite(Perfil perfil,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ISMANTENIMIENTO ISMANTENIMIENTO ");
		query.append("FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapPerfilTramite(perfil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Perfil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Perfil entity
	 * 
	 * @param perfil
	 *            Perfil Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapPerfilTramite(Perfil perfil) {

		StringBuilder where = new StringBuilder(
				PerfilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}
		if (perfil != null && perfil.getIsmantenimiento() != null) {
			where.append(" AND t1.ISMANTENIMIENTO = ?");
			params.add(perfil.getIsmantenimiento());
		}

		where.append(" AND (t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_ADMINISTRATIVO);
		where.append(" OR t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_INSTRUCTOR);
		where.append(" OR t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_COORDINADOR);
		where.append(" OR t1.ID_PERFIL = ? ");
		params.add(Y41bConstantes.PERFIL_DIRECTOR);
		where.append(" OR t1.ID_PERFIL = ?) ");
		params.add(Y41bConstantes.PERFIL_SUPERVISOR);

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Counts rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Perfil perfil) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(perfil);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllLike(Perfil perfil, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ISMANTENIMIENTO ISMANTENIMIENTO ");
		query.append("FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(perfil, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Perfil>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Perfil perfil, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PERFIL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(perfil, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Perfil entity
	 * 
	 * @param perfil
	 *            Perfil Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Perfil perfil) {

		StringBuilder where = new StringBuilder(
				PerfilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}
		if (perfil != null && perfil.getIsmantenimiento() != null) {
			where.append(" AND t1.ISMANTENIMIENTO = ?");
			params.add(perfil.getIsmantenimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Perfil entity
	 * 
	 * @param perfil
	 *            Perfil Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Perfil perfil, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PerfilDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND UPPER(t1.ID_PERFIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getIdPerfil().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getIdPerfil().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_PERFIL IS NOT NULL");
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (perfil != null && perfil.getIsmantenimiento() != null) {
			where.append(" AND UPPER(t1.ISMANTENIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getIsmantenimiento().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getIsmantenimiento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ISMANTENIMIENTO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
