package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Perfil;

/**
 * PerfilDao  
 * 
 *  
 */

public interface PerfilDao {

	/**
	 * Inserts a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil add(Perfil perfil);

	/**
	 * Updates a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil update(Perfil perfil);

	/**
	 * Finds a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil find(Perfil perfil);

	/**
	 * Deletes a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return
	 */
	void remove(Perfil perfil);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Perfil> findAll(Perfil perfil, Pagination pagination);

	/**
	 * Counts rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Long
	 */
	Long findAllCount(Perfil perfil);

	/**
	 * Finds rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Perfil> findAllLike(Perfil perfil, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Perfil perfil, Boolean startsWith);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllPerfilFirma(Perfil perfil, Pagination pagination);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllSinSanciones(Perfil perfil, Pagination pagination);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllControlMercado(Perfil perfil,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllPerfilTramite(Perfil perfil,
			Pagination pagination);
}
