package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ParametrosDaoImpl  
 * 
 *  
 */

@Repository(value = "ParametrosDao")
@Transactional
public class ParametrosDaoImpl implements ParametrosDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Parametros> rwMap = new RowMapper<Parametros>() {
		public Parametros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Parametros(resultSet.getString("PARAMETRO"), resultSet.getString("VALOR"),
					resultSet.getString("DESCRIPCIONES"), resultSet.getString("DESCRIPCIONEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return parametros
	 */
	public Parametros add(Parametros parametros) {
		String query = "INSERT INTO PARAMETROS (PARAMETRO, VALOR, DESCRIPCIONES, DESCRIPCIONEU) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, parametros.getParametro(), parametros.getValor(), parametros.getDescripciones(),
				parametros.getDescripcioneu());
		return parametros;
	}

	/**
	 * Updates a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return parametros
	 */
	public Parametros update(Parametros parametros) {
		String query = "UPDATE PARAMETROS SET VALOR=?, DESCRIPCIONES=?, DESCRIPCIONEU=? WHERE PARAMETRO=?";
		this.jdbcTemplate.update(query, parametros.getValor(), parametros.getDescripciones(),
				parametros.getDescripcioneu(), parametros.getParametro());
		return parametros;
	}

	/**
	 * Finds a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return parametros
	 */
	@Transactional(readOnly = true)
	public Parametros find(Parametros parametros) {
		String query = "SELECT t1.PARAMETRO PARAMETRO, t1.VALOR VALOR,t1.DESCRIPCIONES DESCRIPCIONES, t1.DESCRIPCIONEU DESCRIPCIONEU FROM PARAMETROS t1  WHERE t1.PARAMETRO = ?  ";

		List<Parametros> parametrosList = this.jdbcTemplate.query(query, this.rwMap, parametros.getParametro());
		return (Parametros) DataAccessUtils.uniqueResult(parametrosList);
	}

	/**
	 * Removes a single row in the PARAMETROS table.
	 * 
	 * @param PARAMETROS
	 *            Pagination
	 * @return
	 */
	public void remove(Parametros parametros) {
		String query = "DELETE FROM PARAMETROS WHERE PARAMETRO=?";
		this.jdbcTemplate.update(query, parametros.getParametro());
	}

	/**
	 * Finds a List of rows in the PARAMETROS table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parametros> findAll(Parametros parametros, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PARAMETRO PARAMETRO,t1.VALOR VALOR,t1.DESCRIPCIONES DESCRIPCIONES, t1.DESCRIPCIONEU DESCRIPCIONEU ");
		query.append("FROM PARAMETROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parametros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Parametros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PARAMETROS table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Parametros parametros) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PARAMETROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(parametros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the PARAMETROS table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parametros> findAllLike(Parametros parametros, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PARAMETRO PARAMETRO,t1.VALOR VALOR,t1.DESCRIPCIONES DESCRIPCIONES, t1.DESCRIPCIONEU DESCRIPCIONEU ");
		query.append("FROM PARAMETROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parametros, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Parametros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the PARAMETROS table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Parametros parametros, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PARAMETROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parametros, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PARAMETROS entity
	 * 
	 * @param Parametros
	 *            parametros Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Parametros parametros) {

		StringBuilder where = new StringBuilder(ParametrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parametros != null && parametros.getParametro() != null) {
			where.append(" AND t1.PARAMETRO = ?");
			params.add(parametros.getParametro());
		}
		if (parametros != null && parametros.getValor() != null) {
			where.append(" AND t1.VALOR = ?");
			params.add(parametros.getValor());
		}
		if (parametros != null && parametros.getDescripciones() != null) {
			where.append(" AND t1.DESCRIPCIONES = ?");
			params.add(parametros.getDescripciones());
		}
		if (parametros != null && parametros.getDescripcioneu() != null) {
			where.append(" AND t1.DESCRIPCIONEU = ?");
			params.add(parametros.getDescripcioneu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PARAMETROS entity
	 * 
	 * @param Parametros
	 *            parametros Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Parametros parametros, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ParametrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parametros != null && parametros.getParametro() != null) {
			where.append(" AND UPPER(t1.PARAMETRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getParametro().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getParametro().toUpperCase() + "%");
			}
			where.append(" AND t1.PARAMETRO IS NOT NULL");
		}
		if (parametros != null && parametros.getValor() != null) {
			where.append(" AND UPPER(t1.VALOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getValor().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getValor().toUpperCase() + "%");
			}
			where.append(" AND t1.VALOR IS NOT NULL");
		}
		if (parametros != null && parametros.getDescripciones() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DESCRIPCIONES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getDescripciones().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + parametros.getDescripciones().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DESCRIPCIONES IS NOT NULL");
		}
		if (parametros != null && parametros.getDescripcioneu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DESCRIPCIONEU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getDescripcioneu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + parametros.getDescripcioneu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DESCRIPCIONEU IS NOT NULL");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Devuelvefecha fin prevista.
	 * 
	 * @param fechaInicioExpediente
	 *            the fecha inicio expediente
	 * @return the int
	 */
	public Date devuelvefechaFinPrevista(Date fechaInicioExpediente) {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_SANCIONES_FECHAFINPREVISTA);
		List<Parametros> lparametros = this.findAll(parametros, null);

		if (lparametros != null && lparametros.size() > 0) {
			parametros = lparametros.get(0);
			String numeroMeses = parametros.getValor();
			int numMes = Integer.parseInt(numeroMeses);
			Date fechaFinPrevista = Y41bUtils.addMonth(fechaInicioExpediente, numMes);
			return fechaFinPrevista;
		} else {
			throw new Y41bUDAException("devuelvefechaFinPrevista", true, null);
		}

	}

	/**
	 * Devuelvefecha fin prevista.
	 * 
	 * @param fechaDelHecho
	 *            the fecha del hecho
	 * @param tipoInfraccion
	 *            the tipo infraccion
	 * @return the int
	 */
	public Date devuelvefechaPrescripcion(Date fechaDelHecho, String tipoInfraccion) {
		Parametros parametros = new Parametros();
		if (tipoInfraccion != null) {
			if (Y41bConstantes.SAN_CALIFICACION_LEVE.equals(tipoInfraccion)) {
				parametros.setParametro(Y41bConstantes.SANCIONES_PRESCRIPCION_LEVE);
			} else if (Y41bConstantes.SAN_CALIFICACION_GRAVE.equals(tipoInfraccion)) {
				parametros.setParametro(Y41bConstantes.SANCIONES_PRESCRIPCION_GRAVE);
			} else if (Y41bConstantes.SAN_CALIFICACION_MUYGRAVE.equals(tipoInfraccion)) {
				parametros.setParametro(Y41bConstantes.SANCIONES_PRESCRIPCION_MUYGRAVE);
			} else {
				return null;
			}
		} else {
			return null;
		}

		List<Parametros> lparametros = this.findAll(parametros, null);

		if (lparametros != null && lparametros.size() > 0) {
			parametros = lparametros.get(0);
			String numeroYears = parametros.getValor();
			int years = Integer.parseInt(numeroYears);
			Date fechaFinPrevista = Y41bUtils.addYear(fechaDelHecho, years);
			return fechaFinPrevista;
		} else {
			throw new Y41bUDAException("fechaDelHecho", true, null);
		}

	}

	/**
	 * superadaFechaEIKA
	 * 
	 * @return boolean
	 */
	public boolean superadaFechaEIKA() {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT CASE WHEN LIMITE IS NULL THEN 0 WHEN T.ACTUAL>=T.LIMITE THEN 1 ELSE 0 END AS RESULTADO FROM (SELECT (SELECT TO_CHAR(SYSDATE, 'YYYYMMDD') FROM DUAL) AS ACTUAL,(select VALOR from PARAMETROS where PARAMETRO='PARAMETRO_FECHA_EIKA') as LIMITE FROM DUAL) T");
			return (this.jdbcTemplate.queryForInt(query.toString()) > 0);
		} catch (Exception e) {
			throw new Y41bUDAException("superadaFechaEIKA", true, null);
		}
	}

	/**
	 * anyoFechaEIKA
	 * 
	 * @return int
	 */
	public int anyoFechaEIKA() {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT CASE WHEN ANYO IS NULL THEN 1900 ELSE TO_NUMBER(SUBSTR(ANYO,0,4)) END AS RESULTADO FROM (SELECT (SELECT VALOR from PARAMETROS where PARAMETRO='PARAMETRO_FECHA_EIKA') AS ANYO FROM DUAL)");
			return (this.jdbcTemplate.queryForInt(query.toString()));
		} catch (Exception e) {
			throw new Y41bUDAException("anyoFechaEIKA", true, null);
		}
	}

}
