package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.Date;
import java.util.List;

import com.ejie.y41b.model.Parametros;

/**
 * ParametrosDao  
 * 
 *  
 */

public interface ParametrosDao {

	/**
	 * Inserts a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Parametros
	 */
	Parametros add(Parametros parametros);

	/**
	 * Updates a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Parametros
	 */
	Parametros update(Parametros parametros);

	/**
	 * Finds a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Parametros
	 */
	Parametros find(Parametros parametros);

	/**
	 * Deletes a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return
	 */
	void remove(Parametros parametros);

	/**
	 * Finds a List of rows in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Parametros> findAll(Parametros parametros, Pagination pagination);

	/**
	 * Counts rows in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Long
	 */
	Long findAllCount(Parametros parametros);

	/**
	 * Finds rows in the Parametros table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Parametros> findAllLike(Parametros parametros, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Parametros table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Parametros parametros, Boolean startsWith);

	/**
	 * Devuelvefecha fin prevista.
	 * 
	 * @param fechaInicioExpediente
	 *            the fecha inicio expediente
	 * @return the int
	 */
	public Date devuelvefechaFinPrevista(Date fechaInicioExpediente);

	/**
	 * Devuelvefecha fin prevista.
	 * 
	 * @param fechaInicioExpediente
	 *            the fecha inicio expediente
	 * @return the int
	 */
	public Date devuelvefechaPrescripcion(Date fechaInicioExpediente, String tipoInfraccion);

	/**
	 * superadaFechaEIKA
	 * 
	 * @return boolean
	 */
	public boolean superadaFechaEIKA();

	/**
	 * anyoFechaEIKA
	 * 
	 * @return int
	 */
	public int anyoFechaEIKA();
}
