package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Estadopago;
import com.ejie.y41b.model.Metodopago;
import com.ejie.y41b.model.Movimientos;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * PagosDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class PagosDaoImpl implements PagosDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Pagos> rwMap = new RowMapper<Pagos>() {
		public Pagos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Pagos pagos = new Pagos(resultSet.getString("SGCODIGO"), resultSet.getString("SGREFERENCIA"),
					resultSet.getString("SGEXPEDIENTE"), resultSet.getString("SGIDEXPEDIENTE"),
					resultSet.getString("SGCODPROC"),
					new Establecimiento(resultSet.getString("SGIDESTABLECIMIENTO"), resultSet.getString("ESNOMBRE"),
							resultSet.getString("ESNIF"), resultSet.getString("ESNOCO")),
					resultSet.getDate("SGFECHAEMISION"), resultSet.getDate("SGFECHAESTADO"),
					resultSet.getDate("SGFECHALIMITEPAGO"), resultSet.getDate("SGFECHAPAGO"),
					resultSet.getString("SGFRACCIONADO"), resultSet.getBigDecimal("SGIMPORTE"),
					resultSet.getString("SGDESCRIPCIONPAGO"), resultSet.getString("SGOBSERVACIONES"),
					resultSet.getString("SGDIGITOCONTROL"), resultSet.getString("SGREFERENCIAFRACC"),
					resultSet.getBigDecimal("SGIMPORTEINTERES"), resultSet.getLong("SGNUMFRACCION"),
					new Metodopago(resultSet.getString("MetodopagoSBCODIGO"), resultSet.getString("MetodopagoSBDESCES"),
							resultSet.getString("MetodopagoSBDESCEU")),
					new Conceptopago(resultSet.getString("ConceptopagoSDCODIGO"),
							resultSet.getString("ConceptopagoSDDESCES"), resultSet.getString("ConceptopagoSDDESDEU"),
							resultSet.getBigDecimal("ConceptopagoSDTASAPRES"),
							resultSet.getBigDecimal("ConceptopagoSDTASATELE"),
							resultSet.getInt("ConceptopagoSDDIASLIMITE"),
							resultSet.getString("ConceptopagoSDAPLICPRESUP"),
							resultSet.getString("ConceptopagoSDAPLICPRESUP01"),
							resultSet.getString("ConceptopagoSDAPLICPRESUP20"),
							resultSet.getString("ConceptopagoSDAPLICPRESUP48"),
							resultSet.getString("ConceptopagoSDAPLICPRESUPFRAC"),
							resultSet.getString("ConceptopagoSDELEMENTOPEP"),
							resultSet.getString("ConceptopagoSDELEMENTOPEP01"),
							resultSet.getString("ConceptopagoSDELEMENTOPEP20"),
							resultSet.getString("ConceptopagoSDELEMENTOPEP48"),
							resultSet.getInt("ConceptopagoSDCONCEPTOING"),
							resultSet.getInt("ConceptopagoSDCONCEPTOINGFRAC"),
							resultSet.getString("ConceptopagoSDENTEMISORA"),
							resultSet.getString("ConceptopagoSDENTEMISORASIPCA"),
							resultSet.getLong("ConceptopagoSDSUFIJO"), resultSet.getLong("ConceptopagoSDEJERCICIO"),
							resultSet.getDate("ConceptopagoSDFECHABAJA"),
							new Tipoconceptopago(resultSet.getString("ConceptopagoSDTIPOCONCEPT"), null, null, null)),
					new Estadopago(resultSet.getString("EstadopagoSACODIGO"), resultSet.getString("EstadopagoSADESCES"),
							resultSet.getString("EstadopagoSADESCEU")));

			pagos.setSgimporteEuros(resultSet.getBigDecimal("SGIMPORTE") == null ? null
					: Y41bUtils.formatearAEuros(resultSet.getBigDecimal("SGIMPORTE")));
			pagos.setSgimporteinteresEuros(resultSet.getBigDecimal("SGIMPORTEINTERES") == null ? null
					: Y41bUtils.formatearAEuros(resultSet.getBigDecimal("SGIMPORTEINTERES")));
			pagos.setSgiban(resultSet.getString("SGIBAN"));
			pagos.setSgnombretitular(resultSet.getString("SGNOMBRETITULAR"));
			pagos.setSgfichero(resultSet.getString("SGFICHERO"));
			pagos.setSgfecalta(resultSet.getDate("SGFECALTA"));
			pagos.setSgfecmodif(resultSet.getDate("SGFECMODIF"));
			pagos.setSgnombre(resultSet.getString("SGNOMBRE"));
			pagos.setSgapellido1(resultSet.getString("SGAPELLIDO1"));
			pagos.setSgapellido2(resultSet.getString("SGAPELLIDO2"));
			pagos.setSgcomentarioes(resultSet.getString("SGCOMENTARIOES"));
			pagos.setSgcomentarioeu(resultSet.getString("SGCOMENTARIOEU"));
			pagos.setSgfechanot(resultSet.getDate("SGFECHANOT"));
			pagos.setSgaplicpresupuestaria(resultSet.getString("SGAPLICPRESUPUESTARIA"));
			pagos.setSgaplicpresupinteres(resultSet.getString("SGAPLICPRESUPINTERES"));

			pagos.setConceptopagoInteres(new Conceptopago(resultSet.getString("SGIDCONCEPTOINTERES"), null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null));

			pagos.setSgviaapremio(resultSet.getString("SGVIAAPREMIO"));
			pagos.setSgprontopago(resultSet.getString("SGPRONTOPAGO"));

			pagos.setSgcodsubvencion(resultSet.getString("SGCODSUBVENCION"));
			pagos.setSgfechareintegro(resultSet.getDate("SGFECHAREINTEGRO"));
			pagos.setSgcausareintegro(resultSet.getString("SGCAUSAREINTEGRO"));
			return pagos;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagination
	 * @return Pagos
	 */
	public Pagos add(Pagos pagos) {
		String query = "INSERT INTO PAGOS (SGCODIGO, SGIDMETODOPAGO, SGIDCONCEPTO, SGIDESTADOPAGO, SGREFERENCIA, SGEXPEDIENTE, SGIDEXPEDIENTE, SGCODPROC, SGIDESTABLECIMIENTO, SGFECHAEMISION, SGFECHAESTADO, SGFECHALIMITEPAGO, SGFECHAPAGO, SGFRACCIONADO, SGIMPORTE, SGDESCRIPCIONPAGO, SGOBSERVACIONES, SGDIGITOCONTROL, SGREFERENCIAFRACC, SGIMPORTEINTERES, SGNUMFRACCION, SGIBAN, SGNOMBRETITULAR, SGNOMBRE, SGAPELLIDO1, SGAPELLIDO2, SGCOMENTARIOES, SGCOMENTARIOEU, SGFECHANOT, SGAPLICPRESUPUESTARIA, SGAPLICPRESUPINTERES, SGIDCONCEPTOINTERES, SGVIAAPREMIO, SGPRONTOPAGO, SGCODSUBVENCION, SGFECHAREINTEGRO, SGCAUSAREINTEGRO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		Object getMetodopagoSbcodigoAux = null;
		if (pagos.getMetodopago() != null && pagos.getMetodopago().getSbcodigo() != null) {
			getMetodopagoSbcodigoAux = pagos.getMetodopago().getSbcodigo();
		}
		Object getConceptopagoSdcodigoAux = null;
		if (pagos.getConceptopago() != null && pagos.getConceptopago().getSdcodigo() != null) {
			getConceptopagoSdcodigoAux = pagos.getConceptopago().getSdcodigo();
		}
		Object getConceptointeresSdcodigoAux = null;
		if (pagos.getConceptopagoInteres() != null && pagos.getConceptopagoInteres().getSdcodigo() != null) {
			getConceptointeresSdcodigoAux = pagos.getConceptopagoInteres().getSdcodigo();
		}
		Object getEstadopagoSacodigoAux = null;
		if (pagos.getEstadopago() != null && pagos.getEstadopago().getSacodigo() != null) {
			getEstadopagoSacodigoAux = pagos.getEstadopago().getSacodigo();
		}
		Object getEstablecimientoCodigoAux = null;
		if (pagos.getSgestablecimiento() != null && pagos.getSgestablecimiento().getEscodigo() != null) {
			getEstablecimientoCodigoAux = pagos.getSgestablecimiento().getEscodigo();
		}

		this.jdbcTemplate.update(query, pagos.getSgcodigo(), getMetodopagoSbcodigoAux, getConceptopagoSdcodigoAux,
				getEstadopagoSacodigoAux, pagos.getSgreferencia(), pagos.getSgexpediente(), pagos.getSgidexpediente(),
				pagos.getSgcodproc(), getEstablecimientoCodigoAux, pagos.getSgfechaemision(), pagos.getSgfechaestado(),
				pagos.getSgfechalimitepago(), pagos.getSgfechapago(), pagos.getSgfraccionado(), pagos.getSgimporte(),
				pagos.getSgdescripcionpago(), pagos.getSgobservaciones(), pagos.getSgdigitocontrol(),
				pagos.getSgreferenciafracc(), pagos.getSgimporteinteres(), pagos.getSgnumfraccion(), pagos.getSgiban(),
				pagos.getSgnombretitular(), pagos.getSgnombre(), pagos.getSgapellido1(), pagos.getSgapellido2(),
				pagos.getSgcomentarioes(), pagos.getSgcomentarioeu(), pagos.getSgfechanot(),
				pagos.getSgaplicpresupuestaria(), pagos.getSgaplicpresupinteres(), getConceptointeresSdcodigoAux,
				pagos.getSgviaapremio(), pagos.getSgprontopago(), pagos.getSgcodsubvencion(),
				pagos.getSgfechareintegro(), pagos.getSgcausareintegro());
		return pagos;
	}

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagination
	 * @return Pagos
	 */
	public Pagos update(Pagos pagos) {
		String query = "UPDATE PAGOS SET SGIDMETODOPAGO=?, SGIDCONCEPTO=?, SGIDESTADOPAGO=?, SGREFERENCIA=?, SGEXPEDIENTE=?, SGIDEXPEDIENTE=?, SGCODPROC=?, SGIDESTABLECIMIENTO=?, SGFECHAEMISION=?, SGFECHAESTADO=?, SGFECHALIMITEPAGO=?, SGFECHAPAGO=?, SGFRACCIONADO=?, SGIMPORTE=?, SGDESCRIPCIONPAGO=?, SGOBSERVACIONES=?, SGDIGITOCONTROL=?, SGREFERENCIAFRACC=?, SGIMPORTEINTERES=?, SGNUMFRACCION=?, SGIBAN=?, SGNOMBRETITULAR=?, SGCOMENTARIOES=?, SGCOMENTARIOEU=?, SGFECHANOT=?, SGAPLICPRESUPUESTARIA=?, SGAPLICPRESUPINTERES=?, SGIDCONCEPTOINTERES=?, SGVIAAPREMIO=?,SGPRONTOPAGO=? WHERE SGCODIGO=?";
		Object getMetodopagoSbcodigoAux = null;
		if (pagos.getMetodopago() != null && pagos.getMetodopago().getSbcodigo() != null) {
			getMetodopagoSbcodigoAux = pagos.getMetodopago().getSbcodigo();
		}
		Object getConceptopagoSdcodigoAux = null;
		if (pagos.getConceptopago() != null && pagos.getConceptopago().getSdcodigo() != null) {
			getConceptopagoSdcodigoAux = pagos.getConceptopago().getSdcodigo();
		}
		Object getConceptointeresSdcodigoAux = null;
		if (pagos.getConceptopagoInteres() != null && pagos.getConceptopagoInteres().getSdcodigo() != null) {
			getConceptointeresSdcodigoAux = pagos.getConceptopagoInteres().getSdcodigo();
		}
		Object getEstadopagoSacodigoAux = null;
		if (pagos.getEstadopago() != null && pagos.getEstadopago().getSacodigo() != null) {
			getEstadopagoSacodigoAux = pagos.getEstadopago().getSacodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (pagos.getSgestablecimiento() != null && pagos.getSgestablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = pagos.getSgestablecimiento().getEscodigo();
		}
		this.jdbcTemplate.update(query, getMetodopagoSbcodigoAux, getConceptopagoSdcodigoAux, getEstadopagoSacodigoAux,
				pagos.getSgreferencia(), pagos.getSgexpediente(), pagos.getSgidexpediente(), pagos.getSgcodproc(),
				getEstablecimientoEscodigoAux, pagos.getSgfechaemision(), pagos.getSgfechaestado(),
				pagos.getSgfechalimitepago(), pagos.getSgfechapago(), pagos.getSgfraccionado(), pagos.getSgimporte(),
				pagos.getSgdescripcionpago(), pagos.getSgobservaciones(), pagos.getSgdigitocontrol(),
				pagos.getSgreferenciafracc(), pagos.getSgimporteinteres(), pagos.getSgnumfraccion(), pagos.getSgiban(),
				pagos.getSgnombretitular(), pagos.getSgcomentarioes(), pagos.getSgcomentarioeu(), pagos.getSgfechanot(),
				pagos.getSgaplicpresupuestaria(), pagos.getSgaplicpresupinteres(), getConceptointeresSdcodigoAux,
				pagos.getSgviaapremio(), pagos.getSgprontopago(), pagos.getSgcodigo());
		return pagos;
	}

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar) {
		String query = "UPDATE PAGOS SET SGIDESTABLECIMIENTO=? WHERE SGIDESTABLECIMIENTO=?";
		this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
	}

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagination
	 * @return Pagos
	 */
	@Transactional(readOnly = true)
	public Pagos find(Pagos pagos) {
		String query = "SELECT t1.SGCODIGO SGCODIGO, t1.SGREFERENCIA SGREFERENCIA, t1.SGEXPEDIENTE SGEXPEDIENTE, t1.SGIDEXPEDIENTE SGIDEXPEDIENTE, t1.SGCODPROC SGCODPROC, t1.SGIDESTABLECIMIENTO SGIDESTABLECIMIENTO, t7.UANOMBRE ESNOMBRE, t7.UANIF ESNIF, t7.UANOCO ESNOCO, t1.SGFECHAEMISION SGFECHAEMISION, t1.SGFECHAESTADO SGFECHAESTADO, t1.SGFECHALIMITEPAGO SGFECHALIMITEPAGO, t1.SGFECHAPAGO SGFECHAPAGO, t1.SGFRACCIONADO SGFRACCIONADO, t1.SGIMPORTE SGIMPORTE, t1.SGDESCRIPCIONPAGO SGDESCRIPCIONPAGO, t1.SGOBSERVACIONES SGOBSERVACIONES, t1.SGDIGITOCONTROL SGDIGITOCONTROL, t1.SGREFERENCIAFRACC SGREFERENCIAFRACC, t1.SGIMPORTEINTERES SGIMPORTEINTERES, t1.SGNUMFRACCION SGNUMFRACCION, t1.SGIBAN SGIBAN, t1.SGNOMBRETITULAR SGNOMBRETITULAR, t1.SGFICHERO SGFICHERO, t1.SGFECALTA SGFECALTA, t1.SGFECMODIF SGFECMODIF, t1.SGNOMBRE SGNOMBRE, t1.SGAPELLIDO1 SGAPELLIDO1, t1.SGAPELLIDO2 SGAPELLIDO2, t1.SGCOMENTARIOES SGCOMENTARIOES, t1.SGCOMENTARIOEU SGCOMENTARIOEU, t1.SGFECHANOT SGFECHANOT, t1.SGAPLICPRESUPUESTARIA SGAPLICPRESUPUESTARIA, t1.SGAPLICPRESUPINTERES SGAPLICPRESUPINTERES, t1.SGIDCONCEPTOINTERES SGIDCONCEPTOINTERES, t1.SGVIAAPREMIO SGVIAAPREMIO, t1.SGPRONTOPAGO SGPRONTOPAGO, t1.SGCODSUBVENCION SGCODSUBVENCION, t1.SGFECHAREINTEGRO SGFECHAREINTEGRO, t1.SGCAUSAREINTEGRO SGCAUSAREINTEGRO, t2.SBCODIGO METODOPAGOSBCODIGO, t2.SBDESCES METODOPAGOSBDESCES, t2.SBDESCEU METODOPAGOSBDESCEU, t3.SDCODIGO CONCEPTOPAGOSDCODIGO, t3.SDDESCES CONCEPTOPAGOSDDESCES, t3.SDDESDEU CONCEPTOPAGOSDDESDEU, t3.SDTASAPRES CONCEPTOPAGOSDTASAPRES, t3.SDTASATELE CONCEPTOPAGOSDTASATELE, t3.SDDIASLIMITE CONCEPTOPAGOSDDIASLIMITE, t3.SDAPLICPRESUP CONCEPTOPAGOSDAPLICPRESUP, t3.SDAPLICPRESUP01 CONCEPTOPAGOSDAPLICPRESUP01, t3.SDAPLICPRESUP20 CONCEPTOPAGOSDAPLICPRESUP20, t3.SDAPLICPRESUP48 CONCEPTOPAGOSDAPLICPRESUP48, t3.SDAPLICPRESUPFRAC CONCEPTOPAGOSDAPLICPRESUPFRAC, t3.SDELEMENTOPEP CONCEPTOPAGOSDELEMENTOPEP, t3.SDELEMENTOPEP01 CONCEPTOPAGOSDELEMENTOPEP01, t3.SDELEMENTOPEP20 CONCEPTOPAGOSDELEMENTOPEP20, t3.SDELEMENTOPEP48 CONCEPTOPAGOSDELEMENTOPEP48, t3.SDCONCEPTOING CONCEPTOPAGOSDCONCEPTOING, t3.SDCONCEPTOINGFRAC CONCEPTOPAGOSDCONCEPTOINGFRAC, t3.SDENTEMISORA CONCEPTOPAGOSDENTEMISORA, t3.SDENTEMISORASIPCA CONCEPTOPAGOSDENTEMISORASIPCA, t3.SDSUFIJO CONCEPTOPAGOSDSUFIJO, t3.SDEJERCICIO CONCEPTOPAGOSDEJERCICIO, t3.SDFECHABAJA CONCEPTOPAGOSDFECHABAJA, t4.SACODIGO ESTADOPAGOSACODIGO, t4.SADESCES ESTADOPAGOSADESCES, t4.SADESCEU ESTADOPAGOSADESCEU, t3.SDTIPOCONCEPT CONCEPTOPAGOSDTIPOCONCEPT "
				+ " FROM PAGOS t1 , METODOPAGO t2 , CONCEPTOPAGO t3 , ESTADOPAGO t4, ESTABLECIMIENTO t5, EXPEDIEN t6, SANINTERV t7 "
				+ " WHERE t1.SGCODIGO = ?   AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDESTABLECIMIENTO = t5.ESCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) AND t1.SGIDEXPEDIENTE=t6.EXCODIGO AND t5.ESCODIGO=t7.UAESCODIGO(+) AND t6.EXCODIGO=t7.UAEXCODIGO(+)";

		List<Pagos> pagosList = this.jdbcTemplate.query(query, this.rwMap, pagos.getSgcodigo());
		return (Pagos) DataAccessUtils.uniqueResult(pagosList);
	}

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagination
	 * @return Pagos
	 */
	@Transactional(readOnly = true)
	public Pagos findHR(Pagos pagos) {
		String query = "SELECT t1.SGCODIGO SGCODIGO, t1.SGREFERENCIA SGREFERENCIA, t1.SGEXPEDIENTE SGEXPEDIENTE, t1.SGIDEXPEDIENTE SGIDEXPEDIENTE, t1.SGCODPROC SGCODPROC, t1.SGIDESTABLECIMIENTO SGIDESTABLECIMIENTO, t5.ESNOMBRE ESNOMBRE, t5.ESNIF ESNIF, t5.ESNOCO ESNOCO, t1.SGFECHAEMISION SGFECHAEMISION, t1.SGFECHAESTADO SGFECHAESTADO, t1.SGFECHALIMITEPAGO SGFECHALIMITEPAGO, t1.SGFECHAPAGO SGFECHAPAGO, t1.SGFRACCIONADO SGFRACCIONADO, t1.SGIMPORTE SGIMPORTE, t1.SGDESCRIPCIONPAGO SGDESCRIPCIONPAGO, t1.SGOBSERVACIONES SGOBSERVACIONES, t1.SGDIGITOCONTROL SGDIGITOCONTROL, t1.SGREFERENCIAFRACC SGREFERENCIAFRACC, t1.SGIMPORTEINTERES SGIMPORTEINTERES, t1.SGNUMFRACCION SGNUMFRACCION, t1.SGIBAN SGIBAN, t1.SGNOMBRETITULAR SGNOMBRETITULAR, t1.SGFICHERO SGFICHERO, t1.SGFECALTA SGFECALTA, t1.SGFECMODIF SGFECMODIF, t1.SGNOMBRE SGNOMBRE, t1.SGAPELLIDO1 SGAPELLIDO1, t1.SGAPELLIDO2 SGAPELLIDO2, t1.SGCOMENTARIOES SGCOMENTARIOES, t1.SGCOMENTARIOEU SGCOMENTARIOEU, t1.SGFECHANOT SGFECHANOT, t1.SGAPLICPRESUPUESTARIA SGAPLICPRESUPUESTARIA, t1.SGAPLICPRESUPINTERES SGAPLICPRESUPINTERES, t1.SGIDCONCEPTOINTERES SGIDCONCEPTOINTERES, t1.SGCODSUBVENCION SGCODSUBVENCION, t1.SGFECHAREINTEGRO SGFECHAREINTEGRO, t1.SGCAUSAREINTEGRO SGCAUSAREINTEGRO, t1.SGVIAAPREMIO SGVIAAPREMIO, t1.SGPRONTOPAGO SGPRONTOPAGO, t2.SBCODIGO METODOPAGOSBCODIGO, t2.SBDESCES METODOPAGOSBDESCES, t2.SBDESCEU METODOPAGOSBDESCEU, t3.SDCODIGO CONCEPTOPAGOSDCODIGO, t3.SDDESCES CONCEPTOPAGOSDDESCES, t3.SDDESDEU CONCEPTOPAGOSDDESDEU, t3.SDTASAPRES CONCEPTOPAGOSDTASAPRES, t3.SDTASATELE CONCEPTOPAGOSDTASATELE, t3.SDDIASLIMITE CONCEPTOPAGOSDDIASLIMITE, t3.SDAPLICPRESUP CONCEPTOPAGOSDAPLICPRESUP, t3.SDAPLICPRESUP01 CONCEPTOPAGOSDAPLICPRESUP01, t3.SDAPLICPRESUP20 CONCEPTOPAGOSDAPLICPRESUP20, t3.SDAPLICPRESUP48 CONCEPTOPAGOSDAPLICPRESUP48, t3.SDAPLICPRESUPFRAC CONCEPTOPAGOSDAPLICPRESUPFRAC, t3.SDELEMENTOPEP CONCEPTOPAGOSDELEMENTOPEP, t3.SDELEMENTOPEP01 CONCEPTOPAGOSDELEMENTOPEP01, t3.SDELEMENTOPEP20 CONCEPTOPAGOSDELEMENTOPEP20, t3.SDELEMENTOPEP48 CONCEPTOPAGOSDELEMENTOPEP48, t3.SDCONCEPTOING CONCEPTOPAGOSDCONCEPTOING, t3.SDCONCEPTOINGFRAC CONCEPTOPAGOSDCONCEPTOINGFRAC, t3.SDENTEMISORA CONCEPTOPAGOSDENTEMISORA, t3.SDENTEMISORASIPCA CONCEPTOPAGOSDENTEMISORASIPCA, t3.SDSUFIJO CONCEPTOPAGOSDSUFIJO, t3.SDEJERCICIO CONCEPTOPAGOSDEJERCICIO, t3.SDFECHABAJA CONCEPTOPAGOSDFECHABAJA, t4.SACODIGO ESTADOPAGOSACODIGO, t4.SADESCES ESTADOPAGOSADESCES, t4.SADESCEU ESTADOPAGOSADESCEU, t3.SDTIPOCONCEPT CONCEPTOPAGOSDTIPOCONCEPT FROM PAGOS t1 , METODOPAGO t2 , CONCEPTOPAGO t3 , ESTADOPAGO t4, ESTABLECIMIENTO t5 WHERE t1.SGCODIGO = ? AND t1.SGIDMETODOPAGO = t2.SBCODIGO(+) AND t1.SGIDESTABLECIMIENTO = t5.ESCODIGO(+) AND t1.SGIDCONCEPTO = t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO = t4.SACODIGO(+) ";

		List<Pagos> pagosList = this.jdbcTemplate.query(query, this.rwMap, pagos.getSgcodigo());
		return (Pagos) DataAccessUtils.uniqueResult(pagosList);
	}

	/**
	 * Removes a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagination
	 * @return
	 */
	public void remove(Pagos pagos) {
		String query = "DELETE FROM PAGOS WHERE SGCODIGO=?";
		this.jdbcTemplate.update(query, pagos.getSgcodigo());
	}

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagos> findAll(Pagos pagos, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.SGCODIGO SGCODIGO, t1.SGREFERENCIA SGREFERENCIA, t1.SGEXPEDIENTE SGEXPEDIENTE, t1.SGIDEXPEDIENTE SGIDEXPEDIENTE, t1.SGCODPROC SGCODPROC, t1.SGIDESTABLECIMIENTO SGIDESTABLECIMIENTO, t1.SGCODSUBVENCION SGCODSUBVENCION, t1.SGFECHAREINTEGRO SGFECHAREINTEGRO, t1.SGCAUSAREINTEGRO SGCAUSAREINTEGRO, t5.ESNOCO ESNOCO, t5.ESNIF ESNIF, t5.ESNOMBRE ESNOMBRE, t1.SGFECHAEMISION SGFECHAEMISION, t1.SGFECHAESTADO SGFECHAESTADO, t1.SGFECHALIMITEPAGO SGFECHALIMITEPAGO, t1.SGFECHAPAGO SGFECHAPAGO, t1.SGFRACCIONADO SGFRACCIONADO, t1.SGIMPORTE SGIMPORTE, t1.SGDESCRIPCIONPAGO SGDESCRIPCIONPAGO, t1.SGOBSERVACIONES SGOBSERVACIONES, t1.SGDIGITOCONTROL SGDIGITOCONTROL, t1.SGREFERENCIAFRACC SGREFERENCIAFRACC, t1.SGIMPORTEINTERES SGIMPORTEINTERES, t1.SGNUMFRACCION SGNUMFRACCION, t1.SGIBAN SGIBAN, t1.SGNOMBRETITULAR SGNOMBRETITULAR, t1.SGFICHERO SGFICHERO, t1.SGFECALTA SGFECALTA, t1.SGFECMODIF SGFECMODIF, t1.SGNOMBRE SGNOMBRE, t1.SGAPELLIDO1 SGAPELLIDO1, t1.SGAPELLIDO2 SGAPELLIDO2, t1.SGCOMENTARIOES SGCOMENTARIOES, t1.SGCOMENTARIOEU SGCOMENTARIOEU, t1.SGFECHANOT SGFECHANOT, t1.SGAPLICPRESUPUESTARIA SGAPLICPRESUPUESTARIA, t1.SGAPLICPRESUPINTERES SGAPLICPRESUPINTERES, t1.SGIDCONCEPTOINTERES SGIDCONCEPTOINTERES, t1.SGVIAAPREMIO SGVIAAPREMIO, t1.SGPRONTOPAGO SGPRONTOPAGO, t2.SBCODIGO METODOPAGOSBCODIGO, t2.SBDESCES METODOPAGOSBDESCES, t2.SBDESCEU METODOPAGOSBDESCEU, t3.SDCODIGO CONCEPTOPAGOSDCODIGO, t3.SDDESCES CONCEPTOPAGOSDDESCES, t3.SDDESDEU CONCEPTOPAGOSDDESDEU, t3.SDTASAPRES CONCEPTOPAGOSDTASAPRES, t3.SDTASATELE CONCEPTOPAGOSDTASATELE, t3.SDDIASLIMITE CONCEPTOPAGOSDDIASLIMITE, t3.SDAPLICPRESUP CONCEPTOPAGOSDAPLICPRESUP, t3.SDAPLICPRESUP01 CONCEPTOPAGOSDAPLICPRESUP01, t3.SDAPLICPRESUP20 CONCEPTOPAGOSDAPLICPRESUP20, t3.SDAPLICPRESUP48 CONCEPTOPAGOSDAPLICPRESUP48, t3.SDAPLICPRESUPFRAC CONCEPTOPAGOSDAPLICPRESUPFRAC, t3.SDELEMENTOPEP CONCEPTOPAGOSDELEMENTOPEP, t3.SDELEMENTOPEP01 CONCEPTOPAGOSDELEMENTOPEP01, t3.SDELEMENTOPEP20 CONCEPTOPAGOSDELEMENTOPEP20, t3.SDELEMENTOPEP48 CONCEPTOPAGOSDELEMENTOPEP48, t3.SDCONCEPTOING CONCEPTOPAGOSDCONCEPTOING, t3.SDCONCEPTOINGFRAC CONCEPTOPAGOSDCONCEPTOINGFRAC, t3.SDENTEMISORA CONCEPTOPAGOSDENTEMISORA, t3.SDENTEMISORASIPCA CONCEPTOPAGOSDENTEMISORASIPCA, t3.SDSUFIJO CONCEPTOPAGOSDSUFIJO, t3.SDEJERCICIO CONCEPTOPAGOSDEJERCICIO, t3.SDFECHABAJA CONCEPTOPAGOSDFECHABAJA, t4.SACODIGO ESTADOPAGOSACODIGO, t4.SADESCES ESTADOPAGOSADESCES, t4.SADESCEU ESTADOPAGOSADESCEU, t3.SDTIPOCONCEPT CONCEPTOPAGOSDTIPOCONCEPT ");
		query.append("FROM PAGOS t1 ,METODOPAGO t2 ,CONCEPTOPAGO t3,ESTADOPAGO t4  ,ESTABLECIMIENTO t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pagos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) AND t1.SGIDESTABLECIMIENTO = t5.ESCODIGO(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pagos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagos> findAllPagos(PagosBusqueda pagosBusqueda, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT t6.EXCOOR || '"
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t6.EXNROR || '"
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
				+ "' || t6.EXNRAN SGEXPEDIENTE , t1.SGCODIGO SGCODIGO, t1.SGCODSUBVENCION SGCODSUBVENCION, t1.SGFECHAREINTEGRO SGFECHAREINTEGRO, t1.SGCAUSAREINTEGRO SGCAUSAREINTEGRO,t1.SGREFERENCIA SGREFERENCIA,t1.SGIDEXPEDIENTE SGIDEXPEDIENTE,t1.SGCODPROC SGCODPROC,t1.SGIDESTABLECIMIENTO SGIDESTABLECIMIENTO,t7.UANOMBRE ESNOMBRE,t7.UANIF ESNIF,t7.UANOCO ESNOCO,t1.SGFECHAEMISION SGFECHAEMISION,t1.SGFECHAESTADO SGFECHAESTADO,t1.SGFECHALIMITEPAGO SGFECHALIMITEPAGO,t1.SGFECHAPAGO SGFECHAPAGO,t1.SGFRACCIONADO SGFRACCIONADO,t1.SGIMPORTE SGIMPORTE,t1.SGDESCRIPCIONPAGO SGDESCRIPCIONPAGO,t1.SGOBSERVACIONES SGOBSERVACIONES,t1.SGDIGITOCONTROL SGDIGITOCONTROL,t1.SGREFERENCIAFRACC SGREFERENCIAFRACC,t1.SGIMPORTEINTERES SGIMPORTEINTERES,t1.SGNUMFRACCION SGNUMFRACCION, t1.SGIBAN SGIBAN, t1.SGNOMBRETITULAR SGNOMBRETITULAR, t1.SGFICHERO SGFICHERO, t1.SGFECALTA SGFECALTA, t1.SGFECMODIF SGFECMODIF, t1.SGNOMBRE SGNOMBRE, t1.SGAPELLIDO1 SGAPELLIDO1,t1.SGAPELLIDO2 SGAPELLIDO2, t1.SGCOMENTARIOES SGCOMENTARIOES, t1.SGCOMENTARIOEU SGCOMENTARIOEU, t1.SGFECHANOT SGFECHANOT, t1.SGAPLICPRESUPUESTARIA SGAPLICPRESUPUESTARIA, t1.SGAPLICPRESUPINTERES SGAPLICPRESUPINTERES, t1.SGIDCONCEPTOINTERES SGIDCONCEPTOINTERES, t1.SGVIAAPREMIO SGVIAAPREMIO,  t1.SGPRONTOPAGO SGPRONTOPAGO, t2.SBCODIGO METODOPAGOSBCODIGO,t2.SBDESCES METODOPAGOSBDESCES,t2.SBDESCEU METODOPAGOSBDESCEU,t3.SDCODIGO CONCEPTOPAGOSDCODIGO,t3.SDDESCES CONCEPTOPAGOSDDESCES,t3.SDDESDEU CONCEPTOPAGOSDDESDEU,t3.SDTASAPRES CONCEPTOPAGOSDTASAPRES,t3.SDTASATELE CONCEPTOPAGOSDTASATELE,t3.SDDIASLIMITE CONCEPTOPAGOSDDIASLIMITE,t3.SDAPLICPRESUP CONCEPTOPAGOSDAPLICPRESUP,t3.SDAPLICPRESUP01 CONCEPTOPAGOSDAPLICPRESUP01,t3.SDAPLICPRESUP20 CONCEPTOPAGOSDAPLICPRESUP20,t3.SDAPLICPRESUP48 CONCEPTOPAGOSDAPLICPRESUP48,t3.SDAPLICPRESUPFRAC CONCEPTOPAGOSDAPLICPRESUPFRAC, t3.SDELEMENTOPEP CONCEPTOPAGOSDELEMENTOPEP, t3.SDELEMENTOPEP01 CONCEPTOPAGOSDELEMENTOPEP01, t3.SDELEMENTOPEP20 CONCEPTOPAGOSDELEMENTOPEP20, t3.SDELEMENTOPEP48 CONCEPTOPAGOSDELEMENTOPEP48,t3.SDCONCEPTOING CONCEPTOPAGOSDCONCEPTOING,t3.SDCONCEPTOINGFRAC CONCEPTOPAGOSDCONCEPTOINGFRAC,t3.SDENTEMISORA CONCEPTOPAGOSDENTEMISORA,t3.SDENTEMISORASIPCA CONCEPTOPAGOSDENTEMISORASIPCA,t3.SDSUFIJO CONCEPTOPAGOSDSUFIJO,t3.SDEJERCICIO CONCEPTOPAGOSDEJERCICIO,t3.SDFECHABAJA CONCEPTOPAGOSDFECHABAJA,t4.SACODIGO ESTADOPAGOSACODIGO,t4.SADESCES ESTADOPAGOSADESCES,t4.SADESCEU ESTADOPAGOSADESCEU,t3.SDTIPOCONCEPT CONCEPTOPAGOSDTIPOCONCEPT, ");
		query.append("t6.EXCOOR EXCOOR, t6.EXNRAN EXNRAN, t6.EXNROR EXNROR,  LPAD(t6.EXNROR,12,'0')  CORRELATIVOPAD ");
		query.append(
				"FROM PAGOS t1 ,METODOPAGO t2 ,CONCEPTOPAGO t3 ,ESTADOPAGO t4 ,ESTABLECIMIENTO t5, EXPEDIEN t6, SANINTERV t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pagosBusqueda);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) AND t1.SGIDESTABLECIMIENTO = t5.ESCODIGO(+) AND t1.SGIDEXPEDIENTE=t6.EXCODIGO AND t5.ESCODIGO=t7.UAESCODIGO(+) AND t6.EXCODIGO=t7.UAEXCODIGO(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pagos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagos> findAllOtrosPagos(PagosBusqueda pagosBusqueda, Pagination pagination) {

		String idioma = LocaleContextHolder.getLocale().getLanguage();
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.SGEXPEDIENTE SGEXPEDIENTE , t1.SGCODIGO SGCODIGO, t1.SGREFERENCIA SGREFERENCIA, t1.SGIDEXPEDIENTE SGIDEXPEDIENTE, t1.SGCODPROC SGCODPROC, t1.SGIDESTABLECIMIENTO SGIDESTABLECIMIENTO, t1.SGCODSUBVENCION SGCODSUBVENCION, t1.SGFECHAREINTEGRO SGFECHAREINTEGRO, t1.SGCAUSAREINTEGRO SGCAUSAREINTEGRO, ");
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			query.append("t5.NOMBRE_EU ESNOMBRE");
		} else {
			query.append("t5.NOMBRE_ES ESNOMBRE");
		}
		query.append(
				",t5.CIF ESNIF,t5.NOMBRE_ES ESNOCO,t1.SGFECHAEMISION SGFECHAEMISION,t1.SGFECHAESTADO SGFECHAESTADO,t1.SGFECHALIMITEPAGO SGFECHALIMITEPAGO,t1.SGFECHAPAGO SGFECHAPAGO,t1.SGFRACCIONADO SGFRACCIONADO,t1.SGIMPORTE SGIMPORTE,t1.SGDESCRIPCIONPAGO SGDESCRIPCIONPAGO,t1.SGOBSERVACIONES SGOBSERVACIONES,t1.SGDIGITOCONTROL SGDIGITOCONTROL,t1.SGREFERENCIAFRACC SGREFERENCIAFRACC,t1.SGIMPORTEINTERES SGIMPORTEINTERES,t1.SGNUMFRACCION SGNUMFRACCION, t1.SGIBAN SGIBAN, t1.SGNOMBRETITULAR SGNOMBRETITULAR, t1.SGFICHERO SGFICHERO, t1.SGFECALTA SGFECALTA, t1.SGFECMODIF SGFECMODIF, t1.SGNOMBRE SGNOMBRE, t1.SGAPELLIDO1 SGAPELLIDO1,t1.SGAPELLIDO2 SGAPELLIDO2, t1.SGCOMENTARIOES SGCOMENTARIOES, t1.SGCOMENTARIOEU SGCOMENTARIOEU, t1.SGFECHANOT SGFECHANOT, t1.SGAPLICPRESUPUESTARIA SGAPLICPRESUPUESTARIA,t1.SGAPLICPRESUPINTERES SGAPLICPRESUPINTERES, t1.SGIDCONCEPTOINTERES SGIDCONCEPTOINTERES, t1.SGVIAAPREMIO SGVIAAPREMIO,   t1.SGPRONTOPAGO SGPRONTOPAGO, t2.SBCODIGO METODOPAGOSBCODIGO,t2.SBDESCES METODOPAGOSBDESCES,t2.SBDESCEU METODOPAGOSBDESCEU,t3.SDCODIGO CONCEPTOPAGOSDCODIGO,t3.SDDESCES CONCEPTOPAGOSDDESCES,t3.SDDESDEU CONCEPTOPAGOSDDESDEU,t3.SDTASAPRES CONCEPTOPAGOSDTASAPRES,t3.SDTASATELE CONCEPTOPAGOSDTASATELE,t3.SDDIASLIMITE CONCEPTOPAGOSDDIASLIMITE,t3.SDAPLICPRESUP CONCEPTOPAGOSDAPLICPRESUP,t3.SDAPLICPRESUP01 CONCEPTOPAGOSDAPLICPRESUP01,t3.SDAPLICPRESUP20 CONCEPTOPAGOSDAPLICPRESUP20,t3.SDAPLICPRESUP48 CONCEPTOPAGOSDAPLICPRESUP48,t3.SDAPLICPRESUPFRAC CONCEPTOPAGOSDAPLICPRESUPFRAC, t3.SDELEMENTOPEP CONCEPTOPAGOSDELEMENTOPEP, t3.SDELEMENTOPEP01 CONCEPTOPAGOSDELEMENTOPEP01, t3.SDELEMENTOPEP20 CONCEPTOPAGOSDELEMENTOPEP20, t3.SDELEMENTOPEP48 CONCEPTOPAGOSDELEMENTOPEP48,t3.SDCONCEPTOING CONCEPTOPAGOSDCONCEPTOING,t3.SDCONCEPTOINGFRAC CONCEPTOPAGOSDCONCEPTOINGFRAC,t3.SDENTEMISORA CONCEPTOPAGOSDENTEMISORA,t3.SDENTEMISORASIPCA CONCEPTOPAGOSDENTEMISORASIPCA,t3.SDSUFIJO CONCEPTOPAGOSDSUFIJO,t3.SDEJERCICIO CONCEPTOPAGOSDEJERCICIO,t3.SDFECHABAJA CONCEPTOPAGOSDFECHABAJA,t4.SACODIGO ESTADOPAGOSACODIGO,t4.SADESCES ESTADOPAGOSADESCES,t4.SADESCEU ESTADOPAGOSADESCEU,t3.SDTIPOCONCEPT CONCEPTOPAGOSDTIPOCONCEPT ");
		query.append("FROM PAGOS t1 ,METODOPAGO t2 ,CONCEPTOPAGO t3 ,ESTADOPAGO t4 ,ORGANISMO t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapOtros(pagosBusqueda);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) AND t1.SGIDESTABLECIMIENTO = t5.ENTIDAD_ID(+) AND  t3.SDTIPOCONCEPT<>'"
						+ Y41bConstantes.SANCIONES + "' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pagos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Pagos pagos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PAGOS t1 , METODOPAGO t2 , CONCEPTOPAGO t3 , ESTADOPAGO t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pagos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountPagos(PagosBusqueda pagosBusqueda) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PAGOS t1 , METODOPAGO t2 , CONCEPTOPAGO t3 , ESTADOPAGO t4, EXPEDIEN t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pagosBusqueda);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) AND t1.SGIDEXPEDIENTE=t6.EXCODIGO  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountOtrosPagos(PagosBusqueda pagosBusqueda) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PAGOS t1 ,METODOPAGO t2 ,CONCEPTOPAGO t3 ,ESTADOPAGO t4 ,ORGANISMO t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapOtros(pagosBusqueda);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) AND t1.SGIDESTABLECIMIENTO = t5.ENTIDAD_ID(+) AND  t3.SDTIPOCONCEPT<>'"
						+ Y41bConstantes.SANCIONES + "' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagos> findAllLike(Pagos pagos, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.SGCODIGO SGCODIGO, t1.SGREFERENCIA SGREFERENCIA, t1.SGEXPEDIENTE SGEXPEDIENTE, t1.SGIDEXPEDIENTE SGIDEXPEDIENTE, t1.SGCODPROC SGCODPROC, t1.SGIDESTABLECIMIENTO SGIDESTABLECIMIENTO, t1.SGFECHAEMISION SGFECHAEMISION, t1.SGFECHAESTADO SGFECHAESTADO, t1.SGFECHALIMITEPAGO SGFECHALIMITEPAGO, t1.SGFECHAPAGO SGFECHAPAGO, t1.SGFRACCIONADO SGFRACCIONADO, t1.SGIMPORTE SGIMPORTE, t1.SGDESCRIPCIONPAGO SGDESCRIPCIONPAGO, t1.SGOBSERVACIONES SGOBSERVACIONES, t1.SGDIGITOCONTROL SGDIGITOCONTROL, t1.SGREFERENCIAFRACC SGREFERENCIAFRACC, t1.SGIMPORTEINTERES SGIMPORTEINTERES, t1.SGNUMFRACCION SGNUMFRACCION, t1.SGIBAN SGIBAN, t1.SGNOMBRETITULAR SGNOMBRETITULAR, t1.SGFICHERO SGFICHERO, t1.SGFECALTA SGFECALTA, t1.SGFECMODIF SGFECMODIF, t1.SGNOMBRE SGNOMBRE, t1.SGAPELLIDO1 SGAPELLIDO1, t1.SGAPELLIDO2 SGAPELLIDO2, t1.SGCOMENTARIOES SGCOMENTARIOES, t1.SGCOMENTARIOEU SGCOMENTARIOEU, t1.SGFECHANOT SGFECHANOT, t1.SGAPLICPRESUPUESTARIA SGAPLICPRESUPUESTARIA, t1.SGAPLICPRESUPINTERES SGAPLICPRESUPINTERES, t1.SGIDCONCEPTOINTERES SGIDCONCEPTOINTERES, t1.SGVIAAPREMIO SGVIAAPREMIO, t1.SGPRONTOPAGO SGPRONTOPAGO, t1.SGCODSUBVENCION SGCODSUBVENCION, t1.SGFECHAREINTEGRO SGFECHAREINTEGRO, t1.SGCAUSAREINTEGRO SGCAUSAREINTEGRO, t2.SBCODIGO METODOPAGOSBCODIGO, t2.SBDESCES METODOPAGOSBDESCES, t2.SBDESCEU METODOPAGOSBDESCEU, t3.SDCODIGO CONCEPTOPAGOSDCODIGO, t3.SDDESCES CONCEPTOPAGOSDDESCES, t3.SDDESDEU CONCEPTOPAGOSDDESDEU, t3.SDTASAPRES CONCEPTOPAGOSDTASAPRES, t3.SDTASATELE CONCEPTOPAGOSDTASATELE, t3.SDDIASLIMITE CONCEPTOPAGOSDDIASLIMITE, t3.SDAPLICPRESUP CONCEPTOPAGOSDAPLICPRESUP, t3.SDAPLICPRESUP01 CONCEPTOPAGOSDAPLICPRESUP01, t3.SDAPLICPRESUP20 CONCEPTOPAGOSDAPLICPRESUP20, t3.SDAPLICPRESUP48 CONCEPTOPAGOSDAPLICPRESUP48, t3.SDAPLICPRESUPFRAC CONCEPTOPAGOSDAPLICPRESUPFRAC, t3.SDELEMENTOPEP CONCEPTOPAGOSDELEMENTOPEP, t3.SDELEMENTOPEP01 CONCEPTOPAGOSDELEMENTOPEP01, t3.SDELEMENTOPEP20 CONCEPTOPAGOSDELEMENTOPEP20, t3.SDELEMENTOPEP48 CONCEPTOPAGOSDELEMENTOPEP48, t3.SDCONCEPTOING CONCEPTOPAGOSDCONCEPTOING, t3.SDCONCEPTOINGFRAC CONCEPTOPAGOSDCONCEPTOINGFRAC, t3.SDENTEMISORA CONCEPTOPAGOSDENTEMISORA, t3.SDENTEMISORASIPCA CONCEPTOPAGOSDENTEMISORASIPCA, t3.SDSUFIJO CONCEPTOPAGOSDSUFIJO, t3.SDEJERCICIO CONCEPTOPAGOSDEJERCICIO, t3.SDFECHABAJA CONCEPTOPAGOSDFECHABAJA, t4.SACODIGO ESTADOPAGOSACODIGO, t4.SADESCES ESTADOPAGOSADESCES, t4.SADESCEU ESTADOPAGOSADESCEU, t3.SDTIPOCONCEPT CONCEPTOPAGOSDTIPOCONCEPT ");
		query.append("FROM PAGOS t1 ,METODOPAGO t2 ,CONCEPTOPAGO t3 ,ESTADOPAGO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(pagos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pagos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Pagos pagos, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PAGOS t1 ,METODOPAGO t2 ,CONCEPTOPAGO t3 ,ESTADOPAGO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(pagos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SGIDMETODOPAGO= t2.SBCODIGO(+) AND t1.SGIDCONCEPTO= t3.SDCODIGO(+) AND t1.SGIDESTADOPAGO= t4.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pagos entity
	 * 
	 * @param pagos
	 *            Pagos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Pagos pagos) {

		StringBuilder where = new StringBuilder(PagosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pagos != null && pagos.getSgcodigo() != null) {
			where.append(" AND t1.SGCODIGO = ?");
			params.add(pagos.getSgcodigo());
		}
		if (pagos != null && pagos.getMetodopago() != null && pagos.getMetodopago().getSbcodigo() != null) {
			where.append(" AND t2.SBCODIGO = ?");
			params.add(pagos.getMetodopago().getSbcodigo());
		}
		if (pagos != null && pagos.getMetodopago() != null && pagos.getMetodopago().getSbdesces() != null) {
			where.append(" AND t2.SBDESCES = ?");
			params.add(pagos.getMetodopago().getSbdesces());
		}
		if (pagos != null && pagos.getMetodopago() != null && pagos.getMetodopago().getSbdesceu() != null) {
			where.append(" AND t2.SBDESCEU = ?");
			params.add(pagos.getMetodopago().getSbdesceu());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdcodigo() != null) {
			where.append(" AND t3.SDCODIGO = ?");
			params.add(pagos.getConceptopago().getSdcodigo());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getTipoconceptopago() != null
				&& pagos.getConceptopago().getTipoconceptopago().getSccodigo() != null) {
			where.append(" AND t3.SDTIPOCONCEPT = ?");
			params.add(pagos.getConceptopago().getTipoconceptopago().getSccodigo());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSddesces() != null) {
			where.append(" AND t3.SDDESCES = ?");
			params.add(pagos.getConceptopago().getSddesces());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSddesdeu() != null) {
			where.append(" AND t3.SDDESDEU = ?");
			params.add(pagos.getConceptopago().getSddesdeu());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdtasapres() != null) {
			where.append(" AND t3.SDTASAPRES = ?");
			params.add(pagos.getConceptopago().getSdtasapres());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdtasatele() != null) {
			where.append(" AND t3.SDTASATELE = ?");
			params.add(pagos.getConceptopago().getSdtasatele());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSddiaslimite() != null) {
			where.append(" AND t3.SDDIASLIMITE = ?");
			params.add(pagos.getConceptopago().getSddiaslimite());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup() != null) {
			where.append(" AND t3.SDAPLICPRESUP = ?");
			params.add(pagos.getConceptopago().getSdaplicpresup());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup01() != null) {
			where.append(" AND t3.SDAPLICPRESUP01 = ?");
			params.add(pagos.getConceptopago().getSdaplicpresup01());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup20() != null) {
			where.append(" AND t3.SDAPLICPRESUP20 = ?");
			params.add(pagos.getConceptopago().getSdaplicpresup20());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup48() != null) {
			where.append(" AND t3.SDAPLICPRESUP48 = ?");
			params.add(pagos.getConceptopago().getSdaplicpresup48());
		}
		if (pagos != null && pagos.getConceptopago() != null
				&& pagos.getConceptopago().getSdaplicpresupfrac() != null) {
			where.append(" AND t3.SDAPLICPRESUPFRAC = ?");
			params.add(pagos.getConceptopago().getSdaplicpresupfrac());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdconceptoing() != null) {
			where.append(" AND t3.SDCONCEPTOING = ?");
			params.add(pagos.getConceptopago().getSdconceptoing());
		}
		if (pagos != null && pagos.getConceptopago() != null
				&& pagos.getConceptopago().getSdconceptoingfrac() != null) {
			where.append(" AND t3.SDCONCEPTOINGFRAC = ?");
			params.add(pagos.getConceptopago().getSdconceptoingfrac());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdentemisora() != null) {
			where.append(" AND t3.SDENTEMISORA = ?");
			params.add(pagos.getConceptopago().getSdentemisora());
		}
		if (pagos != null && pagos.getConceptopago() != null
				&& pagos.getConceptopago().getSdentemisorasipca() != null) {
			where.append(" AND t3.SDENTEMISORASIPCA = ?");
			params.add(pagos.getConceptopago().getSdentemisorasipca());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdsufijo() != null) {
			where.append(" AND t3.SDSUFIJO = ?");
			params.add(pagos.getConceptopago().getSdsufijo());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdejercicio() != null) {
			where.append(" AND t3.SDEJERCICIO = ?");
			params.add(pagos.getConceptopago().getSdejercicio());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdfechabaja() != null) {
			where.append(" AND t3.SDFECHABAJA = ?");
			params.add(pagos.getConceptopago().getSdfechabaja());
		}
		if (pagos != null && pagos.getEstadopago() != null && pagos.getEstadopago().getSacodigo() != null) {
			where.append(" AND t4.SACODIGO = ?");
			params.add(pagos.getEstadopago().getSacodigo());
		}
		if (pagos != null && pagos.getEstadopago() != null && pagos.getEstadopago().getSadesces() != null) {
			where.append(" AND t4.SADESCES = ?");
			params.add(pagos.getEstadopago().getSadesces());
		}
		if (pagos != null && pagos.getEstadopago() != null && pagos.getEstadopago().getSadesceu() != null) {
			where.append(" AND t4.SADESCEU = ?");
			params.add(pagos.getEstadopago().getSadesceu());
		}
		if (pagos != null && pagos.getSgreferencia() != null) {
			where.append(" AND t1.SGREFERENCIA = ?");
			params.add(pagos.getSgreferencia());
		}
		if (pagos != null && pagos.getSgexpediente() != null) {
			where.append(" AND t1.SGEXPEDIENTE = ?");
			params.add(pagos.getSgexpediente());
		}
		if (pagos != null && pagos.getSgidexpediente() != null) {
			where.append(" AND t1.SGIDEXPEDIENTE = ?");
			params.add(pagos.getSgidexpediente());
		}
		if (pagos != null && pagos.getSgcodproc() != null) {
			where.append(" AND t1.SGCODPROC = ?");
			params.add(pagos.getSgcodproc());
		}
		if (pagos != null && pagos.getSgestablecimiento() != null) {
			where.append(" AND t1.SGIDESTABLECIMIENTO = ?");
			params.add(pagos.getSgestablecimiento());
		}
		if (pagos != null && pagos.getSgfechaemision() != null) {
			where.append(" AND t1.SGFECHAEMISION = ?");
			params.add(pagos.getSgfechaemision());
		}
		if (pagos != null && pagos.getSgfechaestado() != null) {
			where.append(" AND t1.SGFECHAESTADO = ?");
			params.add(pagos.getSgfechaestado());
		}
		if (pagos != null && pagos.getSgfechalimitepago() != null) {
			where.append(" AND t1.SGFECHALIMITEPAGO = ?");
			params.add(pagos.getSgfechalimitepago());
		}
		if (pagos != null && pagos.getSgfechapago() != null) {
			where.append(" AND t1.SGFECHAPAGO = ?");
			params.add(pagos.getSgfechapago());
		}
		if (pagos != null && pagos.getSgfraccionado() != null) {
			where.append(" AND t1.SGFRACCIONADO = ?");
			params.add(pagos.getSgfraccionado());
		}
		if (pagos != null && pagos.getSgimporte() != null) {
			where.append(" AND t1.SGIMPORTE = ?");
			params.add(pagos.getSgimporte());
		}
		if (pagos != null && pagos.getSgdescripcionpago() != null) {
			where.append(" AND t1.SGDESCRIPCIONPAGO = ?");
			params.add(pagos.getSgdescripcionpago());
		}
		if (pagos != null && pagos.getSgobservaciones() != null) {
			where.append(" AND t1.SGOBSERVACIONES = ?");
			params.add(pagos.getSgobservaciones());
		}
		if (pagos != null && pagos.getSgdigitocontrol() != null) {
			where.append(" AND t1.SGDIGITOCONTROL = ?");
			params.add(pagos.getSgdigitocontrol());
		}
		if (pagos != null && pagos.getSgreferenciafracc() != null) {
			where.append(" AND t1.SGREFERENCIAFRACC = ?");
			params.add(pagos.getSgreferenciafracc());
		}
		if (pagos != null && pagos.getSgimporteinteres() != null) {
			where.append(" AND t1.SGIMPORTEINTERES = ?");
			params.add(pagos.getSgimporteinteres());
		}
		if (pagos != null && pagos.getSgnumfraccion() != null) {
			where.append(" AND t1.SGNUMFRACCION = ?");
			params.add(pagos.getSgnumfraccion());
		}
		if (pagos != null && pagos.getSgviaapremio() != null) {
			where.append(" AND t1.SGVIAAPREMIO = ?");
			params.add(pagos.getSgviaapremio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pagos entity
	 * 
	 * @param pagosBusqueda
	 *            Pagos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapOtros(PagosBusqueda pagosBusqueda) {

		StringBuilder where = new StringBuilder(PagosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdejercicio() != null) {
			where.append(" AND t3.SDEJERCICIO = ?");
			params.add(pagosBusqueda.getConceptopago().getSdejercicio());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgreferencia() != null) {
			where.append(" AND t1.SGREFERENCIA like ? ESCAPE  '\\'");
			params.add("%" + pagosBusqueda.getSgreferencia() + "%");
			where.append(" AND t1.SGREFERENCIA IS NOT NULL");
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgexpediente() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SGEXPEDIENTE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + pagosBusqueda.getSgexpediente().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.SGEXPEDIENTE IS NOT NULL");
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgestablecimiento() != null
				&& pagosBusqueda.getSgestablecimiento().getEscodigo() != null) {
			where.append(" AND t1.SGIDESTABLECIMIENTO = ?");
			params.add(pagosBusqueda.getSgestablecimiento().getEscodigo());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pagos entity
	 * 
	 * @param pagosBusqueda
	 *            Pagos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(PagosBusqueda pagosBusqueda) {

		StringBuilder where = new StringBuilder(PagosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pagosBusqueda != null && pagosBusqueda.getSgcodigo() != null) {
			where.append(" AND t1.SGCODIGO = ?");
			params.add(pagosBusqueda.getSgcodigo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getMetodopago() != null
				&& pagosBusqueda.getMetodopago().getSbcodigo() != null) {
			where.append(" AND t2.SBCODIGO = ?");
			params.add(pagosBusqueda.getMetodopago().getSbcodigo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getMetodopago() != null
				&& pagosBusqueda.getMetodopago().getSbdesces() != null) {
			where.append(" AND t2.SBDESCES = ?");
			params.add(pagosBusqueda.getMetodopago().getSbdesces());
		}
		if (pagosBusqueda != null && pagosBusqueda.getMetodopago() != null
				&& pagosBusqueda.getMetodopago().getSbdesceu() != null) {
			where.append(" AND t2.SBDESCEU = ?");
			params.add(pagosBusqueda.getMetodopago().getSbdesceu());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdcodigo() != null) {
			where.append(" AND t3.SDCODIGO = ?");
			params.add(pagosBusqueda.getConceptopago().getSdcodigo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getTipoconceptopago() != null
				&& pagosBusqueda.getConceptopago().getTipoconceptopago().getSccodigo() != null) {
			where.append(" AND t3.SDTIPOCONCEPT = ?");
			params.add(pagosBusqueda.getConceptopago().getTipoconceptopago().getSccodigo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSddesces() != null) {
			where.append(" AND t3.SDDESCES = ?");
			params.add(pagosBusqueda.getConceptopago().getSddesces());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSddesdeu() != null) {
			where.append(" AND t3.SDDESDEU = ?");
			params.add(pagosBusqueda.getConceptopago().getSddesdeu());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdtasapres() != null) {
			where.append(" AND t3.SDTASAPRES = ?");
			params.add(pagosBusqueda.getConceptopago().getSdtasapres());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdtasatele() != null) {
			where.append(" AND t3.SDTASATELE = ?");
			params.add(pagosBusqueda.getConceptopago().getSdtasatele());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSddiaslimite() != null) {
			where.append(" AND t3.SDDIASLIMITE = ?");
			params.add(pagosBusqueda.getConceptopago().getSddiaslimite());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdaplicpresup() != null) {
			where.append(" AND t3.SDAPLICPRESUP = ?");
			params.add(pagosBusqueda.getConceptopago().getSdaplicpresup());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdaplicpresup01() != null) {
			where.append(" AND t3.SDAPLICPRESUP01 = ?");
			params.add(pagosBusqueda.getConceptopago().getSdaplicpresup01());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdaplicpresup20() != null) {
			where.append(" AND t3.SDAPLICPRESUP20 = ?");
			params.add(pagosBusqueda.getConceptopago().getSdaplicpresup20());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdaplicpresup48() != null) {
			where.append(" AND t3.SDAPLICPRESUP48 = ?");
			params.add(pagosBusqueda.getConceptopago().getSdaplicpresup48());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdaplicpresupfrac() != null) {
			where.append(" AND t3.SDAPLICPRESUPFRAC = ?");
			params.add(pagosBusqueda.getConceptopago().getSdaplicpresupfrac());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdconceptoing() != null) {
			where.append(" AND t3.SDCONCEPTOING = ?");
			params.add(pagosBusqueda.getConceptopago().getSdconceptoing());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdconceptoingfrac() != null) {
			where.append(" AND t3.SDCONCEPTOINGFRAC = ?");
			params.add(pagosBusqueda.getConceptopago().getSdconceptoingfrac());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdentemisora() != null) {
			where.append(" AND t3.SDENTEMISORA = ?");
			params.add(pagosBusqueda.getConceptopago().getSdentemisora());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdentemisorasipca() != null) {
			where.append(" AND t3.SDENTEMISORASIPCA = ?");
			params.add(pagosBusqueda.getConceptopago().getSdentemisorasipca());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdsufijo() != null) {
			where.append(" AND t3.SDSUFIJO = ?");
			params.add(pagosBusqueda.getConceptopago().getSdsufijo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdejercicio() != null) {
			where.append(" AND t3.SDEJERCICIO = ?");
			params.add(pagosBusqueda.getConceptopago().getSdejercicio());
		}
		if (pagosBusqueda != null && pagosBusqueda.getConceptopago() != null
				&& pagosBusqueda.getConceptopago().getSdfechabaja() != null) {
			where.append(" AND t3.SDFECHABAJA = ?");
			params.add(pagosBusqueda.getConceptopago().getSdfechabaja());
		}
		if (pagosBusqueda != null && pagosBusqueda.getEstadopago() != null
				&& pagosBusqueda.getEstadopago().getSacodigo() != null) {
			where.append(" AND t4.SACODIGO = ?");
			params.add(pagosBusqueda.getEstadopago().getSacodigo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getEstadopago() != null
				&& pagosBusqueda.getEstadopago().getSadesces() != null) {
			where.append(" AND t4.SADESCES = ?");
			params.add(pagosBusqueda.getEstadopago().getSadesces());
		}
		if (pagosBusqueda != null && pagosBusqueda.getEstadopago() != null
				&& pagosBusqueda.getEstadopago().getSadesceu() != null) {
			where.append(" AND t4.SADESCEU = ?");
			params.add(pagosBusqueda.getEstadopago().getSadesceu());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgreferencia() != null) {
			// where.append(" AND t1.SGREFERENCIA LIKE '%?%'");
			// params.add(pagosBusqueda.getSgreferencia());

			where.append(" AND t1.SGREFERENCIA like ? ESCAPE  '\\'");
			params.add("%" + pagosBusqueda.getSgreferencia() + "%");
			where.append(" AND t1.SGREFERENCIA IS NOT NULL");
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgexpediente() != null) {
			where.append(" AND t1.SGEXPEDIENTE = ?");
			params.add(pagosBusqueda.getSgexpediente());
		}
		if (pagosBusqueda != null && pagosBusqueda.getExcoor() != null && !pagosBusqueda.getExcoor().equals("")) {
			where.append(" AND UPPER(t6.EXCOOR) like ? ESCAPE  '\\'");
			params.add("%" + pagosBusqueda.getExcoor().toUpperCase() + "%");
			where.append(" AND t6.EXCOOR IS NOT NULL");
		}
		if (pagosBusqueda != null && pagosBusqueda.getExnran() != null) {
			where.append(" AND t6.EXNRAN = ?");
			params.add(pagosBusqueda.getExnran().intValue());
		}
		if (pagosBusqueda != null && pagosBusqueda.getExnror() != null) {
			where.append(" AND t6.EXNROR = ?");
			params.add(pagosBusqueda.getExnror());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgidexpediente() != null) {
			where.append(" AND t1.SGIDEXPEDIENTE = ?");
			params.add(pagosBusqueda.getSgidexpediente());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgcodproc() != null) {
			where.append(" AND t1.SGCODPROC = ?");
			params.add(pagosBusqueda.getSgcodproc());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgestablecimiento() != null
				&& pagosBusqueda.getSgestablecimiento().getEscodigo() != null) {
			where.append(" AND t1.SGIDESTABLECIMIENTO = ?");
			params.add(pagosBusqueda.getSgestablecimiento().getEscodigo());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechaemision() != null) {
			where.append(" AND t1.SGFECHAEMISION = ?");
			params.add(pagosBusqueda.getSgfechaemision());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechaemisiondesde() != null) {
			where.append(" AND t1.SGFECHAEMISION >= ?");
			params.add(pagosBusqueda.getSgfechaemisiondesde());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechaemisionhasta() != null) {
			where.append(" AND t1.SGFECHAEMISION <= ?");
			params.add(pagosBusqueda.getSgfechaemisionhasta());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechaestado() != null) {
			where.append(" AND t1.SGFECHAESTADO = ?");
			params.add(pagosBusqueda.getSgfechaestado());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechalimitepago() != null) {
			where.append(" AND t1.SGFECHALIMITEPAGO = ?");
			params.add(pagosBusqueda.getSgfechalimitepago());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechalimitepagodesde() != null) {
			where.append(" AND t1.SGFECHALIMITEPAGO >= ?");
			params.add(pagosBusqueda.getSgfechalimitepagodesde());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechalimitepagohasta() != null) {
			where.append(" AND t1.SGFECHALIMITEPAGO <= ?");
			params.add(pagosBusqueda.getSgfechalimitepagohasta());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfechapago() != null) {
			where.append(" AND t1.SGFECHAPAGO = ?");
			params.add(pagosBusqueda.getSgfechapago());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgfraccionado() != null) {
			where.append(" AND t1.SGFRACCIONADO = ?");
			params.add(pagosBusqueda.getSgfraccionado());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgimporte() != null) {
			where.append(" AND t1.SGIMPORTE = ?");
			params.add(pagosBusqueda.getSgimporte());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgdescripcionpago() != null) {
			where.append(" AND t1.SGDESCRIPCIONPAGO = ?");
			params.add(pagosBusqueda.getSgdescripcionpago());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgobservaciones() != null) {
			where.append(" AND t1.SGOBSERVACIONES = ?");
			params.add(pagosBusqueda.getSgobservaciones());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgdigitocontrol() != null) {
			where.append(" AND t1.SGDIGITOCONTROL = ?");
			params.add(pagosBusqueda.getSgdigitocontrol());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgreferenciafracc() != null) {
			where.append(" AND t1.SGREFERENCIAFRACC = ?");
			params.add(pagosBusqueda.getSgreferenciafracc());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgimporteinteres() != null) {
			where.append(" AND t1.SGIMPORTEINTERES = ?");
			params.add(pagosBusqueda.getSgimporteinteres());
		}
		if (pagosBusqueda != null && pagosBusqueda.getSgnumfraccion() != null) {
			where.append(" AND t1.SGNUMFRACCION = ?");
			params.add(pagosBusqueda.getSgnumfraccion());
		}
		if (pagosBusqueda != null && !Y41bUtils.esNullOCadenaVacia(pagosBusqueda.getSgviaapremio())) {
			where.append(" AND t1.SGVIAAPREMIO = ?");
			params.add(pagosBusqueda.getSgviaapremio());
		}
		if (pagosBusqueda != null && !Y41bUtils.esNullOCadenaVacia(pagosBusqueda.getSgprontopago())) {
			where.append(" AND t1.SGPRONTOPAGO = ?");
			params.add(pagosBusqueda.getSgprontopago());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pagos entity
	 * 
	 * @param pagos
	 *            Pagos Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Pagos pagos, Boolean startsWith) {

		StringBuilder where = new StringBuilder(PagosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pagos != null && pagos.getSgcodigo() != null) {
			where.append(" AND UPPER(t1.SGCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SGCODIGO IS NOT NULL");
		}
		if (pagos != null && pagos.getMetodopago() != null && pagos.getMetodopago().getSbcodigo() != null) {
			where.append(" AND t2.SBCODIGO = ?");
			params.add(pagos.getMetodopago().getSbcodigo());
		}
		if (pagos != null && pagos.getMetodopago() != null && pagos.getMetodopago().getSbdesces() != null) {
			where.append(" AND UPPER(t2.SBDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getMetodopago().getSbdesces().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getMetodopago().getSbdesces().toUpperCase() + "%");
			}
			where.append(" AND t2.SBDESCES IS NOT NULL");
		}
		if (pagos != null && pagos.getMetodopago() != null && pagos.getMetodopago().getSbdesceu() != null) {
			where.append(" AND UPPER(t2.SBDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getMetodopago().getSbdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getMetodopago().getSbdesceu().toUpperCase() + "%");
			}
			where.append(" AND t2.SBDESCEU IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdcodigo() != null) {
			where.append(" AND t3.SDCODIGO = ?");
			params.add(pagos.getConceptopago().getSdcodigo());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getTipoconceptopago() != null
				&& pagos.getConceptopago().getTipoconceptopago().getSccodigo() != null) {
			where.append(" AND UPPER(t3.SDTIPOCONCEPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getTipoconceptopago().getSccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getTipoconceptopago().getSccodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.SDTIPOCONCEPT IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSddesces() != null) {
			where.append(" AND UPPER(t3.SDDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSddesces().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSddesces().toUpperCase() + "%");
			}
			where.append(" AND t3.SDDESCES IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSddesdeu() != null) {
			where.append(" AND UPPER(t3.SDDESDEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSddesdeu().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSddesdeu().toUpperCase() + "%");
			}
			where.append(" AND t3.SDDESDEU IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdtasapres() != null) {
			where.append(" AND t3.SDTASAPRES = ?");
			params.add(pagos.getConceptopago().getSdtasapres());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdtasatele() != null) {
			where.append(" AND t3.SDTASATELE = ?");
			params.add(pagos.getConceptopago().getSdtasatele());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSddiaslimite() != null) {
			where.append(" AND t3.SDDIASLIMITE = ?");
			params.add(pagos.getConceptopago().getSddiaslimite());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup() != null) {
			where.append(" AND UPPER(t3.SDAPLICPRESUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdaplicpresup().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdaplicpresup().toUpperCase() + "%");
			}
			where.append(" AND t3.SDAPLICPRESUP IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup01() != null) {
			where.append(" AND UPPER(t3.SDAPLICPRESUP01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdaplicpresup01().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdaplicpresup01().toUpperCase() + "%");
			}
			where.append(" AND t3.SDAPLICPRESUP01 IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup20() != null) {
			where.append(" AND UPPER(t3.SDAPLICPRESUP20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdaplicpresup20().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdaplicpresup20().toUpperCase() + "%");
			}
			where.append(" AND t3.SDAPLICPRESUP20 IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdaplicpresup48() != null) {
			where.append(" AND UPPER(t3.SDAPLICPRESUP48) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdaplicpresup48().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdaplicpresup48().toUpperCase() + "%");
			}
			where.append(" AND t3.SDAPLICPRESUP48 IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null
				&& pagos.getConceptopago().getSdaplicpresupfrac() != null) {
			where.append(" AND UPPER(t3.SDAPLICPRESUPFRAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdaplicpresupfrac().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdaplicpresupfrac().toUpperCase() + "%");
			}
			where.append(" AND t3.SDAPLICPRESUPFRAC IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdconceptoing() != null) {
			where.append(" AND t3.SDCONCEPTOING = ?");
			params.add(pagos.getConceptopago().getSdconceptoing());
		}
		if (pagos != null && pagos.getConceptopago() != null
				&& pagos.getConceptopago().getSdconceptoingfrac() != null) {
			where.append(" AND t3.SDCONCEPTOINGFRAC = ?");
			params.add(pagos.getConceptopago().getSdconceptoingfrac());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdentemisora() != null) {
			where.append(" AND UPPER(t3.SDENTEMISORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdentemisora().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdentemisora().toUpperCase() + "%");
			}
			where.append(" AND t3.SDENTEMISORA IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null
				&& pagos.getConceptopago().getSdentemisorasipca() != null) {
			where.append(" AND UPPER(t3.SDENTEMISORASIPCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getConceptopago().getSdentemisorasipca().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getConceptopago().getSdentemisorasipca().toUpperCase() + "%");
			}
			where.append(" AND t3.SDENTEMISORASIPCA IS NOT NULL");
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdsufijo() != null) {
			where.append(" AND t3.SDSUFIJO = ?");
			params.add(pagos.getConceptopago().getSdsufijo());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdejercicio() != null) {
			where.append(" AND t3.SDEJERCICIO = ?");
			params.add(pagos.getConceptopago().getSdejercicio());
		}
		if (pagos != null && pagos.getConceptopago() != null && pagos.getConceptopago().getSdfechabaja() != null) {
			where.append(" AND t3.SDFECHABAJA = ?");
			params.add(pagos.getConceptopago().getSdfechabaja());
		}
		if (pagos != null && pagos.getEstadopago() != null && pagos.getEstadopago().getSacodigo() != null) {
			where.append(" AND t4.SACODIGO = ?");
			params.add(pagos.getEstadopago().getSacodigo());
		}
		if (pagos != null && pagos.getEstadopago() != null && pagos.getEstadopago().getSadesces() != null) {
			where.append(" AND UPPER(t4.SADESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getEstadopago().getSadesces().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getEstadopago().getSadesces().toUpperCase() + "%");
			}
			where.append(" AND t4.SADESCES IS NOT NULL");
		}
		if (pagos != null && pagos.getEstadopago() != null && pagos.getEstadopago().getSadesceu() != null) {
			where.append(" AND UPPER(t4.SADESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getEstadopago().getSadesceu().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getEstadopago().getSadesceu().toUpperCase() + "%");
			}
			where.append(" AND t4.SADESCEU IS NOT NULL");
		}
		if (pagos != null && pagos.getSgreferencia() != null) {
			where.append(" AND UPPER(t1.SGREFERENCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgreferencia().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgreferencia().toUpperCase() + "%");
			}
			where.append(" AND t1.SGREFERENCIA IS NOT NULL");
		}
		if (pagos != null && pagos.getSgexpediente() != null) {
			where.append(" AND UPPER(t1.SGEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgexpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.SGEXPEDIENTE IS NOT NULL");
		}
		if (pagos != null && pagos.getSgidexpediente() != null) {
			where.append(" AND UPPER(t1.SGIDEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgidexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgidexpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.SGIDEXPEDIENTE IS NOT NULL");
		}
		if (pagos != null && pagos.getSgcodproc() != null) {
			where.append(" AND UPPER(t1.SGCODPROC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgcodproc().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgcodproc().toUpperCase() + "%");
			}
			where.append(" AND t1.SGCODPROC IS NOT NULL");
		}
		if (pagos != null && pagos.getSgestablecimiento() != null) {
			where.append(" AND UPPER(t1.SGIDESTABLECIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgestablecimiento().getEscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgestablecimiento().getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SGIDESTABLECIMIENTO IS NOT NULL");
		}
		if (pagos != null && pagos.getSgfechaemision() != null) {
			where.append(" AND t1.SGFECHAEMISION = ?");
			params.add(pagos.getSgfechaemision());
		}
		if (pagos != null && pagos.getSgfechaestado() != null) {
			where.append(" AND t1.SGFECHAESTADO = ?");
			params.add(pagos.getSgfechaestado());
		}
		if (pagos != null && pagos.getSgfechalimitepago() != null) {
			where.append(" AND t1.SGFECHALIMITEPAGO = ?");
			params.add(pagos.getSgfechalimitepago());
		}
		if (pagos != null && pagos.getSgfechapago() != null) {
			where.append(" AND t1.SGFECHAPAGO = ?");
			params.add(pagos.getSgfechapago());
		}
		if (pagos != null && pagos.getSgfraccionado() != null) {
			where.append(" AND UPPER(t1.SGFRACCIONADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgfraccionado().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgfraccionado().toUpperCase() + "%");
			}
			where.append(" AND t1.SGFRACCIONADO IS NOT NULL");
		}
		if (pagos != null && pagos.getSgimporte() != null) {
			where.append(" AND t1.SGIMPORTE = ?");
			params.add(pagos.getSgimporte());
		}
		if (pagos != null && pagos.getSgdescripcionpago() != null) {
			where.append(" AND UPPER(t1.SGDESCRIPCIONPAGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgdescripcionpago().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgdescripcionpago().toUpperCase() + "%");
			}
			where.append(" AND t1.SGDESCRIPCIONPAGO IS NOT NULL");
		}
		if (pagos != null && pagos.getSgobservaciones() != null) {
			where.append(" AND UPPER(t1.SGOBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgobservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgobservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.SGOBSERVACIONES IS NOT NULL");
		}
		if (pagos != null && pagos.getSgdigitocontrol() != null) {
			where.append(" AND UPPER(t1.SGDIGITOCONTROL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgdigitocontrol().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgdigitocontrol().toUpperCase() + "%");
			}
			where.append(" AND t1.SGDIGITOCONTROL IS NOT NULL");
		}
		if (pagos != null && pagos.getSgreferenciafracc() != null) {
			where.append(" AND UPPER(t1.SGREFERENCIAFRACC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagos.getSgreferenciafracc().toUpperCase() + "%");
			} else {
				params.add("%" + pagos.getSgreferenciafracc().toUpperCase() + "%");
			}
			where.append(" AND t1.SGREFERENCIAFRACC IS NOT NULL");
		}
		if (pagos != null && pagos.getSgimporteinteres() != null) {
			where.append(" AND t1.SGIMPORTEINTERES = ?");
			params.add(pagos.getSgimporteinteres());
		}
		if (pagos != null && pagos.getSgnumfraccion() != null) {
			where.append(" AND t1.SGNUMFRACCION = ?");
			params.add(pagos.getSgnumfraccion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * getNewReferencia
	 * 
	 * @return Long
	 */
	public Long getNewReferencia() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT REFERENCIA.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Emitir fraccion.
	 * 
	 * @param pago
	 *            the pago
	 */
	public void emitirFraccion(Pagos pago) {
		/*
		 * meter el movimiento 01 en estado pendiente en la tabla de movimientos
		 * para que el envio sipca construya esta operacion luego para que el
		 * batch de envio sipca lo meta en su fichero a la hora de leer
		 */

		Movimientos movimiento = new Movimientos("", pago.getSgreferencia(),
				Y41bConstantes.OPERACION_SIPCA_FRACCIONAMIENTO, Y41bConstantes.PERIODO_VOLUNTARIO,
				Y41bConstantes.SENTIDO_OPERACION_SALIDA, pago.getSgfechaemision(),
				Y41bConstantes.ESTADO_MOVIMIENTO_PDTE_ENVIO, "");

		String query = "INSERT INTO MOVIMIENTOS (SFCODIGO, SFREFERENCIA, SFTIPOMOV, SFPERIODO, SFSENTIDO, SFFECHAOPERACION, SFESTADOMOV, SFDETALLE) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, movimiento.getSfcodigo(), movimiento.getSfreferencia(),
				movimiento.getSftipomov(), movimiento.getSfperiodo(), movimiento.getSfsentido(),
				movimiento.getSffechaoperacion(), movimiento.getSfestadomov(), movimiento.getSfdetalle());

	}

	/**
	 * Permite obtener el numero de envio para un fichero.
	 * 
	 * @return long numero de envio
	 */
	public long obtenerNumEnvio() {

		List<Object> params = new ArrayList<Object>();
		StringBuffer query = new StringBuffer("SELECT FICHERO.nextval AS NUMERO_ENVIO FROM DUAL");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagination
	 * @return Pagos
	 */
	public void updateNombreFichero(String nombreOriginal, String nombreNuevo) {
		String query = "UPDATE PAGOS SET SGFICHERO=? WHERE SGFICHERO=? AND (SGIDESTADOPAGO=? OR SGIDESTADOPAGO=?)";

		this.jdbcTemplate.update(query, nombreOriginal, nombreNuevo, Y41bConstantes.ESTADO_PAGO_ERRORFICHERO,
				Y41bConstantes.ESTADO_PAGO_ERROR);

	}

	/**
	 * Tiene Liquidacion Firme No Anulada.
	 * 
	 * @param idExpediente
	 *            String
	 * @return boolean
	 */
	public boolean tieneLiquidacionFirmeNoAnulada(String idExpediente) {
		String query = "SELECT COUNT(*) FROM (SELECT SGREFERENCIA FROM PAGOS WHERE SGIDEXPEDIENTE=? AND SGIDCONCEPTO IN (SELECT SDCODIGO FROM CONCEPTOPAGO WHERE SDCONCEPTOING='"
				+ Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION + "') AND SGIDESTADOPAGO NOT IN ('"
				+ Y41bConstantes.ESTADO_PAGO_ANULADO + "','" + Y41bConstantes.ESTADO_PAGO_ANULADO_FRACCIONAMIENTO
				+ "','" + Y41bConstantes.ESTADO_PAGO_SOBRESEIMIENTO + "') " + "AND SGREFERENCIAFRACC IS NULL "
				+ "ORDER BY SGFECHAEMISION DESC)";

		return (this.jdbcTemplate.queryForInt(query, idExpediente) > 0);
	}

	/**
	 * Referencia Liquidacion Firme No Anulada.
	 * 
	 * @param idExpediente
	 *            String
	 * @return String
	 */
	public String referenciaLiquidacionFirmeNoAnulada(String idExpediente) {
		String query = "SELECT SGREFERENCIA FROM (SELECT SGREFERENCIA || SGDIGITOCONTROL AS SGREFERENCIA FROM PAGOS WHERE SGIDEXPEDIENTE=? AND SGIDCONCEPTO IN (SELECT SDCODIGO FROM CONCEPTOPAGO WHERE SDCONCEPTOING='"
				+ Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION + "') AND SGIDESTADOPAGO NOT IN ('"
				+ Y41bConstantes.ESTADO_PAGO_ANULADO + "','" + Y41bConstantes.ESTADO_PAGO_ANULADO_FRACCIONAMIENTO
				+ "','" + Y41bConstantes.ESTADO_PAGO_SOBRESEIMIENTO + "') " + "AND SGREFERENCIAFRACC IS NULL "
				+ "ORDER BY SGFECHAEMISION DESC) WHERE ROWNUM=1";

		return this.jdbcTemplate.queryForObject(query, new Object[] { idExpediente }, String.class);
	}

}
