package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;

/**
 * PagosDao  
 * 
 *  
 */

public interface PagosDao {

	/**
	 * Inserts a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos add(Pagos pagos);

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos update(Pagos pagos);

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar);

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos find(Pagos pagos);

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos findHR(Pagos pagos);

	/**
	 * Deletes a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return
	 */
	void remove(Pagos pagos);

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pagos> findAll(Pagos pagos, Pagination pagination);

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pagos> findAllPagos(PagosBusqueda pagos, Pagination pagination);

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Long
	 */
	Long findAllCount(Pagos pagos);

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	public Long findAllCountPagos(PagosBusqueda pagosBusqueda);

	/**
	 * Finds rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Pagos> findAllLike(Pagos pagos, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Pagos pagos, Boolean startsWith);

	/**
	 * getNewReferencia
	 * 
	 * @return Long
	 */
	public Long getNewReferencia();

	/**
	 * Permite obtener el numero de envio para un fichero.
	 * 
	 * @return long numero de envio
	 */
	public long obtenerNumEnvio();

	/**
	 * Actualiza el nombre del fichero en el que se han enviado los pagos
	 * 
	 * @param nombreOriginal
	 *            String
	 * @param nombreNuevo
	 *            String
	 */
	void updateNombreFichero(String nombreOriginal, String nombreNuevo);

	/**
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	Long findAllCountOtrosPagos(PagosBusqueda pagosBusqueda);

	/**
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List<Pagos>
	 */
	List<Pagos> findAllOtrosPagos(PagosBusqueda pagosBusqueda,
			Pagination pagination);

	/**
	 * Tiene Liquidacion Firme No Anulada.
	 * 
	 * @param idExpediente
	 *            String
	 * @return boolean
	 */
	public boolean tieneLiquidacionFirmeNoAnulada(String idExpediente);

	/**
	 * Referencia Liquidacion Firme No Anulada.
	 * 
	 * @param idExpediente
	 *            String
	 * @return String
	 */
	public String referenciaLiquidacionFirmeNoAnulada(String idExpediente);
}
