package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Pagosarbitros;

/**
 * PagosArbitros2DaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class PagosArbitrosDaoImpl implements PagosArbitrosDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Pagosarbitros> rwMap = new RowMapper<Pagosarbitros>() {
		public Pagosarbitros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Pagosarbitros pagosArbitros = new Pagosarbitros(resultSet.getString("PASACODIGO"),
					resultSet.getString("PAARCODIGO"), resultSet.getString("PATRID"), resultSet.getString("PANUMEXP"),
					resultSet.getDate("PAFECCONT"), resultSet.getDate("PAFECULTCON"), resultSet.getString("PADOCFI"),
					resultSet.getDate("PAFECALTA"), resultSet.getDate("PAFECMODIF"), resultSet.getString("PAUSUALTA"),
					resultSet.getString("PAUSUMODIF"));
			return pagosArbitros;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagination
	 * @return Pagosarbitros
	 */
	public Pagosarbitros add(Pagosarbitros pagosArbitros) {
		String query = "INSERT INTO PAGOSARBITROS (PASACODIGO, PAARCODIGO, PATRID, PANUMEXP, PAFECCONT, PAFECULTCON, PADOCFI, PAFECALTA, PAFECMODIF, PAUSUALTA, PAUSUMODIF) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		this.jdbcTemplate.update(query, pagosArbitros.getPasacodigo(), pagosArbitros.getPaarcodigo(),
				pagosArbitros.getPatrid(), pagosArbitros.getPanumexp(), pagosArbitros.getPafeccont(),
				pagosArbitros.getPafecultcon(), pagosArbitros.getPadocfi(), pagosArbitros.getPafecalta(),
				pagosArbitros.getPafecmodif(), pagosArbitros.getPausualta(), pagosArbitros.getPausumodif());
		return pagosArbitros;
	}

	/**
	 * Updates a single row in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagination
	 * @return Pagosarbitros
	 */
	public Pagosarbitros update(Pagosarbitros pagosArbitros) {
		String query = "UPDATE PAGOSARBITROS SET PASACODIGO = ?, PAARCODIGO = ?, PATRID = ?, PANUMEXP = ?, PAFECCONT = ?, PAFECULTCON = ?, PADOCFI=?, PAFECALTA = ?, PAFECMODIF = ?, PAUSUALTA = ?, PAUSUMODIF = ? WHERE PASACODIGO = ? and PAARCODIGO = ? and PATRID = ?";
		this.jdbcTemplate.update(query, pagosArbitros.getPasacodigo(), pagosArbitros.getPaarcodigo(),
				pagosArbitros.getPatrid(), pagosArbitros.getPanumexp(), pagosArbitros.getPafeccont(),
				pagosArbitros.getPafecultcon(), pagosArbitros.getPadocfi(), pagosArbitros.getPafecalta(),
				pagosArbitros.getPafecmodif(), pagosArbitros.getPausualta(), pagosArbitros.getPausumodif(),
				pagosArbitros.getPasacodigo(), pagosArbitros.getPaarcodigo(), pagosArbitros.getPatrid());
		return pagosArbitros;
	}

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagosArbitros
	 *            Pagination
	 * @return Pagosarbitros
	 */
	@Transactional(readOnly = true)
	public Pagosarbitros find(Pagosarbitros pagosArbitros) {
		String query = "SELECT PASACODIGO, PAARCODIGO, PATRID, PANUMEXP, PAFECCONT, PAFECULTCON, PADOCFI, PAFECALTA, PAFECMODIF, PAUSUALTA, PAUSUMODIF FROM PAGOSARBITROS"
				+ " WHERE PASACODIGO=? AND PAARCODIGO=? AND PATRID=?";
		List<Pagosarbitros> pagosArbitrosList = this.jdbcTemplate.query(query, this.rwMap,
				pagosArbitros.getPasacodigo(), pagosArbitros.getPaarcodigo(), pagosArbitros.getPatrid());
		return (Pagosarbitros) DataAccessUtils.uniqueResult(pagosArbitrosList);
	}

	/**
	 * Removes a single row in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return
	 */
	public void remove(Pagosarbitros pagosArbitros) {
		String query = "DELETE FROM PAGOSARBITROS WHERE PASACODIGO=? AND PAARCODIGO=? AND PATRID=?";
		this.jdbcTemplate.update(query, pagosArbitros.getPasacodigo(), pagosArbitros.getPaarcodigo(),
				pagosArbitros.getPatrid());
	}

	/**
	 * Finds a List of rows in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagosarbitros> findAll(Pagosarbitros pagosArbitros, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT PASACODIGO, PAARCODIGO, PATRID, PANUMEXP, PAFECCONT, PAFECULTCON, PADOCFI, PAFECALTA, PAFECMODIF, PAUSUALTA, PAUSUMODIF ");
		query.append("FROM PAGOSARBITROS ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pagosArbitros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pagosarbitros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Pagosarbitros pagosArbitros) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PAGOSARBITROS ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(pagosArbitros);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the PagosArbitros table using like.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagosarbitros> findAllLike(Pagosarbitros pagosArbitros, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT PASACODIGO, PAARCODIGO, PATRID, PANUMEXP, PAFECCONT, PAFECULTCON, PADOCFI, PAFECALTA, PAFECMODIF, PAUSUALTA, PAUSUMODIF ");
		query.append("FROM PAGOSARBITROS ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(pagosArbitros, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Pagosarbitros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Pagosarbitros table using like.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Pagosarbitros pagosArbitros, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PAGOSARBITROS ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(pagosArbitros, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pagos entity
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Pagosarbitros pagosArbitros) {

		StringBuilder where = new StringBuilder(PagosArbitrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pagosArbitros != null && pagosArbitros.getPasacodigo() != null) {
			where.append(" AND PASACODIGO = ?");
			params.add(pagosArbitros.getPasacodigo());
		}
		if (pagosArbitros != null && pagosArbitros.getPaarcodigo() != null) {
			where.append(" AND PAARCODIGO = ?");
			params.add(pagosArbitros.getPaarcodigo());
		}
		if (pagosArbitros != null && pagosArbitros.getPatrid() != null) {
			where.append(" AND PATRID = ?");
			params.add(pagosArbitros.getPatrid());
		}
		if (pagosArbitros != null && pagosArbitros.getPanumexp() != null) {
			where.append(" AND PANUMEXP = ?");
			params.add(pagosArbitros.getPanumexp());
		}
		if (pagosArbitros != null && pagosArbitros.getPafeccont() != null) {
			where.append(" AND PAFECCONT = ?");
			params.add(pagosArbitros.getPafeccont());
		}
		if (pagosArbitros != null && pagosArbitros.getPafecultcon() != null) {
			where.append(" AND PAFECULTCON = ?");
			params.add(pagosArbitros.getPafecultcon());
		}
		if (pagosArbitros != null && pagosArbitros.getPadocfi() != null) {
			where.append(" AND PADOCFI = ?");
			params.add(pagosArbitros.getPadocfi());
		}
		if (pagosArbitros != null && pagosArbitros.getPafecalta() != null) {
			where.append(" AND PAFECALTA = ?");
			params.add(pagosArbitros.getPafecalta());
		}
		if (pagosArbitros != null && pagosArbitros.getPafecmodif() != null) {
			where.append(" AND PAFECMODIF = ?");
			params.add(pagosArbitros.getPafecmodif());
		}
		if (pagosArbitros != null && pagosArbitros.getPausualta() != null) {
			where.append(" AND PAUSUALTA = ?");
			params.add(pagosArbitros.getPausualta());
		}
		if (pagosArbitros != null && pagosArbitros.getPausumodif() != null) {
			where.append(" AND PAUSUMODIF = ?");
			params.add(pagosArbitros.getPausumodif());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Pagosarbitros entity
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Pagosarbitros pagosArbitros, Boolean startsWith) {
		StringBuilder where = new StringBuilder(PagosArbitrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (pagosArbitros != null && pagosArbitros.getPasacodigo() != null) {
			where.append(" AND UPPER(PASACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPasacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPasacodigo().toUpperCase() + "%");
			}
			where.append(" AND PASACODIGO IS NOT NULL");
		}
		if (pagosArbitros != null && pagosArbitros.getPaarcodigo() != null) {
			where.append(" AND UPPER(PAARCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPaarcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPaarcodigo().toUpperCase() + "%");
			}
			where.append(" AND PAARCODIGO IS NOT NULL");
		}
		if (pagosArbitros != null && pagosArbitros.getPatrid() != null) {
			where.append(" AND UPPER(PATRID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPatrid().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPatrid().toUpperCase() + "%");
			}
			where.append(" AND PATRID IS NOT NULL");
		}
		if (pagosArbitros != null && pagosArbitros.getPanumexp() != null) {
			where.append(" AND UPPER(PANUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPanumexp().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPanumexp().toUpperCase() + "%");
			}
			where.append(" AND PANUMEXP IS NOT NULL");
		}
		if (pagosArbitros != null && pagosArbitros.getPafeccont() != null) {
			where.append(" AND PAFECCONT = ?");
			params.add(pagosArbitros.getPafeccont());
		}
		if (pagosArbitros != null && pagosArbitros.getPafecultcon() != null) {
			where.append(" AND PAFECULTCON = ?");
			params.add(pagosArbitros.getPafecultcon());
		}
		if (pagosArbitros != null && pagosArbitros.getPadocfi() != null) {
			where.append(" AND UPPER(PADOCFI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPadocfi().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPadocfi().toUpperCase() + "%");
			}
			where.append(" AND PADOCFI IS NOT NULL");
		}
		if (pagosArbitros != null && pagosArbitros.getPafecalta() != null) {
			where.append(" AND PAFECALTA = ?");
			params.add(pagosArbitros.getPafecalta());
		}
		if (pagosArbitros != null && pagosArbitros.getPafecmodif() != null) {
			where.append(" AND PAFECMODIF = ?");
			params.add(pagosArbitros.getPafecmodif());
		}
		if (pagosArbitros != null && pagosArbitros.getPausualta() != null) {
			where.append(" AND UPPER(PAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPausualta().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPausualta().toUpperCase() + "%");
			}
			where.append(" AND PAUSUALTA IS NOT NULL");
		}
		if (pagosArbitros != null && pagosArbitros.getPausumodif() != null) {
			where.append(" AND UPPER(PAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(pagosArbitros.getPausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + pagosArbitros.getPausumodif().toUpperCase() + "%");
			}
			where.append(" AND PAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the Pagosarbitros table sin actualizar.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Pagosarbitros> findAllSinActualizarOrdenado() {
		StringBuilder query = new StringBuilder(
				"SELECT PASACODIGO, PAARCODIGO, PATRID, PANUMEXP, PAFECCONT, NVL(PAFECULTCON,TO_DATE('01/01/2000','DD/MM/YYYY')) AS PAFECULTCON, PADOCFI, PAFECALTA, PAFECMODIF, PAUSUALTA, PAUSUMODIF ");
		query.append("FROM PAGOSARBITROS ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE PAFECCONT IS NULL AND (PAFECULTCON IS NULL OR (PAFECULTCON IS NOT NULL AND PAFECULTCON<TRUNC(SYSDATE))) ");
		query.append(where);

		query.append("ORDER BY NVL(PAFECULTCON,TO_DATE('01/01/2000','DD/MM/YYYY')) DESC");

		return (List<Pagosarbitros>) this.jdbcTemplate.query(query.toString(), this.rwMap);
	}

	/**
	 * Counts rows in the Pagos table sin actualizar.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllSinActualizarCount() {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PAGOSARBITROS ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE PAFECCONT IS NULL AND (PAFECULTCON IS NULL OR (PAFECULTCON IS NOT NULL AND PAFECULTCON<TRUNC(SYSDATE))) ");
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString());
	}

}
