package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Pagosarbitros;

/**
 * PagosArbitros2Dao  
 * 
 *  
 */

public interface PagosArbitrosDao {

	/**
	 * Inserts a single row in the PagosArbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	Pagosarbitros add(Pagosarbitros pagosArbitros);

	/**
	 * Updates a single row in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	Pagosarbitros update(Pagosarbitros pagosArbitros);

	/**
	 * Find a single row in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	Pagosarbitros find(Pagosarbitros pagosArbitros);

	/**
	 * Deletes a single row in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return
	 */
	void remove(Pagosarbitros pagosArbitros);

	/**
	 * Finds a List of rows in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pagosarbitros> findAll(Pagosarbitros pagosArbitros, Pagination pagination);

	/**
	 * Counts rows in the Pagosarbitros table.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @return Long
	 */
	Long findAllCount(Pagosarbitros pagosArbitros);

	/**
	 * Finds rows in the Pagosarbitros table using like.
	 * 
	 * @param pagosArbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Pagosarbitros> findAllLike(Pagosarbitros pagosArbitros, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Pagosarbitros table using like.
	 * 
	 * @param pagos
	 *            Pagosarbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Pagosarbitros pagosArbitros, Boolean startsWith);

	/**
	 * Finds a List of rows in the Pagosarbitros table sin actualizar.
	 * 
	 * @return List
	 */
	public List<Pagosarbitros> findAllSinActualizarOrdenado();

	/**
	 * Counts rows in the Pagos table sin actualizar.
	 * 
	 * @return Long
	 */
	public Long findAllSinActualizarCount();

}
