// CHECKSTYLE:OFF
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Grupo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Contacto;

/**
 * * OrganismoDaoImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class OrganismoDaoImpl implements OrganismoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Organismo> rwMap = new RowMapper<Organismo>() {
		public Organismo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Organismo organismo = new Organismo(resultSet.getString("CODORG"), resultSet.getString("ENTIDADID"),
					resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"), resultSet.getString("ACTIVA"),
					resultSet.getString("ISKONTSUMOGEST"), resultSet.getString("ISKONTSUMONET"),
					resultSet.getString("ISOFERTAFORM"), resultSet.getString("ISCONSULTASWEB"),
					resultSet.getString("ISNACIONAL"), resultSet.getString("OBSERVACIONES"),
					resultSet.getString("TELEFONO"), resultSet.getString("FAX"), resultSet.getString("EMAIL"),
					resultSet.getString("URL"), resultSet.getString("USUARIO"), resultSet.getString("PASSWORD"),
					resultSet.getString("NORAPAISID"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("USUULTMOD"), resultSet.getDate("FECULTMOD"));
			organismo.setCif(resultSet.getString("CIF"));
			organismo.setCompleDirec(resultSet.getString("COMPLEDIREC"));
			return organismo;
		}
	};

	private RowMapper<Organismo> rwMapOrganismoContacto = new RowMapper<Organismo>() {
		public Organismo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Organismo organismo = new Organismo(resultSet.getString("CODORG"), resultSet.getString("ENTIDADID"),
					resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"), resultSet.getString("ACTIVA"),
					resultSet.getString("ISKONTSUMOGEST"), resultSet.getString("ISKONTSUMONET"),
					resultSet.getString("ISOFERTAFORM"), resultSet.getString("ISCONSULTASWEB"),
					resultSet.getString("ISNACIONAL"), resultSet.getString("OBSERVACIONES"),
					resultSet.getString("TELEFONO"), resultSet.getString("FAX"), resultSet.getString("EMAIL"),
					resultSet.getString("URL"), resultSet.getString("USUARIO"), resultSet.getString("PASSWORD"),
					resultSet.getString("NORAPAISID"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("USUULTMOD"), resultSet.getDate("FECULTMOD"), resultSet.getString("NOMBRE"),
					null);
			organismo.setCompleDirec(resultSet.getString("COMPLEDIREC"));
			return organismo;
		}
	};

	private RowMapper<Contacto> rwMapContacto = new RowMapper<Contacto>() {
		public Contacto mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Contacto contacto = new Contacto(resultSet.getString("CONTACTOID"), resultSet.getString("NOMBRE"),
					resultSet.getString("CARGO"), resultSet.getString("TELEFONO"), resultSet.getString("FAX"),
					resultSet.getString("EMAIL"), resultSet.getString("URL"), resultSet.getString("ISNACIONAL"),
					resultSet.getString("NORAPAISID"), resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("USUULTMOD"), resultSet.getDate("FECULTMOD"),
					resultSet.getString("COMPLEDIREC"));

			return contacto;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo add(Organismo organismo) {

		String query = "INSERT INTO ORGANISMO( COD_ORG,ENTIDAD_ID,NOMBRE_ES,NOMBRE_EU,ACTIVA,ISKONTSUMOGEST,ISKONTSUMONET,ISOFERTAFORM,ISCONSULTASWEB,ISNACIONAL,OBSERVACIONES,TELEFONO,FAX,EMAIL,URL,USUARIO,PASSWORD,NORA_PAIS_ID,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,USUULTMOD,FECULTMOD)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, organismo.getCodOrg(), organismo.getEntidadId(), organismo.getNombreEs(),
				organismo.getNombreEu(), organismo.getActiva(), organismo.getIskontsumogest(),
				organismo.getIskontsumonet(), organismo.getIsofertaform(), organismo.getIsconsultasweb(),
				organismo.getIsnacional(), organismo.getObservaciones(), organismo.getTelefono(), organismo.getFax(),
				organismo.getEmail(), organismo.getUrl(), organismo.getUsuario(), organismo.getPassword(),
				organismo.getNoraPaisId(), organismo.getNombrePais(), organismo.getNoraProvinciaId(),
				organismo.getNombreProvincia(), organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(),
				organismo.getNoraLocalidadId(), organismo.getNombreLocalidad(), organismo.getNoraCalleId(),
				organismo.getNombreCalle(), organismo.getNoraCpId(), organismo.getNombreCp(),
				organismo.getNoraPortalId(), organismo.getNombrePortal(), organismo.getUsuultmod(),
				organismo.getFecultmod());
		return organismo;
	}

	/**
	 * Updates a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo update(Organismo organismo) {
		String query = "UPDATE ORGANISMO SET ENTIDAD_ID=?,NOMBRE_ES=?,NOMBRE_EU=?,ACTIVA=?,ISKONTSUMOGEST=?,ISKONTSUMONET=?,ISOFERTAFORM=?,ISCONSULTASWEB=?,ISNACIONAL=?,OBSERVACIONES=?,TELEFONO=?,FAX=?,EMAIL=?,URL=?,USUARIO=?,PASSWORD=?,NORA_PAIS_ID=?,NOMBRE_PAIS=?,NORA_PROVINCIA_ID=?,NOMBRE_PROVINCIA=?,NORA_MUNICIPIO_ID=?,NOMBRE_MUNICIPIO=?,NORA_LOCALIDAD_ID=?,NOMBRE_LOCALIDAD=?,NORA_CALLE_ID=?,NOMBRE_CALLE=?,NORA_CP_ID=?,NOMBRE_CP=?,NORA_PORTAL_ID=?,NOMBRE_PORTAL=?,USUULTMOD=?,FECULTMOD=? WHERE COD_ORG=?";
		this.jdbcTemplate.update(query, organismo.getEntidadId(), organismo.getNombreEs(), organismo.getNombreEu(),
				organismo.getActiva(), organismo.getIskontsumogest(), organismo.getIskontsumonet(),
				organismo.getIsofertaform(), organismo.getIsconsultasweb(), organismo.getIsnacional(),
				organismo.getObservaciones(), organismo.getTelefono(), organismo.getFax(), organismo.getEmail(),
				organismo.getUrl(), organismo.getUsuario(), organismo.getPassword(), organismo.getNoraPaisId(),
				organismo.getNombrePais(), organismo.getNoraProvinciaId(), organismo.getNombreProvincia(),
				organismo.getNoraMunicipioId(), organismo.getNombreMunicipio(), organismo.getNoraLocalidadId(),
				organismo.getNombreLocalidad(), organismo.getNoraCalleId(), organismo.getNombreCalle(),
				organismo.getNoraCpId(), organismo.getNombreCp(), organismo.getNoraPortalId(),
				organismo.getNombrePortal(), organismo.getUsuultmod(), organismo.getFecultmod(), organismo.getCodOrg());
		return organismo;
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo find(Organismo organismo) {
		String query = "SELECT t1.COD_ORG CODORG, t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.ISNACIONAL ISNACIONAL, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ "FROM ORGANISMO t1  " + "WHERE t1.COD_ORG = ?    ";
		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMap, organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoById(Organismo organismo) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.ISNACIONAL ISNACIONAL, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.TELEFONO2 TELEFONO2, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.COD_ORG CODORG, t1.COMPLE_DIREC,t1.CIF CIF  "
				+ "FROM ORGANISMO t1  " + "WHERE t1.ENTIDAD_ID = ?    ";
		return (Organismo) this.jdbcTemplate.queryForObject(query, new RowMapper<Organismo>() {
			public Organismo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Organismo(resultSet.getString("ENTIDADID"), resultSet.getString("NOMBREES"),
						resultSet.getString("NOMBREEU"), resultSet.getString("ACTIVA"),
						resultSet.getString("ISKONTSUMOGEST"), resultSet.getString("ISKONTSUMONET"),
						resultSet.getString("ISOFERTAFORM"), resultSet.getString("ISCONSULTASWEB"),
						resultSet.getString("ISNACIONAL"), resultSet.getString("OBSERVACIONES"),
						resultSet.getString("TELEFONO"), resultSet.getString("TELEFONO2"), resultSet.getString("FAX"),
						resultSet.getString("EMAIL"), resultSet.getString("URL"), resultSet.getString("USUARIO"),
						resultSet.getString("PASSWORD"), resultSet.getString("USUULTMOD"),
						resultSet.getDate("FECULTMOD"), resultSet.getString("NORAPAISID"),
						resultSet.getString("NOMBREPAIS"), resultSet.getString("NORAPROVINCIAID"),
						resultSet.getString("NOMBREPROVINCIA"), resultSet.getString("NORAMUNICIPIOID"),
						resultSet.getString("NOMBREMUNICIPIO"), resultSet.getString("NORALOCALIDADID"),
						resultSet.getString("NOMBRELOCALIDAD"), resultSet.getString("NORACALLEID"),
						resultSet.getString("NOMBRECALLE"), resultSet.getString("NORACPID"),
						resultSet.getString("NOMBRECP"), resultSet.getString("NORAPORTALID"),
						resultSet.getString("NOMBREPORTAL"), resultSet.getString("CODORG"),
						resultSet.getString("COMPLE_DIREC"), resultSet.getString("CIF"));
			}
		}, organismo.getEntidadId());
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoByCodOrg(Organismo organismo) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.ISNACIONAL ISNACIONAL, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.TELEFONO2 TELEFONO2, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.COD_ORG CODORG, t1.COMPLE_DIREC,t1.CIF CIF  "
				+ "FROM ORGANISMO t1  " + "WHERE t1.COD_ORG = ?    ";
		return (Organismo) this.jdbcTemplate.queryForObject(query, new RowMapper<Organismo>() {
			public Organismo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Organismo(resultSet.getString("ENTIDADID"), resultSet.getString("NOMBREES"),
						resultSet.getString("NOMBREEU"), resultSet.getString("ACTIVA"),
						resultSet.getString("ISKONTSUMOGEST"), resultSet.getString("ISKONTSUMONET"),
						resultSet.getString("ISOFERTAFORM"), resultSet.getString("ISCONSULTASWEB"),
						resultSet.getString("ISNACIONAL"), resultSet.getString("OBSERVACIONES"),
						resultSet.getString("TELEFONO"), resultSet.getString("TELEFONO2"), resultSet.getString("FAX"),
						resultSet.getString("EMAIL"), resultSet.getString("URL"), resultSet.getString("USUARIO"),
						resultSet.getString("PASSWORD"), resultSet.getString("USUULTMOD"),
						resultSet.getDate("FECULTMOD"), resultSet.getString("NORAPAISID"),
						resultSet.getString("NOMBREPAIS"), resultSet.getString("NORAPROVINCIAID"),
						resultSet.getString("NOMBREPROVINCIA"), resultSet.getString("NORAMUNICIPIOID"),
						resultSet.getString("NOMBREMUNICIPIO"), resultSet.getString("NORALOCALIDADID"),
						resultSet.getString("NOMBRELOCALIDAD"), resultSet.getString("NORACALLEID"),
						resultSet.getString("NOMBRECALLE"), resultSet.getString("NORACPID"),
						resultSet.getString("NOMBRECP"), resultSet.getString("NORAPORTALID"),
						resultSet.getString("NOMBREPORTAL"), resultSet.getString("CODORG"),
						resultSet.getString("COMPLE_DIREC"), resultSet.getString("CIF"));
			}
		}, organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo KNet table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoKnet(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC  "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL AND t1.ISKONTSUMONET = ?   ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg(), Y41bConstantes.VALOR_SI);
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoKbide(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL AND t1.ISKONTSUMOGEST = ?   ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg(), Y41bConstantes.VALOR_SI);
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismo(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ " ,(SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 " + "WHERE t1.COD_ORG = ?  AND t1.COD_ORG IS NOT NULL ";
		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMap, organismo.getCodOrg(), organismo.getCodOrg());
	}

	/**
	 * Removes a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return
	 */
	public void remove(Organismo organismo) {
		String query = "DELETE  FROM ORGANISMO WHERE COD_ORG=?";
		this.jdbcTemplate.update(query, organismo.getCodOrg());
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAll(Organismo organismo, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND t1.COD_ORG = ?");
			params.add(organismo.getCodOrg());
		}
		if (organismo != null && organismo.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(organismo.getEntidadId());
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(organismo.getNombreEs());
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(organismo.getNombreEu());
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND t1.CIF = ?");
			params.add(organismo.getCif());
		}
		if (organismo != null && organismo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(organismo.getActiva());
		}
		if (organismo != null && organismo.getIskontsumogest() != null) {
			where.append(" AND t1.ISKONTSUMOGEST = ?");
			params.add(organismo.getIskontsumogest());
		}
		if (organismo != null && organismo.getIskontsumonet() != null) {
			where.append(" AND t1.ISKONTSUMONET = ?");
			params.add(organismo.getIskontsumonet());
		}
		if (organismo != null && organismo.getIsofertaform() != null) {
			where.append(" AND t1.ISOFERTAFORM = ?");
			params.add(organismo.getIsofertaform());
		}
		if (organismo != null && organismo.getIsconsultasweb() != null) {
			where.append(" AND t1.ISCONSULTASWEB = ?");
			params.add(organismo.getIsconsultasweb());
		}
		if (organismo != null && organismo.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(organismo.getIsnacional());
		}
		if (organismo != null && organismo.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(organismo.getObservaciones());
		}
		if (organismo != null && organismo.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(organismo.getTelefono());
		}
		if (organismo != null && organismo.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(organismo.getFax());
		}
		if (organismo != null && organismo.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(organismo.getEmail());
		}
		if (organismo != null && organismo.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(organismo.getUrl());
		}
		if (organismo != null && organismo.getUsuario() != null) {
			where.append(" AND t1.USUARIO = ?");
			params.add(organismo.getUsuario());
		}
		if (organismo != null && organismo.getPassword() != null) {
			where.append(" AND t1.PASSWORD = ?");
			params.add(organismo.getPassword());
		}
		if (organismo != null && organismo.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(organismo.getNoraPaisId());
		}
		if (organismo != null && organismo.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(organismo.getNombrePais());
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(organismo.getNombreProvincia());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(organismo.getNombreMunicipio());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(organismo.getNombreLocalidad());
		}
		if (organismo != null && organismo.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(organismo.getNoraCalleId());
		}
		if (organismo != null && organismo.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(organismo.getNombreCalle());
		}
		if (organismo != null && organismo.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(organismo.getNoraCpId());
		}
		if (organismo != null && organismo.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(organismo.getNombreCp());
		}
		if (organismo != null && organismo.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(organismo.getNoraPortalId());
		}
		if (organismo != null && organismo.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(organismo.getNombrePortal());
		}
		if (organismo != null && organismo.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(organismo.getUsuultmod());
		}
		if (organismo != null && organismo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(organismo.getFecultmod());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Organismo organismo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND t1.COD_ORG = ?");
			params.add(organismo.getCodOrg());
		}
		if (organismo != null && organismo.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(organismo.getEntidadId());
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(organismo.getNombreEs());
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(organismo.getNombreEu());
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND t1.CIF = ?");
			params.add(organismo.getCif());
		}
		if (organismo != null && organismo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(organismo.getActiva());
		}
		if (organismo != null && organismo.getIskontsumogest() != null) {
			where.append(" AND t1.ISKONTSUMOGEST = ?");
			params.add(organismo.getIskontsumogest());
		}
		if (organismo != null && organismo.getIskontsumonet() != null) {
			where.append(" AND t1.ISKONTSUMONET = ?");
			params.add(organismo.getIskontsumonet());
		}
		if (organismo != null && organismo.getIsofertaform() != null) {
			where.append(" AND t1.ISOFERTAFORM = ?");
			params.add(organismo.getIsofertaform());
		}
		if (organismo != null && organismo.getIsconsultasweb() != null) {
			where.append(" AND t1.ISCONSULTASWEB = ?");
			params.add(organismo.getIsconsultasweb());
		}
		if (organismo != null && organismo.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(organismo.getIsnacional());
		}
		if (organismo != null && organismo.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(organismo.getObservaciones());
		}
		if (organismo != null && organismo.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(organismo.getTelefono());
		}
		if (organismo != null && organismo.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(organismo.getFax());
		}
		if (organismo != null && organismo.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(organismo.getEmail());
		}
		if (organismo != null && organismo.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(organismo.getUrl());
		}
		if (organismo != null && organismo.getUsuario() != null) {
			where.append(" AND t1.USUARIO = ?");
			params.add(organismo.getUsuario());
		}
		if (organismo != null && organismo.getPassword() != null) {
			where.append(" AND t1.PASSWORD = ?");
			params.add(organismo.getPassword());
		}
		if (organismo != null && organismo.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(organismo.getNoraPaisId());
		}
		if (organismo != null && organismo.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(organismo.getNombrePais());
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(organismo.getNombreProvincia());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(organismo.getNombreMunicipio());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(organismo.getNombreLocalidad());
		}
		if (organismo != null && organismo.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(organismo.getNoraCalleId());
		}
		if (organismo != null && organismo.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(organismo.getNombreCalle());
		}
		if (organismo != null && organismo.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(organismo.getNoraCpId());
		}
		if (organismo != null && organismo.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(organismo.getNombreCp());
		}
		if (organismo != null && organismo.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(organismo.getNoraPortalId());
		}
		if (organismo != null && organismo.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(organismo.getNombrePortal());
		}
		if (organismo != null && organismo.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(organismo.getUsuultmod());
		}
		if (organismo != null && organismo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(organismo.getFecultmod());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLike(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_ORG IS NOT NULL");
		}
		if (organismo != null && organismo.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getEntidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getActiva() != null) {
			where.append(" AND UPPER(t1.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getActiva().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVA IS NOT NULL");
		}
		if (organismo != null && organismo.getIskontsumogest() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getIskontsumogest().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getIskontsumogest().toUpperCase() + "%");
			}
			where.append(" AND t1.ISKONTSUMOGEST IS NOT NULL");
		}
		if (organismo != null && organismo.getIskontsumonet() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getIskontsumonet().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getIskontsumonet().toUpperCase() + "%");
			}
			where.append(" AND t1.ISKONTSUMONET IS NOT NULL");
		}
		if (organismo != null && organismo.getIsofertaform() != null) {
			where.append(" AND UPPER(t1.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getIsofertaform().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getIsofertaform().toUpperCase() + "%");
			}
			where.append(" AND t1.ISOFERTAFORM IS NOT NULL");
		}
		if (organismo != null && organismo.getIsconsultasweb() != null) {
			where.append(" AND UPPER(t1.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getIsconsultasweb().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getIsconsultasweb().toUpperCase() + "%");
			}
			where.append(" AND t1.ISCONSULTASWEB IS NOT NULL");
		}
		if (organismo != null && organismo.getIsnacional() != null) {
			where.append(" AND UPPER(t1.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t1.ISNACIONAL IS NOT NULL");
		}
		if (organismo != null && organismo.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (organismo != null && organismo.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (organismo != null && organismo.getFax() != null) {
			where.append(" AND UPPER(t1.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getFax().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getFax().toUpperCase() + "%");
			}
			where.append(" AND t1.FAX IS NOT NULL");
		}
		if (organismo != null && organismo.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (organismo != null && organismo.getUrl() != null) {
			where.append(" AND UPPER(t1.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getUrl().toUpperCase() + "%");
			}
			where.append(" AND t1.URL IS NOT NULL");
		}
		if (organismo != null && organismo.getUsuario() != null) {
			where.append(" AND UPPER(t1.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO IS NOT NULL");
		}
		if (organismo != null && organismo.getPassword() != null) {
			where.append(" AND UPPER(t1.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getPassword().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getPassword().toUpperCase() + "%");
			}
			where.append(" AND t1.PASSWORD IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (organismo != null && organismo.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (organismo != null && organismo.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (organismo != null && organismo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getFecultmod() + "%");
			} else {
				params.add("%" + organismo.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoKnet(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoKnetCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoKbide(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND t1.ISKONTSUMOGEST = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoKbideCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND t1.ISKONTSUMOGEST = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoCambioInstructor(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND (t1.COD_ORG = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA);
		where.append(" OR t1.COD_ORG = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_ARABA);
		where.append(" OR t1.COD_ORG = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA);
		where.append(" OR t1.COD_ORG = ? ");
		params.add(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		where.append(" OR t1.COD_ORG = ?) ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoCambioInstructorCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND (t1.COD_ORG = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA);
		where.append(" OR t1.COD_ORG = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_ARABA);
		where.append(" OR t1.COD_ORG = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA);
		where.append(" OR t1.COD_ORG = ? ");
		params.add(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
		where.append(" OR t1.COD_ORG = ?) ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de Kontsumobide y
	 * KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoKbideKnet(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND (t1.ISKONTSUMOGEST = ? ");
		params.add(Y41bConstantes.VALOR_SI);
		where.append(" OR t1.ISKONTSUMONET = ? ");
		params.add(Y41bConstantes.VALOR_SI);
		where.append(" ) ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de Kontsumobide y KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoKbideKnetCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		where.append(" AND (t1.ISKONTSUMOGEST = ? ");
		params.add(Y41bConstantes.VALOR_SI);
		where.append(" OR t1.ISKONTSUMONET = ? ");
		params.add(Y41bConstantes.VALOR_SI);
		where.append(" ) ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismo(Organismo organismo, String codOrgConectado, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		if (codOrgConectado != null) {
			where.append(" AND t1.COD_ORG != ?");
			params.add(codOrgConectado);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoCount(Organismo organismo, String codOrgConectado, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		if (codOrgConectado != null) {
			where.append(" AND t1.COD_ORG != ?");
			params.add(codOrgConectado);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Obtener los grupos a los que pertenece un organismo
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Grupo> obtenerGruposOrganismo(Organismo organismo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t3.entidad_id = t2.entidad_id AND t2.grupo_id = t1.grupo_id  ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.NOMBRE_ES,t1.NOMBRE_EU FROM GRUPOORGANISMO t1, GRUPOS_ENTIDADES t2, ORGANISMO t3 ");

		where.append(" AND t3.cod_org= ? ");
		params.add(organismo.getCodOrg());

		query.append(where);

		return (List<Grupo>) this.jdbcTemplate.query(query.toString(), new RowMapper<Grupo>() {
			public Grupo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Grupo(null, null, resultSet.getString("NOMBRE_ES"), resultSet.getString("NOMBRE_EU"), null,
						null, null, null);
			}
		}, params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet y
	 * Kontsumobide (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoKTodos(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		// where.append(" AND t1.COD_ORG IS NOT NULL");

		// where.append(" AND t1.ISKONTSUMOGEST = ? ");
		// params.add(Y41bConstantes.VALOR_SI);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoBide y Kontsumonet (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoKTodosCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		// where.append(" AND t1.COD_ORG IS NOT NULL");

		// where.append(" AND t1.ISKONTSUMOGEST = ? ");
		// params.add(Y41bConstantes.VALOR_SI);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param Y41bGrupoOrganismoTree
	 *            Y41bGrupoOrganismoTree
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public List<Organismo> getAyuntamientoPorMunicipio(String provincia, String municipio) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT t1.COD_ORG CODORG, t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.ISNACIONAL ISNACIONAL, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ " FROM ORGANISMO t1, GRUPOS_ENTIDADES tt0, GRUPOORGANISMO tt3 where t1.ENTIDAD_ID = tt0.ENTIDAD_ID AND tt0.GRUPO_ID = TT3.GRUPO_ID AND tt0.grupo_id = ? and T1.NORA_PROVINCIA_ID = ? AND t1.NORA_MUNICIPIO_ID = ?");

		params.add(Y41bConstantes.GRUPO_CONTACTO_AYUNTAMIENTO);
		params.add(provincia);
		params.add(municipio);

		query.append(where);
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosCrearSolicitudes(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_CREAR_SOLICITUDES t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosCrearSolicitudesCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_CREAR_SOLICITUDES t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosNotificacionProductor(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_NOTIF_PRODUCTOR t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosNotificacionProductorCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_NOTIF_PRODUCTOR t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosComunicacionExterna(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_COMUNICACION_EXTERNA t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosComunicacionExternaCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_COMUNICACION_EXTERNA t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosUsuariosKbide13(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_USUARIOS_KBIDE13 t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosUsuariosKbide13Count(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_USUARIOS_KBIDE13 t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosTrasladoConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_TRASLADO_CONSUMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosTrasladoConsumoCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_TRASLADO_CONSUMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosInhibicionConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_INHIBICION_CONSUMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosInhibicionConsumoCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_INHIBICION_CONSUMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosOmicAsociacion(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_OMIC_ASOCIACION t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosOmicAsociacionCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_OMIC_ASOCIACION t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosOOEE(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%O%' ESCAPE  '\\'	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosOOEECount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%O%' ESCAPE  '\\'	");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosAACC(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%C%' ESCAPE  '\\' ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosAACCCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%C%' ESCAPE  '\\' ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosOtros(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) not like '%C%' ESCAPE  '\\' AND UPPER(t1.COD_ORG) not like '%O%' ESCAPE  '\\' ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosOtrosCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) not like '%C%' ESCAPE  '\\' AND UPPER(t1.COD_ORG) not like '%O%' ESCAPE  '\\' ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeUsuariosDenunciasEmpresas(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeUsuariosDenunciasEmpresasCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) = ? ");
		params.add(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeCensoUsuarios(Organismo organismo, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_CENSO_USUARIOS t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCensoUsuariosCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_CENSO_USUARIOS t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}
		where.append(" AND t1.COD_ORG IS NOT NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoCrearSolicitudes(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_CREAR_SOLICITUDES t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoNotificacionProductor(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_NOTIF_PRODUCTOR t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoComunicacionExterna(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_COMUNICACION_EXTERNA t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoUsuariosKbide13(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_USUARIOS_KBIDE13 t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoTrasladoConsumo(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_TRASLADO_CONSUMO t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoInhibicionConsumo(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_INHIBICION_CONSUMO t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoOmicAsociacion(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_OMIC_ASOCIACION t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoOOEE(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 "
				+ "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%O%' ESCAPE  '\\'";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoAACC(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 "
				+ "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%C%' ESCAPE  '\\' ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoOtros(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 "
				+ "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) not like '%C%' ESCAPE  '\\' AND UPPER(t1.COD_ORG) not like '%O%' ESCAPE  '\\' )";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findUsuariosDenunciasEmpresas(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) = ? ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg(), Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
	}

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findCensoUsuarios(Organismo organismo) {
		String query = "SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD ,t1.CIF CIF,t1.COMPLE_DIREC COMPLEDIREC "
				+ ", (SELECT t2.NOMBRE FROM ORGANISMO t4, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t4.COD_ORG = ? AND t4.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND ROWNUM=1) NOMBRE "
				+ "FROM ORGANISMO_CENSO_USUARIOS t1 " + "WHERE t1.COD_ORG = ? AND t1.COD_ORG IS NOT NULL ";

		return (Organismo) this.jdbcTemplate.queryForObject(query, rwMapOrganismoContacto, organismo.getCodOrg(),
				organismo.getCodOrg());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet y
	 * Kontsumobide (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoArbitraje(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet y
	 * Kontsumobide (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoArbitrajeJjaa(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%J%' ESCAPE  '\\'	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoBide y Kontsumonet (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoArbitrajeCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoBide y Kontsumonet (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoArbitrajeCountJjaa(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL AND UPPER(t1.COD_ORG) like '%J%' ESCAPE  '\\'  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet y
	 * Kontsumobide (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoAaccEuskadi(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COD_ORG CODORG,t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,NVL(t1.NOMBRE_EU,t1.NOMBRE_ES) NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.CIF,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM ORGANISMO_AACCEUSKADI t1 ");

		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Organismo>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Organismo table de KontsumoBide y Kontsumonet (todos).
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoAaccEuskadiCount(Organismo organismo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COD_ORG IS NOT NULL  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ORGANISMO_AACCEUSKADI t1  ");
		if (organismo != null && organismo.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCodOrg().toUpperCase() + "%");
			}
		}
		if (organismo != null && organismo.getNombreEs() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEs().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (organismo != null && organismo.getNombreEu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + organismo.getNombreEu().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (organismo != null && organismo.getCif() != null) {
			where.append(" AND UPPER(t1.CIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(organismo.getCif().toUpperCase() + "%");
			} else {
				params.add("%" + organismo.getCif().toUpperCase() + "%");
			}
			where.append(" AND t1.CIF IS NOT NULL");
		}
		if (organismo != null && organismo.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(organismo.getNoraProvinciaId());
		}
		if (organismo != null && organismo.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(organismo.getNoraMunicipioId());
		}
		if (organismo != null && organismo.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(organismo.getNoraLocalidadId());
		}
		if (organismo != null && organismo.getIncluirNoactivos() == null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(Y41bConstantes.VALOR_SI);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the Contacto table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Contacto findContacto(Organismo organismo) {

		String query = "SELECT t2.CONTACTO_ID CONTACTOID,t2.NOMBRE NOMBRE, t2.CARGO CARGO, t2.TELEFONO TELEFONO, t2.FAX FAX,t2.EMAIL EMAIL, "
				+ "t2.URL URL,t2.ISNACIONAL ISNACIONAL, t2.NORA_PAIS_ID NORAPAISID, t2.NOMBRE_PAIS NOMBREPAIS,t2.NORA_PROVINCIA_ID NORAPROVINCIAID,t2.NOMBRE_PROVINCIA NOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,"
				+ "t2.NORA_LOCALIDAD_ID NORALOCALIDADID,t2.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t2.NORA_CALLE_ID NORACALLEID, t2.NOMBRE_CALLE NOMBRECALLE,t2.NORA_CP_ID NORACPID,t2.NOMBRE_CP NOMBRECP,t2.NORA_PORTAL_ID NORAPORTALID,t2.NOMBRE_PORTAL NOMBREPORTAL, "
				+ "t2.USUULTMOD USUULTMOD,t2.FECULTMOD FECULTMOD, t2.COMPLE_DIREC COMPLEDIREC "

				+ "FROM ORGANISMO t1, CONTACTO t2, ENTIDAD_CONTACTO t3 WHERE t1.COD_ORG = ? AND t1.ENTIDAD_ID = t3.ENTIDAD_ID(+) AND t3.CONTACTO_ID=t2.CONTACTO_ID(+) AND UPPER(t2.CARGO) LIKE ? ESCAPE '\\' ";
		return (Contacto) this.jdbcTemplate.queryForObject(query, rwMapContacto, organismo.getCodOrg(),
				"%" + Y41bConstantes.CARGO_RESPONSABLE_REGISTRO + "%");
	}
}
