package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Grupo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Contacto;

/**
 * * OrganismoDao  
 * 
 *  
 */

public interface OrganismoDao {

	/**
	 * Inserts a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo add(Organismo organismo);

	/**
	 * Updates a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo update(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo find(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findOrganismoById(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findOrganismoByCodOrg(Organismo organismo);

	/**
	 * Finds a single row in the Organismo KNet table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	Organismo findOrganismoKnet(Organismo organismo);

	/**
	 * Finds a single row in the Organismo KBide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	Organismo findOrganismoKbide(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	Organismo findOrganismo(Organismo organismo);

	/**
	 * Deletes a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return
	 */
	void remove(Organismo organismo);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Organismo> findAll(Organismo organismo, Pagination pagination);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	Long findAllCount(Organismo organismo);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLike(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKnet(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKnetCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKbide(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKbideCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like de Kontsumobide y
	 * KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKbideKnet(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de Kontsumobide y KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKbideKnetCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismo(Organismo organismo, String codOrgConectado, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoCount(Organismo organismo, String codOrgConectado, Boolean startsWith);

	/**
	 * Obtener los grupos a los que pertenece un organismo
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	List<Grupo> obtenerGruposOrganismo(Organismo organismo);

	/**
	 * Finds rows in the Organismo table using like de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKTodos(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKTodosCount(Organismo organismo, Boolean startsWith);

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param provincia
	 *            the provincia
	 * @param municipio
	 *            the municipio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public List<Organismo> getAyuntamientoPorMunicipio(String provincia, String municipio);

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismoCambioInstructor(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismoCambioInstructorCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosCrearSolicitudes(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosCrearSolicitudesCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosNotificacionProductor(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosNotificacionProductorCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosComunicacionExterna(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosComunicacionExternaCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosUsuariosKbide13(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosUsuariosKbide13Count(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosTrasladoConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosTrasladoConsumoCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosInhibicionConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosInhibicionConsumoCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Organismo> findAllLikeOrganismosOmicAsociacion(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeOrganismosOmicAsociacionCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoCrearSolicitudes(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoNotificacionProductor(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoComunicacionExterna(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoUsuariosKbide13(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoTrasladoConsumo(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoInhibicionConsumo(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	@Transactional(readOnly = true)
	public Organismo findOrganismoOmicAsociacion(Organismo organismo);

	/**
	 * Finds rows in the Organismo table using like de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoArbitraje(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoArbitrajeJjaa(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoArbitrajeCount(Organismo organismo, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoArbitrajeCountJjaa(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOOEE(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOOEECount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosAACC(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosAACCCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOtros(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOtrosCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeUsuariosDenunciasEmpresas(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeUsuariosDenunciasEmpresasCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeCensoUsuarios(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCensoUsuariosCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findOrganismoOOEE(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findOrganismoAACC(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findOrganismoOtros(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findUsuariosDenunciasEmpresas(Organismo organismo);

	/**
	 * Finds a single row in the Organismo Kbide table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findCensoUsuarios(Organismo organismo);

	/**
	 * Finds rows in the Organismo table
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoAaccEuskadi(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoAaccEuskadiCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Contacto
	 */
	Contacto findContacto(Organismo organismo);

}
