package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * OoeeDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class OoeeDaoImpl implements OoeeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Ooee> rwMap = new RowMapper<Ooee>() {
		public Ooee mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ooee(resultSet.getString("OECODIGO"),
					resultSet.getString("OETESI"),
					resultSet.getString("OENOREP"),
					resultSet.getString("OENIREP"),
					resultSet.getString("OENOCARE"),
					resultSet.getString("OENOAPP"),
					resultSet.getString("OENOAPS"),
					resultSet.getDate("OEFEAD"), resultSet.getString("OECOJA"),
					resultSet.getDate("OEFEADFIN"),
					resultSet.getDate("OEFECALTA"),
					resultSet.getString("OEUSUALTA"),
					resultSet.getDate("OEFECMOD"),
					resultSet.getString("OEUSUMOD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Pagination
	 * @return Ooee
	 */
	public Ooee add(Ooee ooee) {
		String query = "INSERT INTO OOEE (OECODIGO, OETESI, OENOREP, OENIREP, OENOCARE, OENOAPP, OENOAPS, OEFEAD, OECOJA, OEFEADFIN, OEFECALTA, OEUSUALTA, OEFECMOD, OEUSUMOD) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ooee.getOecodigo(), ooee.getOetesi(),
				ooee.getOenorep(), ooee.getOenirep(), ooee.getOenocare(),
				ooee.getOenoapp(), ooee.getOenoaps(), ooee.getOefead(),
				ooee.getOecoja(), ooee.getOefeadfin(), ooee.getOefecalta(),
				ooee.getOeusualta(), ooee.getOefecmod(), ooee.getOeusumod());
		return ooee;
	}

	/**
	 * Updates a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Pagination
	 * @return Ooee
	 */
	public Ooee update(Ooee ooee) {
		// String query =
		// "UPDATE OOEE SET OETESI=?, OENOREP=?, OENIREP=?, OENOCARE=?, OENOAPP=?, OENOAPS=?, OEFEAD=?, OECOJA=?, OEFEADFIN=?, OEFECALTA=?, OEUSUALTA=?, OEFECMOD=?, OEUSUMOD=? WHERE OECODIGO=?";
		String query = "UPDATE OOEE SET OETESI=?, OENOREP=?, OENIREP=?,  OEFEAD=?, OEFEADFIN=? WHERE OECODIGO=?";
		this.jdbcTemplate.update(query, ooee.getOetesi(), ooee.getOenorep(),
				ooee.getOenirep(), ooee.getOefead(), ooee.getOefeadfin(),
				ooee.getOecodigo());
		return ooee;
	}

	/**
	 * Finds a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Pagination
	 * @return Ooee
	 */
	@Transactional(readOnly = true)
	public Ooee find(Ooee ooee) {
		String query = "SELECT t1.OECODIGO OECODIGO, t1.OETESI OETESI, t1.OENOREP OENOREP, t1.OENIREP OENIREP, t1.OENOCARE OENOCARE, t1.OENOAPP OENOAPP, t1.OENOAPS OENOAPS, t1.OEFEAD OEFEAD, t1.OECOJA OECOJA, t1.OEFEADFIN OEFEADFIN, t1.OEFECALTA OEFECALTA, t1.OEUSUALTA OEUSUALTA, t1.OEFECMOD OEFECMOD, t2.USUARIOXLNET OEUSUMOD FROM OOEE t1,CENSO_MONITOR t2 WHERE t1.OEUSUMOD=t2.MOCODIGO(+) AND t1.OECODIGO = ?  ";

		List<Ooee> ooeeList = this.jdbcTemplate.query(query, this.rwMap,
				ooee.getOecodigo());
		return (Ooee) DataAccessUtils.uniqueResult(ooeeList);
	}

	/**
	 * Removes a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Pagination
	 * @return
	 */
	public void remove(Ooee ooee) {
		String query = "DELETE FROM OOEE WHERE OECODIGO=?";
		this.jdbcTemplate.update(query, ooee.getOecodigo());
	}

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ooee> findAll(Ooee ooee, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.OECODIGO OECODIGO,t1.OETESI OETESI,t1.OENOREP OENOREP,t1.OENIREP OENIREP,t1.OENOCARE OENOCARE,t1.OENOAPP OENOAPP,t1.OENOAPS OENOAPS,t1.OEFEAD OEFEAD,t1.OECOJA OECOJA,t1.OEFEADFIN OEFEADFIN,t1.OEFECALTA OEFECALTA,t1.OEUSUALTA OEUSUALTA,t1.OEFECMOD OEFECMOD,t1.OEUSUMOD OEUSUMOD ");
		query.append("FROM OOEE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ooee);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ooee>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ooee ooee) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM OOEE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ooee);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ooee table using like.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ooee> findAllLike(Ooee ooee, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.OECODIGO OECODIGO,t1.OETESI OETESI,t1.OENOREP OENOREP,t1.OENIREP OENIREP,t1.OENOCARE OENOCARE,t1.OENOAPP OENOAPP,t1.OENOAPS OENOAPS,t1.OEFEAD OEFEAD,t1.OECOJA OECOJA,t1.OEFEADFIN OEFEADFIN,t1.OEFECALTA OEFECALTA,t1.OEUSUALTA OEUSUALTA,t1.OEFECMOD OEFECMOD,t1.OEUSUMOD OEUSUMOD ");
		query.append("FROM OOEE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ooee, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ooee>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ooee table using like.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ooee ooee, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM OOEE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ooee, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ooee entity
	 * 
	 * @param ooee
	 *            Ooee Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Ooee ooee) {

		StringBuilder where = new StringBuilder(OoeeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ooee != null && !Y41bUtils.esNullOCadenaVacia(ooee.getOecodigo())) {
			where.append(" AND TRANSLATE(UPPER(t1.OECODIGO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ ooee.getOecodigo().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.OECODIGO IS NOT NULL");
		}
		if (ooee != null && !Y41bUtils.esNullOCadenaVacia(ooee.getOetesi())) {
			where.append(" AND TRANSLATE(UPPER(t1.OETESI),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ ooee.getOetesi().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.OETESI IS NOT NULL");
		}
		// Organismo
		if (ooee != null && ooee.getOrganismo() != null) {
			if (!Y41bUtils
					.esNullOCadenaVacia(ooee.getOrganismo().getNombreEs())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ ooee.getOrganismo().getNombreEs().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
				where.append(" AND t2.NOMBRE_ES IS NOT NULL");
			}
			if (!Y41bUtils
					.esNullOCadenaVacia(ooee.getOrganismo().getNombreEu())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ ooee.getOrganismo().getNombreEu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
				where.append(" AND t2.NOMBRE_EU IS NOT NULL");
			}
			if (!Y41bUtils.esNullOCadenaVacia(ooee.getOrganismo()
					.getNoraProvinciaId())) {
				where.append(" AND t2.NORA_PROVINCIA_ID = ?");
				params.add(ooee.getOrganismo().getNoraProvinciaId());
			}
			if (!Y41bUtils.esNullOCadenaVacia(ooee.getOrganismo()
					.getNoraMunicipioId())) {
				where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
				params.add(ooee.getOrganismo().getNoraMunicipioId());
			}
			if (!Y41bUtils.esNullOCadenaVacia(ooee.getOrganismo()
					.getNoraLocalidadId())) {
				where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
				params.add(ooee.getOrganismo().getNoraLocalidadId());
			}
		}
		// Sector
		if (ooee != null && !Y41bUtils.esNullOCadenaVacia(ooee.getOesecodigo())) {
			where.append(" AND t3.M6COSE = ? ");
			params.add(ooee.getOesecodigo());
		}
		// Territorio de actuacion
		if (ooee != null
				&& (!Y41bUtils.esNullOCadenaVacia(ooee.getOeThActAraba())
						|| !Y41bUtils.esNullOCadenaVacia(ooee
								.getOeThActBizkaia()) || !Y41bUtils
						.esNullOCadenaVacia(ooee.getOeThActGipuzkoa()))) {
			where.append(" AND ( ");
			if (ooee != null
					&& !Y41bUtils.esNullOCadenaVacia(ooee.getOeThActAraba())) {
				where.append(" t4.M5COTA1 = ? ");
				params.add(ooee.getOeThActAraba());
			}
			if (ooee != null
					&& !Y41bUtils.esNullOCadenaVacia(ooee.getOeThActBizkaia())) {
				if (ooee != null
						&& !Y41bUtils
								.esNullOCadenaVacia(ooee.getOeThActAraba())) {
					where.append(" OR ");
				}
				where.append(" t4.M5COTA1 = ? ");
				params.add(ooee.getOeThActBizkaia());
			}
			if (ooee != null
					&& !Y41bUtils.esNullOCadenaVacia(ooee.getOeThActGipuzkoa())) {
				if (ooee != null
						&& (!Y41bUtils.esNullOCadenaVacia(ooee
								.getOeThActAraba()) || !Y41bUtils
								.esNullOCadenaVacia(ooee.getOeThActBizkaia()))) {
					where.append(" OR ");
				}
				where.append(" t4.M5COTA1 = ? ");
				params.add(ooee.getOeThActGipuzkoa());
			}
			where.append(" ) ");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ooee entity
	 * 
	 * @param ooee
	 *            Ooee Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Ooee ooee, Boolean startsWith) {

		StringBuilder where = new StringBuilder(OoeeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ooee != null && ooee.getOecodigo() != null) {
			where.append(" AND UPPER(t1.OECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.OECODIGO IS NOT NULL");
		}
		if (ooee != null && ooee.getOetesi() != null) {
			where.append(" AND UPPER(t1.OETESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOetesi().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOetesi().toUpperCase() + "%");
			}
			where.append(" AND t1.OETESI IS NOT NULL");
		}
		if (ooee != null && ooee.getOenorep() != null) {
			where.append(" AND UPPER(t1.OENOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOenorep().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOenorep().toUpperCase() + "%");
			}
			where.append(" AND t1.OENOREP IS NOT NULL");
		}
		if (ooee != null && ooee.getOenirep() != null) {
			where.append(" AND UPPER(t1.OENIREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOenirep().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOenirep().toUpperCase() + "%");
			}
			where.append(" AND t1.OENIREP IS NOT NULL");
		}
		if (ooee != null && ooee.getOenocare() != null) {
			where.append(" AND UPPER(t1.OENOCARE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOenocare().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOenocare().toUpperCase() + "%");
			}
			where.append(" AND t1.OENOCARE IS NOT NULL");
		}
		if (ooee != null && ooee.getOenoapp() != null) {
			where.append(" AND UPPER(t1.OENOAPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOenoapp().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOenoapp().toUpperCase() + "%");
			}
			where.append(" AND t1.OENOAPP IS NOT NULL");
		}
		if (ooee != null && ooee.getOenoaps() != null) {
			where.append(" AND UPPER(t1.OENOAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOenoaps().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOenoaps().toUpperCase() + "%");
			}
			where.append(" AND t1.OENOAPS IS NOT NULL");
		}
		if (ooee != null && ooee.getOefead() != null) {
			where.append(" AND t1.OEFEAD = ?");
			params.add(ooee.getOefead());
		}
		if (ooee != null && ooee.getOecoja() != null) {
			where.append(" AND UPPER(t1.OECOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOecoja().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOecoja().toUpperCase() + "%");
			}
			where.append(" AND t1.OECOJA IS NOT NULL");
		}
		if (ooee != null && ooee.getOefeadfin() != null) {
			where.append(" AND t1.OEFEADFIN = ?");
			params.add(ooee.getOefeadfin());
		}
		if (ooee != null && ooee.getOefecalta() != null) {
			where.append(" AND t1.OEFECALTA = ?");
			params.add(ooee.getOefecalta());
		}
		if (ooee != null && ooee.getOeusualta() != null) {
			where.append(" AND UPPER(t1.OEUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOeusualta().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOeusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.OEUSUALTA IS NOT NULL");
		}
		if (ooee != null && ooee.getOefecmod() != null) {
			where.append(" AND t1.OEFECMOD = ?");
			params.add(ooee.getOefecmod());
		}
		if (ooee != null && ooee.getOeusumod() != null) {
			where.append(" AND UPPER(t1.OEUSUMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ooee.getOeusumod().toUpperCase() + "%");
			} else {
				params.add("%" + ooee.getOeusumod().toUpperCase() + "%");
			}
			where.append(" AND t1.OEUSUMOD IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<Ooee> rwMapBusqueda = new RowMapper<Ooee>() {
		public Ooee mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Ooee ooee = new Ooee(resultSet.getString("OECODIGO"),
					resultSet.getString("OETESI"),
					resultSet.getString("OENOREP"),
					resultSet.getString("OENIREP"),
					resultSet.getString("OENOCARE"),
					resultSet.getString("OENOAPP"),
					resultSet.getString("OENOAPS"),
					resultSet.getDate("OEFEAD"), resultSet.getString("OECOJA"),
					resultSet.getDate("OEFEADFIN"),
					resultSet.getDate("OEFECALTA"),
					resultSet.getString("OEUSUALTA"),
					resultSet.getDate("OEFECMOD"),
					resultSet.getString("OEUSUMOD"));
			Organismo organismo = new Organismo();
			organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			organismo.setNombreMunicipio(resultSet
					.getString("OrganismoNOMBREMUNICIPIO"));
			ooee.setOrganismo(organismo);
			ooee.setOeadherido(resultSet.getString("OEADHERIDO"));
			return ooee;
		}
	};

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ooee> findAllBusqueda(Ooee ooee, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.OECODIGO OECODIGO,t1.OETESI OETESI,t1.OENOREP OENOREP,t1.OENIREP OENIREP,t1.OENOCARE OENOCARE,t1.OENOAPP OENOAPP,t1.OENOAPS OENOAPS,t1.OEFEAD OEFEAD,t1.OECOJA OECOJA,t1.OEFEADFIN OEFEADFIN,t1.OEFECALTA OEFECALTA,t1.OEUSUALTA OEUSUALTA,t1.OEFECMOD OEFECMOD,t1.OEUSUMOD OEUSUMOD ");
		query.append(" , t2.NOMBRE_ES OrganismoNOMBREES, t2.NOMBRE_EU OrganismoNOMBREEU, t2.NOMBRE_MUNICIPIO OrganismoNOMBREMUNICIPIO, CASE WHEN t1.OEFEAD IS NULL OR t1.OEFEAD>SYSDATE THEN 'N' ");
		query.append(" WHEN t1.OEFEAD IS NOT NULL AND t1.OEFEAD<SYSDATE AND t1.OEFEADFIN IS NOT NULL AND t1.OEFEADFIN<SYSDATE THEN 'B' ");
		query.append(" ELSE 'A' END oeadherido ");
		query.append(" FROM OOEE t1, ORGANISMO t2, OESE t3, OETA1 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ooee);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.OECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.OECODIGO=t3.M6COOE(+)  ");
		where.append(" AND t1.OECODIGO=t4.M5COOE(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ooee>) this.jdbcTemplate.query(query.toString(),
				this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBusquedaCount(Ooee ooee) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct oecodigo)  FROM OOEE t1, ORGANISMO t2, OESE t3, OETA1 t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ooee);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.OECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.OECODIGO=t3.M6COOE(+)  ");
		where.append(" AND t1.OECODIGO=t4.M5COOE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
