package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Ooee;

/**
 * OoeeDao  
 * 
 *  
 */

public interface OoeeDao {

	/**
	 * Inserts a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	Ooee add(Ooee ooee);

	/**
	 * Updates a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	Ooee update(Ooee ooee);

	/**
	 * Finds a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	Ooee find(Ooee ooee);

	/**
	 * Deletes a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return
	 */
	void remove(Ooee ooee);

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Ooee> findAll(Ooee ooee, Pagination pagination);

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	Long findAllCount(Ooee ooee);

	/**
	 * Finds rows in the Ooee table using like.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Ooee> findAllLike(Ooee ooee, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Ooee table using like.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Ooee ooee, Boolean startsWith);

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Ooee> findAllBusqueda(Ooee ooee, Pagination pagination);

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	Long findAllBusquedaCount(Ooee ooee);
}
