package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Ooee;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Oeta1;

/**
 * Oeta1DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Oeta1DaoImpl implements Oeta1Dao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Oeta1> rwMap = new RowMapper<Oeta1>() {
		public Oeta1 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Oeta1(new Ooee(resultSet.getString("M5COOE"), null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null),
					resultSet.getString("M5COTA1"),
					resultSet.getDate("M5FECALTA"),
					resultSet.getString("M5USUALTA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Pagination
	 * @return Oeta1
	 */
	public Oeta1 add(Oeta1 oeta1) {
		String query = "INSERT INTO OETA1 (M5COOE, M5COTA1, M5FECALTA, M5USUALTA) VALUES (?,?,?,?)";
		Object OoeeOecodigoAux = null;
		if (oeta1.getOoee() != null && oeta1.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oeta1.getOoee().getOecodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, oeta1.getM5cota1(),
				oeta1.getM5fecalta(), oeta1.getM5usualta());
		return oeta1;
	}

	/**
	 * Updates a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Pagination
	 * @return Oeta1
	 */
	public Oeta1 update(Oeta1 oeta1) {
		String query = "UPDATE OETA1 SET  WHERE M5COOE=? AND M5COTA1=? AND M5FECALTA=? AND M5USUALTA=?";
		Object OoeeOecodigoAux = null;
		if (oeta1.getOoee() != null && oeta1.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oeta1.getOoee().getOecodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, oeta1.getM5cota1(),
				oeta1.getM5fecalta(), oeta1.getM5usualta());
		return oeta1;
	}

	/**
	 * Finds a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Pagination
	 * @return Oeta1
	 */
	@Transactional(readOnly = true)
	public Oeta1 find(Oeta1 oeta1) {
		String query = "SELECT t1.M5COOE M5COOE, t1.M5COTA1 M5COTA1, t1.M5FECALTA M5FECALTA, t1.M5USUALTA M5USUALTA FROM OETA1 t1  WHERE t1.M5COOE = ?   AND t1.M5COTA1 = ?   AND t1.M5FECALTA = ?   AND t1.M5USUALTA = ?  ";

		List<Oeta1> oeta1List = this.jdbcTemplate.query(query, this.rwMap,
				oeta1.getOoee().getOecodigo(), oeta1.getM5cota1(),
				oeta1.getM5fecalta(), oeta1.getM5usualta());
		return (Oeta1) DataAccessUtils.uniqueResult(oeta1List);
	}

	/**
	 * Removes a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Pagination
	 * @return
	 */
	public void remove(Oeta1 oeta1) {
		String query = "DELETE FROM OETA1 WHERE M5COOE=? AND M5COTA1 IN ('01','20','48') ";
		this.jdbcTemplate.update(query, oeta1.getOoee().getOecodigo()/*
																	 * , oeta1.
																	 * getM5cota1
																	 * (),
																	 * oeta1.
																	 * getM5fecalta
																	 * (),
																	 * oeta1.
																	 * getM5usualta
																	 * ()
																	 */);
	}

	/**
	 * Finds a List of rows in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Oeta1> findAll(Oeta1 oeta1, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M5COOE M5COOE,t1.M5COTA1 M5COTA1,t1.M5FECALTA M5FECALTA,t1.M5USUALTA M5USUALTA ");
		query.append("FROM OETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oeta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Oeta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Oeta1 oeta1) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM OETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oeta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Oeta1 table using like.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Oeta1> findAllLike(Oeta1 oeta1, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M5COOE M5COOE,t1.M5COTA1 M5COTA1,t1.M5FECALTA M5FECALTA,t1.M5USUALTA M5USUALTA ");
		query.append("FROM OETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(oeta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Oeta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Oeta1 table using like.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Oeta1 oeta1, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM OETA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(oeta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Oeta1 entity
	 * 
	 * @param oeta1
	 *            Oeta1 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Oeta1 oeta1) {

		StringBuilder where = new StringBuilder(
				Oeta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (oeta1 != null && oeta1.getOoee().getOecodigo() != null) {
			where.append(" AND t1.M5COOE = ?");
			params.add(oeta1.getOoee().getOecodigo());
		}
		if (oeta1 != null && oeta1.getM5cota1() != null) {
			where.append(" AND t1.M5COTA1 = ?");
			params.add(oeta1.getM5cota1());
		}
		if (oeta1 != null && oeta1.getM5fecalta() != null) {
			where.append(" AND t1.M5FECALTA = ?");
			params.add(oeta1.getM5fecalta());
		}
		if (oeta1 != null && oeta1.getM5usualta() != null) {
			where.append(" AND t1.M5USUALTA = ?");
			params.add(oeta1.getM5usualta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Oeta1 entity
	 * 
	 * @param oeta1
	 *            Oeta1 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Oeta1 oeta1, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Oeta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (oeta1 != null && oeta1.getOoee().getOecodigo() != null) {
			where.append(" AND UPPER(t1.OECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oeta1.getOoee().getOecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + oeta1.getOoee().getOecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OECODIGO IS NOT NULL");
		}
		if (oeta1 != null && oeta1.getM5cota1() != null) {
			where.append(" AND UPPER(t1.M5COTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oeta1.getM5cota1().toUpperCase() + "%");
			} else {
				params.add("%" + oeta1.getM5cota1().toUpperCase() + "%");
			}
			where.append(" AND t1.M5COTA1 IS NOT NULL");
		}
		if (oeta1 != null && oeta1.getM5fecalta() != null) {
			where.append(" AND t1.M5FECALTA = ?");
			params.add(oeta1.getM5fecalta());
		}
		if (oeta1 != null && oeta1.getM5usualta() != null) {
			where.append(" AND UPPER(t1.M5USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oeta1.getM5usualta().toUpperCase() + "%");
			} else {
				params.add("%" + oeta1.getM5usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.M5USUALTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
